---
id: DE-010
slug: policy-and-standard-management
name: Delta - Policy and Standard Management
created: '2025-11-03'
updated: '2025-11-03'
status: completed
kind: delta
aliases: []
tags: ["cli", "entities", "governance"]
relations: []
applies_to:
  specs:
  - PROD-003
  requirements:
  - PROD-003.FR-001
  - PROD-003.FR-002
  - PROD-003.FR-003
  - PROD-003.FR-004
  - PROD-003.FR-005
  - PROD-003.FR-006
  - PROD-003.FR-007
  - PROD-003.FR-008
  - PROD-003.NF-001
  - PROD-003.NF-002
---

# DE-010 – Policy and Standard Management

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-010
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - PROD-003
  collaborators: []
requirements:
  implements:
    - PROD-003.FR-001
    - PROD-003.FR-002
    - PROD-003.FR-003
    - PROD-003.FR-004
    - PROD-003.FR-005
    - PROD-003.FR-006
    - PROD-003.FR-007
    - PROD-003.FR-008
    - PROD-003.NF-001
    - PROD-003.NF-002
  updates: []
  verifies: []
phases:
  - IP-010.PHASE-01
  - IP-010.PHASE-02
  - IP-010.PHASE-03
```

## 1. Summary & Context
- **Product Spec(s)**: [PROD-003](../../../specify/product/PROD-003/PROD-003.md) – Policy and Standard Management
- **Technical Spec(s)**: SPEC-110 (CLI), SPEC-117 (Registry pattern), SPEC-111 (Formatters)
- **Implementation Plan**: [IP-010](./IP-010.md) – Draft, phased execution planned
- **Change Drivers**: Governance gap – teams lack dedicated artifacts for policies (hard rules) and standards (conventions/defaults)

## 2. Motivation
spec-driver currently supports ADRs for technical decisions but lacks dedicated artifacts for **policies** (hard rules like "code must have tests") and **standards** (conventions like "use Google Go style guide"). Teams currently:
- Conflate policies with decisions in ADRs
- Document governance in external wikis (breaking traceability)
- Rely on tribal knowledge (creating inconsistency)

This delta adds POL-XXX and STD-XXX artifacts with lifecycle management, bidirectional cross-references, and CLI support following proven ADR patterns.

## 3. Scope & Objectives
- **Primary Outcomes**:
  - Create policies (POL-XXX) with draft→required→deprecated lifecycle (FR-001, FR-002)
  - Create standards (STD-XXX) with draft→required|default→deprecated lifecycle (FR-003, FR-004)
  - CLI commands: `create policy/standard`, `list policies/standards`, `show policy/standard` (FR-005, FR-006)
  - Bidirectional cross-references: policies↔standards↔ADRs (FR-007, FR-008)
  - Registry integration: `specify/.registry/policies.yaml`, `specify/.registry/standards.yaml`
  - Consistent templates and UX patterns (NF-001, NF-002)
- **Operational Constraints**: Reuse existing patterns from SPEC-117 (decisions package) to minimize new code
- **Dependencies**: None – extends existing registry/CLI infrastructure

## 4. Out of Scope
- Automated policy enforcement via CI/CD (future integration point)
- Policy approval workflows (handled by git/PR processes)
- Compliance dashboards (registry enables this, but UI is out of scope)
- Access control/permissions (handled by git)

## 5. Approach Overview
- **System Touchpoints**:
  - `supekku/scripts/lib/policies/` (new package: models, registry, creation)
  - `supekku/scripts/lib/standards/` (new package: models, registry, creation)
  - `supekku/scripts/lib/formatters/` (new: policy_formatters.py, standard_formatters.py)
  - `supekku/cli/` (extend with policy/standard commands)
  - `specify/policies/`, `specify/standards/` (new directories for artifacts)
  - `specify/.registry/` (add policies.yaml, standards.yaml)

- **Key Changes**:
  - **Reuse ADR patterns**: Mirror DecisionRecord structure for PolicyRecord/StandardRecord (SPEC-117)
  - **Domain packages**: Create `policies/` and `standards/` following `decisions/` architecture
  - **CLI extensions**: Add subcommands to SPEC-110 CLI (create, list, show)
  - **Formatters**: Pure display functions following SPEC-111 patterns
  - **Templates**: Simplified governance templates (Statement, Rationale, Scope, Verification)
  - **Cross-references**: Extend ADR frontmatter with `policies:` and `standards:` fields

- **Migration / Rollout Notes**: No migration needed – net new feature; teams can incrementally create policies/standards

## 6. Verification Strategy
- **Requirements Coverage**:
  - FR-001/FR-003: E2E tests for policy/standard creation via CLI
  - FR-002/FR-004: Integration tests for lifecycle transitions and status validation
  - FR-005/FR-006: CLI integration tests for list/show commands with filtering
  - FR-007/FR-008: Cross-reference integrity tests (bidirectional backlinks)
  - NF-001: Template validation tests
  - NF-002: UX consistency review against ADR CLI patterns

- **Planned Artefacts**:
  - VT-PROD-003-001 through VT-PROD-003-009 (unit/integration/E2E tests)
  - VA-PROD-003-001 (UX review and template validation)

- **Acceptance Criteria**:
  - [ ] `spec-driver create policy "Test"` creates POL-001 with valid frontmatter/template
  - [ ] `spec-driver create standard "Test"` creates STD-001 with default status option
  - [ ] `spec-driver list policies --status required` filters correctly
  - [ ] `spec-driver show policy POL-001` displays full details including backlinks
  - [ ] ADR can reference policy via `policies: [POL-001]` frontmatter
  - [ ] Backlinks automatically maintained in registry
  - [ ] `just test` passes with all new tests
  - [ ] `just lint` and `just pylint` pass

## 7. Risks & Mitigations
- **Risk**: Policy/standard proliferation (too many governance artifacts)
  - *Likelihood*: Medium – *Impact*: Medium
  - *Mitigation*: Document creation criteria in templates; periodic review process
- **Risk**: Inconsistent enforcement (policies documented but not followed)
  - *Likelihood*: Medium – *Impact*: High
  - *Mitigation*: Link policies to verification artifacts; document CI integration path for future
- **Risk**: Confusion between policies vs standards
  - *Likelihood*: Low – *Impact*: Medium
  - *Mitigation*: Clear status naming (required vs default); comprehensive documentation
- **Risk**: Coupling to ADR implementation details
  - *Likelihood*: Low – *Impact*: Low
  - *Mitigation*: Extract shared utilities where duplication hurts (per architectural principle)

## 8. Follow-ups & Tracking
- **Future Deltas**:
  - Policy enforcement automation (pre-commit hooks, CI integration)
  - Compliance dashboard/reporting
  - Policy template library for common governance patterns
- **Backlog Items**: None yet – this is the foundational feature
- **Open Decisions / Questions**: None currently

## 9. Implementation Notes
- **Pattern Reuse**: Study `supekku/scripts/lib/decisions/` implementation as blueprint
- **Testing Strategy**: Follow ADR test coverage patterns (registry_test.py, creation_test.py, formatters_test.py)
- **Documentation**: Update README with policy/standard examples; CLI help text
- **Commands Reference**:
  - `uv run spec-driver create policy "Title"`
  - `uv run spec-driver create standard "Title"`
  - `uv run spec-driver list policies [--status STATUS]`
  - `uv run spec-driver show policy POL-001`