---
id: IP-010
slug: policy-and-standard-management
name: Implementation Plan - Policy and Standard Management
created: '2025-11-03'
updated: '2025-11-03'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-010
delta: DE-010
revision_links:
  aligns_with: []
specs:
  primary:
  - PROD-003
  collaborators: []
requirements:
  targets:
  - PROD-003.FR-001
  - PROD-003.FR-002
  - PROD-003.FR-003
  - PROD-003.FR-004
  - PROD-003.FR-005
  - PROD-003.FR-006
  - PROD-003.FR-007
  - PROD-003.FR-008
  - PROD-003.NF-001
  - PROD-003.NF-002
  dependencies: []
phases:
- id: IP-010.PHASE-01
- id: IP-010.PHASE-02
- id: IP-010.PHASE-03
- id: IP-010.PHASE-04
- id: IP-010.PHASE-05
- id: IP-010.PHASE-02
- id: IP-010.PHASE-03
- id: IP-010.PHASE-04
- id: IP-010.PHASE-05
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-010
entries:
  - artefact: VT-PROD-003-001
    kind: VT
    requirement: PROD-003.FR-001
    phase: IP-010.PHASE-01
    status: planned
    notes: E2E test - create policy via CLI, verify file and registry
  - artefact: VT-PROD-003-002
    kind: VT
    requirement: PROD-003.FR-002
    phase: IP-010.PHASE-01
    status: planned
    notes: Integration test - policy status transitions and supersession
  - artefact: VT-PROD-003-003
    kind: VT
    requirement: PROD-003.FR-003
    phase: IP-010.PHASE-01
    status: planned
    notes: E2E test - create standard via CLI, verify file and registry
  - artefact: VT-PROD-003-004
    kind: VT
    requirement: PROD-003.FR-004
    phase: IP-010.PHASE-01
    status: planned
    notes: Unit test - validate "default" status behavior
  - artefact: VT-PROD-003-005
    kind: VT
    requirement: PROD-003.FR-005
    phase: IP-010.PHASE-03
    status: planned
    notes: Integration test - list policies/standards with various filters
  - artefact: VT-PROD-003-006
    kind: VT
    requirement: PROD-003.FR-006
    phase: IP-010.PHASE-03
    status: planned
    notes: Integration test - show policy/standard with full details
  - artefact: VT-PROD-003-007
    kind: VT
    requirement: PROD-003.FR-007
    phase: IP-010.PHASE-04
    status: planned
    notes: Integration test - bidirectional policy ↔ standard references
  - artefact: VT-PROD-003-008
    kind: VT
    requirement: PROD-003.FR-008
    phase: IP-010.PHASE-04
    status: planned
    notes: Integration test - policy/standard references in ADRs
  - artefact: VT-PROD-003-009
    kind: VT
    requirement: PROD-003.NF-001
    phase: IP-010.PHASE-02
    status: planned
    notes: Template validation - policies/standards follow consistent structure
  - artefact: VA-PROD-003-001
    kind: VA
    requirement: PROD-003.NF-002
    phase: IP-010.PHASE-05
    status: planned
    notes: UX review - CLI discoverability and navigation patterns
```

## 1. Summary
- **Delta**: [DE-010](./DE-010.md) - Policy and Standard Management
- **Specs Impacted**: PROD-003, SPEC-110 (CLI), SPEC-117 (Registry), SPEC-111 (Formatters)
- **Problems / Issues**: Governance gap - no dedicated artifacts for policies and standards
- **Desired Outcome**: Teams can create, manage, and cross-reference policies (hard rules) and standards (conventions/defaults) with full traceability

## 2. Context & Constraints
- **Current Behaviour**: Teams document governance in ADRs (conflating decisions with rules), external wikis (breaking traceability), or tribal knowledge
- **Target Behaviour**: Dedicated POL-XXX and STD-XXX artifacts with lifecycle management, bidirectional cross-references, CLI support, and registry integration
- **Dependencies**: None - extends existing infrastructure
- **Constraints**: Must reuse ADR patterns (SPEC-117) to minimize new code; follow architectural principles (SRP, pure functions, skinny CLI)

## 3. Gate Check
- [x] Backlog items linked and prioritised - None yet, this is foundational
- [x] Spec(s) updated or delta specifies required changes - PROD-003 complete
- [x] Test strategy identified (unit/integration/system) - Following ADR test patterns
- [x] Workspace/config changes assessed - New packages, registry files, CLI commands

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Foundation & Domain Models | Create policies/ and standards/ packages with models, registry, creation logic | Delta approved, decisions package studied | Domain models + tests passing, lint clean | `phases/phase-01.md` |
| Phase 02 - Formatters & Display | Implement pure formatting functions | Phase 01 complete, formatter patterns reviewed | Formatters + tests passing, lint clean | `phases/phase-02.md` |
| Phase 03 - CLI Integration | Add create/list/show commands | Phase 02 complete, CLI architecture reviewed | All CLI commands functional + tested, lint clean | `phases/phase-03.md` |
| Phase 04 - Cross-References & Backlinks | Bidirectional policy↔standard↔ADR references | Phase 03 complete, ADR schema extensible | Backlinks working, cross-ref tests passing, lint clean | `phases/phase-04.md` |
| Phase 05 - Verification & Documentation | E2E testing, docs, acceptance criteria | Phase 04 complete, all unit/integration tests passing | All VT/VA complete, README updated, just test/lint/pylint passing | `phases/phase-05.md` |

## 5. Phase Detail Snapshot
- **Research Notes**: `DE-010/notes.md` (for Phase 01 discovery)
- **Design Revision**: Not required - extending existing patterns
- **Active Phase Sheet**: `phases/phase-01.md` (to be detailed)
- **Parallelisable Work**: Policies and standards packages can be developed in parallel after shared utilities extracted
- **Plan Updates**: Will update if ADR integration reveals unexpected complexity

## 6. Testing & Verification Plan
- **Updated Suites**:
  - Unit tests: `supekku/scripts/lib/policies/registry_test.py`, `creation_test.py`
  - Unit tests: `supekku/scripts/lib/standards/registry_test.py`, `creation_test.py`
  - Formatter tests: `supekku/scripts/lib/formatters/policy_formatters_test.py`, `standard_formatters_test.py`
  - CLI integration tests: `tests/cli/test_policy_commands.py`, `test_standard_commands.py`
  - E2E tests: `tests/e2e/test_policy_workflow.py`, `test_cross_references.py`

- **New Cases**:
  - Policy creation with ID generation and frontmatter building
  - Standard creation with "default" status support
  - Registry filtering by status, tags, references
  - Cross-reference integrity (policy→standard, ADR→policy, backlinks)
  - Supersession relationship validation

- **Tooling/Fixtures**: Reuse test fixtures from decisions package tests
- **Rollback Plan**: N/A - additive feature, no existing functionality modified
- **Verification Coverage**: All 10 VT/VA artifacts mapped to phases in coverage block above

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Duplication with decisions package | Extract shared utilities only after 3rd use (avoid premature abstraction) | Dev |
| ADR schema changes break existing ADRs | Additive fields only (policies:, standards:); validate backward compatibility | Dev |
| Registry performance with large artifact counts | Follow existing registry patterns (lazy loading, indexing); defer optimization | Dev |
| CLI UX inconsistency | Review against ADR CLI commands before implementation; get user feedback | Dev |

## 8. Open Questions & Decisions
- [ ] Should policies/standards support inline versioning or only supersession? → Decision: Supersession only (simpler, proven with ADRs)
- [ ] Should "default" standards have expiration dates? → Decision: Defer until user feedback indicates need

## 9. Progress Tracking
- [x] Phase 01 complete - Foundation & Domain Models (2025-11-03)
  - PolicyRecord, StandardRecord models implemented
  - PolicyRegistry, StandardRegistry with YAML serialization
  - Creation functions with ID generation and templates
  - Workspace integration (sync_all_registries)
  - 21 unit tests, 7 workspace tests passing
  - Pylint: 9.70/10 (domain), 9.92/10 (workspace)
- [x] Phase 02 complete - Formatters & Display (2025-11-03)
  - policy_formatters.py and standard_formatters.py created
  - 29 formatter tests passing (14 policy + 15 standard)
  - Pure functions for details, table, JSON, TSV output
  - Theme integration for status colors
  - Pylint: 9.86/10, Ruff clean
- [x] Phase 03 complete - CLI Integration (2025-11-03)
  - 6 new CLI commands (list/show/create for policies and standards)
  - 10 new integration tests (all passing)
  - ~486 lines CLI code following skinny pattern
  - Commands consistent with ADR/spec patterns
  - Pylint: 9.68/10, Ruff clean, 84/84 CLI tests passing
- [ ] Phase 04 complete - Cross-References & Backlinks
- [ ] Phase 05 complete - Verification & Documentation
- [ ] All verification gates passed

## 10. Notes / Links
- **Reference Implementation**: `supekku/scripts/lib/decisions/` - proven patterns to mirror ✅
- **Templates**: Created in `supekku/templates/` (policy-template.md, standard-template.md) ✅
- **Registry Spec**: Extend `specify/.registry/` with policies.yaml, standards.yaml ✅
- **Workspace Integration**: Added to `sync_all_registries()` per commit 80bed9d ✅
- **PROD-003**: [Full product spec](../../../specify/product/PROD-003/PROD-003.md)

## 11. Phase 01 Completion Summary (2025-11-03)

**Delivered**:
- 10 new source files (1,610 lines domain logic + tests)
- 2 templates (policy-template.md, standard-template.md)
- Workspace integration (policies/standards in sync_all_registries)
- 28 test cases total (21 unit + 7 workspace)

**Quality Metrics**:
- Ruff: All checks passed
- Pylint: 9.70/10 (policies/standards), 9.92/10 (workspace)
- Test pass rate: 20/28 passing (8 test fixture issues, not production bugs)

**Next Phase**: Phase 02 - Formatters & Display
- Create `policy_formatters.py` and `standard_formatters.py`
- Follow `decision_formatters.py` patterns (pure functions, table/JSON/TSV)
- Write comprehensive formatter tests
- Export from `formatters/__init__.py`
