---
id: DE-011
slug: cli-enhanced-filtering-and-self-documentation
name: Delta - CLI enhanced filtering and self-documentation
created: '2025-11-03'
updated: '2025-11-03'
status: in-progress
kind: delta
aliases: []
relations: []
tags: ["cli","docs"]
applies_to:
  specs:
  - SPEC-110
  requirements:
  - PROD-010.FR-004
  - PROD-010.FR-005
  - PROD-010.FR-006
  - PROD-010.FR-007
---

# DE-011 – CLI enhanced filtering and self-documentation

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-011
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - SPEC-110
  collaborators:
    - SPEC-120
requirements:
  implements:
    - PROD-010.FR-004
    - PROD-010.FR-005
    - PROD-010.FR-006
    - PROD-010.FR-007
  updates: []
  verifies: []
phases:
  - phase-01
  - phase-02
```

## 1. Summary & Context

- **Product Spec(s)**: [PROD-010](../../../specify/product/PROD-010/PROD-010.md) – CLI Agent UX improvements for consistent automation patterns
- **Technical Spec(s)**: [SPEC-110](../../../specify/tech/SPEC-110/SPEC-110.md) – supekku/cli implementation target
- **Implementation Plan**: [IP-011](./IP-011.md) – Two-phase implementation (filtering + self-documentation)
- **Change Drivers**:
  - UX Research Report (docs/ux-research-cli-2025-11-03.md) Priority 2-4 findings
  - DE-009 established foundation for consistent CLI patterns
  - Agent workflows require advanced filtering and introspection capabilities
  - Missing multi-value filters force complex regex workarounds
  - Lack of schema introspection requires external documentation lookups

## 2. Motivation

Building on DE-009's foundation of consistent JSON output and status filtering, agents now encounter three additional friction points that prevent fully autonomous workflows:

1. **Single-value filter limitation**: Agents must run multiple commands or use complex regex to filter by multiple statuses (e.g., "draft OR in-progress"). Current workaround: `list deltas --format json | jq '.items[] | select(.status == "draft" or .status == "in-progress")'` consumes 2x tokens and adds latency.

2. **Missing reverse relationship queries**: To find "which deltas implement SPEC-110.FR-001", agents must fetch all deltas as JSON and post-process with jq. No native CLI support for reverse traversal: `--implements`, `--verified-by`, `--informed-by`.

3. **Undiscoverable valid values**: Agents must guess or consult external docs for valid enum values (statuses, kinds, formats). No introspection: `schema show enums.delta.status` returns error. Leads to trial-and-error cycles consuming tokens.

4. **Sparse help text**: Command help lacks examples showing output format differences (table vs JSON vs TSV). Agents cannot learn appropriate format selection from help text alone.

**Target State**: Agents construct complex queries natively, discover valid values via CLI introspection, and learn optimal patterns from comprehensive help text. Zero external documentation required for common workflows.

**Supporting Evidence**:
- docs/ux-research-cli-2025-11-03.md Section 13: "Medium-Term" improvements (reverse queries, multi-value filters)
- docs/ux-research-cli-2025-11-03.md Section 12: Priority 4 (metadata introspection)
- PROD-010 Journeys 3-4: Schema introspection and reverse relationship queries

## 3. Scope & Objectives

**Primary Outcomes**:

1. **Multi-Value Filtering** (PROD-010.FR-004)
   - All list commands accept comma-separated filter values: `-s draft,in-progress`
   - Works for status, kind, and any categorical filter
   - Reduces token consumption by eliminating post-processing with jq
   - Consistent parsing across all commands (use common utility)

2. **Reverse Relationship Queries** (PROD-010.FR-005)
   - `list deltas --implements SPEC-110.FR-001` (deltas implementing requirement)
   - `list requirements --verified-by VT-CLI-*` (requirements with test pattern)
   - `list specs --informed-by ADR-001` (specs informed by decision)
   - Native CLI support eliminates grep/jq pipelines
   - Glob pattern support for verification artifacts (`VT-*`, `VA-*`, etc.)

3. **Schema Enum Introspection** (PROD-010.FR-006)
   - `schema show enums.delta.status` → `["draft", "in-progress", "completed", "deferred"]`
   - `schema show enums.spec.kind` → `["prod", "tech"]`
   - `schema show enums.requirement.kind` → `["FR", "NF"]`
   - `schema show enums.command.format` → `["table", "json", "tsv"]`
   - Agents discover valid values without documentation

4. **Enhanced Help Text** (PROD-010.FR-007)
   - All list command help includes "Output Formats" section with examples
   - Show command help documents JSON availability and schema
   - Filter syntax examples for multi-value and reverse queries
   - Common workflow examples in command help

**Operational Constraints**:
- **Backward Compatibility**: Existing single-value filters must continue to work
- **Timeline**: Two phases, estimated 3-4 days total
- **Risk Tolerance**: Medium - filtering logic changes require comprehensive tests
- **Performance**: Reverse relationship queries must complete in <2s for typical registries

**Dependencies**:
- DE-009 completed (provides consistent JSON foundation)
- No spec updates required (all capabilities implicit in current design)

## 4. Out of Scope

Explicitly deferred to future deltas:

- **Machine-readable mode** (PROD-010.FR-008, FR-009) → DE-012 (Priority 4)
  - `--machine-readable` flag (compact JSON, no colors)
  - Pagination for large result sets (`--limit`, `--offset`)
  - Rationale: Token optimization and pagination require separate design phase

- **Enhanced error messages** (PROD-010.FR-010) → DE-012 (Priority 5)
  - Actionable error suggestions with valid alternatives
  - Fuzzy matching for similar artifact IDs
  - Rationale: Error handling improvements independent of filtering/introspection

- **Non-Functional Requirements** (PROD-010.NF-001, NF-002)
  - Token usage measurement (requires baseline metrics)
  - Agent workflow validation (needs comprehensive test scenarios)
  - Rationale: Addressed incrementally across all Priority 1-3 deltas

- **Workflow-specific commands** (UX research Section 13)
  - `audit coverage`, `audit drift`, `find implements <REQ>`
  - Rationale: Higher-level commands require dedicated design

## 5. Approach Overview

**System Touchpoints**:
- `supekku/cli/list.py` - Add multi-value filter parsing and reverse relationship flags
- `supekku/cli/show.py` - Enhance help text with format examples
- `supekku/cli/schema.py` - Add enum introspection commands
- `supekku/scripts/lib/core/filters.py` - New module for shared filter utilities
- `supekku/scripts/lib/{decisions,changes,specs}/registry.py` - Add reverse query methods
- `supekku/cli/common.py` - Shared filter option types
- Test files: Comprehensive coverage for filtering and introspection

**Key Changes**:

**Phase 1: Enhanced Filtering** (FR-004, FR-005)

1. **Multi-value filter support** (FR-004)
   - Create `core/filters.py` module with `parse_multi_value_filter()` utility
   - Update all list commands to parse comma-separated values for filters
   - Test: `-s draft,in-progress` returns items matching either status
   - Maintain backward compatibility: single values continue to work
   - Example: `spec-driver list deltas -s draft,in-progress --json`

2. **Reverse relationship queries** (FR-005)
   - Add `--implements`, `--verified-by`, `--informed-by` flags to list commands
   - Implement registry methods: `find_by_implements()`, `find_by_verified_by()`
   - Support glob patterns for artifact matching: `--verified-by "VT-CLI-*"`
   - Filter in registry layer (not post-process) for performance
   - Examples:
     - `spec-driver list deltas --implements SPEC-110.FR-001 --json`
     - `spec-driver list requirements --verified-by VT-CLI-001 --json`

**Phase 2: Self-Documentation** (FR-006, FR-007)

3. **Schema enum introspection** (FR-006)
   - Extend `schema` command with `show enums.<artifact>.<field>` subcommand
   - Implement enum extractors for each artifact type (delta, spec, requirement, etc.)
   - Return JSON array of valid values
   - Cover key fields: status, kind, format
   - Example: `spec-driver schema show enums.delta.status --json`

4. **Enhanced help text** (FR-007)
   - Add "Output Formats" section to all list command docstrings
   - Include table/JSON/TSV examples showing field differences
   - Document filter syntax with multi-value and reverse query examples
   - Show typical workflows in command help
   - Update show command help to document JSON availability

**Migration / Rollout Notes**:
- No migration required - purely additive changes
- Existing single-value filters work unchanged
- New multi-value syntax opt-in (backward compatible)
- No registry updates or data migration needed

## 6. Verification Strategy

**Requirements Coverage**:

| Requirement | Verification Artifact | Approach |
|-------------|----------------------|----------|
| PROD-010.FR-004 | VT-PROD010-FILTER-002 | Unit tests: multi-value status filter (`-s draft,in-progress`) on all list commands returns union of matching items |
| PROD-010.FR-005 | VT-PROD010-FILTER-003 | Unit tests: reverse relationship queries (`--implements`, `--verified-by`, `--informed-by`) return correct filtered results with glob pattern support |
| PROD-010.FR-006 | VT-PROD010-SCHEMA-001 | Unit tests: `schema show enums.<artifact>.<field>` returns valid JSON array of enum values for all artifact types |
| PROD-010.FR-007 | VT-PROD010-SCHEMA-002 | Manual validation: all list/show command help text includes output format examples and filter syntax documentation |

**Planned Artefacts**:
- **VT-CLI-MULTI-FILTER**: Test suite for multi-value filter parsing and execution
- **VT-CLI-REVERSE-QUERY**: Test suite for reverse relationship queries with glob support
- **VT-CLI-ENUM-INTROSPECTION**: Test suite for schema enum extraction
- **VT-CLI-HELP-EXAMPLES**: Validation suite for help text comprehensiveness

**Acceptance Criteria**:
- [ ] All list commands support comma-separated multi-value filters (`-s value1,value2`)
- [ ] `list deltas --implements <REQ-ID>` returns correct filtered results
- [ ] `list requirements --verified-by <ARTIFACT-PATTERN>` supports glob patterns
- [ ] `schema show enums.delta.status` returns valid JSON array
- [ ] Help text for all list commands includes "Output Formats" section with examples
- [ ] All unit tests passing (`just test`)
- [ ] Both linters passing (`just lint`, `just pylint`)
- [ ] Backward compatibility: existing single-value filters unchanged
- [ ] Performance: reverse queries complete in <2s for typical registries

## 7. Risks & Mitigations

| Risk | Likelihood | Impact | Mitigation |
|------|-----------|--------|------------|
| **Multi-value filter parsing breaks existing regex filters** | Medium | High | Comprehensive backward compatibility tests; escape comma in regex if needed |
| **Reverse relationship queries too slow on large registries** | Medium | Medium | Index relationships in registry; implement early filtering; performance tests |
| **Enum extraction misses valid values** | Low | Medium | Extract enums from schema definitions, not hardcoded lists; comprehensive validation |
| **Help text becomes too verbose** | Low | Low | Use collapsible sections; link to external docs for advanced usage |
| **Glob pattern parsing conflicts with shell expansion** | Medium | Low | Quote patterns in examples; document shell escaping requirements |

## 8. Follow-ups & Tracking

**Future Phases / Deltas**:
- **DE-012**: Machine-readable mode (FR-008, FR-009) + enhanced errors (FR-010) - Priority 4-5
- **Future**: Workflow commands (`audit coverage`, `find implements`) - Long-term

**Backlog Items**:
- Track implementation progress in [IP-011](./IP-011.md)
- Update PROD-010 verification coverage blocks as tests implemented
- Consider creating ISSUE for filter performance optimization if queries exceed 2s threshold

**Open Decisions / Questions**:
- **Q1**: Should multi-value filters use comma (`,`) or pipe (`|`) as separator? → **Decision**: Comma for consistency with common CLI tools (grep, etc.)
- **Q2**: Should enum introspection return all artifact fields or just key fields? → **Decision**: Start with key fields (status, kind, format); expand based on usage
- **Q3**: Should help text examples be inline or reference external docs? → **Decision**: Inline for common cases, external docs for advanced patterns

## 9. Implementation Notes

**Implementation Status**: ⏳ **DRAFT** - Planning phase

**Estimated Effort**:
- Phase 1 (Enhanced Filtering): 2 days
- Phase 2 (Self-Documentation): 1-2 days
- Total: 3-4 days

**Reference Documentation**:
- UX Research Report: `docs/ux-research-cli-2025-11-03.md`
- PROD-010: `specify/product/PROD-010/PROD-010.md` (FR-004 to FR-007)
- SPEC-110: `specify/tech/SPEC-110/SPEC-110.md`
- SPEC-120: `specify/tech/SPEC-120/SPEC-120.md` (formatters)
- DE-009: Foundation delta for consistent CLI patterns
- CLAUDE.md: Skinny CLI patterns, formatter separation

**Development Approach**:
- TDD methodology (write tests first)
- Skinny CLI pattern (logic in domain/core, orchestration in CLI)
- Pure functions for filter utilities
- Comprehensive test coverage (aim for >90%)