---
id: IP-011
slug: cli-enhanced-filtering-and-self-documentation
name: Implementation Plan - CLI enhanced filtering and self-documentation
created: '2025-11-03'
updated: '2025-11-03'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-011
delta: DE-011
revision_links:
  aligns_with: []
specs:
  primary:
    - SPEC-110
  collaborators:
    - SPEC-120
requirements:
  targets:
    - PROD-010.FR-004
    - PROD-010.FR-005
    - PROD-010.FR-006
    - PROD-010.FR-007
  dependencies: []
phases:
  - id: IP-011.PHASE-01
  - id: IP-011.PHASE-02
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-011
entries:
  - artefact: VT-PROD010-FILTER-002
    kind: VT
    requirement: PROD-010.FR-004
    phase: IP-011.PHASE-01
    status: planned
    notes: Unit tests verify multi-value status filter (-s draft,in-progress) on all list commands returns union of matching items. Backward compatibility with single-value filters verified.
  - artefact: VT-PROD010-FILTER-003
    kind: VT
    requirement: PROD-010.FR-005
    phase: IP-011.PHASE-01
    status: planned
    notes: Unit tests verify reverse relationship queries (--implements, --verified-by, --informed-by) return correct filtered results with glob pattern support (VT-*, VA-*, etc.).
  - artefact: VT-PROD010-SCHEMA-001
    kind: VT
    requirement: PROD-010.FR-006
    phase: IP-011.PHASE-02
    status: planned
    notes: Unit tests verify schema show enums.<artifact>.<field> returns valid JSON array of enum values for all artifact types (delta, spec, requirement, etc.).
  - artefact: VT-PROD010-SCHEMA-002
    kind: VH
    requirement: PROD-010.FR-007
    phase: IP-011.PHASE-02
    status: planned
    notes: Manual validation confirms all list/show command help text includes "Output Formats" section with examples and filter syntax documentation.
```

## Implementation Summary

**Status**: ⏳ **DRAFT** - Planning phase

**Delta**: [DE-011](./DE-011.md) - CLI enhanced filtering and self-documentation

**Specs Impacted**:
- Primary: [SPEC-110](../../specify/tech/SPEC-110/SPEC-110.md) - supekku/cli
- Collaborators: [SPEC-120](../../specify/tech/SPEC-120/SPEC-120.md) - formatters
- Requirements: [PROD-010](../../specify/product/PROD-010/PROD-010.md) (FR-004 to FR-007)

**Desired Outcome**: Extend CLI with multi-value filtering, reverse relationship queries, enum introspection, and enhanced help text to enable fully autonomous agent workflows without external documentation.

**Implementation Approach**: Two-phase TDD implementation. Phase 1 focuses on enhanced filtering capabilities (multi-value and reverse queries). Phase 2 adds self-documentation features (enum introspection and help text enhancements). Estimated 3-4 days total.

**Key Deliverables**:
- Phase 1: `supekku/scripts/lib/core/filters.py` (new module), enhanced list commands with multi-value filters and reverse queries
- Phase 2: Extended schema commands with enum introspection, comprehensive help text updates

**Verification**: All 4 requirements verified via unit tests (VT) and manual help text validation (VH).

**References**:
- UX Research: `docs/ux-research-cli-2025-11-03.md` (Priority 2-4)
- Delta: [DE-011.md](./DE-011.md) (comprehensive motivation and approach)
- Phase Sheets: `phases/phase-01.md`, `phases/phase-02.md` (detailed execution plans)
- Foundation: DE-009 (consistent JSON and status filtering baseline)
