---
id: DE-012
slug: restore-entry-exit-criteria-to-ip-schema
name: Delta - Restore Entry/Exit Criteria to IP Schema
created: '2025-11-03'
updated: '2025-11-03'
status: completed
kind: delta
aliases: []
relations: []
tags: ["schema","implementation"]
applies_to:
  specs:
  - PROD-006
  - SPEC-110
  - SPEC-114
  requirements: []
---

# DE-012 – Restore Entry/Exit Criteria to IP Schema

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-012
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - PROD-006
    - SPEC-110
    - SPEC-114
  collaborators: []
requirements:
  implements: []
  updates: []
  verifies: []
phases: []
```

## 1. Summary & Context
- **Product Spec(s)**: PROD-006 – Phase Management (covers phase creation and metadata management)
- **Technical Spec(s)**: SPEC-110 (CLI), SPEC-114 (metadata/blocks)
- **Implementation Plan**: [IP-012](./IP-012.md) – draft, ready for planning
- **Change Drivers**: ISSUE-013 – Regression from DE-004 Phase 06 schema simplification removed critical planning metadata

## 2. Motivation
During DE-004 Phase 06 (commit 6f69db8), entry/exit criteria were removed from the `plan.overview@v1` phases array to eliminate perceived duplication with `phase.overview` blocks. The phases array was simplified to ID-only format: `{id: "IP-XXX.PHASE-NN"}`.

**This was a mistake** because:
- **IP Planning Contract**: Entry/exit criteria in the IP define quality gates upfront, before phase sheets exist. They're part of the planning contract between planner and implementer.
- **Single Source of Truth**: The IP should remain the authoritative source for planned gates, with phase sheets potentially diverging during execution.
- **Drift Detection**: Without IP baseline, we can't detect when phase criteria have drifted due to scope changes.

**Current pain**:
- Planning is incomplete without upfront gate definitions
- No baseline to compare against when phases evolve
- Manual duplication in IP markdown tables (Section 4) with no validation

**Target state**:
- Entry/exit criteria restored to `plan.overview@v1` schema (optional for backward compat)
- `create phase` copies criteria from IP to phase sheets
- Drift detection warns when phase criteria diverge from IP baseline

## 3. Scope & Objectives
- **Primary Outcomes**:
  - FR-013.001: IP schema restored with name, objective, entrance_criteria, exit_criteria fields
  - FR-013.002: `create phase` copies criteria from IP to phase.overview and phase.tracking
  - NF-013.001: Backward compatibility maintained for existing ID-only IPs
  - FR-013.003 (deferred): Drift detection warns when phase criteria differ from IP baseline
- **Operational Constraints**: Solo developer, must maintain backward compatibility, no breaking changes
- **Dependencies**: None – builds on existing DE-004 phase management infrastructure

## 4. Out of Scope
- **Drift Detection**: FR-013.003 deferred to future delta (can be implemented independently)
- **Automatic Migration**: Existing IPs remain ID-only format; migration is manual/on-demand
- **Phase Sheet Enforcement**: Phase sheets may still have criteria in markdown only (phase.tracking optional)
- **Template Changes**: Won't modify phase template beyond ensuring it supports copied criteria

## 5. Approach Overview
- **System Touchpoints**:
  - `supekku/scripts/lib/blocks/plan_metadata.py` – PLAN_OVERVIEW_METADATA schema
  - `supekku/scripts/lib/blocks/phase_metadata.py` – PHASE_OVERVIEW_METADATA (already has fields)
  - `supekku/scripts/lib/changes/creation.py` – create_phase() function
  - `supekku/cli/create.py` – phase creation command

- **Key Changes**:
  1. **Schema Restoration**: Add `name`, `objective`, `entrance_criteria`, `exit_criteria` back to PLAN_OVERVIEW_METADATA phases items (all optional)
  2. **Phase Creation Enhancement**: Update `create_phase()` to read criteria from IP's plan.overview and populate phase.overview + phase.tracking
  3. **Graceful Fallback**: Handle both full metadata and ID-only formats during phase creation
  4. **Template Guidance**: Update plan.md template Section 4 to show full metadata in phase table

- **Migration / Rollout Notes**:
  - No migration required – fields are optional
  - New IPs will use full metadata format
  - Existing IPs continue working with ID-only format
  - Gradual enhancement when IPs are revised

## 6. Verification Strategy
- **Requirements Coverage**:
  - FR-013.001: VT-SCHEMA-013-001 (schema validation tests)
  - FR-013.002: VT-CREATE-013-002 (create_phase with criteria tests)
  - NF-013.001: VT-COMPAT-013-001 (backward compatibility regression tests)

- **Planned Artefacts**:
  - VT-SCHEMA-013-001: Schema metadata tests in plan_metadata_test.py
  - VT-CREATE-013-002: Phase creation tests in creation_test.py
  - VT-COMPAT-013-001: Backward compatibility tests (existing test suite + specific ID-only tests)
  - VA-MANUAL-013-001: Manual test creating IP with full metadata, then creating phase

- **Acceptance Criteria**:
  - [ ] All 1200+ existing tests pass (backward compatibility)
  - [ ] Schema changes generate valid JSON Schema
  - [ ] `create phase` with full metadata IP populates criteria correctly
  - [ ] `create phase` with ID-only IP works without errors (graceful fallback)
  - [ ] Both ruff and pylint pass
  - [ ] Manual verification: Create IP-012 phase with criteria copied from IP

## 7. Risks & Mitigations
- **Risk**: Schema changes break existing IPs – *Likelihood*: low – *Impact*: high – *Mitigation*: Make all new fields optional, run full test suite, test with existing IPs
- **Risk**: Phase creation logic complexity increases – *Likelihood*: medium – *Impact*: low – *Mitigation*: Follow existing patterns from DE-004, comprehensive tests
- **Risk**: Inconsistent criteria between IP and phase sheets – *Likelihood*: medium – *Impact*: medium – *Mitigation*: Document that drift is expected and normal (future drift detection will help)
- **Risk**: Template confusion about where criteria should live – *Likelihood*: low – *Impact*: low – *Mitigation*: Update template guidance to explain dual-copy pattern

## 8. Follow-ups & Tracking
- **Future Phases / Deltas**:
  - FR-013.003 (Drift Detection) – separate delta when prioritized
  - Consider automatic IP migration tool if manual migration proves tedious

- **Backlog Items**: ISSUE-013 – drives this delta

- **Open Decisions / Questions**:
  - Should we auto-migrate existing IPs or leave them as-is? Decision: Leave as-is, migrate on-demand
  - Should phase.tracking criteria be required or optional? Decision: Optional (maintains current behavior)

## 9. Implementation Notes
- Reference DE-004 implementation for phase creation patterns
- Existing phase.overview schema already has entrance_criteria/exit_criteria fields
- phase.tracking schema already has entrance_criteria/exit_criteria arrays
- Key is reading from IP during create_phase and populating both destinations
- Test with IP-004 (full metadata before Phase 06) and IP-012 (new format)
