---
id: IP-012
slug: restore-entry-exit-criteria-to-ip-schema
name: Implementation Plan - Restore Entry/Exit Criteria to IP Schema
created: '2025-11-03'
updated: '2025-11-03'
status: completed
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-012
delta: DE-012
revision_links:
  aligns_with: []
specs:
  primary:
  - PROD-006
  - SPEC-110
  - SPEC-114
  collaborators: []
requirements:
  targets:
  - ISSUE-013.FR-013.001
  - ISSUE-013.FR-013.002
  - ISSUE-013.NF-013.001
  dependencies: []
phases:
- id: IP-012.PHASE-01
  name: Schema Restoration & Phase Creation Enhancement
  objective: Restore entry/exit criteria fields to plan.overview schema and update
    create_phase to copy criteria from IP to phase sheets
  entrance_criteria:
  - DE-012 delta reviewed and accepted
  - ISSUE-013 requirements understood
  - DE-004 phase creation code reviewed for patterns
  exit_criteria:
  - plan_metadata.py schema updated with optional fields
  - create_phase() copies criteria to phase.overview and phase.tracking
  - VT-SCHEMA-013-001 passing (schema validation tests)
  - VT-CREATE-013-002 passing (phase creation tests)
  - VT-COMPAT-013-001 passing (backward compatibility tests)
  - All existing tests pass (1200+ tests)
  - Both ruff and pylint clean
- id: IP-012.PHASE-02
- id: IP-012.PHASE-01
- id: IP-012.PHASE-01
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-012
entries:
  - artefact: VT-SCHEMA-013-001
    kind: VT
    requirement: ISSUE-013.FR-013.001
    phase: IP-012.PHASE-01
    status: verified
    notes: Schema validation tests in plan_metadata_test.py (9 tests passing)

  - artefact: VT-CREATE-013-002
    kind: VT
    requirement: ISSUE-013.FR-013.002
    phase: IP-012.PHASE-01
    status: verified
    notes: Phase creation with criteria copy tests in creation_test.py (4 tests passing)

  - artefact: VT-COMPAT-013-001
    kind: VT
    requirement: ISSUE-013.NF-013.001
    phase: IP-012.PHASE-01
    status: verified
    notes: Backward compatibility verified - all 1304 tests passing
```

## 1. Summary
- **Delta**: DE-012 - Restore Entry/Exit Criteria to IP Schema
- **Specs Impacted**: PROD-006 (Phase Management), SPEC-110 (CLI), SPEC-114 (metadata/blocks)
- **Problems / Issues**: ISSUE-013 – Regression from DE-004 Phase 06 removed critical planning metadata
- **Desired Outcome**: Entry/exit criteria restored to IP schema, create_phase copies criteria to phase sheets, backward compatibility maintained

## 2. Context & Constraints
- **Current Behaviour**: plan.overview phases array contains only `{id: "IP-XXX.PHASE-NN"}`, no metadata
- **Target Behaviour**: Phases array supports optional `name`, `objective`, `entrance_criteria`, `exit_criteria` fields; create_phase copies to phase.overview and phase.tracking
- **Dependencies**: None – builds on DE-004 infrastructure
- **Constraints**: Must maintain backward compatibility with existing ID-only IPs; solo developer; no breaking changes

## 3. Gate Check
- [x] Backlog items linked and prioritised – ISSUE-013 drives this delta
- [x] Spec(s) updated or delta specifies required changes – Specs identified (PROD-006, SPEC-110, SPEC-114)
- [x] Test strategy identified – VT-SCHEMA-013-001, VT-CREATE-013-002, VT-COMPAT-013-001
- [x] Workspace/config changes assessed – No config changes needed, schema metadata only

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 01 - Schema Restoration & Enhancement | Restore criteria fields to plan.overview, update create_phase to copy criteria | DE-012 accepted, ISSUE-013 understood, DE-004 code reviewed | Schema updated, create_phase enhanced, all tests passing | `phases/phase-01.md` |

*Single-phase implementation: schema changes + phase creation enhancement are tightly coupled and can be implemented together.*

## 5. Phase Detail Snapshot
- **Research Notes**: `notes.md` – Track design decisions and discoveries
- **Design Revision**: None needed (schema restoration + existing phase creation pattern)
- **Active Phase Sheet**: `phases/phase-01.md` – created by template, ready for execution
- **Parallelisable Work**: None – schema and creation logic must be done sequentially
- **Plan Updates**: Update if scope changes (e.g., drift detection moved into scope)

## 6. Testing & Verification Plan

**Phase 01 - Schema Restoration & Phase Creation Enhancement**:

- **VT-SCHEMA-013-001**: Schema Validation Tests
  - Test: plan.overview with full phase metadata validates correctly
  - Test: plan.overview with ID-only phases validates correctly (backward compat)
  - Test: optional fields can be omitted
  - Test: entrance_criteria/exit_criteria must be arrays of strings
  - Test: JSON Schema generation includes new fields
  - Location: `supekku/scripts/lib/blocks/plan_metadata_test.py`

- **VT-CREATE-013-002**: Phase Creation with Criteria Copy
  - Test: create_phase with full metadata IP copies criteria to phase.overview
  - Test: create_phase with full metadata IP copies criteria to phase.tracking
  - Test: create_phase with ID-only IP works without errors (graceful fallback)
  - Test: create_phase with partial metadata (e.g., only entrance_criteria) handles correctly
  - Test: create_phase with empty criteria arrays handles correctly
  - Location: `supekku/scripts/lib/changes/creation_test.py`

- **VT-COMPAT-013-001**: Backward Compatibility
  - Test: All existing IPs parse correctly with ID-only format
  - Test: show delta works with both full and ID-only formats
  - Test: Existing test suite passes (1200+ tests)
  - Test: Mixed format (some phases full, some ID-only) handles correctly
  - Location: Existing test suite + new regression tests

**Rollback Plan**:
- Simple: git revert to pre-implementation commit
- No data migration needed – schema changes are additive and optional

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Schema changes break existing IPs | Make all new fields optional, test with existing IPs, run full suite | Dev |
| Phase creation logic gets too complex | Follow DE-004 patterns, use helper functions, comprehensive tests | Dev |
| Criteria get out of sync between IP and phase | Document as expected behavior, note future drift detection | Dev |
| Template confusion about dual-copy pattern | Update template guidance, add comments in code | Dev |

## 8. Open Questions & Decisions
- [x] Should we auto-migrate existing IPs? → No, leave as-is, migrate on-demand
- [x] Should phase.tracking criteria be required? → No, optional (maintains current behavior)
- [x] Single phase or multiple? → Single phase (changes are tightly coupled)
- [ ] Should we validate criteria syntax (e.g., detect requirement IDs)? → Defer to future (out of scope)

## 9. Progress Tracking
- [ ] Phase 01 complete
- [ ] Verification gates passed

## 10. Notes / Links
- Reference: ISSUE-013 for detailed requirements and rationale
- Reference: DE-004 for phase creation patterns
- Reference: commit 6f69db8 for what was removed
- Test with: IP-004 (had full metadata before Phase 06), IP-012 (new format being created)
