---
id: DR-013
slug: add-design-artefacts-to-delta-package
name: Design Revision - add design artefacts to delta package
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: design_revision
aliases: []
owners: []
summary: Scaffold design revision artefacts for every delta to capture architecture intent alongside change planning.
relations:
  - type: implements
    target: DE-013
delta_ref: DE-013
source_context: []
code_impacts:
  - path: supekku/scripts/lib/changes/creation.py
    current_state: Delta creation only produced delta, plan, phase, and notes files.
    target_state: Delta creation also emits a design revision file with compliant frontmatter and template-rendered body.
  - path: .spec-driver/templates/design_revision.md
    current_state: No user template existed for design revision artefacts.
    target_state: Template guides authors through executive summary, problem, code impacts, verification, decisions, and open questions.
  - path: supekku/templates/design_revision.md
    current_state: Packaged templates lacked design revision support.
    target_state: Packaged template mirrors user template to keep scaffolding consistent across installations.
verification_alignment: []
design_decisions: []
open_questions: []
---

# DR-013 – add design artefacts to delta package

## 1. Executive Summary
- **Delta**: [DE-013](./DE-013.md)
- **Status**: draft (update when approved)
- **Owners / Team**: Agents / architecture automation
- **Last Updated**: 2025-11-04
- **Synopsis**: Ensure every delta bundle includes a design revision capturing architectural intent, code impacts, and verification alignment.

## 2. Problem & Constraints
- **Current Behaviour**: `create delta` generated only the delta, implementation plan, initial phase, and notes; technical intent lived in ad-hoc notes or PR descriptions.
- **Drivers / Inputs**: Glossary definition for Design Revision (DR) expects architecture patch coverage; schema `frontmatter.design_revision` already defined but unused.
- **Constraints / Guardrails**: Maintain separation of concerns (templates vs domain vs CLI); keep CLI orchestration skinny; avoid premature abstraction beyond immediate need.
- **Out of Scope**: Design revision registry tooling, rendering/formatter updates, or retrofitting existing deltas beyond DE-013.

## 3. Architecture Intent
- **Target Outcomes**:
  - Auto-generate a `DR-XXX.md` file with compliant frontmatter for every new delta.
  - Provide a reusable markdown template that prompts authors to capture architecture decisions, code impacts, and verification plans.
- **Guiding Principles**: Pure template files for presentation; creation logic limited to scaffolding and metadata; reuse existing slug/id conventions.
- **State Transitions / Lifecycle Impact**: Adds new artefact to delta directories; no change to broader lifecycle states beyond richer documentation.

## 4. Code Impact Summary
| Path | Current State | Target State |
| --- | --- | --- |
| `supekku/scripts/lib/changes/creation.py` | Extras limited to plan, phase, notes | Adds design revision identifier, frontmatter, and template-rendered body to extras |
| `.spec-driver/templates/design_revision.md` | Missing | New template guiding authors through summary, problem, intent, impacts, verification, decisions, questions |
| `supekku/templates/design_revision.md` | Missing | Packaged copy mirrors user template for consistent scaffolding |
| `supekku/scripts/lib/changes/creation_test.py` | No assertions about design revision | Tests verify design revision creation (with and without plan) and relations |

> Capture each affected component with concise before/after statements. Align this table with the `code_impacts` frontmatter entries.

## 5. Verification Alignment
| Verification | Impact | Notes |
| --- | --- | --- |
| VT-Create-Delta (unit) | regression | Existing delta creation behaviours remain and still pass |
| New delta creation tests | new | Added assertions covering design revision frontmatter + allow-missing-plan scenario |

> Keep the table in sync with `verification_alignment` metadata so tooling can audit impacts.

## 6. Supporting Context
- **Research**: `uv run spec-driver schema show frontmatter.design_revision` — confirmed required/optional metadata fields.
- **Glossary**: Design Revision definition emphasises current vs target behaviour and test impacts.
- **Related Deltas / Specs**: SPEC-116 (frontmatter metadata); SPEC-110 (CLI scaffolding expectations).

## 7. Design Decisions & Trade-offs
- Reused delta ID numbering (`DE-013` → `DR-013`) for parity and discoverability.
- Stored template in both `.spec-driver/templates/` and packaged `supekku/templates/` to avoid drift across installations.
- Populated frontmatter arrays with empty lists by default to encourage structured updates while keeping documents valid.

## 8. Open Questions
- [ ] Confirm whether future tooling should auto-populate `verification_alignment` entries once coverage artefacts are known – Owner: @david – due 2025-11-08
- [ ] Evaluate if designers prefer additional relations (e.g., `relates_to` spec IDs) by default – Owner: @agents – due 2025-11-08

## 9. Rollout & Operational Notes
- **Migration / Backfill**: Existing deltas require manual design revision files; consider backfill script once pattern proven.
- **Observability / Alerts**: No runtime telemetry; rely on tests to signal regressions.
- **Recovery / Rollback**: Revert template + creation changes; delta creation reverts to previous behaviour (design revision not generated).

## 10. References & Links
- Schema catalogue: `uv run spec-driver schema list`
- Frontmatter documentation: `supekku/about/frontmatter-schema.md`
- Implementation plan: [IP-013](./IP-013.md)

> Keep this document as the living design record for the delta. Update frontmatter fields (`owners`, `code_impacts`, `verification_alignment`, `design_decisions`, `open_questions`) as the design evolves.
