---
id: IP-013
slug: add-design-artefacts-to-delta-package
name: Implementation Plan - add design artefacts to delta package
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-013
delta: DE-013
revision_links:
  aligns_with: []
specs:
  primary: []
  collaborators: []
requirements:
  targets: []
  dependencies: []
phases:
  - id: IP-013.PHASE-01
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-013
entries:
  - artefact: VT-XXX
    kind: VT
    requirement: SPEC-YYY.FR-001
    phase: IP-013.PHASE-01
    status: planned
    notes: Link to evidence (test run, audit, validation artefact).
```

## 1. Summary
- **Delta**: DE-013 – add design artefacts to delta package
- **Specs Impacted**: SPEC-116 (frontmatter metadata automation), SPEC-110 (CLI scaffolding)
- **Problems / Issues**: BACKLOG item pending (log automation gap once scope confirmed)
- **Desired Outcome**: Scaffold design revision artefacts with compliant metadata alongside every new delta.

## 2. Context & Constraints
- **Current Behaviour**: `create delta` emits the delta, implementation plan, initial phase, and notes only.
- **Target Behaviour**: Automatically produce a design revision document referencing the delta and schema requirements.
- **Dependencies**: `frontmatter.design_revision` schema already defined; future registry tooling can build on this.
- **Constraints**: Preserve SRP (template vs CLI vs domain), avoid premature abstractions, CLI remains thin.

## 3. Gate Check
- [ ] Backlog items linked and prioritised
- [x] Spec(s) updated or delta specifies required changes (SPEC-116/SPEC-110 definitions drive scope)
- [x] Test strategy identified (unit coverage for creation utilities + CLI smoke)
- [x] Workspace/config changes assessed (template duplication + write paths only)


> Tip: Plan phases up front, then create the phase sheet for the current phase only. Update later phases when you are ready to execute them.

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 1 - Research & Planning | Confirm schema obligations, outline template + automation changes | Delta accepted, glossary/schema reviewed | Plan updated with agreed template + creation approach | `phases/phase-01.md` |
| Phase 2 - Implementation | Deliver template, creation scaffolding, and tests/docs | Phase 1 complete, open questions resolved | New artefact generated, tests/docs updated, lint clean | `phases/phase-02.md` *(pending)* |
| Phase 3 - Verification & Adoption | Validate end-to-end flow, document usage guidance | Phase 2 complete, design revision authored | `just test` + linters pass, design revision example committed | `phases/phase-03.md` *(pending)* |

*Adjust/add phases as needed; every phase must have clear gates. Phase sheets are authored one at a time using `supekku/templates/phase-sheet-template.md`.*

## 5. Phase Detail Snapshot
- **Research Notes**: `change/deltas/DE-013-add-design-artefacts-to-delta-package/notes.md`
- **Design Revision**: `change/deltas/DE-013-add-design-artefacts-to-delta-package/DR-013.md`
- **Active Phase Sheet**: `change/deltas/DE-013-add-design-artefacts-to-delta-package/phases/phase-01.md`
- **Parallelisable Work**: Template authoring + schema review can progress alongside plan updates
- **Plan Updates**: Revisit after Phase 1 to confirm template adoption and adjust testing scope

## 6. Testing & Verification Plan
- **Updated Suites**: `supekku/scripts/lib/changes/creation_test.py`, `supekku/cli/test_cli.py`
- **New Cases**: Ensure design revision file scaffolds with correct metadata, CLI emits path, template fallback preserved.
- **Tooling/Fixtures**: Extend temporary repo fixtures in tests to expect design revision files.
- **Rollback Plan**: Revert template + creation logic; delta creation continues to work without design revision extras.
- **Verification Coverage**: Update `supekku:verification.coverage@v1` entries when coverage artefacts identified.

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Template drift between user copy and package copy | Keep templates identical; add regression in tests | dev |
| Frontmatter regression silently introduced | Reuse schema validator + add creation test assertions | dev |

## 8. Open Questions & Decisions
- [ ] Confirm final naming convention (`DR-013.md` vs nested directory) before code changes
- [ ] Decide whether to auto-add reciprocal relations beyond `implements`

## 9. Progress Tracking
- [ ] Phase 1 complete
- [ ] Phase 2 complete
- [ ] Phase 3 complete
- [ ] Verification gates passed

## 10. Notes / Links
- Schema reference: `uv run spec-driver schema show frontmatter.design_revision`
- Schema catalogue: `uv run spec-driver schema list`
- Supporting docs: `supekku/about/frontmatter-schema.md`
```
