---
id: IP-014
slug: backlog-command-shortcuts
name: Implementation Plan - backlog command shortcuts
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-014
delta: DE-014
revision_links:
  aligns_with: []
specs:
  primary:
    - PROD-010
  collaborators: []
requirements:
  targets:
    - PROD-010.FR-011
  dependencies: []
phases:
  - id: IP-014.PHASE-01
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-014
entries:
  - artefact: VT-PROD010-BACKLOG-001
    kind: VT
    requirement: PROD-010.FR-011
    phase: IP-014.PHASE-01
    status: verified
    notes: Test backlog shortcuts with filters (list issues/problems/improvements/risks) - supekku/cli/list_test.py
```

## 1. Summary
- **Delta**: DE-014 - Backlog command shortcuts
- **Specs Impacted**: PROD-010 (FR-011)
- **Problems / Issues**: Inconsistent command patterns; discoverability gap between create and list commands
- **Desired Outcome**: Four new shortcut commands (list issues/problems/improvements/risks) that delegate to existing list backlog functionality, matching create command pattern

## 2. Context & Constraints
- **Current Behaviour**: Users must use `list backlog -k <kind>` to filter by backlog type; inconsistent with `create issue|problem|improvement|risk` pattern
- **Target Behaviour**: Direct commands `list issues`, `list problems`, `list improvements`, `list risks` matching create command discoverability
- **Dependencies**: None; extends existing `list backlog` command
- **Constraints**: Must delegate to existing `list_backlog` function; no duplication; maintain all existing filter options

## 3. Gate Check
- [x] Backlog items linked and prioritised (PROD-010.FR-011 from requirements-additions-2025-11-04.md)
- [x] Spec(s) updated or delta specifies required changes (PROD-010 FR-011 documented)
- [x] Test strategy identified (unit tests following existing list command patterns)
- [x] Workspace/config changes assessed (no changes needed; CLI-only modification)

## 4. Phase Overview
| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 1 - Implementation | Add four shortcut commands | Plan approved, existing code understood | Commands implemented, tests passing, linters clean | `phases/phase-01.md` |

*Single-phase implementation: straightforward command additions with delegation pattern*

## 5. Phase Detail Snapshot
- **Research Notes**: Existing `list_backlog` function at supekku/cli/list.py:1168-1245; create commands at supekku/cli/create.py:404-506
- **Design Revision**: `DE-014/DR-014.md`
- **Active Phase Sheet**: `phases/phase-01.md` (to be created)
- **Parallelisable Work**: None (sequential: implement → test → lint)
- **Plan Updates**: None anticipated

## 6. Testing & Verification Plan
- **Updated Suites**: supekku/cli/list.py tests (if they exist) or create new test file
- **New Cases**:
  - Test each shortcut command (issues/problems/improvements/risks)
  - Verify delegation to list_backlog with correct kind parameter
  - Test filter options pass through correctly (status, substring, regexp, format, truncate)
  - Test JSON output format
  - Test empty results
- **Tooling/Fixtures**: Use existing test patterns from create command tests if available
- **Rollback Plan**: Simple revert; no data migration or state changes
- **Verification Coverage**: VT-PROD010-BACKLOG-001 satisfied by comprehensive test suite

## 7. Risks & Mitigations
| Risk | Mitigation | Owner |
| --- | --- | --- |
| Breaking existing `list backlog` functionality | Delegate only; no changes to core function | Dev |
| Test coverage insufficient | Follow existing test patterns; verify all filter combinations | Dev |
| CLI command naming conflicts | Use established names from FR-011 spec | Dev |

## 8. Open Questions & Decisions
- [x] Command names: Confirmed as `issues`, `problems`, `improvements`, `risks` (plural forms)
- [x] Implementation pattern: Delegation to existing `list_backlog` function
- [x] Filter options: All existing filters must pass through

## 9. Progress Tracking
- [ ] Phase 1 complete
- [ ] Verification gates passed

## 10. Notes / Links
- Requirements spec: docs/requirements-additions-2025-11-04.md (FR-011)
- Pattern reference: create commands at supekku/cli/create.py:404-506
- Existing implementation: list_backlog at supekku/cli/list.py:1168-1245
- Architecture guide: AGENTS.md (Skinny CLI pattern, formatters separation)
