---
id: DE-015
slug: implement-backlog-prioritization-with-interactive-ordering
name: Delta - Implement backlog prioritization with interactive ordering
created: '2025-11-04'
updated: '2025-11-04'
status: completed
kind: delta
tags: ["cli","backlog"]
aliases: []
relations: []
applies_to:
  specs: []
  requirements: []
---

# DE-015 – Implement backlog prioritization with interactive ordering

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-015
revision_links:
  introduces: []
  supersedes: []
specs:
  primary: []
  collaborators: []
requirements:
  implements: []
  updates: []
  verifies: []
phases: []
backlog_items:
  - IMPR-002
```

## 1. Summary & Context
- **Product Spec(s)**: None (internal tooling improvement)
- **Technical Spec(s)**: None (backlog domain enhancement)
- **Implementation Plan**: [IP-015](./IP-015.md) – Not started
- **Change Drivers**:
  - [IMPR-002](../../../backlog/improvements/IMPR-002-backlog-prioritization-with-interactive-ordering-and-delta-integration/IMPR-002.md) – Backlog prioritization feature request
  - [Research findings](../../../backlog/improvements/IMPR-002-backlog-prioritization-with-interactive-ordering-and-delta-integration/research-findings.md) – Implementation analysis

## 2. Motivation

Currently, backlog items (issues, improvements, problems, risks) can only be viewed in chronological order by ID. There is no mechanism for users to express relative priority among items, making it difficult to:
- Communicate what work should be tackled first
- Plan deltas based on priority rather than chronology
- Maintain priority ordering when filtering by status, kind, or severity

While `supekku/about/backlog.md` documents the intent for priority lists ("The list order is canonical"), the tooling to maintain and display this ordering does not exist.

Users need:
- Interactive priority ordering via `--prioritize` flag (opens filtered items in `$EDITOR`)
- Default display order based on priority (with severity fallback)
- Smart merge algorithm that preserves ordering of filtered-out items
- Delta creation workflow that leverages backlog items (`--from-backlog ITEM-ID`)

## 3. Scope & Objectives

**Primary Outcomes:**
1. Backlog registry (`.spec-driver/registry/backlog.yaml`) storing ordered list of item IDs
2. `sync backlog` command to initialize/maintain registry
3. Priority-based display ordering (priority → severity → ID fallback)
4. Interactive reordering via `list backlog --prioritize` with smart merge algorithm
5. `create delta --from-backlog ITEM-ID` for streamlined delta creation

**Operational Constraints:**
- Must maintain thin CLI pattern and pure formatter functions
- Test-first development required
- No new external dependencies
- Backward compatible: items without priority ordering fall back to current behavior

**Dependencies:**
- None (self-contained enhancement to backlog domain)

## 4. Out of Scope

- Bulk operations (e.g., "mark all p1 issues as high priority")
- Priority visualization/graphs
- Automatic priority suggestions based on severity/impact
- Integration with external project management tools
- Priority inheritance (e.g., related requirements inheriting item priority)

## 5. Approach Overview

**System Touchpoints:**
- `supekku/scripts/lib/backlog/` – domain logic (registry, priority management)
- `supekku/scripts/lib/core/` – new editor invocation utility
- `supekku/cli/list.py` – add `--prioritize`, `--order-by-id` flags
- `supekku/cli/sync.py` – add `sync backlog` command
- `supekku/cli/create.py` – add `--from-backlog` flag to delta creation
- `.spec-driver/registry/backlog.yaml` – new registry file (generated)

**Key Changes:**
1. **Backlog registry** – YAML file with ordered list of item IDs
2. **Sync command** – discovers items, initializes/updates registry
3. **Priority ordering** – sort function using registry order with severity/ID fallback
4. **Head-tail partitioning merge** – algorithm for filtered reordering (see research findings)
5. **Editor utility** – invoke `$EDITOR` with markdown list, parse results
6. **CLI flags** – `--prioritize` for interactive mode, `--order-by-id` for chronological fallback
7. **Delta integration** – template population from backlog item metadata

**Migration / Rollout Notes:**
- Initial registry created via `sync backlog` (run once after deployment)
- Existing behavior (ID-based ordering) preserved when registry doesn't exist
- No breaking changes to existing commands or data structures

## 6. Verification Strategy

**Requirements Coverage:**
- VT: Automated tests for partition algorithm, merge logic, sort functions
- VT: CLI integration tests for `--prioritize`, `--order-by-id` flags
- VT: Registry sync tests (creation, updates, orphan handling)
- VH: Manual verification of editor workflow (open, edit, save, merge)
- VH: User acceptance testing of display ordering with various filters

**Planned Artefacts:**
- VT-015-001: Head-tail partition algorithm tests
- VT-015-002: Registry sync operation tests
- VT-015-003: Priority ordering sort function tests
- VT-015-004: Editor utility tests (mock-based)
- VT-015-005: CLI integration tests
- VH-015-001: Interactive editor workflow validation

**Acceptance Criteria:**
- All tests pass (`just test`)
- Both linters pass (`just lint`, `just pylint`)
- `list backlog` with registry shows priority-based ordering
- `list backlog --prioritize` successfully merges user edits with existing order
- `list backlog --order-by-id` shows chronological ordering
- `sync backlog` correctly generates/updates registry
- `create delta --from-backlog ITEM-ID` populates template with item context

## 7. Risks & Mitigations

**Risk:** Editor invocation fails (missing `$EDITOR`, terminal issues)
- *Likelihood*: medium – *Impact*: medium
- *Mitigation*: Fallback to `$VISUAL`, then `vi`. Clear error messages. Test on multiple platforms.

**Risk:** User edits break markdown parsing (syntax errors, duplicate IDs)
- *Likelihood*: medium – *Impact*: low
- *Mitigation*: Validate parsed results before applying. If invalid, show error and preserve original ordering.

**Risk:** Merge algorithm produces unexpected ordering with complex filter combinations
- *Likelihood*: low – *Impact*: medium
- *Mitigation*: Comprehensive test coverage of edge cases. Document algorithm behavior clearly.

**Risk:** Registry diverges from filesystem (deleted items still in registry)
- *Likelihood*: medium – *Impact*: low
- *Mitigation*: `sync backlog` prunes orphaned entries. Display warnings for missing items.

## 8. Follow-ups & Tracking

**Future Enhancements (separate deltas):**
- Bulk priority operations
- Priority visualization in terminal UI
- Auto-priority suggestions based on severity/impact
- Related requirement prioritization

**Open Questions:**
- Should `sync backlog` run automatically like `sync decisions`?
  - Decision: Start with manual sync, observe usage patterns
- How to handle priority conflicts when manually editing registry YAML?
  - Decision: Last-write-wins, with validation warnings

## 9. Implementation Notes

**Key Algorithm (see research findings):**
```
Head-tail partitioning:
- Partition items as (shown_item, [unshown_followers])
- User reorders shown items
- Tails move atomically with their heads
- Flatten to produce final ordering
```

**Testing strategy:**
- Unit tests for all domain logic
- Mock-based tests for editor invocation
- Integration tests for CLI commands
- Property-based tests for merge algorithm edge cases

**Related documentation:**
- [IMPR-002](../../../backlog/improvements/IMPR-002-backlog-prioritization-with-interactive-ordering-and-delta-integration/IMPR-002.md) – Feature specification
- [Research findings](../../../backlog/improvements/IMPR-002-backlog-prioritization-with-interactive-ordering-and-delta-integration/research-findings.md) – Implementation analysis and algorithm details