---
id: IP-015
slug: implement-backlog-prioritization-with-interactive-ordering
name: Implementation Plan - Implement backlog prioritization with interactive ordering
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-015
delta: DE-015
revision_links:
  aligns_with: []
specs:
  primary: []
  collaborators: []
requirements:
  targets: []
  dependencies: []
phases:
- id: IP-015.PHASE-01
- id: IP-015.PHASE-02
- id: IP-015.PHASE-03
- id: IP-015.PHASE-04
- id: IP-015.PHASE-02
- id: IP-015.PHASE-03
- id: IP-015.PHASE-04
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-015
entries:
  - artefact: VT-015-001
    kind: VT
    requirement: internal
    phase: IP-015.PHASE-02
    status: planned
    notes: Head-tail partition algorithm tests
  - artefact: VT-015-002
    kind: VT
    requirement: internal
    phase: IP-015.PHASE-01
    status: planned
    notes: Registry sync operation tests
  - artefact: VT-015-003
    kind: VT
    requirement: internal
    phase: IP-015.PHASE-02
    status: planned
    notes: Priority ordering sort function tests
  - artefact: VT-015-004
    kind: VT
    requirement: internal
    phase: IP-015.PHASE-03
    status: planned
    notes: Editor utility tests (mock-based)
  - artefact: VT-015-005
    kind: VT
    requirement: internal
    phase: IP-015.PHASE-04
    status: planned
    notes: CLI integration tests
  - artefact: VH-015-001
    kind: VH
    requirement: internal
    phase: IP-015.PHASE-04
    status: planned
    notes: Interactive editor workflow validation
```

## 1. Summary
- **Delta**: DE-015 - Implement backlog prioritization with interactive ordering
- **Specs Impacted**: None (internal tooling improvement)
- **Problems / Issues**: IMPR-002 - Backlog prioritization with interactive ordering and delta integration
- **Desired Outcome**: Users can interactively prioritize backlog items with `--prioritize` flag, with smart filtering and ordering preserved in registry

## 2. Context & Constraints
- **Current Behaviour**: Backlog items sorted by ID only (chronological). No priority mechanism exists.
- **Target Behaviour**:
  - Registry stores ordered list of item IDs
  - Display uses priority → severity → ID sorting
  - Interactive reordering via `--prioritize` flag with head-tail merge algorithm
- **Dependencies**: None (self-contained)
- **Constraints**:
  - Must maintain backward compatibility (no registry = current behavior)
  - Must follow thin CLI pattern
  - Test-first development required

## 3. Gate Check
- [x] Backlog items linked and prioritised (IMPR-002)
- [x] Spec(s) updated or delta specifies required changes (internal tooling, no spec)
- [x] Test strategy identified (unit tests for domain, integration tests for CLI, manual VH for editor)
- [x] Workspace/config changes assessed (new registry file only)

## 4. Phase Overview

| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| **Phase 1** - Registry Infrastructure | Create backlog registry and sync command | IP approved | Registry structure defined, sync command working, tests pass | `phases/phase-01.md` |
| **Phase 2** - Priority Ordering Logic | Implement ordering and merge algorithm | Phase 1 complete | Sort functions work, head-tail partition tested, display uses priority | `phases/phase-02.md` |
| **Phase 3** - Interactive Editor Flow | Build editor utility and `--prioritize` flag | Phase 2 complete | Editor invocation works, markdown parsing validated, merge algorithm integrated | `phases/phase-03.md` |
| **Phase 4** - CLI Integration & Delta Support | Wire up all CLI flags and delta creation | Phase 3 complete | All flags work, `--from-backlog` populates templates, full integration tests pass | `phases/phase-04.md` |

*Each phase builds incrementally, allowing early validation before adding complexity.*

## 5. Phase Detail Snapshot

**Phase 1 - Registry Infrastructure:**
- Create `.spec-driver/registry/backlog.yaml` schema
- Implement `sync backlog` command in `supekku/cli/sync.py`
- Add registry read/write functions in `supekku/scripts/lib/backlog/registry.py`
- Tests: VT-015-002 (sync operations)

**Phase 2 - Priority Ordering Logic:**
- Implement head-tail partition algorithm
- Create sort function with priority → severity → ID fallback
- Update `discover_backlog_items()` to use registry ordering
- Update `format_backlog_list_table()` to use ordered items
- Tests: VT-015-001 (partition), VT-015-003 (sorting)

**Phase 3 - Interactive Editor Flow:**
- Create `supekku/scripts/lib/core/editor.py` utility
- Implement markdown list generation and parsing
- Wire partition algorithm to merge user edits
- Tests: VT-015-004 (editor utility, mocked)

**Phase 4 - CLI Integration & Delta Support:**
- Add `--prioritize` / `--prioritise` flag to `list backlog`
- Add `--order-by-id` / `-o` flag
- Implement `create delta --from-backlog ITEM-ID`
- Tests: VT-015-005 (CLI integration), VH-015-001 (manual workflow)

## 6. Testing & Verification Plan

**Unit Tests:**
- `supekku/scripts/lib/backlog/registry_test.py` - sync, read/write registry
- `supekku/scripts/lib/backlog/priority_test.py` - partition algorithm, merge logic
- `supekku/scripts/lib/core/editor_test.py` - editor invocation (mocked)

**Integration Tests:**
- `supekku/cli/list_test.py` - `--prioritize` flag end-to-end
- `supekku/cli/sync_test.py` - `sync backlog` command
- `supekku/cli/create_test.py` - `--from-backlog` flag

**Manual Verification (VH-015-001):**
- Run `list backlog --prioritize` with various filters
- Verify ordering persists across sessions
- Test edge cases (empty filters, all items shown, syntax errors)

**Rollback Plan:**
- Registry file is additive only; can be deleted without breaking existing functionality
- No database migrations or schema changes
- Feature flags not needed (backward compatible by design)

## 7. Risks & Mitigations

| Risk | Mitigation | Owner |
| --- | --- | --- |
| Editor invocation fails on some platforms | Test on Linux/macOS/WSL; fallback to VISUAL then vi | Dev |
| Markdown parsing breaks with unusual item names | Validate parsing with property-based tests; defensive parsing | Dev |
| Registry file conflicts with concurrent edits | Document as single-user tool; add file locking if needed later | Dev |
| Performance degrades with large backlogs (100+ items) | Profile with 500 item test; optimize if needed | Dev |

## 8. Open Questions & Decisions

- [x] Should registry track all metadata or just ordering? **Decision:** Just ordering (IDs only)
- [x] Should priority use indices or list position? **Decision:** List position (simpler)
- [x] Auto-sync or manual `sync backlog`? **Decision:** Manual initially, observe usage
- [x] Should `--prioritize` auto-save or require confirmation? **Decision:** Auto-save on successful editor exit (no confirmation needed)

## 9. Progress Tracking

- [x] Phase 1 complete - Registry Infrastructure
- [x] Phase 2 complete - Priority Ordering Logic
- [x] Phase 3 complete - Interactive Editor Flow
- [x] Phase 4 complete - CLI Integration & Delta Support
- [x] All verification gates passed (VT-015-001 through VT-015-005, VH-015-001)
- [x] Lint checks pass (`just lint`, `just pylint`)

## 10. Lessons Learned

**What Went Well:**
- Incremental phased approach allowed early validation before adding complexity
- Test-first development caught edge cases (empty lists, malformed input, duplicates)
- Mocking strategy for editor invocation worked well for automated testing
- ID-based lookups solution was clean and avoided dataclass hashability issues

**Challenges & Solutions:**
- **BacklogItem unhashability**: Fixed by using ID-based membership checks and dict lookups instead of object-based
- **Editor integration**: subprocess.run() blocks correctly for most editors (vim, nano)
- **Circular dependencies**: Local imports with noqa worked well for backlog ↔ core dependency

**Future Improvements:**
- Consider making BacklogItem frozen dataclass for hashability (would need to evaluate impact)
- Could add `--wait` flag support for GUI editors that background themselves
- Batch operations (e.g., "move all p1 issues to top") could be useful

## 11. Notes / Links

- **Research:** [research-findings.md](../../../backlog/improvements/IMPR-002-backlog-prioritization-with-interactive-ordering-and-delta-integration/research-findings.md)
- **Improvement:** [IMPR-002](../../../backlog/improvements/IMPR-002-backlog-prioritization-with-interactive-ordering-and-delta-integration/IMPR-002.md)
- **Algorithm reference:** Head-tail partitioning (see research findings)
- **Current backlog code:** `supekku/scripts/lib/backlog/registry.py:227` (discover_backlog_items)
