---
id: DE-016
slug: remove-phase-01-auto-creation-and-enable-intelligent-phase-creation
name: Delta - Remove phase-01 auto-creation and enable intelligent phase creation
created: '2025-11-04'
updated: '2025-11-04'
status: completed
kind: delta
aliases: []
tags: ["implementation", "create"]
relations: []
applies_to:
  specs:
    - PROD-011
  requirements:
    - PROD-011.FR-001
    - PROD-011.FR-002
---

# DE-016 – Remove phase-01 auto-creation and enable intelligent phase creation

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-016
revision_links:
  introduces: []
  supersedes: []
specs:
  primary: []
  collaborators: []
requirements:
  implements:
    - PROD-011.FR-001
    - PROD-011.FR-002
  updates: []
  verifies: []
phases: []
```

## 1. Summary & Context
- **Product Spec(s)**: PROD-011 – Implementation Execution Workflow
- **Implementation Plan**: [IP-016](./IP-016.md) – pending
- **Change Drivers**: Original user problem statement, PROD-006 (Phase Management) implementation revealed timing issue

## 2. Motivation

**Problem**: Currently `create delta` auto-creates phase-01 alongside the empty Implementation Plan template. This prevents phase-01 from benefiting from the entry/exit criteria intelligence added to `create phase` in PROD-006, which copies criteria from the IP. Phase-01 is created before the IP is fleshed out, so there are no criteria to copy.

**Target State**:
- `create delta` produces only: delta file, design revision, implementation plan, notes (no phase)
- Users flesh out IP first (manually or via future /supekku.plan hook)
- `create phase --plan IP-XXX` works when no phases exist, creating phase-01 with intelligent criteria copying

**User Impact**: Eliminates manual duplication of entry/exit criteria from IP to phase-01, consistent experience across all phases.

## 3. Scope & Objectives

**Primary Outcomes**:
- **PROD-011.FR-001**: Remove phase-01 auto-creation from `create delta` command
- **PROD-011.FR-002**: Ensure `create phase` works when plan has zero existing phases

**Operational Constraints**:
- Must maintain backward compatibility with existing deltas that have phase-01
- Must not break existing phase creation for phases 2+
- Simple fix, no new abstractions

**Dependencies**: PROD-006 already implemented (create phase with criteria intelligence)

## 4. Out of Scope

- Workflow hook system (PROD-011.FR-003, FR-004) – future delta
- Automation metadata (PROD-011.FR-005, FR-008) – future delta
- Constitution integration (PROD-011.FR-006, FR-007) – future delta
- CLI flags for commit policy – future delta
- Help system integration – future delta

## 5. Approach Overview

**System Touchpoints**:
- `supekku/cli/create.py` or equivalent delta creation logic
- `supekku/scripts/lib/changes/creation.py` (likely location of phase creation logic)
- Templates in `.spec-driver/templates/`

**Key Changes**:
1. Remove phase directory and phase-01.md creation from delta creation flow
2. Update `create phase` to handle empty phases directory (determine starting at 01)
3. Verify phase numbering logic works from 01 when no phases exist

**Migration / Rollout Notes**:
- No migration needed for existing deltas (their phase-01 files remain)
- New deltas created after this change won't have phase-01 until explicitly created
- Documentation update to reflect new workflow

## 6. Verification Strategy

**Requirements Coverage**:
- VT-016-001: Test `create delta` produces 4 files (DE, DR, IP, notes), no phases/ directory
- VT-016-002: Test `create phase --plan IP-XXX` when plan has no phases, verify phase-01 created
- VT-016-003: Test phase-01 includes entry/exit criteria from fleshed-out IP
- VT-016-004: Test existing create phase behavior unchanged (phase-02, phase-03, etc.)

**Acceptance Criteria**:
- `create delta` output verified (no phase directory)
- `create phase` works on empty phases directory
- Phase numbering starts at 01 correctly
- Entry/exit criteria copied from IP to phase-01
- All existing tests pass
- Linters pass

## 7. Risks & Mitigations

**Risk**: Users confused by missing phase-01 after delta creation
- *Likelihood*: Medium
- *Impact*: Low
- *Mitigation*: Update output message, documentation, consider INIT.md patch per ISSUE-003

**Risk**: Phase numbering logic assumes phase-01 exists
- *Likelihood*: Low
- *Impact*: Medium
- *Mitigation*: Review and test phase number determination logic thoroughly

**Risk**: Breaking change for automation/scripts expecting phase-01
- *Likelihood*: Low
- *Impact*: Low
- *Mitigation*: Project is early stage, limited external usage

## 8. Follow-ups & Tracking

**Future Deltas**:
- DE-TBD: Workflow hook system (PROD-011 FR-003, FR-004)
- DE-TBD: Automation metadata with CLI flags (PROD-011 FR-005, FR-008)
- DE-TBD: Constitution integration (PROD-011 FR-006, FR-007)

**Backlog Items**:
- ISSUE-003: INIT.md patching into installer for user guidance

**Open Questions**:
- Should we update delta creation output message to guide users on next steps?
- Update which documentation files? (README, workflow docs, etc.)

## 9. Implementation Notes

**Files to Investigate**:
- `supekku/cli/create.py` - delta creation command
- `supekku/scripts/lib/changes/creation.py` - change artifact creation logic
- `supekku/scripts/create_delta.py` - may contain phase creation
- `.spec-driver/templates/phase-template.md` - phase template (unchanged)

**Testing Strategy**:
- Run existing delta creation, verify no phase directory
- Create IP, flesh out phases section, run create phase, verify phase-01 with criteria
- Run full test suite to ensure no regressions