---
id: DE-017
slug: add-category-support-to-requirements
name: Delta - Add category support to requirements
created: '2025-11-04'
updated: '2025-11-04'
status: completed
kind: delta
aliases: []
tags: ["cli", "requirements"]
relations:
  - type: relates_to
    target: IMPR-001
    note: Add category support to requirements
applies_to:
  specs: []
  requirements: []
progress:
  phase: 2
  status: Phase 2 complete - CLI filtering and display implemented
  completed_phases:
    - IP-017.PHASE-01
    - IP-017.PHASE-02
  remaining_phases:
    - IP-017.PHASE-03
---

# DE-017 – Add category support to requirements

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-017
revision_links:
  introduces: []
  supersedes: []
specs:
  primary: []
  collaborators: []
requirements:
  implements: []
  updates: []
  verifies: []
phases: []
```

## 1. Summary & Context
- **Product Spec(s)**: N/A – Internal tooling improvement
- **Technical Spec(s)**: N/A – Requirements subsystem enhancement
- **Implementation Plan**: [IP-017](./IP-017.md) – Phase 2 complete
- **Change Drivers**: [IMPR-001](../../../backlog/improvements/IMPR-001-add-category-support-to-requirements/IMPR-001.md) – Add category support to requirements
- **Current Phase**: Phase 2 complete (CLI & Formatters) – See [phase-02.md](./phases/phase-02.md)
- **Next Phase**: Phase 3 (Manual Verification & Polish)

## 2. Motivation

Requirements currently lack categorization, limiting the ability to:
- Filter requirements by functional area, quality attribute, or concern
- Understand requirement distribution across categories (security, performance, UX, etc.)
- Generate category-focused coverage reports
- Navigate large requirement sets efficiently

**Target State**: Requirements support optional categorization with flexible filtering, enabling users to organize and query requirements by domain-specific categories.

## 3. Scope & Objectives

**Primary Outcomes**:
- Requirements can declare categories via inline syntax: `**FR-001**(category): description`
- Requirements can declare categories via frontmatter: `category: value`
- `list requirements` command supports `--category` filter (substring match)
- Category column appears in list output
- Regexp/case-insensitive filters operate on category field
- Category data persists in requirements registry

**Operational Constraints**:
- No breaking changes to existing requirement parsing
- Backward compatible: uncategorized requirements continue to work
- No performance degradation for large requirement sets

**Dependencies**: None

## 4. Out of Scope

- Category taxonomy validation (categories are freeform)
- Hierarchical category enforcement (delimiters user-defined)
- Category autocomplete/suggestions in CLI
- Category-based requirement grouping in reports
- Migration tooling to add categories to existing requirements

## 5. Approach Overview

**System Touchpoints**:
- `supekku/scripts/lib/requirements/registry.py` – RequirementRecord model, parsing
- `supekku/scripts/lib/formatters/requirement_formatters.py` – Display formatting (if exists, else create)
- `supekku/cli/list.py` or `supekku/scripts/requirements.py` – CLI command
- `.spec-driver/registry/requirements.yaml` – Registry schema

**Key Changes**:
1. **Data Model**: Add optional `category: str | None` field to `RequirementRecord`
2. **Parser Enhancement**:
   - Extend `_REQUIREMENT_LINE` regex to capture `(category)` after requirement ID
   - Parse `category` from frontmatter YAML
   - Apply precedence: inline category > frontmatter category
3. **Merge Strategy**: Update `RequirementRecord.merge()` to handle category (body wins)
4. **CLI Enhancement**: Add `--category` filter option, extend existing filters
5. **Formatter**: Add category column to list output, handle uncategorized gracefully
6. **Registry**: Include `category` in serialization/deserialization

**Migration / Rollout Notes**:
- Existing requirements without categories display empty/placeholder in category column
- No registry migration needed – `category` field defaults to `None`

## 6. Verification Strategy

**Requirements Coverage**:
- **Inline parsing**: Unit test verifying `**FR-001**(auth): description` extracts `category="auth"`
- **Frontmatter parsing**: Unit test verifying YAML `category:` field extraction
- **Precedence**: Unit test confirming body category overrides frontmatter
- **Filtering**: Integration test for `--category` substring matching
- **Regexp filtering**: Integration test for `-r` pattern matching on category
- **Case-insensitive**: Integration test for `-i` flag on category
- **Display**: Integration test verifying category column in output
- **Registry persistence**: Test category survives sync round-trip

**Planned Artifacts**:
- VT-017-001: Unit tests for category parsing (inline + frontmatter)
- VT-017-002: Unit tests for merge precedence
- VT-017-003: Integration tests for CLI filtering
- VT-017-004: Integration tests for category display
- VH-017-001: Manual verification of category workflow in real specs

**Acceptance Criteria**:
- All tests pass (`just test`)
- Both linters pass (`just lint`, `just pylint`)
- Category appears in `list requirements` output
- `--category` filter works with substring matching
- Existing requirements without categories display correctly
- Registry sync preserves category data

## 7. Risks & Mitigations

- **Risk**: Regex complexity introduces parsing bugs – *Likelihood*: medium – *Impact*: medium – *Mitigation*: Comprehensive unit tests with edge cases (special chars, whitespace, nested parens)
- **Risk**: Performance degradation on large requirement sets – *Likelihood*: low – *Impact*: low – *Mitigation*: Category parsing adds minimal overhead; benchmark if concerns arise
- **Risk**: User confusion about precedence rules – *Likelihood*: low – *Impact*: low – *Mitigation*: Document precedence clearly in help text and examples

## 8. Follow-ups & Tracking

**Future Phases / Deltas**:
- Category-based grouping in reports (not critical for initial release)
- Category autocomplete/suggestions (UX enhancement)
- Category analytics (distribution charts, coverage by category)

**Backlog Items**: None

**Open Decisions / Questions**: None

## 9. Implementation Status

**Phase 1 Complete** (Data Model & Parser):
- ✅ RequirementRecord extended with `category` field
- ✅ Parser regex updated to capture `(category)` syntax
- ✅ Frontmatter parsing supports `category` field
- ✅ Merge precedence: body category > frontmatter category
- ✅ Registry serialization/deserialization updated
- ✅ VT-017-001 and VT-017-002 passing (1352 total tests)
- ✅ Linters clean

**Phase 2 Complete** (CLI & Formatters):
- ✅ `--category`/`-c` filter option added to `list requirements` command
- ✅ Category filter respects `--case-insensitive` flag
- ✅ Regexp filter extended to search category field
- ✅ Category column added to table/TSV/JSON output formats
- ✅ Category styling: blue (#458588) color applied
- ✅ Formatter module created with comprehensive tests
- ✅ VT-017-003 passing (9 integration tests for filtering)
- ✅ VT-017-004 passing (4 integration tests for display)
- ✅ Manual testing with 14 categorized requirements
- ✅ All 29 tests passing, linters clean

**Phase 3 Pending** (Manual Verification & Polish):
- ⏳ VH-017-001: Manual verification in real workflow
- ⏳ Edge case testing and documentation updates
- ⏳ Final polish and delta completion

**Commits**:
- `a126386` - feat(DE-017): add category column to requirement formatters
- `1a8541b` - feat(DE-017): add category filter to requirements list CLI
- `4171959` - test(DE-017): add integration tests for category filtering and display
- `4d358bf` - feat(DE-017): add categories to sample requirements for testing
- `41a87ea` - docs(DE-017): document manual testing results in phase-02
- `1c52f6e` - style(DE-017): add blue color to category column

## 10. Implementation Notes

**Development Workflow**:
```bash
# Run tests continuously during development
just test supekku/scripts/lib/requirements/

# Lint individual files as you go
just pylint supekku/scripts/lib/requirements/registry.py

# Full validation before commit
just
```

**Testing Strategy**:
- TDD approach: write tests first for each parsing scenario
- Use existing requirement test fixtures as baseline
- Add category variations to existing test specs

**Reference Files**:
- Existing parser: `supekku/scripts/lib/requirements/registry.py:50-54` (_REQUIREMENT_LINE regex)
- Existing model: `supekku/scripts/lib/requirements/registry.py:56-124` (RequirementRecord)
- Merge logic: `supekku/scripts/lib/requirements/registry.py:73-90` (RequirementRecord.merge)