---
id: DR-017
slug: add-category-support-to-requirements
name: Design Revision - Add category support to requirements
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: design_revision
aliases: []
owners: []
relations:
- type: implements
  target: DE-017
delta_ref: DE-017
source_context:
- IMPR-001
code_impacts:
- path: supekku/scripts/lib/requirements/registry.py
  component: RequirementRecord
  impact: model_extension
- path: supekku/scripts/lib/requirements/registry.py
  component: _REQUIREMENT_LINE
  impact: regex_enhancement
- path: supekku/scripts/lib/requirements/registry.py
  component: _records_from_content
  impact: parser_logic
- path: supekku/scripts/lib/formatters/
  component: requirement_formatters
  impact: new_module
- path: supekku/scripts/lib/core/frontmatter_metadata/spec.py
  component: SPEC_FRONTMATTER_METADATA
  impact: schema_documentation
- path: supekku/scripts/lib/core/frontmatter_metadata/prod.py
  component: PROD_FRONTMATTER_METADATA
  impact: schema_documentation
verification_alignment:
- artifact: VT-017-001
  type: new
  scope: unit_tests
- artifact: VT-017-002
  type: new
  scope: unit_tests
- artifact: VT-017-003
  type: new
  scope: integration_tests
- artifact: VT-017-004
  type: new
  scope: integration_tests
- artifact: VH-017-001
  type: new
  scope: manual_verification
design_decisions:
- id: DEC-017-001
  summary: Body content takes precedence over frontmatter for category
  rationale: Consistent with existing merge behavior for title/kind/path
- id: DEC-017-002
  summary: Categories are optional and freeform (no taxonomy)
  rationale: Maximize flexibility, avoid premature abstraction
- id: DEC-017-003
  summary: User-defined hierarchy delimiters (no enforcement)
  rationale: Support diverse categorization schemes without imposing structure
open_questions: []
---

# DR-017 – Add category support to requirements

## 1. Executive Summary
- **Delta**: [DE-017](./DE-017.md)
- **Status**: draft
- **Owners / Team**: TBD
- **Last Updated**: 2025-11-04
- **Synopsis**: Extend requirements subsystem to support optional categorization with flexible filtering

## 2. Problem & Constraints

**Current Behaviour**: Requirements lack categorization mechanism. Users cannot:
- Filter requirements by functional domain (auth, storage, reporting)
- Query by quality attribute (security, performance, reliability)
- Understand requirement distribution across concerns
- Generate category-focused coverage reports

**Drivers / Inputs**: [IMPR-001](../../../backlog/improvements/IMPR-001-add-category-support-to-requirements/IMPR-001.md)

**Constraints / Guardrails**:
- No breaking changes to existing requirement parsing
- Backward compatibility: uncategorized requirements must continue to work
- Follow existing precedence patterns (body > frontmatter)
- Pure functions in formatters (no business logic)

**Out of Scope**:
- Category taxonomy validation
- Hierarchical category enforcement
- Category autocomplete/suggestions
- Category-based grouping in reports
- Migration tooling

## 3. Architecture Intent

**Target Outcomes**:
- Requirements declare categories via inline syntax: `**FR-001**(category): desc`
- Requirements declare categories via frontmatter YAML
- CLI supports `--category` filter with substring/regexp/case-insensitive matching
- Category appears as column in list output
- Category data persists in registry

**Guiding Principles**:
- **SRP**: Category parsing in registry, formatting in formatters, filtering in CLI
- **Pure functions**: Formatters have no side effects
- **Avoid premature abstraction**: Start with requirement-specific implementation
- **Body precedence**: Inline category overrides frontmatter (consistent with title/kind)

**State Transitions / Lifecycle Impact**: None. Category is descriptive metadata, not lifecycle state.

## 4. Code Impact Summary

| Path | Current State | Target State |
| --- | --- | --- |
| `supekku/scripts/lib/requirements/registry.py` (RequirementRecord) | No category field | Add optional `category: str \| None` field |
| `supekku/scripts/lib/requirements/registry.py` (_REQUIREMENT_LINE) | Regex captures FR/NF-NNN and title | Extended regex captures optional `(category)` group |
| `supekku/scripts/lib/requirements/registry.py` (_records_from_content) | Parses ID and title from body | Parse category from inline syntax and frontmatter, apply precedence |
| `supekku/scripts/lib/requirements/registry.py` (RequirementRecord.merge) | Merges title/kind/path (body wins) | Add category to merge with same precedence |
| `supekku/scripts/lib/requirements/registry.py` (to_dict/from_dict) | Serializes current fields | Include category in serialization |
| `supekku/scripts/lib/formatters/requirement_formatters.py` | Does not exist | Create with category column formatting |
| `supekku/scripts/lib/core/frontmatter_metadata/spec.py` | No category field documentation | Add optional category field to SPEC_FRONTMATTER_METADATA |
| `supekku/scripts/lib/core/frontmatter_metadata/prod.py` | No category field documentation | Add optional category field to PROD_FRONTMATTER_METADATA |
| CLI (requirements list command) | No category filtering | Add `--category` option, extend regexp/-i to category |

## 5. Verification Alignment

| Verification | Impact | Notes |
| --- | --- | --- |
| VT-017-001 | new | Unit tests: category parsing (inline + frontmatter) |
| VT-017-002 | new | Unit tests: merge precedence (body > frontmatter) |
| VT-017-003 | new | Integration tests: CLI category filtering |
| VT-017-004 | new | Integration tests: category column display |
| VH-017-001 | new | Manual verification in real specs |

## 6. Supporting Context

**Related Improvements**: [IMPR-001](../../../backlog/improvements/IMPR-001-add-category-support-to-requirements/IMPR-001.md) – Add category support to requirements

**Architecture Patterns**:
- Existing parser: `_REQUIREMENT_LINE` regex at registry.py:50-54
- Existing model: `RequirementRecord` dataclass at registry.py:56-124
- Existing merge: `RequirementRecord.merge()` at registry.py:73-90
- Precedence pattern: body content (`other.*`) wins over existing record (`self.*`)

## 7. Design Decisions & Trade-offs

**DEC-017-001**: Body content takes precedence over frontmatter for category
- **Rationale**: Consistent with existing merge behavior for `title`, `kind`, `path`
- **Consequences**: Source of truth is visible in spec body; simple mental model
- **Trade-offs**: Frontmatter-only definitions require fallback logic

**DEC-017-002**: Categories are optional and freeform (no taxonomy)
- **Rationale**: Maximize flexibility, avoid premature abstraction
- **Consequences**: No validation overhead; users define their own conventions
- **Trade-offs**: Potential for inconsistent category names across specs

**DEC-017-003**: User-defined hierarchy delimiters (no enforcement)
- **Rationale**: Support diverse categorization schemes without imposing structure
- **Consequences**: Simple substring/regexp filtering works regardless of delimiter
- **Trade-offs**: No hierarchical query support (e.g., "all security/* categories")

## 8. Open Questions

None.

## 9. Rollout & Operational Notes

**Migration / Backfill**:
- No migration needed – `category` field defaults to `None`
- Existing requirements continue to work without categories
- Users can add categories to specs incrementally

**Observability / Alerts**: None (internal tooling change)

**Recovery / Rollback**:
- If issues arise, remove category field from RequirementRecord
- Registry sync will ignore category in source specs
- No data loss – category is descriptive metadata only

## 10. References & Links

**Code References**:
- Parser regex: `supekku/scripts/lib/requirements/registry.py:50-54`
- Data model: `supekku/scripts/lib/requirements/registry.py:56-124`
- Merge logic: `supekku/scripts/lib/requirements/registry.py:73-90`
- Sync logic: `supekku/scripts/lib/requirements/registry.py:165-318`

**Design References**:
- AGENTS.md: Architecture principles (SRP, pure functions, avoid premature abstraction)
- IMPR-001: Improvement proposal with use cases and examples
