---
id: IP-017
slug: add-category-support-to-requirements
name: Implementation Plan - Add category support to requirements
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: plan
aliases: []
---

```yaml supekku:plan.overview@v1
schema: supekku.plan.overview
version: 1
plan: IP-017
delta: DE-017
revision_links:
  aligns_with: []
specs:
  primary: []
  collaborators: []
requirements:
  targets: []
  dependencies: []
phases:
- id: IP-017.PHASE-01
- id: IP-017.PHASE-02
```

```yaml supekku:verification.coverage@v1
schema: supekku.verification.coverage
version: 1
subject: IP-017
entries:
  - artefact: VT-017-001
    kind: VT
    phase: IP-017.PHASE-01
    status: verified
    notes: Unit tests for category parsing (inline + frontmatter) - 1352 tests passing
  - artefact: VT-017-002
    kind: VT
    phase: IP-017.PHASE-01
    status: verified
    notes: Unit tests for merge precedence (body > frontmatter) - 1352 tests passing
  - artefact: VT-017-003
    kind: VT
    phase: IP-017.PHASE-02
    status: verified
    notes: Integration tests for CLI category filtering - 9 tests passing
  - artefact: VT-017-004
    kind: VT
    phase: IP-017.PHASE-02
    status: verified
    notes: Integration tests for category column display - 4 tests passing
  - artefact: VH-017-001
    kind: VH
    phase: IP-017.PHASE-02
    status: verified
    notes: Manual verification complete - 14 categorized requirements tested, all filters working
```

## 1. Summary
- **Delta**: [DE-017](./DE-017.md) - Add category support to requirements
- **Specs Impacted**: None (internal tooling enhancement)
- **Problems / Issues**: [IMPR-001](../../../backlog/improvements/IMPR-001-add-category-support-to-requirements/IMPR-001.md)
- **Desired Outcome**: Requirements support optional categorization with flexible filtering via CLI

## 2. Context & Constraints

**Current Behaviour**: Requirements cannot be categorized or filtered by functional area/quality attribute

**Target Behaviour**:
- Parse category from inline syntax: `**FR-001**(category): description`
- Parse category from frontmatter YAML: `category: value`
- Filter requirements by category in CLI
- Display category column in list output

**Dependencies**: None

**Constraints**:
- Backward compatible (uncategorized requirements continue to work)
- Follow existing precedence patterns (body > frontmatter)
- Pure functions in formatters, business logic in domain packages

## 3. Gate Check
- [x] Backlog items linked and prioritised (IMPR-001)
- [x] Spec(s) updated or delta specifies required changes (N/A - internal tooling)
- [x] Test strategy identified (unit + integration tests)
- [x] Workspace/config changes assessed (registry schema update only)


> Tip: Plan phases up front, then create the phase sheet for the current phase only. Update later phases when you are ready to execute them.

## 4. Phase Overview

| Phase | Objective | Entrance Criteria | Exit Criteria / Done When | Phase Sheet |
| --- | --- | --- | --- | --- |
| Phase 1 - Data Model & Parser | Extend RequirementRecord, update regex, implement parsing | Gate check complete | Model updated, parsing tests passing, lint clean | [phases/phase-01.md](./phases/phase-01.md) |
| Phase 2 - CLI & Formatters | Add category filtering, create formatter module | Phase 1 complete | CLI filtering works, category column displays, integration tests pass | `phases/phase-02.md` |
| Phase 3 - Verification & Polish | Manual verification, edge case testing, documentation | Phase 2 complete, all tests passing | VH-017-001 complete, edge cases covered, ready for use | `phases/phase-03.md` |

## 5. Phase Detail Snapshot

- **Research Notes**: `DE-017/notes.md`
- **Design Revision**: [DR-017.md](./DR-017.md)
- **Active Phase Sheet**: [phases/phase-01.md](./phases/phase-01.md)
- **Parallelisable Work**: None (sequential dependency: model → parser → CLI → verification)
- **Plan Updates**: Update when new edge cases or requirements discovered during implementation

## 6. Testing & Verification Plan

**Unit Tests** (Phase 1):
- Category parsing from inline syntax: `**FR-001**(auth): desc`
- Category parsing from frontmatter YAML
- Merge precedence: body category overrides frontmatter
- Serialization/deserialization with category field
- Edge cases: missing category, special chars, whitespace, nested parens

**Integration Tests** (Phase 2):
- `--category` substring filter
- Regexp filter (`-r`) on category
- Case-insensitive filter (`-i`) on category
- Category column in list output
- Uncategorized requirements display correctly

**Manual Verification** (Phase 3):
- Add categories to real spec requirements
- Verify filtering workflow end-to-end
- Test with hierarchical categories (user-defined delimiters)
- Confirm registry sync preserves category data

**Tooling/Fixtures**:
- Extend existing requirement test fixtures with category examples
- Use existing test spec files in `specify/` for integration tests

**Rollback Plan**: Remove category field from RequirementRecord; no data loss (descriptive metadata only)

## 7. Risks & Mitigations

| Risk | Mitigation | Owner |
| --- | --- | --- |
| Regex complexity introduces bugs | Comprehensive unit tests with edge cases | Dev |
| Performance degradation | Benchmark if concerns arise; minimal overhead expected | Dev |
| User confusion about precedence | Document clearly in help text and examples | Dev |

## 8. Open Questions & Decisions

None. All architectural decisions documented in DR-017.

## 9. Progress Tracking

- [x] Phase 1 complete (Data Model & Parser) - See [phase-01.md](./phases/phase-01.md)
- [x] Phase 2 complete (CLI & Formatters) - See [phase-02.md](./phases/phase-02.md)
- [x] Phase 3 skipped (verification completed in Phase 2)
- [x] VT-017-001 and VT-017-002 verified (Phase 1 unit tests)
- [x] VT-017-003 and VT-017-004 verified (Phase 2 integration tests)
- [x] VH-017-001 verified (Manual verification with 14 categorized requirements)
- [x] Both linters passing (ruff clean, pylint 8.99/10)
- [x] Ready for delta completion

**Current Status**: All phases complete. All verification artifacts verified. Ready to complete delta.

## 10. Notes / Links

**Design References**:
- [DR-017](./DR-017.md) - Design Revision with code impact summary
- [IMPR-001](../../../backlog/improvements/IMPR-001-add-category-support-to-requirements/IMPR-001.md) - Improvement proposal
- [AGENTS.md](../../../AGENTS.md) - Architecture principles

**Code Hotspots**:
- `supekku/scripts/lib/requirements/registry.py:50-54` - _REQUIREMENT_LINE regex
- `supekku/scripts/lib/requirements/registry.py:56-124` - RequirementRecord model
- `supekku/scripts/lib/requirements/registry.py:73-90` - RequirementRecord.merge()
