---
id: DE-018
slug: add-tags-column-to-list-table-output-for-all-artifact-types
name: Delta - Add Tags column to list table output for all artifact types
created: '2025-11-04'
updated: '2025-11-04'
status: completed
kind: delta
aliases: []
relations: []
tags: ["cli"]
applies_to:
  specs:
  - SPEC-110
  - SPEC-120
  requirements: []
---

# DE-018 – Add Tags column to list table output for all artifact types

```yaml supekku:delta.relationships@v1
schema: supekku.delta.relationships
version: 1
delta: DE-018
revision_links:
  introduces: []
  supersedes: []
specs:
  primary:
    - SPEC-110
    - SPEC-120
  collaborators: []
requirements:
  implements: []
  updates: []
  verifies: []
phases: []
```

## 1. Summary & Context
- **Product Spec(s)**: PROD-010 – CLI Agent UX (list command consistency)
- **Technical Spec(s)**: [SPEC-110](../../../specify/tech/SPEC-110/SPEC-110.md) – CLI, [SPEC-120](../../../specify/tech/SPEC-120/SPEC-120.md) – Formatters
- **Implementation Plan**: [IP-018](./IP-018.md) – Draft, pending execution
- **Change Drivers**: [ISSUE-017](../../../backlog/issues/ISSUE-017-add-tags-column-to-list-table-output-for-all-artifact-types/ISSUE-017.md) – UX discoverability gap; DE-010 established pattern for policies/standards

## 2. Motivation
All artifact list commands (`list adrs`, `list specs`, `list deltas`, etc.) support `--tag` filtering, but table output doesn't include a Tags column. This creates a discoverability gap - users can't see which tags are available without using `--json` or `show` commands.

Current table output shows: `ID | Title | Status | Updated`

Expected: `ID | Title | Status | Tags | Updated`

DE-010 already fixed this for policies and standards, establishing the pattern. This delta extends that consistency to remaining artifact types.

## 3. Scope & Objectives
- **Primary Outcomes**:
  - Add Tags column to all remaining formatter table outputs:
    - `decision_formatters.py` (ADRs)
    - `spec_formatters.py` (SPEC/PROD specs)
    - `change_formatters.py` (Deltas, revisions, audits)
    - `requirement_formatters.py` (Requirements)
    - `backlog_formatters.py` (Issues, problems, improvements)
  - Consistent tag display: comma-separated list or empty string
  - Comprehensive test coverage for tag display edge cases
- **Operational Constraints**: Follow existing pattern from DE-010; no new abstractions
- **Dependencies**: None – extends existing formatters

## 4. Out of Scope
- Changes to `policy_formatters.py` and `standard_formatters.py` (already fixed in DE-010)
- Tag filtering logic (already implemented)
- JSON output format (already includes tags)

## 5. Approach Overview
- **System Touchpoints**:
  - `supekku/scripts/lib/formatters/decision_formatters.py`
  - `supekku/scripts/lib/formatters/spec_formatters.py`
  - `supekku/scripts/lib/formatters/change_formatters.py`
  - `supekku/scripts/lib/formatters/requirement_formatters.py`
  - `supekku/scripts/lib/formatters/backlog_formatters.py`
  - Corresponding test files (`*_formatters_test.py`)

- **Key Changes** (pattern from DE-010):
  1. Add "Tags" to columns list in `_format_as_table()` functions
  2. Update `_prepare_*_row()` functions to include formatted tags
  3. Update `_calculate_column_widths()` to include tags column width calculation
  4. Format tags as comma-separated list (or empty string if no tags)
  5. Add test cases for tag display in `*_formatters_test.py` files

- **Migration / Rollout Notes**: No migration needed – purely additive display change

## 6. Verification Strategy
- **Requirements Coverage**:
  - Unit tests for each formatter's tag display logic
  - Edge cases: no tags, single tag, multiple tags, long tag lists
  - Integration with existing table rendering

- **Planned Artefacts**:
  - VT-018-001: Unit tests for decision_formatters tag column
  - VT-018-002: Unit tests for spec_formatters tag column
  - VT-018-003: Unit tests for change_formatters tag column
  - VT-018-004: Unit tests for requirement_formatters tag column
  - VT-018-005: Unit tests for backlog_formatters tag column
  - VA-018-001: Visual consistency review across all list commands

- **Acceptance Criteria**:
  - [ ] All five formatters display Tags column in table output
  - [ ] Tags displayed as comma-separated list or empty string
  - [ ] Column widths adjust properly with tags included
  - [ ] All new tests pass (`just test`)
  - [ ] Linters pass (`just lint` + `just pylint`)
  - [ ] Visual consistency verified across artifact types

## 7. Risks & Mitigations
- **Risk**: Column width calculations may need adjustment for tag column
  - *Likelihood*: Low – *Impact*: Low
  - *Mitigation*: Follow DE-010 pattern which handled this correctly
- **Risk**: Long tag lists may cause wrapping issues
  - *Likelihood*: Low – *Impact*: Low
  - *Mitigation*: Test with multiple tags; consider truncation if needed (like title column)

## 8. Follow-ups & Tracking
- **Future Phases / Deltas**: None anticipated
- **Backlog Items**: ISSUE-017 – Resolved by this delta
- **Open Decisions / Questions**: None

## 9. Implementation Notes
- **Pattern to follow** (from DE-010):
  ```python
  # In _format_as_table():
  columns = ["ID", "Title", "Status", "Tags", "Updated"]

  # In _prepare_*_row():
  tags_str = ", ".join(artifact.tags) if artifact.tags else ""

  # In _calculate_column_widths():
  # Add tags column to width calculations
  ```
- **Testing approach**: Test no tags, single tag, multiple tags, very long tags
- **Commands to verify**:
  - `uv run spec-driver list adrs`
  - `uv run spec-driver list specs`
  - `uv run spec-driver list deltas`
  - `uv run spec-driver list requirements`
  - `just test`
  - `just lint`
