---
id: DR-018
slug: add-tags-column-to-list-table-output-for-all-artifact-types
name: Design Revision - Add Tags column to list table output for all artifact types
created: '2025-11-04'
updated: '2025-11-04'
status: draft
kind: design_revision
aliases: []
owners: []
relations:
- type: implements
  target: DE-018
delta_ref: DE-018
source_context: []
code_impacts: []
verification_alignment: []
design_decisions: []
open_questions: []
---

# DR-018 – Add Tags column to list table output for all artifact types

## 1. Executive Summary
- **Delta**: [DE-018](./DE-018.md)
- **Status**: draft
- **Owners / Team**: Agent-driven
- **Last Updated**: 2025-11-04
- **Synopsis**: Extend table formatters to display Tags column for improved tag discoverability

## 2. Problem & Constraints
- **Current Behaviour**: All list commands support `--tag` filtering but table output omits Tags column, forcing users to use `--json` or `show` commands to discover available tags
- **Drivers / Inputs**: [ISSUE-017](../../../backlog/issues/ISSUE-017-add-tags-column-to-list-table-output-for-all-artifact-types/ISSUE-017.md) – UX discoverability gap; DE-010 established pattern
- **Constraints / Guardrails**: Follow existing DE-010 pattern; no new abstractions per architectural principle (avoid premature abstraction)
- **Out of Scope**: Changes to policy/standard formatters (already fixed); JSON output (already includes tags); tag filtering logic (already implemented)

## 3. Architecture Intent
- **Target Outcomes**:
  - Consistent Tags column across all artifact list outputs
  - Follow pure function pattern from SPEC-120 (formatters)
  - Maintain thin CLI pattern from SPEC-110
- **Guiding Principles**: Pure formatters, no business logic in display code, reuse existing patterns
- **State Transitions / Lifecycle Impact**: None – display-only change

## 4. Code Impact Summary
| Path | Current State | Target State |
| --- | --- | --- |
| `supekku/scripts/lib/formatters/decision_formatters.py` | Table columns: ID, Title, Status, Updated | Table columns: ID, Title, Status, Tags, Updated |
| `supekku/scripts/lib/formatters/spec_formatters.py` | Table columns: ID, Name, Status, Updated | Table columns: ID, Name, Status, Tags, Updated |
| `supekku/scripts/lib/formatters/change_formatters.py` | Table columns: ID, Kind, Status, Name, Updated | Table columns: ID, Kind, Status, Tags, Name, Updated |
| `supekku/scripts/lib/formatters/requirement_formatters.py` | Table columns: ID, Type, Status, Name | Table columns: ID, Type, Status, Tags, Name |
| `supekku/scripts/lib/formatters/backlog_formatters.py` | Table columns: ID, Kind, Severity, Name | Table columns: ID, Kind, Severity, Tags, Name |

## 5. Verification Alignment
| Verification | Impact | Notes |
| --- | --- | --- |
| VT-018-001 | new | Unit tests for decision_formatters tag display |
| VT-018-002 | new | Unit tests for spec_formatters tag display |
| VT-018-003 | new | Unit tests for change_formatters tag display |
| VT-018-004 | new | Unit tests for requirement_formatters tag display |
| VT-018-005 | new | Unit tests for backlog_formatters tag display |
| VA-018-001 | new | Visual consistency review across artifact types |

## 6. Supporting Context
- **Related Deltas / Specs**:
  - DE-010 – Established pattern for policy/standard formatters
  - SPEC-110 – CLI orchestration specification
  - SPEC-120 – Formatters specification (pure functions)

## 7. Design Decisions & Trade-offs
- **Decision**: Reuse DE-010 pattern rather than create abstraction
  - **Rationale**: Architectural principle "avoid premature abstraction" - only 2 examples (DE-010 + this delta), need 3+ before extracting shared utility
  - **Consequence**: Some code duplication across formatters, but maintains clarity and simplicity
  - **Trade-off**: Accept duplication now for flexibility; extract shared utility only when clear pattern emerges
- **Decision**: Tags column placement varies by formatter
  - **Rationale**: Different artifacts have different column priorities (e.g., deltas have "Kind", requirements don't)
  - **Consequence**: Tags placement optimized per artifact type rather than enforcing uniform position

## 8. Open Questions
None

## 9. Rollout & Operational Notes
- **Migration / Backfill**: None required – purely additive display change
- **Observability / Alerts**: N/A – CLI output change only
- **Recovery / Rollback**: Git revert if issues; no data changes

## 10. References & Links
- Pattern source: `supekku/scripts/lib/formatters/policy_formatters.py` (DE-010)
- Pattern source: `supekku/scripts/lib/formatters/standard_formatters.py` (DE-010)
- Issue: [ISSUE-017](../../../backlog/issues/ISSUE-017-add-tags-column-to-list-table-output-for-all-artifact-types/ISSUE-017.md)
