"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticMapReduceMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class ElasticMapReduceMetrics {
    static jobsRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'JobsRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static jobsFailedAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'JobsFailed',
            dimensions,
            statistic: 'Average',
        };
    }
    static isIdleAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'IsIdle',
            dimensions,
            statistic: 'Average',
        };
    }
    static mapTasksRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MapTasksRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static mapTasksRemainingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MapTasksRemaining',
            dimensions,
            statistic: 'Average',
        };
    }
    static mapSlotsOpenAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MapSlotsOpen',
            dimensions,
            statistic: 'Average',
        };
    }
    static remainingMapTasksPerSlotAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'RemainingMapTasksPerSlot',
            dimensions,
            statistic: 'Average',
        };
    }
    static reduceTasksRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'ReduceTasksRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static reduceTasksRemainingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'ReduceTasksRemaining',
            dimensions,
            statistic: 'Average',
        };
    }
    static reduceSlotsOpenAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'ReduceSlotsOpen',
            dimensions,
            statistic: 'Average',
        };
    }
    static coreNodesRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'CoreNodesRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static coreNodesPendingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'CoreNodesPending',
            dimensions,
            statistic: 'Average',
        };
    }
    static liveDataNodesAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'LiveDataNodes',
            dimensions,
            statistic: 'Average',
        };
    }
    static taskNodesRunningAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TaskNodesRunning',
            dimensions,
            statistic: 'Average',
        };
    }
    static taskNodesPendingAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TaskNodesPending',
            dimensions,
            statistic: 'Average',
        };
    }
    static liveTaskTrackersAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'LiveTaskTrackers',
            dimensions,
            statistic: 'Average',
        };
    }
    static s3BytesWrittenSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'S3BytesWritten',
            dimensions,
            statistic: 'Sum',
        };
    }
    static s3BytesReadSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'S3BytesRead',
            dimensions,
            statistic: 'Sum',
        };
    }
    static hdfsUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'HDFSUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static hdfsBytesReadSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'HDFSBytesRead',
            dimensions,
            statistic: 'Sum',
        };
    }
    static hdfsBytesWrittenSum(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'HDFSBytesWritten',
            dimensions,
            statistic: 'Sum',
        };
    }
    static missingBlocksAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MissingBlocks',
            dimensions,
            statistic: 'Average',
        };
    }
    static totalLoadAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TotalLoad',
            dimensions,
            statistic: 'Average',
        };
    }
    static backupFailedAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'BackupFailed',
            dimensions,
            statistic: 'Average',
        };
    }
    static mostRecentBackupDurationAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'MostRecentBackupDuration',
            dimensions,
            statistic: 'Average',
        };
    }
    static timeSinceLastSuccessfulBackupAverage(dimensions) {
        return {
            namespace: 'AWS/ElasticMapReduce',
            metricName: 'TimeSinceLastSuccessfulBackup',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.ElasticMapReduceMetrics = ElasticMapReduceMetrics;
//# sourceMappingURL=data:application/json;base64,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