import { IConstruct, Stack } from 'monocdk';
/**
 * Interface for creating a rule suppression.
 *
 * @stability stable
 */
export interface NagPackSuppression {
    /**
     * The id of the rule to ignore.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The reason to ignore the rule (minimum 10 characters).
     *
     * @stability stable
     */
    readonly reason: string;
}
/**
 * Helper class with methods to add cdk-nag suppressions to cdk resources.
 *
 * @stability stable
 */
export declare class NagSuppressions {
    /**
     * Apply cdk-nag suppressions to a Stack and optionally nested stacks.
     *
     * @param stack The Stack to apply the suppression to.
     * @param suppressions A list of suppressions to apply to the stack.
     * @param applyToNestedStacks Apply the suppressions to children stacks (default:false).
     * @stability stable
     */
    static addStackSuppressions(stack: Stack, suppressions: NagPackSuppression[], applyToNestedStacks?: boolean): void;
    /**
     * Add cdk-nag suppressions to a CfnResource and optionally its children.
     *
     * @param construct The IConstruct to apply the suppression to.
     * @param suppressions A list of suppressions to apply to the resource.
     * @param applyToChildren Apply the suppressions to children CfnResources  (default:false).
     * @stability stable
     */
    static addResourceSuppressions(construct: IConstruct, suppressions: NagPackSuppression[], applyToChildren?: boolean): void;
    /**
     * Add cdk-nag suppressions to a CfnResource and optionally its children via its path.
     *
     * @param stack The Stack the construct belongs to.
     * @param path The path to the construct in the provided stack.
     * @param suppressions A list of suppressions to apply to the resource.
     * @param applyToChildren Apply the suppressions to children CfnResources  (default:false).
     * @stability stable
     */
    static addResourceSuppressionsByPath(stack: Stack, path: string, suppressions: NagPackSuppression[], applyToChildren?: boolean): void;
}
