"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_athena_1 = require("monocdk/aws-athena");
const monocdk_1 = require("monocdk");
const nag_rules_1 = require("../../nag-rules");
/**
 * Athena workgroups encrypt query results
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_athena_1.CfnWorkGroup) {
        const workGroupConfiguration = monocdk_1.Stack.of(node).resolve(node.workGroupConfiguration);
        if (workGroupConfiguration == undefined) {
            const workGroupConfigurationUpdates = monocdk_1.Stack.of(node).resolve(node.workGroupConfigurationUpdates);
            if (workGroupConfigurationUpdates == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const resultConfigurationUpdates = monocdk_1.Stack.of(node).resolve(workGroupConfigurationUpdates.resultConfigurationUpdates);
            if (resultConfigurationUpdates != undefined) {
                const removeEncryptionConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, resultConfigurationUpdates.removeEncryptionConfiguration);
                const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfigurationUpdates.encryptionConfiguration);
                const enforceWorkGroupConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, workGroupConfigurationUpdates.enforceWorkGroupConfiguration);
                if (removeEncryptionConfiguration &&
                    encryptionConfiguration == undefined) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
                else if (encryptionConfiguration != undefined &&
                    !enforceWorkGroupConfiguration) {
                    return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
                }
            }
        }
        else {
            const enforceWorkGroupConfiguration = nag_rules_1.NagRules.resolveIfPrimitive(node, workGroupConfiguration.enforceWorkGroupConfiguration);
            if (!enforceWorkGroupConfiguration) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const resultConfiguration = monocdk_1.Stack.of(node).resolve(workGroupConfiguration.resultConfiguration);
            if (resultConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
            const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfiguration.encryptionConfiguration);
            if (encryptionConfiguration == undefined) {
                return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
            }
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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