# scikit-keras
Scikit-learn-compatible Keras models

## Status
[![Build Status](https://travis-ci.org/daviddiazvico/scikit-keras.svg?branch=master)](https://travis-ci.org/daviddiazvico/scikit-keras)
[![Coverage Status](https://coveralls.io/repos/github/daviddiazvico/scikit-keras/badge.svg)](https://coveralls.io/github/daviddiazvico/scikit-keras)
[![Maintainability](https://api.codeclimate.com/v1/badges/a37c9ee152b41a0cb577/maintainability)](https://codeclimate.com/github/daviddiazvico/scikit-keras/maintainability)
[![Test Coverage](https://api.codeclimate.com/v1/badges/a37c9ee152b41a0cb577/test_coverage)](https://codeclimate.com/github/daviddiazvico/scikit-keras/test_coverage)
[![Code Health](https://landscape.io/github/daviddiazvico/scikit-keras/master/landscape.svg?style=flat)](https://landscape.io/github/daviddiazvico/scikit-keras/master)
[![Documentation Status](https://readthedocs.org/projects/scikit-keras/badge/?version=latest)](http://scikit-keras.readthedocs.io/en/latest/?badge=latest)

![Anaconda Cloud](https://anaconda.org/daviddiazvico/scikit-keras/badges/version.svg)
![license](https://anaconda.org/daviddiazvico/scikit-keras/badges/license.svg)
![downloads](https://anaconda.org/daviddiazvico/scikit-keras/badges/downloads.svg)
![Install with](https://anaconda.org/daviddiazvico/scikit-keras/badges/installer/conda.svg)

## Installation
Available in [PyPI](https://pypi.python.org/pypi?:action=display&name=scikit-keras)
```
pip install scikit-keras
```
and [Anaconda Cloud](https://anaconda.org/daviddiazvico/scikit-keras)
```
conda install -c daviddiazvico scikit-keras
```

## Documentation
To generate the documentation, go to the docs subfolder and run
```
sphinx-apidoc -o . ../skkeras/
make html
```

## Distribution
Run the following command from the project home to upload the package to [testPyPI](https://testpypi.python.org/)
```
python setup.py sdist upload -r testpypi
```
or [PyPI](https://pypi.python.org/)
```
python setup.py sdist upload -r pypi
```
Then, you can also upload to [Anaconda Cloud](https://anaconda.org/). Install [conda-build](https://anaconda.org/anaconda/conda-build) and [anaconda-client](https://anaconda.org/anaconda/anaconda-client), go to ~, and run
```
conda skeleton pypi scikit-keras
conda-build scikit-keras
anaconda login
anaconda upload <TEST END generated by conda-build>
```

## Citation
If you find scikit-keras useful, please cite it in your publications. You can use this [BibTeX](http://www.bibtex.org/) entry:
```
@misc{scikit-keras,
      title={scikit-keras},
      author={Diaz-Vico, David},
      year={2017},
      publisher={GitHub},
      howpublished={\url{https://github.com/daviddiazvico/scikit-keras}}}
```