# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 features: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 router: pulumi.Input['GatewayRouterArgs'],
                 zone: pulumi.Input[_builtins.str],
                 address: Optional[pulumi.Input['GatewayAddressArgs']] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] features: Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        :param pulumi.Input['GatewayRouterArgs'] router: Attached Router from where traffic is routed towards the network gateway service.
        :param pulumi.Input[_builtins.str] zone: Zone in which the gateway will be hosted, e.g. `de-fra1`.
        :param pulumi.Input['GatewayAddressArgs'] address: IP addresses assigned to the gateway.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the network gateway.
        :param pulumi.Input[_builtins.str] name: Gateway name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] plan: Gateway pricing plan.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "router", router)
        pulumi.set(__self__, "zone", zone)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if configured_status is not None:
            pulumi.set(__self__, "configured_status", configured_status)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Input['GatewayRouterArgs']:
        """
        Attached Router from where traffic is routed towards the network gateway service.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input['GatewayRouterArgs']):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        Zone in which the gateway will be hosted, e.g. `de-fra1`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['GatewayAddressArgs']]:
        """
        IP addresses assigned to the gateway.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['GatewayAddressArgs']]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @configured_status.setter
    def configured_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configured_status", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the network gateway.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway name. Needs to be unique within the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway pricing plan.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input['GatewayAddressArgs']] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayAddressArgs']]]] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operational_state: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input['GatewayRouterArgs']] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input['GatewayAddressArgs'] address: IP addresses assigned to the gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayAddressArgs']]] addresses: IP addresses assigned to the gateway.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connections: Names of connections attached to the gateway. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] features: Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the network gateway.
        :param pulumi.Input[_builtins.str] name: Gateway name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] operational_state: The service operational state indicates the service's current operational, effective state. Managed by the system.
        :param pulumi.Input[_builtins.str] plan: Gateway pricing plan.
        :param pulumi.Input['GatewayRouterArgs'] router: Attached Router from where traffic is routed towards the network gateway service.
        :param pulumi.Input[_builtins.str] zone: Zone in which the gateway will be hosted, e.g. `de-fra1`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if addresses is not None:
            warnings.warn("""Use 'address' attribute instead. This attribute will be removed in the next major version of the provider""", DeprecationWarning)
            pulumi.log.warn("""addresses is deprecated: Use 'address' attribute instead. This attribute will be removed in the next major version of the provider""")
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if configured_status is not None:
            pulumi.set(__self__, "configured_status", configured_status)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operational_state is not None:
            pulumi.set(__self__, "operational_state", operational_state)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['GatewayAddressArgs']]:
        """
        IP addresses assigned to the gateway.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['GatewayAddressArgs']]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use 'address' attribute instead. This attribute will be removed in the next major version of the provider""")
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayAddressArgs']]]]:
        """
        IP addresses assigned to the gateway.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @configured_status.setter
    def configured_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configured_status", value)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Names of connections attached to the gateway. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connections", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the network gateway.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway name. Needs to be unique within the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service operational state indicates the service's current operational, effective state. Managed by the system.
        """
        return pulumi.get(self, "operational_state")

    @operational_state.setter
    def operational_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operational_state", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway pricing plan.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input['GatewayRouterArgs']]:
        """
        Attached Router from where traffic is routed towards the network gateway service.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input['GatewayRouterArgs']]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone in which the gateway will be hosted, e.g. `de-fra1`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']]] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[Union['GatewayRouterArgs', 'GatewayRouterArgsDict']]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Network gateways connect SDN Private Networks to external IP networks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create router for the gateway
        this = upcloud.Router("this", name="gateway-example-router")
        # Create network for the gateway
        this_network = upcloud.Network("this",
            name="gateway-example-net",
            zone="pl-waw1",
            ip_network={
                "address": "172.16.2.0/24",
                "dhcp": True,
                "family": "IPv4",
            },
            router=this.id)
        this_gateway = upcloud.Gateway("this",
            name="gateway-example-gw",
            zone="pl-waw1",
            features=["nat"],
            router={
                "id": this.id,
            },
            labels={
                "managed-by": "terraform",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']] address: IP addresses assigned to the gateway.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] features: Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the network gateway.
        :param pulumi.Input[_builtins.str] name: Gateway name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] plan: Gateway pricing plan.
        :param pulumi.Input[Union['GatewayRouterArgs', 'GatewayRouterArgsDict']] router: Attached Router from where traffic is routed towards the network gateway service.
        :param pulumi.Input[_builtins.str] zone: Zone in which the gateway will be hosted, e.g. `de-fra1`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Network gateways connect SDN Private Networks to external IP networks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create router for the gateway
        this = upcloud.Router("this", name="gateway-example-router")
        # Create network for the gateway
        this_network = upcloud.Network("this",
            name="gateway-example-net",
            zone="pl-waw1",
            ip_network={
                "address": "172.16.2.0/24",
                "dhcp": True,
                "family": "IPv4",
            },
            router=this.id)
        this_gateway = upcloud.Gateway("this",
            name="gateway-example-gw",
            zone="pl-waw1",
            features=["nat"],
            router={
                "id": this.id,
            },
            labels={
                "managed-by": "terraform",
            })
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']]] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[Union['GatewayRouterArgs', 'GatewayRouterArgsDict']]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["configured_status"] = configured_status
            if features is None and not opts.urn:
                raise TypeError("Missing required property 'features'")
            __props__.__dict__["features"] = features
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["plan"] = plan
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["addresses"] = None
            __props__.__dict__["connections"] = None
            __props__.__dict__["operational_state"] = None
        super(Gateway, __self__).__init__(
            'upcloud:index/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']]] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']]]]] = None,
            configured_status: Optional[pulumi.Input[_builtins.str]] = None,
            connections: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            operational_state: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            router: Optional[pulumi.Input[Union['GatewayRouterArgs', 'GatewayRouterArgsDict']]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']] address: IP addresses assigned to the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayAddressArgs', 'GatewayAddressArgsDict']]]] addresses: IP addresses assigned to the gateway.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connections: Names of connections attached to the gateway. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] features: Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the network gateway.
        :param pulumi.Input[_builtins.str] name: Gateway name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] operational_state: The service operational state indicates the service's current operational, effective state. Managed by the system.
        :param pulumi.Input[_builtins.str] plan: Gateway pricing plan.
        :param pulumi.Input[Union['GatewayRouterArgs', 'GatewayRouterArgsDict']] router: Attached Router from where traffic is routed towards the network gateway service.
        :param pulumi.Input[_builtins.str] zone: Zone in which the gateway will be hosted, e.g. `de-fra1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["address"] = address
        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["configured_status"] = configured_status
        __props__.__dict__["connections"] = connections
        __props__.__dict__["features"] = features
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["operational_state"] = operational_state
        __props__.__dict__["plan"] = plan
        __props__.__dict__["router"] = router
        __props__.__dict__["zone"] = zone
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output['outputs.GatewayAddress']:
        """
        IP addresses assigned to the gateway.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use 'address' attribute instead. This attribute will be removed in the next major version of the provider""")
    def addresses(self) -> pulumi.Output[Sequence['outputs.GatewayAddress']]:
        """
        IP addresses assigned to the gateway.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Names of connections attached to the gateway. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Features enabled for the gateway. Note that VPN feature is currently in beta, for more details see https://upcloud.com/resources/docs/networking#nat-and-vpn-gateways.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User defined key-value pairs to classify the network gateway.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Gateway name. Needs to be unique within the account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> pulumi.Output[_builtins.str]:
        """
        The service operational state indicates the service's current operational, effective state. Managed by the system.
        """
        return pulumi.get(self, "operational_state")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        Gateway pricing plan.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Output['outputs.GatewayRouter']:
        """
        Attached Router from where traffic is routed towards the network gateway service.
        """
        return pulumi.get(self, "router")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Zone in which the gateway will be hosted, e.g. `de-fra1`.
        """
        return pulumi.get(self, "zone")

