# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayConnectionArgs', 'GatewayConnection']

@pulumi.input_type
class GatewayConnectionArgs:
    def __init__(__self__, *,
                 gateway: pulumi.Input[_builtins.str],
                 local_routes: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_routes: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GatewayConnection resource.
        :param pulumi.Input[_builtins.str] gateway: The ID of the Gateway resource to which the connection belongs.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]] local_routes: Route for the UpCloud side of the network.
        :param pulumi.Input[_builtins.str] name: The name of the connection, should be unique within the gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]] remote_routes: Route for the remote side of the network.
        :param pulumi.Input[_builtins.str] type: The type of the connection; currently the only supported type is 'ipsec'.
        """
        pulumi.set(__self__, "gateway", gateway)
        if local_routes is not None:
            pulumi.set(__self__, "local_routes", local_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_routes is not None:
            pulumi.set(__self__, "remote_routes", remote_routes)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Gateway resource to which the connection belongs.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="localRoutes")
    def local_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]]]:
        """
        Route for the UpCloud side of the network.
        """
        return pulumi.get(self, "local_routes")

    @local_routes.setter
    def local_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]]]):
        pulumi.set(self, "local_routes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the connection, should be unique within the gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteRoutes")
    def remote_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]]]:
        """
        Route for the remote side of the network.
        """
        return pulumi.get(self, "remote_routes")

    @remote_routes.setter
    def remote_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]]]):
        pulumi.set(self, "remote_routes", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the connection; currently the only supported type is 'ipsec'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _GatewayConnectionState:
    def __init__(__self__, *,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 local_routes: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_routes: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]]] = None,
                 tunnels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GatewayConnection resources.
        :param pulumi.Input[_builtins.str] gateway: The ID of the Gateway resource to which the connection belongs.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]] local_routes: Route for the UpCloud side of the network.
        :param pulumi.Input[_builtins.str] name: The name of the connection, should be unique within the gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]] remote_routes: Route for the remote side of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tunnels: List of connection's tunnels names. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        :param pulumi.Input[_builtins.str] type: The type of the connection; currently the only supported type is 'ipsec'.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the connection
        """
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if local_routes is not None:
            pulumi.set(__self__, "local_routes", local_routes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_routes is not None:
            pulumi.set(__self__, "remote_routes", remote_routes)
        if tunnels is not None:
            pulumi.set(__self__, "tunnels", tunnels)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Gateway resource to which the connection belongs.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="localRoutes")
    def local_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]]]:
        """
        Route for the UpCloud side of the network.
        """
        return pulumi.get(self, "local_routes")

    @local_routes.setter
    def local_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionLocalRouteArgs']]]]):
        pulumi.set(self, "local_routes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the connection, should be unique within the gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteRoutes")
    def remote_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]]]:
        """
        Route for the remote side of the network.
        """
        return pulumi.get(self, "remote_routes")

    @remote_routes.setter
    def remote_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayConnectionRemoteRouteArgs']]]]):
        pulumi.set(self, "remote_routes", value)

    @_builtins.property
    @pulumi.getter
    def tunnels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of connection's tunnels names. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        """
        return pulumi.get(self, "tunnels")

    @tunnels.setter
    def tunnels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tunnels", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the connection; currently the only supported type is 'ipsec'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the connection
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("upcloud:index/gatewayConnection:GatewayConnection")
class GatewayConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 local_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionLocalRouteArgs', 'GatewayConnectionLocalRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionRemoteRouteArgs', 'GatewayConnectionRemoteRouteArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this = upcloud.Router("this", name="gateway-example-router")
        this_network = upcloud.Network("this",
            name="gateway-example-net",
            zone="pl-waw1",
            ip_network={
                "address": "172.16.2.0/24",
                "dhcp": True,
                "family": "IPv4",
            },
            router=this.id)
        this_gateway = upcloud.Gateway("this",
            name="gateway-example-gw",
            zone="pl-waw1",
            features=["vpn"],
            plan="advanced",
            router={
                "id": this.id,
            })
        this_gateway_connection = upcloud.GatewayConnection("this",
            gateway=this_gateway.id,
            name="test-connection",
            type="ipsec",
            local_routes=[{
                "name": "local-route",
                "type": "static",
                "static_network": "10.123.123.0/24",
            }],
            remote_routes=[{
                "name": "remote-route",
                "type": "static",
                "static_network": "100.123.123.0/24",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway: The ID of the Gateway resource to which the connection belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionLocalRouteArgs', 'GatewayConnectionLocalRouteArgsDict']]]] local_routes: Route for the UpCloud side of the network.
        :param pulumi.Input[_builtins.str] name: The name of the connection, should be unique within the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionRemoteRouteArgs', 'GatewayConnectionRemoteRouteArgsDict']]]] remote_routes: Route for the remote side of the network.
        :param pulumi.Input[_builtins.str] type: The type of the connection; currently the only supported type is 'ipsec'.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        this = upcloud.Router("this", name="gateway-example-router")
        this_network = upcloud.Network("this",
            name="gateway-example-net",
            zone="pl-waw1",
            ip_network={
                "address": "172.16.2.0/24",
                "dhcp": True,
                "family": "IPv4",
            },
            router=this.id)
        this_gateway = upcloud.Gateway("this",
            name="gateway-example-gw",
            zone="pl-waw1",
            features=["vpn"],
            plan="advanced",
            router={
                "id": this.id,
            })
        this_gateway_connection = upcloud.GatewayConnection("this",
            gateway=this_gateway.id,
            name="test-connection",
            type="ipsec",
            local_routes=[{
                "name": "local-route",
                "type": "static",
                "static_network": "10.123.123.0/24",
            }],
            remote_routes=[{
                "name": "remote-route",
                "type": "static",
                "static_network": "100.123.123.0/24",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param GatewayConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 local_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionLocalRouteArgs', 'GatewayConnectionLocalRouteArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionRemoteRouteArgs', 'GatewayConnectionRemoteRouteArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayConnectionArgs.__new__(GatewayConnectionArgs)

            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            __props__.__dict__["local_routes"] = local_routes
            __props__.__dict__["name"] = name
            __props__.__dict__["remote_routes"] = remote_routes
            __props__.__dict__["type"] = type
            __props__.__dict__["tunnels"] = None
            __props__.__dict__["uuid"] = None
        super(GatewayConnection, __self__).__init__(
            'upcloud:index/gatewayConnection:GatewayConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gateway: Optional[pulumi.Input[_builtins.str]] = None,
            local_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionLocalRouteArgs', 'GatewayConnectionLocalRouteArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            remote_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionRemoteRouteArgs', 'GatewayConnectionRemoteRouteArgsDict']]]]] = None,
            tunnels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'GatewayConnection':
        """
        Get an existing GatewayConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] gateway: The ID of the Gateway resource to which the connection belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionLocalRouteArgs', 'GatewayConnectionLocalRouteArgsDict']]]] local_routes: Route for the UpCloud side of the network.
        :param pulumi.Input[_builtins.str] name: The name of the connection, should be unique within the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GatewayConnectionRemoteRouteArgs', 'GatewayConnectionRemoteRouteArgsDict']]]] remote_routes: Route for the remote side of the network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tunnels: List of connection's tunnels names. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        :param pulumi.Input[_builtins.str] type: The type of the connection; currently the only supported type is 'ipsec'.
        :param pulumi.Input[_builtins.str] uuid: The UUID of the connection
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayConnectionState.__new__(_GatewayConnectionState)

        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["local_routes"] = local_routes
        __props__.__dict__["name"] = name
        __props__.__dict__["remote_routes"] = remote_routes
        __props__.__dict__["tunnels"] = tunnels
        __props__.__dict__["type"] = type
        __props__.__dict__["uuid"] = uuid
        return GatewayConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Gateway resource to which the connection belongs.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="localRoutes")
    def local_routes(self) -> pulumi.Output[Optional[Sequence['outputs.GatewayConnectionLocalRoute']]]:
        """
        Route for the UpCloud side of the network.
        """
        return pulumi.get(self, "local_routes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the connection, should be unique within the gateway.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="remoteRoutes")
    def remote_routes(self) -> pulumi.Output[Optional[Sequence['outputs.GatewayConnectionRemoteRoute']]]:
        """
        Route for the remote side of the network.
        """
        return pulumi.get(self, "remote_routes")

    @_builtins.property
    @pulumi.getter
    def tunnels(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of connection's tunnels names. Note that this field can have outdated information as connections are created by a separate resource. To make sure that you have the most recent data run 'terrafrom refresh'.
        """
        return pulumi.get(self, "tunnels")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the connection; currently the only supported type is 'ipsec'.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the connection
        """
        return pulumi.get(self, "uuid")

