# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHostsResult',
    'AwaitableGetHostsResult',
    'get_hosts',
    'get_hosts_output',
]

@pulumi.output_type
class GetHostsResult:
    """
    A collection of values returned by getHosts.
    """
    def __init__(__self__, hosts=None, id=None):
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.GetHostsHostResult']]:
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetHostsResult(GetHostsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostsResult(
            hosts=self.hosts,
            id=self.id)


def get_hosts(hosts: Optional[Sequence[Union['GetHostsHostArgs', 'GetHostsHostArgsDict']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostsResult:
    """
    Returns a list of available UpCloud hosts.
    		A host identifies the host server that virtual machines are run on.
    		Only hosts on private cloud to which the calling account has access to are available through this resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_upcloud as upcloud

    all_hosts = upcloud.get_hosts()
    ```
    """
    __args__ = dict()
    __args__['hosts'] = hosts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('upcloud:index/getHosts:getHosts', __args__, opts=opts, typ=GetHostsResult).value

    return AwaitableGetHostsResult(
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'))
def get_hosts_output(hosts: Optional[pulumi.Input[Optional[Sequence[Union['GetHostsHostArgs', 'GetHostsHostArgsDict']]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostsResult]:
    """
    Returns a list of available UpCloud hosts.
    		A host identifies the host server that virtual machines are run on.
    		Only hosts on private cloud to which the calling account has access to are available through this resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_upcloud as upcloud

    all_hosts = upcloud.get_hosts()
    ```
    """
    __args__ = dict()
    __args__['hosts'] = hosts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('upcloud:index/getHosts:getHosts', __args__, opts=opts, typ=GetHostsResult)
    return __ret__.apply(lambda __response__: GetHostsResult(
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id')))
