# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[_builtins.str],
                 zone: pulumi.Input[_builtins.str],
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[_builtins.str] plan: Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the load balancer.
        :param pulumi.Input[_builtins.str] maintenance_dow: The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        :param pulumi.Input[_builtins.str] maintenance_time: The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        :param pulumi.Input[_builtins.str] name: The name of the service. Must be unique within customer account.
        :param pulumi.Input[_builtins.str] network: Private network UUID where traffic will be routed. Must reside in load balancer zone.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]] networks: Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "zone", zone)
        if configured_status is not None:
            pulumi.set(__self__, "configured_status", configured_status)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            warnings.warn("""Use 'networks' to define networks attached to load balancer""", DeprecationWarning)
            pulumi.log.warn("""network is deprecated: Use 'networks' to define networks attached to load balancer""")
        if network is not None:
            pulumi.set(__self__, "network", network)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @configured_status.setter
    def configured_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configured_status", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the load balancer.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        """
        return pulumi.get(self, "maintenance_dow")

    @maintenance_dow.setter
    def maintenance_dow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_dow", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use 'networks' to define networks attached to load balancer""")
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network UUID where traffic will be routed. Must reside in load balancer zone.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]]:
        """
        Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 frontends: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNodeArgs']]]] = None,
                 operational_state: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backends: Backends are groups of customer servers whose traffic should be balanced.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[_builtins.str] dns_name: DNS name of the load balancer
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] frontends: Frontends receive the traffic before dispatching it to the backends.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the load balancer.
        :param pulumi.Input[_builtins.str] maintenance_dow: The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        :param pulumi.Input[_builtins.str] maintenance_time: The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        :param pulumi.Input[_builtins.str] name: The name of the service. Must be unique within customer account.
        :param pulumi.Input[_builtins.str] network: Private network UUID where traffic will be routed. Must reside in load balancer zone.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]] networks: Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerNodeArgs']]] nodes: Nodes are instances running load balancer service
        :param pulumi.Input[_builtins.str] operational_state: The service operational state indicates the service's current operational, effective state. Managed by the system.
        :param pulumi.Input[_builtins.str] plan: Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resolvers: Domain Name Resolvers.
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if configured_status is not None:
            pulumi.set(__self__, "configured_status", configured_status)
        if dns_name is not None:
            warnings.warn("""Use 'networks' to get network DNS name""", DeprecationWarning)
            pulumi.log.warn("""dns_name is deprecated: Use 'networks' to get network DNS name""")
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if frontends is not None:
            pulumi.set(__self__, "frontends", frontends)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_dow is not None:
            pulumi.set(__self__, "maintenance_dow", maintenance_dow)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            warnings.warn("""Use 'networks' to define networks attached to load balancer""", DeprecationWarning)
            pulumi.log.warn("""network is deprecated: Use 'networks' to define networks attached to load balancer""")
        if network is not None:
            pulumi.set(__self__, "network", network)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if operational_state is not None:
            pulumi.set(__self__, "operational_state", operational_state)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if resolvers is not None:
            pulumi.set(__self__, "resolvers", resolvers)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Backends are groups of customer servers whose traffic should be balanced.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backends", value)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @configured_status.setter
    def configured_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configured_status", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    @_utilities.deprecated("""Use 'networks' to get network DNS name""")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS name of the load balancer
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter
    def frontends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Frontends receive the traffic before dispatching it to the backends.
        """
        return pulumi.get(self, "frontends")

    @frontends.setter
    def frontends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "frontends", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the load balancer.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        """
        return pulumi.get(self, "maintenance_dow")

    @maintenance_dow.setter
    def maintenance_dow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_dow", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        """
        return pulumi.get(self, "maintenance_time")

    @maintenance_time.setter
    def maintenance_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use 'networks' to define networks attached to load balancer""")
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network UUID where traffic will be routed. Must reside in load balancer zone.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]]:
        """
        Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNodeArgs']]]]:
        """
        Nodes are instances running load balancer service
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service operational state indicates the service's current operational, effective state. Managed by the system.
        """
        return pulumi.get(self, "operational_state")

    @operational_state.setter
    def operational_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operational_state", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def resolvers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domain Name Resolvers.
        """
        return pulumi.get(self, "resolvers")

    @resolvers.setter
    def resolvers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resolvers", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/loadbalancer:Loadbalancer")
class Loadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource represents [Managed Load Balancer](https://upcloud.com/products/managed-load-balancer) service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            networks=[
                {
                    "name": "Private-Net",
                    "type": "private",
                    "family": "IPv4",
                    "network": upcloud_network["lbNetwork"]["id"],
                },
                {
                    "name": "Public-Net",
                    "type": "public",
                    "family": "IPv4",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the load balancer.
        :param pulumi.Input[_builtins.str] maintenance_dow: The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        :param pulumi.Input[_builtins.str] maintenance_time: The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        :param pulumi.Input[_builtins.str] name: The name of the service. Must be unique within customer account.
        :param pulumi.Input[_builtins.str] network: Private network UUID where traffic will be routed. Must reside in load balancer zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]] networks: Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        :param pulumi.Input[_builtins.str] plan: Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents [Managed Load Balancer](https://upcloud.com/products/managed-load-balancer) service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            networks=[
                {
                    "name": "Private-Net",
                    "type": "private",
                    "family": "IPv4",
                    "network": upcloud_network["lbNetwork"]["id"],
                },
                {
                    "name": "Public-Net",
                    "type": "public",
                    "family": "IPv4",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["configured_status"] = configured_status
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_dow"] = maintenance_dow
            __props__.__dict__["maintenance_time"] = maintenance_time
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["networks"] = networks
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["backends"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["frontends"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["operational_state"] = None
            __props__.__dict__["resolvers"] = None
        super(Loadbalancer, __self__).__init__(
            'upcloud:index/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configured_status: Optional[pulumi.Input[_builtins.str]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            frontends: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_dow: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNodeArgs', 'LoadbalancerNodeArgsDict']]]]] = None,
            operational_state: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backends: Backends are groups of customer servers whose traffic should be balanced.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[_builtins.str] dns_name: DNS name of the load balancer
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] frontends: Frontends receive the traffic before dispatching it to the backends.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the load balancer.
        :param pulumi.Input[_builtins.str] maintenance_dow: The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        :param pulumi.Input[_builtins.str] maintenance_time: The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        :param pulumi.Input[_builtins.str] name: The name of the service. Must be unique within customer account.
        :param pulumi.Input[_builtins.str] network: Private network UUID where traffic will be routed. Must reside in load balancer zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNetworkArgs', 'LoadbalancerNetworkArgsDict']]]] networks: Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerNodeArgs', 'LoadbalancerNodeArgsDict']]]] nodes: Nodes are instances running load balancer service
        :param pulumi.Input[_builtins.str] operational_state: The service operational state indicates the service's current operational, effective state. Managed by the system.
        :param pulumi.Input[_builtins.str] plan: Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resolvers: Domain Name Resolvers.
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["backends"] = backends
        __props__.__dict__["configured_status"] = configured_status
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["frontends"] = frontends
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_dow"] = maintenance_dow
        __props__.__dict__["maintenance_time"] = maintenance_time
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["networks"] = networks
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["operational_state"] = operational_state
        __props__.__dict__["plan"] = plan
        __props__.__dict__["resolvers"] = resolvers
        __props__.__dict__["zone"] = zone
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Backends are groups of customer servers whose traffic should be balanced.
        """
        return pulumi.get(self, "backends")

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> pulumi.Output[_builtins.str]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    @_utilities.deprecated("""Use 'networks' to get network DNS name""")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        DNS name of the load balancer
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter
    def frontends(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Frontends receive the traffic before dispatching it to the backends.
        """
        return pulumi.get(self, "frontends")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User defined key-value pairs to classify the load balancer.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceDow")
    def maintenance_dow(self) -> pulumi.Output[_builtins.str]:
        """
        The day of the week on which maintenance will be performed. If not provided, we will randomly select a weekend day. Valid values `monday|tuesday|wednesday|thursday|friday|saturday|sunday`.
        """
        return pulumi.get(self, "maintenance_dow")

    @_builtins.property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the maintenance will begin in UTC. A 2-hour timeframe has been allocated for maintenance. During this period, the multi-node production plans will not experience any downtime, while the one-node plans will have a downtime of 1-2 minutes. If not provided, we will randomly select an off-peak time. Needs to be a valid time format in UTC HH:MM:SSZ, for example `20:01:01Z`.
        """
        return pulumi.get(self, "maintenance_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use 'networks' to define networks attached to load balancer""")
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        Private network UUID where traffic will be routed. Must reside in load balancer zone.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.LoadbalancerNetwork']]]:
        """
        Attached Networks from where traffic consumed and routed. Private networks must reside in loadbalancer zone.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.LoadbalancerNode']]:
        """
        Nodes are instances running load balancer service
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> pulumi.Output[_builtins.str]:
        """
        The service operational state indicates the service's current operational, effective state. Managed by the system.
        """
        return pulumi.get(self, "operational_state")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        Plan which the service will have. You can list available load balancer plans with `upctl loadbalancer plans`
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def resolvers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Domain Name Resolvers.
        """
        return pulumi.get(self, "resolvers")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

