# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LoadbalancerFrontendTlsConfigArgs', 'LoadbalancerFrontendTlsConfig']

@pulumi.input_type
class LoadbalancerFrontendTlsConfigArgs:
    def __init__(__self__, *,
                 certificate_bundle: pulumi.Input[_builtins.str],
                 frontend: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadbalancerFrontendTlsConfig resource.
        :param pulumi.Input[_builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the TLS config is connected.
        :param pulumi.Input[_builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        pulumi.set(__self__, "certificate_bundle", certificate_bundle)
        pulumi.set(__self__, "frontend", frontend)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> pulumi.Input[_builtins.str]:
        """
        Reference to certificate bundle ID.
        """
        return pulumi.get(self, "certificate_bundle")

    @certificate_bundle.setter
    def certificate_bundle(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_bundle", value)

    @_builtins.property
    @pulumi.getter
    def frontend(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the load balancer frontend to which the TLS config is connected.
        """
        return pulumi.get(self, "frontend")

    @frontend.setter
    def frontend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frontend", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the TLS config. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadbalancerFrontendTlsConfigState:
    def __init__(__self__, *,
                 certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerFrontendTlsConfig resources.
        :param pulumi.Input[_builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the TLS config is connected.
        :param pulumi.Input[_builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        if certificate_bundle is not None:
            pulumi.set(__self__, "certificate_bundle", certificate_bundle)
        if frontend is not None:
            pulumi.set(__self__, "frontend", frontend)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reference to certificate bundle ID.
        """
        return pulumi.get(self, "certificate_bundle")

    @certificate_bundle.setter
    def certificate_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_bundle", value)

    @_builtins.property
    @pulumi.getter
    def frontend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the load balancer frontend to which the TLS config is connected.
        """
        return pulumi.get(self, "frontend")

    @frontend.setter
    def frontend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frontend", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the TLS config. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("upcloud:index/loadbalancerFrontendTlsConfig:LoadbalancerFrontendTlsConfig")
class LoadbalancerFrontendTlsConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource represents frontend TLS config

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        lb_fe1_tls1 = upcloud.LoadbalancerFrontendTlsConfig("lb_fe_1_tls1",
            frontend=upcloud_loadbalancer_frontend["lbFe1"]["id"],
            name="lb-fe-1-tls1-test",
            certificate_bundle=upcloud_loadbalancer_manual_certificate_bundle["lb-cb-m1"]["id"])
        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb_cb_m1 = upcloud.LoadbalancerManualCertificateBundle("lb-cb-m1",
            name="lb-cb-m1-test",
            certificate="LS0tLS1CRUdJTiBDRVJ...",
            private_key="LS0tLS1CRUdJTiBQUkl...")
        lb_fe1 = upcloud.LoadbalancerFrontend("lb_fe_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-fe-1-test",
            mode="http",
            port=8080,
            default_backend_name=upcloud_loadbalancer_backend["lbBe1"]["name"])
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            network=upcloud_network["lbNetwork"]["id"])
        lb_be1 = upcloud.LoadbalancerBackend("lb_be_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-be-1-test")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the TLS config is connected.
        :param pulumi.Input[_builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerFrontendTlsConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents frontend TLS config

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        lb_fe1_tls1 = upcloud.LoadbalancerFrontendTlsConfig("lb_fe_1_tls1",
            frontend=upcloud_loadbalancer_frontend["lbFe1"]["id"],
            name="lb-fe-1-tls1-test",
            certificate_bundle=upcloud_loadbalancer_manual_certificate_bundle["lb-cb-m1"]["id"])
        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb_cb_m1 = upcloud.LoadbalancerManualCertificateBundle("lb-cb-m1",
            name="lb-cb-m1-test",
            certificate="LS0tLS1CRUdJTiBDRVJ...",
            private_key="LS0tLS1CRUdJTiBQUkl...")
        lb_fe1 = upcloud.LoadbalancerFrontend("lb_fe_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-fe-1-test",
            mode="http",
            port=8080,
            default_backend_name=upcloud_loadbalancer_backend["lbBe1"]["name"])
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            network=upcloud_network["lbNetwork"]["id"])
        lb_be1 = upcloud.LoadbalancerBackend("lb_be_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-be-1-test")
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerFrontendTlsConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerFrontendTlsConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerFrontendTlsConfigArgs.__new__(LoadbalancerFrontendTlsConfigArgs)

            if certificate_bundle is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_bundle'")
            __props__.__dict__["certificate_bundle"] = certificate_bundle
            if frontend is None and not opts.urn:
                raise TypeError("Missing required property 'frontend'")
            __props__.__dict__["frontend"] = frontend
            __props__.__dict__["name"] = name
        super(LoadbalancerFrontendTlsConfig, __self__).__init__(
            'upcloud:index/loadbalancerFrontendTlsConfig:LoadbalancerFrontendTlsConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_bundle: Optional[pulumi.Input[_builtins.str]] = None,
            frontend: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadbalancerFrontendTlsConfig':
        """
        Get an existing LoadbalancerFrontendTlsConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_bundle: Reference to certificate bundle ID.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the TLS config is connected.
        :param pulumi.Input[_builtins.str] name: The name of the TLS config. Must be unique within customer account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerFrontendTlsConfigState.__new__(_LoadbalancerFrontendTlsConfigState)

        __props__.__dict__["certificate_bundle"] = certificate_bundle
        __props__.__dict__["frontend"] = frontend
        __props__.__dict__["name"] = name
        return LoadbalancerFrontendTlsConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateBundle")
    def certificate_bundle(self) -> pulumi.Output[_builtins.str]:
        """
        Reference to certificate bundle ID.
        """
        return pulumi.get(self, "certificate_bundle")

    @_builtins.property
    @pulumi.getter
    def frontend(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the load balancer frontend to which the TLS config is connected.
        """
        return pulumi.get(self, "frontend")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the TLS config. Must be unique within customer account.
        """
        return pulumi.get(self, "name")

