# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GatewayAddress',
    'GatewayConnectionLocalRoute',
    'GatewayConnectionRemoteRoute',
    'GatewayConnectionTunnelIpsecAuthPsk',
    'GatewayConnectionTunnelIpsecProperties',
    'GatewayRouter',
    'KubernetesNodeGroupCloudNativePlan',
    'KubernetesNodeGroupCustomPlan',
    'KubernetesNodeGroupGpuPlan',
    'KubernetesNodeGroupKubeletArg',
    'KubernetesNodeGroupTaint',
    'LoadbalancerBackendProperties',
    'LoadbalancerFrontendNetwork',
    'LoadbalancerFrontendProperties',
    'LoadbalancerFrontendRuleActions',
    'LoadbalancerFrontendRuleActionsHttpRedirect',
    'LoadbalancerFrontendRuleActionsHttpReturn',
    'LoadbalancerFrontendRuleActionsSetForwardedHeader',
    'LoadbalancerFrontendRuleActionsSetRequestHeader',
    'LoadbalancerFrontendRuleActionsSetResponseHeader',
    'LoadbalancerFrontendRuleActionsTcpReject',
    'LoadbalancerFrontendRuleActionsUseBackend',
    'LoadbalancerFrontendRuleMatchers',
    'LoadbalancerFrontendRuleMatchersBodySize',
    'LoadbalancerFrontendRuleMatchersBodySizeRange',
    'LoadbalancerFrontendRuleMatchersCookie',
    'LoadbalancerFrontendRuleMatchersHeader',
    'LoadbalancerFrontendRuleMatchersHost',
    'LoadbalancerFrontendRuleMatchersHttpMethod',
    'LoadbalancerFrontendRuleMatchersHttpStatus',
    'LoadbalancerFrontendRuleMatchersHttpStatusRange',
    'LoadbalancerFrontendRuleMatchersNumMembersUp',
    'LoadbalancerFrontendRuleMatchersPath',
    'LoadbalancerFrontendRuleMatchersRequestHeader',
    'LoadbalancerFrontendRuleMatchersResponseHeader',
    'LoadbalancerFrontendRuleMatchersSrcIp',
    'LoadbalancerFrontendRuleMatchersSrcPort',
    'LoadbalancerFrontendRuleMatchersSrcPortRange',
    'LoadbalancerFrontendRuleMatchersUrl',
    'LoadbalancerFrontendRuleMatchersUrlParam',
    'LoadbalancerFrontendRuleMatchersUrlQuery',
    'LoadbalancerNetwork',
    'LoadbalancerNode',
    'LoadbalancerNodeNetwork',
    'LoadbalancerNodeNetworkIpAddress',
    'ManagedDatabaseMysqlComponent',
    'ManagedDatabaseMysqlNetwork',
    'ManagedDatabaseMysqlNodeState',
    'ManagedDatabaseMysqlProperties',
    'ManagedDatabaseMysqlPropertiesMigration',
    'ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup',
    'ManagedDatabaseOpensearchComponent',
    'ManagedDatabaseOpensearchNetwork',
    'ManagedDatabaseOpensearchNodeState',
    'ManagedDatabaseOpensearchProperties',
    'ManagedDatabaseOpensearchPropertiesAuthFailureListeners',
    'ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting',
    'ManagedDatabaseOpensearchPropertiesClusterRemoteStore',
    'ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlog',
    'ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlogThreshold',
    'ManagedDatabaseOpensearchPropertiesDiskWatermarks',
    'ManagedDatabaseOpensearchPropertiesIndexRollup',
    'ManagedDatabaseOpensearchPropertiesIndexTemplate',
    'ManagedDatabaseOpensearchPropertiesOpenid',
    'ManagedDatabaseOpensearchPropertiesOpensearchDashboards',
    'ManagedDatabaseOpensearchPropertiesRemoteStore',
    'ManagedDatabaseOpensearchPropertiesSaml',
    'ManagedDatabaseOpensearchPropertiesSearchBackpressure',
    'ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress',
    'ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask',
    'ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask',
    'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueries',
    'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu',
    'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency',
    'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory',
    'ManagedDatabaseOpensearchPropertiesSegrep',
    'ManagedDatabaseOpensearchPropertiesShardIndexingPressure',
    'ManagedDatabaseOpensearchPropertiesShardIndexingPressureOperatingFactor',
    'ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameter',
    'ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode',
    'ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard',
    'ManagedDatabasePostgresqlComponent',
    'ManagedDatabasePostgresqlNetwork',
    'ManagedDatabasePostgresqlNodeState',
    'ManagedDatabasePostgresqlProperties',
    'ManagedDatabasePostgresqlPropertiesMigration',
    'ManagedDatabasePostgresqlPropertiesPgaudit',
    'ManagedDatabasePostgresqlPropertiesPgbouncer',
    'ManagedDatabasePostgresqlPropertiesPglookout',
    'ManagedDatabasePostgresqlPropertiesTimescaledb',
    'ManagedDatabaseRedisComponent',
    'ManagedDatabaseRedisNetwork',
    'ManagedDatabaseRedisNodeState',
    'ManagedDatabaseRedisProperties',
    'ManagedDatabaseRedisPropertiesMigration',
    'ManagedDatabaseUserOpensearchAccessControl',
    'ManagedDatabaseUserOpensearchAccessControlRule',
    'ManagedDatabaseUserPgAccessControl',
    'ManagedDatabaseUserRedisAccessControl',
    'ManagedDatabaseUserValkeyAccessControl',
    'ManagedDatabaseValkeyComponent',
    'ManagedDatabaseValkeyNetwork',
    'ManagedDatabaseValkeyNodeState',
    'ManagedDatabaseValkeyProperties',
    'ManagedDatabaseValkeyPropertiesMigration',
    'ManagedObjectStorageEndpoint',
    'ManagedObjectStorageNetwork',
    'NetworkIpNetwork',
    'NetworkPeeringNetwork',
    'NetworkPeeringPeerNetwork',
    'ObjectStorageBucket',
    'RouterStaticRoute',
    'ServerFirewallRulesFirewallRule',
    'ServerLogin',
    'ServerNetworkInterface',
    'ServerNetworkInterfaceAdditionalIpAddress',
    'ServerSimpleBackup',
    'ServerStorageDevice',
    'ServerTemplate',
    'ServerTemplateBackupRule',
    'StorageBackupRule',
    'StorageClone',
    'StorageImport',
    'GetHostsHostResult',
    'GetHostsHostStatisticResult',
    'GetIpAddressesAddressResult',
    'GetManagedDatabaseMysqlSessionsSessionResult',
    'GetManagedDatabaseOpensearchIndicesIndexResult',
    'GetManagedDatabasePostgresqlSessionsSessionResult',
    'GetManagedDatabaseRedisSessionsSessionResult',
    'GetManagedDatabaseValkeySessionsSessionResult',
    'GetManagedObjectStoragePoliciesPolicyResult',
    'GetManagedObjectStorageRegionsRegionResult',
    'GetNetworksNetworkResult',
    'GetNetworksNetworkIpNetworkResult',
    'GetNetworksNetworkServerResult',
    'GetTagsTagResult',
]

@pulumi.output_type
class GatewayAddress(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: IP addresss
        :param _builtins.str name: Name of the IP address
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        IP addresss
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the IP address
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GatewayConnectionLocalRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "staticNetwork":
            suggest = "static_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayConnectionLocalRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayConnectionLocalRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayConnectionLocalRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 static_network: _builtins.str,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the route
        :param _builtins.str static_network: Destination prefix of the route; needs to be a valid IPv4 prefix
        :param _builtins.str type: Type of route; currently the only supported type is 'static'
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "static_network", static_network)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the route
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="staticNetwork")
    def static_network(self) -> _builtins.str:
        """
        Destination prefix of the route; needs to be a valid IPv4 prefix
        """
        return pulumi.get(self, "static_network")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of route; currently the only supported type is 'static'
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GatewayConnectionRemoteRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "staticNetwork":
            suggest = "static_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayConnectionRemoteRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayConnectionRemoteRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayConnectionRemoteRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 static_network: _builtins.str,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the route
        :param _builtins.str static_network: Destination prefix of the route; needs to be a valid IPv4 prefix
        :param _builtins.str type: Type of route; currently the only supported type is 'static'
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "static_network", static_network)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the route
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="staticNetwork")
    def static_network(self) -> _builtins.str:
        """
        Destination prefix of the route; needs to be a valid IPv4 prefix
        """
        return pulumi.get(self, "static_network")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of route; currently the only supported type is 'static'
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GatewayConnectionTunnelIpsecAuthPsk(dict):
    def __init__(__self__, *,
                 psk: _builtins.str):
        """
        :param _builtins.str psk: The pre-shared key. This value is only used during resource creation and is not returned in the state. It is not possible to update this value. If you need to update it, delete the connection and create a new one.
        """
        pulumi.set(__self__, "psk", psk)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> _builtins.str:
        """
        The pre-shared key. This value is only used during resource creation and is not returned in the state. It is not possible to update this value. If you need to update it, delete the connection and create a new one.
        """
        return pulumi.get(self, "psk")


@pulumi.output_type
class GatewayConnectionTunnelIpsecProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "childRekeyTime":
            suggest = "child_rekey_time"
        elif key == "dpdDelay":
            suggest = "dpd_delay"
        elif key == "dpdTimeout":
            suggest = "dpd_timeout"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "phase1Algorithms":
            suggest = "phase1_algorithms"
        elif key == "phase1DhGroupNumbers":
            suggest = "phase1_dh_group_numbers"
        elif key == "phase1IntegrityAlgorithms":
            suggest = "phase1_integrity_algorithms"
        elif key == "phase2Algorithms":
            suggest = "phase2_algorithms"
        elif key == "phase2DhGroupNumbers":
            suggest = "phase2_dh_group_numbers"
        elif key == "phase2IntegrityAlgorithms":
            suggest = "phase2_integrity_algorithms"
        elif key == "rekeyTime":
            suggest = "rekey_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayConnectionTunnelIpsecProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayConnectionTunnelIpsecProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayConnectionTunnelIpsecProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 child_rekey_time: Optional[_builtins.int] = None,
                 dpd_delay: Optional[_builtins.int] = None,
                 dpd_timeout: Optional[_builtins.int] = None,
                 ike_lifetime: Optional[_builtins.int] = None,
                 phase1_algorithms: Optional[Sequence[_builtins.str]] = None,
                 phase1_dh_group_numbers: Optional[Sequence[_builtins.int]] = None,
                 phase1_integrity_algorithms: Optional[Sequence[_builtins.str]] = None,
                 phase2_algorithms: Optional[Sequence[_builtins.str]] = None,
                 phase2_dh_group_numbers: Optional[Sequence[_builtins.int]] = None,
                 phase2_integrity_algorithms: Optional[Sequence[_builtins.str]] = None,
                 rekey_time: Optional[_builtins.int] = None):
        """
        :param _builtins.int child_rekey_time: IKE child SA rekey time in seconds.
        :param _builtins.int dpd_delay: Delay before sending Dead Peer Detection packets if no traffic is detected, in seconds.
        :param _builtins.int dpd_timeout: Timeout period for DPD reply before considering the peer to be dead, in seconds.
        :param _builtins.int ike_lifetime: Maximum IKE SA lifetime in seconds.
        :param Sequence[_builtins.str] phase1_algorithms: List of Phase 1: Proposal algorithms.
        :param Sequence[_builtins.int] phase1_dh_group_numbers: List of Phase 1 Diffie-Hellman group numbers.
        :param Sequence[_builtins.str] phase1_integrity_algorithms: List of Phase 1 integrity algorithms.
        :param Sequence[_builtins.str] phase2_algorithms: List of Phase 2: Security Association algorithms.
        :param Sequence[_builtins.int] phase2_dh_group_numbers: List of Phase 2 Diffie-Hellman group numbers.
        :param Sequence[_builtins.str] phase2_integrity_algorithms: List of Phase 2 integrity algorithms.
        :param _builtins.int rekey_time: IKE SA rekey time in seconds.
        """
        if child_rekey_time is not None:
            pulumi.set(__self__, "child_rekey_time", child_rekey_time)
        if dpd_delay is not None:
            pulumi.set(__self__, "dpd_delay", dpd_delay)
        if dpd_timeout is not None:
            pulumi.set(__self__, "dpd_timeout", dpd_timeout)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if phase1_algorithms is not None:
            pulumi.set(__self__, "phase1_algorithms", phase1_algorithms)
        if phase1_dh_group_numbers is not None:
            pulumi.set(__self__, "phase1_dh_group_numbers", phase1_dh_group_numbers)
        if phase1_integrity_algorithms is not None:
            pulumi.set(__self__, "phase1_integrity_algorithms", phase1_integrity_algorithms)
        if phase2_algorithms is not None:
            pulumi.set(__self__, "phase2_algorithms", phase2_algorithms)
        if phase2_dh_group_numbers is not None:
            pulumi.set(__self__, "phase2_dh_group_numbers", phase2_dh_group_numbers)
        if phase2_integrity_algorithms is not None:
            pulumi.set(__self__, "phase2_integrity_algorithms", phase2_integrity_algorithms)
        if rekey_time is not None:
            pulumi.set(__self__, "rekey_time", rekey_time)

    @_builtins.property
    @pulumi.getter(name="childRekeyTime")
    def child_rekey_time(self) -> Optional[_builtins.int]:
        """
        IKE child SA rekey time in seconds.
        """
        return pulumi.get(self, "child_rekey_time")

    @_builtins.property
    @pulumi.getter(name="dpdDelay")
    def dpd_delay(self) -> Optional[_builtins.int]:
        """
        Delay before sending Dead Peer Detection packets if no traffic is detected, in seconds.
        """
        return pulumi.get(self, "dpd_delay")

    @_builtins.property
    @pulumi.getter(name="dpdTimeout")
    def dpd_timeout(self) -> Optional[_builtins.int]:
        """
        Timeout period for DPD reply before considering the peer to be dead, in seconds.
        """
        return pulumi.get(self, "dpd_timeout")

    @_builtins.property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[_builtins.int]:
        """
        Maximum IKE SA lifetime in seconds.
        """
        return pulumi.get(self, "ike_lifetime")

    @_builtins.property
    @pulumi.getter(name="phase1Algorithms")
    def phase1_algorithms(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Phase 1: Proposal algorithms.
        """
        return pulumi.get(self, "phase1_algorithms")

    @_builtins.property
    @pulumi.getter(name="phase1DhGroupNumbers")
    def phase1_dh_group_numbers(self) -> Optional[Sequence[_builtins.int]]:
        """
        List of Phase 1 Diffie-Hellman group numbers.
        """
        return pulumi.get(self, "phase1_dh_group_numbers")

    @_builtins.property
    @pulumi.getter(name="phase1IntegrityAlgorithms")
    def phase1_integrity_algorithms(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Phase 1 integrity algorithms.
        """
        return pulumi.get(self, "phase1_integrity_algorithms")

    @_builtins.property
    @pulumi.getter(name="phase2Algorithms")
    def phase2_algorithms(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Phase 2: Security Association algorithms.
        """
        return pulumi.get(self, "phase2_algorithms")

    @_builtins.property
    @pulumi.getter(name="phase2DhGroupNumbers")
    def phase2_dh_group_numbers(self) -> Optional[Sequence[_builtins.int]]:
        """
        List of Phase 2 Diffie-Hellman group numbers.
        """
        return pulumi.get(self, "phase2_dh_group_numbers")

    @_builtins.property
    @pulumi.getter(name="phase2IntegrityAlgorithms")
    def phase2_integrity_algorithms(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Phase 2 integrity algorithms.
        """
        return pulumi.get(self, "phase2_integrity_algorithms")

    @_builtins.property
    @pulumi.getter(name="rekeyTime")
    def rekey_time(self) -> Optional[_builtins.int]:
        """
        IKE SA rekey time in seconds.
        """
        return pulumi.get(self, "rekey_time")


@pulumi.output_type
class GatewayRouter(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: ID of the router attached to the gateway.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the router attached to the gateway.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class KubernetesNodeGroupCloudNativePlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageSize":
            suggest = "storage_size"
        elif key == "storageTier":
            suggest = "storage_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodeGroupCloudNativePlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodeGroupCloudNativePlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodeGroupCloudNativePlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_size: Optional[_builtins.int] = None,
                 storage_tier: Optional[_builtins.str] = None):
        """
        :param _builtins.int storage_size: The size of the storage device in gigabytes.
        :param _builtins.str storage_tier: The storage tier to use.
        """
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[_builtins.int]:
        """
        The size of the storage device in gigabytes.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[_builtins.str]:
        """
        The storage tier to use.
        """
        return pulumi.get(self, "storage_tier")


@pulumi.output_type
class KubernetesNodeGroupCustomPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageSize":
            suggest = "storage_size"
        elif key == "storageTier":
            suggest = "storage_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodeGroupCustomPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodeGroupCustomPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodeGroupCustomPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cores: _builtins.int,
                 memory: _builtins.int,
                 storage_size: _builtins.int,
                 storage_tier: Optional[_builtins.str] = None):
        """
        :param _builtins.int cores: The number of CPU cores dedicated to individual node group nodes.
        :param _builtins.int memory: The amount of memory in megabytes to assign to individual node group node. Value needs to be divisible by 1024.
        :param _builtins.int storage_size: The size of the storage device in gigabytes.
        :param _builtins.str storage_tier: The storage tier to use.
        """
        pulumi.set(__self__, "cores", cores)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "storage_size", storage_size)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)

    @_builtins.property
    @pulumi.getter
    def cores(self) -> _builtins.int:
        """
        The number of CPU cores dedicated to individual node group nodes.
        """
        return pulumi.get(self, "cores")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        The amount of memory in megabytes to assign to individual node group node. Value needs to be divisible by 1024.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> _builtins.int:
        """
        The size of the storage device in gigabytes.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[_builtins.str]:
        """
        The storage tier to use.
        """
        return pulumi.get(self, "storage_tier")


@pulumi.output_type
class KubernetesNodeGroupGpuPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageSize":
            suggest = "storage_size"
        elif key == "storageTier":
            suggest = "storage_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodeGroupGpuPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodeGroupGpuPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodeGroupGpuPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_size: Optional[_builtins.int] = None,
                 storage_tier: Optional[_builtins.str] = None):
        """
        :param _builtins.int storage_size: The size of the storage device in gigabytes.
        :param _builtins.str storage_tier: The storage tier to use.
        """
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if storage_tier is not None:
            pulumi.set(__self__, "storage_tier", storage_tier)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[_builtins.int]:
        """
        The size of the storage device in gigabytes.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> Optional[_builtins.str]:
        """
        The storage tier to use.
        """
        return pulumi.get(self, "storage_tier")


@pulumi.output_type
class KubernetesNodeGroupKubeletArg(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Kubelet argument key.
        :param _builtins.str value: Kubelet argument value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Kubelet argument key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Kubelet argument value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KubernetesNodeGroupTaint(dict):
    def __init__(__self__, *,
                 effect: _builtins.str,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str effect: Taint effect.
        :param _builtins.str key: Taint key.
        :param _builtins.str value: Taint value.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> _builtins.str:
        """
        Taint effect.
        """
        return pulumi.get(self, "effect")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Taint key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Taint value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerBackendProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckExpectedStatus":
            suggest = "health_check_expected_status"
        elif key == "healthCheckFall":
            suggest = "health_check_fall"
        elif key == "healthCheckInterval":
            suggest = "health_check_interval"
        elif key == "healthCheckRise":
            suggest = "health_check_rise"
        elif key == "healthCheckTlsVerify":
            suggest = "health_check_tls_verify"
        elif key == "healthCheckType":
            suggest = "health_check_type"
        elif key == "healthCheckUrl":
            suggest = "health_check_url"
        elif key == "http2Enabled":
            suggest = "http2_enabled"
        elif key == "outboundProxyProtocol":
            suggest = "outbound_proxy_protocol"
        elif key == "stickySessionCookieName":
            suggest = "sticky_session_cookie_name"
        elif key == "timeoutServer":
            suggest = "timeout_server"
        elif key == "timeoutTunnel":
            suggest = "timeout_tunnel"
        elif key == "tlsEnabled":
            suggest = "tls_enabled"
        elif key == "tlsUseSystemCa":
            suggest = "tls_use_system_ca"
        elif key == "tlsVerify":
            suggest = "tls_verify"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerBackendProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerBackendProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerBackendProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_expected_status: Optional[_builtins.int] = None,
                 health_check_fall: Optional[_builtins.int] = None,
                 health_check_interval: Optional[_builtins.int] = None,
                 health_check_rise: Optional[_builtins.int] = None,
                 health_check_tls_verify: Optional[_builtins.bool] = None,
                 health_check_type: Optional[_builtins.str] = None,
                 health_check_url: Optional[_builtins.str] = None,
                 http2_enabled: Optional[_builtins.bool] = None,
                 outbound_proxy_protocol: Optional[_builtins.str] = None,
                 sticky_session_cookie_name: Optional[_builtins.str] = None,
                 timeout_server: Optional[_builtins.int] = None,
                 timeout_tunnel: Optional[_builtins.int] = None,
                 tls_enabled: Optional[_builtins.bool] = None,
                 tls_use_system_ca: Optional[_builtins.bool] = None,
                 tls_verify: Optional[_builtins.bool] = None):
        """
        :param _builtins.int health_check_expected_status: Expected HTTP status code returned by the customer application to mark server as healthy. Ignored for `tcp` `health_check_type`.
        :param _builtins.int health_check_fall: Sets how many failed health checks are allowed until the backend member is taken off from the rotation.
        :param _builtins.int health_check_interval: Interval between health checks in seconds.
        :param _builtins.int health_check_rise: Sets how many successful health checks are required to put the backend member back into rotation.
        :param _builtins.bool health_check_tls_verify: Enables certificate verification with the system CA certificate bundle. Works with https scheme in health_check_url, otherwise ignored.
        :param _builtins.str health_check_type: Health check type.
        :param _builtins.str health_check_url: Target path for health check HTTP GET requests. Ignored for `tcp` `health_check_type`.
        :param _builtins.bool http2_enabled: Allow HTTP/2 connections to backend members by utilizing ALPN extension of TLS protocol, therefore it can only be enabled when tls_enabled is set to true. Note: members should support HTTP/2 for this setting to work.
        :param _builtins.str outbound_proxy_protocol: Enable outbound proxy protocol by setting the desired version. Defaults to empty string. Empty string disables proxy protocol.
        :param _builtins.str sticky_session_cookie_name: Sets sticky session cookie name. Empty string disables sticky session.
        :param _builtins.int timeout_server: Backend server timeout in seconds.
        :param _builtins.int timeout_tunnel: Maximum inactivity time on the client and server side for tunnels in seconds.
        :param _builtins.bool tls_enabled: Enables TLS connection from the load balancer to backend servers.
        :param _builtins.bool tls_use_system_ca: If enabled, then the system CA certificate bundle will be used for the certificate verification.
        :param _builtins.bool tls_verify: Enables backend servers certificate verification. Please make sure that TLS config with the certificate bundle of type authority attached to the backend or `tls_use_system_ca` enabled. Note: `tls_verify` has preference over `health_check_tls_verify` when `tls_enabled` in true.
        """
        if health_check_expected_status is not None:
            pulumi.set(__self__, "health_check_expected_status", health_check_expected_status)
        if health_check_fall is not None:
            pulumi.set(__self__, "health_check_fall", health_check_fall)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_rise is not None:
            pulumi.set(__self__, "health_check_rise", health_check_rise)
        if health_check_tls_verify is not None:
            pulumi.set(__self__, "health_check_tls_verify", health_check_tls_verify)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if health_check_url is not None:
            pulumi.set(__self__, "health_check_url", health_check_url)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if outbound_proxy_protocol is not None:
            pulumi.set(__self__, "outbound_proxy_protocol", outbound_proxy_protocol)
        if sticky_session_cookie_name is not None:
            pulumi.set(__self__, "sticky_session_cookie_name", sticky_session_cookie_name)
        if timeout_server is not None:
            pulumi.set(__self__, "timeout_server", timeout_server)
        if timeout_tunnel is not None:
            pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if tls_use_system_ca is not None:
            pulumi.set(__self__, "tls_use_system_ca", tls_use_system_ca)
        if tls_verify is not None:
            pulumi.set(__self__, "tls_verify", tls_verify)

    @_builtins.property
    @pulumi.getter(name="healthCheckExpectedStatus")
    def health_check_expected_status(self) -> Optional[_builtins.int]:
        """
        Expected HTTP status code returned by the customer application to mark server as healthy. Ignored for `tcp` `health_check_type`.
        """
        return pulumi.get(self, "health_check_expected_status")

    @_builtins.property
    @pulumi.getter(name="healthCheckFall")
    def health_check_fall(self) -> Optional[_builtins.int]:
        """
        Sets how many failed health checks are allowed until the backend member is taken off from the rotation.
        """
        return pulumi.get(self, "health_check_fall")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[_builtins.int]:
        """
        Interval between health checks in seconds.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckRise")
    def health_check_rise(self) -> Optional[_builtins.int]:
        """
        Sets how many successful health checks are required to put the backend member back into rotation.
        """
        return pulumi.get(self, "health_check_rise")

    @_builtins.property
    @pulumi.getter(name="healthCheckTlsVerify")
    def health_check_tls_verify(self) -> Optional[_builtins.bool]:
        """
        Enables certificate verification with the system CA certificate bundle. Works with https scheme in health_check_url, otherwise ignored.
        """
        return pulumi.get(self, "health_check_tls_verify")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[_builtins.str]:
        """
        Health check type.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckUrl")
    def health_check_url(self) -> Optional[_builtins.str]:
        """
        Target path for health check HTTP GET requests. Ignored for `tcp` `health_check_type`.
        """
        return pulumi.get(self, "health_check_url")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[_builtins.bool]:
        """
        Allow HTTP/2 connections to backend members by utilizing ALPN extension of TLS protocol, therefore it can only be enabled when tls_enabled is set to true. Note: members should support HTTP/2 for this setting to work.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="outboundProxyProtocol")
    def outbound_proxy_protocol(self) -> Optional[_builtins.str]:
        """
        Enable outbound proxy protocol by setting the desired version. Defaults to empty string. Empty string disables proxy protocol.
        """
        return pulumi.get(self, "outbound_proxy_protocol")

    @_builtins.property
    @pulumi.getter(name="stickySessionCookieName")
    def sticky_session_cookie_name(self) -> Optional[_builtins.str]:
        """
        Sets sticky session cookie name. Empty string disables sticky session.
        """
        return pulumi.get(self, "sticky_session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> Optional[_builtins.int]:
        """
        Backend server timeout in seconds.
        """
        return pulumi.get(self, "timeout_server")

    @_builtins.property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> Optional[_builtins.int]:
        """
        Maximum inactivity time on the client and server side for tunnels in seconds.
        """
        return pulumi.get(self, "timeout_tunnel")

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[_builtins.bool]:
        """
        Enables TLS connection from the load balancer to backend servers.
        """
        return pulumi.get(self, "tls_enabled")

    @_builtins.property
    @pulumi.getter(name="tlsUseSystemCa")
    def tls_use_system_ca(self) -> Optional[_builtins.bool]:
        """
        If enabled, then the system CA certificate bundle will be used for the certificate verification.
        """
        return pulumi.get(self, "tls_use_system_ca")

    @_builtins.property
    @pulumi.getter(name="tlsVerify")
    def tls_verify(self) -> Optional[_builtins.bool]:
        """
        Enables backend servers certificate verification. Please make sure that TLS config with the certificate bundle of type authority attached to the backend or `tls_use_system_ca` enabled. Note: `tls_verify` has preference over `health_check_tls_verify` when `tls_enabled` in true.
        """
        return pulumi.get(self, "tls_verify")


@pulumi.output_type
class LoadbalancerFrontendNetwork(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Name of the load balancer network.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the load balancer network.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadbalancerFrontendProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "http2Enabled":
            suggest = "http2_enabled"
        elif key == "inboundProxyProtocol":
            suggest = "inbound_proxy_protocol"
        elif key == "timeoutClient":
            suggest = "timeout_client"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http2_enabled: Optional[_builtins.bool] = None,
                 inbound_proxy_protocol: Optional[_builtins.bool] = None,
                 timeout_client: Optional[_builtins.int] = None):
        """
        :param _builtins.bool http2_enabled: Enable or disable HTTP/2 support.
        :param _builtins.bool inbound_proxy_protocol: Enable or disable inbound proxy protocol support.
        :param _builtins.int timeout_client: Client request timeout in seconds.
        """
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if inbound_proxy_protocol is not None:
            pulumi.set(__self__, "inbound_proxy_protocol", inbound_proxy_protocol)
        if timeout_client is not None:
            pulumi.set(__self__, "timeout_client", timeout_client)

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable HTTP/2 support.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="inboundProxyProtocol")
    def inbound_proxy_protocol(self) -> Optional[_builtins.bool]:
        """
        Enable or disable inbound proxy protocol support.
        """
        return pulumi.get(self, "inbound_proxy_protocol")

    @_builtins.property
    @pulumi.getter(name="timeoutClient")
    def timeout_client(self) -> Optional[_builtins.int]:
        """
        Client request timeout in seconds.
        """
        return pulumi.get(self, "timeout_client")


@pulumi.output_type
class LoadbalancerFrontendRuleActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpRedirects":
            suggest = "http_redirects"
        elif key == "httpReturns":
            suggest = "http_returns"
        elif key == "setForwardedHeaders":
            suggest = "set_forwarded_headers"
        elif key == "setRequestHeaders":
            suggest = "set_request_headers"
        elif key == "setResponseHeaders":
            suggest = "set_response_headers"
        elif key == "tcpRejects":
            suggest = "tcp_rejects"
        elif key == "useBackends":
            suggest = "use_backends"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_redirects: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsHttpRedirect']] = None,
                 http_returns: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsHttpReturn']] = None,
                 set_forwarded_headers: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsSetForwardedHeader']] = None,
                 set_request_headers: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsSetRequestHeader']] = None,
                 set_response_headers: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsSetResponseHeader']] = None,
                 tcp_rejects: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsTcpReject']] = None,
                 use_backends: Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsUseBackend']] = None):
        """
        :param Sequence['LoadbalancerFrontendRuleActionsHttpRedirectArgs'] http_redirects: Redirects HTTP requests to specified location or URL scheme. Only either location or scheme can be defined at a time.
        :param Sequence['LoadbalancerFrontendRuleActionsHttpReturnArgs'] http_returns: Returns HTTP response with specified HTTP status.
        :param Sequence['LoadbalancerFrontendRuleActionsSetForwardedHeaderArgs'] set_forwarded_headers: Adds 'X-Forwarded-For / -Proto / -Port' headers in your forwarded requests
        :param Sequence['LoadbalancerFrontendRuleActionsSetRequestHeaderArgs'] set_request_headers: Set request header
        :param Sequence['LoadbalancerFrontendRuleActionsSetResponseHeaderArgs'] set_response_headers: Set response header
        :param Sequence['LoadbalancerFrontendRuleActionsTcpRejectArgs'] tcp_rejects: Terminates a connection.
        :param Sequence['LoadbalancerFrontendRuleActionsUseBackendArgs'] use_backends: Routes traffic to specified `backend`.
        """
        if http_redirects is not None:
            pulumi.set(__self__, "http_redirects", http_redirects)
        if http_returns is not None:
            pulumi.set(__self__, "http_returns", http_returns)
        if set_forwarded_headers is not None:
            pulumi.set(__self__, "set_forwarded_headers", set_forwarded_headers)
        if set_request_headers is not None:
            pulumi.set(__self__, "set_request_headers", set_request_headers)
        if set_response_headers is not None:
            pulumi.set(__self__, "set_response_headers", set_response_headers)
        if tcp_rejects is not None:
            pulumi.set(__self__, "tcp_rejects", tcp_rejects)
        if use_backends is not None:
            pulumi.set(__self__, "use_backends", use_backends)

    @_builtins.property
    @pulumi.getter(name="httpRedirects")
    def http_redirects(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsHttpRedirect']]:
        """
        Redirects HTTP requests to specified location or URL scheme. Only either location or scheme can be defined at a time.
        """
        return pulumi.get(self, "http_redirects")

    @_builtins.property
    @pulumi.getter(name="httpReturns")
    def http_returns(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsHttpReturn']]:
        """
        Returns HTTP response with specified HTTP status.
        """
        return pulumi.get(self, "http_returns")

    @_builtins.property
    @pulumi.getter(name="setForwardedHeaders")
    def set_forwarded_headers(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsSetForwardedHeader']]:
        """
        Adds 'X-Forwarded-For / -Proto / -Port' headers in your forwarded requests
        """
        return pulumi.get(self, "set_forwarded_headers")

    @_builtins.property
    @pulumi.getter(name="setRequestHeaders")
    def set_request_headers(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsSetRequestHeader']]:
        """
        Set request header
        """
        return pulumi.get(self, "set_request_headers")

    @_builtins.property
    @pulumi.getter(name="setResponseHeaders")
    def set_response_headers(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsSetResponseHeader']]:
        """
        Set response header
        """
        return pulumi.get(self, "set_response_headers")

    @_builtins.property
    @pulumi.getter(name="tcpRejects")
    def tcp_rejects(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsTcpReject']]:
        """
        Terminates a connection.
        """
        return pulumi.get(self, "tcp_rejects")

    @_builtins.property
    @pulumi.getter(name="useBackends")
    def use_backends(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleActionsUseBackend']]:
        """
        Routes traffic to specified `backend`.
        """
        return pulumi.get(self, "use_backends")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsHttpRedirect(dict):
    def __init__(__self__, *,
                 location: Optional[_builtins.str] = None,
                 scheme: Optional[_builtins.str] = None,
                 status: Optional[_builtins.int] = None):
        """
        :param _builtins.str location: Target location.
        :param _builtins.str scheme: Target scheme.
        :param _builtins.int status: HTTP status code.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Target location.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        Target scheme.
        """
        return pulumi.get(self, "scheme")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        """
        HTTP status code.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsHttpReturn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleActionsHttpReturn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleActionsHttpReturn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleActionsHttpReturn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: _builtins.str,
                 payload: _builtins.str,
                 status: _builtins.int):
        """
        :param _builtins.str content_type: Content type.
        :param _builtins.str payload: The payload.
        :param _builtins.int status: HTTP status code.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        Content type.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def payload(self) -> _builtins.str:
        """
        The payload.
        """
        return pulumi.get(self, "payload")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        HTTP status code.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsSetForwardedHeader(dict):
    def __init__(__self__, *,
                 active: Optional[_builtins.bool] = None):
        if active is not None:
            pulumi.set(__self__, "active", active)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "active")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsSetRequestHeader(dict):
    def __init__(__self__, *,
                 header: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str header: Header name.
        :param _builtins.str value: Header value.
        """
        pulumi.set(__self__, "header", header)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def header(self) -> _builtins.str:
        """
        Header name.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsSetResponseHeader(dict):
    def __init__(__self__, *,
                 header: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str header: Header name.
        :param _builtins.str value: Header value.
        """
        pulumi.set(__self__, "header", header)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def header(self) -> _builtins.str:
        """
        Header name.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsTcpReject(dict):
    def __init__(__self__, *,
                 active: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool active: Indicates if the rule is active.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[_builtins.bool]:
        """
        Indicates if the rule is active.
        """
        return pulumi.get(self, "active")


@pulumi.output_type
class LoadbalancerFrontendRuleActionsUseBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendName":
            suggest = "backend_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleActionsUseBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleActionsUseBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleActionsUseBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_name: _builtins.str):
        """
        :param _builtins.str backend_name: The name of the backend where traffic will be routed.
        """
        pulumi.set(__self__, "backend_name", backend_name)

    @_builtins.property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> _builtins.str:
        """
        The name of the backend where traffic will be routed.
        """
        return pulumi.get(self, "backend_name")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodySizeRanges":
            suggest = "body_size_ranges"
        elif key == "bodySizes":
            suggest = "body_sizes"
        elif key == "httpMethods":
            suggest = "http_methods"
        elif key == "httpStatusRanges":
            suggest = "http_status_ranges"
        elif key == "httpStatuses":
            suggest = "http_statuses"
        elif key == "numMembersUps":
            suggest = "num_members_ups"
        elif key == "requestHeaders":
            suggest = "request_headers"
        elif key == "responseHeaders":
            suggest = "response_headers"
        elif key == "srcIps":
            suggest = "src_ips"
        elif key == "srcPortRanges":
            suggest = "src_port_ranges"
        elif key == "srcPorts":
            suggest = "src_ports"
        elif key == "urlParams":
            suggest = "url_params"
        elif key == "urlQueries":
            suggest = "url_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_size_ranges: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersBodySizeRange']] = None,
                 body_sizes: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersBodySize']] = None,
                 cookies: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersCookie']] = None,
                 headers: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHeader']] = None,
                 hosts: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHost']] = None,
                 http_methods: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHttpMethod']] = None,
                 http_status_ranges: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHttpStatusRange']] = None,
                 http_statuses: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHttpStatus']] = None,
                 num_members_ups: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersNumMembersUp']] = None,
                 paths: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersPath']] = None,
                 request_headers: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersRequestHeader']] = None,
                 response_headers: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersResponseHeader']] = None,
                 src_ips: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersSrcIp']] = None,
                 src_port_ranges: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersSrcPortRange']] = None,
                 src_ports: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersSrcPort']] = None,
                 url_params: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersUrlParam']] = None,
                 url_queries: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersUrlQuery']] = None,
                 urls: Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersUrl']] = None):
        """
        :param Sequence['LoadbalancerFrontendRuleMatchersBodySizeRangeArgs'] body_size_ranges: Matches by range of HTTP request body sizes.
        :param Sequence['LoadbalancerFrontendRuleMatchersBodySizeArgs'] body_sizes: Matches by HTTP request body size.
        :param Sequence['LoadbalancerFrontendRuleMatchersCookieArgs'] cookies: Matches by HTTP cookie value. Cookie name must be provided.
        :param Sequence['LoadbalancerFrontendRuleMatchersHeaderArgs'] headers: Matches by HTTP header value. Header name must be provided.
        :param Sequence['LoadbalancerFrontendRuleMatchersHostArgs'] hosts: Matches by hostname. Header extracted from HTTP Headers or from TLS certificate in case of secured connection.
        :param Sequence['LoadbalancerFrontendRuleMatchersHttpMethodArgs'] http_methods: Matches by HTTP method.
        :param Sequence['LoadbalancerFrontendRuleMatchersHttpStatusRangeArgs'] http_status_ranges: Matches by range of HTTP statuses.
        :param Sequence['LoadbalancerFrontendRuleMatchersHttpStatusArgs'] http_statuses: Matches by HTTP status.
        :param Sequence['LoadbalancerFrontendRuleMatchersNumMembersUpArgs'] num_members_ups: Matches by number of healthy backend members.
        :param Sequence['LoadbalancerFrontendRuleMatchersPathArgs'] paths: Matches by URL path.
        :param Sequence['LoadbalancerFrontendRuleMatchersRequestHeaderArgs'] request_headers: Matches by HTTP request header value. Header name must be provided.
        :param Sequence['LoadbalancerFrontendRuleMatchersResponseHeaderArgs'] response_headers: Matches by HTTP response header value. Header name must be provided.
        :param Sequence['LoadbalancerFrontendRuleMatchersSrcIpArgs'] src_ips: Matches by source IP address.
        :param Sequence['LoadbalancerFrontendRuleMatchersSrcPortRangeArgs'] src_port_ranges: Matches by range of source port numbers.
        :param Sequence['LoadbalancerFrontendRuleMatchersSrcPortArgs'] src_ports: Matches by source port number.
        :param Sequence['LoadbalancerFrontendRuleMatchersUrlParamArgs'] url_params: Matches by URL query parameter value. Query parameter name must be provided
        :param Sequence['LoadbalancerFrontendRuleMatchersUrlQueryArgs'] url_queries: Matches by URL query string.
        :param Sequence['LoadbalancerFrontendRuleMatchersUrlArgs'] urls: Matches by URL without schema, e.g. `example.com/dashboard`.
        """
        if body_size_ranges is not None:
            pulumi.set(__self__, "body_size_ranges", body_size_ranges)
        if body_sizes is not None:
            pulumi.set(__self__, "body_sizes", body_sizes)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if http_methods is not None:
            pulumi.set(__self__, "http_methods", http_methods)
        if http_status_ranges is not None:
            pulumi.set(__self__, "http_status_ranges", http_status_ranges)
        if http_statuses is not None:
            pulumi.set(__self__, "http_statuses", http_statuses)
        if num_members_ups is not None:
            pulumi.set(__self__, "num_members_ups", num_members_ups)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)
        if src_ips is not None:
            pulumi.set(__self__, "src_ips", src_ips)
        if src_port_ranges is not None:
            pulumi.set(__self__, "src_port_ranges", src_port_ranges)
        if src_ports is not None:
            pulumi.set(__self__, "src_ports", src_ports)
        if url_params is not None:
            pulumi.set(__self__, "url_params", url_params)
        if url_queries is not None:
            pulumi.set(__self__, "url_queries", url_queries)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)

    @_builtins.property
    @pulumi.getter(name="bodySizeRanges")
    def body_size_ranges(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersBodySizeRange']]:
        """
        Matches by range of HTTP request body sizes.
        """
        return pulumi.get(self, "body_size_ranges")

    @_builtins.property
    @pulumi.getter(name="bodySizes")
    def body_sizes(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersBodySize']]:
        """
        Matches by HTTP request body size.
        """
        return pulumi.get(self, "body_sizes")

    @_builtins.property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersCookie']]:
        """
        Matches by HTTP cookie value. Cookie name must be provided.
        """
        return pulumi.get(self, "cookies")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use `request_header` instead.""")
    def headers(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHeader']]:
        """
        Matches by HTTP header value. Header name must be provided.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHost']]:
        """
        Matches by hostname. Header extracted from HTTP Headers or from TLS certificate in case of secured connection.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter(name="httpMethods")
    def http_methods(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHttpMethod']]:
        """
        Matches by HTTP method.
        """
        return pulumi.get(self, "http_methods")

    @_builtins.property
    @pulumi.getter(name="httpStatusRanges")
    def http_status_ranges(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHttpStatusRange']]:
        """
        Matches by range of HTTP statuses.
        """
        return pulumi.get(self, "http_status_ranges")

    @_builtins.property
    @pulumi.getter(name="httpStatuses")
    def http_statuses(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersHttpStatus']]:
        """
        Matches by HTTP status.
        """
        return pulumi.get(self, "http_statuses")

    @_builtins.property
    @pulumi.getter(name="numMembersUps")
    def num_members_ups(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersNumMembersUp']]:
        """
        Matches by number of healthy backend members.
        """
        return pulumi.get(self, "num_members_ups")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersPath']]:
        """
        Matches by URL path.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersRequestHeader']]:
        """
        Matches by HTTP request header value. Header name must be provided.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersResponseHeader']]:
        """
        Matches by HTTP response header value. Header name must be provided.
        """
        return pulumi.get(self, "response_headers")

    @_builtins.property
    @pulumi.getter(name="srcIps")
    def src_ips(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersSrcIp']]:
        """
        Matches by source IP address.
        """
        return pulumi.get(self, "src_ips")

    @_builtins.property
    @pulumi.getter(name="srcPortRanges")
    def src_port_ranges(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersSrcPortRange']]:
        """
        Matches by range of source port numbers.
        """
        return pulumi.get(self, "src_port_ranges")

    @_builtins.property
    @pulumi.getter(name="srcPorts")
    def src_ports(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersSrcPort']]:
        """
        Matches by source port number.
        """
        return pulumi.get(self, "src_ports")

    @_builtins.property
    @pulumi.getter(name="urlParams")
    def url_params(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersUrlParam']]:
        """
        Matches by URL query parameter value. Query parameter name must be provided
        """
        return pulumi.get(self, "url_params")

    @_builtins.property
    @pulumi.getter(name="urlQueries")
    def url_queries(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersUrlQuery']]:
        """
        Matches by URL query string.
        """
        return pulumi.get(self, "url_queries")

    @_builtins.property
    @pulumi.getter
    def urls(self) -> Optional[Sequence['outputs.LoadbalancerFrontendRuleMatchersUrl']]:
        """
        Matches by URL without schema, e.g. `example.com/dashboard`.
        """
        return pulumi.get(self, "urls")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersBodySize(dict):
    def __init__(__self__, *,
                 method: _builtins.str,
                 value: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str method: Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        :param _builtins.int value: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersBodySizeRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rangeEnd":
            suggest = "range_end"
        elif key == "rangeStart":
            suggest = "range_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersBodySizeRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersBodySizeRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersBodySizeRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range_end: _builtins.int,
                 range_start: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.int range_end: Integer value.
        :param _builtins.int range_start: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "range_end", range_end)
        pulumi.set(__self__, "range_start", range_start)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "range_end")

    @_builtins.property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "range_start")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersCookie(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersCookie. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersCookie.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersCookie.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 name: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.str name: Name of the argument.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the argument.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 name: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.str name: Name of the argument.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the argument.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersHost(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str value: String value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        String value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersHttpMethod(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str value: String value (`GET`, `HEAD`, `POST`, `PUT`, `PATCH`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`).
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        String value (`GET`, `HEAD`, `POST`, `PUT`, `PATCH`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`).
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersHttpStatus(dict):
    def __init__(__self__, *,
                 method: _builtins.str,
                 value: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str method: Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        :param _builtins.int value: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersHttpStatusRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rangeEnd":
            suggest = "range_end"
        elif key == "rangeStart":
            suggest = "range_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersHttpStatusRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersHttpStatusRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersHttpStatusRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range_end: _builtins.int,
                 range_start: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.int range_end: Integer value.
        :param _builtins.int range_start: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "range_end", range_end)
        pulumi.set(__self__, "range_start", range_start)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "range_end")

    @_builtins.property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "range_start")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersNumMembersUp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendName":
            suggest = "backend_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersNumMembersUp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersNumMembersUp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersNumMembersUp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_name: _builtins.str,
                 method: _builtins.str,
                 value: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str backend_name: The name of the `backend`.
        :param _builtins.str method: Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        :param _builtins.int value: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "backend_name", backend_name)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> _builtins.str:
        """
        The name of the `backend`.
        """
        return pulumi.get(self, "backend_name")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersPath(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersRequestHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersRequestHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersRequestHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersRequestHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 name: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.str name: Name of the argument.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the argument.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersResponseHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersResponseHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersResponseHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersResponseHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 name: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.str name: Name of the argument.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the argument.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersSrcIp(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str value: IP address. CIDR masks are supported, e.g. `192.168.0.0/24`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        IP address. CIDR masks are supported, e.g. `192.168.0.0/24`.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersSrcPort(dict):
    def __init__(__self__, *,
                 method: _builtins.str,
                 value: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.str method: Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        :param _builtins.int value: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "value", value)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`equal`, `greater`, `greater_or_equal`, `less`, `less_or_equal`).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersSrcPortRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rangeEnd":
            suggest = "range_end"
        elif key == "rangeStart":
            suggest = "range_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersSrcPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersSrcPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersSrcPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range_end: _builtins.int,
                 range_start: _builtins.int,
                 inverse: Optional[_builtins.bool] = None):
        """
        :param _builtins.int range_end: Integer value.
        :param _builtins.int range_start: Integer value.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        pulumi.set(__self__, "range_end", range_end)
        pulumi.set(__self__, "range_start", range_start)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)

    @_builtins.property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "range_end")

    @_builtins.property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> _builtins.int:
        """
        Integer value.
        """
        return pulumi.get(self, "range_start")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersUrl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersUrl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersUrl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersUrl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersUrlParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersUrlParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersUrlParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersUrlParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 name: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.str name: Name of the argument.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the argument.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerFrontendRuleMatchersUrlQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerFrontendRuleMatchersUrlQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerFrontendRuleMatchersUrlQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerFrontendRuleMatchersUrlQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 ignore_case: Optional[_builtins.bool] = None,
                 inverse: Optional[_builtins.bool] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        :param _builtins.bool ignore_case: Defines if case should be ignored. Defaults to `false`.
        :param _builtins.bool inverse: Defines if the condition should be inverted. Works similarly to logical NOT operator.
        :param _builtins.str value: String value.
        """
        pulumi.set(__self__, "method", method)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if inverse is not None:
            pulumi.set(__self__, "inverse", inverse)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Match method (`exact`, `substring`, `regexp`, `starts`, `ends`, `domain`, `ip`, `exists`). Matcher with `exists` and `ip` methods must be used without `value` and `ignore_case` fields.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[_builtins.bool]:
        """
        Defines if case should be ignored. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_case")

    @_builtins.property
    @pulumi.getter
    def inverse(self) -> Optional[_builtins.bool]:
        """
        Defines if the condition should be inverted. Works similarly to logical NOT operator.
        """
        return pulumi.get(self, "inverse")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        String value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadbalancerNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 dns_name: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None):
        """
        :param _builtins.str family: Network family. Currently only `IPv4` is supported.
        :param _builtins.str name: The name of the network. Must be unique within the service.
        :param _builtins.str type: The type of the network. Only one public network can be attached and at least one private network must be attached.
        :param _builtins.str dns_name: DNS name of the load balancer network
        :param _builtins.str id: The unique identifier of the network.
        :param _builtins.str network: Private network UUID. Required for private networks and must reside in loadbalancer zone. For public network the field should be omitted.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. Currently only `IPv4` is supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the network. Only one public network can be attached and at least one private network must be attached.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[_builtins.str]:
        """
        DNS name of the load balancer network
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique identifier of the network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        Private network UUID. Required for private networks and must reside in loadbalancer zone. For public network the field should be omitted.
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class LoadbalancerNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationalState":
            suggest = "operational_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 networks: Optional[Sequence['outputs.LoadbalancerNodeNetwork']] = None,
                 operational_state: Optional[_builtins.str] = None):
        """
        :param Sequence['LoadbalancerNodeNetworkArgs'] networks: Networks attached to the node
        :param _builtins.str operational_state: Node's operational state. Managed by the system.
        """
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if operational_state is not None:
            pulumi.set(__self__, "operational_state", operational_state)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[Sequence['outputs.LoadbalancerNodeNetwork']]:
        """
        Networks attached to the node
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> Optional[_builtins.str]:
        """
        Node's operational state. Managed by the system.
        """
        return pulumi.get(self, "operational_state")


@pulumi.output_type
class LoadbalancerNodeNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadbalancerNodeNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadbalancerNodeNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadbalancerNodeNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_addresses: Optional[Sequence['outputs.LoadbalancerNodeNetworkIpAddress']] = None,
                 name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence['LoadbalancerNodeNetworkIpAddressArgs'] ip_addresses: IP addresses attached to the network
        :param _builtins.str name: The name of the network
        :param _builtins.str type: The type of the network
        """
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence['outputs.LoadbalancerNodeNetworkIpAddress']]:
        """
        IP addresses attached to the network
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the network
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the network
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadbalancerNodeNetworkIpAddress(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 listen: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address: Node's IP address
        :param _builtins.bool listen: Whether the node listens to the traffic
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if listen is not None:
            pulumi.set(__self__, "listen", listen)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        Node's IP address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def listen(self) -> Optional[_builtins.bool]:
        """
        Whether the node listens to the traffic
        """
        return pulumi.get(self, "listen")


@pulumi.output_type
class ManagedDatabaseMysqlComponent(dict):
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 route: Optional[_builtins.str] = None,
                 usage: Optional[_builtins.str] = None):
        """
        :param _builtins.str component: Type of the component
        :param _builtins.str host: Hostname of the component
        :param _builtins.int port: Port number of the component
        :param _builtins.str route: Component network route type
        :param _builtins.str usage: Usage of the component
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if route is not None:
            pulumi.set(__self__, "route", route)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Type of the component
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname of the component
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the component
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def route(self) -> Optional[_builtins.str]:
        """
        Component network route type
        """
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.str]:
        """
        Usage of the component
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class ManagedDatabaseMysqlNetwork(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str family: Network family. Currently only `IPv4` is supported.
        :param _builtins.str name: The name of the network. Must be unique within the service.
        :param _builtins.str type: The type of the network. Must be private.
        :param _builtins.str uuid: Private network UUID. Must reside in the same zone as the database.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. Currently only `IPv4` is supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the network. Must be private.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Private network UUID. Must reside in the same zone as the database.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ManagedDatabaseMysqlNodeState(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name plus a node iteration
        :param _builtins.str role: Role of the node
        :param _builtins.str state: State of the node
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name plus a node iteration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Role of the node
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the node
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedDatabaseMysqlProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "automaticUtilityNetworkIpFilter":
            suggest = "automatic_utility_network_ip_filter"
        elif key == "backupHour":
            suggest = "backup_hour"
        elif key == "backupMinute":
            suggest = "backup_minute"
        elif key == "binlogRetentionPeriod":
            suggest = "binlog_retention_period"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "defaultTimeZone":
            suggest = "default_time_zone"
        elif key == "groupConcatMaxLen":
            suggest = "group_concat_max_len"
        elif key == "informationSchemaStatsExpiry":
            suggest = "information_schema_stats_expiry"
        elif key == "innodbChangeBufferMaxSize":
            suggest = "innodb_change_buffer_max_size"
        elif key == "innodbFlushNeighbors":
            suggest = "innodb_flush_neighbors"
        elif key == "innodbFtMinTokenSize":
            suggest = "innodb_ft_min_token_size"
        elif key == "innodbFtServerStopwordTable":
            suggest = "innodb_ft_server_stopword_table"
        elif key == "innodbLockWaitTimeout":
            suggest = "innodb_lock_wait_timeout"
        elif key == "innodbLogBufferSize":
            suggest = "innodb_log_buffer_size"
        elif key == "innodbOnlineAlterLogMaxSize":
            suggest = "innodb_online_alter_log_max_size"
        elif key == "innodbPrintAllDeadlocks":
            suggest = "innodb_print_all_deadlocks"
        elif key == "innodbReadIoThreads":
            suggest = "innodb_read_io_threads"
        elif key == "innodbRollbackOnTimeout":
            suggest = "innodb_rollback_on_timeout"
        elif key == "innodbThreadConcurrency":
            suggest = "innodb_thread_concurrency"
        elif key == "innodbWriteIoThreads":
            suggest = "innodb_write_io_threads"
        elif key == "interactiveTimeout":
            suggest = "interactive_timeout"
        elif key == "internalTmpMemStorageEngine":
            suggest = "internal_tmp_mem_storage_engine"
        elif key == "ipFilters":
            suggest = "ip_filters"
        elif key == "logOutput":
            suggest = "log_output"
        elif key == "longQueryTime":
            suggest = "long_query_time"
        elif key == "maxAllowedPacket":
            suggest = "max_allowed_packet"
        elif key == "maxHeapTableSize":
            suggest = "max_heap_table_size"
        elif key == "mysqlIncrementalBackup":
            suggest = "mysql_incremental_backup"
        elif key == "netBufferLength":
            suggest = "net_buffer_length"
        elif key == "netReadTimeout":
            suggest = "net_read_timeout"
        elif key == "netWriteTimeout":
            suggest = "net_write_timeout"
        elif key == "publicAccess":
            suggest = "public_access"
        elif key == "serviceLog":
            suggest = "service_log"
        elif key == "slowQueryLog":
            suggest = "slow_query_log"
        elif key == "sortBufferSize":
            suggest = "sort_buffer_size"
        elif key == "sqlMode":
            suggest = "sql_mode"
        elif key == "sqlRequirePrimaryKey":
            suggest = "sql_require_primary_key"
        elif key == "tmpTableSize":
            suggest = "tmp_table_size"
        elif key == "waitTimeout":
            suggest = "wait_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseMysqlProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseMysqlProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseMysqlProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[_builtins.str] = None,
                 admin_username: Optional[_builtins.str] = None,
                 automatic_utility_network_ip_filter: Optional[_builtins.bool] = None,
                 backup_hour: Optional[_builtins.int] = None,
                 backup_minute: Optional[_builtins.int] = None,
                 binlog_retention_period: Optional[_builtins.int] = None,
                 connect_timeout: Optional[_builtins.int] = None,
                 default_time_zone: Optional[_builtins.str] = None,
                 group_concat_max_len: Optional[_builtins.int] = None,
                 information_schema_stats_expiry: Optional[_builtins.int] = None,
                 innodb_change_buffer_max_size: Optional[_builtins.int] = None,
                 innodb_flush_neighbors: Optional[_builtins.int] = None,
                 innodb_ft_min_token_size: Optional[_builtins.int] = None,
                 innodb_ft_server_stopword_table: Optional[_builtins.str] = None,
                 innodb_lock_wait_timeout: Optional[_builtins.int] = None,
                 innodb_log_buffer_size: Optional[_builtins.int] = None,
                 innodb_online_alter_log_max_size: Optional[_builtins.int] = None,
                 innodb_print_all_deadlocks: Optional[_builtins.bool] = None,
                 innodb_read_io_threads: Optional[_builtins.int] = None,
                 innodb_rollback_on_timeout: Optional[_builtins.bool] = None,
                 innodb_thread_concurrency: Optional[_builtins.int] = None,
                 innodb_write_io_threads: Optional[_builtins.int] = None,
                 interactive_timeout: Optional[_builtins.int] = None,
                 internal_tmp_mem_storage_engine: Optional[_builtins.str] = None,
                 ip_filters: Optional[Sequence[_builtins.str]] = None,
                 log_output: Optional[_builtins.str] = None,
                 long_query_time: Optional[_builtins.float] = None,
                 max_allowed_packet: Optional[_builtins.int] = None,
                 max_heap_table_size: Optional[_builtins.int] = None,
                 migration: Optional['outputs.ManagedDatabaseMysqlPropertiesMigration'] = None,
                 mysql_incremental_backup: Optional['outputs.ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup'] = None,
                 net_buffer_length: Optional[_builtins.int] = None,
                 net_read_timeout: Optional[_builtins.int] = None,
                 net_write_timeout: Optional[_builtins.int] = None,
                 public_access: Optional[_builtins.bool] = None,
                 service_log: Optional[_builtins.bool] = None,
                 slow_query_log: Optional[_builtins.bool] = None,
                 sort_buffer_size: Optional[_builtins.int] = None,
                 sql_mode: Optional[_builtins.str] = None,
                 sql_require_primary_key: Optional[_builtins.bool] = None,
                 tmp_table_size: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None,
                 wait_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str admin_password: Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
        :param _builtins.str admin_username: Custom username for admin user. This must be set only when a new service is being created.
        :param _builtins.bool automatic_utility_network_ip_filter: Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        :param _builtins.int backup_hour: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.int backup_minute: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.int binlog_retention_period: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.
        :param _builtins.int connect_timeout: The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
        :param _builtins.str default_time_zone: Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or 'SYSTEM' to use the MySQL server default.
        :param _builtins.int group_concat_max_len: The maximum permitted result length in bytes for the GROUP_CONCAT() function.
        :param _builtins.int information_schema_stats_expiry: The time, in seconds, before cached statistics expire.
        :param _builtins.int innodb_change_buffer_max_size: Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        :param _builtins.int innodb_flush_neighbors: Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        :param _builtins.int innodb_ft_min_token_size: Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        :param _builtins.str innodb_ft_server_stopword_table: This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables.
        :param _builtins.int innodb_lock_wait_timeout: The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        :param _builtins.int innodb_log_buffer_size: The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        :param _builtins.int innodb_online_alter_log_max_size: The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        :param _builtins.bool innodb_print_all_deadlocks: When enabled, information about all deadlocks in InnoDB user transactions is recorded in the error log. Disabled by default.
        :param _builtins.int innodb_read_io_threads: The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param _builtins.bool innodb_rollback_on_timeout: When enabled a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        :param _builtins.int innodb_thread_concurrency: Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        :param _builtins.int innodb_write_io_threads: The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        :param _builtins.int interactive_timeout: The number of seconds the server waits for activity on an interactive connection before closing it.
        :param _builtins.str internal_tmp_mem_storage_engine: The storage engine for in-memory internal temporary tables.
        :param Sequence[_builtins.str] ip_filters: IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        :param _builtins.str log_output: The slow log output destination when slow_query_log is ON. To enable MySQL AI Insights, choose INSIGHTS. To use MySQL AI Insights and the mysql.slow_log table at the same time, choose INSIGHTS,TABLE. To only use the mysql.slow_log table, choose TABLE. To silence slow logs, choose NONE.
        :param _builtins.float long_query_time: The slow_query_logs work as SQL statements that take more than long_query_time seconds to execute.
        :param _builtins.int max_allowed_packet: Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        :param _builtins.int max_heap_table_size: Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        :param 'ManagedDatabaseMysqlPropertiesMigrationArgs' migration: Migrate data from existing server.
        :param 'ManagedDatabaseMysqlPropertiesMysqlIncrementalBackupArgs' mysql_incremental_backup: MySQL incremental backup configuration.
        :param _builtins.int net_buffer_length: Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        :param _builtins.int net_read_timeout: The number of seconds to wait for more data from a connection before aborting the read.
        :param _builtins.int net_write_timeout: The number of seconds to wait for a block to be written to a connection before aborting the write.
        :param _builtins.bool public_access: Public Access. Allow access to the service from the public Internet.
        :param _builtins.bool service_log: Service logging. Store logs for the service so that they are available in the HTTP API and console.
        :param _builtins.bool slow_query_log: Slow query log enables capturing of slow queries. Setting slow_query_log to false also truncates the mysql.slow_log table.
        :param _builtins.int sort_buffer_size: Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        :param _builtins.str sql_mode: Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned.
        :param _builtins.bool sql_require_primary_key: Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        :param _builtins.int tmp_table_size: Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        :param _builtins.str version: MySQL major version.
        :param _builtins.int wait_timeout: The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if automatic_utility_network_ip_filter is not None:
            pulumi.set(__self__, "automatic_utility_network_ip_filter", automatic_utility_network_ip_filter)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if binlog_retention_period is not None:
            pulumi.set(__self__, "binlog_retention_period", binlog_retention_period)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if default_time_zone is not None:
            pulumi.set(__self__, "default_time_zone", default_time_zone)
        if group_concat_max_len is not None:
            pulumi.set(__self__, "group_concat_max_len", group_concat_max_len)
        if information_schema_stats_expiry is not None:
            pulumi.set(__self__, "information_schema_stats_expiry", information_schema_stats_expiry)
        if innodb_change_buffer_max_size is not None:
            pulumi.set(__self__, "innodb_change_buffer_max_size", innodb_change_buffer_max_size)
        if innodb_flush_neighbors is not None:
            pulumi.set(__self__, "innodb_flush_neighbors", innodb_flush_neighbors)
        if innodb_ft_min_token_size is not None:
            pulumi.set(__self__, "innodb_ft_min_token_size", innodb_ft_min_token_size)
        if innodb_ft_server_stopword_table is not None:
            pulumi.set(__self__, "innodb_ft_server_stopword_table", innodb_ft_server_stopword_table)
        if innodb_lock_wait_timeout is not None:
            pulumi.set(__self__, "innodb_lock_wait_timeout", innodb_lock_wait_timeout)
        if innodb_log_buffer_size is not None:
            pulumi.set(__self__, "innodb_log_buffer_size", innodb_log_buffer_size)
        if innodb_online_alter_log_max_size is not None:
            pulumi.set(__self__, "innodb_online_alter_log_max_size", innodb_online_alter_log_max_size)
        if innodb_print_all_deadlocks is not None:
            pulumi.set(__self__, "innodb_print_all_deadlocks", innodb_print_all_deadlocks)
        if innodb_read_io_threads is not None:
            pulumi.set(__self__, "innodb_read_io_threads", innodb_read_io_threads)
        if innodb_rollback_on_timeout is not None:
            pulumi.set(__self__, "innodb_rollback_on_timeout", innodb_rollback_on_timeout)
        if innodb_thread_concurrency is not None:
            pulumi.set(__self__, "innodb_thread_concurrency", innodb_thread_concurrency)
        if innodb_write_io_threads is not None:
            pulumi.set(__self__, "innodb_write_io_threads", innodb_write_io_threads)
        if interactive_timeout is not None:
            pulumi.set(__self__, "interactive_timeout", interactive_timeout)
        if internal_tmp_mem_storage_engine is not None:
            pulumi.set(__self__, "internal_tmp_mem_storage_engine", internal_tmp_mem_storage_engine)
        if ip_filters is not None:
            pulumi.set(__self__, "ip_filters", ip_filters)
        if log_output is not None:
            pulumi.set(__self__, "log_output", log_output)
        if long_query_time is not None:
            pulumi.set(__self__, "long_query_time", long_query_time)
        if max_allowed_packet is not None:
            pulumi.set(__self__, "max_allowed_packet", max_allowed_packet)
        if max_heap_table_size is not None:
            pulumi.set(__self__, "max_heap_table_size", max_heap_table_size)
        if migration is not None:
            pulumi.set(__self__, "migration", migration)
        if mysql_incremental_backup is not None:
            pulumi.set(__self__, "mysql_incremental_backup", mysql_incremental_backup)
        if net_buffer_length is not None:
            pulumi.set(__self__, "net_buffer_length", net_buffer_length)
        if net_read_timeout is not None:
            pulumi.set(__self__, "net_read_timeout", net_read_timeout)
        if net_write_timeout is not None:
            pulumi.set(__self__, "net_write_timeout", net_write_timeout)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if service_log is not None:
            pulumi.set(__self__, "service_log", service_log)
        if slow_query_log is not None:
            pulumi.set(__self__, "slow_query_log", slow_query_log)
        if sort_buffer_size is not None:
            pulumi.set(__self__, "sort_buffer_size", sort_buffer_size)
        if sql_mode is not None:
            pulumi.set(__self__, "sql_mode", sql_mode)
        if sql_require_primary_key is not None:
            pulumi.set(__self__, "sql_require_primary_key", sql_require_primary_key)
        if tmp_table_size is not None:
            pulumi.set(__self__, "tmp_table_size", tmp_table_size)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[_builtins.str]:
        """
        Custom username for admin user. This must be set only when a new service is being created.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="automaticUtilityNetworkIpFilter")
    def automatic_utility_network_ip_filter(self) -> Optional[_builtins.bool]:
        """
        Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        """
        return pulumi.get(self, "automatic_utility_network_ip_filter")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[_builtins.int]:
        """
        The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[_builtins.int]:
        """
        The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="binlogRetentionPeriod")
    def binlog_retention_period(self) -> Optional[_builtins.int]:
        """
        The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.
        """
        return pulumi.get(self, "binlog_retention_period")

    @_builtins.property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake.
        """
        return pulumi.get(self, "connect_timeout")

    @_builtins.property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> Optional[_builtins.str]:
        """
        Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or 'SYSTEM' to use the MySQL server default.
        """
        return pulumi.get(self, "default_time_zone")

    @_builtins.property
    @pulumi.getter(name="groupConcatMaxLen")
    def group_concat_max_len(self) -> Optional[_builtins.int]:
        """
        The maximum permitted result length in bytes for the GROUP_CONCAT() function.
        """
        return pulumi.get(self, "group_concat_max_len")

    @_builtins.property
    @pulumi.getter(name="informationSchemaStatsExpiry")
    def information_schema_stats_expiry(self) -> Optional[_builtins.int]:
        """
        The time, in seconds, before cached statistics expire.
        """
        return pulumi.get(self, "information_schema_stats_expiry")

    @_builtins.property
    @pulumi.getter(name="innodbChangeBufferMaxSize")
    def innodb_change_buffer_max_size(self) -> Optional[_builtins.int]:
        """
        Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25.
        """
        return pulumi.get(self, "innodb_change_buffer_max_size")

    @_builtins.property
    @pulumi.getter(name="innodbFlushNeighbors")
    def innodb_flush_neighbors(self) -> Optional[_builtins.int]:
        """
        Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent.
        """
        return pulumi.get(self, "innodb_flush_neighbors")

    @_builtins.property
    @pulumi.getter(name="innodbFtMinTokenSize")
    def innodb_ft_min_token_size(self) -> Optional[_builtins.int]:
        """
        Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "innodb_ft_min_token_size")

    @_builtins.property
    @pulumi.getter(name="innodbFtServerStopwordTable")
    def innodb_ft_server_stopword_table(self) -> Optional[_builtins.str]:
        """
        This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables.
        """
        return pulumi.get(self, "innodb_ft_server_stopword_table")

    @_builtins.property
    @pulumi.getter(name="innodbLockWaitTimeout")
    def innodb_lock_wait_timeout(self) -> Optional[_builtins.int]:
        """
        The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
        """
        return pulumi.get(self, "innodb_lock_wait_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbLogBufferSize")
    def innodb_log_buffer_size(self) -> Optional[_builtins.int]:
        """
        The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
        """
        return pulumi.get(self, "innodb_log_buffer_size")

    @_builtins.property
    @pulumi.getter(name="innodbOnlineAlterLogMaxSize")
    def innodb_online_alter_log_max_size(self) -> Optional[_builtins.int]:
        """
        The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
        """
        return pulumi.get(self, "innodb_online_alter_log_max_size")

    @_builtins.property
    @pulumi.getter(name="innodbPrintAllDeadlocks")
    def innodb_print_all_deadlocks(self) -> Optional[_builtins.bool]:
        """
        When enabled, information about all deadlocks in InnoDB user transactions is recorded in the error log. Disabled by default.
        """
        return pulumi.get(self, "innodb_print_all_deadlocks")

    @_builtins.property
    @pulumi.getter(name="innodbReadIoThreads")
    def innodb_read_io_threads(self) -> Optional[_builtins.int]:
        """
        The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "innodb_read_io_threads")

    @_builtins.property
    @pulumi.getter(name="innodbRollbackOnTimeout")
    def innodb_rollback_on_timeout(self) -> Optional[_builtins.bool]:
        """
        When enabled a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "innodb_rollback_on_timeout")

    @_builtins.property
    @pulumi.getter(name="innodbThreadConcurrency")
    def innodb_thread_concurrency(self) -> Optional[_builtins.int]:
        """
        Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit).
        """
        return pulumi.get(self, "innodb_thread_concurrency")

    @_builtins.property
    @pulumi.getter(name="innodbWriteIoThreads")
    def innodb_write_io_threads(self) -> Optional[_builtins.int]:
        """
        The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "innodb_write_io_threads")

    @_builtins.property
    @pulumi.getter(name="interactiveTimeout")
    def interactive_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds the server waits for activity on an interactive connection before closing it.
        """
        return pulumi.get(self, "interactive_timeout")

    @_builtins.property
    @pulumi.getter(name="internalTmpMemStorageEngine")
    def internal_tmp_mem_storage_engine(self) -> Optional[_builtins.str]:
        """
        The storage engine for in-memory internal temporary tables.
        """
        return pulumi.get(self, "internal_tmp_mem_storage_engine")

    @_builtins.property
    @pulumi.getter(name="ipFilters")
    def ip_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        """
        return pulumi.get(self, "ip_filters")

    @_builtins.property
    @pulumi.getter(name="logOutput")
    def log_output(self) -> Optional[_builtins.str]:
        """
        The slow log output destination when slow_query_log is ON. To enable MySQL AI Insights, choose INSIGHTS. To use MySQL AI Insights and the mysql.slow_log table at the same time, choose INSIGHTS,TABLE. To only use the mysql.slow_log table, choose TABLE. To silence slow logs, choose NONE.
        """
        return pulumi.get(self, "log_output")

    @_builtins.property
    @pulumi.getter(name="longQueryTime")
    def long_query_time(self) -> Optional[_builtins.float]:
        """
        The slow_query_logs work as SQL statements that take more than long_query_time seconds to execute.
        """
        return pulumi.get(self, "long_query_time")

    @_builtins.property
    @pulumi.getter(name="maxAllowedPacket")
    def max_allowed_packet(self) -> Optional[_builtins.int]:
        """
        Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M).
        """
        return pulumi.get(self, "max_allowed_packet")

    @_builtins.property
    @pulumi.getter(name="maxHeapTableSize")
    def max_heap_table_size(self) -> Optional[_builtins.int]:
        """
        Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "max_heap_table_size")

    @_builtins.property
    @pulumi.getter
    def migration(self) -> Optional['outputs.ManagedDatabaseMysqlPropertiesMigration']:
        """
        Migrate data from existing server.
        """
        return pulumi.get(self, "migration")

    @_builtins.property
    @pulumi.getter(name="mysqlIncrementalBackup")
    def mysql_incremental_backup(self) -> Optional['outputs.ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup']:
        """
        MySQL incremental backup configuration.
        """
        return pulumi.get(self, "mysql_incremental_backup")

    @_builtins.property
    @pulumi.getter(name="netBufferLength")
    def net_buffer_length(self) -> Optional[_builtins.int]:
        """
        Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
        """
        return pulumi.get(self, "net_buffer_length")

    @_builtins.property
    @pulumi.getter(name="netReadTimeout")
    def net_read_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to wait for more data from a connection before aborting the read.
        """
        return pulumi.get(self, "net_read_timeout")

    @_builtins.property
    @pulumi.getter(name="netWriteTimeout")
    def net_write_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds to wait for a block to be written to a connection before aborting the write.
        """
        return pulumi.get(self, "net_write_timeout")

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[_builtins.bool]:
        """
        Public Access. Allow access to the service from the public Internet.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter(name="serviceLog")
    def service_log(self) -> Optional[_builtins.bool]:
        """
        Service logging. Store logs for the service so that they are available in the HTTP API and console.
        """
        return pulumi.get(self, "service_log")

    @_builtins.property
    @pulumi.getter(name="slowQueryLog")
    def slow_query_log(self) -> Optional[_builtins.bool]:
        """
        Slow query log enables capturing of slow queries. Setting slow_query_log to false also truncates the mysql.slow_log table.
        """
        return pulumi.get(self, "slow_query_log")

    @_builtins.property
    @pulumi.getter(name="sortBufferSize")
    def sort_buffer_size(self) -> Optional[_builtins.int]:
        """
        Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K).
        """
        return pulumi.get(self, "sort_buffer_size")

    @_builtins.property
    @pulumi.getter(name="sqlMode")
    def sql_mode(self) -> Optional[_builtins.str]:
        """
        Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned.
        """
        return pulumi.get(self, "sql_mode")

    @_builtins.property
    @pulumi.getter(name="sqlRequirePrimaryKey")
    def sql_require_primary_key(self) -> Optional[_builtins.bool]:
        """
        Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
        """
        return pulumi.get(self, "sql_require_primary_key")

    @_builtins.property
    @pulumi.getter(name="tmpTableSize")
    def tmp_table_size(self) -> Optional[_builtins.int]:
        """
        Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M).
        """
        return pulumi.get(self, "tmp_table_size")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        MySQL major version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds the server waits for activity on a noninteractive connection before closing it.
        """
        return pulumi.get(self, "wait_timeout")


@pulumi.output_type
class ManagedDatabaseMysqlPropertiesMigration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreDbs":
            suggest = "ignore_dbs"
        elif key == "ignoreRoles":
            suggest = "ignore_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseMysqlPropertiesMigration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseMysqlPropertiesMigration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseMysqlPropertiesMigration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dbname: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 ignore_dbs: Optional[_builtins.str] = None,
                 ignore_roles: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 ssl: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str dbname: Database name for bootstrapping the initial connection.
        :param _builtins.str host: Hostname or IP address of the server where to migrate data from.
        :param _builtins.str ignore_dbs: Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        :param _builtins.str ignore_roles: Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        :param _builtins.str method: The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        :param _builtins.str password: Password for authentication with the server where to migrate data from.
        :param _builtins.int port: Port number of the server where to migrate data from.
        :param _builtins.bool ssl: The server where to migrate data from is secured with SSL.
        :param _builtins.str username: User name for authentication with the server where to migrate data from.
        """
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ignore_dbs is not None:
            pulumi.set(__self__, "ignore_dbs", ignore_dbs)
        if ignore_roles is not None:
            pulumi.set(__self__, "ignore_roles", ignore_roles)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[_builtins.str]:
        """
        Database name for bootstrapping the initial connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname or IP address of the server where to migrate data from.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_dbs")

    @_builtins.property
    @pulumi.getter(name="ignoreRoles")
    def ignore_roles(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_roles")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the server where to migrate data from.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[_builtins.bool]:
        """
        The server where to migrate data from is secured with SSL.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        User name for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullBackupWeekSchedule":
            suggest = "full_backup_week_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseMysqlPropertiesMysqlIncrementalBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 full_backup_week_schedule: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable incremental backups. Enable periodic incremental backups. When enabled, full_backup_week_schedule must be set. Incremental backups only store changes since the last backup, making them faster and more storage-efficient than full backups. This is particularly useful for large databases where daily full backups would be too time-consuming or expensive.
        :param _builtins.str full_backup_week_schedule: Full backup week schedule. Comma-separated list of days of the week when full backups should be created. Valid values: mon, tue, wed, thu, fri, sat, sun.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if full_backup_week_schedule is not None:
            pulumi.set(__self__, "full_backup_week_schedule", full_backup_week_schedule)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable incremental backups. Enable periodic incremental backups. When enabled, full_backup_week_schedule must be set. Incremental backups only store changes since the last backup, making them faster and more storage-efficient than full backups. This is particularly useful for large databases where daily full backups would be too time-consuming or expensive.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fullBackupWeekSchedule")
    def full_backup_week_schedule(self) -> Optional[_builtins.str]:
        """
        Full backup week schedule. Comma-separated list of days of the week when full backups should be created. Valid values: mon, tue, wed, thu, fri, sat, sun.
        """
        return pulumi.get(self, "full_backup_week_schedule")


@pulumi.output_type
class ManagedDatabaseOpensearchComponent(dict):
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 route: Optional[_builtins.str] = None,
                 usage: Optional[_builtins.str] = None):
        """
        :param _builtins.str component: Type of the component
        :param _builtins.str host: Hostname of the component
        :param _builtins.int port: Port number of the component
        :param _builtins.str route: Component network route type
        :param _builtins.str usage: Usage of the component
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if route is not None:
            pulumi.set(__self__, "route", route)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Type of the component
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname of the component
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the component
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def route(self) -> Optional[_builtins.str]:
        """
        Component network route type
        """
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.str]:
        """
        Usage of the component
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class ManagedDatabaseOpensearchNetwork(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str family: Network family. Currently only `IPv4` is supported.
        :param _builtins.str name: The name of the network. Must be unique within the service.
        :param _builtins.str type: The type of the network. Must be private.
        :param _builtins.str uuid: Private network UUID. Must reside in the same zone as the database.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. Currently only `IPv4` is supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the network. Must be private.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Private network UUID. Must reside in the same zone as the database.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ManagedDatabaseOpensearchNodeState(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name plus a node iteration
        :param _builtins.str role: Role of the node
        :param _builtins.str state: State of the node
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name plus a node iteration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Role of the node
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the node
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedDatabaseOpensearchProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionAutoCreateIndexEnabled":
            suggest = "action_auto_create_index_enabled"
        elif key == "actionDestructiveRequiresName":
            suggest = "action_destructive_requires_name"
        elif key == "authFailureListeners":
            suggest = "auth_failure_listeners"
        elif key == "automaticUtilityNetworkIpFilter":
            suggest = "automatic_utility_network_ip_filter"
        elif key == "clusterFilecacheRemoteDataRatio":
            suggest = "cluster_filecache_remote_data_ratio"
        elif key == "clusterMaxShardsPerNode":
            suggest = "cluster_max_shards_per_node"
        elif key == "clusterRemoteStore":
            suggest = "cluster_remote_store"
        elif key == "clusterRoutingAllocationBalancePreferPrimary":
            suggest = "cluster_routing_allocation_balance_prefer_primary"
        elif key == "clusterRoutingAllocationNodeConcurrentRecoveries":
            suggest = "cluster_routing_allocation_node_concurrent_recoveries"
        elif key == "clusterSearchRequestSlowlog":
            suggest = "cluster_search_request_slowlog"
        elif key == "customDomain":
            suggest = "custom_domain"
        elif key == "diskWatermarks":
            suggest = "disk_watermarks"
        elif key == "elasticsearchVersion":
            suggest = "elasticsearch_version"
        elif key == "emailSenderName":
            suggest = "email_sender_name"
        elif key == "emailSenderPassword":
            suggest = "email_sender_password"
        elif key == "emailSenderUsername":
            suggest = "email_sender_username"
        elif key == "enableRemoteBackedStorage":
            suggest = "enable_remote_backed_storage"
        elif key == "enableSearchableSnapshots":
            suggest = "enable_searchable_snapshots"
        elif key == "enableSecurityAudit":
            suggest = "enable_security_audit"
        elif key == "enableSnapshotApi":
            suggest = "enable_snapshot_api"
        elif key == "httpMaxContentLength":
            suggest = "http_max_content_length"
        elif key == "httpMaxHeaderSize":
            suggest = "http_max_header_size"
        elif key == "httpMaxInitialLineLength":
            suggest = "http_max_initial_line_length"
        elif key == "indexPatterns":
            suggest = "index_patterns"
        elif key == "indexRollup":
            suggest = "index_rollup"
        elif key == "indexTemplate":
            suggest = "index_template"
        elif key == "indicesFielddataCacheSize":
            suggest = "indices_fielddata_cache_size"
        elif key == "indicesMemoryIndexBufferSize":
            suggest = "indices_memory_index_buffer_size"
        elif key == "indicesMemoryMaxIndexBufferSize":
            suggest = "indices_memory_max_index_buffer_size"
        elif key == "indicesMemoryMinIndexBufferSize":
            suggest = "indices_memory_min_index_buffer_size"
        elif key == "indicesQueriesCacheSize":
            suggest = "indices_queries_cache_size"
        elif key == "indicesQueryBoolMaxClauseCount":
            suggest = "indices_query_bool_max_clause_count"
        elif key == "indicesRecoveryMaxBytesPerSec":
            suggest = "indices_recovery_max_bytes_per_sec"
        elif key == "indicesRecoveryMaxConcurrentFileChunks":
            suggest = "indices_recovery_max_concurrent_file_chunks"
        elif key == "ipFilters":
            suggest = "ip_filters"
        elif key == "ismEnabled":
            suggest = "ism_enabled"
        elif key == "ismHistoryEnabled":
            suggest = "ism_history_enabled"
        elif key == "ismHistoryMaxAge":
            suggest = "ism_history_max_age"
        elif key == "ismHistoryMaxDocs":
            suggest = "ism_history_max_docs"
        elif key == "ismHistoryRolloverCheckPeriod":
            suggest = "ism_history_rollover_check_period"
        elif key == "ismHistoryRolloverRetentionPeriod":
            suggest = "ism_history_rollover_retention_period"
        elif key == "keepIndexRefreshInterval":
            suggest = "keep_index_refresh_interval"
        elif key == "knnMemoryCircuitBreakerEnabled":
            suggest = "knn_memory_circuit_breaker_enabled"
        elif key == "knnMemoryCircuitBreakerLimit":
            suggest = "knn_memory_circuit_breaker_limit"
        elif key == "nodeSearchCacheSize":
            suggest = "node_search_cache_size"
        elif key == "opensearchDashboards":
            suggest = "opensearch_dashboards"
        elif key == "overrideMainResponseVersion":
            suggest = "override_main_response_version"
        elif key == "pluginsAlertingFilterByBackendRoles":
            suggest = "plugins_alerting_filter_by_backend_roles"
        elif key == "publicAccess":
            suggest = "public_access"
        elif key == "reindexRemoteWhitelists":
            suggest = "reindex_remote_whitelists"
        elif key == "remoteStore":
            suggest = "remote_store"
        elif key == "scriptMaxCompilationsRate":
            suggest = "script_max_compilations_rate"
        elif key == "searchBackpressure":
            suggest = "search_backpressure"
        elif key == "searchInsightsTopQueries":
            suggest = "search_insights_top_queries"
        elif key == "searchMaxBuckets":
            suggest = "search_max_buckets"
        elif key == "serviceLog":
            suggest = "service_log"
        elif key == "shardIndexingPressure":
            suggest = "shard_indexing_pressure"
        elif key == "threadPoolAnalyzeQueueSize":
            suggest = "thread_pool_analyze_queue_size"
        elif key == "threadPoolAnalyzeSize":
            suggest = "thread_pool_analyze_size"
        elif key == "threadPoolForceMergeSize":
            suggest = "thread_pool_force_merge_size"
        elif key == "threadPoolGetQueueSize":
            suggest = "thread_pool_get_queue_size"
        elif key == "threadPoolGetSize":
            suggest = "thread_pool_get_size"
        elif key == "threadPoolSearchQueueSize":
            suggest = "thread_pool_search_queue_size"
        elif key == "threadPoolSearchSize":
            suggest = "thread_pool_search_size"
        elif key == "threadPoolSearchThrottledQueueSize":
            suggest = "thread_pool_search_throttled_queue_size"
        elif key == "threadPoolSearchThrottledSize":
            suggest = "thread_pool_search_throttled_size"
        elif key == "threadPoolWriteQueueSize":
            suggest = "thread_pool_write_queue_size"
        elif key == "threadPoolWriteSize":
            suggest = "thread_pool_write_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_auto_create_index_enabled: Optional[_builtins.bool] = None,
                 action_destructive_requires_name: Optional[_builtins.bool] = None,
                 auth_failure_listeners: Optional['outputs.ManagedDatabaseOpensearchPropertiesAuthFailureListeners'] = None,
                 automatic_utility_network_ip_filter: Optional[_builtins.bool] = None,
                 cluster_filecache_remote_data_ratio: Optional[_builtins.int] = None,
                 cluster_max_shards_per_node: Optional[_builtins.int] = None,
                 cluster_remote_store: Optional['outputs.ManagedDatabaseOpensearchPropertiesClusterRemoteStore'] = None,
                 cluster_routing_allocation_balance_prefer_primary: Optional[_builtins.bool] = None,
                 cluster_routing_allocation_node_concurrent_recoveries: Optional[_builtins.int] = None,
                 cluster_search_request_slowlog: Optional['outputs.ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlog'] = None,
                 custom_domain: Optional[_builtins.str] = None,
                 disk_watermarks: Optional['outputs.ManagedDatabaseOpensearchPropertiesDiskWatermarks'] = None,
                 elasticsearch_version: Optional[_builtins.str] = None,
                 email_sender_name: Optional[_builtins.str] = None,
                 email_sender_password: Optional[_builtins.str] = None,
                 email_sender_username: Optional[_builtins.str] = None,
                 enable_remote_backed_storage: Optional[_builtins.bool] = None,
                 enable_searchable_snapshots: Optional[_builtins.bool] = None,
                 enable_security_audit: Optional[_builtins.bool] = None,
                 enable_snapshot_api: Optional[_builtins.bool] = None,
                 http_max_content_length: Optional[_builtins.int] = None,
                 http_max_header_size: Optional[_builtins.int] = None,
                 http_max_initial_line_length: Optional[_builtins.int] = None,
                 index_patterns: Optional[Sequence[_builtins.str]] = None,
                 index_rollup: Optional['outputs.ManagedDatabaseOpensearchPropertiesIndexRollup'] = None,
                 index_template: Optional['outputs.ManagedDatabaseOpensearchPropertiesIndexTemplate'] = None,
                 indices_fielddata_cache_size: Optional[_builtins.int] = None,
                 indices_memory_index_buffer_size: Optional[_builtins.int] = None,
                 indices_memory_max_index_buffer_size: Optional[_builtins.int] = None,
                 indices_memory_min_index_buffer_size: Optional[_builtins.int] = None,
                 indices_queries_cache_size: Optional[_builtins.int] = None,
                 indices_query_bool_max_clause_count: Optional[_builtins.int] = None,
                 indices_recovery_max_bytes_per_sec: Optional[_builtins.int] = None,
                 indices_recovery_max_concurrent_file_chunks: Optional[_builtins.int] = None,
                 ip_filters: Optional[Sequence[_builtins.str]] = None,
                 ism_enabled: Optional[_builtins.bool] = None,
                 ism_history_enabled: Optional[_builtins.bool] = None,
                 ism_history_max_age: Optional[_builtins.int] = None,
                 ism_history_max_docs: Optional[_builtins.int] = None,
                 ism_history_rollover_check_period: Optional[_builtins.int] = None,
                 ism_history_rollover_retention_period: Optional[_builtins.int] = None,
                 keep_index_refresh_interval: Optional[_builtins.bool] = None,
                 knn_memory_circuit_breaker_enabled: Optional[_builtins.bool] = None,
                 knn_memory_circuit_breaker_limit: Optional[_builtins.int] = None,
                 node_search_cache_size: Optional[_builtins.str] = None,
                 openid: Optional['outputs.ManagedDatabaseOpensearchPropertiesOpenid'] = None,
                 opensearch_dashboards: Optional['outputs.ManagedDatabaseOpensearchPropertiesOpensearchDashboards'] = None,
                 override_main_response_version: Optional[_builtins.bool] = None,
                 plugins_alerting_filter_by_backend_roles: Optional[_builtins.bool] = None,
                 public_access: Optional[_builtins.bool] = None,
                 reindex_remote_whitelists: Optional[Sequence[_builtins.str]] = None,
                 remote_store: Optional['outputs.ManagedDatabaseOpensearchPropertiesRemoteStore'] = None,
                 saml: Optional['outputs.ManagedDatabaseOpensearchPropertiesSaml'] = None,
                 script_max_compilations_rate: Optional[_builtins.str] = None,
                 search_backpressure: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressure'] = None,
                 search_insights_top_queries: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueries'] = None,
                 search_max_buckets: Optional[_builtins.int] = None,
                 segrep: Optional['outputs.ManagedDatabaseOpensearchPropertiesSegrep'] = None,
                 service_log: Optional[_builtins.bool] = None,
                 shard_indexing_pressure: Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressure'] = None,
                 thread_pool_analyze_queue_size: Optional[_builtins.int] = None,
                 thread_pool_analyze_size: Optional[_builtins.int] = None,
                 thread_pool_force_merge_size: Optional[_builtins.int] = None,
                 thread_pool_get_queue_size: Optional[_builtins.int] = None,
                 thread_pool_get_size: Optional[_builtins.int] = None,
                 thread_pool_search_queue_size: Optional[_builtins.int] = None,
                 thread_pool_search_size: Optional[_builtins.int] = None,
                 thread_pool_search_throttled_queue_size: Optional[_builtins.int] = None,
                 thread_pool_search_throttled_size: Optional[_builtins.int] = None,
                 thread_pool_write_queue_size: Optional[_builtins.int] = None,
                 thread_pool_write_size: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.bool action_auto_create_index_enabled: action.auto_create_index. Explicitly allow or block automatic creation of indices. Defaults to true.
        :param _builtins.bool action_destructive_requires_name: Require explicit index names when deleting.
        :param 'ManagedDatabaseOpensearchPropertiesAuthFailureListenersArgs' auth_failure_listeners: Opensearch Security Plugin Settings.
        :param _builtins.bool automatic_utility_network_ip_filter: Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        :param _builtins.int cluster_filecache_remote_data_ratio: The limit of how much total remote data can be referenced. Defines a limit of how much total remote data can be referenced as a ratio of the size of the disk reserved for the file cache. This is designed to be a safeguard to prevent oversubscribing a cluster. Defaults to 0.
        :param _builtins.int cluster_max_shards_per_node: Controls the number of shards allowed in the cluster per data node.
        :param _builtins.bool cluster_routing_allocation_balance_prefer_primary: When set to true, OpenSearch attempts to evenly distribute the primary shards between the cluster nodes. Enabling this setting does not always guarantee an equal number of primary shards on each node, especially in the event of a failover. Changing this setting to false after it was set to true does not invoke redistribution of primary shards. Default is false.
        :param _builtins.int cluster_routing_allocation_node_concurrent_recoveries: Concurrent incoming/outgoing shard recoveries per node. How many concurrent incoming/outgoing shard recoveries (normally replicas) are allowed to happen on a node. Defaults to node cpu count * 2.
        :param _builtins.str custom_domain: Custom domain. Serve the web frontend using a custom CNAME pointing to the Aiven DNS name.
        :param 'ManagedDatabaseOpensearchPropertiesDiskWatermarksArgs' disk_watermarks: Watermark settings.
        :param _builtins.str elasticsearch_version: Elasticsearch major version.
        :param _builtins.str email_sender_name: Sender name placeholder to be used in Opensearch Dashboards and Opensearch keystore. This should be identical to the Sender name defined in Opensearch dashboards.
        :param _builtins.str email_sender_password: Sender password for Opensearch alerts to authenticate with SMTP server. Sender password for Opensearch alerts to authenticate with SMTP server.
        :param _builtins.str email_sender_username: Sender username for Opensearch alerts.
        :param _builtins.bool enable_remote_backed_storage: Enable remote-backed storage.
        :param _builtins.bool enable_searchable_snapshots: Enable searchable snapshots.
        :param _builtins.bool enable_security_audit: Enable/Disable security audit.
        :param _builtins.bool enable_snapshot_api: Enable/Disable snapshot API. Enable/Disable snapshot API for custom repositories, this requires security management to be enabled.
        :param _builtins.int http_max_content_length: Maximum content length for HTTP requests to the OpenSearch HTTP API, in bytes.
        :param _builtins.int http_max_header_size: The max size of allowed headers, in bytes.
        :param _builtins.int http_max_initial_line_length: The max length of an HTTP URL, in bytes.
        :param Sequence[_builtins.str] index_patterns: Index patterns.
        :param 'ManagedDatabaseOpensearchPropertiesIndexRollupArgs' index_rollup: Index rollup settings.
        :param 'ManagedDatabaseOpensearchPropertiesIndexTemplateArgs' index_template: Template settings for all new indexes.
        :param _builtins.int indices_fielddata_cache_size: Relative amount. Maximum amount of heap memory used for field data cache. This is an expert setting; decreasing the value too much will increase overhead of loading field data; too much memory used for field data cache will decrease amount of heap available for other operations.
        :param _builtins.int indices_memory_index_buffer_size: Percentage value. Default is 10%. Total amount of heap used for indexing buffer, before writing segments to disk. This is an expert setting. Too low value will slow down indexing; too high value will increase indexing performance but causes performance issues for query performance.
        :param _builtins.int indices_memory_max_index_buffer_size: Absolute value. Default is unbound. Doesn't work without indices.memory.index_buffer_size. Maximum amount of heap used for query cache, an absolute indices.memory.index_buffer_size maximum hard limit.
        :param _builtins.int indices_memory_min_index_buffer_size: Absolute value. Default is 48mb. Doesn't work without indices.memory.index_buffer_size. Minimum amount of heap used for query cache, an absolute indices.memory.index_buffer_size minimal hard limit.
        :param _builtins.int indices_queries_cache_size: Percentage value. Default is 10%. Maximum amount of heap used for query cache. This is an expert setting. Too low value will decrease query performance and increase performance for other operations; too high value will cause issues with other OpenSearch functionality.
        :param _builtins.int indices_query_bool_max_clause_count: Maximum number of clauses Lucene BooleanQuery can have. The default value (1024) is relatively high, and increasing it may cause performance issues. Investigate other approaches first before increasing this value.
        :param _builtins.int indices_recovery_max_bytes_per_sec: Limits total inbound and outbound recovery traffic for each node. Applies to both peer recoveries as well as snapshot recoveries (i.e., restores from a snapshot). Defaults to 40mb.
        :param _builtins.int indices_recovery_max_concurrent_file_chunks: Number of file chunks sent in parallel for each recovery. Defaults to 2.
        :param Sequence[_builtins.str] ip_filters: IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        :param _builtins.bool ism_enabled: Specifies whether ISM is enabled or not.
        :param _builtins.bool ism_history_enabled: Specifies whether audit history is enabled or not. The logs from ISM are automatically indexed to a logs document.
        :param _builtins.int ism_history_max_age: The maximum age before rolling over the audit history index in hours.
        :param _builtins.int ism_history_max_docs: The maximum number of documents before rolling over the audit history index.
        :param _builtins.int ism_history_rollover_check_period: The time between rollover checks for the audit history index in hours.
        :param _builtins.int ism_history_rollover_retention_period: How long audit history indices are kept in days.
        :param _builtins.bool keep_index_refresh_interval: Don't reset index.refresh_interval to the default value. Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
        :param _builtins.bool knn_memory_circuit_breaker_enabled: Enable or disable KNN memory circuit breaker. Defaults to true.
        :param _builtins.int knn_memory_circuit_breaker_limit: Maximum amount of memory that can be used for KNN index. Defaults to 50% of the JVM heap size.
        :param _builtins.str node_search_cache_size: The limit of how much total remote data can be referenced. Defines a limit of how much total remote data can be referenced as a ratio of the size of the disk reserved for the file cache. This is designed to be a safeguard to prevent oversubscribing a cluster. Defaults to 5gb. Requires restarting all OpenSearch nodes.
        :param 'ManagedDatabaseOpensearchPropertiesOpenidArgs' openid: OpenSearch OpenID Connect Configuration.
        :param 'ManagedDatabaseOpensearchPropertiesOpensearchDashboardsArgs' opensearch_dashboards: OpenSearch Dashboards settings.
        :param _builtins.bool override_main_response_version: Compatibility mode sets OpenSearch to report its version as 7.10 so clients continue to work. Default is false.
        :param _builtins.bool plugins_alerting_filter_by_backend_roles: Enable or disable filtering of alerting by backend roles. Requires Security plugin. Defaults to false.
        :param _builtins.bool public_access: Public Access. Allow access to the service from the public Internet.
        :param Sequence[_builtins.str] reindex_remote_whitelists: Whitelisted addresses for reindexing. Changing this value will cause all OpenSearch instances to restart.
        :param 'ManagedDatabaseOpensearchPropertiesSamlArgs' saml: OpenSearch SAML configuration.
        :param _builtins.str script_max_compilations_rate: Script max compilation rate - circuit breaker to prevent/minimize OOMs. Script compilation circuit breaker limits the number of inline script compilations within a period of time. Default is use-context.
        :param 'ManagedDatabaseOpensearchPropertiesSearchBackpressureArgs' search_backpressure: Search Backpressure Settings.
        :param _builtins.int search_max_buckets: Maximum number of aggregation buckets allowed in a single response. OpenSearch default value is used when this is not defined.
        :param 'ManagedDatabaseOpensearchPropertiesSegrepArgs' segrep: Segment Replication Backpressure Settings.
        :param _builtins.bool service_log: Service logging. Store logs for the service so that they are available in the HTTP API and console.
        :param 'ManagedDatabaseOpensearchPropertiesShardIndexingPressureArgs' shard_indexing_pressure: Shard indexing back pressure settings.
        :param _builtins.int thread_pool_analyze_queue_size: analyze thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        :param _builtins.int thread_pool_analyze_size: analyze thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        :param _builtins.int thread_pool_force_merge_size: force_merge thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        :param _builtins.int thread_pool_get_queue_size: get thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        :param _builtins.int thread_pool_get_size: get thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        :param _builtins.int thread_pool_search_queue_size: search thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        :param _builtins.int thread_pool_search_size: search thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        :param _builtins.int thread_pool_search_throttled_queue_size: search_throttled thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        :param _builtins.int thread_pool_search_throttled_size: search_throttled thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        :param _builtins.int thread_pool_write_queue_size: write thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        :param _builtins.int thread_pool_write_size: write thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        :param _builtins.str version: OpenSearch major version.
        """
        if action_auto_create_index_enabled is not None:
            pulumi.set(__self__, "action_auto_create_index_enabled", action_auto_create_index_enabled)
        if action_destructive_requires_name is not None:
            pulumi.set(__self__, "action_destructive_requires_name", action_destructive_requires_name)
        if auth_failure_listeners is not None:
            pulumi.set(__self__, "auth_failure_listeners", auth_failure_listeners)
        if automatic_utility_network_ip_filter is not None:
            pulumi.set(__self__, "automatic_utility_network_ip_filter", automatic_utility_network_ip_filter)
        if cluster_filecache_remote_data_ratio is not None:
            pulumi.set(__self__, "cluster_filecache_remote_data_ratio", cluster_filecache_remote_data_ratio)
        if cluster_max_shards_per_node is not None:
            pulumi.set(__self__, "cluster_max_shards_per_node", cluster_max_shards_per_node)
        if cluster_remote_store is not None:
            pulumi.set(__self__, "cluster_remote_store", cluster_remote_store)
        if cluster_routing_allocation_balance_prefer_primary is not None:
            pulumi.set(__self__, "cluster_routing_allocation_balance_prefer_primary", cluster_routing_allocation_balance_prefer_primary)
        if cluster_routing_allocation_node_concurrent_recoveries is not None:
            pulumi.set(__self__, "cluster_routing_allocation_node_concurrent_recoveries", cluster_routing_allocation_node_concurrent_recoveries)
        if cluster_search_request_slowlog is not None:
            pulumi.set(__self__, "cluster_search_request_slowlog", cluster_search_request_slowlog)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if disk_watermarks is not None:
            pulumi.set(__self__, "disk_watermarks", disk_watermarks)
        if elasticsearch_version is not None:
            pulumi.set(__self__, "elasticsearch_version", elasticsearch_version)
        if email_sender_name is not None:
            pulumi.set(__self__, "email_sender_name", email_sender_name)
        if email_sender_password is not None:
            pulumi.set(__self__, "email_sender_password", email_sender_password)
        if email_sender_username is not None:
            pulumi.set(__self__, "email_sender_username", email_sender_username)
        if enable_remote_backed_storage is not None:
            pulumi.set(__self__, "enable_remote_backed_storage", enable_remote_backed_storage)
        if enable_searchable_snapshots is not None:
            pulumi.set(__self__, "enable_searchable_snapshots", enable_searchable_snapshots)
        if enable_security_audit is not None:
            pulumi.set(__self__, "enable_security_audit", enable_security_audit)
        if enable_snapshot_api is not None:
            pulumi.set(__self__, "enable_snapshot_api", enable_snapshot_api)
        if http_max_content_length is not None:
            pulumi.set(__self__, "http_max_content_length", http_max_content_length)
        if http_max_header_size is not None:
            pulumi.set(__self__, "http_max_header_size", http_max_header_size)
        if http_max_initial_line_length is not None:
            pulumi.set(__self__, "http_max_initial_line_length", http_max_initial_line_length)
        if index_patterns is not None:
            pulumi.set(__self__, "index_patterns", index_patterns)
        if index_rollup is not None:
            pulumi.set(__self__, "index_rollup", index_rollup)
        if index_template is not None:
            pulumi.set(__self__, "index_template", index_template)
        if indices_fielddata_cache_size is not None:
            pulumi.set(__self__, "indices_fielddata_cache_size", indices_fielddata_cache_size)
        if indices_memory_index_buffer_size is not None:
            pulumi.set(__self__, "indices_memory_index_buffer_size", indices_memory_index_buffer_size)
        if indices_memory_max_index_buffer_size is not None:
            pulumi.set(__self__, "indices_memory_max_index_buffer_size", indices_memory_max_index_buffer_size)
        if indices_memory_min_index_buffer_size is not None:
            pulumi.set(__self__, "indices_memory_min_index_buffer_size", indices_memory_min_index_buffer_size)
        if indices_queries_cache_size is not None:
            pulumi.set(__self__, "indices_queries_cache_size", indices_queries_cache_size)
        if indices_query_bool_max_clause_count is not None:
            pulumi.set(__self__, "indices_query_bool_max_clause_count", indices_query_bool_max_clause_count)
        if indices_recovery_max_bytes_per_sec is not None:
            pulumi.set(__self__, "indices_recovery_max_bytes_per_sec", indices_recovery_max_bytes_per_sec)
        if indices_recovery_max_concurrent_file_chunks is not None:
            pulumi.set(__self__, "indices_recovery_max_concurrent_file_chunks", indices_recovery_max_concurrent_file_chunks)
        if ip_filters is not None:
            pulumi.set(__self__, "ip_filters", ip_filters)
        if ism_enabled is not None:
            pulumi.set(__self__, "ism_enabled", ism_enabled)
        if ism_history_enabled is not None:
            pulumi.set(__self__, "ism_history_enabled", ism_history_enabled)
        if ism_history_max_age is not None:
            pulumi.set(__self__, "ism_history_max_age", ism_history_max_age)
        if ism_history_max_docs is not None:
            pulumi.set(__self__, "ism_history_max_docs", ism_history_max_docs)
        if ism_history_rollover_check_period is not None:
            pulumi.set(__self__, "ism_history_rollover_check_period", ism_history_rollover_check_period)
        if ism_history_rollover_retention_period is not None:
            pulumi.set(__self__, "ism_history_rollover_retention_period", ism_history_rollover_retention_period)
        if keep_index_refresh_interval is not None:
            pulumi.set(__self__, "keep_index_refresh_interval", keep_index_refresh_interval)
        if knn_memory_circuit_breaker_enabled is not None:
            pulumi.set(__self__, "knn_memory_circuit_breaker_enabled", knn_memory_circuit_breaker_enabled)
        if knn_memory_circuit_breaker_limit is not None:
            pulumi.set(__self__, "knn_memory_circuit_breaker_limit", knn_memory_circuit_breaker_limit)
        if node_search_cache_size is not None:
            pulumi.set(__self__, "node_search_cache_size", node_search_cache_size)
        if openid is not None:
            pulumi.set(__self__, "openid", openid)
        if opensearch_dashboards is not None:
            pulumi.set(__self__, "opensearch_dashboards", opensearch_dashboards)
        if override_main_response_version is not None:
            pulumi.set(__self__, "override_main_response_version", override_main_response_version)
        if plugins_alerting_filter_by_backend_roles is not None:
            pulumi.set(__self__, "plugins_alerting_filter_by_backend_roles", plugins_alerting_filter_by_backend_roles)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if reindex_remote_whitelists is not None:
            pulumi.set(__self__, "reindex_remote_whitelists", reindex_remote_whitelists)
        if remote_store is not None:
            pulumi.set(__self__, "remote_store", remote_store)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if script_max_compilations_rate is not None:
            pulumi.set(__self__, "script_max_compilations_rate", script_max_compilations_rate)
        if search_backpressure is not None:
            pulumi.set(__self__, "search_backpressure", search_backpressure)
        if search_insights_top_queries is not None:
            pulumi.set(__self__, "search_insights_top_queries", search_insights_top_queries)
        if search_max_buckets is not None:
            pulumi.set(__self__, "search_max_buckets", search_max_buckets)
        if segrep is not None:
            pulumi.set(__self__, "segrep", segrep)
        if service_log is not None:
            pulumi.set(__self__, "service_log", service_log)
        if shard_indexing_pressure is not None:
            pulumi.set(__self__, "shard_indexing_pressure", shard_indexing_pressure)
        if thread_pool_analyze_queue_size is not None:
            pulumi.set(__self__, "thread_pool_analyze_queue_size", thread_pool_analyze_queue_size)
        if thread_pool_analyze_size is not None:
            pulumi.set(__self__, "thread_pool_analyze_size", thread_pool_analyze_size)
        if thread_pool_force_merge_size is not None:
            pulumi.set(__self__, "thread_pool_force_merge_size", thread_pool_force_merge_size)
        if thread_pool_get_queue_size is not None:
            pulumi.set(__self__, "thread_pool_get_queue_size", thread_pool_get_queue_size)
        if thread_pool_get_size is not None:
            pulumi.set(__self__, "thread_pool_get_size", thread_pool_get_size)
        if thread_pool_search_queue_size is not None:
            pulumi.set(__self__, "thread_pool_search_queue_size", thread_pool_search_queue_size)
        if thread_pool_search_size is not None:
            pulumi.set(__self__, "thread_pool_search_size", thread_pool_search_size)
        if thread_pool_search_throttled_queue_size is not None:
            pulumi.set(__self__, "thread_pool_search_throttled_queue_size", thread_pool_search_throttled_queue_size)
        if thread_pool_search_throttled_size is not None:
            pulumi.set(__self__, "thread_pool_search_throttled_size", thread_pool_search_throttled_size)
        if thread_pool_write_queue_size is not None:
            pulumi.set(__self__, "thread_pool_write_queue_size", thread_pool_write_queue_size)
        if thread_pool_write_size is not None:
            pulumi.set(__self__, "thread_pool_write_size", thread_pool_write_size)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="actionAutoCreateIndexEnabled")
    def action_auto_create_index_enabled(self) -> Optional[_builtins.bool]:
        """
        action.auto_create_index. Explicitly allow or block automatic creation of indices. Defaults to true.
        """
        return pulumi.get(self, "action_auto_create_index_enabled")

    @_builtins.property
    @pulumi.getter(name="actionDestructiveRequiresName")
    def action_destructive_requires_name(self) -> Optional[_builtins.bool]:
        """
        Require explicit index names when deleting.
        """
        return pulumi.get(self, "action_destructive_requires_name")

    @_builtins.property
    @pulumi.getter(name="authFailureListeners")
    def auth_failure_listeners(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesAuthFailureListeners']:
        """
        Opensearch Security Plugin Settings.
        """
        return pulumi.get(self, "auth_failure_listeners")

    @_builtins.property
    @pulumi.getter(name="automaticUtilityNetworkIpFilter")
    def automatic_utility_network_ip_filter(self) -> Optional[_builtins.bool]:
        """
        Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        """
        return pulumi.get(self, "automatic_utility_network_ip_filter")

    @_builtins.property
    @pulumi.getter(name="clusterFilecacheRemoteDataRatio")
    def cluster_filecache_remote_data_ratio(self) -> Optional[_builtins.int]:
        """
        The limit of how much total remote data can be referenced. Defines a limit of how much total remote data can be referenced as a ratio of the size of the disk reserved for the file cache. This is designed to be a safeguard to prevent oversubscribing a cluster. Defaults to 0.
        """
        return pulumi.get(self, "cluster_filecache_remote_data_ratio")

    @_builtins.property
    @pulumi.getter(name="clusterMaxShardsPerNode")
    def cluster_max_shards_per_node(self) -> Optional[_builtins.int]:
        """
        Controls the number of shards allowed in the cluster per data node.
        """
        return pulumi.get(self, "cluster_max_shards_per_node")

    @_builtins.property
    @pulumi.getter(name="clusterRemoteStore")
    def cluster_remote_store(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesClusterRemoteStore']:
        return pulumi.get(self, "cluster_remote_store")

    @_builtins.property
    @pulumi.getter(name="clusterRoutingAllocationBalancePreferPrimary")
    def cluster_routing_allocation_balance_prefer_primary(self) -> Optional[_builtins.bool]:
        """
        When set to true, OpenSearch attempts to evenly distribute the primary shards between the cluster nodes. Enabling this setting does not always guarantee an equal number of primary shards on each node, especially in the event of a failover. Changing this setting to false after it was set to true does not invoke redistribution of primary shards. Default is false.
        """
        return pulumi.get(self, "cluster_routing_allocation_balance_prefer_primary")

    @_builtins.property
    @pulumi.getter(name="clusterRoutingAllocationNodeConcurrentRecoveries")
    def cluster_routing_allocation_node_concurrent_recoveries(self) -> Optional[_builtins.int]:
        """
        Concurrent incoming/outgoing shard recoveries per node. How many concurrent incoming/outgoing shard recoveries (normally replicas) are allowed to happen on a node. Defaults to node cpu count * 2.
        """
        return pulumi.get(self, "cluster_routing_allocation_node_concurrent_recoveries")

    @_builtins.property
    @pulumi.getter(name="clusterSearchRequestSlowlog")
    def cluster_search_request_slowlog(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlog']:
        return pulumi.get(self, "cluster_search_request_slowlog")

    @_builtins.property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[_builtins.str]:
        """
        Custom domain. Serve the web frontend using a custom CNAME pointing to the Aiven DNS name.
        """
        return pulumi.get(self, "custom_domain")

    @_builtins.property
    @pulumi.getter(name="diskWatermarks")
    def disk_watermarks(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesDiskWatermarks']:
        """
        Watermark settings.
        """
        return pulumi.get(self, "disk_watermarks")

    @_builtins.property
    @pulumi.getter(name="elasticsearchVersion")
    def elasticsearch_version(self) -> Optional[_builtins.str]:
        """
        Elasticsearch major version.
        """
        return pulumi.get(self, "elasticsearch_version")

    @_builtins.property
    @pulumi.getter(name="emailSenderName")
    def email_sender_name(self) -> Optional[_builtins.str]:
        """
        Sender name placeholder to be used in Opensearch Dashboards and Opensearch keystore. This should be identical to the Sender name defined in Opensearch dashboards.
        """
        return pulumi.get(self, "email_sender_name")

    @_builtins.property
    @pulumi.getter(name="emailSenderPassword")
    def email_sender_password(self) -> Optional[_builtins.str]:
        """
        Sender password for Opensearch alerts to authenticate with SMTP server. Sender password for Opensearch alerts to authenticate with SMTP server.
        """
        return pulumi.get(self, "email_sender_password")

    @_builtins.property
    @pulumi.getter(name="emailSenderUsername")
    def email_sender_username(self) -> Optional[_builtins.str]:
        """
        Sender username for Opensearch alerts.
        """
        return pulumi.get(self, "email_sender_username")

    @_builtins.property
    @pulumi.getter(name="enableRemoteBackedStorage")
    def enable_remote_backed_storage(self) -> Optional[_builtins.bool]:
        """
        Enable remote-backed storage.
        """
        return pulumi.get(self, "enable_remote_backed_storage")

    @_builtins.property
    @pulumi.getter(name="enableSearchableSnapshots")
    def enable_searchable_snapshots(self) -> Optional[_builtins.bool]:
        """
        Enable searchable snapshots.
        """
        return pulumi.get(self, "enable_searchable_snapshots")

    @_builtins.property
    @pulumi.getter(name="enableSecurityAudit")
    def enable_security_audit(self) -> Optional[_builtins.bool]:
        """
        Enable/Disable security audit.
        """
        return pulumi.get(self, "enable_security_audit")

    @_builtins.property
    @pulumi.getter(name="enableSnapshotApi")
    def enable_snapshot_api(self) -> Optional[_builtins.bool]:
        """
        Enable/Disable snapshot API. Enable/Disable snapshot API for custom repositories, this requires security management to be enabled.
        """
        return pulumi.get(self, "enable_snapshot_api")

    @_builtins.property
    @pulumi.getter(name="httpMaxContentLength")
    def http_max_content_length(self) -> Optional[_builtins.int]:
        """
        Maximum content length for HTTP requests to the OpenSearch HTTP API, in bytes.
        """
        return pulumi.get(self, "http_max_content_length")

    @_builtins.property
    @pulumi.getter(name="httpMaxHeaderSize")
    def http_max_header_size(self) -> Optional[_builtins.int]:
        """
        The max size of allowed headers, in bytes.
        """
        return pulumi.get(self, "http_max_header_size")

    @_builtins.property
    @pulumi.getter(name="httpMaxInitialLineLength")
    def http_max_initial_line_length(self) -> Optional[_builtins.int]:
        """
        The max length of an HTTP URL, in bytes.
        """
        return pulumi.get(self, "http_max_initial_line_length")

    @_builtins.property
    @pulumi.getter(name="indexPatterns")
    def index_patterns(self) -> Optional[Sequence[_builtins.str]]:
        """
        Index patterns.
        """
        return pulumi.get(self, "index_patterns")

    @_builtins.property
    @pulumi.getter(name="indexRollup")
    def index_rollup(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesIndexRollup']:
        """
        Index rollup settings.
        """
        return pulumi.get(self, "index_rollup")

    @_builtins.property
    @pulumi.getter(name="indexTemplate")
    def index_template(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesIndexTemplate']:
        """
        Template settings for all new indexes.
        """
        return pulumi.get(self, "index_template")

    @_builtins.property
    @pulumi.getter(name="indicesFielddataCacheSize")
    def indices_fielddata_cache_size(self) -> Optional[_builtins.int]:
        """
        Relative amount. Maximum amount of heap memory used for field data cache. This is an expert setting; decreasing the value too much will increase overhead of loading field data; too much memory used for field data cache will decrease amount of heap available for other operations.
        """
        return pulumi.get(self, "indices_fielddata_cache_size")

    @_builtins.property
    @pulumi.getter(name="indicesMemoryIndexBufferSize")
    def indices_memory_index_buffer_size(self) -> Optional[_builtins.int]:
        """
        Percentage value. Default is 10%. Total amount of heap used for indexing buffer, before writing segments to disk. This is an expert setting. Too low value will slow down indexing; too high value will increase indexing performance but causes performance issues for query performance.
        """
        return pulumi.get(self, "indices_memory_index_buffer_size")

    @_builtins.property
    @pulumi.getter(name="indicesMemoryMaxIndexBufferSize")
    def indices_memory_max_index_buffer_size(self) -> Optional[_builtins.int]:
        """
        Absolute value. Default is unbound. Doesn't work without indices.memory.index_buffer_size. Maximum amount of heap used for query cache, an absolute indices.memory.index_buffer_size maximum hard limit.
        """
        return pulumi.get(self, "indices_memory_max_index_buffer_size")

    @_builtins.property
    @pulumi.getter(name="indicesMemoryMinIndexBufferSize")
    def indices_memory_min_index_buffer_size(self) -> Optional[_builtins.int]:
        """
        Absolute value. Default is 48mb. Doesn't work without indices.memory.index_buffer_size. Minimum amount of heap used for query cache, an absolute indices.memory.index_buffer_size minimal hard limit.
        """
        return pulumi.get(self, "indices_memory_min_index_buffer_size")

    @_builtins.property
    @pulumi.getter(name="indicesQueriesCacheSize")
    def indices_queries_cache_size(self) -> Optional[_builtins.int]:
        """
        Percentage value. Default is 10%. Maximum amount of heap used for query cache. This is an expert setting. Too low value will decrease query performance and increase performance for other operations; too high value will cause issues with other OpenSearch functionality.
        """
        return pulumi.get(self, "indices_queries_cache_size")

    @_builtins.property
    @pulumi.getter(name="indicesQueryBoolMaxClauseCount")
    def indices_query_bool_max_clause_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of clauses Lucene BooleanQuery can have. The default value (1024) is relatively high, and increasing it may cause performance issues. Investigate other approaches first before increasing this value.
        """
        return pulumi.get(self, "indices_query_bool_max_clause_count")

    @_builtins.property
    @pulumi.getter(name="indicesRecoveryMaxBytesPerSec")
    def indices_recovery_max_bytes_per_sec(self) -> Optional[_builtins.int]:
        """
        Limits total inbound and outbound recovery traffic for each node. Applies to both peer recoveries as well as snapshot recoveries (i.e., restores from a snapshot). Defaults to 40mb.
        """
        return pulumi.get(self, "indices_recovery_max_bytes_per_sec")

    @_builtins.property
    @pulumi.getter(name="indicesRecoveryMaxConcurrentFileChunks")
    def indices_recovery_max_concurrent_file_chunks(self) -> Optional[_builtins.int]:
        """
        Number of file chunks sent in parallel for each recovery. Defaults to 2.
        """
        return pulumi.get(self, "indices_recovery_max_concurrent_file_chunks")

    @_builtins.property
    @pulumi.getter(name="ipFilters")
    def ip_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        """
        return pulumi.get(self, "ip_filters")

    @_builtins.property
    @pulumi.getter(name="ismEnabled")
    def ism_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether ISM is enabled or not.
        """
        return pulumi.get(self, "ism_enabled")

    @_builtins.property
    @pulumi.getter(name="ismHistoryEnabled")
    def ism_history_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether audit history is enabled or not. The logs from ISM are automatically indexed to a logs document.
        """
        return pulumi.get(self, "ism_history_enabled")

    @_builtins.property
    @pulumi.getter(name="ismHistoryMaxAge")
    def ism_history_max_age(self) -> Optional[_builtins.int]:
        """
        The maximum age before rolling over the audit history index in hours.
        """
        return pulumi.get(self, "ism_history_max_age")

    @_builtins.property
    @pulumi.getter(name="ismHistoryMaxDocs")
    def ism_history_max_docs(self) -> Optional[_builtins.int]:
        """
        The maximum number of documents before rolling over the audit history index.
        """
        return pulumi.get(self, "ism_history_max_docs")

    @_builtins.property
    @pulumi.getter(name="ismHistoryRolloverCheckPeriod")
    def ism_history_rollover_check_period(self) -> Optional[_builtins.int]:
        """
        The time between rollover checks for the audit history index in hours.
        """
        return pulumi.get(self, "ism_history_rollover_check_period")

    @_builtins.property
    @pulumi.getter(name="ismHistoryRolloverRetentionPeriod")
    def ism_history_rollover_retention_period(self) -> Optional[_builtins.int]:
        """
        How long audit history indices are kept in days.
        """
        return pulumi.get(self, "ism_history_rollover_retention_period")

    @_builtins.property
    @pulumi.getter(name="keepIndexRefreshInterval")
    def keep_index_refresh_interval(self) -> Optional[_builtins.bool]:
        """
        Don't reset index.refresh_interval to the default value. Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
        """
        return pulumi.get(self, "keep_index_refresh_interval")

    @_builtins.property
    @pulumi.getter(name="knnMemoryCircuitBreakerEnabled")
    def knn_memory_circuit_breaker_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable KNN memory circuit breaker. Defaults to true.
        """
        return pulumi.get(self, "knn_memory_circuit_breaker_enabled")

    @_builtins.property
    @pulumi.getter(name="knnMemoryCircuitBreakerLimit")
    def knn_memory_circuit_breaker_limit(self) -> Optional[_builtins.int]:
        """
        Maximum amount of memory that can be used for KNN index. Defaults to 50% of the JVM heap size.
        """
        return pulumi.get(self, "knn_memory_circuit_breaker_limit")

    @_builtins.property
    @pulumi.getter(name="nodeSearchCacheSize")
    def node_search_cache_size(self) -> Optional[_builtins.str]:
        """
        The limit of how much total remote data can be referenced. Defines a limit of how much total remote data can be referenced as a ratio of the size of the disk reserved for the file cache. This is designed to be a safeguard to prevent oversubscribing a cluster. Defaults to 5gb. Requires restarting all OpenSearch nodes.
        """
        return pulumi.get(self, "node_search_cache_size")

    @_builtins.property
    @pulumi.getter
    def openid(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesOpenid']:
        """
        OpenSearch OpenID Connect Configuration.
        """
        return pulumi.get(self, "openid")

    @_builtins.property
    @pulumi.getter(name="opensearchDashboards")
    def opensearch_dashboards(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesOpensearchDashboards']:
        """
        OpenSearch Dashboards settings.
        """
        return pulumi.get(self, "opensearch_dashboards")

    @_builtins.property
    @pulumi.getter(name="overrideMainResponseVersion")
    def override_main_response_version(self) -> Optional[_builtins.bool]:
        """
        Compatibility mode sets OpenSearch to report its version as 7.10 so clients continue to work. Default is false.
        """
        return pulumi.get(self, "override_main_response_version")

    @_builtins.property
    @pulumi.getter(name="pluginsAlertingFilterByBackendRoles")
    def plugins_alerting_filter_by_backend_roles(self) -> Optional[_builtins.bool]:
        """
        Enable or disable filtering of alerting by backend roles. Requires Security plugin. Defaults to false.
        """
        return pulumi.get(self, "plugins_alerting_filter_by_backend_roles")

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[_builtins.bool]:
        """
        Public Access. Allow access to the service from the public Internet.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter(name="reindexRemoteWhitelists")
    def reindex_remote_whitelists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Whitelisted addresses for reindexing. Changing this value will cause all OpenSearch instances to restart.
        """
        return pulumi.get(self, "reindex_remote_whitelists")

    @_builtins.property
    @pulumi.getter(name="remoteStore")
    def remote_store(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesRemoteStore']:
        return pulumi.get(self, "remote_store")

    @_builtins.property
    @pulumi.getter
    def saml(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSaml']:
        """
        OpenSearch SAML configuration.
        """
        return pulumi.get(self, "saml")

    @_builtins.property
    @pulumi.getter(name="scriptMaxCompilationsRate")
    def script_max_compilations_rate(self) -> Optional[_builtins.str]:
        """
        Script max compilation rate - circuit breaker to prevent/minimize OOMs. Script compilation circuit breaker limits the number of inline script compilations within a period of time. Default is use-context.
        """
        return pulumi.get(self, "script_max_compilations_rate")

    @_builtins.property
    @pulumi.getter(name="searchBackpressure")
    def search_backpressure(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressure']:
        """
        Search Backpressure Settings.
        """
        return pulumi.get(self, "search_backpressure")

    @_builtins.property
    @pulumi.getter(name="searchInsightsTopQueries")
    def search_insights_top_queries(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueries']:
        return pulumi.get(self, "search_insights_top_queries")

    @_builtins.property
    @pulumi.getter(name="searchMaxBuckets")
    def search_max_buckets(self) -> Optional[_builtins.int]:
        """
        Maximum number of aggregation buckets allowed in a single response. OpenSearch default value is used when this is not defined.
        """
        return pulumi.get(self, "search_max_buckets")

    @_builtins.property
    @pulumi.getter
    def segrep(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSegrep']:
        """
        Segment Replication Backpressure Settings.
        """
        return pulumi.get(self, "segrep")

    @_builtins.property
    @pulumi.getter(name="serviceLog")
    def service_log(self) -> Optional[_builtins.bool]:
        """
        Service logging. Store logs for the service so that they are available in the HTTP API and console.
        """
        return pulumi.get(self, "service_log")

    @_builtins.property
    @pulumi.getter(name="shardIndexingPressure")
    def shard_indexing_pressure(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressure']:
        """
        Shard indexing back pressure settings.
        """
        return pulumi.get(self, "shard_indexing_pressure")

    @_builtins.property
    @pulumi.getter(name="threadPoolAnalyzeQueueSize")
    def thread_pool_analyze_queue_size(self) -> Optional[_builtins.int]:
        """
        analyze thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        """
        return pulumi.get(self, "thread_pool_analyze_queue_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolAnalyzeSize")
    def thread_pool_analyze_size(self) -> Optional[_builtins.int]:
        """
        analyze thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        """
        return pulumi.get(self, "thread_pool_analyze_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolForceMergeSize")
    def thread_pool_force_merge_size(self) -> Optional[_builtins.int]:
        """
        force_merge thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        """
        return pulumi.get(self, "thread_pool_force_merge_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolGetQueueSize")
    def thread_pool_get_queue_size(self) -> Optional[_builtins.int]:
        """
        get thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        """
        return pulumi.get(self, "thread_pool_get_queue_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolGetSize")
    def thread_pool_get_size(self) -> Optional[_builtins.int]:
        """
        get thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        """
        return pulumi.get(self, "thread_pool_get_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolSearchQueueSize")
    def thread_pool_search_queue_size(self) -> Optional[_builtins.int]:
        """
        search thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        """
        return pulumi.get(self, "thread_pool_search_queue_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolSearchSize")
    def thread_pool_search_size(self) -> Optional[_builtins.int]:
        """
        search thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        """
        return pulumi.get(self, "thread_pool_search_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolSearchThrottledQueueSize")
    def thread_pool_search_throttled_queue_size(self) -> Optional[_builtins.int]:
        """
        search_throttled thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        """
        return pulumi.get(self, "thread_pool_search_throttled_queue_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolSearchThrottledSize")
    def thread_pool_search_throttled_size(self) -> Optional[_builtins.int]:
        """
        search_throttled thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        """
        return pulumi.get(self, "thread_pool_search_throttled_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolWriteQueueSize")
    def thread_pool_write_queue_size(self) -> Optional[_builtins.int]:
        """
        write thread pool queue size. Size for the thread pool queue. See documentation for exact details.
        """
        return pulumi.get(self, "thread_pool_write_queue_size")

    @_builtins.property
    @pulumi.getter(name="threadPoolWriteSize")
    def thread_pool_write_size(self) -> Optional[_builtins.int]:
        """
        write thread pool size. Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
        """
        return pulumi.get(self, "thread_pool_write_size")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        OpenSearch major version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesAuthFailureListeners(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalAuthenticationBackendLimiting":
            suggest = "internal_authentication_backend_limiting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesAuthFailureListeners. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesAuthFailureListeners.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesAuthFailureListeners.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 internal_authentication_backend_limiting: Optional['outputs.ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting'] = None):
        if internal_authentication_backend_limiting is not None:
            pulumi.set(__self__, "internal_authentication_backend_limiting", internal_authentication_backend_limiting)

    @_builtins.property
    @pulumi.getter(name="internalAuthenticationBackendLimiting")
    def internal_authentication_backend_limiting(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting']:
        return pulumi.get(self, "internal_authentication_backend_limiting")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedTries":
            suggest = "allowed_tries"
        elif key == "authenticationBackend":
            suggest = "authentication_backend"
        elif key == "blockExpirySeconds":
            suggest = "block_expiry_seconds"
        elif key == "maxBlockedClients":
            suggest = "max_blocked_clients"
        elif key == "maxTrackedClients":
            suggest = "max_tracked_clients"
        elif key == "timeWindowSeconds":
            suggest = "time_window_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesAuthFailureListenersInternalAuthenticationBackendLimiting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_tries: Optional[_builtins.int] = None,
                 authentication_backend: Optional[_builtins.str] = None,
                 block_expiry_seconds: Optional[_builtins.int] = None,
                 max_blocked_clients: Optional[_builtins.int] = None,
                 max_tracked_clients: Optional[_builtins.int] = None,
                 time_window_seconds: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int allowed_tries: The number of login attempts allowed before login is blocked.
        :param _builtins.str authentication_backend: The internal backend. Enter `internal`.
        :param _builtins.int block_expiry_seconds: The duration of time that login remains blocked after a failed login.
        :param _builtins.int max_blocked_clients: The maximum number of blocked IP addresses.
        :param _builtins.int max_tracked_clients: The maximum number of tracked IP addresses that have failed login.
        :param _builtins.int time_window_seconds: The window of time in which the value for `allowed_tries` is enforced.
        :param _builtins.str type: The type of rate limiting.
        """
        if allowed_tries is not None:
            pulumi.set(__self__, "allowed_tries", allowed_tries)
        if authentication_backend is not None:
            pulumi.set(__self__, "authentication_backend", authentication_backend)
        if block_expiry_seconds is not None:
            pulumi.set(__self__, "block_expiry_seconds", block_expiry_seconds)
        if max_blocked_clients is not None:
            pulumi.set(__self__, "max_blocked_clients", max_blocked_clients)
        if max_tracked_clients is not None:
            pulumi.set(__self__, "max_tracked_clients", max_tracked_clients)
        if time_window_seconds is not None:
            pulumi.set(__self__, "time_window_seconds", time_window_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowedTries")
    def allowed_tries(self) -> Optional[_builtins.int]:
        """
        The number of login attempts allowed before login is blocked.
        """
        return pulumi.get(self, "allowed_tries")

    @_builtins.property
    @pulumi.getter(name="authenticationBackend")
    def authentication_backend(self) -> Optional[_builtins.str]:
        """
        The internal backend. Enter `internal`.
        """
        return pulumi.get(self, "authentication_backend")

    @_builtins.property
    @pulumi.getter(name="blockExpirySeconds")
    def block_expiry_seconds(self) -> Optional[_builtins.int]:
        """
        The duration of time that login remains blocked after a failed login.
        """
        return pulumi.get(self, "block_expiry_seconds")

    @_builtins.property
    @pulumi.getter(name="maxBlockedClients")
    def max_blocked_clients(self) -> Optional[_builtins.int]:
        """
        The maximum number of blocked IP addresses.
        """
        return pulumi.get(self, "max_blocked_clients")

    @_builtins.property
    @pulumi.getter(name="maxTrackedClients")
    def max_tracked_clients(self) -> Optional[_builtins.int]:
        """
        The maximum number of tracked IP addresses that have failed login.
        """
        return pulumi.get(self, "max_tracked_clients")

    @_builtins.property
    @pulumi.getter(name="timeWindowSeconds")
    def time_window_seconds(self) -> Optional[_builtins.int]:
        """
        The window of time in which the value for `allowed_tries` is enforced.
        """
        return pulumi.get(self, "time_window_seconds")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of rate limiting.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesClusterRemoteStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateGlobalMetadataUploadTimeout":
            suggest = "state_global_metadata_upload_timeout"
        elif key == "stateMetadataManifestUploadTimeout":
            suggest = "state_metadata_manifest_upload_timeout"
        elif key == "translogBufferInterval":
            suggest = "translog_buffer_interval"
        elif key == "translogMaxReaders":
            suggest = "translog_max_readers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesClusterRemoteStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesClusterRemoteStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesClusterRemoteStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_global_metadata_upload_timeout: Optional[_builtins.str] = None,
                 state_metadata_manifest_upload_timeout: Optional[_builtins.str] = None,
                 translog_buffer_interval: Optional[_builtins.str] = None,
                 translog_max_readers: Optional[_builtins.int] = None):
        """
        :param _builtins.str state_global_metadata_upload_timeout: The amount of time to wait for the cluster state upload to complete. The amount of time to wait for the cluster state upload to complete. Defaults to 20s.
        :param _builtins.str state_metadata_manifest_upload_timeout: The amount of time to wait for the manifest file upload to complete. The amount of time to wait for the manifest file upload to complete. The manifest file contains the details of each of the files uploaded for a single cluster state, both index metadata files and global metadata files. Defaults to 20s.
        :param _builtins.str translog_buffer_interval: The default value of the translog buffer interval. The default value of the translog buffer interval used when performing periodic translog updates. This setting is only effective when the index setting `index.remote_store.translog.buffer_interval` is not present. Defaults to 650ms.
        :param _builtins.int translog_max_readers: The maximum number of open translog files for remote-backed indexes. Sets the maximum number of open translog files for remote-backed indexes. This limits the total number of translog files per shard. After reaching this limit, the remote store flushes the translog files. Default is 1000. The minimum required is 100.
        """
        if state_global_metadata_upload_timeout is not None:
            pulumi.set(__self__, "state_global_metadata_upload_timeout", state_global_metadata_upload_timeout)
        if state_metadata_manifest_upload_timeout is not None:
            pulumi.set(__self__, "state_metadata_manifest_upload_timeout", state_metadata_manifest_upload_timeout)
        if translog_buffer_interval is not None:
            pulumi.set(__self__, "translog_buffer_interval", translog_buffer_interval)
        if translog_max_readers is not None:
            pulumi.set(__self__, "translog_max_readers", translog_max_readers)

    @_builtins.property
    @pulumi.getter(name="stateGlobalMetadataUploadTimeout")
    def state_global_metadata_upload_timeout(self) -> Optional[_builtins.str]:
        """
        The amount of time to wait for the cluster state upload to complete. The amount of time to wait for the cluster state upload to complete. Defaults to 20s.
        """
        return pulumi.get(self, "state_global_metadata_upload_timeout")

    @_builtins.property
    @pulumi.getter(name="stateMetadataManifestUploadTimeout")
    def state_metadata_manifest_upload_timeout(self) -> Optional[_builtins.str]:
        """
        The amount of time to wait for the manifest file upload to complete. The amount of time to wait for the manifest file upload to complete. The manifest file contains the details of each of the files uploaded for a single cluster state, both index metadata files and global metadata files. Defaults to 20s.
        """
        return pulumi.get(self, "state_metadata_manifest_upload_timeout")

    @_builtins.property
    @pulumi.getter(name="translogBufferInterval")
    def translog_buffer_interval(self) -> Optional[_builtins.str]:
        """
        The default value of the translog buffer interval. The default value of the translog buffer interval used when performing periodic translog updates. This setting is only effective when the index setting `index.remote_store.translog.buffer_interval` is not present. Defaults to 650ms.
        """
        return pulumi.get(self, "translog_buffer_interval")

    @_builtins.property
    @pulumi.getter(name="translogMaxReaders")
    def translog_max_readers(self) -> Optional[_builtins.int]:
        """
        The maximum number of open translog files for remote-backed indexes. Sets the maximum number of open translog files for remote-backed indexes. This limits the total number of translog files per shard. After reaching this limit, the remote store flushes the translog files. Default is 1000. The minimum required is 100.
        """
        return pulumi.get(self, "translog_max_readers")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlog(dict):
    def __init__(__self__, *,
                 level: Optional[_builtins.str] = None,
                 threshold: Optional['outputs.ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlogThreshold'] = None):
        """
        :param _builtins.str level: Log level.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter
    def level(self) -> Optional[_builtins.str]:
        """
        Log level.
        """
        return pulumi.get(self, "level")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlogThreshold']:
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesClusterSearchRequestSlowlogThreshold(dict):
    def __init__(__self__, *,
                 debug: Optional[_builtins.str] = None,
                 info: Optional[_builtins.str] = None,
                 trace: Optional[_builtins.str] = None,
                 warn: Optional[_builtins.str] = None):
        """
        :param _builtins.str debug: Debug threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        :param _builtins.str info: Info threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        :param _builtins.str trace: Trace threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        :param _builtins.str warn: Warning threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        """
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if info is not None:
            pulumi.set(__self__, "info", info)
        if trace is not None:
            pulumi.set(__self__, "trace", trace)
        if warn is not None:
            pulumi.set(__self__, "warn", warn)

    @_builtins.property
    @pulumi.getter
    def debug(self) -> Optional[_builtins.str]:
        """
        Debug threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        """
        return pulumi.get(self, "debug")

    @_builtins.property
    @pulumi.getter
    def info(self) -> Optional[_builtins.str]:
        """
        Info threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        """
        return pulumi.get(self, "info")

    @_builtins.property
    @pulumi.getter
    def trace(self) -> Optional[_builtins.str]:
        """
        Trace threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        """
        return pulumi.get(self, "trace")

    @_builtins.property
    @pulumi.getter
    def warn(self) -> Optional[_builtins.str]:
        """
        Warning threshold for total request took time. The value should be in the form count and unit, where unit one of (s,m,h,d,nanos,ms,micros) or -1. Default is -1.
        """
        return pulumi.get(self, "warn")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesDiskWatermarks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "floodStage":
            suggest = "flood_stage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesDiskWatermarks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesDiskWatermarks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesDiskWatermarks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flood_stage: Optional[_builtins.int] = None,
                 high: Optional[_builtins.int] = None,
                 low: Optional[_builtins.int] = None):
        """
        :param _builtins.int flood_stage: Flood stage watermark (percentage). The flood stage watermark for disk usage.
        :param _builtins.int high: High watermark (percentage). The high watermark for disk usage.
        :param _builtins.int low: Low watermark (percentage). The low watermark for disk usage.
        """
        if flood_stage is not None:
            pulumi.set(__self__, "flood_stage", flood_stage)
        if high is not None:
            pulumi.set(__self__, "high", high)
        if low is not None:
            pulumi.set(__self__, "low", low)

    @_builtins.property
    @pulumi.getter(name="floodStage")
    def flood_stage(self) -> Optional[_builtins.int]:
        """
        Flood stage watermark (percentage). The flood stage watermark for disk usage.
        """
        return pulumi.get(self, "flood_stage")

    @_builtins.property
    @pulumi.getter
    def high(self) -> Optional[_builtins.int]:
        """
        High watermark (percentage). The high watermark for disk usage.
        """
        return pulumi.get(self, "high")

    @_builtins.property
    @pulumi.getter
    def low(self) -> Optional[_builtins.int]:
        """
        Low watermark (percentage). The low watermark for disk usage.
        """
        return pulumi.get(self, "low")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesIndexRollup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollupDashboardsEnabled":
            suggest = "rollup_dashboards_enabled"
        elif key == "rollupEnabled":
            suggest = "rollup_enabled"
        elif key == "rollupSearchBackoffCount":
            suggest = "rollup_search_backoff_count"
        elif key == "rollupSearchBackoffMillis":
            suggest = "rollup_search_backoff_millis"
        elif key == "rollupSearchSearchAllJobs":
            suggest = "rollup_search_search_all_jobs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesIndexRollup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesIndexRollup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesIndexRollup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rollup_dashboards_enabled: Optional[_builtins.bool] = None,
                 rollup_enabled: Optional[_builtins.bool] = None,
                 rollup_search_backoff_count: Optional[_builtins.int] = None,
                 rollup_search_backoff_millis: Optional[_builtins.int] = None,
                 rollup_search_search_all_jobs: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool rollup_dashboards_enabled: plugins.rollup.dashboards.enabled. Whether rollups are enabled in OpenSearch Dashboards. Defaults to true.
        :param _builtins.bool rollup_enabled: plugins.rollup.enabled. Whether the rollup plugin is enabled. Defaults to true.
        :param _builtins.int rollup_search_backoff_count: plugins.rollup.search.backoff_count. How many retries the plugin should attempt for failed rollup jobs. Defaults to 5.
        :param _builtins.int rollup_search_backoff_millis: plugins.rollup.search.backoff_millis. The backoff time between retries for failed rollup jobs. Defaults to 1000ms.
        :param _builtins.bool rollup_search_search_all_jobs: plugins.rollup.search.all_jobs. Whether OpenSearch should return all jobs that match all specified search terms. If disabled, OpenSearch returns just one, as opposed to all, of the jobs that matches the search terms. Defaults to false.
        """
        if rollup_dashboards_enabled is not None:
            pulumi.set(__self__, "rollup_dashboards_enabled", rollup_dashboards_enabled)
        if rollup_enabled is not None:
            pulumi.set(__self__, "rollup_enabled", rollup_enabled)
        if rollup_search_backoff_count is not None:
            pulumi.set(__self__, "rollup_search_backoff_count", rollup_search_backoff_count)
        if rollup_search_backoff_millis is not None:
            pulumi.set(__self__, "rollup_search_backoff_millis", rollup_search_backoff_millis)
        if rollup_search_search_all_jobs is not None:
            pulumi.set(__self__, "rollup_search_search_all_jobs", rollup_search_search_all_jobs)

    @_builtins.property
    @pulumi.getter(name="rollupDashboardsEnabled")
    def rollup_dashboards_enabled(self) -> Optional[_builtins.bool]:
        """
        plugins.rollup.dashboards.enabled. Whether rollups are enabled in OpenSearch Dashboards. Defaults to true.
        """
        return pulumi.get(self, "rollup_dashboards_enabled")

    @_builtins.property
    @pulumi.getter(name="rollupEnabled")
    def rollup_enabled(self) -> Optional[_builtins.bool]:
        """
        plugins.rollup.enabled. Whether the rollup plugin is enabled. Defaults to true.
        """
        return pulumi.get(self, "rollup_enabled")

    @_builtins.property
    @pulumi.getter(name="rollupSearchBackoffCount")
    def rollup_search_backoff_count(self) -> Optional[_builtins.int]:
        """
        plugins.rollup.search.backoff_count. How many retries the plugin should attempt for failed rollup jobs. Defaults to 5.
        """
        return pulumi.get(self, "rollup_search_backoff_count")

    @_builtins.property
    @pulumi.getter(name="rollupSearchBackoffMillis")
    def rollup_search_backoff_millis(self) -> Optional[_builtins.int]:
        """
        plugins.rollup.search.backoff_millis. The backoff time between retries for failed rollup jobs. Defaults to 1000ms.
        """
        return pulumi.get(self, "rollup_search_backoff_millis")

    @_builtins.property
    @pulumi.getter(name="rollupSearchSearchAllJobs")
    def rollup_search_search_all_jobs(self) -> Optional[_builtins.bool]:
        """
        plugins.rollup.search.all_jobs. Whether OpenSearch should return all jobs that match all specified search terms. If disabled, OpenSearch returns just one, as opposed to all, of the jobs that matches the search terms. Defaults to false.
        """
        return pulumi.get(self, "rollup_search_search_all_jobs")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesIndexTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mappingNestedObjectsLimit":
            suggest = "mapping_nested_objects_limit"
        elif key == "numberOfReplicas":
            suggest = "number_of_replicas"
        elif key == "numberOfShards":
            suggest = "number_of_shards"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesIndexTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesIndexTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesIndexTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mapping_nested_objects_limit: Optional[_builtins.int] = None,
                 number_of_replicas: Optional[_builtins.int] = None,
                 number_of_shards: Optional[_builtins.int] = None):
        """
        :param _builtins.int mapping_nested_objects_limit: index.mapping.nested_objects.limit. The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
        :param _builtins.int number_of_replicas: The number of replicas each primary shard has.
        :param _builtins.int number_of_shards: The number of primary shards that an index should have.
        """
        if mapping_nested_objects_limit is not None:
            pulumi.set(__self__, "mapping_nested_objects_limit", mapping_nested_objects_limit)
        if number_of_replicas is not None:
            pulumi.set(__self__, "number_of_replicas", number_of_replicas)
        if number_of_shards is not None:
            pulumi.set(__self__, "number_of_shards", number_of_shards)

    @_builtins.property
    @pulumi.getter(name="mappingNestedObjectsLimit")
    def mapping_nested_objects_limit(self) -> Optional[_builtins.int]:
        """
        index.mapping.nested_objects.limit. The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
        """
        return pulumi.get(self, "mapping_nested_objects_limit")

    @_builtins.property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> Optional[_builtins.int]:
        """
        The number of replicas each primary shard has.
        """
        return pulumi.get(self, "number_of_replicas")

    @_builtins.property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> Optional[_builtins.int]:
        """
        The number of primary shards that an index should have.
        """
        return pulumi.get(self, "number_of_shards")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesOpenid(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "connectUrl":
            suggest = "connect_url"
        elif key == "jwtHeader":
            suggest = "jwt_header"
        elif key == "jwtUrlParameter":
            suggest = "jwt_url_parameter"
        elif key == "refreshRateLimitCount":
            suggest = "refresh_rate_limit_count"
        elif key == "refreshRateLimitTimeWindowMs":
            suggest = "refresh_rate_limit_time_window_ms"
        elif key == "rolesKey":
            suggest = "roles_key"
        elif key == "subjectKey":
            suggest = "subject_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesOpenid. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesOpenid.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesOpenid.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 client_secret: Optional[_builtins.str] = None,
                 connect_url: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 header: Optional[_builtins.str] = None,
                 jwt_header: Optional[_builtins.str] = None,
                 jwt_url_parameter: Optional[_builtins.str] = None,
                 refresh_rate_limit_count: Optional[_builtins.int] = None,
                 refresh_rate_limit_time_window_ms: Optional[_builtins.int] = None,
                 roles_key: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 subject_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: The ID of the OpenID Connect client. The ID of the OpenID Connect client configured in your IdP. Required.
        :param _builtins.str client_secret: The client secret of the OpenID Connect. The client secret of the OpenID Connect client configured in your IdP. Required.
        :param _builtins.str connect_url: OpenID Connect metadata/configuration URL. The URL of your IdP where the Security plugin can find the OpenID Connect metadata/configuration settings.
        :param _builtins.bool enabled: Enable or disable OpenSearch OpenID Connect authentication. Enables or disables OpenID Connect authentication for OpenSearch. When enabled, users can authenticate using OpenID Connect with an Identity Provider.
        :param _builtins.str header: HTTP header name of the JWT token. HTTP header name of the JWT token. Optional. Default is Authorization.
        :param _builtins.str jwt_header: The HTTP header that stores the token. The HTTP header that stores the token. Typically the Authorization header with the Bearer schema: Authorization: Bearer <token>. Optional. Default is Authorization.
        :param _builtins.str jwt_url_parameter: URL JWT token. If the token is not transmitted in the HTTP header, but as an URL parameter, define the name of the parameter here. Optional.
        :param _builtins.int refresh_rate_limit_count: The maximum number of unknown key IDs in the time frame. The maximum number of unknown key IDs in the time frame. Default is 10. Optional.
        :param _builtins.int refresh_rate_limit_time_window_ms: The time frame to use when checking the maximum number of unknown key IDs, in milliseconds. The time frame to use when checking the maximum number of unknown key IDs, in milliseconds. Optional.Default is 10000 (10 seconds).
        :param _builtins.str roles_key: The key in the JSON payload that stores the user’s roles. The key in the JSON payload that stores the user’s roles. The value of this key must be a comma-separated list of roles. Required only if you want to use roles in the JWT.
        :param _builtins.str scope: The scope of the identity token issued by the IdP. The scope of the identity token issued by the IdP. Optional. Default is openid profile email address phone.
        :param _builtins.str subject_key: The key in the JSON payload that stores the user’s name. The key in the JSON payload that stores the user’s name. If not defined, the subject registered claim is used. Most IdP providers use the preferred_username claim. Optional.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connect_url is not None:
            pulumi.set(__self__, "connect_url", connect_url)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if jwt_header is not None:
            pulumi.set(__self__, "jwt_header", jwt_header)
        if jwt_url_parameter is not None:
            pulumi.set(__self__, "jwt_url_parameter", jwt_url_parameter)
        if refresh_rate_limit_count is not None:
            pulumi.set(__self__, "refresh_rate_limit_count", refresh_rate_limit_count)
        if refresh_rate_limit_time_window_ms is not None:
            pulumi.set(__self__, "refresh_rate_limit_time_window_ms", refresh_rate_limit_time_window_ms)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The ID of the OpenID Connect client. The ID of the OpenID Connect client configured in your IdP. Required.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        The client secret of the OpenID Connect. The client secret of the OpenID Connect client configured in your IdP. Required.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="connectUrl")
    def connect_url(self) -> Optional[_builtins.str]:
        """
        OpenID Connect metadata/configuration URL. The URL of your IdP where the Security plugin can find the OpenID Connect metadata/configuration settings.
        """
        return pulumi.get(self, "connect_url")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable OpenSearch OpenID Connect authentication. Enables or disables OpenID Connect authentication for OpenSearch. When enabled, users can authenticate using OpenID Connect with an Identity Provider.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def header(self) -> Optional[_builtins.str]:
        """
        HTTP header name of the JWT token. HTTP header name of the JWT token. Optional. Default is Authorization.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter(name="jwtHeader")
    def jwt_header(self) -> Optional[_builtins.str]:
        """
        The HTTP header that stores the token. The HTTP header that stores the token. Typically the Authorization header with the Bearer schema: Authorization: Bearer <token>. Optional. Default is Authorization.
        """
        return pulumi.get(self, "jwt_header")

    @_builtins.property
    @pulumi.getter(name="jwtUrlParameter")
    def jwt_url_parameter(self) -> Optional[_builtins.str]:
        """
        URL JWT token. If the token is not transmitted in the HTTP header, but as an URL parameter, define the name of the parameter here. Optional.
        """
        return pulumi.get(self, "jwt_url_parameter")

    @_builtins.property
    @pulumi.getter(name="refreshRateLimitCount")
    def refresh_rate_limit_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of unknown key IDs in the time frame. The maximum number of unknown key IDs in the time frame. Default is 10. Optional.
        """
        return pulumi.get(self, "refresh_rate_limit_count")

    @_builtins.property
    @pulumi.getter(name="refreshRateLimitTimeWindowMs")
    def refresh_rate_limit_time_window_ms(self) -> Optional[_builtins.int]:
        """
        The time frame to use when checking the maximum number of unknown key IDs, in milliseconds. The time frame to use when checking the maximum number of unknown key IDs, in milliseconds. Optional.Default is 10000 (10 seconds).
        """
        return pulumi.get(self, "refresh_rate_limit_time_window_ms")

    @_builtins.property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[_builtins.str]:
        """
        The key in the JSON payload that stores the user’s roles. The key in the JSON payload that stores the user’s roles. The value of this key must be a comma-separated list of roles. Required only if you want to use roles in the JWT.
        """
        return pulumi.get(self, "roles_key")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The scope of the identity token issued by the IdP. The scope of the identity token issued by the IdP. Optional. Default is openid profile email address phone.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[_builtins.str]:
        """
        The key in the JSON payload that stores the user’s name. The key in the JSON payload that stores the user’s name. If not defined, the subject registered claim is used. Most IdP providers use the preferred_username claim. Optional.
        """
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesOpensearchDashboards(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxOldSpaceSize":
            suggest = "max_old_space_size"
        elif key == "multipleDataSourceEnabled":
            suggest = "multiple_data_source_enabled"
        elif key == "opensearchRequestTimeout":
            suggest = "opensearch_request_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesOpensearchDashboards. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesOpensearchDashboards.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesOpensearchDashboards.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 max_old_space_size: Optional[_builtins.int] = None,
                 multiple_data_source_enabled: Optional[_builtins.bool] = None,
                 opensearch_request_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Enable or disable OpenSearch Dashboards.
        :param _builtins.int max_old_space_size: Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch.
        :param _builtins.bool multiple_data_source_enabled: Enable or disable multiple data sources in OpenSearch Dashboards.
        :param _builtins.int opensearch_request_timeout: Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_old_space_size is not None:
            pulumi.set(__self__, "max_old_space_size", max_old_space_size)
        if multiple_data_source_enabled is not None:
            pulumi.set(__self__, "multiple_data_source_enabled", multiple_data_source_enabled)
        if opensearch_request_timeout is not None:
            pulumi.set(__self__, "opensearch_request_timeout", opensearch_request_timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable OpenSearch Dashboards.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="maxOldSpaceSize")
    def max_old_space_size(self) -> Optional[_builtins.int]:
        """
        Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch.
        """
        return pulumi.get(self, "max_old_space_size")

    @_builtins.property
    @pulumi.getter(name="multipleDataSourceEnabled")
    def multiple_data_source_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable multiple data sources in OpenSearch Dashboards.
        """
        return pulumi.get(self, "multiple_data_source_enabled")

    @_builtins.property
    @pulumi.getter(name="opensearchRequestTimeout")
    def opensearch_request_timeout(self) -> Optional[_builtins.int]:
        """
        Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch.
        """
        return pulumi.get(self, "opensearch_request_timeout")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesRemoteStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentPressureBytesLagVarianceFactor":
            suggest = "segment_pressure_bytes_lag_variance_factor"
        elif key == "segmentPressureConsecutiveFailuresLimit":
            suggest = "segment_pressure_consecutive_failures_limit"
        elif key == "segmentPressureEnabled":
            suggest = "segment_pressure_enabled"
        elif key == "segmentPressureTimeLagVarianceFactor":
            suggest = "segment_pressure_time_lag_variance_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesRemoteStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesRemoteStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesRemoteStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 segment_pressure_bytes_lag_variance_factor: Optional[_builtins.float] = None,
                 segment_pressure_consecutive_failures_limit: Optional[_builtins.int] = None,
                 segment_pressure_enabled: Optional[_builtins.bool] = None,
                 segment_pressure_time_lag_variance_factor: Optional[_builtins.float] = None):
        """
        :param _builtins.float segment_pressure_bytes_lag_variance_factor: The variance factor that is used to calculate the dynamic bytes lag threshold. The variance factor that is used together with the moving average to calculate the dynamic bytes lag threshold for activating remote segment backpressure. Defaults to 10.
        :param _builtins.int segment_pressure_consecutive_failures_limit: The minimum consecutive failure count for activating remote segment backpressure. The minimum consecutive failure count for activating remote segment backpressure. Defaults to 5.
        :param _builtins.bool segment_pressure_enabled: Enables remote segment backpressure. Enables remote segment backpressure. Default is `true`.
        :param _builtins.float segment_pressure_time_lag_variance_factor: The variance factor that is used to calculate the dynamic bytes lag threshold. The variance factor that is used together with the moving average to calculate the dynamic time lag threshold for activating remote segment backpressure. Defaults to 10.
        """
        if segment_pressure_bytes_lag_variance_factor is not None:
            pulumi.set(__self__, "segment_pressure_bytes_lag_variance_factor", segment_pressure_bytes_lag_variance_factor)
        if segment_pressure_consecutive_failures_limit is not None:
            pulumi.set(__self__, "segment_pressure_consecutive_failures_limit", segment_pressure_consecutive_failures_limit)
        if segment_pressure_enabled is not None:
            pulumi.set(__self__, "segment_pressure_enabled", segment_pressure_enabled)
        if segment_pressure_time_lag_variance_factor is not None:
            pulumi.set(__self__, "segment_pressure_time_lag_variance_factor", segment_pressure_time_lag_variance_factor)

    @_builtins.property
    @pulumi.getter(name="segmentPressureBytesLagVarianceFactor")
    def segment_pressure_bytes_lag_variance_factor(self) -> Optional[_builtins.float]:
        """
        The variance factor that is used to calculate the dynamic bytes lag threshold. The variance factor that is used together with the moving average to calculate the dynamic bytes lag threshold for activating remote segment backpressure. Defaults to 10.
        """
        return pulumi.get(self, "segment_pressure_bytes_lag_variance_factor")

    @_builtins.property
    @pulumi.getter(name="segmentPressureConsecutiveFailuresLimit")
    def segment_pressure_consecutive_failures_limit(self) -> Optional[_builtins.int]:
        """
        The minimum consecutive failure count for activating remote segment backpressure. The minimum consecutive failure count for activating remote segment backpressure. Defaults to 5.
        """
        return pulumi.get(self, "segment_pressure_consecutive_failures_limit")

    @_builtins.property
    @pulumi.getter(name="segmentPressureEnabled")
    def segment_pressure_enabled(self) -> Optional[_builtins.bool]:
        """
        Enables remote segment backpressure. Enables remote segment backpressure. Default is `true`.
        """
        return pulumi.get(self, "segment_pressure_enabled")

    @_builtins.property
    @pulumi.getter(name="segmentPressureTimeLagVarianceFactor")
    def segment_pressure_time_lag_variance_factor(self) -> Optional[_builtins.float]:
        """
        The variance factor that is used to calculate the dynamic bytes lag threshold. The variance factor that is used together with the moving average to calculate the dynamic time lag threshold for activating remote segment backpressure. Defaults to 10.
        """
        return pulumi.get(self, "segment_pressure_time_lag_variance_factor")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSaml(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "idpMetadataUrl":
            suggest = "idp_metadata_url"
        elif key == "idpPemtrustedcasContent":
            suggest = "idp_pemtrustedcas_content"
        elif key == "rolesKey":
            suggest = "roles_key"
        elif key == "spEntityId":
            suggest = "sp_entity_id"
        elif key == "subjectKey":
            suggest = "subject_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSaml. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSaml.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSaml.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 idp_entity_id: Optional[_builtins.str] = None,
                 idp_metadata_url: Optional[_builtins.str] = None,
                 idp_pemtrustedcas_content: Optional[_builtins.str] = None,
                 roles_key: Optional[_builtins.str] = None,
                 sp_entity_id: Optional[_builtins.str] = None,
                 subject_key: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable or disable OpenSearch SAML authentication. Enables or disables SAML-based authentication for OpenSearch. When enabled, users can authenticate using SAML with an Identity Provider.
        :param _builtins.str idp_entity_id: Identity Provider Entity ID. The unique identifier for the Identity Provider (IdP) entity that is used for SAML authentication. This value is typically provided by the IdP.
        :param _builtins.str idp_metadata_url: Identity Provider (IdP) SAML metadata URL. The URL of the SAML metadata for the Identity Provider (IdP). This is used to configure SAML-based authentication with the IdP.
        :param _builtins.str idp_pemtrustedcas_content: PEM-encoded root CA Content for SAML IdP server verification. This parameter specifies the PEM-encoded root certificate authority (CA) content for the SAML identity provider (IdP) server verification. The root CA content is used to verify the SSL/TLS certificate presented by the server.
        :param _builtins.str roles_key: SAML response role attribute. Optional. Specifies the attribute in the SAML response where role information is stored, if available. Role attributes are not required for SAML authentication, but can be included in SAML assertions by most Identity Providers (IdPs) to determine user access levels or permissions.
        :param _builtins.str sp_entity_id: Service Provider Entity ID. The unique identifier for the Service Provider (SP) entity that is used for SAML authentication. This value is typically provided by the SP.
        :param _builtins.str subject_key: SAML response subject attribute. Optional. Specifies the attribute in the SAML response where the subject identifier is stored. If not configured, the NameID attribute is used by default.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_entity_id is not None:
            pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        if idp_metadata_url is not None:
            pulumi.set(__self__, "idp_metadata_url", idp_metadata_url)
        if idp_pemtrustedcas_content is not None:
            pulumi.set(__self__, "idp_pemtrustedcas_content", idp_pemtrustedcas_content)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if sp_entity_id is not None:
            pulumi.set(__self__, "sp_entity_id", sp_entity_id)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable OpenSearch SAML authentication. Enables or disables SAML-based authentication for OpenSearch. When enabled, users can authenticate using SAML with an Identity Provider.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> Optional[_builtins.str]:
        """
        Identity Provider Entity ID. The unique identifier for the Identity Provider (IdP) entity that is used for SAML authentication. This value is typically provided by the IdP.
        """
        return pulumi.get(self, "idp_entity_id")

    @_builtins.property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> Optional[_builtins.str]:
        """
        Identity Provider (IdP) SAML metadata URL. The URL of the SAML metadata for the Identity Provider (IdP). This is used to configure SAML-based authentication with the IdP.
        """
        return pulumi.get(self, "idp_metadata_url")

    @_builtins.property
    @pulumi.getter(name="idpPemtrustedcasContent")
    def idp_pemtrustedcas_content(self) -> Optional[_builtins.str]:
        """
        PEM-encoded root CA Content for SAML IdP server verification. This parameter specifies the PEM-encoded root certificate authority (CA) content for the SAML identity provider (IdP) server verification. The root CA content is used to verify the SSL/TLS certificate presented by the server.
        """
        return pulumi.get(self, "idp_pemtrustedcas_content")

    @_builtins.property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[_builtins.str]:
        """
        SAML response role attribute. Optional. Specifies the attribute in the SAML response where role information is stored, if available. Role attributes are not required for SAML authentication, but can be included in SAML assertions by most Identity Providers (IdPs) to determine user access levels or permissions.
        """
        return pulumi.get(self, "roles_key")

    @_builtins.property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> Optional[_builtins.str]:
        """
        Service Provider Entity ID. The unique identifier for the Service Provider (SP) entity that is used for SAML authentication. This value is typically provided by the SP.
        """
        return pulumi.get(self, "sp_entity_id")

    @_builtins.property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[_builtins.str]:
        """
        SAML response subject attribute. Optional. Specifies the attribute in the SAML response where the subject identifier is stored. If not configured, the NameID attribute is used by default.
        """
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchBackpressure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeDuress":
            suggest = "node_duress"
        elif key == "searchShardTask":
            suggest = "search_shard_task"
        elif key == "searchTask":
            suggest = "search_task"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchBackpressure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None,
                 node_duress: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress'] = None,
                 search_shard_task: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask'] = None,
                 search_task: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask'] = None):
        """
        :param _builtins.str mode: The search backpressure mode. The search backpressure mode. Valid values are monitor_only, enforced, or disabled. Default is monitor_only.
        :param 'ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuressArgs' node_duress: Node duress settings.
        :param 'ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTaskArgs' search_shard_task: Search shard settings.
        :param 'ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTaskArgs' search_task: Search task settings.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if node_duress is not None:
            pulumi.set(__self__, "node_duress", node_duress)
        if search_shard_task is not None:
            pulumi.set(__self__, "search_shard_task", search_shard_task)
        if search_task is not None:
            pulumi.set(__self__, "search_task", search_task)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The search backpressure mode. The search backpressure mode. Valid values are monitor_only, enforced, or disabled. Default is monitor_only.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="nodeDuress")
    def node_duress(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress']:
        """
        Node duress settings.
        """
        return pulumi.get(self, "node_duress")

    @_builtins.property
    @pulumi.getter(name="searchShardTask")
    def search_shard_task(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask']:
        """
        Search shard settings.
        """
        return pulumi.get(self, "search_shard_task")

    @_builtins.property
    @pulumi.getter(name="searchTask")
    def search_task(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask']:
        """
        Search task settings.
        """
        return pulumi.get(self, "search_task")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "heapThreshold":
            suggest = "heap_threshold"
        elif key == "numSuccessiveBreaches":
            suggest = "num_successive_breaches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressureNodeDuress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_threshold: Optional[_builtins.float] = None,
                 heap_threshold: Optional[_builtins.float] = None,
                 num_successive_breaches: Optional[_builtins.int] = None):
        """
        :param _builtins.float cpu_threshold: The CPU usage threshold (as a percentage) required for a node to be considered to be under duress. The CPU usage threshold (as a percentage) required for a node to be considered to be under duress. Default is 0.9.
        :param _builtins.float heap_threshold: The heap usage threshold (as a percentage) required for a node to be considered to be under duress. The heap usage threshold (as a percentage) required for a node to be considered to be under duress. Default is 0.7.
        :param _builtins.int num_successive_breaches: The number of successive limit breaches after which the node is considered to be under duress. The number of successive limit breaches after which the node is considered to be under duress. Default is 3.
        """
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if heap_threshold is not None:
            pulumi.set(__self__, "heap_threshold", heap_threshold)
        if num_successive_breaches is not None:
            pulumi.set(__self__, "num_successive_breaches", num_successive_breaches)

    @_builtins.property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[_builtins.float]:
        """
        The CPU usage threshold (as a percentage) required for a node to be considered to be under duress. The CPU usage threshold (as a percentage) required for a node to be considered to be under duress. Default is 0.9.
        """
        return pulumi.get(self, "cpu_threshold")

    @_builtins.property
    @pulumi.getter(name="heapThreshold")
    def heap_threshold(self) -> Optional[_builtins.float]:
        """
        The heap usage threshold (as a percentage) required for a node to be considered to be under duress. The heap usage threshold (as a percentage) required for a node to be considered to be under duress. Default is 0.7.
        """
        return pulumi.get(self, "heap_threshold")

    @_builtins.property
    @pulumi.getter(name="numSuccessiveBreaches")
    def num_successive_breaches(self) -> Optional[_builtins.int]:
        """
        The number of successive limit breaches after which the node is considered to be under duress. The number of successive limit breaches after which the node is considered to be under duress. Default is 3.
        """
        return pulumi.get(self, "num_successive_breaches")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cancellationBurst":
            suggest = "cancellation_burst"
        elif key == "cancellationRate":
            suggest = "cancellation_rate"
        elif key == "cancellationRatio":
            suggest = "cancellation_ratio"
        elif key == "cpuTimeMillisThreshold":
            suggest = "cpu_time_millis_threshold"
        elif key == "elapsedTimeMillisThreshold":
            suggest = "elapsed_time_millis_threshold"
        elif key == "heapMovingAverageWindowSize":
            suggest = "heap_moving_average_window_size"
        elif key == "heapPercentThreshold":
            suggest = "heap_percent_threshold"
        elif key == "heapVariance":
            suggest = "heap_variance"
        elif key == "totalHeapPercentThreshold":
            suggest = "total_heap_percent_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchShardTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cancellation_burst: Optional[_builtins.float] = None,
                 cancellation_rate: Optional[_builtins.float] = None,
                 cancellation_ratio: Optional[_builtins.float] = None,
                 cpu_time_millis_threshold: Optional[_builtins.int] = None,
                 elapsed_time_millis_threshold: Optional[_builtins.int] = None,
                 heap_moving_average_window_size: Optional[_builtins.int] = None,
                 heap_percent_threshold: Optional[_builtins.float] = None,
                 heap_variance: Optional[_builtins.float] = None,
                 total_heap_percent_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.float cancellation_burst: The maximum number of search tasks to cancel in a single iteration of the observer thread. The maximum number of search tasks to cancel in a single iteration of the observer thread. Default is 10.0.
        :param _builtins.float cancellation_rate: The maximum number of tasks to cancel per millisecond of elapsed time. The maximum number of tasks to cancel per millisecond of elapsed time. Default is 0.003.
        :param _builtins.float cancellation_ratio: The maximum number of tasks to cancel. The maximum number of tasks to cancel, as a percentage of successful task completions. Default is 0.1.
        :param _builtins.int cpu_time_millis_threshold: The CPU usage threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. The CPU usage threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. Default is 15000.
        :param _builtins.int elapsed_time_millis_threshold: The elapsed time threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. The elapsed time threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. Default is 30000.
        :param _builtins.int heap_moving_average_window_size: The number of previously completed search shard tasks to consider when calculating the rolling average of heap usage. The number of previously completed search shard tasks to consider when calculating the rolling average of heap usage. Default is 100.
        :param _builtins.float heap_percent_threshold: The heap usage threshold (as a percentage) required for a single search shard task before it is considered for cancellation. The heap usage threshold (as a percentage) required for a single search shard task before it is considered for cancellation. Default is 0.5.
        :param _builtins.float heap_variance: The minimum variance required for a single search shard task’s heap usage compared to the rolling average of previously completed tasks before it is considered for cancellation. The minimum variance required for a single search shard task’s heap usage compared to the rolling average of previously completed tasks before it is considered for cancellation. Default is 2.0.
        :param _builtins.float total_heap_percent_threshold: The heap usage threshold (as a percentage) required for the sum of heap usages of all search shard tasks before cancellation is applied. The heap usage threshold (as a percentage) required for the sum of heap usages of all search shard tasks before cancellation is applied. Default is 0.5.
        """
        if cancellation_burst is not None:
            pulumi.set(__self__, "cancellation_burst", cancellation_burst)
        if cancellation_rate is not None:
            pulumi.set(__self__, "cancellation_rate", cancellation_rate)
        if cancellation_ratio is not None:
            pulumi.set(__self__, "cancellation_ratio", cancellation_ratio)
        if cpu_time_millis_threshold is not None:
            pulumi.set(__self__, "cpu_time_millis_threshold", cpu_time_millis_threshold)
        if elapsed_time_millis_threshold is not None:
            pulumi.set(__self__, "elapsed_time_millis_threshold", elapsed_time_millis_threshold)
        if heap_moving_average_window_size is not None:
            pulumi.set(__self__, "heap_moving_average_window_size", heap_moving_average_window_size)
        if heap_percent_threshold is not None:
            pulumi.set(__self__, "heap_percent_threshold", heap_percent_threshold)
        if heap_variance is not None:
            pulumi.set(__self__, "heap_variance", heap_variance)
        if total_heap_percent_threshold is not None:
            pulumi.set(__self__, "total_heap_percent_threshold", total_heap_percent_threshold)

    @_builtins.property
    @pulumi.getter(name="cancellationBurst")
    def cancellation_burst(self) -> Optional[_builtins.float]:
        """
        The maximum number of search tasks to cancel in a single iteration of the observer thread. The maximum number of search tasks to cancel in a single iteration of the observer thread. Default is 10.0.
        """
        return pulumi.get(self, "cancellation_burst")

    @_builtins.property
    @pulumi.getter(name="cancellationRate")
    def cancellation_rate(self) -> Optional[_builtins.float]:
        """
        The maximum number of tasks to cancel per millisecond of elapsed time. The maximum number of tasks to cancel per millisecond of elapsed time. Default is 0.003.
        """
        return pulumi.get(self, "cancellation_rate")

    @_builtins.property
    @pulumi.getter(name="cancellationRatio")
    def cancellation_ratio(self) -> Optional[_builtins.float]:
        """
        The maximum number of tasks to cancel. The maximum number of tasks to cancel, as a percentage of successful task completions. Default is 0.1.
        """
        return pulumi.get(self, "cancellation_ratio")

    @_builtins.property
    @pulumi.getter(name="cpuTimeMillisThreshold")
    def cpu_time_millis_threshold(self) -> Optional[_builtins.int]:
        """
        The CPU usage threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. The CPU usage threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. Default is 15000.
        """
        return pulumi.get(self, "cpu_time_millis_threshold")

    @_builtins.property
    @pulumi.getter(name="elapsedTimeMillisThreshold")
    def elapsed_time_millis_threshold(self) -> Optional[_builtins.int]:
        """
        The elapsed time threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. The elapsed time threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. Default is 30000.
        """
        return pulumi.get(self, "elapsed_time_millis_threshold")

    @_builtins.property
    @pulumi.getter(name="heapMovingAverageWindowSize")
    def heap_moving_average_window_size(self) -> Optional[_builtins.int]:
        """
        The number of previously completed search shard tasks to consider when calculating the rolling average of heap usage. The number of previously completed search shard tasks to consider when calculating the rolling average of heap usage. Default is 100.
        """
        return pulumi.get(self, "heap_moving_average_window_size")

    @_builtins.property
    @pulumi.getter(name="heapPercentThreshold")
    def heap_percent_threshold(self) -> Optional[_builtins.float]:
        """
        The heap usage threshold (as a percentage) required for a single search shard task before it is considered for cancellation. The heap usage threshold (as a percentage) required for a single search shard task before it is considered for cancellation. Default is 0.5.
        """
        return pulumi.get(self, "heap_percent_threshold")

    @_builtins.property
    @pulumi.getter(name="heapVariance")
    def heap_variance(self) -> Optional[_builtins.float]:
        """
        The minimum variance required for a single search shard task’s heap usage compared to the rolling average of previously completed tasks before it is considered for cancellation. The minimum variance required for a single search shard task’s heap usage compared to the rolling average of previously completed tasks before it is considered for cancellation. Default is 2.0.
        """
        return pulumi.get(self, "heap_variance")

    @_builtins.property
    @pulumi.getter(name="totalHeapPercentThreshold")
    def total_heap_percent_threshold(self) -> Optional[_builtins.float]:
        """
        The heap usage threshold (as a percentage) required for the sum of heap usages of all search shard tasks before cancellation is applied. The heap usage threshold (as a percentage) required for the sum of heap usages of all search shard tasks before cancellation is applied. Default is 0.5.
        """
        return pulumi.get(self, "total_heap_percent_threshold")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cancellationBurst":
            suggest = "cancellation_burst"
        elif key == "cancellationRate":
            suggest = "cancellation_rate"
        elif key == "cancellationRatio":
            suggest = "cancellation_ratio"
        elif key == "cpuTimeMillisThreshold":
            suggest = "cpu_time_millis_threshold"
        elif key == "elapsedTimeMillisThreshold":
            suggest = "elapsed_time_millis_threshold"
        elif key == "heapMovingAverageWindowSize":
            suggest = "heap_moving_average_window_size"
        elif key == "heapPercentThreshold":
            suggest = "heap_percent_threshold"
        elif key == "heapVariance":
            suggest = "heap_variance"
        elif key == "totalHeapPercentThreshold":
            suggest = "total_heap_percent_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchBackpressureSearchTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cancellation_burst: Optional[_builtins.float] = None,
                 cancellation_rate: Optional[_builtins.float] = None,
                 cancellation_ratio: Optional[_builtins.float] = None,
                 cpu_time_millis_threshold: Optional[_builtins.int] = None,
                 elapsed_time_millis_threshold: Optional[_builtins.int] = None,
                 heap_moving_average_window_size: Optional[_builtins.int] = None,
                 heap_percent_threshold: Optional[_builtins.float] = None,
                 heap_variance: Optional[_builtins.float] = None,
                 total_heap_percent_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.float cancellation_burst: The maximum number of search tasks to cancel in a single iteration of the observer thread. The maximum number of search tasks to cancel in a single iteration of the observer thread. Default is 5.0.
        :param _builtins.float cancellation_rate: The maximum number of search tasks to cancel per millisecond of elapsed time. The maximum number of search tasks to cancel per millisecond of elapsed time. Default is 0.003.
        :param _builtins.float cancellation_ratio: The maximum number of search tasks to cancel, as a percentage of successful search task completions. The maximum number of search tasks to cancel, as a percentage of successful search task completions. Default is 0.1.
        :param _builtins.int cpu_time_millis_threshold: The CPU usage threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. The CPU usage threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. Default is 30000.
        :param _builtins.int elapsed_time_millis_threshold: The elapsed time threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. The elapsed time threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. Default is 45000.
        :param _builtins.int heap_moving_average_window_size: The window size used to calculate the rolling average of the heap usage for the completed parent tasks. The window size used to calculate the rolling average of the heap usage for the completed parent tasks. Default is 10.
        :param _builtins.float heap_percent_threshold: The heap usage threshold (as a percentage) required for an individual parent task before it is considered for cancellation. The heap usage threshold (as a percentage) required for an individual parent task before it is considered for cancellation. Default is 0.2.
        :param _builtins.float heap_variance: The heap usage variance required for an individual parent task before it is considered for cancellation. The heap usage variance required for an individual parent task before it is considered for cancellation. A task is considered for cancellation when taskHeapUsage is greater than or equal to heapUsageMovingAverage * variance. Default is 2.0.
        :param _builtins.float total_heap_percent_threshold: The heap usage threshold (as a percentage) required for the sum of heap usages of all search tasks before cancellation is applied. The heap usage threshold (as a percentage) required for the sum of heap usages of all search tasks before cancellation is applied. Default is 0.5.
        """
        if cancellation_burst is not None:
            pulumi.set(__self__, "cancellation_burst", cancellation_burst)
        if cancellation_rate is not None:
            pulumi.set(__self__, "cancellation_rate", cancellation_rate)
        if cancellation_ratio is not None:
            pulumi.set(__self__, "cancellation_ratio", cancellation_ratio)
        if cpu_time_millis_threshold is not None:
            pulumi.set(__self__, "cpu_time_millis_threshold", cpu_time_millis_threshold)
        if elapsed_time_millis_threshold is not None:
            pulumi.set(__self__, "elapsed_time_millis_threshold", elapsed_time_millis_threshold)
        if heap_moving_average_window_size is not None:
            pulumi.set(__self__, "heap_moving_average_window_size", heap_moving_average_window_size)
        if heap_percent_threshold is not None:
            pulumi.set(__self__, "heap_percent_threshold", heap_percent_threshold)
        if heap_variance is not None:
            pulumi.set(__self__, "heap_variance", heap_variance)
        if total_heap_percent_threshold is not None:
            pulumi.set(__self__, "total_heap_percent_threshold", total_heap_percent_threshold)

    @_builtins.property
    @pulumi.getter(name="cancellationBurst")
    def cancellation_burst(self) -> Optional[_builtins.float]:
        """
        The maximum number of search tasks to cancel in a single iteration of the observer thread. The maximum number of search tasks to cancel in a single iteration of the observer thread. Default is 5.0.
        """
        return pulumi.get(self, "cancellation_burst")

    @_builtins.property
    @pulumi.getter(name="cancellationRate")
    def cancellation_rate(self) -> Optional[_builtins.float]:
        """
        The maximum number of search tasks to cancel per millisecond of elapsed time. The maximum number of search tasks to cancel per millisecond of elapsed time. Default is 0.003.
        """
        return pulumi.get(self, "cancellation_rate")

    @_builtins.property
    @pulumi.getter(name="cancellationRatio")
    def cancellation_ratio(self) -> Optional[_builtins.float]:
        """
        The maximum number of search tasks to cancel, as a percentage of successful search task completions. The maximum number of search tasks to cancel, as a percentage of successful search task completions. Default is 0.1.
        """
        return pulumi.get(self, "cancellation_ratio")

    @_builtins.property
    @pulumi.getter(name="cpuTimeMillisThreshold")
    def cpu_time_millis_threshold(self) -> Optional[_builtins.int]:
        """
        The CPU usage threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. The CPU usage threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. Default is 30000.
        """
        return pulumi.get(self, "cpu_time_millis_threshold")

    @_builtins.property
    @pulumi.getter(name="elapsedTimeMillisThreshold")
    def elapsed_time_millis_threshold(self) -> Optional[_builtins.int]:
        """
        The elapsed time threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. The elapsed time threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. Default is 45000.
        """
        return pulumi.get(self, "elapsed_time_millis_threshold")

    @_builtins.property
    @pulumi.getter(name="heapMovingAverageWindowSize")
    def heap_moving_average_window_size(self) -> Optional[_builtins.int]:
        """
        The window size used to calculate the rolling average of the heap usage for the completed parent tasks. The window size used to calculate the rolling average of the heap usage for the completed parent tasks. Default is 10.
        """
        return pulumi.get(self, "heap_moving_average_window_size")

    @_builtins.property
    @pulumi.getter(name="heapPercentThreshold")
    def heap_percent_threshold(self) -> Optional[_builtins.float]:
        """
        The heap usage threshold (as a percentage) required for an individual parent task before it is considered for cancellation. The heap usage threshold (as a percentage) required for an individual parent task before it is considered for cancellation. Default is 0.2.
        """
        return pulumi.get(self, "heap_percent_threshold")

    @_builtins.property
    @pulumi.getter(name="heapVariance")
    def heap_variance(self) -> Optional[_builtins.float]:
        """
        The heap usage variance required for an individual parent task before it is considered for cancellation. The heap usage variance required for an individual parent task before it is considered for cancellation. A task is considered for cancellation when taskHeapUsage is greater than or equal to heapUsageMovingAverage * variance. Default is 2.0.
        """
        return pulumi.get(self, "heap_variance")

    @_builtins.property
    @pulumi.getter(name="totalHeapPercentThreshold")
    def total_heap_percent_threshold(self) -> Optional[_builtins.float]:
        """
        The heap usage threshold (as a percentage) required for the sum of heap usages of all search tasks before cancellation is applied. The heap usage threshold (as a percentage) required for the sum of heap usages of all search tasks before cancellation is applied. Default is 0.5.
        """
        return pulumi.get(self, "total_heap_percent_threshold")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueries(dict):
    def __init__(__self__, *,
                 cpu: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu'] = None,
                 latency: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency'] = None,
                 memory: Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory'] = None):
        """
        :param 'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpuArgs' cpu: Top N queries monitoring by CPU.
        :param 'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatencyArgs' latency: Top N queries monitoring by latency.
        :param 'ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemoryArgs' memory: Top N queries monitoring by memory.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if latency is not None:
            pulumi.set(__self__, "latency", latency)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu']:
        """
        Top N queries monitoring by CPU.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def latency(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency']:
        """
        Top N queries monitoring by latency.
        """
        return pulumi.get(self, "latency")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory']:
        """
        Top N queries monitoring by memory.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topNSize":
            suggest = "top_n_size"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesCpu.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 top_n_size: Optional[_builtins.int] = None,
                 window_size: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable or disable top N query monitoring by the metric. Enable or disable top N query monitoring by the metric.
        :param _builtins.int top_n_size: Specify the value of N for the top N queries by the metric.
        :param _builtins.str window_size: The window size of the top N queries by the metric. Configure the window size of the top N queries.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if top_n_size is not None:
            pulumi.set(__self__, "top_n_size", top_n_size)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable top N query monitoring by the metric. Enable or disable top N query monitoring by the metric.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="topNSize")
    def top_n_size(self) -> Optional[_builtins.int]:
        """
        Specify the value of N for the top N queries by the metric.
        """
        return pulumi.get(self, "top_n_size")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[_builtins.str]:
        """
        The window size of the top N queries by the metric. Configure the window size of the top N queries.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topNSize":
            suggest = "top_n_size"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesLatency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 top_n_size: Optional[_builtins.int] = None,
                 window_size: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable or disable top N query monitoring by the metric. Enable or disable top N query monitoring by the metric.
        :param _builtins.int top_n_size: Specify the value of N for the top N queries by the metric.
        :param _builtins.str window_size: The window size of the top N queries by the metric. Configure the window size of the top N queries.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if top_n_size is not None:
            pulumi.set(__self__, "top_n_size", top_n_size)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable top N query monitoring by the metric. Enable or disable top N query monitoring by the metric.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="topNSize")
    def top_n_size(self) -> Optional[_builtins.int]:
        """
        Specify the value of N for the top N queries by the metric.
        """
        return pulumi.get(self, "top_n_size")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[_builtins.str]:
        """
        The window size of the top N queries by the metric. Configure the window size of the top N queries.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topNSize":
            suggest = "top_n_size"
        elif key == "windowSize":
            suggest = "window_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSearchInsightsTopQueriesMemory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 top_n_size: Optional[_builtins.int] = None,
                 window_size: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable or disable top N query monitoring by the metric. Enable or disable top N query monitoring by the metric.
        :param _builtins.int top_n_size: Specify the value of N for the top N queries by the metric.
        :param _builtins.str window_size: The window size of the top N queries by the metric. Configure the window size of the top N queries.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if top_n_size is not None:
            pulumi.set(__self__, "top_n_size", top_n_size)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable top N query monitoring by the metric. Enable or disable top N query monitoring by the metric.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="topNSize")
    def top_n_size(self) -> Optional[_builtins.int]:
        """
        Specify the value of N for the top N queries by the metric.
        """
        return pulumi.get(self, "top_n_size")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[_builtins.str]:
        """
        The window size of the top N queries by the metric. Configure the window size of the top N queries.
        """
        return pulumi.get(self, "window_size")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesSegrep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pressureCheckpointLimit":
            suggest = "pressure_checkpoint_limit"
        elif key == "pressureEnabled":
            suggest = "pressure_enabled"
        elif key == "pressureReplicaStaleLimit":
            suggest = "pressure_replica_stale_limit"
        elif key == "pressureTimeLimit":
            suggest = "pressure_time_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesSegrep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesSegrep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesSegrep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pressure_checkpoint_limit: Optional[_builtins.int] = None,
                 pressure_enabled: Optional[_builtins.bool] = None,
                 pressure_replica_stale_limit: Optional[_builtins.float] = None,
                 pressure_time_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.int pressure_checkpoint_limit: The maximum number of indexing checkpoints that a replica shard can fall behind when copying from primary. Once `segrep.pressure.checkpoint.limit` is breached along with `segrep.pressure.time.limit`, the segment replication backpressure mechanism is initiated. Default is 4 checkpoints.
        :param _builtins.bool pressure_enabled: Enables the segment replication backpressure mechanism. Default is false.
        :param _builtins.float pressure_replica_stale_limit: The maximum number of stale replica shards that can exist in a replication group. Once `segrep.pressure.replica.stale.limit` is breached, the segment replication backpressure mechanism is initiated. Default is .5, which is 50% of a replication group.
        :param _builtins.str pressure_time_limit: The maximum amount of time that a replica shard can take to copy from the primary shard. Once segrep.pressure.time.limit is breached along with segrep.pressure.checkpoint.limit, the segment replication backpressure mechanism is initiated. Default is 5 minutes.
        """
        if pressure_checkpoint_limit is not None:
            pulumi.set(__self__, "pressure_checkpoint_limit", pressure_checkpoint_limit)
        if pressure_enabled is not None:
            pulumi.set(__self__, "pressure_enabled", pressure_enabled)
        if pressure_replica_stale_limit is not None:
            pulumi.set(__self__, "pressure_replica_stale_limit", pressure_replica_stale_limit)
        if pressure_time_limit is not None:
            pulumi.set(__self__, "pressure_time_limit", pressure_time_limit)

    @_builtins.property
    @pulumi.getter(name="pressureCheckpointLimit")
    def pressure_checkpoint_limit(self) -> Optional[_builtins.int]:
        """
        The maximum number of indexing checkpoints that a replica shard can fall behind when copying from primary. Once `segrep.pressure.checkpoint.limit` is breached along with `segrep.pressure.time.limit`, the segment replication backpressure mechanism is initiated. Default is 4 checkpoints.
        """
        return pulumi.get(self, "pressure_checkpoint_limit")

    @_builtins.property
    @pulumi.getter(name="pressureEnabled")
    def pressure_enabled(self) -> Optional[_builtins.bool]:
        """
        Enables the segment replication backpressure mechanism. Default is false.
        """
        return pulumi.get(self, "pressure_enabled")

    @_builtins.property
    @pulumi.getter(name="pressureReplicaStaleLimit")
    def pressure_replica_stale_limit(self) -> Optional[_builtins.float]:
        """
        The maximum number of stale replica shards that can exist in a replication group. Once `segrep.pressure.replica.stale.limit` is breached, the segment replication backpressure mechanism is initiated. Default is .5, which is 50% of a replication group.
        """
        return pulumi.get(self, "pressure_replica_stale_limit")

    @_builtins.property
    @pulumi.getter(name="pressureTimeLimit")
    def pressure_time_limit(self) -> Optional[_builtins.str]:
        """
        The maximum amount of time that a replica shard can take to copy from the primary shard. Once segrep.pressure.time.limit is breached along with segrep.pressure.checkpoint.limit, the segment replication backpressure mechanism is initiated. Default is 5 minutes.
        """
        return pulumi.get(self, "pressure_time_limit")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesShardIndexingPressure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatingFactor":
            suggest = "operating_factor"
        elif key == "primaryParameter":
            suggest = "primary_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesShardIndexingPressure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesShardIndexingPressure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesShardIndexingPressure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 enforced: Optional[_builtins.bool] = None,
                 operating_factor: Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressureOperatingFactor'] = None,
                 primary_parameter: Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameter'] = None):
        """
        :param _builtins.bool enabled: Enable or disable shard indexing backpressure. Enable or disable shard indexing backpressure. Default is false.
        :param _builtins.bool enforced: Run shard indexing backpressure in shadow mode or enforced mode. Run shard indexing backpressure in shadow mode or enforced mode.
                           In shadow mode (value set as false), shard indexing backpressure tracks all granular-level metrics,
                           but it doesn’t actually reject any indexing requests.
                           In enforced mode (value set as true),
                           shard indexing backpressure rejects any requests to the cluster that might cause a dip in its performance.
                           Default is false.
        :param 'ManagedDatabaseOpensearchPropertiesShardIndexingPressureOperatingFactorArgs' operating_factor: Operating factor.
        :param 'ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterArgs' primary_parameter: Primary parameter.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if enforced is not None:
            pulumi.set(__self__, "enforced", enforced)
        if operating_factor is not None:
            pulumi.set(__self__, "operating_factor", operating_factor)
        if primary_parameter is not None:
            pulumi.set(__self__, "primary_parameter", primary_parameter)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable shard indexing backpressure. Enable or disable shard indexing backpressure. Default is false.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def enforced(self) -> Optional[_builtins.bool]:
        """
        Run shard indexing backpressure in shadow mode or enforced mode. Run shard indexing backpressure in shadow mode or enforced mode.
                    In shadow mode (value set as false), shard indexing backpressure tracks all granular-level metrics,
                    but it doesn’t actually reject any indexing requests.
                    In enforced mode (value set as true),
                    shard indexing backpressure rejects any requests to the cluster that might cause a dip in its performance.
                    Default is false.
        """
        return pulumi.get(self, "enforced")

    @_builtins.property
    @pulumi.getter(name="operatingFactor")
    def operating_factor(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressureOperatingFactor']:
        """
        Operating factor.
        """
        return pulumi.get(self, "operating_factor")

    @_builtins.property
    @pulumi.getter(name="primaryParameter")
    def primary_parameter(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameter']:
        """
        Primary parameter.
        """
        return pulumi.get(self, "primary_parameter")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesShardIndexingPressureOperatingFactor(dict):
    def __init__(__self__, *,
                 lower: Optional[_builtins.float] = None,
                 optimal: Optional[_builtins.float] = None,
                 upper: Optional[_builtins.float] = None):
        """
        :param _builtins.float lower: Lower occupancy limit of the allocated quota of memory for the shard. Specify the lower occupancy limit of the allocated quota of memory for the shard.
                                   If the total memory usage of a shard is below this limit,
                                   shard indexing backpressure decreases the current allocated memory for that shard.
                                   Default is 0.75.
        :param _builtins.float optimal: Optimal occupancy of the allocated quota of memory for the shard. Specify the optimal occupancy of the allocated quota of memory for the shard.
                                   If the total memory usage of a shard is at this level,
                                   shard indexing backpressure doesn’t change the current allocated memory for that shard.
                                   Default is 0.85.
        :param _builtins.float upper: Upper occupancy limit of the allocated quota of memory for the shard. Specify the upper occupancy limit of the allocated quota of memory for the shard.
                                   If the total memory usage of a shard is above this limit,
                                   shard indexing backpressure increases the current allocated memory for that shard.
                                   Default is 0.95.
        """
        if lower is not None:
            pulumi.set(__self__, "lower", lower)
        if optimal is not None:
            pulumi.set(__self__, "optimal", optimal)
        if upper is not None:
            pulumi.set(__self__, "upper", upper)

    @_builtins.property
    @pulumi.getter
    def lower(self) -> Optional[_builtins.float]:
        """
        Lower occupancy limit of the allocated quota of memory for the shard. Specify the lower occupancy limit of the allocated quota of memory for the shard.
                            If the total memory usage of a shard is below this limit,
                            shard indexing backpressure decreases the current allocated memory for that shard.
                            Default is 0.75.
        """
        return pulumi.get(self, "lower")

    @_builtins.property
    @pulumi.getter
    def optimal(self) -> Optional[_builtins.float]:
        """
        Optimal occupancy of the allocated quota of memory for the shard. Specify the optimal occupancy of the allocated quota of memory for the shard.
                            If the total memory usage of a shard is at this level,
                            shard indexing backpressure doesn’t change the current allocated memory for that shard.
                            Default is 0.85.
        """
        return pulumi.get(self, "optimal")

    @_builtins.property
    @pulumi.getter
    def upper(self) -> Optional[_builtins.float]:
        """
        Upper occupancy limit of the allocated quota of memory for the shard. Specify the upper occupancy limit of the allocated quota of memory for the shard.
                            If the total memory usage of a shard is above this limit,
                            shard indexing backpressure increases the current allocated memory for that shard.
                            Default is 0.95.
        """
        return pulumi.get(self, "upper")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameter(dict):
    def __init__(__self__, *,
                 node: Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode'] = None,
                 shard: Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard'] = None):
        if node is not None:
            pulumi.set(__self__, "node", node)
        if shard is not None:
            pulumi.set(__self__, "shard", shard)

    @_builtins.property
    @pulumi.getter
    def node(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode']:
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter
    def shard(self) -> Optional['outputs.ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard']:
        return pulumi.get(self, "shard")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "softLimit":
            suggest = "soft_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 soft_limit: Optional[_builtins.float] = None):
        """
        :param _builtins.float soft_limit: Node soft limit. Define the percentage of the node-level memory
                                           threshold that acts as a soft indicator for strain on a node.
                                           Default is 0.7.
        """
        if soft_limit is not None:
            pulumi.set(__self__, "soft_limit", soft_limit)

    @_builtins.property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> Optional[_builtins.float]:
        """
        Node soft limit. Define the percentage of the node-level memory
                                    threshold that acts as a soft indicator for strain on a node.
                                    Default is 0.7.
        """
        return pulumi.get(self, "soft_limit")


@pulumi.output_type
class ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minLimit":
            suggest = "min_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseOpensearchPropertiesShardIndexingPressurePrimaryParameterShard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_limit: Optional[_builtins.float] = None):
        """
        :param _builtins.float min_limit: Shard min limit. Specify the minimum assigned quota for a new shard in any role (coordinator, primary, or replica).
                                           Shard indexing backpressure increases or decreases this allocated quota based on the inflow of traffic for the shard.
                                           Default is 0.001.
        """
        if min_limit is not None:
            pulumi.set(__self__, "min_limit", min_limit)

    @_builtins.property
    @pulumi.getter(name="minLimit")
    def min_limit(self) -> Optional[_builtins.float]:
        """
        Shard min limit. Specify the minimum assigned quota for a new shard in any role (coordinator, primary, or replica).
                                    Shard indexing backpressure increases or decreases this allocated quota based on the inflow of traffic for the shard.
                                    Default is 0.001.
        """
        return pulumi.get(self, "min_limit")


@pulumi.output_type
class ManagedDatabasePostgresqlComponent(dict):
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 route: Optional[_builtins.str] = None,
                 usage: Optional[_builtins.str] = None):
        """
        :param _builtins.str component: Type of the component
        :param _builtins.str host: Hostname of the component
        :param _builtins.int port: Port number of the component
        :param _builtins.str route: Component network route type
        :param _builtins.str usage: Usage of the component
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if route is not None:
            pulumi.set(__self__, "route", route)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Type of the component
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname of the component
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the component
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def route(self) -> Optional[_builtins.str]:
        """
        Component network route type
        """
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.str]:
        """
        Usage of the component
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class ManagedDatabasePostgresqlNetwork(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str family: Network family. Currently only `IPv4` is supported.
        :param _builtins.str name: The name of the network. Must be unique within the service.
        :param _builtins.str type: The type of the network. Must be private.
        :param _builtins.str uuid: Private network UUID. Must reside in the same zone as the database.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. Currently only `IPv4` is supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the network. Must be private.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Private network UUID. Must reside in the same zone as the database.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ManagedDatabasePostgresqlNodeState(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name plus a node iteration
        :param _builtins.str role: Role of the node
        :param _builtins.str state: State of the node
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name plus a node iteration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Role of the node
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the node
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedDatabasePostgresqlProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "automaticUtilityNetworkIpFilter":
            suggest = "automatic_utility_network_ip_filter"
        elif key == "autovacuumAnalyzeScaleFactor":
            suggest = "autovacuum_analyze_scale_factor"
        elif key == "autovacuumAnalyzeThreshold":
            suggest = "autovacuum_analyze_threshold"
        elif key == "autovacuumFreezeMaxAge":
            suggest = "autovacuum_freeze_max_age"
        elif key == "autovacuumMaxWorkers":
            suggest = "autovacuum_max_workers"
        elif key == "autovacuumNaptime":
            suggest = "autovacuum_naptime"
        elif key == "autovacuumVacuumCostDelay":
            suggest = "autovacuum_vacuum_cost_delay"
        elif key == "autovacuumVacuumCostLimit":
            suggest = "autovacuum_vacuum_cost_limit"
        elif key == "autovacuumVacuumScaleFactor":
            suggest = "autovacuum_vacuum_scale_factor"
        elif key == "autovacuumVacuumThreshold":
            suggest = "autovacuum_vacuum_threshold"
        elif key == "backupHour":
            suggest = "backup_hour"
        elif key == "backupMinute":
            suggest = "backup_minute"
        elif key == "bgwriterDelay":
            suggest = "bgwriter_delay"
        elif key == "bgwriterFlushAfter":
            suggest = "bgwriter_flush_after"
        elif key == "bgwriterLruMaxpages":
            suggest = "bgwriter_lru_maxpages"
        elif key == "bgwriterLruMultiplier":
            suggest = "bgwriter_lru_multiplier"
        elif key == "deadlockTimeout":
            suggest = "deadlock_timeout"
        elif key == "defaultToastCompression":
            suggest = "default_toast_compression"
        elif key == "idleInTransactionSessionTimeout":
            suggest = "idle_in_transaction_session_timeout"
        elif key == "ipFilters":
            suggest = "ip_filters"
        elif key == "logAutovacuumMinDuration":
            suggest = "log_autovacuum_min_duration"
        elif key == "logErrorVerbosity":
            suggest = "log_error_verbosity"
        elif key == "logLinePrefix":
            suggest = "log_line_prefix"
        elif key == "logMinDurationStatement":
            suggest = "log_min_duration_statement"
        elif key == "logTempFiles":
            suggest = "log_temp_files"
        elif key == "maxConnections":
            suggest = "max_connections"
        elif key == "maxFilesPerProcess":
            suggest = "max_files_per_process"
        elif key == "maxLocksPerTransaction":
            suggest = "max_locks_per_transaction"
        elif key == "maxLogicalReplicationWorkers":
            suggest = "max_logical_replication_workers"
        elif key == "maxParallelWorkers":
            suggest = "max_parallel_workers"
        elif key == "maxParallelWorkersPerGather":
            suggest = "max_parallel_workers_per_gather"
        elif key == "maxPredLocksPerTransaction":
            suggest = "max_pred_locks_per_transaction"
        elif key == "maxPreparedTransactions":
            suggest = "max_prepared_transactions"
        elif key == "maxReplicationSlots":
            suggest = "max_replication_slots"
        elif key == "maxSlotWalKeepSize":
            suggest = "max_slot_wal_keep_size"
        elif key == "maxStackDepth":
            suggest = "max_stack_depth"
        elif key == "maxStandbyArchiveDelay":
            suggest = "max_standby_archive_delay"
        elif key == "maxStandbyStreamingDelay":
            suggest = "max_standby_streaming_delay"
        elif key == "maxSyncWorkersPerSubscription":
            suggest = "max_sync_workers_per_subscription"
        elif key == "maxWalSenders":
            suggest = "max_wal_senders"
        elif key == "maxWorkerProcesses":
            suggest = "max_worker_processes"
        elif key == "passwordEncryption":
            suggest = "password_encryption"
        elif key == "pgPartmanBgwInterval":
            suggest = "pg_partman_bgw_interval"
        elif key == "pgPartmanBgwRole":
            suggest = "pg_partman_bgw_role"
        elif key == "pgStatMonitorEnable":
            suggest = "pg_stat_monitor_enable"
        elif key == "pgStatMonitorPgsmEnableQueryPlan":
            suggest = "pg_stat_monitor_pgsm_enable_query_plan"
        elif key == "pgStatMonitorPgsmMaxBuckets":
            suggest = "pg_stat_monitor_pgsm_max_buckets"
        elif key == "pgStatStatementsTrack":
            suggest = "pg_stat_statements_track"
        elif key == "publicAccess":
            suggest = "public_access"
        elif key == "serviceLog":
            suggest = "service_log"
        elif key == "sharedBuffersPercentage":
            suggest = "shared_buffers_percentage"
        elif key == "synchronousReplication":
            suggest = "synchronous_replication"
        elif key == "tempFileLimit":
            suggest = "temp_file_limit"
        elif key == "trackActivityQuerySize":
            suggest = "track_activity_query_size"
        elif key == "trackCommitTimestamp":
            suggest = "track_commit_timestamp"
        elif key == "trackFunctions":
            suggest = "track_functions"
        elif key == "trackIoTiming":
            suggest = "track_io_timing"
        elif key == "walSenderTimeout":
            suggest = "wal_sender_timeout"
        elif key == "walWriterDelay":
            suggest = "wal_writer_delay"
        elif key == "workMem":
            suggest = "work_mem"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePostgresqlProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePostgresqlProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePostgresqlProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[_builtins.str] = None,
                 admin_username: Optional[_builtins.str] = None,
                 automatic_utility_network_ip_filter: Optional[_builtins.bool] = None,
                 autovacuum_analyze_scale_factor: Optional[_builtins.float] = None,
                 autovacuum_analyze_threshold: Optional[_builtins.int] = None,
                 autovacuum_freeze_max_age: Optional[_builtins.int] = None,
                 autovacuum_max_workers: Optional[_builtins.int] = None,
                 autovacuum_naptime: Optional[_builtins.int] = None,
                 autovacuum_vacuum_cost_delay: Optional[_builtins.int] = None,
                 autovacuum_vacuum_cost_limit: Optional[_builtins.int] = None,
                 autovacuum_vacuum_scale_factor: Optional[_builtins.float] = None,
                 autovacuum_vacuum_threshold: Optional[_builtins.int] = None,
                 backup_hour: Optional[_builtins.int] = None,
                 backup_minute: Optional[_builtins.int] = None,
                 bgwriter_delay: Optional[_builtins.int] = None,
                 bgwriter_flush_after: Optional[_builtins.int] = None,
                 bgwriter_lru_maxpages: Optional[_builtins.int] = None,
                 bgwriter_lru_multiplier: Optional[_builtins.float] = None,
                 deadlock_timeout: Optional[_builtins.int] = None,
                 default_toast_compression: Optional[_builtins.str] = None,
                 idle_in_transaction_session_timeout: Optional[_builtins.int] = None,
                 ip_filters: Optional[Sequence[_builtins.str]] = None,
                 jit: Optional[_builtins.bool] = None,
                 log_autovacuum_min_duration: Optional[_builtins.int] = None,
                 log_error_verbosity: Optional[_builtins.str] = None,
                 log_line_prefix: Optional[_builtins.str] = None,
                 log_min_duration_statement: Optional[_builtins.int] = None,
                 log_temp_files: Optional[_builtins.int] = None,
                 max_connections: Optional[_builtins.int] = None,
                 max_files_per_process: Optional[_builtins.int] = None,
                 max_locks_per_transaction: Optional[_builtins.int] = None,
                 max_logical_replication_workers: Optional[_builtins.int] = None,
                 max_parallel_workers: Optional[_builtins.int] = None,
                 max_parallel_workers_per_gather: Optional[_builtins.int] = None,
                 max_pred_locks_per_transaction: Optional[_builtins.int] = None,
                 max_prepared_transactions: Optional[_builtins.int] = None,
                 max_replication_slots: Optional[_builtins.int] = None,
                 max_slot_wal_keep_size: Optional[_builtins.int] = None,
                 max_stack_depth: Optional[_builtins.int] = None,
                 max_standby_archive_delay: Optional[_builtins.int] = None,
                 max_standby_streaming_delay: Optional[_builtins.int] = None,
                 max_sync_workers_per_subscription: Optional[_builtins.int] = None,
                 max_wal_senders: Optional[_builtins.int] = None,
                 max_worker_processes: Optional[_builtins.int] = None,
                 migration: Optional['outputs.ManagedDatabasePostgresqlPropertiesMigration'] = None,
                 password_encryption: Optional[_builtins.str] = None,
                 pg_partman_bgw_interval: Optional[_builtins.int] = None,
                 pg_partman_bgw_role: Optional[_builtins.str] = None,
                 pg_stat_monitor_enable: Optional[_builtins.bool] = None,
                 pg_stat_monitor_pgsm_enable_query_plan: Optional[_builtins.bool] = None,
                 pg_stat_monitor_pgsm_max_buckets: Optional[_builtins.int] = None,
                 pg_stat_statements_track: Optional[_builtins.str] = None,
                 pgaudit: Optional['outputs.ManagedDatabasePostgresqlPropertiesPgaudit'] = None,
                 pgbouncer: Optional['outputs.ManagedDatabasePostgresqlPropertiesPgbouncer'] = None,
                 pglookout: Optional['outputs.ManagedDatabasePostgresqlPropertiesPglookout'] = None,
                 public_access: Optional[_builtins.bool] = None,
                 service_log: Optional[_builtins.bool] = None,
                 shared_buffers_percentage: Optional[_builtins.float] = None,
                 synchronous_replication: Optional[_builtins.str] = None,
                 temp_file_limit: Optional[_builtins.int] = None,
                 timescaledb: Optional['outputs.ManagedDatabasePostgresqlPropertiesTimescaledb'] = None,
                 timezone: Optional[_builtins.str] = None,
                 track_activity_query_size: Optional[_builtins.int] = None,
                 track_commit_timestamp: Optional[_builtins.str] = None,
                 track_functions: Optional[_builtins.str] = None,
                 track_io_timing: Optional[_builtins.str] = None,
                 variant: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None,
                 wal_sender_timeout: Optional[_builtins.int] = None,
                 wal_writer_delay: Optional[_builtins.int] = None,
                 work_mem: Optional[_builtins.int] = None):
        """
        :param _builtins.str admin_password: Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
        :param _builtins.str admin_username: Custom username for admin user. This must be set only when a new service is being created.
        :param _builtins.bool automatic_utility_network_ip_filter: Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        :param _builtins.float autovacuum_analyze_scale_factor: Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE (e.g. `0.2` for 20% of the table size). The default is `0.2`.
        :param _builtins.int autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is `50`.
        :param _builtins.int autovacuum_freeze_max_age: Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. The system launches autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. Changing this parameter causes a service restart.
        :param _builtins.int autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is `3`. Changing this parameter causes a service restart.
        :param _builtins.int autovacuum_naptime: Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds. The default is `60`.
        :param _builtins.int autovacuum_vacuum_cost_delay: Specifies the cost delay value that will be used in automatic VACUUM operations. If `-1` is specified, the regular vacuum_cost_delay value will be used. The default is `2` (upstream default).
        :param _builtins.int autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If `-1` is specified, the regular vacuum_cost_limit value will be used. The default is `-1` (upstream default).
        :param _builtins.float autovacuum_vacuum_scale_factor: Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM (e.g. `0.2` for 20% of the table size). The default is `0.2`.
        :param _builtins.int autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is `50`.
        :param _builtins.int backup_hour: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.int backup_minute: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.int bgwriter_delay: Specifies the delay between activity rounds for the background writer in milliseconds. The default is `200`.
        :param _builtins.int bgwriter_flush_after: Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes. Setting of 0 disables forced writeback. The default is `512`.
        :param _builtins.int bgwriter_lru_maxpages: In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. The default is `100`.
        :param _builtins.float bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is `2.0`.
        :param _builtins.int deadlock_timeout: This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition. The default is `1000` (upstream default).
        :param _builtins.str default_toast_compression: Specifies the default TOAST compression method for values of compressible columns. The default is `lz4`. Only available for PostgreSQL 14+.
        :param _builtins.int idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds.
        :param Sequence[_builtins.str] ip_filters: IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        :param _builtins.bool jit: Controls system-wide use of Just-in-Time Compilation (JIT).
        :param _builtins.int log_autovacuum_min_duration: Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one disables logging autovacuum actions. The default is `1000`.
        :param _builtins.str log_error_verbosity: Controls the amount of detail written in the server log for each message that is logged.
        :param _builtins.str log_line_prefix: Choose from one of the available log formats.
        :param _builtins.int log_min_duration_statement: Log statements that take more than this number of milliseconds to run, -1 disables.
        :param _builtins.int log_temp_files: Log statements for each temporary file created larger than this number of kilobytes, -1 disables.
        :param _builtins.int max_connections: PostgreSQL maximum number of concurrent connections to the database server. Changing this parameter causes a service restart.
        :param _builtins.int max_files_per_process: PostgreSQL maximum number of files that can be open per process. The default is `1000` (upstream default). Changing this parameter causes a service restart.
        :param _builtins.int max_locks_per_transaction: PostgreSQL maximum locks per transaction. Changing this parameter causes a service restart.
        :param _builtins.int max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers). The default is `4` (upstream default). Changing this parameter causes a service restart.
        :param _builtins.int max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries. The default is `8` (upstream default).
        :param _builtins.int max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node. The default is `2` (upstream default).
        :param _builtins.int max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction. The default is `64` (upstream default). Changing this parameter causes a service restart.
        :param _builtins.int max_prepared_transactions: PostgreSQL maximum prepared transactions. The default is `0`. Changing this parameter causes a service restart.
        :param _builtins.int max_replication_slots: PostgreSQL maximum replication slots. The default is `20`. Changing this parameter causes a service restart.
        :param _builtins.int max_slot_wal_keep_size: PostgreSQL maximum WAL size (MB) reserved for replication slots. If `-1` is specified, replication slots may retain an unlimited amount of WAL files. The default is `-1` (upstream default). wal_keep_size minimum WAL size setting takes precedence over this.
        :param _builtins.int max_stack_depth: Maximum depth of the stack in bytes. The default is `2097152` (upstream default).
        :param _builtins.int max_standby_archive_delay: Max standby archive delay in milliseconds. The default is `30000` (upstream default).
        :param _builtins.int max_standby_streaming_delay: Max standby streaming delay in milliseconds. The default is `30000` (upstream default).
        :param _builtins.int max_sync_workers_per_subscription: Maximum number of synchronization workers per subscription. The default is `2`.
        :param _builtins.int max_wal_senders: PostgreSQL maximum WAL senders. The default is `20`. Changing this parameter causes a service restart.
        :param _builtins.int max_worker_processes: Sets the maximum number of background processes that the system can support. The default is `8`. Changing this parameter causes a service restart.
        :param 'ManagedDatabasePostgresqlPropertiesMigrationArgs' migration: Migrate data from existing server.
        :param _builtins.str password_encryption: Chooses the algorithm for encrypting passwords.
        :param _builtins.int pg_partman_bgw_interval: Sets the time interval in seconds to run pg_partman's scheduled tasks. The default is `3600`.
        :param _builtins.str pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks.
        :param _builtins.bool pg_stat_monitor_enable: Enable pg_stat_monitor extension if available for the current cluster. Enable the pg_stat_monitor extension. Changing this parameter causes a service restart. When this extension is enabled, pg_stat_statements results for utility commands are unreliable.
        :param _builtins.bool pg_stat_monitor_pgsm_enable_query_plan: Enables or disables query plan monitoring. Changing this parameter causes a service restart. Only available for PostgreSQL 13+.
        :param _builtins.int pg_stat_monitor_pgsm_max_buckets: Sets the maximum number of buckets. Changing this parameter causes a service restart. Only available for PostgreSQL 13+.
        :param _builtins.str pg_stat_statements_track: Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default is `top`.
        :param 'ManagedDatabasePostgresqlPropertiesPgauditArgs' pgaudit: PGAudit settings. System-wide settings for the pgaudit extension.
        :param 'ManagedDatabasePostgresqlPropertiesPgbouncerArgs' pgbouncer: PGBouncer connection pooling settings. System-wide settings for pgbouncer.
        :param 'ManagedDatabasePostgresqlPropertiesPglookoutArgs' pglookout: PGLookout settings. System-wide settings for pglookout.
        :param _builtins.bool public_access: Public Access. Allow access to the service from the public Internet.
        :param _builtins.bool service_log: Service logging. Store logs for the service so that they are available in the HTTP API and console.
        :param _builtins.float shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value. Changing this parameter causes a service restart.
        :param _builtins.str synchronous_replication: Synchronous replication type. Note that the service plan also needs to support synchronous replication.
        :param _builtins.int temp_file_limit: PostgreSQL temporary file limit in KiB, -1 for unlimited.
        :param 'ManagedDatabasePostgresqlPropertiesTimescaledbArgs' timescaledb: TimescaleDB extension configuration values. System-wide settings for the timescaledb extension.
        :param _builtins.str timezone: PostgreSQL service timezone.
        :param _builtins.int track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session. Changing this parameter causes a service restart.
        :param _builtins.str track_commit_timestamp: Record commit time of transactions. Changing this parameter causes a service restart.
        :param _builtins.str track_functions: Enables tracking of function call counts and time used.
        :param _builtins.str track_io_timing: Enables timing of database I/O calls. The default is `off`. When on, it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        :param _builtins.str variant: Variant of the PostgreSQL service, may affect the features that are exposed by default.
        :param _builtins.str version: PostgreSQL major version.
        :param _builtins.int wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        :param _builtins.int wal_writer_delay: WAL flush interval in milliseconds. The default is `200`. Setting this parameter to a lower value may negatively impact performance.
        :param _builtins.int work_mem: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. The default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if automatic_utility_network_ip_filter is not None:
            pulumi.set(__self__, "automatic_utility_network_ip_filter", automatic_utility_network_ip_filter)
        if autovacuum_analyze_scale_factor is not None:
            pulumi.set(__self__, "autovacuum_analyze_scale_factor", autovacuum_analyze_scale_factor)
        if autovacuum_analyze_threshold is not None:
            pulumi.set(__self__, "autovacuum_analyze_threshold", autovacuum_analyze_threshold)
        if autovacuum_freeze_max_age is not None:
            pulumi.set(__self__, "autovacuum_freeze_max_age", autovacuum_freeze_max_age)
        if autovacuum_max_workers is not None:
            pulumi.set(__self__, "autovacuum_max_workers", autovacuum_max_workers)
        if autovacuum_naptime is not None:
            pulumi.set(__self__, "autovacuum_naptime", autovacuum_naptime)
        if autovacuum_vacuum_cost_delay is not None:
            pulumi.set(__self__, "autovacuum_vacuum_cost_delay", autovacuum_vacuum_cost_delay)
        if autovacuum_vacuum_cost_limit is not None:
            pulumi.set(__self__, "autovacuum_vacuum_cost_limit", autovacuum_vacuum_cost_limit)
        if autovacuum_vacuum_scale_factor is not None:
            pulumi.set(__self__, "autovacuum_vacuum_scale_factor", autovacuum_vacuum_scale_factor)
        if autovacuum_vacuum_threshold is not None:
            pulumi.set(__self__, "autovacuum_vacuum_threshold", autovacuum_vacuum_threshold)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if bgwriter_delay is not None:
            pulumi.set(__self__, "bgwriter_delay", bgwriter_delay)
        if bgwriter_flush_after is not None:
            pulumi.set(__self__, "bgwriter_flush_after", bgwriter_flush_after)
        if bgwriter_lru_maxpages is not None:
            pulumi.set(__self__, "bgwriter_lru_maxpages", bgwriter_lru_maxpages)
        if bgwriter_lru_multiplier is not None:
            pulumi.set(__self__, "bgwriter_lru_multiplier", bgwriter_lru_multiplier)
        if deadlock_timeout is not None:
            pulumi.set(__self__, "deadlock_timeout", deadlock_timeout)
        if default_toast_compression is not None:
            pulumi.set(__self__, "default_toast_compression", default_toast_compression)
        if idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "idle_in_transaction_session_timeout", idle_in_transaction_session_timeout)
        if ip_filters is not None:
            pulumi.set(__self__, "ip_filters", ip_filters)
        if jit is not None:
            pulumi.set(__self__, "jit", jit)
        if log_autovacuum_min_duration is not None:
            pulumi.set(__self__, "log_autovacuum_min_duration", log_autovacuum_min_duration)
        if log_error_verbosity is not None:
            pulumi.set(__self__, "log_error_verbosity", log_error_verbosity)
        if log_line_prefix is not None:
            pulumi.set(__self__, "log_line_prefix", log_line_prefix)
        if log_min_duration_statement is not None:
            pulumi.set(__self__, "log_min_duration_statement", log_min_duration_statement)
        if log_temp_files is not None:
            pulumi.set(__self__, "log_temp_files", log_temp_files)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_files_per_process is not None:
            pulumi.set(__self__, "max_files_per_process", max_files_per_process)
        if max_locks_per_transaction is not None:
            pulumi.set(__self__, "max_locks_per_transaction", max_locks_per_transaction)
        if max_logical_replication_workers is not None:
            pulumi.set(__self__, "max_logical_replication_workers", max_logical_replication_workers)
        if max_parallel_workers is not None:
            pulumi.set(__self__, "max_parallel_workers", max_parallel_workers)
        if max_parallel_workers_per_gather is not None:
            pulumi.set(__self__, "max_parallel_workers_per_gather", max_parallel_workers_per_gather)
        if max_pred_locks_per_transaction is not None:
            pulumi.set(__self__, "max_pred_locks_per_transaction", max_pred_locks_per_transaction)
        if max_prepared_transactions is not None:
            pulumi.set(__self__, "max_prepared_transactions", max_prepared_transactions)
        if max_replication_slots is not None:
            pulumi.set(__self__, "max_replication_slots", max_replication_slots)
        if max_slot_wal_keep_size is not None:
            pulumi.set(__self__, "max_slot_wal_keep_size", max_slot_wal_keep_size)
        if max_stack_depth is not None:
            pulumi.set(__self__, "max_stack_depth", max_stack_depth)
        if max_standby_archive_delay is not None:
            pulumi.set(__self__, "max_standby_archive_delay", max_standby_archive_delay)
        if max_standby_streaming_delay is not None:
            pulumi.set(__self__, "max_standby_streaming_delay", max_standby_streaming_delay)
        if max_sync_workers_per_subscription is not None:
            pulumi.set(__self__, "max_sync_workers_per_subscription", max_sync_workers_per_subscription)
        if max_wal_senders is not None:
            pulumi.set(__self__, "max_wal_senders", max_wal_senders)
        if max_worker_processes is not None:
            pulumi.set(__self__, "max_worker_processes", max_worker_processes)
        if migration is not None:
            pulumi.set(__self__, "migration", migration)
        if password_encryption is not None:
            pulumi.set(__self__, "password_encryption", password_encryption)
        if pg_partman_bgw_interval is not None:
            pulumi.set(__self__, "pg_partman_bgw_interval", pg_partman_bgw_interval)
        if pg_partman_bgw_role is not None:
            pulumi.set(__self__, "pg_partman_bgw_role", pg_partman_bgw_role)
        if pg_stat_monitor_enable is not None:
            pulumi.set(__self__, "pg_stat_monitor_enable", pg_stat_monitor_enable)
        if pg_stat_monitor_pgsm_enable_query_plan is not None:
            pulumi.set(__self__, "pg_stat_monitor_pgsm_enable_query_plan", pg_stat_monitor_pgsm_enable_query_plan)
        if pg_stat_monitor_pgsm_max_buckets is not None:
            pulumi.set(__self__, "pg_stat_monitor_pgsm_max_buckets", pg_stat_monitor_pgsm_max_buckets)
        if pg_stat_statements_track is not None:
            pulumi.set(__self__, "pg_stat_statements_track", pg_stat_statements_track)
        if pgaudit is not None:
            pulumi.set(__self__, "pgaudit", pgaudit)
        if pgbouncer is not None:
            pulumi.set(__self__, "pgbouncer", pgbouncer)
        if pglookout is not None:
            pulumi.set(__self__, "pglookout", pglookout)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if service_log is not None:
            pulumi.set(__self__, "service_log", service_log)
        if shared_buffers_percentage is not None:
            pulumi.set(__self__, "shared_buffers_percentage", shared_buffers_percentage)
        if synchronous_replication is not None:
            pulumi.set(__self__, "synchronous_replication", synchronous_replication)
        if temp_file_limit is not None:
            pulumi.set(__self__, "temp_file_limit", temp_file_limit)
        if timescaledb is not None:
            pulumi.set(__self__, "timescaledb", timescaledb)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if track_activity_query_size is not None:
            pulumi.set(__self__, "track_activity_query_size", track_activity_query_size)
        if track_commit_timestamp is not None:
            pulumi.set(__self__, "track_commit_timestamp", track_commit_timestamp)
        if track_functions is not None:
            pulumi.set(__self__, "track_functions", track_functions)
        if track_io_timing is not None:
            pulumi.set(__self__, "track_io_timing", track_io_timing)
        if variant is not None:
            pulumi.set(__self__, "variant", variant)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wal_sender_timeout is not None:
            pulumi.set(__self__, "wal_sender_timeout", wal_sender_timeout)
        if wal_writer_delay is not None:
            pulumi.set(__self__, "wal_writer_delay", wal_writer_delay)
        if work_mem is not None:
            pulumi.set(__self__, "work_mem", work_mem)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[_builtins.str]:
        """
        Custom username for admin user. This must be set only when a new service is being created.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="automaticUtilityNetworkIpFilter")
    def automatic_utility_network_ip_filter(self) -> Optional[_builtins.bool]:
        """
        Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        """
        return pulumi.get(self, "automatic_utility_network_ip_filter")

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeScaleFactor")
    def autovacuum_analyze_scale_factor(self) -> Optional[_builtins.float]:
        """
        Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE (e.g. `0.2` for 20% of the table size). The default is `0.2`.
        """
        return pulumi.get(self, "autovacuum_analyze_scale_factor")

    @_builtins.property
    @pulumi.getter(name="autovacuumAnalyzeThreshold")
    def autovacuum_analyze_threshold(self) -> Optional[_builtins.int]:
        """
        Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is `50`.
        """
        return pulumi.get(self, "autovacuum_analyze_threshold")

    @_builtins.property
    @pulumi.getter(name="autovacuumFreezeMaxAge")
    def autovacuum_freeze_max_age(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. The system launches autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "autovacuum_freeze_max_age")

    @_builtins.property
    @pulumi.getter(name="autovacuumMaxWorkers")
    def autovacuum_max_workers(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is `3`. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "autovacuum_max_workers")

    @_builtins.property
    @pulumi.getter(name="autovacuumNaptime")
    def autovacuum_naptime(self) -> Optional[_builtins.int]:
        """
        Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds. The default is `60`.
        """
        return pulumi.get(self, "autovacuum_naptime")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostDelay")
    def autovacuum_vacuum_cost_delay(self) -> Optional[_builtins.int]:
        """
        Specifies the cost delay value that will be used in automatic VACUUM operations. If `-1` is specified, the regular vacuum_cost_delay value will be used. The default is `2` (upstream default).
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_delay")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumCostLimit")
    def autovacuum_vacuum_cost_limit(self) -> Optional[_builtins.int]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If `-1` is specified, the regular vacuum_cost_limit value will be used. The default is `-1` (upstream default).
        """
        return pulumi.get(self, "autovacuum_vacuum_cost_limit")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumScaleFactor")
    def autovacuum_vacuum_scale_factor(self) -> Optional[_builtins.float]:
        """
        Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM (e.g. `0.2` for 20% of the table size). The default is `0.2`.
        """
        return pulumi.get(self, "autovacuum_vacuum_scale_factor")

    @_builtins.property
    @pulumi.getter(name="autovacuumVacuumThreshold")
    def autovacuum_vacuum_threshold(self) -> Optional[_builtins.int]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is `50`.
        """
        return pulumi.get(self, "autovacuum_vacuum_threshold")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[_builtins.int]:
        """
        The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[_builtins.int]:
        """
        The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="bgwriterDelay")
    def bgwriter_delay(self) -> Optional[_builtins.int]:
        """
        Specifies the delay between activity rounds for the background writer in milliseconds. The default is `200`.
        """
        return pulumi.get(self, "bgwriter_delay")

    @_builtins.property
    @pulumi.getter(name="bgwriterFlushAfter")
    def bgwriter_flush_after(self) -> Optional[_builtins.int]:
        """
        Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes. Setting of 0 disables forced writeback. The default is `512`.
        """
        return pulumi.get(self, "bgwriter_flush_after")

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMaxpages")
    def bgwriter_lru_maxpages(self) -> Optional[_builtins.int]:
        """
        In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. The default is `100`.
        """
        return pulumi.get(self, "bgwriter_lru_maxpages")

    @_builtins.property
    @pulumi.getter(name="bgwriterLruMultiplier")
    def bgwriter_lru_multiplier(self) -> Optional[_builtins.float]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is `2.0`.
        """
        return pulumi.get(self, "bgwriter_lru_multiplier")

    @_builtins.property
    @pulumi.getter(name="deadlockTimeout")
    def deadlock_timeout(self) -> Optional[_builtins.int]:
        """
        This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition. The default is `1000` (upstream default).
        """
        return pulumi.get(self, "deadlock_timeout")

    @_builtins.property
    @pulumi.getter(name="defaultToastCompression")
    def default_toast_compression(self) -> Optional[_builtins.str]:
        """
        Specifies the default TOAST compression method for values of compressible columns. The default is `lz4`. Only available for PostgreSQL 14+.
        """
        return pulumi.get(self, "default_toast_compression")

    @_builtins.property
    @pulumi.getter(name="idleInTransactionSessionTimeout")
    def idle_in_transaction_session_timeout(self) -> Optional[_builtins.int]:
        """
        Time out sessions with open transactions after this number of milliseconds.
        """
        return pulumi.get(self, "idle_in_transaction_session_timeout")

    @_builtins.property
    @pulumi.getter(name="ipFilters")
    def ip_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        """
        return pulumi.get(self, "ip_filters")

    @_builtins.property
    @pulumi.getter
    def jit(self) -> Optional[_builtins.bool]:
        """
        Controls system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "jit")

    @_builtins.property
    @pulumi.getter(name="logAutovacuumMinDuration")
    def log_autovacuum_min_duration(self) -> Optional[_builtins.int]:
        """
        Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one disables logging autovacuum actions. The default is `1000`.
        """
        return pulumi.get(self, "log_autovacuum_min_duration")

    @_builtins.property
    @pulumi.getter(name="logErrorVerbosity")
    def log_error_verbosity(self) -> Optional[_builtins.str]:
        """
        Controls the amount of detail written in the server log for each message that is logged.
        """
        return pulumi.get(self, "log_error_verbosity")

    @_builtins.property
    @pulumi.getter(name="logLinePrefix")
    def log_line_prefix(self) -> Optional[_builtins.str]:
        """
        Choose from one of the available log formats.
        """
        return pulumi.get(self, "log_line_prefix")

    @_builtins.property
    @pulumi.getter(name="logMinDurationStatement")
    def log_min_duration_statement(self) -> Optional[_builtins.int]:
        """
        Log statements that take more than this number of milliseconds to run, -1 disables.
        """
        return pulumi.get(self, "log_min_duration_statement")

    @_builtins.property
    @pulumi.getter(name="logTempFiles")
    def log_temp_files(self) -> Optional[_builtins.int]:
        """
        Log statements for each temporary file created larger than this number of kilobytes, -1 disables.
        """
        return pulumi.get(self, "log_temp_files")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum number of concurrent connections to the database server. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxFilesPerProcess")
    def max_files_per_process(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum number of files that can be open per process. The default is `1000` (upstream default). Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_files_per_process")

    @_builtins.property
    @pulumi.getter(name="maxLocksPerTransaction")
    def max_locks_per_transaction(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum locks per transaction. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_locks_per_transaction")

    @_builtins.property
    @pulumi.getter(name="maxLogicalReplicationWorkers")
    def max_logical_replication_workers(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers). The default is `4` (upstream default). Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_logical_replication_workers")

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkers")
    def max_parallel_workers(self) -> Optional[_builtins.int]:
        """
        Sets the maximum number of workers that the system can support for parallel queries. The default is `8` (upstream default).
        """
        return pulumi.get(self, "max_parallel_workers")

    @_builtins.property
    @pulumi.getter(name="maxParallelWorkersPerGather")
    def max_parallel_workers_per_gather(self) -> Optional[_builtins.int]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node. The default is `2` (upstream default).
        """
        return pulumi.get(self, "max_parallel_workers_per_gather")

    @_builtins.property
    @pulumi.getter(name="maxPredLocksPerTransaction")
    def max_pred_locks_per_transaction(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum predicate locks per transaction. The default is `64` (upstream default). Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_pred_locks_per_transaction")

    @_builtins.property
    @pulumi.getter(name="maxPreparedTransactions")
    def max_prepared_transactions(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum prepared transactions. The default is `0`. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_prepared_transactions")

    @_builtins.property
    @pulumi.getter(name="maxReplicationSlots")
    def max_replication_slots(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum replication slots. The default is `20`. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_replication_slots")

    @_builtins.property
    @pulumi.getter(name="maxSlotWalKeepSize")
    def max_slot_wal_keep_size(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum WAL size (MB) reserved for replication slots. If `-1` is specified, replication slots may retain an unlimited amount of WAL files. The default is `-1` (upstream default). wal_keep_size minimum WAL size setting takes precedence over this.
        """
        return pulumi.get(self, "max_slot_wal_keep_size")

    @_builtins.property
    @pulumi.getter(name="maxStackDepth")
    def max_stack_depth(self) -> Optional[_builtins.int]:
        """
        Maximum depth of the stack in bytes. The default is `2097152` (upstream default).
        """
        return pulumi.get(self, "max_stack_depth")

    @_builtins.property
    @pulumi.getter(name="maxStandbyArchiveDelay")
    def max_standby_archive_delay(self) -> Optional[_builtins.int]:
        """
        Max standby archive delay in milliseconds. The default is `30000` (upstream default).
        """
        return pulumi.get(self, "max_standby_archive_delay")

    @_builtins.property
    @pulumi.getter(name="maxStandbyStreamingDelay")
    def max_standby_streaming_delay(self) -> Optional[_builtins.int]:
        """
        Max standby streaming delay in milliseconds. The default is `30000` (upstream default).
        """
        return pulumi.get(self, "max_standby_streaming_delay")

    @_builtins.property
    @pulumi.getter(name="maxSyncWorkersPerSubscription")
    def max_sync_workers_per_subscription(self) -> Optional[_builtins.int]:
        """
        Maximum number of synchronization workers per subscription. The default is `2`.
        """
        return pulumi.get(self, "max_sync_workers_per_subscription")

    @_builtins.property
    @pulumi.getter(name="maxWalSenders")
    def max_wal_senders(self) -> Optional[_builtins.int]:
        """
        PostgreSQL maximum WAL senders. The default is `20`. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_wal_senders")

    @_builtins.property
    @pulumi.getter(name="maxWorkerProcesses")
    def max_worker_processes(self) -> Optional[_builtins.int]:
        """
        Sets the maximum number of background processes that the system can support. The default is `8`. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_worker_processes")

    @_builtins.property
    @pulumi.getter
    def migration(self) -> Optional['outputs.ManagedDatabasePostgresqlPropertiesMigration']:
        """
        Migrate data from existing server.
        """
        return pulumi.get(self, "migration")

    @_builtins.property
    @pulumi.getter(name="passwordEncryption")
    def password_encryption(self) -> Optional[_builtins.str]:
        """
        Chooses the algorithm for encrypting passwords.
        """
        return pulumi.get(self, "password_encryption")

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwInterval")
    def pg_partman_bgw_interval(self) -> Optional[_builtins.int]:
        """
        Sets the time interval in seconds to run pg_partman's scheduled tasks. The default is `3600`.
        """
        return pulumi.get(self, "pg_partman_bgw_interval")

    @_builtins.property
    @pulumi.getter(name="pgPartmanBgwRole")
    def pg_partman_bgw_role(self) -> Optional[_builtins.str]:
        """
        Controls which role to use for pg_partman's scheduled background tasks.
        """
        return pulumi.get(self, "pg_partman_bgw_role")

    @_builtins.property
    @pulumi.getter(name="pgStatMonitorEnable")
    def pg_stat_monitor_enable(self) -> Optional[_builtins.bool]:
        """
        Enable pg_stat_monitor extension if available for the current cluster. Enable the pg_stat_monitor extension. Changing this parameter causes a service restart. When this extension is enabled, pg_stat_statements results for utility commands are unreliable.
        """
        return pulumi.get(self, "pg_stat_monitor_enable")

    @_builtins.property
    @pulumi.getter(name="pgStatMonitorPgsmEnableQueryPlan")
    def pg_stat_monitor_pgsm_enable_query_plan(self) -> Optional[_builtins.bool]:
        """
        Enables or disables query plan monitoring. Changing this parameter causes a service restart. Only available for PostgreSQL 13+.
        """
        return pulumi.get(self, "pg_stat_monitor_pgsm_enable_query_plan")

    @_builtins.property
    @pulumi.getter(name="pgStatMonitorPgsmMaxBuckets")
    def pg_stat_monitor_pgsm_max_buckets(self) -> Optional[_builtins.int]:
        """
        Sets the maximum number of buckets. Changing this parameter causes a service restart. Only available for PostgreSQL 13+.
        """
        return pulumi.get(self, "pg_stat_monitor_pgsm_max_buckets")

    @_builtins.property
    @pulumi.getter(name="pgStatStatementsTrack")
    def pg_stat_statements_track(self) -> Optional[_builtins.str]:
        """
        Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default is `top`.
        """
        return pulumi.get(self, "pg_stat_statements_track")

    @_builtins.property
    @pulumi.getter
    def pgaudit(self) -> Optional['outputs.ManagedDatabasePostgresqlPropertiesPgaudit']:
        """
        PGAudit settings. System-wide settings for the pgaudit extension.
        """
        return pulumi.get(self, "pgaudit")

    @_builtins.property
    @pulumi.getter
    def pgbouncer(self) -> Optional['outputs.ManagedDatabasePostgresqlPropertiesPgbouncer']:
        """
        PGBouncer connection pooling settings. System-wide settings for pgbouncer.
        """
        return pulumi.get(self, "pgbouncer")

    @_builtins.property
    @pulumi.getter
    def pglookout(self) -> Optional['outputs.ManagedDatabasePostgresqlPropertiesPglookout']:
        """
        PGLookout settings. System-wide settings for pglookout.
        """
        return pulumi.get(self, "pglookout")

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[_builtins.bool]:
        """
        Public Access. Allow access to the service from the public Internet.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter(name="serviceLog")
    def service_log(self) -> Optional[_builtins.bool]:
        """
        Service logging. Store logs for the service so that they are available in the HTTP API and console.
        """
        return pulumi.get(self, "service_log")

    @_builtins.property
    @pulumi.getter(name="sharedBuffersPercentage")
    def shared_buffers_percentage(self) -> Optional[_builtins.float]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "shared_buffers_percentage")

    @_builtins.property
    @pulumi.getter(name="synchronousReplication")
    def synchronous_replication(self) -> Optional[_builtins.str]:
        """
        Synchronous replication type. Note that the service plan also needs to support synchronous replication.
        """
        return pulumi.get(self, "synchronous_replication")

    @_builtins.property
    @pulumi.getter(name="tempFileLimit")
    def temp_file_limit(self) -> Optional[_builtins.int]:
        """
        PostgreSQL temporary file limit in KiB, -1 for unlimited.
        """
        return pulumi.get(self, "temp_file_limit")

    @_builtins.property
    @pulumi.getter
    def timescaledb(self) -> Optional['outputs.ManagedDatabasePostgresqlPropertiesTimescaledb']:
        """
        TimescaleDB extension configuration values. System-wide settings for the timescaledb extension.
        """
        return pulumi.get(self, "timescaledb")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        PostgreSQL service timezone.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="trackActivityQuerySize")
    def track_activity_query_size(self) -> Optional[_builtins.int]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "track_activity_query_size")

    @_builtins.property
    @pulumi.getter(name="trackCommitTimestamp")
    def track_commit_timestamp(self) -> Optional[_builtins.str]:
        """
        Record commit time of transactions. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "track_commit_timestamp")

    @_builtins.property
    @pulumi.getter(name="trackFunctions")
    def track_functions(self) -> Optional[_builtins.str]:
        """
        Enables tracking of function call counts and time used.
        """
        return pulumi.get(self, "track_functions")

    @_builtins.property
    @pulumi.getter(name="trackIoTiming")
    def track_io_timing(self) -> Optional[_builtins.str]:
        """
        Enables timing of database I/O calls. The default is `off`. When on, it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        """
        return pulumi.get(self, "track_io_timing")

    @_builtins.property
    @pulumi.getter
    def variant(self) -> Optional[_builtins.str]:
        """
        Variant of the PostgreSQL service, may affect the features that are exposed by default.
        """
        return pulumi.get(self, "variant")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        PostgreSQL major version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="walSenderTimeout")
    def wal_sender_timeout(self) -> Optional[_builtins.int]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        """
        return pulumi.get(self, "wal_sender_timeout")

    @_builtins.property
    @pulumi.getter(name="walWriterDelay")
    def wal_writer_delay(self) -> Optional[_builtins.int]:
        """
        WAL flush interval in milliseconds. The default is `200`. Setting this parameter to a lower value may negatively impact performance.
        """
        return pulumi.get(self, "wal_writer_delay")

    @_builtins.property
    @pulumi.getter(name="workMem")
    def work_mem(self) -> Optional[_builtins.int]:
        """
        Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. The default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "work_mem")


@pulumi.output_type
class ManagedDatabasePostgresqlPropertiesMigration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreDbs":
            suggest = "ignore_dbs"
        elif key == "ignoreRoles":
            suggest = "ignore_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePostgresqlPropertiesMigration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePostgresqlPropertiesMigration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePostgresqlPropertiesMigration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dbname: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 ignore_dbs: Optional[_builtins.str] = None,
                 ignore_roles: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 ssl: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str dbname: Database name for bootstrapping the initial connection.
        :param _builtins.str host: Hostname or IP address of the server where to migrate data from.
        :param _builtins.str ignore_dbs: Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        :param _builtins.str ignore_roles: Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        :param _builtins.str method: The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        :param _builtins.str password: Password for authentication with the server where to migrate data from.
        :param _builtins.int port: Port number of the server where to migrate data from.
        :param _builtins.bool ssl: The server where to migrate data from is secured with SSL.
        :param _builtins.str username: User name for authentication with the server where to migrate data from.
        """
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ignore_dbs is not None:
            pulumi.set(__self__, "ignore_dbs", ignore_dbs)
        if ignore_roles is not None:
            pulumi.set(__self__, "ignore_roles", ignore_roles)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[_builtins.str]:
        """
        Database name for bootstrapping the initial connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname or IP address of the server where to migrate data from.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_dbs")

    @_builtins.property
    @pulumi.getter(name="ignoreRoles")
    def ignore_roles(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_roles")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the server where to migrate data from.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[_builtins.bool]:
        """
        The server where to migrate data from is secured with SSL.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        User name for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ManagedDatabasePostgresqlPropertiesPgaudit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureEnabled":
            suggest = "feature_enabled"
        elif key == "logCatalog":
            suggest = "log_catalog"
        elif key == "logClient":
            suggest = "log_client"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "logMaxStringLength":
            suggest = "log_max_string_length"
        elif key == "logNestedStatements":
            suggest = "log_nested_statements"
        elif key == "logParameter":
            suggest = "log_parameter"
        elif key == "logParameterMaxSize":
            suggest = "log_parameter_max_size"
        elif key == "logRelation":
            suggest = "log_relation"
        elif key == "logRows":
            suggest = "log_rows"
        elif key == "logStatement":
            suggest = "log_statement"
        elif key == "logStatementOnce":
            suggest = "log_statement_once"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePostgresqlPropertiesPgaudit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePostgresqlPropertiesPgaudit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePostgresqlPropertiesPgaudit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_enabled: Optional[_builtins.bool] = None,
                 log_catalog: Optional[_builtins.bool] = None,
                 log_client: Optional[_builtins.bool] = None,
                 log_level: Optional[_builtins.str] = None,
                 log_max_string_length: Optional[_builtins.int] = None,
                 log_nested_statements: Optional[_builtins.bool] = None,
                 log_parameter: Optional[_builtins.bool] = None,
                 log_parameter_max_size: Optional[_builtins.int] = None,
                 log_relation: Optional[_builtins.bool] = None,
                 log_rows: Optional[_builtins.bool] = None,
                 log_statement: Optional[_builtins.bool] = None,
                 log_statement_once: Optional[_builtins.bool] = None,
                 logs: Optional[Sequence[_builtins.str]] = None,
                 role: Optional[_builtins.str] = None):
        """
        :param _builtins.bool feature_enabled: Enable pgaudit extension. Enable pgaudit extension. When enabled, pgaudit extension will be automatically installed.Otherwise, extension will be uninstalled but auditing configurations will be preserved.
        :param _builtins.bool log_catalog: Specifies that session logging should be enabled in the casewhere all relations in a statement are in pg_catalog.
        :param _builtins.bool log_client: Specifies whether log messages will be visible to a client process such as psql.
        :param _builtins.str log_level: Specifies the log level that will be used for log entries.
        :param _builtins.int log_max_string_length: Crop parameters representation and whole statements if they exceed this threshold. A (default) value of -1 disable the truncation.
        :param _builtins.bool log_nested_statements: This GUC allows to turn off logging nested statements, that is, statements that are executed as part of another ExecutorRun.
        :param _builtins.bool log_parameter: Specifies that audit logging should include the parameters that were passed with the statement.
        :param _builtins.int log_parameter_max_size: Specifies that parameter values longer than this setting (in bytes) should not be logged, but replaced with <long param suppressed>.
        :param _builtins.bool log_relation: Specifies whether session audit logging should create a separate log entry for each relation (TABLE, VIEW, etc.) referenced in a SELECT or DML statement.
        :param _builtins.bool log_rows: Specifies that audit logging should include the rows retrieved or affected by a statement. When enabled the rows field will be included after the parameter field.
        :param _builtins.bool log_statement: Specifies whether logging will include the statement text and parameters (if enabled).
        :param _builtins.bool log_statement_once: Specifies whether logging will include the statement text and parameters with the first log entry for a statement/substatement combination or with every entry.
        :param Sequence[_builtins.str] logs: Specifies which classes of statements will be logged by session audit logging.
        :param _builtins.str role: Specifies the master role to use for object audit logging.
        """
        if feature_enabled is not None:
            pulumi.set(__self__, "feature_enabled", feature_enabled)
        if log_catalog is not None:
            pulumi.set(__self__, "log_catalog", log_catalog)
        if log_client is not None:
            pulumi.set(__self__, "log_client", log_client)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if log_max_string_length is not None:
            pulumi.set(__self__, "log_max_string_length", log_max_string_length)
        if log_nested_statements is not None:
            pulumi.set(__self__, "log_nested_statements", log_nested_statements)
        if log_parameter is not None:
            pulumi.set(__self__, "log_parameter", log_parameter)
        if log_parameter_max_size is not None:
            pulumi.set(__self__, "log_parameter_max_size", log_parameter_max_size)
        if log_relation is not None:
            pulumi.set(__self__, "log_relation", log_relation)
        if log_rows is not None:
            pulumi.set(__self__, "log_rows", log_rows)
        if log_statement is not None:
            pulumi.set(__self__, "log_statement", log_statement)
        if log_statement_once is not None:
            pulumi.set(__self__, "log_statement_once", log_statement_once)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="featureEnabled")
    def feature_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable pgaudit extension. Enable pgaudit extension. When enabled, pgaudit extension will be automatically installed.Otherwise, extension will be uninstalled but auditing configurations will be preserved.
        """
        return pulumi.get(self, "feature_enabled")

    @_builtins.property
    @pulumi.getter(name="logCatalog")
    def log_catalog(self) -> Optional[_builtins.bool]:
        """
        Specifies that session logging should be enabled in the casewhere all relations in a statement are in pg_catalog.
        """
        return pulumi.get(self, "log_catalog")

    @_builtins.property
    @pulumi.getter(name="logClient")
    def log_client(self) -> Optional[_builtins.bool]:
        """
        Specifies whether log messages will be visible to a client process such as psql.
        """
        return pulumi.get(self, "log_client")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[_builtins.str]:
        """
        Specifies the log level that will be used for log entries.
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter(name="logMaxStringLength")
    def log_max_string_length(self) -> Optional[_builtins.int]:
        """
        Crop parameters representation and whole statements if they exceed this threshold. A (default) value of -1 disable the truncation.
        """
        return pulumi.get(self, "log_max_string_length")

    @_builtins.property
    @pulumi.getter(name="logNestedStatements")
    def log_nested_statements(self) -> Optional[_builtins.bool]:
        """
        This GUC allows to turn off logging nested statements, that is, statements that are executed as part of another ExecutorRun.
        """
        return pulumi.get(self, "log_nested_statements")

    @_builtins.property
    @pulumi.getter(name="logParameter")
    def log_parameter(self) -> Optional[_builtins.bool]:
        """
        Specifies that audit logging should include the parameters that were passed with the statement.
        """
        return pulumi.get(self, "log_parameter")

    @_builtins.property
    @pulumi.getter(name="logParameterMaxSize")
    def log_parameter_max_size(self) -> Optional[_builtins.int]:
        """
        Specifies that parameter values longer than this setting (in bytes) should not be logged, but replaced with <long param suppressed>.
        """
        return pulumi.get(self, "log_parameter_max_size")

    @_builtins.property
    @pulumi.getter(name="logRelation")
    def log_relation(self) -> Optional[_builtins.bool]:
        """
        Specifies whether session audit logging should create a separate log entry for each relation (TABLE, VIEW, etc.) referenced in a SELECT or DML statement.
        """
        return pulumi.get(self, "log_relation")

    @_builtins.property
    @pulumi.getter(name="logRows")
    def log_rows(self) -> Optional[_builtins.bool]:
        """
        Specifies that audit logging should include the rows retrieved or affected by a statement. When enabled the rows field will be included after the parameter field.
        """
        return pulumi.get(self, "log_rows")

    @_builtins.property
    @pulumi.getter(name="logStatement")
    def log_statement(self) -> Optional[_builtins.bool]:
        """
        Specifies whether logging will include the statement text and parameters (if enabled).
        """
        return pulumi.get(self, "log_statement")

    @_builtins.property
    @pulumi.getter(name="logStatementOnce")
    def log_statement_once(self) -> Optional[_builtins.bool]:
        """
        Specifies whether logging will include the statement text and parameters with the first log entry for a statement/substatement combination or with every entry.
        """
        return pulumi.get(self, "log_statement_once")

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies which classes of statements will be logged by session audit logging.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Specifies the master role to use for object audit logging.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ManagedDatabasePostgresqlPropertiesPgbouncer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autodbIdleTimeout":
            suggest = "autodb_idle_timeout"
        elif key == "autodbMaxDbConnections":
            suggest = "autodb_max_db_connections"
        elif key == "autodbPoolMode":
            suggest = "autodb_pool_mode"
        elif key == "autodbPoolSize":
            suggest = "autodb_pool_size"
        elif key == "ignoreStartupParameters":
            suggest = "ignore_startup_parameters"
        elif key == "maxPreparedStatements":
            suggest = "max_prepared_statements"
        elif key == "minPoolSize":
            suggest = "min_pool_size"
        elif key == "serverIdleTimeout":
            suggest = "server_idle_timeout"
        elif key == "serverLifetime":
            suggest = "server_lifetime"
        elif key == "serverResetQueryAlways":
            suggest = "server_reset_query_always"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePostgresqlPropertiesPgbouncer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePostgresqlPropertiesPgbouncer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePostgresqlPropertiesPgbouncer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autodb_idle_timeout: Optional[_builtins.int] = None,
                 autodb_max_db_connections: Optional[_builtins.int] = None,
                 autodb_pool_mode: Optional[_builtins.str] = None,
                 autodb_pool_size: Optional[_builtins.int] = None,
                 ignore_startup_parameters: Optional[Sequence[_builtins.str]] = None,
                 max_prepared_statements: Optional[_builtins.int] = None,
                 min_pool_size: Optional[_builtins.int] = None,
                 server_idle_timeout: Optional[_builtins.int] = None,
                 server_lifetime: Optional[_builtins.int] = None,
                 server_reset_query_always: Optional[_builtins.bool] = None):
        """
        :param _builtins.int autodb_idle_timeout: If the automatically created database pools have been unused this many seconds, they are freed. If 0 then timeout is disabled. [seconds].
        :param _builtins.int autodb_max_db_connections: Do not allow more than this many server connections per database (regardless of user). Setting it to 0 means unlimited.
        :param _builtins.str autodb_pool_mode: PGBouncer pool mode.
        :param _builtins.int autodb_pool_size: If non-zero then create automatically a pool of that size per user when a pool doesn't exist.
        :param Sequence[_builtins.str] ignore_startup_parameters: List of parameters to ignore when given in startup packet.
        :param _builtins.int max_prepared_statements: PgBouncer tracks protocol-level named prepared statements related commands sent by the client in transaction and statement pooling modes when max_prepared_statements is set to a non-zero value. Setting it to 0 disables prepared statements. max_prepared_statements defaults to 100, and its maximum is 3000.
        :param _builtins.int min_pool_size: Add more server connections to pool if below this number. Improves behavior when usual load comes suddenly back after period of total inactivity. The value is effectively capped at the pool size.
        :param _builtins.int server_idle_timeout: If a server connection has been idle more than this many seconds it will be dropped. If 0 then timeout is disabled. [seconds].
        :param _builtins.int server_lifetime: The pooler will close an unused server connection that has been connected longer than this. [seconds].
        :param _builtins.bool server_reset_query_always: Run server_reset_query (DISCARD ALL) in all pooling modes.
        """
        if autodb_idle_timeout is not None:
            pulumi.set(__self__, "autodb_idle_timeout", autodb_idle_timeout)
        if autodb_max_db_connections is not None:
            pulumi.set(__self__, "autodb_max_db_connections", autodb_max_db_connections)
        if autodb_pool_mode is not None:
            pulumi.set(__self__, "autodb_pool_mode", autodb_pool_mode)
        if autodb_pool_size is not None:
            pulumi.set(__self__, "autodb_pool_size", autodb_pool_size)
        if ignore_startup_parameters is not None:
            pulumi.set(__self__, "ignore_startup_parameters", ignore_startup_parameters)
        if max_prepared_statements is not None:
            pulumi.set(__self__, "max_prepared_statements", max_prepared_statements)
        if min_pool_size is not None:
            pulumi.set(__self__, "min_pool_size", min_pool_size)
        if server_idle_timeout is not None:
            pulumi.set(__self__, "server_idle_timeout", server_idle_timeout)
        if server_lifetime is not None:
            pulumi.set(__self__, "server_lifetime", server_lifetime)
        if server_reset_query_always is not None:
            pulumi.set(__self__, "server_reset_query_always", server_reset_query_always)

    @_builtins.property
    @pulumi.getter(name="autodbIdleTimeout")
    def autodb_idle_timeout(self) -> Optional[_builtins.int]:
        """
        If the automatically created database pools have been unused this many seconds, they are freed. If 0 then timeout is disabled. [seconds].
        """
        return pulumi.get(self, "autodb_idle_timeout")

    @_builtins.property
    @pulumi.getter(name="autodbMaxDbConnections")
    def autodb_max_db_connections(self) -> Optional[_builtins.int]:
        """
        Do not allow more than this many server connections per database (regardless of user). Setting it to 0 means unlimited.
        """
        return pulumi.get(self, "autodb_max_db_connections")

    @_builtins.property
    @pulumi.getter(name="autodbPoolMode")
    def autodb_pool_mode(self) -> Optional[_builtins.str]:
        """
        PGBouncer pool mode.
        """
        return pulumi.get(self, "autodb_pool_mode")

    @_builtins.property
    @pulumi.getter(name="autodbPoolSize")
    def autodb_pool_size(self) -> Optional[_builtins.int]:
        """
        If non-zero then create automatically a pool of that size per user when a pool doesn't exist.
        """
        return pulumi.get(self, "autodb_pool_size")

    @_builtins.property
    @pulumi.getter(name="ignoreStartupParameters")
    def ignore_startup_parameters(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of parameters to ignore when given in startup packet.
        """
        return pulumi.get(self, "ignore_startup_parameters")

    @_builtins.property
    @pulumi.getter(name="maxPreparedStatements")
    def max_prepared_statements(self) -> Optional[_builtins.int]:
        """
        PgBouncer tracks protocol-level named prepared statements related commands sent by the client in transaction and statement pooling modes when max_prepared_statements is set to a non-zero value. Setting it to 0 disables prepared statements. max_prepared_statements defaults to 100, and its maximum is 3000.
        """
        return pulumi.get(self, "max_prepared_statements")

    @_builtins.property
    @pulumi.getter(name="minPoolSize")
    def min_pool_size(self) -> Optional[_builtins.int]:
        """
        Add more server connections to pool if below this number. Improves behavior when usual load comes suddenly back after period of total inactivity. The value is effectively capped at the pool size.
        """
        return pulumi.get(self, "min_pool_size")

    @_builtins.property
    @pulumi.getter(name="serverIdleTimeout")
    def server_idle_timeout(self) -> Optional[_builtins.int]:
        """
        If a server connection has been idle more than this many seconds it will be dropped. If 0 then timeout is disabled. [seconds].
        """
        return pulumi.get(self, "server_idle_timeout")

    @_builtins.property
    @pulumi.getter(name="serverLifetime")
    def server_lifetime(self) -> Optional[_builtins.int]:
        """
        The pooler will close an unused server connection that has been connected longer than this. [seconds].
        """
        return pulumi.get(self, "server_lifetime")

    @_builtins.property
    @pulumi.getter(name="serverResetQueryAlways")
    def server_reset_query_always(self) -> Optional[_builtins.bool]:
        """
        Run server_reset_query (DISCARD ALL) in all pooling modes.
        """
        return pulumi.get(self, "server_reset_query_always")


@pulumi.output_type
class ManagedDatabasePostgresqlPropertiesPglookout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxFailoverReplicationTimeLag":
            suggest = "max_failover_replication_time_lag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePostgresqlPropertiesPglookout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePostgresqlPropertiesPglookout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePostgresqlPropertiesPglookout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_failover_replication_time_lag: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_failover_replication_time_lag: Number of seconds of master unavailability before triggering database failover to standby.
        """
        if max_failover_replication_time_lag is not None:
            pulumi.set(__self__, "max_failover_replication_time_lag", max_failover_replication_time_lag)

    @_builtins.property
    @pulumi.getter(name="maxFailoverReplicationTimeLag")
    def max_failover_replication_time_lag(self) -> Optional[_builtins.int]:
        """
        Number of seconds of master unavailability before triggering database failover to standby.
        """
        return pulumi.get(self, "max_failover_replication_time_lag")


@pulumi.output_type
class ManagedDatabasePostgresqlPropertiesTimescaledb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBackgroundWorkers":
            suggest = "max_background_workers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabasePostgresqlPropertiesTimescaledb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabasePostgresqlPropertiesTimescaledb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabasePostgresqlPropertiesTimescaledb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_background_workers: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_background_workers: The number of background workers for timescaledb operations. You should configure this setting to the sum of your number of databases and the total number of concurrent background workers you want running at any given point in time. Changing this parameter causes a service restart.
        """
        if max_background_workers is not None:
            pulumi.set(__self__, "max_background_workers", max_background_workers)

    @_builtins.property
    @pulumi.getter(name="maxBackgroundWorkers")
    def max_background_workers(self) -> Optional[_builtins.int]:
        """
        The number of background workers for timescaledb operations. You should configure this setting to the sum of your number of databases and the total number of concurrent background workers you want running at any given point in time. Changing this parameter causes a service restart.
        """
        return pulumi.get(self, "max_background_workers")


@pulumi.output_type
class ManagedDatabaseRedisComponent(dict):
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 route: Optional[_builtins.str] = None,
                 usage: Optional[_builtins.str] = None):
        """
        :param _builtins.str component: Type of the component
        :param _builtins.str host: Hostname of the component
        :param _builtins.int port: Port number of the component
        :param _builtins.str route: Component network route type
        :param _builtins.str usage: Usage of the component
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if route is not None:
            pulumi.set(__self__, "route", route)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Type of the component
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname of the component
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the component
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def route(self) -> Optional[_builtins.str]:
        """
        Component network route type
        """
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.str]:
        """
        Usage of the component
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class ManagedDatabaseRedisNetwork(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str family: Network family. Currently only `IPv4` is supported.
        :param _builtins.str name: The name of the network. Must be unique within the service.
        :param _builtins.str type: The type of the network. Must be private.
        :param _builtins.str uuid: Private network UUID. Must reside in the same zone as the database.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. Currently only `IPv4` is supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the network. Must be private.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Private network UUID. Must reside in the same zone as the database.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ManagedDatabaseRedisNodeState(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name plus a node iteration
        :param _builtins.str role: Role of the node
        :param _builtins.str state: State of the node
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name plus a node iteration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Role of the node
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the node
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedDatabaseRedisProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticUtilityNetworkIpFilter":
            suggest = "automatic_utility_network_ip_filter"
        elif key == "backupHour":
            suggest = "backup_hour"
        elif key == "backupMinute":
            suggest = "backup_minute"
        elif key == "ipFilters":
            suggest = "ip_filters"
        elif key == "publicAccess":
            suggest = "public_access"
        elif key == "redisAclChannelsDefault":
            suggest = "redis_acl_channels_default"
        elif key == "redisIoThreads":
            suggest = "redis_io_threads"
        elif key == "redisLfuDecayTime":
            suggest = "redis_lfu_decay_time"
        elif key == "redisLfuLogFactor":
            suggest = "redis_lfu_log_factor"
        elif key == "redisMaxmemoryPolicy":
            suggest = "redis_maxmemory_policy"
        elif key == "redisNotifyKeyspaceEvents":
            suggest = "redis_notify_keyspace_events"
        elif key == "redisNumberOfDatabases":
            suggest = "redis_number_of_databases"
        elif key == "redisPersistence":
            suggest = "redis_persistence"
        elif key == "redisPubsubClientOutputBufferLimit":
            suggest = "redis_pubsub_client_output_buffer_limit"
        elif key == "redisSsl":
            suggest = "redis_ssl"
        elif key == "redisTimeout":
            suggest = "redis_timeout"
        elif key == "redisVersion":
            suggest = "redis_version"
        elif key == "serviceLog":
            suggest = "service_log"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseRedisProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseRedisProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseRedisProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_utility_network_ip_filter: Optional[_builtins.bool] = None,
                 backup_hour: Optional[_builtins.int] = None,
                 backup_minute: Optional[_builtins.int] = None,
                 ip_filters: Optional[Sequence[_builtins.str]] = None,
                 migration: Optional['outputs.ManagedDatabaseRedisPropertiesMigration'] = None,
                 public_access: Optional[_builtins.bool] = None,
                 redis_acl_channels_default: Optional[_builtins.str] = None,
                 redis_io_threads: Optional[_builtins.int] = None,
                 redis_lfu_decay_time: Optional[_builtins.int] = None,
                 redis_lfu_log_factor: Optional[_builtins.int] = None,
                 redis_maxmemory_policy: Optional[_builtins.str] = None,
                 redis_notify_keyspace_events: Optional[_builtins.str] = None,
                 redis_number_of_databases: Optional[_builtins.int] = None,
                 redis_persistence: Optional[_builtins.str] = None,
                 redis_pubsub_client_output_buffer_limit: Optional[_builtins.int] = None,
                 redis_ssl: Optional[_builtins.bool] = None,
                 redis_timeout: Optional[_builtins.int] = None,
                 redis_version: Optional[_builtins.str] = None,
                 service_log: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool automatic_utility_network_ip_filter: Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        :param _builtins.int backup_hour: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.int backup_minute: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        :param Sequence[_builtins.str] ip_filters: IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        :param 'ManagedDatabaseRedisPropertiesMigrationArgs' migration: Migrate data from existing server.
        :param _builtins.bool public_access: Public Access. Allow access to the service from the public Internet.
        :param _builtins.str redis_acl_channels_default: Default ACL for pub/sub channels used when Redis user is created. Determines default pub/sub channels' ACL for new users if ACL is not supplied. When this option is not defined, all_channels is assumed to keep backward compatibility. This option doesn't affect Redis configuration acl-pubsub-default.
        :param _builtins.int redis_io_threads: Redis IO thread count. Set Redis IO thread count. Changing this will cause a restart of the Redis service.
        :param _builtins.int redis_lfu_decay_time: LFU maxmemory-policy counter decay time in minutes.
        :param _builtins.int redis_lfu_log_factor: Counter logarithm factor for volatile-lfu and allkeys-lfu maxmemory-policies.
        :param _builtins.str redis_maxmemory_policy: Redis maxmemory-policy.
        :param _builtins.str redis_notify_keyspace_events: Set notify-keyspace-events option.
        :param _builtins.int redis_number_of_databases: Number of Redis databases. Set number of Redis databases. Changing this will cause a restart of the Redis service.
        :param _builtins.str redis_persistence: Redis persistence. When persistence is 'rdb', Redis does RDB dumps each 10 minutes if any key is changed. Also RDB dumps are done according to the backup schedule for backup purposes. When persistence is 'off', no RDB dumps or backups are done, so data can be lost at any moment if the service is restarted for any reason, or if the service is powered off. Also, the service can't be forked.
        :param _builtins.int redis_pubsub_client_output_buffer_limit: Pub/sub client output buffer hard limit in MB. Set output buffer limit for pub / sub clients in MB. The value is the hard limit, the soft limit is 1/4 of the hard limit. When setting the limit, be mindful of the available memory in the selected service plan.
        :param _builtins.bool redis_ssl: Require SSL to access Redis.
        :param _builtins.int redis_timeout: Redis idle connection timeout in seconds.
        :param _builtins.str redis_version: Redis major version.
        :param _builtins.bool service_log: Service logging. Store logs for the service so that they are available in the HTTP API and console.
        """
        if automatic_utility_network_ip_filter is not None:
            pulumi.set(__self__, "automatic_utility_network_ip_filter", automatic_utility_network_ip_filter)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if ip_filters is not None:
            pulumi.set(__self__, "ip_filters", ip_filters)
        if migration is not None:
            pulumi.set(__self__, "migration", migration)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if redis_acl_channels_default is not None:
            pulumi.set(__self__, "redis_acl_channels_default", redis_acl_channels_default)
        if redis_io_threads is not None:
            pulumi.set(__self__, "redis_io_threads", redis_io_threads)
        if redis_lfu_decay_time is not None:
            pulumi.set(__self__, "redis_lfu_decay_time", redis_lfu_decay_time)
        if redis_lfu_log_factor is not None:
            pulumi.set(__self__, "redis_lfu_log_factor", redis_lfu_log_factor)
        if redis_maxmemory_policy is not None:
            pulumi.set(__self__, "redis_maxmemory_policy", redis_maxmemory_policy)
        if redis_notify_keyspace_events is not None:
            pulumi.set(__self__, "redis_notify_keyspace_events", redis_notify_keyspace_events)
        if redis_number_of_databases is not None:
            pulumi.set(__self__, "redis_number_of_databases", redis_number_of_databases)
        if redis_persistence is not None:
            pulumi.set(__self__, "redis_persistence", redis_persistence)
        if redis_pubsub_client_output_buffer_limit is not None:
            pulumi.set(__self__, "redis_pubsub_client_output_buffer_limit", redis_pubsub_client_output_buffer_limit)
        if redis_ssl is not None:
            pulumi.set(__self__, "redis_ssl", redis_ssl)
        if redis_timeout is not None:
            pulumi.set(__self__, "redis_timeout", redis_timeout)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if service_log is not None:
            pulumi.set(__self__, "service_log", service_log)

    @_builtins.property
    @pulumi.getter(name="automaticUtilityNetworkIpFilter")
    def automatic_utility_network_ip_filter(self) -> Optional[_builtins.bool]:
        """
        Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        """
        return pulumi.get(self, "automatic_utility_network_ip_filter")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[_builtins.int]:
        """
        The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[_builtins.int]:
        """
        The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="ipFilters")
    def ip_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        """
        return pulumi.get(self, "ip_filters")

    @_builtins.property
    @pulumi.getter
    def migration(self) -> Optional['outputs.ManagedDatabaseRedisPropertiesMigration']:
        """
        Migrate data from existing server.
        """
        return pulumi.get(self, "migration")

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[_builtins.bool]:
        """
        Public Access. Allow access to the service from the public Internet.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter(name="redisAclChannelsDefault")
    def redis_acl_channels_default(self) -> Optional[_builtins.str]:
        """
        Default ACL for pub/sub channels used when Redis user is created. Determines default pub/sub channels' ACL for new users if ACL is not supplied. When this option is not defined, all_channels is assumed to keep backward compatibility. This option doesn't affect Redis configuration acl-pubsub-default.
        """
        return pulumi.get(self, "redis_acl_channels_default")

    @_builtins.property
    @pulumi.getter(name="redisIoThreads")
    def redis_io_threads(self) -> Optional[_builtins.int]:
        """
        Redis IO thread count. Set Redis IO thread count. Changing this will cause a restart of the Redis service.
        """
        return pulumi.get(self, "redis_io_threads")

    @_builtins.property
    @pulumi.getter(name="redisLfuDecayTime")
    def redis_lfu_decay_time(self) -> Optional[_builtins.int]:
        """
        LFU maxmemory-policy counter decay time in minutes.
        """
        return pulumi.get(self, "redis_lfu_decay_time")

    @_builtins.property
    @pulumi.getter(name="redisLfuLogFactor")
    def redis_lfu_log_factor(self) -> Optional[_builtins.int]:
        """
        Counter logarithm factor for volatile-lfu and allkeys-lfu maxmemory-policies.
        """
        return pulumi.get(self, "redis_lfu_log_factor")

    @_builtins.property
    @pulumi.getter(name="redisMaxmemoryPolicy")
    def redis_maxmemory_policy(self) -> Optional[_builtins.str]:
        """
        Redis maxmemory-policy.
        """
        return pulumi.get(self, "redis_maxmemory_policy")

    @_builtins.property
    @pulumi.getter(name="redisNotifyKeyspaceEvents")
    def redis_notify_keyspace_events(self) -> Optional[_builtins.str]:
        """
        Set notify-keyspace-events option.
        """
        return pulumi.get(self, "redis_notify_keyspace_events")

    @_builtins.property
    @pulumi.getter(name="redisNumberOfDatabases")
    def redis_number_of_databases(self) -> Optional[_builtins.int]:
        """
        Number of Redis databases. Set number of Redis databases. Changing this will cause a restart of the Redis service.
        """
        return pulumi.get(self, "redis_number_of_databases")

    @_builtins.property
    @pulumi.getter(name="redisPersistence")
    def redis_persistence(self) -> Optional[_builtins.str]:
        """
        Redis persistence. When persistence is 'rdb', Redis does RDB dumps each 10 minutes if any key is changed. Also RDB dumps are done according to the backup schedule for backup purposes. When persistence is 'off', no RDB dumps or backups are done, so data can be lost at any moment if the service is restarted for any reason, or if the service is powered off. Also, the service can't be forked.
        """
        return pulumi.get(self, "redis_persistence")

    @_builtins.property
    @pulumi.getter(name="redisPubsubClientOutputBufferLimit")
    def redis_pubsub_client_output_buffer_limit(self) -> Optional[_builtins.int]:
        """
        Pub/sub client output buffer hard limit in MB. Set output buffer limit for pub / sub clients in MB. The value is the hard limit, the soft limit is 1/4 of the hard limit. When setting the limit, be mindful of the available memory in the selected service plan.
        """
        return pulumi.get(self, "redis_pubsub_client_output_buffer_limit")

    @_builtins.property
    @pulumi.getter(name="redisSsl")
    def redis_ssl(self) -> Optional[_builtins.bool]:
        """
        Require SSL to access Redis.
        """
        return pulumi.get(self, "redis_ssl")

    @_builtins.property
    @pulumi.getter(name="redisTimeout")
    def redis_timeout(self) -> Optional[_builtins.int]:
        """
        Redis idle connection timeout in seconds.
        """
        return pulumi.get(self, "redis_timeout")

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[_builtins.str]:
        """
        Redis major version.
        """
        return pulumi.get(self, "redis_version")

    @_builtins.property
    @pulumi.getter(name="serviceLog")
    def service_log(self) -> Optional[_builtins.bool]:
        """
        Service logging. Store logs for the service so that they are available in the HTTP API and console.
        """
        return pulumi.get(self, "service_log")


@pulumi.output_type
class ManagedDatabaseRedisPropertiesMigration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreDbs":
            suggest = "ignore_dbs"
        elif key == "ignoreRoles":
            suggest = "ignore_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseRedisPropertiesMigration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseRedisPropertiesMigration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseRedisPropertiesMigration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dbname: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 ignore_dbs: Optional[_builtins.str] = None,
                 ignore_roles: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 ssl: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str dbname: Database name for bootstrapping the initial connection.
        :param _builtins.str host: Hostname or IP address of the server where to migrate data from.
        :param _builtins.str ignore_dbs: Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        :param _builtins.str ignore_roles: Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        :param _builtins.str method: The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        :param _builtins.str password: Password for authentication with the server where to migrate data from.
        :param _builtins.int port: Port number of the server where to migrate data from.
        :param _builtins.bool ssl: The server where to migrate data from is secured with SSL.
        :param _builtins.str username: User name for authentication with the server where to migrate data from.
        """
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ignore_dbs is not None:
            pulumi.set(__self__, "ignore_dbs", ignore_dbs)
        if ignore_roles is not None:
            pulumi.set(__self__, "ignore_roles", ignore_roles)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[_builtins.str]:
        """
        Database name for bootstrapping the initial connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname or IP address of the server where to migrate data from.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_dbs")

    @_builtins.property
    @pulumi.getter(name="ignoreRoles")
    def ignore_roles(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_roles")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the server where to migrate data from.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[_builtins.bool]:
        """
        The server where to migrate data from is secured with SSL.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        User name for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ManagedDatabaseUserOpensearchAccessControl(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.ManagedDatabaseUserOpensearchAccessControlRule']):
        """
        :param Sequence['ManagedDatabaseUserOpensearchAccessControlRuleArgs'] rules: Set user access control rules.
        """
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ManagedDatabaseUserOpensearchAccessControlRule']:
        """
        Set user access control rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ManagedDatabaseUserOpensearchAccessControlRule(dict):
    def __init__(__self__, *,
                 index: _builtins.str,
                 permission: _builtins.str):
        """
        :param _builtins.str index: Set index name, pattern or top level API.
        :param _builtins.str permission: Set permission access.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "permission", permission)

    @_builtins.property
    @pulumi.getter
    def index(self) -> _builtins.str:
        """
        Set index name, pattern or top level API.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Set permission access.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ManagedDatabaseUserPgAccessControl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowReplication":
            suggest = "allow_replication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseUserPgAccessControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseUserPgAccessControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseUserPgAccessControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_replication: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool allow_replication: Grant replication privilege
        """
        if allow_replication is not None:
            pulumi.set(__self__, "allow_replication", allow_replication)

    @_builtins.property
    @pulumi.getter(name="allowReplication")
    def allow_replication(self) -> Optional[_builtins.bool]:
        """
        Grant replication privilege
        """
        return pulumi.get(self, "allow_replication")


@pulumi.output_type
class ManagedDatabaseUserRedisAccessControl(dict):
    def __init__(__self__, *,
                 categories: Optional[_builtins.str] = None,
                 channels: Optional[_builtins.str] = None,
                 commands: Optional[_builtins.str] = None,
                 keys: Optional[_builtins.str] = None):
        """
        :param _builtins.str categories: Set access control to all commands in specified categories.
        :param _builtins.str channels: Set access control to Pub/Sub channels.
        :param _builtins.str commands: Set access control to commands.
        :param _builtins.str keys: Set access control to keys.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[_builtins.str]:
        """
        Set access control to all commands in specified categories.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def channels(self) -> Optional[_builtins.str]:
        """
        Set access control to Pub/Sub channels.
        """
        return pulumi.get(self, "channels")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[_builtins.str]:
        """
        Set access control to commands.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[_builtins.str]:
        """
        Set access control to keys.
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class ManagedDatabaseUserValkeyAccessControl(dict):
    def __init__(__self__, *,
                 categories: Optional[_builtins.str] = None,
                 channels: Optional[_builtins.str] = None,
                 commands: Optional[_builtins.str] = None,
                 keys: Optional[_builtins.str] = None):
        """
        :param _builtins.str categories: Set access control to all commands in specified categories.
        :param _builtins.str channels: Set access control to Pub/Sub channels.
        :param _builtins.str commands: Set access control to commands.
        :param _builtins.str keys: Set access control to keys.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[_builtins.str]:
        """
        Set access control to all commands in specified categories.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def channels(self) -> Optional[_builtins.str]:
        """
        Set access control to Pub/Sub channels.
        """
        return pulumi.get(self, "channels")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[_builtins.str]:
        """
        Set access control to commands.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[_builtins.str]:
        """
        Set access control to keys.
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class ManagedDatabaseValkeyComponent(dict):
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 route: Optional[_builtins.str] = None,
                 usage: Optional[_builtins.str] = None):
        """
        :param _builtins.str component: Type of the component
        :param _builtins.str host: Hostname of the component
        :param _builtins.int port: Port number of the component
        :param _builtins.str route: Component network route type
        :param _builtins.str usage: Usage of the component
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if route is not None:
            pulumi.set(__self__, "route", route)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Type of the component
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname of the component
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the component
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def route(self) -> Optional[_builtins.str]:
        """
        Component network route type
        """
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.str]:
        """
        Usage of the component
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class ManagedDatabaseValkeyNetwork(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str family: Network family. Currently only `IPv4` is supported.
        :param _builtins.str name: The name of the network. Must be unique within the service.
        :param _builtins.str type: The type of the network. Must be private.
        :param _builtins.str uuid: Private network UUID. Must reside in the same zone as the database.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. Currently only `IPv4` is supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the network. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the network. Must be private.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        Private network UUID. Must reside in the same zone as the database.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ManagedDatabaseValkeyNodeState(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name plus a node iteration
        :param _builtins.str role: Role of the node
        :param _builtins.str state: State of the node
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name plus a node iteration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Role of the node
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of the node
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedDatabaseValkeyProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticUtilityNetworkIpFilter":
            suggest = "automatic_utility_network_ip_filter"
        elif key == "backupHour":
            suggest = "backup_hour"
        elif key == "backupMinute":
            suggest = "backup_minute"
        elif key == "frequentSnapshots":
            suggest = "frequent_snapshots"
        elif key == "ipFilters":
            suggest = "ip_filters"
        elif key == "publicAccess":
            suggest = "public_access"
        elif key == "serviceLog":
            suggest = "service_log"
        elif key == "valkeyAclChannelsDefault":
            suggest = "valkey_acl_channels_default"
        elif key == "valkeyActiveExpireEffort":
            suggest = "valkey_active_expire_effort"
        elif key == "valkeyIoThreads":
            suggest = "valkey_io_threads"
        elif key == "valkeyLfuDecayTime":
            suggest = "valkey_lfu_decay_time"
        elif key == "valkeyLfuLogFactor":
            suggest = "valkey_lfu_log_factor"
        elif key == "valkeyMaxmemoryPolicy":
            suggest = "valkey_maxmemory_policy"
        elif key == "valkeyNotifyKeyspaceEvents":
            suggest = "valkey_notify_keyspace_events"
        elif key == "valkeyNumberOfDatabases":
            suggest = "valkey_number_of_databases"
        elif key == "valkeyPersistence":
            suggest = "valkey_persistence"
        elif key == "valkeyPubsubClientOutputBufferLimit":
            suggest = "valkey_pubsub_client_output_buffer_limit"
        elif key == "valkeySsl":
            suggest = "valkey_ssl"
        elif key == "valkeyTimeout":
            suggest = "valkey_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseValkeyProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseValkeyProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseValkeyProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_utility_network_ip_filter: Optional[_builtins.bool] = None,
                 backup_hour: Optional[_builtins.int] = None,
                 backup_minute: Optional[_builtins.int] = None,
                 frequent_snapshots: Optional[_builtins.bool] = None,
                 ip_filters: Optional[Sequence[_builtins.str]] = None,
                 migration: Optional['outputs.ManagedDatabaseValkeyPropertiesMigration'] = None,
                 public_access: Optional[_builtins.bool] = None,
                 service_log: Optional[_builtins.bool] = None,
                 valkey_acl_channels_default: Optional[_builtins.str] = None,
                 valkey_active_expire_effort: Optional[_builtins.int] = None,
                 valkey_io_threads: Optional[_builtins.int] = None,
                 valkey_lfu_decay_time: Optional[_builtins.int] = None,
                 valkey_lfu_log_factor: Optional[_builtins.int] = None,
                 valkey_maxmemory_policy: Optional[_builtins.str] = None,
                 valkey_notify_keyspace_events: Optional[_builtins.str] = None,
                 valkey_number_of_databases: Optional[_builtins.int] = None,
                 valkey_persistence: Optional[_builtins.str] = None,
                 valkey_pubsub_client_output_buffer_limit: Optional[_builtins.int] = None,
                 valkey_ssl: Optional[_builtins.bool] = None,
                 valkey_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.bool automatic_utility_network_ip_filter: Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        :param _builtins.int backup_hour: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.int backup_minute: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        :param _builtins.bool frequent_snapshots: Frequent RDB snapshots. When enabled, Valkey will create frequent local RDB snapshots. When disabled, Valkey will only take RDB snapshots when a backup is created, based on the backup schedule. This setting is ignored when `valkey_persistence` is set to `off`.
        :param Sequence[_builtins.str] ip_filters: IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        :param 'ManagedDatabaseValkeyPropertiesMigrationArgs' migration: Migrate data from existing server.
        :param _builtins.bool public_access: Public Access. Allow access to the service from the public Internet.
        :param _builtins.bool service_log: Service logging. Store logs for the service so that they are available in the HTTP API and console.
        :param _builtins.str valkey_acl_channels_default: Default ACL for pub/sub channels used when a Valkey user is created. Determines default pub/sub channels' ACL for new users if ACL is not supplied. When this option is not defined, all_channels is assumed to keep backward compatibility. This option doesn't affect Valkey configuration acl-pubsub-default.
        :param _builtins.int valkey_active_expire_effort: Active expire effort. Valkey reclaims expired keys both when accessed and in the background. The background process scans for expired keys to free memory. Increasing the active-expire-effort setting (default 1, max 10) uses more CPU to reclaim expired keys faster, reducing memory usage but potentially increasing latency.
        :param _builtins.int valkey_io_threads: Valkey IO thread count. Set Valkey IO thread count. Changing this will cause a restart of the Valkey service.
        :param _builtins.int valkey_lfu_decay_time: LFU maxmemory-policy counter decay time in minutes.
        :param _builtins.int valkey_lfu_log_factor: Counter logarithm factor for volatile-lfu and allkeys-lfu maxmemory-policies.
        :param _builtins.str valkey_maxmemory_policy: Valkey maxmemory-policy.
        :param _builtins.str valkey_notify_keyspace_events: Set notify-keyspace-events option.
        :param _builtins.int valkey_number_of_databases: Number of Valkey databases. Set number of Valkey databases. Changing this will cause a restart of the Valkey service.
        :param _builtins.str valkey_persistence: Valkey persistence. When persistence is 'rdb', Valkey does RDB dumps each 10 minutes if any key is changed. Also RDB dumps are done according to backup schedule for backup purposes. When persistence is 'off', no RDB dumps and backups are done, so data can be lost at any moment if service is restarted for any reason, or if service is powered off. Also service can't be forked.
        :param _builtins.int valkey_pubsub_client_output_buffer_limit: Pub/sub client output buffer hard limit in MB. Set output buffer limit for pub / sub clients in MB. The value is the hard limit, the soft limit is 1/4 of the hard limit. When setting the limit, be mindful of the available memory in the selected service plan.
        :param _builtins.bool valkey_ssl: Require SSL to access Valkey.
        :param _builtins.int valkey_timeout: Valkey idle connection timeout in seconds.
        """
        if automatic_utility_network_ip_filter is not None:
            pulumi.set(__self__, "automatic_utility_network_ip_filter", automatic_utility_network_ip_filter)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_minute is not None:
            pulumi.set(__self__, "backup_minute", backup_minute)
        if frequent_snapshots is not None:
            pulumi.set(__self__, "frequent_snapshots", frequent_snapshots)
        if ip_filters is not None:
            pulumi.set(__self__, "ip_filters", ip_filters)
        if migration is not None:
            pulumi.set(__self__, "migration", migration)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if service_log is not None:
            pulumi.set(__self__, "service_log", service_log)
        if valkey_acl_channels_default is not None:
            pulumi.set(__self__, "valkey_acl_channels_default", valkey_acl_channels_default)
        if valkey_active_expire_effort is not None:
            pulumi.set(__self__, "valkey_active_expire_effort", valkey_active_expire_effort)
        if valkey_io_threads is not None:
            pulumi.set(__self__, "valkey_io_threads", valkey_io_threads)
        if valkey_lfu_decay_time is not None:
            pulumi.set(__self__, "valkey_lfu_decay_time", valkey_lfu_decay_time)
        if valkey_lfu_log_factor is not None:
            pulumi.set(__self__, "valkey_lfu_log_factor", valkey_lfu_log_factor)
        if valkey_maxmemory_policy is not None:
            pulumi.set(__self__, "valkey_maxmemory_policy", valkey_maxmemory_policy)
        if valkey_notify_keyspace_events is not None:
            pulumi.set(__self__, "valkey_notify_keyspace_events", valkey_notify_keyspace_events)
        if valkey_number_of_databases is not None:
            pulumi.set(__self__, "valkey_number_of_databases", valkey_number_of_databases)
        if valkey_persistence is not None:
            pulumi.set(__self__, "valkey_persistence", valkey_persistence)
        if valkey_pubsub_client_output_buffer_limit is not None:
            pulumi.set(__self__, "valkey_pubsub_client_output_buffer_limit", valkey_pubsub_client_output_buffer_limit)
        if valkey_ssl is not None:
            pulumi.set(__self__, "valkey_ssl", valkey_ssl)
        if valkey_timeout is not None:
            pulumi.set(__self__, "valkey_timeout", valkey_timeout)

    @_builtins.property
    @pulumi.getter(name="automaticUtilityNetworkIpFilter")
    def automatic_utility_network_ip_filter(self) -> Optional[_builtins.bool]:
        """
        Automatic utility network IP Filter. Automatically allow connections from servers in the utility network within the same zone.
        """
        return pulumi.get(self, "automatic_utility_network_ip_filter")

    @_builtins.property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[_builtins.int]:
        """
        The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_hour")

    @_builtins.property
    @pulumi.getter(name="backupMinute")
    def backup_minute(self) -> Optional[_builtins.int]:
        """
        The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
        """
        return pulumi.get(self, "backup_minute")

    @_builtins.property
    @pulumi.getter(name="frequentSnapshots")
    def frequent_snapshots(self) -> Optional[_builtins.bool]:
        """
        Frequent RDB snapshots. When enabled, Valkey will create frequent local RDB snapshots. When disabled, Valkey will only take RDB snapshots when a backup is created, based on the backup schedule. This setting is ignored when `valkey_persistence` is set to `off`.
        """
        return pulumi.get(self, "frequent_snapshots")

    @_builtins.property
    @pulumi.getter(name="ipFilters")
    def ip_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP filter. Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'.
        """
        return pulumi.get(self, "ip_filters")

    @_builtins.property
    @pulumi.getter
    def migration(self) -> Optional['outputs.ManagedDatabaseValkeyPropertiesMigration']:
        """
        Migrate data from existing server.
        """
        return pulumi.get(self, "migration")

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[_builtins.bool]:
        """
        Public Access. Allow access to the service from the public Internet.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter(name="serviceLog")
    def service_log(self) -> Optional[_builtins.bool]:
        """
        Service logging. Store logs for the service so that they are available in the HTTP API and console.
        """
        return pulumi.get(self, "service_log")

    @_builtins.property
    @pulumi.getter(name="valkeyAclChannelsDefault")
    def valkey_acl_channels_default(self) -> Optional[_builtins.str]:
        """
        Default ACL for pub/sub channels used when a Valkey user is created. Determines default pub/sub channels' ACL for new users if ACL is not supplied. When this option is not defined, all_channels is assumed to keep backward compatibility. This option doesn't affect Valkey configuration acl-pubsub-default.
        """
        return pulumi.get(self, "valkey_acl_channels_default")

    @_builtins.property
    @pulumi.getter(name="valkeyActiveExpireEffort")
    def valkey_active_expire_effort(self) -> Optional[_builtins.int]:
        """
        Active expire effort. Valkey reclaims expired keys both when accessed and in the background. The background process scans for expired keys to free memory. Increasing the active-expire-effort setting (default 1, max 10) uses more CPU to reclaim expired keys faster, reducing memory usage but potentially increasing latency.
        """
        return pulumi.get(self, "valkey_active_expire_effort")

    @_builtins.property
    @pulumi.getter(name="valkeyIoThreads")
    def valkey_io_threads(self) -> Optional[_builtins.int]:
        """
        Valkey IO thread count. Set Valkey IO thread count. Changing this will cause a restart of the Valkey service.
        """
        return pulumi.get(self, "valkey_io_threads")

    @_builtins.property
    @pulumi.getter(name="valkeyLfuDecayTime")
    def valkey_lfu_decay_time(self) -> Optional[_builtins.int]:
        """
        LFU maxmemory-policy counter decay time in minutes.
        """
        return pulumi.get(self, "valkey_lfu_decay_time")

    @_builtins.property
    @pulumi.getter(name="valkeyLfuLogFactor")
    def valkey_lfu_log_factor(self) -> Optional[_builtins.int]:
        """
        Counter logarithm factor for volatile-lfu and allkeys-lfu maxmemory-policies.
        """
        return pulumi.get(self, "valkey_lfu_log_factor")

    @_builtins.property
    @pulumi.getter(name="valkeyMaxmemoryPolicy")
    def valkey_maxmemory_policy(self) -> Optional[_builtins.str]:
        """
        Valkey maxmemory-policy.
        """
        return pulumi.get(self, "valkey_maxmemory_policy")

    @_builtins.property
    @pulumi.getter(name="valkeyNotifyKeyspaceEvents")
    def valkey_notify_keyspace_events(self) -> Optional[_builtins.str]:
        """
        Set notify-keyspace-events option.
        """
        return pulumi.get(self, "valkey_notify_keyspace_events")

    @_builtins.property
    @pulumi.getter(name="valkeyNumberOfDatabases")
    def valkey_number_of_databases(self) -> Optional[_builtins.int]:
        """
        Number of Valkey databases. Set number of Valkey databases. Changing this will cause a restart of the Valkey service.
        """
        return pulumi.get(self, "valkey_number_of_databases")

    @_builtins.property
    @pulumi.getter(name="valkeyPersistence")
    def valkey_persistence(self) -> Optional[_builtins.str]:
        """
        Valkey persistence. When persistence is 'rdb', Valkey does RDB dumps each 10 minutes if any key is changed. Also RDB dumps are done according to backup schedule for backup purposes. When persistence is 'off', no RDB dumps and backups are done, so data can be lost at any moment if service is restarted for any reason, or if service is powered off. Also service can't be forked.
        """
        return pulumi.get(self, "valkey_persistence")

    @_builtins.property
    @pulumi.getter(name="valkeyPubsubClientOutputBufferLimit")
    def valkey_pubsub_client_output_buffer_limit(self) -> Optional[_builtins.int]:
        """
        Pub/sub client output buffer hard limit in MB. Set output buffer limit for pub / sub clients in MB. The value is the hard limit, the soft limit is 1/4 of the hard limit. When setting the limit, be mindful of the available memory in the selected service plan.
        """
        return pulumi.get(self, "valkey_pubsub_client_output_buffer_limit")

    @_builtins.property
    @pulumi.getter(name="valkeySsl")
    def valkey_ssl(self) -> Optional[_builtins.bool]:
        """
        Require SSL to access Valkey.
        """
        return pulumi.get(self, "valkey_ssl")

    @_builtins.property
    @pulumi.getter(name="valkeyTimeout")
    def valkey_timeout(self) -> Optional[_builtins.int]:
        """
        Valkey idle connection timeout in seconds.
        """
        return pulumi.get(self, "valkey_timeout")


@pulumi.output_type
class ManagedDatabaseValkeyPropertiesMigration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreDbs":
            suggest = "ignore_dbs"
        elif key == "ignoreRoles":
            suggest = "ignore_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDatabaseValkeyPropertiesMigration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDatabaseValkeyPropertiesMigration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDatabaseValkeyPropertiesMigration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dbname: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None,
                 ignore_dbs: Optional[_builtins.str] = None,
                 ignore_roles: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 ssl: Optional[_builtins.bool] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str dbname: Database name for bootstrapping the initial connection.
        :param _builtins.str host: Hostname or IP address of the server where to migrate data from.
        :param _builtins.str ignore_dbs: Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        :param _builtins.str ignore_roles: Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        :param _builtins.str method: The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        :param _builtins.str password: Password for authentication with the server where to migrate data from.
        :param _builtins.int port: Port number of the server where to migrate data from.
        :param _builtins.bool ssl: The server where to migrate data from is secured with SSL.
        :param _builtins.str username: User name for authentication with the server where to migrate data from.
        """
        if dbname is not None:
            pulumi.set(__self__, "dbname", dbname)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ignore_dbs is not None:
            pulumi.set(__self__, "ignore_dbs", ignore_dbs)
        if ignore_roles is not None:
            pulumi.set(__self__, "ignore_roles", ignore_roles)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def dbname(self) -> Optional[_builtins.str]:
        """
        Database name for bootstrapping the initial connection.
        """
        return pulumi.get(self, "dbname")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname or IP address of the server where to migrate data from.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="ignoreDbs")
    def ignore_dbs(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of databases, which should be ignored during migration (supported by MySQL and PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_dbs")

    @_builtins.property
    @pulumi.getter(name="ignoreRoles")
    def ignore_roles(self) -> Optional[_builtins.str]:
        """
        Comma-separated list of database roles, which should be ignored during migration (supported by PostgreSQL only at the moment).
        """
        return pulumi.get(self, "ignore_roles")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The migration method to be used (currently supported only by Redis, Dragonfly, MySQL and PostgreSQL service types).
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the server where to migrate data from.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[_builtins.bool]:
        """
        The server where to migrate data from is secured with SSL.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        User name for authentication with the server where to migrate data from.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ManagedObjectStorageEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "iamUrl":
            suggest = "iam_url"
        elif key == "stsUrl":
            suggest = "sts_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedObjectStorageEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedObjectStorageEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedObjectStorageEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 iam_url: Optional[_builtins.str] = None,
                 sts_url: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: Domain name of the endpoint.
        :param _builtins.str iam_url: URL for IAM.
        :param _builtins.str sts_url: URL for STS.
        :param _builtins.str type: Type of the endpoint (`private` / `public`).
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if iam_url is not None:
            pulumi.set(__self__, "iam_url", iam_url)
        if sts_url is not None:
            pulumi.set(__self__, "sts_url", sts_url)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        Domain name of the endpoint.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="iamUrl")
    def iam_url(self) -> Optional[_builtins.str]:
        """
        URL for IAM.
        """
        return pulumi.get(self, "iam_url")

    @_builtins.property
    @pulumi.getter(name="stsUrl")
    def sts_url(self) -> Optional[_builtins.str]:
        """
        URL for STS.
        """
        return pulumi.get(self, "sts_url")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the endpoint (`private` / `public`).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ManagedObjectStorageNetwork(dict):
    def __init__(__self__, *,
                 family: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.str family: Network family. IPv6 currently not supported.
        :param _builtins.str name: Network name. Must be unique within the service.
        :param _builtins.str type: Network type.
        :param _builtins.str uuid: Private network uuid. For public networks the field should be omitted.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        Network family. IPv6 currently not supported.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Network name. Must be unique within the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Network type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        Private network uuid. For public networks the field should be omitted.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class NetworkIpNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dhcpDefaultRoute":
            suggest = "dhcp_default_route"
        elif key == "dhcpDns":
            suggest = "dhcp_dns"
        elif key == "dhcpRoutes":
            suggest = "dhcp_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkIpNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkIpNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkIpNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 dhcp: _builtins.bool,
                 family: _builtins.str,
                 dhcp_default_route: Optional[_builtins.bool] = None,
                 dhcp_dns: Optional[Sequence[_builtins.str]] = None,
                 dhcp_routes: Optional[Sequence[_builtins.str]] = None,
                 gateway: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The CIDR range of the subnet
        :param _builtins.bool dhcp: Is DHCP enabled?
        :param _builtins.str family: IP address family
        :param _builtins.bool dhcp_default_route: Is the gateway the DHCP default route?
        :param Sequence[_builtins.str] dhcp_dns: The DNS servers given by DHCP
        :param Sequence[_builtins.str] dhcp_routes: The additional DHCP classless static routes given by DHCP
        :param _builtins.str gateway: Gateway address given by DHCP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "dhcp", dhcp)
        pulumi.set(__self__, "family", family)
        if dhcp_default_route is not None:
            pulumi.set(__self__, "dhcp_default_route", dhcp_default_route)
        if dhcp_dns is not None:
            pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        if dhcp_routes is not None:
            pulumi.set(__self__, "dhcp_routes", dhcp_routes)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The CIDR range of the subnet
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def dhcp(self) -> _builtins.bool:
        """
        Is DHCP enabled?
        """
        return pulumi.get(self, "dhcp")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        IP address family
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter(name="dhcpDefaultRoute")
    def dhcp_default_route(self) -> Optional[_builtins.bool]:
        """
        Is the gateway the DHCP default route?
        """
        return pulumi.get(self, "dhcp_default_route")

    @_builtins.property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Optional[Sequence[_builtins.str]]:
        """
        The DNS servers given by DHCP
        """
        return pulumi.get(self, "dhcp_dns")

    @_builtins.property
    @pulumi.getter(name="dhcpRoutes")
    def dhcp_routes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The additional DHCP classless static routes given by DHCP
        """
        return pulumi.get(self, "dhcp_routes")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        Gateway address given by DHCP
        """
        return pulumi.get(self, "gateway")


@pulumi.output_type
class NetworkPeeringNetwork(dict):
    def __init__(__self__, *,
                 uuid: _builtins.str):
        """
        :param _builtins.str uuid: The UUID of the network.
        """
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the network.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class NetworkPeeringPeerNetwork(dict):
    def __init__(__self__, *,
                 uuid: _builtins.str):
        """
        :param _builtins.str uuid: The UUID of the network.
        """
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The UUID of the network.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class ObjectStorageBucket(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the bucket
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the bucket
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RouterStaticRoute(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 nexthop: _builtins.str,
                 route: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "route", route)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def route(self) -> _builtins.str:
        return pulumi.get(self, "route")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerFirewallRulesFirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddressEnd":
            suggest = "destination_address_end"
        elif key == "destinationAddressStart":
            suggest = "destination_address_start"
        elif key == "destinationPortEnd":
            suggest = "destination_port_end"
        elif key == "destinationPortStart":
            suggest = "destination_port_start"
        elif key == "icmpType":
            suggest = "icmp_type"
        elif key == "sourceAddressEnd":
            suggest = "source_address_end"
        elif key == "sourceAddressStart":
            suggest = "source_address_start"
        elif key == "sourcePortEnd":
            suggest = "source_port_end"
        elif key == "sourcePortStart":
            suggest = "source_port_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerFirewallRulesFirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerFirewallRulesFirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerFirewallRulesFirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 direction: _builtins.str,
                 comment: Optional[_builtins.str] = None,
                 destination_address_end: Optional[_builtins.str] = None,
                 destination_address_start: Optional[_builtins.str] = None,
                 destination_port_end: Optional[_builtins.str] = None,
                 destination_port_start: Optional[_builtins.str] = None,
                 family: Optional[_builtins.str] = None,
                 icmp_type: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 source_address_end: Optional[_builtins.str] = None,
                 source_address_start: Optional[_builtins.str] = None,
                 source_port_end: Optional[_builtins.str] = None,
                 source_port_start: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Action to take if the rule conditions are met. Valid values `accept | drop`.
        :param _builtins.str direction: The direction of network traffic this rule will be applied to. Valid values are `in` and `out`.
        :param _builtins.str comment: A comment for the rule.
        :param _builtins.str destination_address_end: The destination address range ends from this address
        :param _builtins.str destination_address_start: The destination address range starts from this address
        :param _builtins.str destination_port_end: The destination port range ends from this port number
        :param _builtins.str destination_port_start: The destination port range starts from this port number
        :param _builtins.str family: The address family of new firewall rule
        :param _builtins.str icmp_type: The ICMP type of the rule. Only valid if protocol is ICMP.
        :param _builtins.str protocol: The protocol of the rule. Possible values are `` (empty), `tcp`, `udp`, `icmp`.
        :param _builtins.str source_address_end: The source address range ends from this address
        :param _builtins.str source_address_start: The source address range starts from this address
        :param _builtins.str source_port_end: The source port range ends from this port number
        :param _builtins.str source_port_start: The source port range starts from this port number
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "direction", direction)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if destination_address_end is not None:
            pulumi.set(__self__, "destination_address_end", destination_address_end)
        if destination_address_start is not None:
            pulumi.set(__self__, "destination_address_start", destination_address_start)
        if destination_port_end is not None:
            pulumi.set(__self__, "destination_port_end", destination_port_end)
        if destination_port_start is not None:
            pulumi.set(__self__, "destination_port_start", destination_port_start)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address_end is not None:
            pulumi.set(__self__, "source_address_end", source_address_end)
        if source_address_start is not None:
            pulumi.set(__self__, "source_address_start", source_address_start)
        if source_port_end is not None:
            pulumi.set(__self__, "source_port_end", source_port_end)
        if source_port_start is not None:
            pulumi.set(__self__, "source_port_start", source_port_start)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Action to take if the rule conditions are met. Valid values `accept | drop`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        The direction of network traffic this rule will be applied to. Valid values are `in` and `out`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        A comment for the rule.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="destinationAddressEnd")
    def destination_address_end(self) -> Optional[_builtins.str]:
        """
        The destination address range ends from this address
        """
        return pulumi.get(self, "destination_address_end")

    @_builtins.property
    @pulumi.getter(name="destinationAddressStart")
    def destination_address_start(self) -> Optional[_builtins.str]:
        """
        The destination address range starts from this address
        """
        return pulumi.get(self, "destination_address_start")

    @_builtins.property
    @pulumi.getter(name="destinationPortEnd")
    def destination_port_end(self) -> Optional[_builtins.str]:
        """
        The destination port range ends from this port number
        """
        return pulumi.get(self, "destination_port_end")

    @_builtins.property
    @pulumi.getter(name="destinationPortStart")
    def destination_port_start(self) -> Optional[_builtins.str]:
        """
        The destination port range starts from this port number
        """
        return pulumi.get(self, "destination_port_start")

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[_builtins.str]:
        """
        The address family of new firewall rule
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[_builtins.str]:
        """
        The ICMP type of the rule. Only valid if protocol is ICMP.
        """
        return pulumi.get(self, "icmp_type")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol of the rule. Possible values are `` (empty), `tcp`, `udp`, `icmp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceAddressEnd")
    def source_address_end(self) -> Optional[_builtins.str]:
        """
        The source address range ends from this address
        """
        return pulumi.get(self, "source_address_end")

    @_builtins.property
    @pulumi.getter(name="sourceAddressStart")
    def source_address_start(self) -> Optional[_builtins.str]:
        """
        The source address range starts from this address
        """
        return pulumi.get(self, "source_address_start")

    @_builtins.property
    @pulumi.getter(name="sourcePortEnd")
    def source_port_end(self) -> Optional[_builtins.str]:
        """
        The source port range ends from this port number
        """
        return pulumi.get(self, "source_port_end")

    @_builtins.property
    @pulumi.getter(name="sourcePortStart")
    def source_port_start(self) -> Optional[_builtins.str]:
        """
        The source port range starts from this port number
        """
        return pulumi.get(self, "source_port_start")


@pulumi.output_type
class ServerLogin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createPassword":
            suggest = "create_password"
        elif key == "passwordDelivery":
            suggest = "password_delivery"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerLogin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerLogin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerLogin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_password: Optional[_builtins.bool] = None,
                 keys: Optional[Sequence[_builtins.str]] = None,
                 password_delivery: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.bool create_password: Indicates a password should be create to allow access
        :param Sequence[_builtins.str] keys: A list of ssh keys to access the server
        :param _builtins.str password_delivery: The delivery method for the server's root password (one of `none`, `email` or `sms`)
        :param _builtins.str user: Username to be create to access the server
        """
        if create_password is not None:
            pulumi.set(__self__, "create_password", create_password)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if password_delivery is not None:
            pulumi.set(__self__, "password_delivery", password_delivery)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="createPassword")
    def create_password(self) -> Optional[_builtins.bool]:
        """
        Indicates a password should be create to allow access
        """
        return pulumi.get(self, "create_password")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of ssh keys to access the server
        """
        return pulumi.get(self, "keys")

    @_builtins.property
    @pulumi.getter(name="passwordDelivery")
    def password_delivery(self) -> Optional[_builtins.str]:
        """
        The delivery method for the server's root password (one of `none`, `email` or `sms`)
        """
        return pulumi.get(self, "password_delivery")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        Username to be create to access the server
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServerNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalIpAddresses":
            suggest = "additional_ip_addresses"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipAddressFamily":
            suggest = "ip_address_family"
        elif key == "ipAddressFloating":
            suggest = "ip_address_floating"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "sourceIpFiltering":
            suggest = "source_ip_filtering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 additional_ip_addresses: Optional[Sequence['outputs.ServerNetworkInterfaceAdditionalIpAddress']] = None,
                 bootable: Optional[_builtins.bool] = None,
                 index: Optional[_builtins.int] = None,
                 ip_address: Optional[_builtins.str] = None,
                 ip_address_family: Optional[_builtins.str] = None,
                 ip_address_floating: Optional[_builtins.bool] = None,
                 mac_address: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 source_ip_filtering: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: Network interface type. For private network interfaces, a network must be specified with an existing network id.
        :param Sequence['ServerNetworkInterfaceAdditionalIpAddressArgs'] additional_ip_addresses: 0-31 blocks of additional IP addresses to assign to this interface. Allowed only with network interfaces of type `private`
        :param _builtins.bool bootable: `true` if this interface should be used for network booting.
        :param _builtins.int index: The interface index.
        :param _builtins.str ip_address: The primary IP address of this interface.
        :param _builtins.str ip_address_family: The type of the primary IP address of this interface (one of `IPv4` or `IPv6`).
        :param _builtins.bool ip_address_floating: `true` indicates that the primary IP address is a floating IP address.
        :param _builtins.str mac_address: The MAC address of the interface.
        :param _builtins.str network: The UUID of the network to attach this interface to. Required for private network interfaces.
        :param _builtins.bool source_ip_filtering: `true` if source IP should be filtered.
        """
        pulumi.set(__self__, "type", type)
        if additional_ip_addresses is not None:
            pulumi.set(__self__, "additional_ip_addresses", additional_ip_addresses)
        if bootable is not None:
            pulumi.set(__self__, "bootable", bootable)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_family is not None:
            pulumi.set(__self__, "ip_address_family", ip_address_family)
        if ip_address_floating is not None:
            pulumi.set(__self__, "ip_address_floating", ip_address_floating)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if source_ip_filtering is not None:
            pulumi.set(__self__, "source_ip_filtering", source_ip_filtering)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Network interface type. For private network interfaces, a network must be specified with an existing network id.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="additionalIpAddresses")
    def additional_ip_addresses(self) -> Optional[Sequence['outputs.ServerNetworkInterfaceAdditionalIpAddress']]:
        """
        0-31 blocks of additional IP addresses to assign to this interface. Allowed only with network interfaces of type `private`
        """
        return pulumi.get(self, "additional_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def bootable(self) -> Optional[_builtins.bool]:
        """
        `true` if this interface should be used for network booting.
        """
        return pulumi.get(self, "bootable")

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[_builtins.int]:
        """
        The interface index.
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The primary IP address of this interface.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipAddressFamily")
    def ip_address_family(self) -> Optional[_builtins.str]:
        """
        The type of the primary IP address of this interface (one of `IPv4` or `IPv6`).
        """
        return pulumi.get(self, "ip_address_family")

    @_builtins.property
    @pulumi.getter(name="ipAddressFloating")
    def ip_address_floating(self) -> Optional[_builtins.bool]:
        """
        `true` indicates that the primary IP address is a floating IP address.
        """
        return pulumi.get(self, "ip_address_floating")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        The MAC address of the interface.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The UUID of the network to attach this interface to. Required for private network interfaces.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="sourceIpFiltering")
    def source_ip_filtering(self) -> Optional[_builtins.bool]:
        """
        `true` if source IP should be filtered.
        """
        return pulumi.get(self, "source_ip_filtering")


@pulumi.output_type
class ServerNetworkInterfaceAdditionalIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipAddressFamily":
            suggest = "ip_address_family"
        elif key == "ipAddressFloating":
            suggest = "ip_address_floating"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerNetworkInterfaceAdditionalIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerNetworkInterfaceAdditionalIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerNetworkInterfaceAdditionalIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[_builtins.str] = None,
                 ip_address_family: Optional[_builtins.str] = None,
                 ip_address_floating: Optional[_builtins.bool] = None):
        """
        :param _builtins.str ip_address: An additional IP address for this interface.
        :param _builtins.str ip_address_family: The type of the additional IP address of this interface (one of `IPv4` or `IPv6`).
        :param _builtins.bool ip_address_floating: `true` indicates that the additional IP address is a floating IP address.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_family is not None:
            pulumi.set(__self__, "ip_address_family", ip_address_family)
        if ip_address_floating is not None:
            pulumi.set(__self__, "ip_address_floating", ip_address_floating)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        An additional IP address for this interface.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipAddressFamily")
    def ip_address_family(self) -> Optional[_builtins.str]:
        """
        The type of the additional IP address of this interface (one of `IPv4` or `IPv6`).
        """
        return pulumi.get(self, "ip_address_family")

    @_builtins.property
    @pulumi.getter(name="ipAddressFloating")
    def ip_address_floating(self) -> Optional[_builtins.bool]:
        """
        `true` indicates that the additional IP address is a floating IP address.
        """
        return pulumi.get(self, "ip_address_floating")


@pulumi.output_type
class ServerSimpleBackup(dict):
    def __init__(__self__, *,
                 plan: Optional[_builtins.str] = None,
                 time: Optional[_builtins.str] = None):
        """
        :param _builtins.str plan: Simple backup plan. Accepted values: daily, dailies, weeklies, monthlies.
        :param _builtins.str time: Time of the day at which backup will be taken. Should be provided in a hhmm format (e.g. 2230).
        """
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[_builtins.str]:
        """
        Simple backup plan. Accepted values: daily, dailies, weeklies, monthlies.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def time(self) -> Optional[_builtins.str]:
        """
        Time of the day at which backup will be taken. Should be provided in a hhmm format (e.g. 2230).
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class ServerStorageDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPosition":
            suggest = "address_position"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerStorageDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerStorageDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerStorageDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 address_position: Optional[_builtins.str] = None,
                 storage: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The device address the storage will be attached to (`scsi`|`virtio`|`ide`). Leave `address_position` field empty to auto-select next available address from that bus.
        :param _builtins.str address_position: The device position in the given bus (defined via field `address`). Valid values for address `virtio` are `0-15` (`0`, for example). Valid values for `scsi` or `ide` are `0-1:0-1` (`0:0`, for example). Leave empty to auto-select next available address in the given bus.
        :param _builtins.str storage: The UUID of the storage to attach to the server.
        :param _builtins.str type: The device type the storage will be attached as
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_position is not None:
            pulumi.set(__self__, "address_position", address_position)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The device address the storage will be attached to (`scsi`|`virtio`|`ide`). Leave `address_position` field empty to auto-select next available address from that bus.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressPosition")
    def address_position(self) -> Optional[_builtins.str]:
        """
        The device position in the given bus (defined via field `address`). Valid values for address `virtio` are `0-15` (`0`, for example). Valid values for `scsi` or `ide` are `0-1:0-1` (`0:0`, for example). Leave empty to auto-select next available address in the given bus.
        """
        return pulumi.get(self, "address_position")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[_builtins.str]:
        """
        The UUID of the storage to attach to the server.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The device type the storage will be attached as
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPosition":
            suggest = "address_position"
        elif key == "backupRule":
            suggest = "backup_rule"
        elif key == "deleteAutoresizeBackup":
            suggest = "delete_autoresize_backup"
        elif key == "filesystemAutoresize":
            suggest = "filesystem_autoresize"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 address_position: Optional[_builtins.str] = None,
                 backup_rule: Optional['outputs.ServerTemplateBackupRule'] = None,
                 delete_autoresize_backup: Optional[_builtins.bool] = None,
                 encrypt: Optional[_builtins.bool] = None,
                 filesystem_autoresize: Optional[_builtins.bool] = None,
                 id: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 storage: Optional[_builtins.str] = None,
                 tier: Optional[_builtins.str] = None,
                 title: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The device address the storage will be attached to (`scsi`|`virtio`|`ide`). Leave `address_position` field empty to auto-select next available address from that bus.
        :param _builtins.str address_position: The device position in the given bus (defined via field `address`). For example `0:0`, or `0`. Leave empty to auto-select next available address in the given bus.
        :param _builtins.bool delete_autoresize_backup: If set to true, the backup taken before the partition and filesystem resize attempt will be deleted immediately after success.
        :param _builtins.bool encrypt: Sets if the storage is encrypted at rest
        :param _builtins.bool filesystem_autoresize: If set to true, provider will attempt to resize partition and filesystem when the size of template storage changes.
               							Please note that before the resize attempt is made, backup of the storage will be taken. If the resize attempt fails, the backup will be used
               							to restore the storage and then deleted. If the resize attempt succeeds, backup will be kept (unless delete_autoresize_backup option is set to true).
               							Taking and keeping backups incure costs.
        :param _builtins.str id: The unique identifier for the storage
        :param _builtins.int size: The size of the storage in gigabytes
        :param _builtins.str storage: A valid storage UUID or template name. You can list available public templates with `upctl storage list --public --template` and available private templates with `upctl storage list --template`.
        :param _builtins.str tier: The storage tier to use.
        :param _builtins.str title: A short, informative description
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_position is not None:
            pulumi.set(__self__, "address_position", address_position)
        if backup_rule is not None:
            pulumi.set(__self__, "backup_rule", backup_rule)
        if delete_autoresize_backup is not None:
            pulumi.set(__self__, "delete_autoresize_backup", delete_autoresize_backup)
        if encrypt is not None:
            pulumi.set(__self__, "encrypt", encrypt)
        if filesystem_autoresize is not None:
            pulumi.set(__self__, "filesystem_autoresize", filesystem_autoresize)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The device address the storage will be attached to (`scsi`|`virtio`|`ide`). Leave `address_position` field empty to auto-select next available address from that bus.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressPosition")
    def address_position(self) -> Optional[_builtins.str]:
        """
        The device position in the given bus (defined via field `address`). For example `0:0`, or `0`. Leave empty to auto-select next available address in the given bus.
        """
        return pulumi.get(self, "address_position")

    @_builtins.property
    @pulumi.getter(name="backupRule")
    def backup_rule(self) -> Optional['outputs.ServerTemplateBackupRule']:
        return pulumi.get(self, "backup_rule")

    @_builtins.property
    @pulumi.getter(name="deleteAutoresizeBackup")
    def delete_autoresize_backup(self) -> Optional[_builtins.bool]:
        """
        If set to true, the backup taken before the partition and filesystem resize attempt will be deleted immediately after success.
        """
        return pulumi.get(self, "delete_autoresize_backup")

    @_builtins.property
    @pulumi.getter
    def encrypt(self) -> Optional[_builtins.bool]:
        """
        Sets if the storage is encrypted at rest
        """
        return pulumi.get(self, "encrypt")

    @_builtins.property
    @pulumi.getter(name="filesystemAutoresize")
    def filesystem_autoresize(self) -> Optional[_builtins.bool]:
        """
        If set to true, provider will attempt to resize partition and filesystem when the size of template storage changes.
        							Please note that before the resize attempt is made, backup of the storage will be taken. If the resize attempt fails, the backup will be used
        							to restore the storage and then deleted. If the resize attempt succeeds, backup will be kept (unless delete_autoresize_backup option is set to true).
        							Taking and keeping backups incure costs.
        """
        return pulumi.get(self, "filesystem_autoresize")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique identifier for the storage
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The size of the storage in gigabytes
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[_builtins.str]:
        """
        A valid storage UUID or template name. You can list available public templates with `upctl storage list --public --template` and available private templates with `upctl storage list --template`.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[_builtins.str]:
        """
        The storage tier to use.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[_builtins.str]:
        """
        A short, informative description
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ServerTemplateBackupRule(dict):
    def __init__(__self__, *,
                 interval: _builtins.str,
                 retention: _builtins.int,
                 time: _builtins.str):
        """
        :param _builtins.str interval: The weekday when the backup is created
        :param _builtins.int retention: The number of days before a backup is automatically deleted
        :param _builtins.str time: The time of day (UTC) when the backup is created
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        The weekday when the backup is created
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.int:
        """
        The number of days before a backup is automatically deleted
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def time(self) -> _builtins.str:
        """
        The time of day (UTC) when the backup is created
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class StorageBackupRule(dict):
    def __init__(__self__, *,
                 interval: _builtins.str,
                 retention: _builtins.int,
                 time: _builtins.str):
        """
        :param _builtins.str interval: The weekday when the backup is created
        :param _builtins.int retention: The number of days before a backup is automatically deleted
        :param _builtins.str time: The time of day (UTC) when the backup is created
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "time", time)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        The weekday when the backup is created
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.int:
        """
        The number of days before a backup is automatically deleted
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def time(self) -> _builtins.str:
        """
        The time of day (UTC) when the backup is created
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class StorageClone(dict):
    def __init__(__self__, *,
                 id: _builtins.str):
        """
        :param _builtins.str id: The unique identifier of the storage/template to clone.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the storage/template to clone.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class StorageImport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceLocation":
            suggest = "source_location"
        elif key == "sourceHash":
            suggest = "source_hash"
        elif key == "writtenBytes":
            suggest = "written_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageImport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageImport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageImport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: _builtins.str,
                 source_location: _builtins.str,
                 sha256sum: Optional[_builtins.str] = None,
                 source_hash: Optional[_builtins.str] = None,
                 written_bytes: Optional[_builtins.int] = None):
        """
        :param _builtins.str source: The mode of the import task. One of `http_import` or `direct_upload`.
        :param _builtins.str source_location: The location of the file to import. For `http_import` an accessible URL. For `direct_upload` a local file. When direct uploading a compressed image, `Content-Type` header of the PUT request is set automatically based on the file extension (`.gz` or `.xz`, case-insensitive).
        :param _builtins.str sha256sum: sha256 sum of the imported data
        :param _builtins.str source_hash: SHA256 hash of the source content. This hash is used to verify the integrity of the imported data by comparing it to `sha256sum` after the import has completed. Possible filename is automatically removed from the hash before comparison.
        :param _builtins.int written_bytes: Number of bytes imported
        """
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_location", source_location)
        if sha256sum is not None:
            pulumi.set(__self__, "sha256sum", sha256sum)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)
        if written_bytes is not None:
            pulumi.set(__self__, "written_bytes", written_bytes)

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The mode of the import task. One of `http_import` or `direct_upload`.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> _builtins.str:
        """
        The location of the file to import. For `http_import` an accessible URL. For `direct_upload` a local file. When direct uploading a compressed image, `Content-Type` header of the PUT request is set automatically based on the file extension (`.gz` or `.xz`, case-insensitive).
        """
        return pulumi.get(self, "source_location")

    @_builtins.property
    @pulumi.getter
    def sha256sum(self) -> Optional[_builtins.str]:
        """
        sha256 sum of the imported data
        """
        return pulumi.get(self, "sha256sum")

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[_builtins.str]:
        """
        SHA256 hash of the source content. This hash is used to verify the integrity of the imported data by comparing it to `sha256sum` after the import has completed. Possible filename is automatically removed from the hash before comparison.
        """
        return pulumi.get(self, "source_hash")

    @_builtins.property
    @pulumi.getter(name="writtenBytes")
    def written_bytes(self) -> Optional[_builtins.int]:
        """
        Number of bytes imported
        """
        return pulumi.get(self, "written_bytes")


@pulumi.output_type
class GetHostsHostResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 host_id: _builtins.int,
                 windows_enabled: _builtins.bool,
                 zone: _builtins.str,
                 statistics: Optional[Sequence['outputs.GetHostsHostStatisticResult']] = None):
        """
        :param _builtins.str description: Free form text describing the host
        :param _builtins.int host_id: The unique id of the host
        :param _builtins.bool windows_enabled: If true, this node can be used as a host for Windows servers.
        :param _builtins.str zone: The zone the host is in, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "windows_enabled", windows_enabled)
        pulumi.set(__self__, "zone", zone)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Free form text describing the host
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> _builtins.int:
        """
        The unique id of the host
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter(name="windowsEnabled")
    def windows_enabled(self) -> _builtins.bool:
        """
        If true, this node can be used as a host for Windows servers.
        """
        return pulumi.get(self, "windows_enabled")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zone the host is in, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Optional[Sequence['outputs.GetHostsHostStatisticResult']]:
        return pulumi.get(self, "statistics")


@pulumi.output_type
class GetHostsHostStatisticResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 timestamp: _builtins.str,
                 value: _builtins.float):
        """
        :param _builtins.str name: The name of the statistic
        :param _builtins.str timestamp: The timestamp of the statistic
        :param _builtins.float value: The value of the statistic
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the statistic
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> _builtins.str:
        """
        The timestamp of the statistic
        """
        return pulumi.get(self, "timestamp")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.float:
        """
        The value of the statistic
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetIpAddressesAddressResult(dict):
    def __init__(__self__, *,
                 access: _builtins.str,
                 address: _builtins.str,
                 family: _builtins.str,
                 floating: _builtins.bool,
                 mac: _builtins.str,
                 part_of_plan: _builtins.bool,
                 ptr_record: _builtins.str,
                 server: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str access: Is address for utility or public network
        :param _builtins.str address: An UpCloud assigned IP Address
        :param _builtins.str family: IP address family
        :param _builtins.bool floating: Does the IP Address represents a floating IP Address
        :param _builtins.str mac: MAC address of server interface to assign address to
        :param _builtins.bool part_of_plan: Is the address a part of a plan
        :param _builtins.str ptr_record: A reverse DNS record entry
        :param _builtins.str server: The unique identifier for a server
        :param _builtins.str zone: Zone of address, required when assigning a detached floating IP address, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "floating", floating)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "part_of_plan", part_of_plan)
        pulumi.set(__self__, "ptr_record", ptr_record)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def access(self) -> _builtins.str:
        """
        Is address for utility or public network
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        An UpCloud assigned IP Address
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        IP address family
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def floating(self) -> _builtins.bool:
        """
        Does the IP Address represents a floating IP Address
        """
        return pulumi.get(self, "floating")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> _builtins.str:
        """
        MAC address of server interface to assign address to
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter(name="partOfPlan")
    def part_of_plan(self) -> _builtins.bool:
        """
        Is the address a part of a plan
        """
        return pulumi.get(self, "part_of_plan")

    @_builtins.property
    @pulumi.getter(name="ptrRecord")
    def ptr_record(self) -> _builtins.str:
        """
        A reverse DNS record entry
        """
        return pulumi.get(self, "ptr_record")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The unique identifier for a server
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        Zone of address, required when assigning a detached floating IP address, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetManagedDatabaseMysqlSessionsSessionResult(dict):
    def __init__(__self__, *,
                 application_name: _builtins.str,
                 client_addr: _builtins.str,
                 datname: _builtins.str,
                 id: _builtins.str,
                 query: _builtins.str,
                 query_duration: _builtins.str,
                 state: _builtins.str,
                 usename: _builtins.str):
        """
        :param _builtins.str application_name: Name of the application that is connected to this service.
        :param _builtins.str client_addr: IP address of the client connected to this service.
        :param _builtins.str datname: Name of the database this service is connected to.
        :param _builtins.str id: Process ID of this service.
        :param _builtins.str query: Text of this service's most recent query. If state is active this field shows the currently executing query. In all other states, it shows an empty string.
        :param _builtins.str query_duration: The active query current duration.
        :param _builtins.str state: Current overall state of this service: active: The service is executing a query, idle: The service is waiting for a new client command.
        :param _builtins.str usename: Name of the user logged into this service.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "client_addr", client_addr)
        pulumi.set(__self__, "datname", datname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_duration", query_duration)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "usename", usename)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        Name of the application that is connected to this service.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="clientAddr")
    def client_addr(self) -> _builtins.str:
        """
        IP address of the client connected to this service.
        """
        return pulumi.get(self, "client_addr")

    @_builtins.property
    @pulumi.getter
    def datname(self) -> _builtins.str:
        """
        Name of the database this service is connected to.
        """
        return pulumi.get(self, "datname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Process ID of this service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Text of this service's most recent query. If state is active this field shows the currently executing query. In all other states, it shows an empty string.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryDuration")
    def query_duration(self) -> _builtins.str:
        """
        The active query current duration.
        """
        return pulumi.get(self, "query_duration")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Current overall state of this service: active: The service is executing a query, idle: The service is waiting for a new client command.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def usename(self) -> _builtins.str:
        """
        Name of the user logged into this service.
        """
        return pulumi.get(self, "usename")


@pulumi.output_type
class GetManagedDatabaseOpensearchIndicesIndexResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 docs: _builtins.int,
                 health: _builtins.str,
                 index_name: _builtins.str,
                 number_of_replicas: _builtins.int,
                 number_of_shards: _builtins.int,
                 read_only_allow_delete: _builtins.bool,
                 size: _builtins.int,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: Timestamp indicating the creation time of the index.
        :param _builtins.int docs: Number of documents stored in the index.
        :param _builtins.str health: Health status of the index e.g. `green`, `yellow`, or `red`.
        :param _builtins.str index_name: Name of the index.
        :param _builtins.int number_of_replicas: Number of replicas configured for the index.
        :param _builtins.int number_of_shards: Number of shards configured & used by the index.
        :param _builtins.bool read_only_allow_delete: Indicates whether the index is in a read-only state that permits deletion of the entire index. This attribute can be automatically set to true in certain scenarios where the node disk space exceeds the flood stage.
        :param _builtins.int size: Size of the index in bytes.
        :param _builtins.str status: Status of the index e.g. `open` or `closed`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "docs", docs)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "number_of_replicas", number_of_replicas)
        pulumi.set(__self__, "number_of_shards", number_of_shards)
        pulumi.set(__self__, "read_only_allow_delete", read_only_allow_delete)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Timestamp indicating the creation time of the index.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def docs(self) -> _builtins.int:
        """
        Number of documents stored in the index.
        """
        return pulumi.get(self, "docs")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Health status of the index e.g. `green`, `yellow`, or `red`.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="indexName")
    def index_name(self) -> _builtins.str:
        """
        Name of the index.
        """
        return pulumi.get(self, "index_name")

    @_builtins.property
    @pulumi.getter(name="numberOfReplicas")
    def number_of_replicas(self) -> _builtins.int:
        """
        Number of replicas configured for the index.
        """
        return pulumi.get(self, "number_of_replicas")

    @_builtins.property
    @pulumi.getter(name="numberOfShards")
    def number_of_shards(self) -> _builtins.int:
        """
        Number of shards configured & used by the index.
        """
        return pulumi.get(self, "number_of_shards")

    @_builtins.property
    @pulumi.getter(name="readOnlyAllowDelete")
    def read_only_allow_delete(self) -> _builtins.bool:
        """
        Indicates whether the index is in a read-only state that permits deletion of the entire index. This attribute can be automatically set to true in certain scenarios where the node disk space exceeds the flood stage.
        """
        return pulumi.get(self, "read_only_allow_delete")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Size of the index in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the index e.g. `open` or `closed`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetManagedDatabasePostgresqlSessionsSessionResult(dict):
    def __init__(__self__, *,
                 application_name: _builtins.str,
                 backend_start: _builtins.str,
                 backend_type: _builtins.str,
                 backend_xid: _builtins.int,
                 backend_xmin: _builtins.int,
                 client_addr: _builtins.str,
                 client_hostname: _builtins.str,
                 client_port: _builtins.int,
                 datid: _builtins.int,
                 datname: _builtins.str,
                 id: _builtins.str,
                 query: _builtins.str,
                 query_duration: _builtins.str,
                 query_start: _builtins.str,
                 state: _builtins.str,
                 state_change: _builtins.str,
                 usename: _builtins.str,
                 usesysid: _builtins.int,
                 wait_event: _builtins.str,
                 wait_event_type: _builtins.str,
                 xact_start: _builtins.str):
        """
        :param _builtins.str application_name: Name of the application that is connected to this service.
        :param _builtins.str backend_start: Time when this process was started, i.e., when the client connected to the server.
        :param _builtins.str backend_type: Type of current service.
        :param _builtins.int backend_xid: Top-level transaction identifier of this service, if any.
        :param _builtins.int backend_xmin: The current service's xmin horizon.
        :param _builtins.str client_addr: IP address of the client connected to this service. If this field is null, it indicates either that the client is connected via a Unix socket on the server machine or that this is an internal process such as autovacuum.
        :param _builtins.str client_hostname: Host name of the connected client, as reported by a reverse DNS lookup of `client_addr`.
        :param _builtins.int client_port: TCP port number that the client is using for communication with this service, or -1 if a Unix socket is used.
        :param _builtins.int datid: OID of the database this service is connected to.
        :param _builtins.str datname: Name of the database this service is connected to.
        :param _builtins.str id: Process ID of this service.
        :param _builtins.str query: Text of this service's most recent query. If state is active this field shows the currently executing query. In all other states, it shows the last query that was executed.
        :param _builtins.str query_duration: The active query current duration.
        :param _builtins.str query_start: Time when the currently active query was started, or if state is not active, when the last query was started.
        :param _builtins.str state: Current overall state of this service: active: The service is executing a query, idle: The service is waiting for a new client command.
        :param _builtins.str state_change: Time when the state was last changed.
        :param _builtins.str usename: Name of the user logged into this service.
        :param _builtins.int usesysid: OID of the user logged into this service.
        :param _builtins.str wait_event: Wait event name if service is currently waiting.
        :param _builtins.str wait_event_type: The type of event for which the service is waiting, if any; otherwise NULL.
        :param _builtins.str xact_start: Time when this process' current transaction was started, or null if no transaction is active.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "backend_start", backend_start)
        pulumi.set(__self__, "backend_type", backend_type)
        pulumi.set(__self__, "backend_xid", backend_xid)
        pulumi.set(__self__, "backend_xmin", backend_xmin)
        pulumi.set(__self__, "client_addr", client_addr)
        pulumi.set(__self__, "client_hostname", client_hostname)
        pulumi.set(__self__, "client_port", client_port)
        pulumi.set(__self__, "datid", datid)
        pulumi.set(__self__, "datname", datname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_duration", query_duration)
        pulumi.set(__self__, "query_start", query_start)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_change", state_change)
        pulumi.set(__self__, "usename", usename)
        pulumi.set(__self__, "usesysid", usesysid)
        pulumi.set(__self__, "wait_event", wait_event)
        pulumi.set(__self__, "wait_event_type", wait_event_type)
        pulumi.set(__self__, "xact_start", xact_start)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        Name of the application that is connected to this service.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="backendStart")
    def backend_start(self) -> _builtins.str:
        """
        Time when this process was started, i.e., when the client connected to the server.
        """
        return pulumi.get(self, "backend_start")

    @_builtins.property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> _builtins.str:
        """
        Type of current service.
        """
        return pulumi.get(self, "backend_type")

    @_builtins.property
    @pulumi.getter(name="backendXid")
    def backend_xid(self) -> _builtins.int:
        """
        Top-level transaction identifier of this service, if any.
        """
        return pulumi.get(self, "backend_xid")

    @_builtins.property
    @pulumi.getter(name="backendXmin")
    def backend_xmin(self) -> _builtins.int:
        """
        The current service's xmin horizon.
        """
        return pulumi.get(self, "backend_xmin")

    @_builtins.property
    @pulumi.getter(name="clientAddr")
    def client_addr(self) -> _builtins.str:
        """
        IP address of the client connected to this service. If this field is null, it indicates either that the client is connected via a Unix socket on the server machine or that this is an internal process such as autovacuum.
        """
        return pulumi.get(self, "client_addr")

    @_builtins.property
    @pulumi.getter(name="clientHostname")
    def client_hostname(self) -> _builtins.str:
        """
        Host name of the connected client, as reported by a reverse DNS lookup of `client_addr`.
        """
        return pulumi.get(self, "client_hostname")

    @_builtins.property
    @pulumi.getter(name="clientPort")
    def client_port(self) -> _builtins.int:
        """
        TCP port number that the client is using for communication with this service, or -1 if a Unix socket is used.
        """
        return pulumi.get(self, "client_port")

    @_builtins.property
    @pulumi.getter
    def datid(self) -> _builtins.int:
        """
        OID of the database this service is connected to.
        """
        return pulumi.get(self, "datid")

    @_builtins.property
    @pulumi.getter
    def datname(self) -> _builtins.str:
        """
        Name of the database this service is connected to.
        """
        return pulumi.get(self, "datname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Process ID of this service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Text of this service's most recent query. If state is active this field shows the currently executing query. In all other states, it shows the last query that was executed.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryDuration")
    def query_duration(self) -> _builtins.str:
        """
        The active query current duration.
        """
        return pulumi.get(self, "query_duration")

    @_builtins.property
    @pulumi.getter(name="queryStart")
    def query_start(self) -> _builtins.str:
        """
        Time when the currently active query was started, or if state is not active, when the last query was started.
        """
        return pulumi.get(self, "query_start")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Current overall state of this service: active: The service is executing a query, idle: The service is waiting for a new client command.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateChange")
    def state_change(self) -> _builtins.str:
        """
        Time when the state was last changed.
        """
        return pulumi.get(self, "state_change")

    @_builtins.property
    @pulumi.getter
    def usename(self) -> _builtins.str:
        """
        Name of the user logged into this service.
        """
        return pulumi.get(self, "usename")

    @_builtins.property
    @pulumi.getter
    def usesysid(self) -> _builtins.int:
        """
        OID of the user logged into this service.
        """
        return pulumi.get(self, "usesysid")

    @_builtins.property
    @pulumi.getter(name="waitEvent")
    def wait_event(self) -> _builtins.str:
        """
        Wait event name if service is currently waiting.
        """
        return pulumi.get(self, "wait_event")

    @_builtins.property
    @pulumi.getter(name="waitEventType")
    def wait_event_type(self) -> _builtins.str:
        """
        The type of event for which the service is waiting, if any; otherwise NULL.
        """
        return pulumi.get(self, "wait_event_type")

    @_builtins.property
    @pulumi.getter(name="xactStart")
    def xact_start(self) -> _builtins.str:
        """
        Time when this process' current transaction was started, or null if no transaction is active.
        """
        return pulumi.get(self, "xact_start")


@pulumi.output_type
class GetManagedDatabaseRedisSessionsSessionResult(dict):
    def __init__(__self__, *,
                 active_channel_subscriptions: _builtins.int,
                 active_database: _builtins.str,
                 active_pattern_matching_channel_subscriptions: _builtins.int,
                 application_name: _builtins.str,
                 client_addr: _builtins.str,
                 connection_age: _builtins.int,
                 connection_idle: _builtins.int,
                 flags: Sequence[_builtins.str],
                 flags_raw: _builtins.str,
                 id: _builtins.str,
                 multi_exec_commands: _builtins.int,
                 output_buffer: _builtins.int,
                 output_buffer_memory: _builtins.int,
                 output_list_length: _builtins.int,
                 query: _builtins.str,
                 query_buffer: _builtins.int,
                 query_buffer_free: _builtins.int):
        """
        :param _builtins.int active_channel_subscriptions: Number of active channel subscriptions
        :param _builtins.str active_database: Current database ID
        :param _builtins.int active_pattern_matching_channel_subscriptions: Number of pattern matching subscriptions.
        :param _builtins.str application_name: Name of the application that is connected to this service.
        :param _builtins.str client_addr: Number of pattern matching subscriptions.
        :param _builtins.int connection_age: Total duration of the connection in nanoseconds.
        :param _builtins.int connection_idle: Idle time of the connection in nanoseconds.
        :param Sequence[_builtins.str] flags: A set containing flags' descriptions.
        :param _builtins.str flags_raw: Client connection flags in raw string format.
        :param _builtins.str id: Process ID of this session.
        :param _builtins.int multi_exec_commands: Number of commands in a MULTI/EXEC context.
        :param _builtins.int output_buffer: Output buffer length.
        :param _builtins.int output_buffer_memory: Output buffer memory usage.
        :param _builtins.int output_list_length: Output list length (replies are queued in this list when the buffer is full).
        :param _builtins.str query: The last executed command.
        :param _builtins.int query_buffer: Query buffer length (0 means no query pending).
        :param _builtins.int query_buffer_free: Free space of the query buffer (0 means the buffer is full).
        """
        pulumi.set(__self__, "active_channel_subscriptions", active_channel_subscriptions)
        pulumi.set(__self__, "active_database", active_database)
        pulumi.set(__self__, "active_pattern_matching_channel_subscriptions", active_pattern_matching_channel_subscriptions)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "client_addr", client_addr)
        pulumi.set(__self__, "connection_age", connection_age)
        pulumi.set(__self__, "connection_idle", connection_idle)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "flags_raw", flags_raw)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_exec_commands", multi_exec_commands)
        pulumi.set(__self__, "output_buffer", output_buffer)
        pulumi.set(__self__, "output_buffer_memory", output_buffer_memory)
        pulumi.set(__self__, "output_list_length", output_list_length)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_buffer", query_buffer)
        pulumi.set(__self__, "query_buffer_free", query_buffer_free)

    @_builtins.property
    @pulumi.getter(name="activeChannelSubscriptions")
    def active_channel_subscriptions(self) -> _builtins.int:
        """
        Number of active channel subscriptions
        """
        return pulumi.get(self, "active_channel_subscriptions")

    @_builtins.property
    @pulumi.getter(name="activeDatabase")
    def active_database(self) -> _builtins.str:
        """
        Current database ID
        """
        return pulumi.get(self, "active_database")

    @_builtins.property
    @pulumi.getter(name="activePatternMatchingChannelSubscriptions")
    def active_pattern_matching_channel_subscriptions(self) -> _builtins.int:
        """
        Number of pattern matching subscriptions.
        """
        return pulumi.get(self, "active_pattern_matching_channel_subscriptions")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        Name of the application that is connected to this service.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="clientAddr")
    def client_addr(self) -> _builtins.str:
        """
        Number of pattern matching subscriptions.
        """
        return pulumi.get(self, "client_addr")

    @_builtins.property
    @pulumi.getter(name="connectionAge")
    def connection_age(self) -> _builtins.int:
        """
        Total duration of the connection in nanoseconds.
        """
        return pulumi.get(self, "connection_age")

    @_builtins.property
    @pulumi.getter(name="connectionIdle")
    def connection_idle(self) -> _builtins.int:
        """
        Idle time of the connection in nanoseconds.
        """
        return pulumi.get(self, "connection_idle")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Sequence[_builtins.str]:
        """
        A set containing flags' descriptions.
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter(name="flagsRaw")
    def flags_raw(self) -> _builtins.str:
        """
        Client connection flags in raw string format.
        """
        return pulumi.get(self, "flags_raw")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Process ID of this session.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiExecCommands")
    def multi_exec_commands(self) -> _builtins.int:
        """
        Number of commands in a MULTI/EXEC context.
        """
        return pulumi.get(self, "multi_exec_commands")

    @_builtins.property
    @pulumi.getter(name="outputBuffer")
    def output_buffer(self) -> _builtins.int:
        """
        Output buffer length.
        """
        return pulumi.get(self, "output_buffer")

    @_builtins.property
    @pulumi.getter(name="outputBufferMemory")
    def output_buffer_memory(self) -> _builtins.int:
        """
        Output buffer memory usage.
        """
        return pulumi.get(self, "output_buffer_memory")

    @_builtins.property
    @pulumi.getter(name="outputListLength")
    def output_list_length(self) -> _builtins.int:
        """
        Output list length (replies are queued in this list when the buffer is full).
        """
        return pulumi.get(self, "output_list_length")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The last executed command.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryBuffer")
    def query_buffer(self) -> _builtins.int:
        """
        Query buffer length (0 means no query pending).
        """
        return pulumi.get(self, "query_buffer")

    @_builtins.property
    @pulumi.getter(name="queryBufferFree")
    def query_buffer_free(self) -> _builtins.int:
        """
        Free space of the query buffer (0 means the buffer is full).
        """
        return pulumi.get(self, "query_buffer_free")


@pulumi.output_type
class GetManagedDatabaseValkeySessionsSessionResult(dict):
    def __init__(__self__, *,
                 active_channel_subscriptions: _builtins.int,
                 active_database: _builtins.str,
                 active_pattern_matching_channel_subscriptions: _builtins.int,
                 application_name: _builtins.str,
                 client_addr: _builtins.str,
                 connection_age: _builtins.int,
                 connection_idle: _builtins.int,
                 flags: Sequence[_builtins.str],
                 flags_raw: _builtins.str,
                 id: _builtins.str,
                 multi_exec_commands: _builtins.int,
                 output_buffer: _builtins.int,
                 output_buffer_memory: _builtins.int,
                 output_list_length: _builtins.int,
                 query: _builtins.str,
                 query_buffer: _builtins.int,
                 query_buffer_free: _builtins.int):
        """
        :param _builtins.int active_channel_subscriptions: Number of active channel subscriptions
        :param _builtins.str active_database: Current database ID
        :param _builtins.int active_pattern_matching_channel_subscriptions: Number of pattern matching subscriptions.
        :param _builtins.str application_name: Name of the application that is connected to this service.
        :param _builtins.str client_addr: Number of pattern matching subscriptions.
        :param _builtins.int connection_age: Total duration of the connection in nanoseconds.
        :param _builtins.int connection_idle: Idle time of the connection in nanoseconds.
        :param Sequence[_builtins.str] flags: A set containing flags' descriptions.
        :param _builtins.str flags_raw: Client connection flags in raw string format.
        :param _builtins.str id: Process ID of this session.
        :param _builtins.int multi_exec_commands: Number of commands in a MULTI/EXEC context.
        :param _builtins.int output_buffer: Output buffer length.
        :param _builtins.int output_buffer_memory: Output buffer memory usage.
        :param _builtins.int output_list_length: Output list length (replies are queued in this list when the buffer is full).
        :param _builtins.str query: The last executed command.
        :param _builtins.int query_buffer: Query buffer length (0 means no query pending).
        :param _builtins.int query_buffer_free: Free space of the query buffer (0 means the buffer is full).
        """
        pulumi.set(__self__, "active_channel_subscriptions", active_channel_subscriptions)
        pulumi.set(__self__, "active_database", active_database)
        pulumi.set(__self__, "active_pattern_matching_channel_subscriptions", active_pattern_matching_channel_subscriptions)
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "client_addr", client_addr)
        pulumi.set(__self__, "connection_age", connection_age)
        pulumi.set(__self__, "connection_idle", connection_idle)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "flags_raw", flags_raw)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_exec_commands", multi_exec_commands)
        pulumi.set(__self__, "output_buffer", output_buffer)
        pulumi.set(__self__, "output_buffer_memory", output_buffer_memory)
        pulumi.set(__self__, "output_list_length", output_list_length)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_buffer", query_buffer)
        pulumi.set(__self__, "query_buffer_free", query_buffer_free)

    @_builtins.property
    @pulumi.getter(name="activeChannelSubscriptions")
    def active_channel_subscriptions(self) -> _builtins.int:
        """
        Number of active channel subscriptions
        """
        return pulumi.get(self, "active_channel_subscriptions")

    @_builtins.property
    @pulumi.getter(name="activeDatabase")
    def active_database(self) -> _builtins.str:
        """
        Current database ID
        """
        return pulumi.get(self, "active_database")

    @_builtins.property
    @pulumi.getter(name="activePatternMatchingChannelSubscriptions")
    def active_pattern_matching_channel_subscriptions(self) -> _builtins.int:
        """
        Number of pattern matching subscriptions.
        """
        return pulumi.get(self, "active_pattern_matching_channel_subscriptions")

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        """
        Name of the application that is connected to this service.
        """
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="clientAddr")
    def client_addr(self) -> _builtins.str:
        """
        Number of pattern matching subscriptions.
        """
        return pulumi.get(self, "client_addr")

    @_builtins.property
    @pulumi.getter(name="connectionAge")
    def connection_age(self) -> _builtins.int:
        """
        Total duration of the connection in nanoseconds.
        """
        return pulumi.get(self, "connection_age")

    @_builtins.property
    @pulumi.getter(name="connectionIdle")
    def connection_idle(self) -> _builtins.int:
        """
        Idle time of the connection in nanoseconds.
        """
        return pulumi.get(self, "connection_idle")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> Sequence[_builtins.str]:
        """
        A set containing flags' descriptions.
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter(name="flagsRaw")
    def flags_raw(self) -> _builtins.str:
        """
        Client connection flags in raw string format.
        """
        return pulumi.get(self, "flags_raw")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Process ID of this session.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiExecCommands")
    def multi_exec_commands(self) -> _builtins.int:
        """
        Number of commands in a MULTI/EXEC context.
        """
        return pulumi.get(self, "multi_exec_commands")

    @_builtins.property
    @pulumi.getter(name="outputBuffer")
    def output_buffer(self) -> _builtins.int:
        """
        Output buffer length.
        """
        return pulumi.get(self, "output_buffer")

    @_builtins.property
    @pulumi.getter(name="outputBufferMemory")
    def output_buffer_memory(self) -> _builtins.int:
        """
        Output buffer memory usage.
        """
        return pulumi.get(self, "output_buffer_memory")

    @_builtins.property
    @pulumi.getter(name="outputListLength")
    def output_list_length(self) -> _builtins.int:
        """
        Output list length (replies are queued in this list when the buffer is full).
        """
        return pulumi.get(self, "output_list_length")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The last executed command.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryBuffer")
    def query_buffer(self) -> _builtins.int:
        """
        Query buffer length (0 means no query pending).
        """
        return pulumi.get(self, "query_buffer")

    @_builtins.property
    @pulumi.getter(name="queryBufferFree")
    def query_buffer_free(self) -> _builtins.int:
        """
        Free space of the query buffer (0 means the buffer is full).
        """
        return pulumi.get(self, "query_buffer_free")


@pulumi.output_type
class GetManagedObjectStoragePoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 attachment_count: _builtins.int,
                 created_at: _builtins.str,
                 default_version_id: _builtins.str,
                 document: _builtins.str,
                 name: _builtins.str,
                 service_uuid: _builtins.str,
                 system: _builtins.bool,
                 updated_at: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn: Policy ARN.
        :param _builtins.int attachment_count: Attachment count.
        :param _builtins.str created_at: Creation time.
        :param _builtins.str default_version_id: Default version id.
        :param _builtins.str document: Policy document, URL-encoded compliant with RFC 3986.
        :param _builtins.str name: Policy name.
        :param _builtins.str service_uuid: Managed Object Storage service UUID.
        :param _builtins.bool system: Defines whether the policy was set up by the system.
        :param _builtins.str updated_at: Update time.
        :param _builtins.str description: Description of the policy.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "attachment_count", attachment_count)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "default_version_id", default_version_id)
        pulumi.set(__self__, "document", document)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uuid", service_uuid)
        pulumi.set(__self__, "system", system)
        pulumi.set(__self__, "updated_at", updated_at)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Policy ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> _builtins.int:
        """
        Attachment count.
        """
        return pulumi.get(self, "attachment_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="defaultVersionId")
    def default_version_id(self) -> _builtins.str:
        """
        Default version id.
        """
        return pulumi.get(self, "default_version_id")

    @_builtins.property
    @pulumi.getter
    def document(self) -> _builtins.str:
        """
        Policy document, URL-encoded compliant with RFC 3986.
        """
        return pulumi.get(self, "document")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Policy name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceUuid")
    def service_uuid(self) -> _builtins.str:
        """
        Managed Object Storage service UUID.
        """
        return pulumi.get(self, "service_uuid")

    @_builtins.property
    @pulumi.getter
    def system(self) -> _builtins.bool:
        """
        Defines whether the policy was set up by the system.
        """
        return pulumi.get(self, "system")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Update time.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the policy.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetManagedObjectStorageRegionsRegionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 primary_zone: _builtins.str,
                 zones: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Name of the region.
        :param _builtins.str primary_zone: Primary zone of the region.
        :param Sequence[_builtins.str] zones: List of zones in the region.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_zone", primary_zone)
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the region.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryZone")
    def primary_zone(self) -> _builtins.str:
        """
        Primary zone of the region.
        """
        return pulumi.get(self, "primary_zone")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence[_builtins.str]:
        """
        List of zones in the region.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GetNetworksNetworkResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 ip_networks: Sequence['outputs.GetNetworksNetworkIpNetworkResult'],
                 name: _builtins.str,
                 servers: Sequence['outputs.GetNetworksNetworkServerResult'],
                 type: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str id: The UUID of the network
        :param Sequence['GetNetworksNetworkIpNetworkArgs'] ip_networks: A list of IP subnets within the network
        :param _builtins.str name: A valid name for the network
        :param Sequence['GetNetworksNetworkServerArgs'] servers: A list of attached servers
        :param _builtins.str type: The network type
        :param _builtins.str zone: The zone the network is in, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_networks", ip_networks)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the network
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipNetworks")
    def ip_networks(self) -> Sequence['outputs.GetNetworksNetworkIpNetworkResult']:
        """
        A list of IP subnets within the network
        """
        return pulumi.get(self, "ip_networks")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A valid name for the network
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetNetworksNetworkServerResult']:
        """
        A list of attached servers
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The network type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zone the network is in, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetNetworksNetworkIpNetworkResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 dhcp: _builtins.bool,
                 dhcp_default_route: _builtins.bool,
                 dhcp_dns: Sequence[_builtins.str],
                 dhcp_routes: Sequence[_builtins.str],
                 family: _builtins.str,
                 gateway: _builtins.str):
        """
        :param _builtins.str address: The CIDR range of the subnet
        :param _builtins.bool dhcp: Is DHCP enabled?
        :param _builtins.bool dhcp_default_route: Is the gateway the DHCP default route?
        :param Sequence[_builtins.str] dhcp_dns: The DNS servers given by DHCP
        :param Sequence[_builtins.str] dhcp_routes: The additional DHCP classless static routes given by DHCP
        :param _builtins.str family: IP address family
        :param _builtins.str gateway: Gateway address given by DHCP
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "dhcp", dhcp)
        pulumi.set(__self__, "dhcp_default_route", dhcp_default_route)
        pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        pulumi.set(__self__, "dhcp_routes", dhcp_routes)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "gateway", gateway)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The CIDR range of the subnet
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def dhcp(self) -> _builtins.bool:
        """
        Is DHCP enabled?
        """
        return pulumi.get(self, "dhcp")

    @_builtins.property
    @pulumi.getter(name="dhcpDefaultRoute")
    def dhcp_default_route(self) -> _builtins.bool:
        """
        Is the gateway the DHCP default route?
        """
        return pulumi.get(self, "dhcp_default_route")

    @_builtins.property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Sequence[_builtins.str]:
        """
        The DNS servers given by DHCP
        """
        return pulumi.get(self, "dhcp_dns")

    @_builtins.property
    @pulumi.getter(name="dhcpRoutes")
    def dhcp_routes(self) -> Sequence[_builtins.str]:
        """
        The additional DHCP classless static routes given by DHCP
        """
        return pulumi.get(self, "dhcp_routes")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        IP address family
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        Gateway address given by DHCP
        """
        return pulumi.get(self, "gateway")


@pulumi.output_type
class GetNetworksNetworkServerResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 title: _builtins.str):
        """
        :param _builtins.str id: The UUID of the server
        :param _builtins.str title: The short description of the server
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The UUID of the server
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        The short description of the server
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str,
                 servers: Sequence[_builtins.str]):
        """
        :param _builtins.str description: Free form text representing the meaning of the tag
        :param _builtins.str name: The value representing the tag
        :param Sequence[_builtins.str] servers: A collection of servers that have been assigned the tag
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Free form text representing the meaning of the tag
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The value representing the tag
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence[_builtins.str]:
        """
        A collection of servers that have been assigned the tag
        """
        return pulumi.get(self, "servers")


