# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StorageBackupArgs', 'StorageBackup']

@pulumi.input_type
class StorageBackupArgs:
    def __init__(__self__, *,
                 source_storage: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a StorageBackup resource.
        :param pulumi.Input[_builtins.str] source_storage: The UUID of the storage to back up.
        :param pulumi.Input[_builtins.str] title: Title of the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the storage.
        """
        pulumi.set(__self__, "source_storage", source_storage)
        pulumi.set(__self__, "title", title)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @_builtins.property
    @pulumi.getter(name="sourceStorage")
    def source_storage(self) -> pulumi.Input[_builtins.str]:
        """
        The UUID of the storage to back up.
        """
        return pulumi.get(self, "source_storage")

    @source_storage.setter
    def source_storage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_storage", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        Title of the backup.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the storage.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class _StorageBackupState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 source_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 system_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageBackup resources.
        :param pulumi.Input[_builtins.str] created_at: Timestamp of the backup creation.
        :param pulumi.Input[_builtins.bool] encrypt: Sets if the storage is encrypted at rest.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the storage.
        :param pulumi.Input[_builtins.int] size: The size of the storage in gigabytes.
        :param pulumi.Input[_builtins.str] source_storage: The UUID of the storage to back up.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_labels: System defined key-value pairs to classify the storage. The keys of system defined labels are prefixed with underscore and can not be modified by the user.
        :param pulumi.Input[_builtins.str] tier: The tier of the storage.
        :param pulumi.Input[_builtins.str] title: Title of the backup.
        :param pulumi.Input[_builtins.str] type: The type of the storage.
        :param pulumi.Input[_builtins.str] zone: The zone the storage is in, e.g. `de-fra1`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if encrypt is not None:
            pulumi.set(__self__, "encrypt", encrypt)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if source_storage is not None:
            pulumi.set(__self__, "source_storage", source_storage)
        if system_labels is not None:
            pulumi.set(__self__, "system_labels", system_labels)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of the backup creation.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def encrypt(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sets if the storage is encrypted at rest.
        """
        return pulumi.get(self, "encrypt")

    @encrypt.setter
    def encrypt(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypt", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the storage.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the storage in gigabytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="sourceStorage")
    def source_storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the storage to back up.
        """
        return pulumi.get(self, "source_storage")

    @source_storage.setter
    def source_storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_storage", value)

    @_builtins.property
    @pulumi.getter(name="systemLabels")
    def system_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System defined key-value pairs to classify the storage. The keys of system defined labels are prefixed with underscore and can not be modified by the user.
        """
        return pulumi.get(self, "system_labels")

    @system_labels.setter
    def system_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_labels", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tier of the storage.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Title of the backup.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone the storage is in, e.g. `de-fra1`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/storageBackup:StorageBackup")
class StorageBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an on-demand storage backup.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        backup1 = upcloud.StorageBackup("backup_1",
            title="backup",
            source_storage="01185ec5-1b0b-4cbc-a968-eb920ac7572d")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the storage.
        :param pulumi.Input[_builtins.str] source_storage: The UUID of the storage to back up.
        :param pulumi.Input[_builtins.str] title: Title of the backup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an on-demand storage backup.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        backup1 = upcloud.StorageBackup("backup_1",
            title="backup",
            source_storage="01185ec5-1b0b-4cbc-a968-eb920ac7572d")
        ```

        :param str resource_name: The name of the resource.
        :param StorageBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_storage: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageBackupArgs.__new__(StorageBackupArgs)

            __props__.__dict__["labels"] = labels
            if source_storage is None and not opts.urn:
                raise TypeError("Missing required property 'source_storage'")
            __props__.__dict__["source_storage"] = source_storage
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["created_at"] = None
            __props__.__dict__["encrypt"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["system_labels"] = None
            __props__.__dict__["tier"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["zone"] = None
        super(StorageBackup, __self__).__init__(
            'upcloud:index/storageBackup:StorageBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            source_storage: Optional[pulumi.Input[_builtins.str]] = None,
            system_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'StorageBackup':
        """
        Get an existing StorageBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Timestamp of the backup creation.
        :param pulumi.Input[_builtins.bool] encrypt: Sets if the storage is encrypted at rest.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the storage.
        :param pulumi.Input[_builtins.int] size: The size of the storage in gigabytes.
        :param pulumi.Input[_builtins.str] source_storage: The UUID of the storage to back up.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_labels: System defined key-value pairs to classify the storage. The keys of system defined labels are prefixed with underscore and can not be modified by the user.
        :param pulumi.Input[_builtins.str] tier: The tier of the storage.
        :param pulumi.Input[_builtins.str] title: Title of the backup.
        :param pulumi.Input[_builtins.str] type: The type of the storage.
        :param pulumi.Input[_builtins.str] zone: The zone the storage is in, e.g. `de-fra1`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageBackupState.__new__(_StorageBackupState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["encrypt"] = encrypt
        __props__.__dict__["labels"] = labels
        __props__.__dict__["size"] = size
        __props__.__dict__["source_storage"] = source_storage
        __props__.__dict__["system_labels"] = system_labels
        __props__.__dict__["tier"] = tier
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return StorageBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of the backup creation.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def encrypt(self) -> pulumi.Output[_builtins.bool]:
        """
        Sets if the storage is encrypted at rest.
        """
        return pulumi.get(self, "encrypt")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User defined key-value pairs to classify the storage.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the storage in gigabytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="sourceStorage")
    def source_storage(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the storage to back up.
        """
        return pulumi.get(self, "source_storage")

    @_builtins.property
    @pulumi.getter(name="systemLabels")
    def system_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System defined key-value pairs to classify the storage. The keys of system defined labels are prefixed with underscore and can not be modified by the user.
        """
        return pulumi.get(self, "system_labels")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[_builtins.str]:
        """
        The tier of the storage.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        Title of the backup.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the storage.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The zone the storage is in, e.g. `de-fra1`.
        """
        return pulumi.get(self, "zone")

