# Generated by Django 5.1 on 2024-08-15 11:33

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import umap.models


class Migration(migrations.Migration):
    dependencies = [("umap", "0021_remove_map_description")]

    operations = [
        migrations.CreateModel(
            name="Team",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=200, unique=True, verbose_name="name"),
                ),
                (
                    "description",
                    models.TextField(blank=True, null=True, verbose_name="description"),
                ),
                (
                    "users",
                    models.ManyToManyField(
                        related_name="teams", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="map",
            name="team",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="umap.team",
                verbose_name="team",
            ),
        ),
        migrations.AlterField(
            model_name="datalayer",
            name="edit_status",
            field=models.SmallIntegerField(
                choices=[
                    (0, "Inherit"),
                    (1, "Everyone"),
                    (2, "Editors and team only"),
                    (3, "Owner only"),
                ],
                default=0,
                verbose_name="edit status",
            ),
        ),
        migrations.AlterField(
            model_name="map",
            name="edit_status",
            field=models.SmallIntegerField(
                choices=[
                    (1, "Everyone"),
                    (2, "Editors and team only"),
                    (3, "Owner only"),
                ],
                default=umap.models.get_default_edit_status,
                verbose_name="edit status",
            ),
        ),
        migrations.AlterField(
            model_name="map",
            name="share_status",
            field=models.SmallIntegerField(
                choices=[
                    (1, "Everyone (public)"),
                    (2, "Anyone with link"),
                    (3, "Editors and team only"),
                    (9, "Blocked"),
                ],
                default=umap.models.get_default_share_status,
                verbose_name="share status",
            ),
        ),
    ]
