# Copyright (c) 2023 - 2025, AG2ai, Inc., AG2ai open-source projects maintainers and core contributors
#
# SPDX-License-Identifier: Apache-2.0

# this file is autogenerated, please do not edit it directly
# instead, edit the corresponding setup.jinja file and run the ./scripts/build-setup-files.py script

import os

import setuptools

here = os.path.abspath(os.path.dirname(__file__))

with open("README.md", encoding="UTF-8") as fh:
    long_description = fh.read()

# Get the code version
version = {}
with open(os.path.join(here, "autogen/version.py")) as fp:
    exec(fp.read(), version)
__version__ = version["__version__"]

setuptools.setup(
    name="autogen",
    version=__version__,
    description="Alias package for ag2",
    long_description=long_description,
    long_description_content_type="text/markdown",
    install_requires=["ag2==" + __version__],
    extras_require={
        "flaml": ["ag2[flaml]==" + __version__],
        "openai": ["ag2[openai]==" + __version__],
        "openai-realtime": ["ag2[openai-realtime]==" + __version__],
        "jupyter-executor": ["ag2[jupyter-executor]==" + __version__],
        "retrievechat": ["ag2[retrievechat]==" + __version__],
        "retrievechat-pgvector": ["ag2[retrievechat-pgvector]==" + __version__],
        "retrievechat-mongodb": ["ag2[retrievechat-mongodb]==" + __version__],
        "retrievechat-qdrant": ["ag2[retrievechat-qdrant]==" + __version__],
        "retrievechat-couchbase": ["ag2[retrievechat-couchbase]==" + __version__],
        "graph-rag-falkor-db": ["ag2[graph-rag-falkor-db]==" + __version__],
        "rag": ["ag2[rag]==" + __version__],
        "crawl4ai": ["ag2[crawl4ai]==" + __version__],
        "browser-use": ["ag2[browser-use]==" + __version__],
        "google-client": ["ag2[google-client]==" + __version__],
        "google-api": ["ag2[google-api]==" + __version__],
        "google-search": ["ag2[google-search]==" + __version__],
        "wikipedia": ["ag2[wikipedia]==" + __version__],
        "neo4j": ["ag2[neo4j]==" + __version__],
        "twilio": ["ag2[twilio]==" + __version__],
        "mcp": ["ag2[mcp]==" + __version__],
        "mcp-proxy-gen": ["ag2[mcp-proxy-gen]==" + __version__],
        "interop-crewai": ["ag2[interop-crewai]==" + __version__],
        "interop-langchain": ["ag2[interop-langchain]==" + __version__],
        "interop-pydantic-ai": ["ag2[interop-pydantic-ai]==" + __version__],
        "interop": ["ag2[interop]==" + __version__],
        "autobuild": ["ag2[autobuild]==" + __version__],
        "blendsearch": ["ag2[blendsearch]==" + __version__],
        "mathchat": ["ag2[mathchat]==" + __version__],
        "captainagent": ["ag2[captainagent]==" + __version__],
        "teachable": ["ag2[teachable]==" + __version__],
        "lmm": ["ag2[lmm]==" + __version__],
        "graph": ["ag2[graph]==" + __version__],
        "gemini": ["ag2[gemini]==" + __version__],
        "gemini-realtime": ["ag2[gemini-realtime]==" + __version__],
        "together": ["ag2[together]==" + __version__],
        "websurfer": ["ag2[websurfer]==" + __version__],
        "redis": ["ag2[redis]==" + __version__],
        "cosmosdb": ["ag2[cosmosdb]==" + __version__],
        "websockets": ["ag2[websockets]==" + __version__],
        "long-context": ["ag2[long-context]==" + __version__],
        "anthropic": ["ag2[anthropic]==" + __version__],
        "cerebras": ["ag2[cerebras]==" + __version__],
        "mistral": ["ag2[mistral]==" + __version__],
        "groq": ["ag2[groq]==" + __version__],
        "cohere": ["ag2[cohere]==" + __version__],
        "ollama": ["ag2[ollama]==" + __version__],
        "bedrock": ["ag2[bedrock]==" + __version__],
        "deepseek": ["ag2[deepseek]==" + __version__],
        "commsagent-discord": ["ag2[commsagent-discord]==" + __version__],
        "commsagent-slack": ["ag2[commsagent-slack]==" + __version__],
        "commsagent-telegram": ["ag2[commsagent-telegram]==" + __version__],
        "duckduckgo": ["ag2[duckduckgo]==" + __version__],
        "tavily": ["ag2[tavily]==" + __version__],
        "test": ["ag2[test]==" + __version__],
        "docs": ["ag2[docs]==" + __version__],
        "types": ["ag2[types]==" + __version__],
        "lint": ["ag2[lint]==" + __version__],
        "dev": ["ag2[dev]==" + __version__],

    },
    url="https://github.com/ag2ai/ag2",
    author="Chi Wang & Qingyun Wu",
    author_email="support@ag2.ai",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    license="Apache Software License 2.0",
    python_requires=">=3.10,<3.14",
)
