# Apgard SDK

Apgard is a Python SDK designed to help AI companion companies build **safe, compliant, and caring chat experiences**. It tracks user interactions across companion conversations and provides real-time guidance to keep conversations on track.

## Key Capabilities

- **Content Monitoring and Intervention** – Detects at-risk threads such as self-harm, suicidal ideation, or sexually explicit material, and provides guidance on proper response.

- **Break Tracker** – Tracks ongoing chat sessions and notifies when to take breaks. By default, breaks are triggered every three hours.

Apgard helps teams continue to **innovate safely**, ensuring that AI companions lead with care while meeting regulatory requirements such as California’s SB 243.

# API Key

Request access via this Google form:: https://forms.gle/q6CekCHiDaEdL1CD8 

---

## Installation
```
pip install apgard
```

## Initialize client
By default, ApgardClient is synchronous. The SDK also has an asynchronous client. Reach out for more details.
```
from apgard import ApgardClient

client = ApgardClient(api_key="your-api-key")
```

## Get apgard user_id and start conversation
```
apgard_user_id = apgard_client.get_or_create_user_id(external_user_id='external_user_123') # Optional: pass your external user ID for mapping
conversation_id = apgard_client.moderation.start_conversation(apgard_user_id)
```

# Content Monitoring and Interventions
Call moderate_message() with user messages to detect high-risk content and guide the conversation:

```
result = client.moderation.moderate_message(
    user_id="user_123", # apgard user ID
    conversation_id="conversation_123", # apgard conversation ID
    content="I feel hopeless...", # message to analyze
    role="user"  # 'user' or 'assistant'
)

```
## Response Schema
The method returns a ConversationIntervention object:

```
class ConversationIntervention:
    should_intervene: bool        # True if action is recommended
    severity: str                 # "low", "medium", "high", "critical"
    action: str                   # "allow", "guide_mental_reflection", "provide_crisis_hotline", "block"
    risk_type: List[str]          # e.g., ["self_harm", "sexual_content"]
    suggested_message: Optional[str] = None  # Guidance text for AI response
```
Example Usage
```
if result.should_intervene:
    # Use suggested_message to respond safely
    ai.send_message(result.suggested_message)
```

# Break Tracker
Call record_activity() whenever the user interacts with your chatbot:
```
break_status = client.breaks.activity(user_id="user_123") # apgard user ID

if break_status.break_due:
    # Display break reminder
    print(break_status.message)
else:
    # Continue chatbot interaction
    print("User can continue chatting")
```
## Response Schema
```
class BreakStatus:
    break_due: bool
    message: Optional[str] = None
````