# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-10-17 15:21
from __future__ import unicode_literals

import colorfield.fields
import django.db.models.deletion
from django.db import models, migrations


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
    ]

    operations = [
        migrations.CreateModel(
            name='FUPContainerPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_fup_fupcontainerpluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('name', models.SlugField(verbose_name='name')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FUPItemAnimation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='name')),
                ('slug', models.SlugField(max_length=25, unique=True, verbose_name='slug')),
            ],
            options={
                'verbose_name': 'Animation',
                'verbose_name_plural': 'Animations',
            },
        ),
        migrations.CreateModel(
            name='FUPItemAnimationFrame',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('x', models.SmallIntegerField(verbose_name='x')),
                ('y', models.SmallIntegerField(verbose_name='y')),
                ('z', models.SmallIntegerField(verbose_name='z')),
                ('animation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='frames', related_query_name='frame', to='cmsplugin_fup.FUPItemAnimation')),
            ],
            options={
                'verbose_name': 'Animation frame',
                'verbose_name_plural': 'Animation frames',
            },
        ),
        migrations.CreateModel(
            name='FUPItemPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_fup_fupitempluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('background_color', colorfield.fields.ColorField(max_length=18, null=True, verbose_name='background color')),
                ('width', models.SmallIntegerField(blank=True, verbose_name='width')),
                ('width_unit', models.CharField(choices=[('vw', 'vw'), ('px', 'pixel'), ('rem', 'root em'), ('%', '%')], max_length=5, verbose_name='unit')),
                ('height', models.SmallIntegerField(blank=True, verbose_name='height')),
                ('height_unit', models.CharField(choices=[('vh', 'vh'), ('px', 'pixel'), ('rem', 'root em'), ('%', '%')], max_length=5, verbose_name='unit')),
                ('animation_duration', models.DecimalField(decimal_places=1, default=0.7, max_digits=3, verbose_name='duration (s)')),
                ('animation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cmsplugin_fup.FUPItemAnimation')),
            ],
            options={
                'verbose_name': 'FUP item',
                'verbose_name_plural': 'FUP items',
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='FUPItemPosition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('x', models.DecimalField(decimal_places=3, max_digits=7, verbose_name='x')),
                ('x_unit', models.CharField(choices=[('vw', 'vw'), ('px', 'pixel'), ('rem', 'root em'), ('%', '%')], max_length=5, verbose_name='unit')),
                ('y', models.DecimalField(decimal_places=3, max_digits=7, verbose_name='y')),
                ('y_unit', models.CharField(choices=[('vh', 'vh'), ('px', 'pixel'), ('rem', 'root em'), ('%', '%')], max_length=5, verbose_name='unit')),
                ('fup_item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cmsplugin_fup.FUPItemPluginModel')),
            ],
            options={
                'verbose_name': 'FUP item position',
                'verbose_name_plural': 'FUP item positions',
            },
        ),
        migrations.CreateModel(
            name='FUPPluginModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_fup_fuppluginmodel', serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=255, verbose_name='name')),
                ('fup_container', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to='cmsplugin_fup.FUPContainerPluginModel')),
            ],
            options={
                'verbose_name': 'FUP',
                'verbose_name_plural': 'FUPs',
            },
            bases=('cms.cmsplugin',),
        ),
    ]
