from contextvars import ContextVar
from re import Pattern

from everysk.core.object import BaseDict

class SettingsManager:
    settings: ContextVar
    token: str

class Settings:
    CUSTOM_INDEX_BASE_PRICE_MAX_VAL: float
    CUSTOM_INDEX_BASE_PRICE_MIN_VAL: float
    CUSTOM_INDEX_DATA_MAX_SIZE: int
    CUSTOM_INDEX_DATA_TYPE_PRICE: str
    CUSTOM_INDEX_DATA_TYPE_RETURN: str
    CUSTOM_INDEX_DATA_TYPE_RETURN_100: str
    CUSTOM_INDEX_MIN_DATA_BLOB: int
    CUSTOM_INDEX_PERIODICITY_DAILY: str
    CUSTOM_INDEX_PERIODICITY_MONTHLY: str
    CUSTOM_INDEX_SYMBOL_MAX_SIZE: int
    CUSTOM_INDEX_SYMBOL_MIN_SIZE: int
    CUSTOM_INDEX_SYMBOL_PREFIX: str
    CUSTOM_INDEX_SYMBOL_REGEX: Pattern
    DATASTORE_ID_MAX_SIZE: int
    DATASTORE_ID_PREFIX: str
    DATASTORE_ID_REGEX: Pattern
    DATASTORE_LEVEL_MAX_LENGTH: int
    DEBUG: bool
    DEFAULT_QUERY_LIMIT: int
    DEFAULT_QUERY_OFFSET: int
    DEFAULT_QUERY_PAGE_SIZE: int
    ENGINES_CACHE_EXECUTION_EXPIRATION_TIME: int
    ENGINES_EXPRESSION_DEFAULT_DATA_TYPES: tuple
    ENGINES_MARKET_DATA_TICKER_TYPES: list
    ENTITY_DEFAULT_VERSION: str
    ENTITY_DESCRIPTION_MAX_LEN: int
    ENTITY_DESCRIPTION_MIN_LEN: int
    ENTITY_ID_LENGTH: int
    ENTITY_LINK_UID_MAX_LENGTH: int
    ENTITY_LINK_UID_MIN_LENGTH: int
    ENTITY_MAX_TAG_LENGTH: int
    ENTITY_MAX_TAG_SIZE: int
    ENTITY_MIN_TAG_LENGTH: int
    ENTITY_MIN_TAG_SIZE: int
    ENTITY_NAME_MAX_LENGTH: int
    ENTITY_NAME_MIN_LENGTH: int
    ENTITY_WORKSPACE_MAX_LENGTH: int
    ENTITY_WORKSPACE_MIN_LENGTH: int
    ENTITY_WORKSPACE_REGEX: Pattern
    EVERYSK_API_SID: str
    EVERYSK_API_TOKEN: str
    EVERYSK_API_URL: str
    EVERYSK_API_URL_DOMAIN: str
    EVERYSK_API_URL_SCHEME: str
    EVERYSK_API_VERIFY_SSL_CERTS: bool
    EVERYSK_API_VERSION: str
    EVERYSK_APP_URL: str
    EVERYSK_APP_URL_DOMAIN: str
    EVERYSK_APP_URL_SCHEME: str
    EVERYSK_GOOGLE_CLOUD_LOCATION: str
    EVERYSK_GOOGLE_CLOUD_PROJECT: str
    EVERYSK_HTTP_LOG_RESPONSE: bool
    EVERYSK_SDK_ENGINES_MODULES_PATH: dict | BaseDict
    EVERYSK_SDK_ENTITIES_MODULES_PATH: dict | BaseDict
    EVERYSK_SDK_HTTP_DEFAULT_TIMEOUT: int
    EVERYSK_SDK_MODULES_PATH: dict | BaseDict
    EVERYSK_SDK_ROUTE: str
    EVERYSK_SDK_URL: str
    EVERYSK_SDK_VERSION: str
    EVERYSK_SERVER_CODES_LOG: tuple
    EVERYSK_SERVER_DEBUG: bool
    EVERYSK_SERVER_GZIP_COMPRESS_LEVEL: int
    EVERYSK_SERVER_GZIP_MINIMUM_SIZE: int
    EVERYSK_SERVER_REDIRECT_URL: str
    EVERYSK_SERVER_REST_KEY_NAME: str
    EVERYSK_SERVER_REST_KEY_VALUE: str
    EVERYSK_SIGNING_KEY: str
    FILE_CONTENT_TYPES: list
    FILE_DATA_MAX_SIZE_IN_BASE64: int
    FILE_DATA_MAX_SIZE_IN_RAW: int
    FILE_HASH_LENGTH: int
    FILE_ID_MAX_SIZE: int
    FILE_ID_PREFIX: str
    FILE_ID_REGEX: Pattern
    FILE_URL_LENGTH: int
    FILE_URL_PATH: str
    FX_RATE_MAX_VALUE: float
    FX_RATE_MIN_VALUE: float
    HTTP_DEFAULT_HEADERS: dict | BaseDict
    HTTP_DEFAULT_RETRY_END_SECONDS: int
    HTTP_DEFAULT_RETRY_LIMIT: int
    HTTP_DEFAULT_RETRY_START_SECONDS: int
    HTTP_DEFAULT_SSL_VERIFY: bool
    HTTP_DEFAULT_TIMEOUT: int
    HTTP_REQUESTS_VERIFY: bool
    HTTP_SUCCESS_STATUS_CODES: list
    HTTP_USE_RANDOM_USER_AGENT: bool
    LABEL_MAX_LENGTH: int
    LOGGING_APP_SERVER: str
    LOGGING_GOOGLE_CLOUD_TRACE_ID: str
    LOGGING_JSON: bool
    MULTIPLIER_MAX_VALUE: float
    MULTIPLIER_MIN_VALUE: float
    PAYLOAD_SECURITY_MARGING: float
    PORTFOLIO_ID_MAX_SIZE: int
    PORTFOLIO_ID_PREFIX: str
    PORTFOLIO_ID_REGEX: Pattern
    PORTFOLIO_LEVEL_MAX_LENGTH: int
    PORTFOLIO_MAX_SIZE: int
    PORTFOLIO_PROPERTIES_ORDER: list
    PORTFOLIO_SECURITY_ERROR_MESSAGE_MAX_LEN: int
    PORTFOLIO_SECURITY_ERROR_TYPE_MAX_LEN: int
    PORTFOLIO_SECURITY_TYPE_MAX_LEN: int
    PRICE_MAX_VALUE: float
    PRICE_MIN_VALUE: float
    PRIVATE_SECURITY_DATA_MAX_SIZE: int
    PRIVATE_SECURITY_SYMBOL_MAX_SIZE: int
    PRIVATE_SECURITY_SYMBOL_MIN_SIZE: int
    PRIVATE_SECURITY_SYMBOL_PREFIX: str
    PRIVATE_SECURITY_SYMBOL_REGEX: Pattern
    PROFILE: str
    QUANTITY_MAX_VALUE: float
    QUANTITY_MIN_VALUE: float
    QUERY_OPERATORS: set
    REDIS_HOST: str
    REDIS_PORT: int
    REPORT_AUTHORIZATION_PRIVATE: str
    REPORT_AUTHORIZATION_PUBLIC: str
    REPORT_AUTHORIZATION_REGEX: Pattern
    REPORT_ID_MAX_SIZE: int
    REPORT_ID_PREFIX: str
    REPORT_ID_REGEX: Pattern
    REPORT_LEVEL_MAX_LENGTH: int
    REPORT_URL_PATH: str
    SECURITY_ID_LENGTH: int
    SECURITY_ID_PREFIX: str
    SECURITY_STATUS_DELISTED: str
    SECURITY_STATUS_ERROR: str
    SECURITY_STATUS_OK: str
    SERIALIZE_CONVERT_METHOD_NAME: str
    SERIALIZE_DATETIME_KEY: str
    SERIALIZE_DATE_KEY: str
    SERIALIZE_UNDEFINED_KEY: str
    SERIALIZE_USE_UNDEFINED: bool
    SIMPLE_UNIQUE_ID_LENGTH: int
    SLACK_URL: str
    SYMBOL_ID_MAX_LEN: int
    SYMBOL_MAX_LENGTH: int
    def __init__(self, singleton: bool = True, **kwargs) -> None: ...
    def __enter__(self) -> 'Settings': ...

settings: Settings
