# QuizGenerator Scripts

Utility scripts for maintaining and releasing QuizGenerator.

## vendor_lms_interface.py

Vendors LMSInterface code into QuizGenerator for PyPI release.

### Usage

**Dry run (recommended first):**
```bash
python scripts/vendor_lms_interface.py --dry-run
```

**Apply changes:**
```bash
python scripts/vendor_lms_interface.py
```

**Custom LMSInterface location:**
```bash
python scripts/vendor_lms_interface.py --lms-path /path/to/LMSInterface
```

### What it does

1. Copies `lms_interface/*.py` files to `QuizGenerator/canvas/`
2. Adds version tracking metadata to `QuizGenerator/canvas/__init__.py`
3. Updates imports in `generate_quiz.py`
4. Removes LMSInterface external dependency from `pyproject.toml`
5. Reminds you to add Canvas dependencies manually

### After running

1. Review changes: `git diff`
2. Manually add these dependencies to `pyproject.toml` if needed:
   ```toml
   dependencies = [
       "canvasapi==3.2.0",
       "requests==2.32.2",
       # ... other deps
   ]
   ```
3. Test: `uv sync && python generate_quiz.py --help`
4. Commit: `git add QuizGenerator/canvas/ generate_quiz.py pyproject.toml`

### When to use

- Before releasing to PyPI (first time)
- When updating vendored LMSInterface code to a newer version
- After making changes to LMSInterface that need to be synced

### Version tracking

The script automatically tracks:
- LMSInterface version number
- Date of vendoring
- Source repository

This information is stored in `QuizGenerator/canvas/__init__.py` for reference.