"""Stub file for reflex/components/datadisplay/shiki_code_block.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from dataclasses import dataclass
from typing import Any, Literal

from reflex.components.component import Component, ComponentNamespace
from reflex.components.core.breakpoints import Breakpoints
from reflex.components.markdown.markdown import MarkdownComponentMap
from reflex.components.props import NoExtrasAllowedProps
from reflex.event import EventType, PointerEventInfo
from reflex.style import Style
from reflex.vars.base import Var
from reflex.vars.function import FunctionStringVar

def copy_script() -> Any: ...

SHIKIJS_TRANSFORMER_FNS = {
    "transformerNotationDiff",
    "transformerNotationHighlight",
    "transformerNotationWordHighlight",
    "transformerNotationFocus",
    "transformerNotationErrorLevel",
    "transformerRenderWhitespace",
    "transformerMetaHighlight",
    "transformerMetaWordHighlight",
    "transformerCompactLineOptions",
    "transformerRemoveNotationEscape",
}
LINE_NUMBER_STYLING = {
    "code": {
        "counter-reset": "step",
        "counter-increment": "step 0",
        "display": "grid",
        "line-height": "1.7",
        "font-size": "0.875em",
    },
    "code .line::before": {
        "content": "counter(step)",
        "counter-increment": "step",
        "width": "1rem",
        "margin-right": "1.5rem",
        "display": "inline-block",
        "text-align": "right",
        "color": "rgba(115,138,148,.4)",
    },
}
BOX_PARENT_STYLING = {
    "pre": {
        "margin": "0",
        "padding": "24px",
        "background": "transparent",
        "overflow-x": "auto",
        "border-radius": "6px",
    }
}
THEME_MAPPING = {
    "light": "one-light",
    "dark": "one-dark-pro",
    "a11y-dark": "github-dark",
}
LANGUAGE_MAPPING = {"bash": "shellscript"}
LiteralCodeLanguage = Literal[
    "abap",
    "actionscript-3",
    "ada",
    "angular-html",
    "angular-ts",
    "apache",
    "apex",
    "apl",
    "applescript",
    "ara",
    "asciidoc",
    "asm",
    "astro",
    "awk",
    "ballerina",
    "bat",
    "beancount",
    "berry",
    "bibtex",
    "bicep",
    "blade",
    "c",
    "cadence",
    "clarity",
    "clojure",
    "cmake",
    "cobol",
    "codeowners",
    "codeql",
    "coffee",
    "common-lisp",
    "coq",
    "cpp",
    "crystal",
    "csharp",
    "css",
    "csv",
    "cue",
    "cypher",
    "d",
    "dart",
    "dax",
    "desktop",
    "diff",
    "docker",
    "dotenv",
    "dream-maker",
    "edge",
    "elixir",
    "elm",
    "emacs-lisp",
    "erb",
    "erlang",
    "fennel",
    "fish",
    "fluent",
    "fortran-fixed-form",
    "fortran-free-form",
    "fsharp",
    "gdresource",
    "gdscript",
    "gdshader",
    "genie",
    "gherkin",
    "git-commit",
    "git-rebase",
    "gleam",
    "glimmer-js",
    "glimmer-ts",
    "glsl",
    "gnuplot",
    "go",
    "graphql",
    "groovy",
    "hack",
    "haml",
    "handlebars",
    "haskell",
    "haxe",
    "hcl",
    "hjson",
    "hlsl",
    "html",
    "html-derivative",
    "http",
    "hxml",
    "hy",
    "imba",
    "ini",
    "java",
    "javascript",
    "jinja",
    "jison",
    "json",
    "json5",
    "jsonc",
    "jsonl",
    "jsonnet",
    "jssm",
    "jsx",
    "julia",
    "kotlin",
    "kusto",
    "latex",
    "lean",
    "less",
    "liquid",
    "log",
    "logo",
    "lua",
    "luau",
    "make",
    "markdown",
    "marko",
    "matlab",
    "mdc",
    "mdx",
    "mermaid",
    "mojo",
    "move",
    "narrat",
    "nextflow",
    "nginx",
    "nim",
    "nix",
    "nushell",
    "objective-c",
    "objective-cpp",
    "ocaml",
    "pascal",
    "perl",
    "php",
    "plain",
    "plsql",
    "po",
    "postcss",
    "powerquery",
    "powershell",
    "prisma",
    "prolog",
    "proto",
    "pug",
    "puppet",
    "purescript",
    "python",
    "qml",
    "qmldir",
    "qss",
    "r",
    "racket",
    "raku",
    "razor",
    "reg",
    "regexp",
    "rel",
    "riscv",
    "rst",
    "ruby",
    "rust",
    "sas",
    "sass",
    "scala",
    "scheme",
    "scss",
    "shaderlab",
    "shellscript",
    "shellsession",
    "smalltalk",
    "solidity",
    "soy",
    "sparql",
    "splunk",
    "sql",
    "ssh-config",
    "stata",
    "stylus",
    "svelte",
    "swift",
    "system-verilog",
    "systemd",
    "tasl",
    "tcl",
    "templ",
    "terraform",
    "tex",
    "toml",
    "ts-tags",
    "tsv",
    "tsx",
    "turtle",
    "twig",
    "typescript",
    "typespec",
    "typst",
    "v",
    "vala",
    "vb",
    "verilog",
    "vhdl",
    "viml",
    "vue",
    "vue-html",
    "vyper",
    "wasm",
    "wenyan",
    "wgsl",
    "wikitext",
    "wolfram",
    "xml",
    "xsl",
    "yaml",
    "zenscript",
    "zig",
]
LiteralCodeTheme = Literal[
    "andromeeda",
    "aurora-x",
    "ayu-dark",
    "catppuccin-frappe",
    "catppuccin-latte",
    "catppuccin-macchiato",
    "catppuccin-mocha",
    "dark-plus",
    "dracula",
    "dracula-soft",
    "everforest-dark",
    "everforest-light",
    "github-dark",
    "github-dark-default",
    "github-dark-dimmed",
    "github-dark-high-contrast",
    "github-light",
    "github-light-default",
    "github-light-high-contrast",
    "houston",
    "laserwave",
    "light-plus",
    "material-theme",
    "material-theme-darker",
    "material-theme-lighter",
    "material-theme-ocean",
    "material-theme-palenight",
    "min-dark",
    "min-light",
    "monokai",
    "night-owl",
    "nord",
    "one-dark-pro",
    "one-light",
    "plastic",
    "poimandres",
    "red",
    "rose-pine",
    "rose-pine-dawn",
    "rose-pine-moon",
    "slack-dark",
    "slack-ochin",
    "snazzy-light",
    "solarized-dark",
    "solarized-light",
    "synthwave-84",
    "tokyo-night",
    "vesper",
    "vitesse-black",
    "vitesse-dark",
    "vitesse-light",
]

class Position(NoExtrasAllowedProps):
    line: int
    character: int

class ShikiDecorations(NoExtrasAllowedProps):
    start: int | Position
    end: int | Position
    tag_name: str
    properties: dict[str, Any]
    always_wrap: bool

@dataclass(kw_only=True)
class ShikiBaseTransformers:
    library: str
    fns: list[FunctionStringVar]
    style: Style | None

@dataclass(kw_only=True)
class ShikiJsTransformer(ShikiBaseTransformers):
    library: str
    fns: list[FunctionStringVar]
    style: Style | None

class ShikiCodeBlock(Component, MarkdownComponentMap):
    @classmethod
    def create(
        cls,
        *children,
        language: Literal[
            "abap",
            "actionscript-3",
            "ada",
            "angular-html",
            "angular-ts",
            "apache",
            "apex",
            "apl",
            "applescript",
            "ara",
            "asciidoc",
            "asm",
            "astro",
            "awk",
            "ballerina",
            "bat",
            "beancount",
            "berry",
            "bibtex",
            "bicep",
            "blade",
            "c",
            "cadence",
            "clarity",
            "clojure",
            "cmake",
            "cobol",
            "codeowners",
            "codeql",
            "coffee",
            "common-lisp",
            "coq",
            "cpp",
            "crystal",
            "csharp",
            "css",
            "csv",
            "cue",
            "cypher",
            "d",
            "dart",
            "dax",
            "desktop",
            "diff",
            "docker",
            "dotenv",
            "dream-maker",
            "edge",
            "elixir",
            "elm",
            "emacs-lisp",
            "erb",
            "erlang",
            "fennel",
            "fish",
            "fluent",
            "fortran-fixed-form",
            "fortran-free-form",
            "fsharp",
            "gdresource",
            "gdscript",
            "gdshader",
            "genie",
            "gherkin",
            "git-commit",
            "git-rebase",
            "gleam",
            "glimmer-js",
            "glimmer-ts",
            "glsl",
            "gnuplot",
            "go",
            "graphql",
            "groovy",
            "hack",
            "haml",
            "handlebars",
            "haskell",
            "haxe",
            "hcl",
            "hjson",
            "hlsl",
            "html",
            "html-derivative",
            "http",
            "hxml",
            "hy",
            "imba",
            "ini",
            "java",
            "javascript",
            "jinja",
            "jison",
            "json",
            "json5",
            "jsonc",
            "jsonl",
            "jsonnet",
            "jssm",
            "jsx",
            "julia",
            "kotlin",
            "kusto",
            "latex",
            "lean",
            "less",
            "liquid",
            "log",
            "logo",
            "lua",
            "luau",
            "make",
            "markdown",
            "marko",
            "matlab",
            "mdc",
            "mdx",
            "mermaid",
            "mojo",
            "move",
            "narrat",
            "nextflow",
            "nginx",
            "nim",
            "nix",
            "nushell",
            "objective-c",
            "objective-cpp",
            "ocaml",
            "pascal",
            "perl",
            "php",
            "plain",
            "plsql",
            "po",
            "postcss",
            "powerquery",
            "powershell",
            "prisma",
            "prolog",
            "proto",
            "pug",
            "puppet",
            "purescript",
            "python",
            "qml",
            "qmldir",
            "qss",
            "r",
            "racket",
            "raku",
            "razor",
            "reg",
            "regexp",
            "rel",
            "riscv",
            "rst",
            "ruby",
            "rust",
            "sas",
            "sass",
            "scala",
            "scheme",
            "scss",
            "shaderlab",
            "shellscript",
            "shellsession",
            "smalltalk",
            "solidity",
            "soy",
            "sparql",
            "splunk",
            "sql",
            "ssh-config",
            "stata",
            "stylus",
            "svelte",
            "swift",
            "system-verilog",
            "systemd",
            "tasl",
            "tcl",
            "templ",
            "terraform",
            "tex",
            "toml",
            "ts-tags",
            "tsv",
            "tsx",
            "turtle",
            "twig",
            "typescript",
            "typespec",
            "typst",
            "v",
            "vala",
            "vb",
            "verilog",
            "vhdl",
            "viml",
            "vue",
            "vue-html",
            "vyper",
            "wasm",
            "wenyan",
            "wgsl",
            "wikitext",
            "wolfram",
            "xml",
            "xsl",
            "yaml",
            "zenscript",
            "zig",
        ]
        | Var[
            Literal[
                "abap",
                "actionscript-3",
                "ada",
                "angular-html",
                "angular-ts",
                "apache",
                "apex",
                "apl",
                "applescript",
                "ara",
                "asciidoc",
                "asm",
                "astro",
                "awk",
                "ballerina",
                "bat",
                "beancount",
                "berry",
                "bibtex",
                "bicep",
                "blade",
                "c",
                "cadence",
                "clarity",
                "clojure",
                "cmake",
                "cobol",
                "codeowners",
                "codeql",
                "coffee",
                "common-lisp",
                "coq",
                "cpp",
                "crystal",
                "csharp",
                "css",
                "csv",
                "cue",
                "cypher",
                "d",
                "dart",
                "dax",
                "desktop",
                "diff",
                "docker",
                "dotenv",
                "dream-maker",
                "edge",
                "elixir",
                "elm",
                "emacs-lisp",
                "erb",
                "erlang",
                "fennel",
                "fish",
                "fluent",
                "fortran-fixed-form",
                "fortran-free-form",
                "fsharp",
                "gdresource",
                "gdscript",
                "gdshader",
                "genie",
                "gherkin",
                "git-commit",
                "git-rebase",
                "gleam",
                "glimmer-js",
                "glimmer-ts",
                "glsl",
                "gnuplot",
                "go",
                "graphql",
                "groovy",
                "hack",
                "haml",
                "handlebars",
                "haskell",
                "haxe",
                "hcl",
                "hjson",
                "hlsl",
                "html",
                "html-derivative",
                "http",
                "hxml",
                "hy",
                "imba",
                "ini",
                "java",
                "javascript",
                "jinja",
                "jison",
                "json",
                "json5",
                "jsonc",
                "jsonl",
                "jsonnet",
                "jssm",
                "jsx",
                "julia",
                "kotlin",
                "kusto",
                "latex",
                "lean",
                "less",
                "liquid",
                "log",
                "logo",
                "lua",
                "luau",
                "make",
                "markdown",
                "marko",
                "matlab",
                "mdc",
                "mdx",
                "mermaid",
                "mojo",
                "move",
                "narrat",
                "nextflow",
                "nginx",
                "nim",
                "nix",
                "nushell",
                "objective-c",
                "objective-cpp",
                "ocaml",
                "pascal",
                "perl",
                "php",
                "plain",
                "plsql",
                "po",
                "postcss",
                "powerquery",
                "powershell",
                "prisma",
                "prolog",
                "proto",
                "pug",
                "puppet",
                "purescript",
                "python",
                "qml",
                "qmldir",
                "qss",
                "r",
                "racket",
                "raku",
                "razor",
                "reg",
                "regexp",
                "rel",
                "riscv",
                "rst",
                "ruby",
                "rust",
                "sas",
                "sass",
                "scala",
                "scheme",
                "scss",
                "shaderlab",
                "shellscript",
                "shellsession",
                "smalltalk",
                "solidity",
                "soy",
                "sparql",
                "splunk",
                "sql",
                "ssh-config",
                "stata",
                "stylus",
                "svelte",
                "swift",
                "system-verilog",
                "systemd",
                "tasl",
                "tcl",
                "templ",
                "terraform",
                "tex",
                "toml",
                "ts-tags",
                "tsv",
                "tsx",
                "turtle",
                "twig",
                "typescript",
                "typespec",
                "typst",
                "v",
                "vala",
                "vb",
                "verilog",
                "vhdl",
                "viml",
                "vue",
                "vue-html",
                "vyper",
                "wasm",
                "wenyan",
                "wgsl",
                "wikitext",
                "wolfram",
                "xml",
                "xsl",
                "yaml",
                "zenscript",
                "zig",
            ]
        ]
        | None = None,
        theme: Literal[
            "andromeeda",
            "aurora-x",
            "ayu-dark",
            "catppuccin-frappe",
            "catppuccin-latte",
            "catppuccin-macchiato",
            "catppuccin-mocha",
            "dark-plus",
            "dracula",
            "dracula-soft",
            "everforest-dark",
            "everforest-light",
            "github-dark",
            "github-dark-default",
            "github-dark-dimmed",
            "github-dark-high-contrast",
            "github-light",
            "github-light-default",
            "github-light-high-contrast",
            "houston",
            "laserwave",
            "light-plus",
            "material-theme",
            "material-theme-darker",
            "material-theme-lighter",
            "material-theme-ocean",
            "material-theme-palenight",
            "min-dark",
            "min-light",
            "monokai",
            "night-owl",
            "nord",
            "one-dark-pro",
            "one-light",
            "plastic",
            "poimandres",
            "red",
            "rose-pine",
            "rose-pine-dawn",
            "rose-pine-moon",
            "slack-dark",
            "slack-ochin",
            "snazzy-light",
            "solarized-dark",
            "solarized-light",
            "synthwave-84",
            "tokyo-night",
            "vesper",
            "vitesse-black",
            "vitesse-dark",
            "vitesse-light",
        ]
        | Var[
            Literal[
                "andromeeda",
                "aurora-x",
                "ayu-dark",
                "catppuccin-frappe",
                "catppuccin-latte",
                "catppuccin-macchiato",
                "catppuccin-mocha",
                "dark-plus",
                "dracula",
                "dracula-soft",
                "everforest-dark",
                "everforest-light",
                "github-dark",
                "github-dark-default",
                "github-dark-dimmed",
                "github-dark-high-contrast",
                "github-light",
                "github-light-default",
                "github-light-high-contrast",
                "houston",
                "laserwave",
                "light-plus",
                "material-theme",
                "material-theme-darker",
                "material-theme-lighter",
                "material-theme-ocean",
                "material-theme-palenight",
                "min-dark",
                "min-light",
                "monokai",
                "night-owl",
                "nord",
                "one-dark-pro",
                "one-light",
                "plastic",
                "poimandres",
                "red",
                "rose-pine",
                "rose-pine-dawn",
                "rose-pine-moon",
                "slack-dark",
                "slack-ochin",
                "snazzy-light",
                "solarized-dark",
                "solarized-light",
                "synthwave-84",
                "tokyo-night",
                "vesper",
                "vitesse-black",
                "vitesse-dark",
                "vitesse-light",
            ]
        ]
        | None = None,
        themes: Var[dict[str, str] | list[dict[str, Any]]]
        | dict[str, str]
        | list[dict[str, Any]]
        | None = None,
        code: Var[str] | str | None = None,
        transformers: Var[list[ShikiBaseTransformers | dict[str, Any]]]
        | list[ShikiBaseTransformers | dict[str, Any]]
        | None = None,
        decorations: Var[list[ShikiDecorations]] | list[ShikiDecorations] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ShikiCodeBlock:
        """Create a code block component using [shiki syntax highlighter](https://shiki.matsu.io/).

        Args:
            *children: The children of the component.
            language: The language to use.
            theme: The theme to use ("light" or "dark").
            themes: The set of themes to use for different modes.
            code: The code to display.
            transformers: The transformers to use for the syntax highlighter.
            decorations: The decorations to use for the syntax highlighter.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props to pass to the component.

        Returns:
            The code block component.
        """

    def add_imports(self) -> dict[str, list[str]]: ...
    @classmethod
    def create_transformer(
        cls, library: str, fns: list[str]
    ) -> ShikiBaseTransformers: ...

class ShikiHighLevelCodeBlock(ShikiCodeBlock):
    @classmethod
    def create(
        cls,
        *children,
        use_transformers: Var[bool] | bool | None = None,
        show_line_numbers: Var[bool] | bool | None = None,
        can_copy: bool | None = None,
        copy_button: Component | bool | None = None,
        language: Literal[
            "abap",
            "actionscript-3",
            "ada",
            "angular-html",
            "angular-ts",
            "apache",
            "apex",
            "apl",
            "applescript",
            "ara",
            "asciidoc",
            "asm",
            "astro",
            "awk",
            "ballerina",
            "bat",
            "beancount",
            "berry",
            "bibtex",
            "bicep",
            "blade",
            "c",
            "cadence",
            "clarity",
            "clojure",
            "cmake",
            "cobol",
            "codeowners",
            "codeql",
            "coffee",
            "common-lisp",
            "coq",
            "cpp",
            "crystal",
            "csharp",
            "css",
            "csv",
            "cue",
            "cypher",
            "d",
            "dart",
            "dax",
            "desktop",
            "diff",
            "docker",
            "dotenv",
            "dream-maker",
            "edge",
            "elixir",
            "elm",
            "emacs-lisp",
            "erb",
            "erlang",
            "fennel",
            "fish",
            "fluent",
            "fortran-fixed-form",
            "fortran-free-form",
            "fsharp",
            "gdresource",
            "gdscript",
            "gdshader",
            "genie",
            "gherkin",
            "git-commit",
            "git-rebase",
            "gleam",
            "glimmer-js",
            "glimmer-ts",
            "glsl",
            "gnuplot",
            "go",
            "graphql",
            "groovy",
            "hack",
            "haml",
            "handlebars",
            "haskell",
            "haxe",
            "hcl",
            "hjson",
            "hlsl",
            "html",
            "html-derivative",
            "http",
            "hxml",
            "hy",
            "imba",
            "ini",
            "java",
            "javascript",
            "jinja",
            "jison",
            "json",
            "json5",
            "jsonc",
            "jsonl",
            "jsonnet",
            "jssm",
            "jsx",
            "julia",
            "kotlin",
            "kusto",
            "latex",
            "lean",
            "less",
            "liquid",
            "log",
            "logo",
            "lua",
            "luau",
            "make",
            "markdown",
            "marko",
            "matlab",
            "mdc",
            "mdx",
            "mermaid",
            "mojo",
            "move",
            "narrat",
            "nextflow",
            "nginx",
            "nim",
            "nix",
            "nushell",
            "objective-c",
            "objective-cpp",
            "ocaml",
            "pascal",
            "perl",
            "php",
            "plain",
            "plsql",
            "po",
            "postcss",
            "powerquery",
            "powershell",
            "prisma",
            "prolog",
            "proto",
            "pug",
            "puppet",
            "purescript",
            "python",
            "qml",
            "qmldir",
            "qss",
            "r",
            "racket",
            "raku",
            "razor",
            "reg",
            "regexp",
            "rel",
            "riscv",
            "rst",
            "ruby",
            "rust",
            "sas",
            "sass",
            "scala",
            "scheme",
            "scss",
            "shaderlab",
            "shellscript",
            "shellsession",
            "smalltalk",
            "solidity",
            "soy",
            "sparql",
            "splunk",
            "sql",
            "ssh-config",
            "stata",
            "stylus",
            "svelte",
            "swift",
            "system-verilog",
            "systemd",
            "tasl",
            "tcl",
            "templ",
            "terraform",
            "tex",
            "toml",
            "ts-tags",
            "tsv",
            "tsx",
            "turtle",
            "twig",
            "typescript",
            "typespec",
            "typst",
            "v",
            "vala",
            "vb",
            "verilog",
            "vhdl",
            "viml",
            "vue",
            "vue-html",
            "vyper",
            "wasm",
            "wenyan",
            "wgsl",
            "wikitext",
            "wolfram",
            "xml",
            "xsl",
            "yaml",
            "zenscript",
            "zig",
        ]
        | Var[
            Literal[
                "abap",
                "actionscript-3",
                "ada",
                "angular-html",
                "angular-ts",
                "apache",
                "apex",
                "apl",
                "applescript",
                "ara",
                "asciidoc",
                "asm",
                "astro",
                "awk",
                "ballerina",
                "bat",
                "beancount",
                "berry",
                "bibtex",
                "bicep",
                "blade",
                "c",
                "cadence",
                "clarity",
                "clojure",
                "cmake",
                "cobol",
                "codeowners",
                "codeql",
                "coffee",
                "common-lisp",
                "coq",
                "cpp",
                "crystal",
                "csharp",
                "css",
                "csv",
                "cue",
                "cypher",
                "d",
                "dart",
                "dax",
                "desktop",
                "diff",
                "docker",
                "dotenv",
                "dream-maker",
                "edge",
                "elixir",
                "elm",
                "emacs-lisp",
                "erb",
                "erlang",
                "fennel",
                "fish",
                "fluent",
                "fortran-fixed-form",
                "fortran-free-form",
                "fsharp",
                "gdresource",
                "gdscript",
                "gdshader",
                "genie",
                "gherkin",
                "git-commit",
                "git-rebase",
                "gleam",
                "glimmer-js",
                "glimmer-ts",
                "glsl",
                "gnuplot",
                "go",
                "graphql",
                "groovy",
                "hack",
                "haml",
                "handlebars",
                "haskell",
                "haxe",
                "hcl",
                "hjson",
                "hlsl",
                "html",
                "html-derivative",
                "http",
                "hxml",
                "hy",
                "imba",
                "ini",
                "java",
                "javascript",
                "jinja",
                "jison",
                "json",
                "json5",
                "jsonc",
                "jsonl",
                "jsonnet",
                "jssm",
                "jsx",
                "julia",
                "kotlin",
                "kusto",
                "latex",
                "lean",
                "less",
                "liquid",
                "log",
                "logo",
                "lua",
                "luau",
                "make",
                "markdown",
                "marko",
                "matlab",
                "mdc",
                "mdx",
                "mermaid",
                "mojo",
                "move",
                "narrat",
                "nextflow",
                "nginx",
                "nim",
                "nix",
                "nushell",
                "objective-c",
                "objective-cpp",
                "ocaml",
                "pascal",
                "perl",
                "php",
                "plain",
                "plsql",
                "po",
                "postcss",
                "powerquery",
                "powershell",
                "prisma",
                "prolog",
                "proto",
                "pug",
                "puppet",
                "purescript",
                "python",
                "qml",
                "qmldir",
                "qss",
                "r",
                "racket",
                "raku",
                "razor",
                "reg",
                "regexp",
                "rel",
                "riscv",
                "rst",
                "ruby",
                "rust",
                "sas",
                "sass",
                "scala",
                "scheme",
                "scss",
                "shaderlab",
                "shellscript",
                "shellsession",
                "smalltalk",
                "solidity",
                "soy",
                "sparql",
                "splunk",
                "sql",
                "ssh-config",
                "stata",
                "stylus",
                "svelte",
                "swift",
                "system-verilog",
                "systemd",
                "tasl",
                "tcl",
                "templ",
                "terraform",
                "tex",
                "toml",
                "ts-tags",
                "tsv",
                "tsx",
                "turtle",
                "twig",
                "typescript",
                "typespec",
                "typst",
                "v",
                "vala",
                "vb",
                "verilog",
                "vhdl",
                "viml",
                "vue",
                "vue-html",
                "vyper",
                "wasm",
                "wenyan",
                "wgsl",
                "wikitext",
                "wolfram",
                "xml",
                "xsl",
                "yaml",
                "zenscript",
                "zig",
            ]
        ]
        | None = None,
        theme: Literal[
            "andromeeda",
            "aurora-x",
            "ayu-dark",
            "catppuccin-frappe",
            "catppuccin-latte",
            "catppuccin-macchiato",
            "catppuccin-mocha",
            "dark-plus",
            "dracula",
            "dracula-soft",
            "everforest-dark",
            "everforest-light",
            "github-dark",
            "github-dark-default",
            "github-dark-dimmed",
            "github-dark-high-contrast",
            "github-light",
            "github-light-default",
            "github-light-high-contrast",
            "houston",
            "laserwave",
            "light-plus",
            "material-theme",
            "material-theme-darker",
            "material-theme-lighter",
            "material-theme-ocean",
            "material-theme-palenight",
            "min-dark",
            "min-light",
            "monokai",
            "night-owl",
            "nord",
            "one-dark-pro",
            "one-light",
            "plastic",
            "poimandres",
            "red",
            "rose-pine",
            "rose-pine-dawn",
            "rose-pine-moon",
            "slack-dark",
            "slack-ochin",
            "snazzy-light",
            "solarized-dark",
            "solarized-light",
            "synthwave-84",
            "tokyo-night",
            "vesper",
            "vitesse-black",
            "vitesse-dark",
            "vitesse-light",
        ]
        | Var[
            Literal[
                "andromeeda",
                "aurora-x",
                "ayu-dark",
                "catppuccin-frappe",
                "catppuccin-latte",
                "catppuccin-macchiato",
                "catppuccin-mocha",
                "dark-plus",
                "dracula",
                "dracula-soft",
                "everforest-dark",
                "everforest-light",
                "github-dark",
                "github-dark-default",
                "github-dark-dimmed",
                "github-dark-high-contrast",
                "github-light",
                "github-light-default",
                "github-light-high-contrast",
                "houston",
                "laserwave",
                "light-plus",
                "material-theme",
                "material-theme-darker",
                "material-theme-lighter",
                "material-theme-ocean",
                "material-theme-palenight",
                "min-dark",
                "min-light",
                "monokai",
                "night-owl",
                "nord",
                "one-dark-pro",
                "one-light",
                "plastic",
                "poimandres",
                "red",
                "rose-pine",
                "rose-pine-dawn",
                "rose-pine-moon",
                "slack-dark",
                "slack-ochin",
                "snazzy-light",
                "solarized-dark",
                "solarized-light",
                "synthwave-84",
                "tokyo-night",
                "vesper",
                "vitesse-black",
                "vitesse-dark",
                "vitesse-light",
            ]
        ]
        | None = None,
        themes: Var[dict[str, str] | list[dict[str, Any]]]
        | dict[str, str]
        | list[dict[str, Any]]
        | None = None,
        code: Var[str] | str | None = None,
        transformers: Var[list[ShikiBaseTransformers | dict[str, Any]]]
        | list[ShikiBaseTransformers | dict[str, Any]]
        | None = None,
        decorations: Var[list[ShikiDecorations]] | list[ShikiDecorations] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ShikiHighLevelCodeBlock:
        """Create a code block component using [shiki syntax highlighter](https://shiki.matsu.io/).

        Args:
            *children: The children of the component.
            use_transformers: If this is enabled, the default transformers(shikijs transformer) will be used.
            show_line_numbers: If this is enabled line numbers will be shown next to the code block.
            can_copy: Whether a copy button should appear.
            copy_button: copy_button: A custom copy button to override the default one.
            language: The language to use.
            theme: The theme to use ("light" or "dark").
            themes: The set of themes to use for different modes.
            code: The code to display.
            transformers: The transformers to use for the syntax highlighter.
            decorations: The decorations to use for the syntax highlighter.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props to pass to the component.

        Returns:
            The code block component.
        """

class TransformerNamespace(ComponentNamespace):
    shikijs = ShikiJsTransformer

class CodeblockNamespace(ComponentNamespace):
    root = staticmethod(ShikiCodeBlock.create)
    create_transformer = staticmethod(ShikiCodeBlock.create_transformer)
    transformers = TransformerNamespace()

    @staticmethod
    def __call__(
        *children,
        use_transformers: Var[bool] | bool | None = None,
        show_line_numbers: Var[bool] | bool | None = None,
        can_copy: bool | None = None,
        copy_button: Component | bool | None = None,
        language: Literal[
            "abap",
            "actionscript-3",
            "ada",
            "angular-html",
            "angular-ts",
            "apache",
            "apex",
            "apl",
            "applescript",
            "ara",
            "asciidoc",
            "asm",
            "astro",
            "awk",
            "ballerina",
            "bat",
            "beancount",
            "berry",
            "bibtex",
            "bicep",
            "blade",
            "c",
            "cadence",
            "clarity",
            "clojure",
            "cmake",
            "cobol",
            "codeowners",
            "codeql",
            "coffee",
            "common-lisp",
            "coq",
            "cpp",
            "crystal",
            "csharp",
            "css",
            "csv",
            "cue",
            "cypher",
            "d",
            "dart",
            "dax",
            "desktop",
            "diff",
            "docker",
            "dotenv",
            "dream-maker",
            "edge",
            "elixir",
            "elm",
            "emacs-lisp",
            "erb",
            "erlang",
            "fennel",
            "fish",
            "fluent",
            "fortran-fixed-form",
            "fortran-free-form",
            "fsharp",
            "gdresource",
            "gdscript",
            "gdshader",
            "genie",
            "gherkin",
            "git-commit",
            "git-rebase",
            "gleam",
            "glimmer-js",
            "glimmer-ts",
            "glsl",
            "gnuplot",
            "go",
            "graphql",
            "groovy",
            "hack",
            "haml",
            "handlebars",
            "haskell",
            "haxe",
            "hcl",
            "hjson",
            "hlsl",
            "html",
            "html-derivative",
            "http",
            "hxml",
            "hy",
            "imba",
            "ini",
            "java",
            "javascript",
            "jinja",
            "jison",
            "json",
            "json5",
            "jsonc",
            "jsonl",
            "jsonnet",
            "jssm",
            "jsx",
            "julia",
            "kotlin",
            "kusto",
            "latex",
            "lean",
            "less",
            "liquid",
            "log",
            "logo",
            "lua",
            "luau",
            "make",
            "markdown",
            "marko",
            "matlab",
            "mdc",
            "mdx",
            "mermaid",
            "mojo",
            "move",
            "narrat",
            "nextflow",
            "nginx",
            "nim",
            "nix",
            "nushell",
            "objective-c",
            "objective-cpp",
            "ocaml",
            "pascal",
            "perl",
            "php",
            "plain",
            "plsql",
            "po",
            "postcss",
            "powerquery",
            "powershell",
            "prisma",
            "prolog",
            "proto",
            "pug",
            "puppet",
            "purescript",
            "python",
            "qml",
            "qmldir",
            "qss",
            "r",
            "racket",
            "raku",
            "razor",
            "reg",
            "regexp",
            "rel",
            "riscv",
            "rst",
            "ruby",
            "rust",
            "sas",
            "sass",
            "scala",
            "scheme",
            "scss",
            "shaderlab",
            "shellscript",
            "shellsession",
            "smalltalk",
            "solidity",
            "soy",
            "sparql",
            "splunk",
            "sql",
            "ssh-config",
            "stata",
            "stylus",
            "svelte",
            "swift",
            "system-verilog",
            "systemd",
            "tasl",
            "tcl",
            "templ",
            "terraform",
            "tex",
            "toml",
            "ts-tags",
            "tsv",
            "tsx",
            "turtle",
            "twig",
            "typescript",
            "typespec",
            "typst",
            "v",
            "vala",
            "vb",
            "verilog",
            "vhdl",
            "viml",
            "vue",
            "vue-html",
            "vyper",
            "wasm",
            "wenyan",
            "wgsl",
            "wikitext",
            "wolfram",
            "xml",
            "xsl",
            "yaml",
            "zenscript",
            "zig",
        ]
        | Var[
            Literal[
                "abap",
                "actionscript-3",
                "ada",
                "angular-html",
                "angular-ts",
                "apache",
                "apex",
                "apl",
                "applescript",
                "ara",
                "asciidoc",
                "asm",
                "astro",
                "awk",
                "ballerina",
                "bat",
                "beancount",
                "berry",
                "bibtex",
                "bicep",
                "blade",
                "c",
                "cadence",
                "clarity",
                "clojure",
                "cmake",
                "cobol",
                "codeowners",
                "codeql",
                "coffee",
                "common-lisp",
                "coq",
                "cpp",
                "crystal",
                "csharp",
                "css",
                "csv",
                "cue",
                "cypher",
                "d",
                "dart",
                "dax",
                "desktop",
                "diff",
                "docker",
                "dotenv",
                "dream-maker",
                "edge",
                "elixir",
                "elm",
                "emacs-lisp",
                "erb",
                "erlang",
                "fennel",
                "fish",
                "fluent",
                "fortran-fixed-form",
                "fortran-free-form",
                "fsharp",
                "gdresource",
                "gdscript",
                "gdshader",
                "genie",
                "gherkin",
                "git-commit",
                "git-rebase",
                "gleam",
                "glimmer-js",
                "glimmer-ts",
                "glsl",
                "gnuplot",
                "go",
                "graphql",
                "groovy",
                "hack",
                "haml",
                "handlebars",
                "haskell",
                "haxe",
                "hcl",
                "hjson",
                "hlsl",
                "html",
                "html-derivative",
                "http",
                "hxml",
                "hy",
                "imba",
                "ini",
                "java",
                "javascript",
                "jinja",
                "jison",
                "json",
                "json5",
                "jsonc",
                "jsonl",
                "jsonnet",
                "jssm",
                "jsx",
                "julia",
                "kotlin",
                "kusto",
                "latex",
                "lean",
                "less",
                "liquid",
                "log",
                "logo",
                "lua",
                "luau",
                "make",
                "markdown",
                "marko",
                "matlab",
                "mdc",
                "mdx",
                "mermaid",
                "mojo",
                "move",
                "narrat",
                "nextflow",
                "nginx",
                "nim",
                "nix",
                "nushell",
                "objective-c",
                "objective-cpp",
                "ocaml",
                "pascal",
                "perl",
                "php",
                "plain",
                "plsql",
                "po",
                "postcss",
                "powerquery",
                "powershell",
                "prisma",
                "prolog",
                "proto",
                "pug",
                "puppet",
                "purescript",
                "python",
                "qml",
                "qmldir",
                "qss",
                "r",
                "racket",
                "raku",
                "razor",
                "reg",
                "regexp",
                "rel",
                "riscv",
                "rst",
                "ruby",
                "rust",
                "sas",
                "sass",
                "scala",
                "scheme",
                "scss",
                "shaderlab",
                "shellscript",
                "shellsession",
                "smalltalk",
                "solidity",
                "soy",
                "sparql",
                "splunk",
                "sql",
                "ssh-config",
                "stata",
                "stylus",
                "svelte",
                "swift",
                "system-verilog",
                "systemd",
                "tasl",
                "tcl",
                "templ",
                "terraform",
                "tex",
                "toml",
                "ts-tags",
                "tsv",
                "tsx",
                "turtle",
                "twig",
                "typescript",
                "typespec",
                "typst",
                "v",
                "vala",
                "vb",
                "verilog",
                "vhdl",
                "viml",
                "vue",
                "vue-html",
                "vyper",
                "wasm",
                "wenyan",
                "wgsl",
                "wikitext",
                "wolfram",
                "xml",
                "xsl",
                "yaml",
                "zenscript",
                "zig",
            ]
        ]
        | None = None,
        theme: Literal[
            "andromeeda",
            "aurora-x",
            "ayu-dark",
            "catppuccin-frappe",
            "catppuccin-latte",
            "catppuccin-macchiato",
            "catppuccin-mocha",
            "dark-plus",
            "dracula",
            "dracula-soft",
            "everforest-dark",
            "everforest-light",
            "github-dark",
            "github-dark-default",
            "github-dark-dimmed",
            "github-dark-high-contrast",
            "github-light",
            "github-light-default",
            "github-light-high-contrast",
            "houston",
            "laserwave",
            "light-plus",
            "material-theme",
            "material-theme-darker",
            "material-theme-lighter",
            "material-theme-ocean",
            "material-theme-palenight",
            "min-dark",
            "min-light",
            "monokai",
            "night-owl",
            "nord",
            "one-dark-pro",
            "one-light",
            "plastic",
            "poimandres",
            "red",
            "rose-pine",
            "rose-pine-dawn",
            "rose-pine-moon",
            "slack-dark",
            "slack-ochin",
            "snazzy-light",
            "solarized-dark",
            "solarized-light",
            "synthwave-84",
            "tokyo-night",
            "vesper",
            "vitesse-black",
            "vitesse-dark",
            "vitesse-light",
        ]
        | Var[
            Literal[
                "andromeeda",
                "aurora-x",
                "ayu-dark",
                "catppuccin-frappe",
                "catppuccin-latte",
                "catppuccin-macchiato",
                "catppuccin-mocha",
                "dark-plus",
                "dracula",
                "dracula-soft",
                "everforest-dark",
                "everforest-light",
                "github-dark",
                "github-dark-default",
                "github-dark-dimmed",
                "github-dark-high-contrast",
                "github-light",
                "github-light-default",
                "github-light-high-contrast",
                "houston",
                "laserwave",
                "light-plus",
                "material-theme",
                "material-theme-darker",
                "material-theme-lighter",
                "material-theme-ocean",
                "material-theme-palenight",
                "min-dark",
                "min-light",
                "monokai",
                "night-owl",
                "nord",
                "one-dark-pro",
                "one-light",
                "plastic",
                "poimandres",
                "red",
                "rose-pine",
                "rose-pine-dawn",
                "rose-pine-moon",
                "slack-dark",
                "slack-ochin",
                "snazzy-light",
                "solarized-dark",
                "solarized-light",
                "synthwave-84",
                "tokyo-night",
                "vesper",
                "vitesse-black",
                "vitesse-dark",
                "vitesse-light",
            ]
        ]
        | None = None,
        themes: Var[dict[str, str] | list[dict[str, Any]]]
        | dict[str, str]
        | list[dict[str, Any]]
        | None = None,
        code: Var[str] | str | None = None,
        transformers: Var[list[ShikiBaseTransformers | dict[str, Any]]]
        | list[ShikiBaseTransformers | dict[str, Any]]
        | None = None,
        decorations: Var[list[ShikiDecorations]] | list[ShikiDecorations] | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> ShikiHighLevelCodeBlock:
        """Create a code block component using [shiki syntax highlighter](https://shiki.matsu.io/).

        Args:
            *children: The children of the component.
            use_transformers: If this is enabled, the default transformers(shikijs transformer) will be used.
            show_line_numbers: If this is enabled line numbers will be shown next to the code block.
            can_copy: Whether a copy button should appear.
            copy_button: copy_button: A custom copy button to override the default one.
            language: The language to use.
            theme: The theme to use ("light" or "dark").
            themes: The set of themes to use for different modes.
            code: The code to display.
            transformers: The transformers to use for the syntax highlighter.
            decorations: The decorations to use for the syntax highlighter.
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The props to pass to the component.

        Returns:
            The code block component.
        """

code_block = CodeblockNamespace()
