"""Stub file for reflex/components/radix/themes/components/text_area.py"""

# ------------------- DO NOT EDIT ----------------------
# This file was generated by `reflex/utils/pyi_generator.py`!
# ------------------------------------------------------
from collections.abc import Mapping, Sequence
from typing import Any, Literal

from reflex.components.core.breakpoints import Breakpoints
from reflex.components.el import elements
from reflex.components.radix.themes.base import RadixThemesComponent
from reflex.event import EventType, KeyInputInfo, PointerEventInfo
from reflex.vars.base import Var

LiteralTextAreaSize = Literal["1", "2", "3"]
LiteralTextAreaResize = Literal["none", "vertical", "horizontal", "both"]

class TextArea(RadixThemesComponent, elements.Textarea):
    @classmethod
    def create(
        cls,
        *children,
        auto_complete: Var[str] | str | None = None,
        auto_focus: Var[bool] | bool | None = None,
        auto_height: Var[bool] | bool | None = None,
        cols: Var[int | str] | int | str | None = None,
        default_value: Var[str] | str | None = None,
        dirname: Var[str] | str | None = None,
        disabled: Var[bool] | bool | None = None,
        enter_key_submit: Var[bool] | bool | None = None,
        form: Var[str] | str | None = None,
        max_length: Var[int | str] | int | str | None = None,
        min_length: Var[int | str] | int | str | None = None,
        name: Var[str] | str | None = None,
        placeholder: Var[str] | str | None = None,
        read_only: Var[bool] | bool | None = None,
        required: Var[bool] | bool | None = None,
        rows: Var[int | str] | int | str | None = None,
        value: Var[str] | str | None = None,
        wrap: Var[str] | str | None = None,
        style: Sequence[Mapping[str, Any]]
        | Mapping[str, Any]
        | Var[Mapping[str, Any]]
        | Breakpoints
        | None = None,
        key: Any | None = None,
        id: Any | None = None,
        ref: Var | None = None,
        class_name: Any | None = None,
        custom_attrs: dict[str, Var | Any] | None = None,
        on_blur: EventType[()] | EventType[str] | None = None,
        on_change: EventType[()] | EventType[str] | None = None,
        on_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_context_menu: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_double_click: EventType[()] | EventType[PointerEventInfo] | None = None,
        on_focus: EventType[()] | EventType[str] | None = None,
        on_key_down: EventType[()]
        | EventType[str]
        | EventType[str, KeyInputInfo]
        | None = None,
        on_key_up: EventType[()]
        | EventType[str]
        | EventType[str, KeyInputInfo]
        | None = None,
        on_mount: EventType[()] | None = None,
        on_mouse_down: EventType[()] | None = None,
        on_mouse_enter: EventType[()] | None = None,
        on_mouse_leave: EventType[()] | None = None,
        on_mouse_move: EventType[()] | None = None,
        on_mouse_out: EventType[()] | None = None,
        on_mouse_over: EventType[()] | None = None,
        on_mouse_up: EventType[()] | None = None,
        on_scroll: EventType[()] | None = None,
        on_scroll_end: EventType[()] | None = None,
        on_unmount: EventType[()] | None = None,
        **props,
    ) -> TextArea:
        """Create an Input component.

        Args:
            *children: The children of the component.
            auto_complete: Whether the form control should have autocomplete enabled
            auto_focus: Automatically focuses the textarea when the page loads
            default_value: The default value of the textarea when initially rendered
            dirname: Name part of the textarea to submit in 'dir' and 'name' pair when form is submitted
            disabled: Disables the textarea
            form: Associates the textarea with a form (by id)
            max_length: Maximum number of characters allowed in the textarea
            min_length: Minimum number of characters required in the textarea
            name: Name of the textarea, used when submitting the form
            placeholder: Placeholder text in the textarea
            read_only: Indicates whether the textarea is read-only
            required: Indicates that the textarea is required
            rows: Visible number of lines in the text control
            value: The controlled value of the textarea, read only unless used with on_change
            wrap: How the text in the textarea is to be wrapped when submitting the form
            auto_height: Automatically fit the content height to the text (use min-height with this prop)
            cols: Visible width of the text control, in average character widths
            enter_key_submit: Enter key submits form (shift-enter adds new line)
            on_change: Fired when the input value changes
            on_focus: Fired when the input gains focus
            on_blur: Fired when the input loses focus
            on_key_down: Fired when a key is pressed down
            on_key_up: Fired when a key is released
            style: The style of the component.
            key: A unique key for the component.
            id: The id for the component.
            ref: The Var to pass as the ref to the component.
            class_name: The class name for the component.
            custom_attrs: custom attribute
            **props: The properties of the component.

        Returns:
            The component.
        """

    def add_style(self): ...

text_area = TextArea.create
