# toasttab
## Authentication API

The authentication API returns an authentication token that you can present
when your integration client software uses other Toast APIs. For more
information about authentication, see [the Toast Developer
Guide](https://doc.toasttab.com/doc/devguide/authentication.html).

## Menus API

Returns information about a restaurant's menus.

_Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.

## Orders API

The orders API includes operations that create, update, and retrieve information about restaurant
guest orders.

Information on orders includes the checks, items ordered,
prices, payments, discounts, and customer data.

You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.

You can add items to an existing check.

The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order.
You cannot update an existing payment, but you can update the tip amount.

For delivery orders, you can update the delivery information.

You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.

The orders API supports email addresses that: 
  - Are up to 53 characters long. 
  - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @. 
  - Use the following supported characters:
    - a-z
    - A-Z
    - 0-9
    - _ (underscore)
    - International characters are not supported

## Labor API

Toast labor API is a set of REST web services that you can use to 
manage the employees, jobs, and shifts for your restaurant. The 
labor API is intended for software engineers, managers, and 
technical staff who are responsible for integrating third-party 
systems with the Toast platform.
## Restaurants API

Returns information about the configuration of restaurant.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.26
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import toastapi
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import toastapi
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import toastapi
from toastapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://ws-sandbox-api.eng.toasttab.com
# See configuration.py for a list of all supported configuration parameters.
configuration = toastapi.Configuration(
    host = "https://ws-sandbox-api.eng.toasttab.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
async with toastapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = toastapi.AlternatePaymentTypesApi(api_client)
    toast_restaurant_external_id = 'toast_restaurant_external_id_example' # str | The Toast POS GUID of the restaurant that the configuration applies to. 
    page_token = 'page_token_example' # str | A string that identifies the set of data objects that the endpoint will return in its response data. You can use this parameter to retrieve one page of response data. You get the value that you supply in the `pageToken` parameter from the `Toast-Next-Page-Token` header field value of a previous request to the endpoint. For more information, see <a href=\"https://doc.toasttab.com/doc/devguide/apiResponseDataPagination.html\">Paginating response data</a>.  (optional)
    last_modified = '2024-06-20T00:00:00.000+0000' # str | Limits the return data to objects created or modified after a specific date and time. For example: `2024-06-20T00:00:00.000+0000`.  (optional)

    try:
        # Get alternative payment types 
        api_response = await api_instance.alternate_payment_types_get(toast_restaurant_external_id, page_token=page_token, last_modified=last_modified)
        print("The response of AlternatePaymentTypesApi->alternate_payment_types_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AlternatePaymentTypesApi->alternate_payment_types_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://ws-sandbox-api.eng.toasttab.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AlternatePaymentTypesApi* | [**alternate_payment_types_get**](docs/AlternatePaymentTypesApi.md#alternate_payment_types_get) | **GET** /config/v2/alternatePaymentTypes | Get alternative payment types 
*AlternatePaymentTypesApi* | [**alternate_payment_types_guid_get**](docs/AlternatePaymentTypesApi.md#alternate_payment_types_guid_get) | **GET** /config/v2/alternatePaymentTypes/{guid} | Get an alternative payment type 
*AuthenticationApi* | [**authentication_login_post**](docs/AuthenticationApi.md#authentication_login_post) | **POST** /authentication/v1/authentication/login | Get an authentication token
*BreakTypesApi* | [**break_types_get**](docs/BreakTypesApi.md#break_types_get) | **GET** /config/v2/breakTypes | Get break types 
*BreakTypesApi* | [**break_types_guid_get**](docs/BreakTypesApi.md#break_types_guid_get) | **GET** /config/v2/breakTypes/{guid} | Get a break type 
*CashDrawersApi* | [**cash_drawers_get**](docs/CashDrawersApi.md#cash_drawers_get) | **GET** /config/v2/cashDrawers | Get cash drawers 
*CashDrawersApi* | [**cash_drawers_guid_get**](docs/CashDrawersApi.md#cash_drawers_guid_get) | **GET** /config/v2/cashDrawers/{guid} | Get a cash drawer 
*DiningOptionsApi* | [**dining_options_get**](docs/DiningOptionsApi.md#dining_options_get) | **GET** /config/v2/diningOptions | Get dining options 
*DiningOptionsApi* | [**dining_options_guid_get**](docs/DiningOptionsApi.md#dining_options_guid_get) | **GET** /config/v2/diningOptions/{guid} | Get a dining option 
*DiscountsApi* | [**applicable_discounts_post**](docs/DiscountsApi.md#applicable_discounts_post) | **POST** /orders/v2/applicableDiscounts | Get applicable discounts
*DiscountsApi* | [**discounts_get**](docs/DiscountsApi.md#discounts_get) | **GET** /config/v2/discounts | Get discounts
*DiscountsApi* | [**discounts_guid_get**](docs/DiscountsApi.md#discounts_guid_get) | **GET** /config/v2/discounts/{guid} | Get a discount
*DiscountsApi* | [**orders_checks_applied_discounts_post**](docs/DiscountsApi.md#orders_checks_applied_discounts_post) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/appliedDiscounts | Add check-level discounts
*DiscountsApi* | [**orders_checks_selections_applied_discounts_post**](docs/DiscountsApi.md#orders_checks_selections_applied_discounts_post) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/selections/{selectionGuid}/appliedDiscounts | Add item-level discounts
*EmployeesApi* | [**employees_employee_id_delete**](docs/EmployeesApi.md#employees_employee_id_delete) | **DELETE** /labor/v1/employees/{employeeId} | Delete an employee
*EmployeesApi* | [**employees_employee_id_external_id_post**](docs/EmployeesApi.md#employees_employee_id_external_id_post) | **POST** /labor/v1/employees/{employeeId}/externalId | Add an external identifier
*EmployeesApi* | [**employees_employee_id_external_id_put**](docs/EmployeesApi.md#employees_employee_id_external_id_put) | **PUT** /labor/v1/employees/{employeeId}/externalId | Add or replace an external identifier
*EmployeesApi* | [**employees_employee_id_get**](docs/EmployeesApi.md#employees_employee_id_get) | **GET** /labor/v1/employees/{employeeId} | Get information about one employee
*EmployeesApi* | [**employees_employee_id_jobs_put**](docs/EmployeesApi.md#employees_employee_id_jobs_put) | **PUT** /labor/v1/employees/{employeeId}/jobs | Replace a jobs list
*EmployeesApi* | [**employees_employee_id_patch**](docs/EmployeesApi.md#employees_employee_id_patch) | **PATCH** /labor/v1/employees/{employeeId} | Update employee information
*EmployeesApi* | [**employees_employee_id_unarchive_put**](docs/EmployeesApi.md#employees_employee_id_unarchive_put) | **PUT** /labor/v1/employees/{employeeId}/unarchive | Unarchive an employee
*EmployeesApi* | [**employees_employee_id_wage_overrides_put**](docs/EmployeesApi.md#employees_employee_id_wage_overrides_put) | **PUT** /labor/v1/employees/{employeeId}/wageOverrides | Replace wage overrides
*EmployeesApi* | [**employees_get**](docs/EmployeesApi.md#employees_get) | **GET** /labor/v1/employees | Get employees
*EmployeesApi* | [**employees_post**](docs/EmployeesApi.md#employees_post) | **POST** /labor/v1/employees | Add an employee
*JobsApi* | [**jobs_get**](docs/JobsApi.md#jobs_get) | **GET** /labor/v1/jobs | Get jobs
*JobsApi* | [**jobs_job_id_external_id_post**](docs/JobsApi.md#jobs_job_id_external_id_post) | **POST** /labor/v1/jobs/{jobId}/externalId | Add an external identifier
*JobsApi* | [**jobs_job_id_external_id_put**](docs/JobsApi.md#jobs_job_id_external_id_put) | **PUT** /labor/v1/jobs/{jobId}/externalId | Add or replace an external identifier
*JobsApi* | [**jobs_job_id_get**](docs/JobsApi.md#jobs_job_id_get) | **GET** /labor/v1/jobs/{jobId} | Get one job
*MenuGroupsApi* | [**menu_groups_get**](docs/MenuGroupsApi.md#menu_groups_get) | **GET** /config/v2/menuGroups | Get menu groups 
*MenuGroupsApi* | [**menu_groups_guid_get**](docs/MenuGroupsApi.md#menu_groups_guid_get) | **GET** /config/v2/menuGroups/{guid} | Get a menu group 
*MenuItemsApi* | [**menu_items_get**](docs/MenuItemsApi.md#menu_items_get) | **GET** /config/v2/menuItems | Get menu items 
*MenuItemsApi* | [**menu_items_guid_get**](docs/MenuItemsApi.md#menu_items_guid_get) | **GET** /config/v2/menuItems/{guid} | Get a menu item 
*MenusV2Api* | [**menus_v2_get**](docs/MenusV2Api.md#menus_v2_get) | **GET** /menus/v2/menus | Get menus (V2)
*MenusV2Api* | [**menus_v2_metadata_get**](docs/MenusV2Api.md#menus_v2_metadata_get) | **GET** /menus/v2/metadata | Get menu last modified timestamp (V2)
*MenusV3Api* | [**menus_v3_get**](docs/MenusV3Api.md#menus_v3_get) | **GET** /menus/v3/menus | Get menus
*MenusV3Api* | [**menus_v3_metadata_get**](docs/MenusV3Api.md#menus_v3_metadata_get) | **GET** /menus/v3/metadata | Get menu last modified timestamp 
*NoSaleReasonsApi* | [**no_sale_reasons_get**](docs/NoSaleReasonsApi.md#no_sale_reasons_get) | **GET** /config/v2/noSaleReasons | Get no sale reasons
*NoSaleReasonsApi* | [**no_sale_reasons_guid_get**](docs/NoSaleReasonsApi.md#no_sale_reasons_guid_get) | **GET** /config/v2/noSaleReasons/{guid} | Get a no sale reason
*OrdersApi* | [**orders_bulk_get**](docs/OrdersApi.md#orders_bulk_get) | **GET** /orders/v2/ordersBulk | Get multiple orders
*OrdersApi* | [**orders_get**](docs/OrdersApi.md#orders_get) | **GET** /orders/v2/orders | Get order identifiers (deprecated)
*OrdersApi* | [**orders_guid_get**](docs/OrdersApi.md#orders_guid_get) | **GET** /orders/v2/orders/{guid} | Get an order
*OrdersApi* | [**orders_order_guid_checks_check_guid_selections_post**](docs/OrdersApi.md#orders_order_guid_checks_check_guid_selections_post) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/selections | Add items to a check
*OrdersApi* | [**orders_order_guid_delivery_info_patch**](docs/OrdersApi.md#orders_order_guid_delivery_info_patch) | **PATCH** /orders/v2/orders/{orderGuid}/deliveryInfo | Update delivery information
*OrdersApi* | [**orders_post**](docs/OrdersApi.md#orders_post) | **POST** /orders/v2/orders | Post an order
*OrdersApi* | [**prices_post**](docs/OrdersApi.md#prices_post) | **POST** /orders/v2/prices | Get order prices
*OrdersApi* | [**void_order**](docs/OrdersApi.md#void_order) | **POST** /orders/v2/orders/{orderGuid}/void | Void an order
*PaymentsApi* | [**orders_checks_payments_post**](docs/PaymentsApi.md#orders_checks_payments_post) | **POST** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/payments | Post payments
*PaymentsApi* | [**orders_order_guid_checks_check_guid_payments_payment_guid_patch**](docs/PaymentsApi.md#orders_order_guid_checks_check_guid_payments_payment_guid_patch) | **PATCH** /orders/v2/orders/{orderGuid}/checks/{checkGuid}/payments/{paymentGuid} | Update a tip amount
*PaymentsApi* | [**payments_get**](docs/PaymentsApi.md#payments_get) | **GET** /orders/v2/payments | Get payment identifiers
*PaymentsApi* | [**payments_guid_get**](docs/PaymentsApi.md#payments_guid_get) | **GET** /orders/v2/payments/{guid} | Get a payment
*PayoutReasonsApi* | [**payout_reasons_get**](docs/PayoutReasonsApi.md#payout_reasons_get) | **GET** /config/v2/payoutReasons | Get payout reasons
*PayoutReasonsApi* | [**payout_reasons_guid_get**](docs/PayoutReasonsApi.md#payout_reasons_guid_get) | **GET** /config/v2/payoutReasons/{guid} | Get payout reason by GUID
*PreModifierGroupsApi* | [**pre_modifier_groups_get**](docs/PreModifierGroupsApi.md#pre_modifier_groups_get) | **GET** /config/v2/preModifierGroups | Get pre modifier groups
*PreModifierGroupsApi* | [**pre_modifier_groups_guid_get**](docs/PreModifierGroupsApi.md#pre_modifier_groups_guid_get) | **GET** /config/v2/preModifierGroups/{guid} | Get a pre-modifier group
*PreModifiersApi* | [**pre_modifiers_get**](docs/PreModifiersApi.md#pre_modifiers_get) | **GET** /config/v2/preModifiers | Get pre-modifiers
*PriceGroupsApi* | [**price_groups_get**](docs/PriceGroupsApi.md#price_groups_get) | **GET** /config/v2/priceGroups | Get price groups
*PriceGroupsApi* | [**price_groups_guid_get**](docs/PriceGroupsApi.md#price_groups_guid_get) | **GET** /config/v2/priceGroups/{guid} | Get price group by GUID
*PrintersApi* | [**printers_get**](docs/PrintersApi.md#printers_get) | **GET** /config/v2/printers | Get printers 
*PrintersApi* | [**printers_guid_get**](docs/PrintersApi.md#printers_guid_get) | **GET** /config/v2/printers/{guid} | Get a printer 
*RestaurantServicesApi* | [**restaurant_services_get**](docs/RestaurantServicesApi.md#restaurant_services_get) | **GET** /config/v2/restaurantServices | Get restaurant services
*RestaurantServicesApi* | [**restaurant_services_guid_get**](docs/RestaurantServicesApi.md#restaurant_services_guid_get) | **GET** /config/v2/restaurantServices/{guid} | Get restaurant service by GUID
*RestaurantsApi* | [**groups_management_group_guid_restaurants_get**](docs/RestaurantsApi.md#groups_management_group_guid_restaurants_get) | **GET** /restaurants/v1/groups/{managementGroupGUID}/restaurants | Get restaurants in a management group
*RestaurantsApi* | [**restaurants_restaurant_guid_get**](docs/RestaurantsApi.md#restaurants_restaurant_guid_get) | **GET** /restaurants/v1/restaurants/{restaurantGUID} | Get restaurant configuration information
*RevenueCentersApi* | [**revenue_centers_get**](docs/RevenueCentersApi.md#revenue_centers_get) | **GET** /config/v2/revenueCenters | Get revenue centers
*RevenueCentersApi* | [**revenue_centers_guid_get**](docs/RevenueCentersApi.md#revenue_centers_guid_get) | **GET** /config/v2/revenueCenters/{guid} | Get revenue center by GUID
*ServiceAreasApi* | [**service_areas_get**](docs/ServiceAreasApi.md#service_areas_get) | **GET** /config/v2/serviceAreas | Get service areas
*ServiceAreasApi* | [**service_areas_guid_get**](docs/ServiceAreasApi.md#service_areas_guid_get) | **GET** /config/v2/serviceAreas/{guid} | Get service area by GUID
*ServiceChargesApi* | [**service_charges_get**](docs/ServiceChargesApi.md#service_charges_get) | **GET** /config/v2/serviceCharges | Get service charges
*ServiceChargesApi* | [**service_charges_guid_get**](docs/ServiceChargesApi.md#service_charges_guid_get) | **GET** /config/v2/serviceCharges/{guid} | Get service charge by GUID
*ShiftsApi* | [**shifts_get**](docs/ShiftsApi.md#shifts_get) | **GET** /labor/v1/shifts | Get shifts
*ShiftsApi* | [**shifts_post**](docs/ShiftsApi.md#shifts_post) | **POST** /labor/v1/shifts | Create a shift
*ShiftsApi* | [**shifts_shift_id_delete**](docs/ShiftsApi.md#shifts_shift_id_delete) | **DELETE** /labor/v1/shifts/{shiftId} | Delete a shift
*ShiftsApi* | [**shifts_shift_id_get**](docs/ShiftsApi.md#shifts_shift_id_get) | **GET** /labor/v1/shifts/{shiftId} | Get a shift
*ShiftsApi* | [**shifts_shift_id_put**](docs/ShiftsApi.md#shifts_shift_id_put) | **PUT** /labor/v1/shifts/{shiftId} | Update a shift
*TablesApi* | [**tables_get**](docs/TablesApi.md#tables_get) | **GET** /config/v2/tables | Get tables 
*TablesApi* | [**tables_guid_get**](docs/TablesApi.md#tables_guid_get) | **GET** /config/v2/tables/{guid} | Get a table 
*TaxRatesApi* | [**tax_rates_get**](docs/TaxRatesApi.md#tax_rates_get) | **GET** /config/v2/taxRates | Get tax rates
*TaxRatesApi* | [**tax_rates_guid_get**](docs/TaxRatesApi.md#tax_rates_guid_get) | **GET** /config/v2/taxRates/{guid} | Get tax rate by GUID
*TimeEntriesApi* | [**time_entries_get**](docs/TimeEntriesApi.md#time_entries_get) | **GET** /labor/v1/timeEntries | Get time entries
*TimeEntriesApi* | [**time_entries_time_entry_id_get**](docs/TimeEntriesApi.md#time_entries_time_entry_id_get) | **GET** /labor/v1/timeEntries/{timeEntryId} | Get one time entry
*TipWithholdingApi* | [**tip_withholding_get**](docs/TipWithholdingApi.md#tip_withholding_get) | **GET** /config/v2/tipWithholding | Get tip withholding configuration
*VoidReasonsApi* | [**void_reasons_get**](docs/VoidReasonsApi.md#void_reasons_get) | **GET** /config/v2/voidReasons | Get void reasons
*VoidReasonsApi* | [**void_reasons_guid_get**](docs/VoidReasonsApi.md#void_reasons_guid_get) | **GET** /config/v2/voidReasons/{guid} | Get void reason by GUID


## Documentation For Models

 - [Alcohol](docs/Alcohol.md)
 - [AlternatePaymentType](docs/AlternatePaymentType.md)
 - [ApplicableDiscount](docs/ApplicableDiscount.md)
 - [ApplicableDiscountsRequest](docs/ApplicableDiscountsRequest.md)
 - [AppliedDiscount](docs/AppliedDiscount.md)
 - [AppliedDiscountReason](docs/AppliedDiscountReason.md)
 - [AppliedDiscountTrigger](docs/AppliedDiscountTrigger.md)
 - [AppliedLoyaltyInfo](docs/AppliedLoyaltyInfo.md)
 - [AppliedPackagingInfo](docs/AppliedPackagingInfo.md)
 - [AppliedPackagingItem](docs/AppliedPackagingItem.md)
 - [AppliedServiceCharge](docs/AppliedServiceCharge.md)
 - [AppliedTaxRate](docs/AppliedTaxRate.md)
 - [AuthenticationRequest](docs/AuthenticationRequest.md)
 - [AuthenticationResponse](docs/AuthenticationResponse.md)
 - [AuthenticationToken](docs/AuthenticationToken.md)
 - [Availability](docs/Availability.md)
 - [BreakType](docs/BreakType.md)
 - [CashDrawer](docs/CashDrawer.md)
 - [Check](docs/Check.md)
 - [ConfigReference](docs/ConfigReference.md)
 - [ContentAdvisories](docs/ContentAdvisories.md)
 - [CurbsidePickupInfo](docs/CurbsidePickupInfo.md)
 - [Customer](docs/Customer.md)
 - [DaySchedule](docs/DaySchedule.md)
 - [Delivery](docs/Delivery.md)
 - [DeliveryInfo](docs/DeliveryInfo.md)
 - [DeliveryPaymentOptions](docs/DeliveryPaymentOptions.md)
 - [DeliveryServiceInfo](docs/DeliveryServiceInfo.md)
 - [Device](docs/Device.md)
 - [DimensionUnitOfMeasure](docs/DimensionUnitOfMeasure.md)
 - [DiningOption](docs/DiningOption.md)
 - [Discount](docs/Discount.md)
 - [Employee](docs/Employee.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [ExternalReference](docs/ExternalReference.md)
 - [General](docs/General.md)
 - [GiftCardInfo](docs/GiftCardInfo.md)
 - [Hours](docs/Hours.md)
 - [Image](docs/Image.md)
 - [ItemTag](docs/ItemTag.md)
 - [Job](docs/Job.md)
 - [JobWageOverride](docs/JobWageOverride.md)
 - [Location](docs/Location.md)
 - [LoyaltyDetails](docs/LoyaltyDetails.md)
 - [MarketplaceFacilitatorTaxInfo](docs/MarketplaceFacilitatorTaxInfo.md)
 - [Menu](docs/Menu.md)
 - [MenuGroup](docs/MenuGroup.md)
 - [MenuItem](docs/MenuItem.md)
 - [Metadata](docs/Metadata.md)
 - [ModifierGroup](docs/ModifierGroup.md)
 - [ModifierOption](docs/ModifierOption.md)
 - [ModifierOptionTaxInfo](docs/ModifierOptionTaxInfo.md)
 - [NoSaleReason](docs/NoSaleReason.md)
 - [OnlineOrdering](docs/OnlineOrdering.md)
 - [Order](docs/Order.md)
 - [OrderResponse](docs/OrderResponse.md)
 - [OrdersOrderGuidDeliveryInfoPatchRequest](docs/OrdersOrderGuidDeliveryInfoPatchRequest.md)
 - [Payment](docs/Payment.md)
 - [PaymentOptions](docs/PaymentOptions.md)
 - [PayoutReason](docs/PayoutReason.md)
 - [Portion](docs/Portion.md)
 - [PreModifier](docs/PreModifier.md)
 - [PreModifierGroup](docs/PreModifierGroup.md)
 - [PrepTimes](docs/PrepTimes.md)
 - [PriceGroup](docs/PriceGroup.md)
 - [PricingRules](docs/PricingRules.md)
 - [Printer](docs/Printer.md)
 - [Refund](docs/Refund.md)
 - [RefundDetails](docs/RefundDetails.md)
 - [Restaurant](docs/Restaurant.md)
 - [RestaurantBasic](docs/RestaurantBasic.md)
 - [RestaurantInfo](docs/RestaurantInfo.md)
 - [RestaurantService](docs/RestaurantService.md)
 - [RevenueCenter](docs/RevenueCenter.md)
 - [SalesCategory](docs/SalesCategory.md)
 - [Schedule](docs/Schedule.md)
 - [Schedules](docs/Schedules.md)
 - [Selection](docs/Selection.md)
 - [SequencePrice](docs/SequencePrice.md)
 - [Service](docs/Service.md)
 - [ServiceArea](docs/ServiceArea.md)
 - [ServiceCharge](docs/ServiceCharge.md)
 - [ServiceChargeCriteria](docs/ServiceChargeCriteria.md)
 - [Shift](docs/Shift.md)
 - [SizeSequencePricingRule](docs/SizeSequencePricingRule.md)
 - [Table](docs/Table.md)
 - [TakeoutPaymentOptions](docs/TakeoutPaymentOptions.md)
 - [TaxRate](docs/TaxRate.md)
 - [TimeEntry](docs/TimeEntry.md)
 - [TimeEntryBreak](docs/TimeEntryBreak.md)
 - [TimeRange](docs/TimeRange.md)
 - [TimeSpecificPrice](docs/TimeSpecificPrice.md)
 - [TipWithholding](docs/TipWithholding.md)
 - [ToastReference](docs/ToastReference.md)
 - [URLs](docs/URLs.md)
 - [UpdatePaymentRequest](docs/UpdatePaymentRequest.md)
 - [VoidInformation](docs/VoidInformation.md)
 - [VoidOrderRequest](docs/VoidOrderRequest.md)
 - [VoidOrderRequestSelections](docs/VoidOrderRequestSelections.md)
 - [VoidReason](docs/VoidReason.md)
 - [WeekSchedule](docs/WeekSchedule.md)
 - [WeightUnitOfMeasure](docs/WeightUnitOfMeasure.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oauth2"></a>
### oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **restaurants:read**: Allows reading from the restaurants API.
 - **labor:read**: Allows reading from the labor API.
 - **orders:read**: Allows reading from the orders API.
 - **orders:write**: Allows writing to the orders API.
 - **payments:read**: Allows reading from the payments API.
 - **payments:write**: Allows writing to the payments API.
 - **discounts:read**: Allows reading from the discounts API.
 - **discounts:write**: Allows writing to the discounts API.
 - **menus.channel:read**: Allows reading from the menus API.
 - **menus:read**: Allows reading from menus API V2.
 - **config:read**: Allows reading from the configuration API.


## Author




