# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from toastapi.models.applied_discount_reason import AppliedDiscountReason
from toastapi.models.applied_discount_trigger import AppliedDiscountTrigger
from toastapi.models.external_reference import ExternalReference
from toastapi.models.loyalty_details import LoyaltyDetails
from toastapi.models.toast_reference import ToastReference
from typing import Optional, Set
from typing_extensions import Self

class AppliedDiscount(BaseModel):
    """
    A discount applied to a check or item. 
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    name: Optional[StrictStr] = Field(default=None, description="The name of the applied discount.")
    discount_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The discount amount. This amount is subtracted from the check or item.", alias="discountAmount")
    discount: Optional[ToastReference] = None
    approver: Optional[ExternalReference] = None
    discount_type: Optional[StrictStr] = Field(default=None, description="The behavior of this discount. ", alias="discountType")
    discount_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The percent value (0-100) of the applied discount when the `discountType` is `PERCENT` or `OPEN_PERCENT`.", alias="discountPercent")
    non_tax_discount_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The discount amount, excluding the tax discount amount. Response only.", alias="nonTaxDiscountAmount")
    triggers: Optional[List[AppliedDiscountTrigger]] = Field(default=None, description="The menu item selections in the check that triggered this discount to be applied. Response only.")
    processing_state: Optional[StrictStr] = Field(default=None, description="The validation state of a loyalty program discount. Response only.  Valid values:  * `PENDING_APPLIED` - The loyalty program discount is applied to the check but the loyalty program service provider has not validated it. The discount will appear on guest receipts.  * `APPLIED` - The loyalty program discount has been validated by the loyalty program service provider and will appear on guest receipts.  * `PENDING_VOID` - The loyalty program service provider rejected the discount. The discount is pending removal from the check.  * `VOID` - The loyalty program discount has been removed from the check because the loyalty program service provider rejected it. ", alias="processingState")
    applied_discount_reason: Optional[AppliedDiscountReason] = Field(default=None, alias="appliedDiscountReason")
    loyalty_details: Optional[LoyaltyDetails] = Field(default=None, alias="loyaltyDetails")
    combo_items: Optional[List[ExternalReference]] = Field(default=None, description="The menu item selections that are discounted as part of a combo discount. Response only.", alias="comboItems")
    applied_promo_code: Optional[StrictStr] = Field(default=None, description="The promo code that was applied to get this discount. Response only.", alias="appliedPromoCode")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "name", "discountAmount", "discount", "approver", "discountType", "discountPercent", "nonTaxDiscountAmount", "triggers", "processingState", "appliedDiscountReason", "loyaltyDetails", "comboItems", "appliedPromoCode"]

    @field_validator('discount_type')
    def discount_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BOGO', 'PERCENT', 'FIXED', 'OPEN_PERCENT', 'OPEN_FIXED', 'FIXED_TOTAL']):
            raise ValueError("must be one of enum values ('BOGO', 'PERCENT', 'FIXED', 'OPEN_PERCENT', 'OPEN_FIXED', 'FIXED_TOTAL')")
        return value

    @field_validator('processing_state')
    def processing_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PENDING_APPLIED', 'APPLIED', 'PENDING_VOID', 'VOID']):
            raise ValueError("must be one of enum values ('PENDING_APPLIED', 'APPLIED', 'PENDING_VOID', 'VOID')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppliedDiscount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of discount
        if self.discount:
            _dict['discount'] = self.discount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of approver
        if self.approver:
            _dict['approver'] = self.approver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in triggers (list)
        _items = []
        if self.triggers:
            for _item_triggers in self.triggers:
                if _item_triggers:
                    _items.append(_item_triggers.to_dict())
            _dict['triggers'] = _items
        # override the default output from pydantic by calling `to_dict()` of applied_discount_reason
        if self.applied_discount_reason:
            _dict['appliedDiscountReason'] = self.applied_discount_reason.to_dict()
        # override the default output from pydantic by calling `to_dict()` of loyalty_details
        if self.loyalty_details:
            _dict['loyaltyDetails'] = self.loyalty_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in combo_items (list)
        _items = []
        if self.combo_items:
            for _item_combo_items in self.combo_items:
                if _item_combo_items:
                    _items.append(_item_combo_items.to_dict())
            _dict['comboItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppliedDiscount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "name": obj.get("name"),
            "discountAmount": obj.get("discountAmount"),
            "discount": ToastReference.from_dict(obj["discount"]) if obj.get("discount") is not None else None,
            "approver": ExternalReference.from_dict(obj["approver"]) if obj.get("approver") is not None else None,
            "discountType": obj.get("discountType"),
            "discountPercent": obj.get("discountPercent"),
            "nonTaxDiscountAmount": obj.get("nonTaxDiscountAmount"),
            "triggers": [AppliedDiscountTrigger.from_dict(_item) for _item in obj["triggers"]] if obj.get("triggers") is not None else None,
            "processingState": obj.get("processingState"),
            "appliedDiscountReason": AppliedDiscountReason.from_dict(obj["appliedDiscountReason"]) if obj.get("appliedDiscountReason") is not None else None,
            "loyaltyDetails": LoyaltyDetails.from_dict(obj["loyaltyDetails"]) if obj.get("loyaltyDetails") is not None else None,
            "comboItems": [ExternalReference.from_dict(_item) for _item in obj["comboItems"]] if obj.get("comboItems") is not None else None,
            "appliedPromoCode": obj.get("appliedPromoCode")
        })
        return _obj


