# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from toastapi.models.availability import Availability
from toastapi.models.image import Image
from toastapi.models.menu_group import MenuGroup
from typing import Optional, Set
from typing_extensions import Self

class Menu(BaseModel):
    """
    Information about a menu configured for this restaurant. 
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A descriptive name for this menu, for example, \"Food\" or \"Drinks\". ")
    guid: Optional[StrictStr] = Field(default=None, description="A unique identifier for this menu, assigned by the Toast POS system. ")
    multi_location_id: Optional[StrictStr] = Field(default=None, description="An identifier that is used to identify and consolidate menu entities that are versions of each other.  `multiLocationId` replaces `masterId`. `multiLocationId` and `masterId` always have the same value.  Menu entities can be versioned. Those versions can be assigned to specific restaurant locations, or groups of locations, in a management group. For example, you could have two versions of a burger, one for a Boston location and another for a New York City location. Versioned menu entities share the majority of, but not all of, their data. For example, the Boston version is called the Minuteman Burger and has pickles, while the New York City version is called the Empire Burger and does not.  You use the `multiLocationId` to identify menu entities that are versions of each other. To continue the example above, the Minuteman Burger in the JSON returned for the Boston location has the same `multilocationId` as the Empire Burger in the JSON returned for the New York City location. These matching `multlocationId` values indicate that the two items are related versions of the same item. In Toast reports, this allows a restaurant to track sales of the burger across both locations. ", alias="multiLocationId")
    master_id: Optional[StrictInt] = Field(default=None, description="This value is deprecated. Instead of `masterId`, use `multiLocationId`.  An identifier that is used to identify and consolidate menu entities that are versions of each other. ", alias="masterId")
    description: Optional[StrictStr] = Field(default=None, description="An optional short description for this menu. ")
    pos_name: Optional[StrictStr] = Field(default=None, description="The button label name that appears for this menu entity in the Toast POS app. `posName` contains an empty string if a `posName` has not been defined for the menu entity and the `name` value is used for the button label instead. ", alias="posName")
    pos_button_color_light: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in light mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorLight` contains the HEX code for the light mode color. ", alias="posButtonColorLight")
    pos_button_color_dark: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in dark mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorDark` contains the HEX code for the dark mode color. ", alias="posButtonColorDark")
    high_res_image: Optional[StrictStr] = Field(default=None, description="The URL to a high resolution image that has been uploaded for this menu. The image file must be in JPG, PNG, or SVG format. The `highResImage` value is only available if the Toast Kiosk module has been enabled for this restaurant. This value is null if no high resolution image has been specified. ", alias="highResImage")
    image: Optional[Image] = None
    visibility: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that indicate where this menu entity is visible:  * POS: The menu entity is visible in the Toast POS app.   * KIOSK: The menu entity is visible on a Toast kiosk.   * TOAST_ONLINE_ORDERING: The menu entity is visible in the Toast online   ordering site for this restaurant.   * ORDERING_PARTNERS: The restaurants wants this menu entity to be visible   on online ordering sites that integrate with the Toast POS system using the orders API.   * GRUBHUB: Deprecated. The menu entity is included during a menu sync to   Grubhub and will be visible on the Grubhub online ordering service after a   menu sync has completed. _Note:_ Conceptually, the _Grubhub_ configuration   option that was associated with the `GRUBHUB` string in this array has   been replaced by the more general _Online orders: Ordering partners_   configuration option and restaurants that used the _Grubhub_ option have   been automatically migrated to the new _Online orders: Ordering partners_   option. This means that any menu entity that had the _Grubhub_ option set   to _Yes_ will now have the _Online orders: Ordering partners_ option   enabled and the `ORDERING_PARTNERS` enum will be present in the   `visibility` array for it. To support backwards compatibility, the   `visibility` array for these entities will also continue to contain the   `GRUBHUB` enum for a short period of time. See <a   href=\"https://doc.toasttab.com/doc/devguide/apiDeprecatedApiFunctions.html#apiMenuEntityVisibilityEnhancements\">Menu   Visibility Enhancements (Rolled Out)</a> for more information.  The `visibility` array is empty if the menu entity is not configured to be visible for any of the use cases listed above. ")
    availability: Optional[Availability] = None
    menu_groups: Optional[Annotated[List[MenuGroup], Field(min_length=0)]] = Field(default=None, description="An array of the `MenuGroup` objects contained in this menu. ", alias="menuGroups")
    __properties: ClassVar[List[str]] = ["name", "guid", "multiLocationId", "masterId", "description", "posName", "posButtonColorLight", "posButtonColorDark", "highResImage", "image", "visibility", "availability", "menuGroups"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS']):
                raise ValueError("each list item must be one of ('POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Menu from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of availability
        if self.availability:
            _dict['availability'] = self.availability.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in menu_groups (list)
        _items = []
        if self.menu_groups:
            for _item_menu_groups in self.menu_groups:
                if _item_menu_groups:
                    _items.append(_item_menu_groups.to_dict())
            _dict['menuGroups'] = _items
        # set to None if high_res_image (nullable) is None
        # and model_fields_set contains the field
        if self.high_res_image is None and "high_res_image" in self.model_fields_set:
            _dict['highResImage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Menu from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "guid": obj.get("guid"),
            "multiLocationId": obj.get("multiLocationId"),
            "masterId": obj.get("masterId"),
            "description": obj.get("description"),
            "posName": obj.get("posName"),
            "posButtonColorLight": obj.get("posButtonColorLight"),
            "posButtonColorDark": obj.get("posButtonColorDark"),
            "highResImage": obj.get("highResImage"),
            "image": Image.from_dict(obj["image"]) if obj.get("image") is not None else None,
            "visibility": obj.get("visibility"),
            "availability": Availability.from_dict(obj["availability"]) if obj.get("availability") is not None else None,
            "menuGroups": [MenuGroup.from_dict(_item) for _item in obj["menuGroups"]] if obj.get("menuGroups") is not None else None
        })
        return _obj


