# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from toastapi.models.content_advisories import ContentAdvisories
from toastapi.models.dimension_unit_of_measure import DimensionUnitOfMeasure
from toastapi.models.image import Image
from toastapi.models.item_tag import ItemTag
from toastapi.models.portion import Portion
from toastapi.models.sales_category import SalesCategory
from toastapi.models.weight_unit_of_measure import WeightUnitOfMeasure
from typing import Optional, Set
from typing_extensions import Self

class MenuItem(BaseModel):
    """
    Information about a menu item configured for this restaurant. 
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A descriptive name for this menu item, for example, \"Caesar Salad\" or \"Turkey Sandwich\". ")
    kitchen_name: Optional[StrictStr] = Field(default=None, description="The name of the menu item as it appears on kitchen tickets. The `kitchenName` can include both numbers and letters. This value contains an empty string if a kitchen name has not been configured for the menu item. ", alias="kitchenName")
    guid: Optional[StrictStr] = Field(default=None, description="A unique identifier for this menu item, assigned by the Toast POS system. ")
    multi_location_id: Optional[StrictStr] = Field(default=None, description="An identifier that is used to identify and consolidate menu entities that are versions of each other.  `multiLocationId` replaces `masterId`. `multiLocationId` and `masterId` always have the same value.  Menu entities can be versioned. Those versions can be assigned to specific restaurant locations, or groups of locations, in a management group. For example, you could have two versions of a burger, one for a Boston location and another for a New York City location. Versioned menu entities share the majority of, but not all of, their data. For example, the Boston version is called the Minuteman Burger and has pickles, while the New York City version is called the Empire Burger and does not.  You use the `multiLocationId` to identify menu entities that are versions of each other. To continue the example above, the Minuteman Burger in the JSON returned for the Boston location has the same `multilocationId` as the Empire Burger in the JSON returned for the New York City location. These matching `multlocationId` values indicate that the two items are related versions of the same item. In Toast reports, this allows a restaurant to track sales of the burger across both locations. ", alias="multiLocationId")
    master_id: Optional[StrictInt] = Field(default=None, description="This value is deprecated. Instead of `masterId`, use `multiLocationId`.  An identifier that is used to identify and consolidate menu entities that are versions of each other. ", alias="masterId")
    description: Optional[StrictStr] = Field(default=None, description="An optional short description of this menu item. ")
    pos_name: Optional[StrictStr] = Field(default=None, description="The button label name that appears for this menu entity in the Toast POS app. `posName` contains an empty string if a `posName` has not been defined for the menu entity and the `name` value is used for the button label instead. ", alias="posName")
    pos_button_color_light: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in light mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorLight` contains the HEX code for the light mode color. ", alias="posButtonColorLight")
    pos_button_color_dark: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in dark mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorDark` contains the HEX code for the dark mode color. ", alias="posButtonColorDark")
    image: Optional[Image] = None
    visibility: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that indicate where this menu entity is visible:  * POS: The menu entity is visible in the Toast POS app.   * KIOSK: The menu entity is visible on a Toast kiosk.   * TOAST_ONLINE_ORDERING: The menu entity is visible in the Toast online   ordering site for this restaurant.   * ORDERING_PARTNERS: The restaurants wants this menu entity to be visible   on online ordering sites that integrate with the Toast POS system using the orders API.   * GRUBHUB: Deprecated. The menu entity is included during a menu sync to   Grubhub and will be visible on the Grubhub online ordering service after a   menu sync has completed. _Note:_ Conceptually, the _Grubhub_ configuration   option that was associated with the `GRUBHUB` string in this array has   been replaced by the more general _Online orders: Ordering partners_   configuration option and restaurants that used the _Grubhub_ option have   been automatically migrated to the new _Online orders: Ordering partners_   option. This means that any menu entity that had the _Grubhub_ option set   to _Yes_ will now have the _Online orders: Ordering partners_ option   enabled and the `ORDERING_PARTNERS` enum will be present in the   `visibility` array for it. To support backwards compatibility, the   `visibility` array for these entities will also continue to contain the   `GRUBHUB` enum for a short period of time. See <a   href=\"https://doc.toasttab.com/doc/devguide/apiDeprecatedApiFunctions.html#apiMenuEntityVisibilityEnhancements\">Menu   Visibility Enhancements (Rolled Out)</a> for more information.  The `visibility` array is empty if the menu entity is not configured to be visible for any of the use cases listed above. ")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The price of this menu item.  In Toast Web, menu items may have prices assigned to them individually, or they may inherit them from a parent menu group. The `price` value reflects the menu item's fully resolved pricing configuration in the following ways:    * For base prices, the `price` value is populated with the specified base price.      * For menu-specific prices, the `price` value is resolved based on the current menu. For example, consider a menu item that is included in both Lunch and Dinner menus and is priced at $10 for the Lunch menu and $12 for the Dinner menu. In the fully resolved JSON returned by the menus API, this menu item would appear twice, once as a child of the Lunch menu with a `price` value of $10, and again as a child of the Dinner menu with a `price` value of $12.      If this same menu item is added to a Breakfast menu but a menu-specific price is not defined for the Breakfast menu, then the `price` value for the instance of the menu item that appears in the Breakfast menu JSON is populated with the base price from the menu-specific price configuration. Menu-specific price configurations include a base price that functions as a default price when a menu-specific price cannot be resolved.    * For location-specific prices, the `price` value is resolved based on the current location. For example, consider a menu item that costs $15 in the Boston location and $20 in the New York location. When you retrieve menu data for the Boston location, this menu item's `price` value is $15. When you retrieve menu data for the New York location, the menu item's `price` value is $20.      * For time-specific prices, the `price` value is populated with the base price that is specified as part of the time-specific price configuration. This base price functions as a default price for the menu item during times of the day when a time-specific price has not been defined. For example, consider a menu item that costs $8 from noon to 2pm and $10 during the rest of the day. The `price` value for this item would be $10. You must use the `pricingStrategy` and `pricingRules` values for this menu item to calculate the price of the item during time periods for which a time-specific price has been defined.      * For size prices, the `price` value is null. You must use this menu item's `pricingStrategy` and `pricingRules` values to calculate the price of the item for different sizes.      * For open prices, the `price` value is null.       If the menu item is priced using a price level, the `price` value reflects the pricing strategy used for that price level, using the same logic described above. For example, consider a price level that applies a size price to the menu items it is assigned to. In this scenario, the `price` value is null and you must use the menu item's `pricingStrategy` and `pricingRules` values to calculate the price of the item for different sizes.    For more information on menu item pricing and pricing strategies, see the <a href=\"https://doc.toasttab.com/doc/platformguide/adminToastPosPricingFeatures.html\">Menu Pricing</a> section in the Toast Platform Guide. ")
    pricing_strategy: Optional[StrictStr] = Field(default=None, description="A string that represents the pricing strategy used for this menu item.  You use the `pricingStrategy` value, in conjunction with the `pricingRules` value, to calculate the price for a menu item that uses the Time Specific Price or Size Price pricing strategy.  In Toast Web, menu items may have pricing strategies assigned to them individually, or they may inherit them from a parent menu group. The `pricingStrategy` value indicates the menu item's fully resolved pricing strategy. If the menu item is priced using the:   * Base Price pricing strategy, then the `pricingStrategy` value is BASE_PRICE.   * Menu Specific Price pricing strategy, then the `pricingStrategy` value is MENU_SPECIFIC_PRICE.   * Time Specific Price pricing strategy, then the `pricingStrategy` value is TIME_SPECIFIC_PRICE.   * Size Price pricing strategy, then the `pricingStrategy` value is SIZE_PRICE.   * Open Price pricing strategy, then the `pricingStrategy` value is OPEN_PRICE.  If the menu item is priced using the Location Specific Price pricing strategy, then the `pricingStrategy` value indicates which pricing strategy is used at the current location. For example, consider a menu item that uses a menu-specific price at the Boston location and a base price at the New York location. When you retrieve the menu data for the Boston location, the `pricingStrategy` for the menu item is MENU_SPECIFIC_PRICE. When you retrieve menu data for the New York location, the `pricingStrategy` for the menu item is BASE_PRICE.  If the menu item is priced using a price level, then the `pricingStrategy` value indicates which pricing strategy is used for that price level. For example, if the \"Draft Beer\" pricing level uses a time-specific price, then the `pricingStrategy` value for a menu item that is assigned the \"Draft Beer\" pricing level is TIME_SPECIFIC_PRICE.  If the `pricingStrategy` value is BASE_PRICE or MENU_SPECIFIC_PRICE, you can retrieve the menu item's price from its `price` value.  If the `pricingStrategy` value is TIME_SPECIFIC_PRICE or SIZE_PRICE, you must use the rules provided in _this menu item's_ `pricingRules` value to calculate the price for it. ", alias="pricingStrategy")
    pricing_rules: Optional[Dict[str, Any]] = Field(default=None, alias="pricingRules")
    is_deferred: Optional[StrictBool] = Field(default=None, description="Indicates whether this menu item should be considered deferred revenue. ", alias="isDeferred")
    is_discountable: Optional[StrictBool] = Field(default=None, description="Indicates whether this menu item can be discounted.  **_Important_** The orders API _does not validate_ against the `isDiscountable` value. If you submit an order that applies a discount to a menu item whose `isDiscountable` value is FALSE, the orders API will not fail the order but it will set the discount amount on the menu item to $0.00. If you are using the menus API to build an ordering application, be sure to inspect the `isDiscountable` value of the menu items to ensure that your ordering application does not allow an item to be discounted if its `isDiscountable` value is FALSE. ", alias="isDiscountable")
    sales_category: Optional[SalesCategory] = Field(default=None, alias="salesCategory")
    tax_info: Optional[List[StrictStr]] = Field(default=None, description="An array of GUIDs for the tax rates that apply to this menu item.  Note that a menu item's tax rates may get overridden if a modifier option is applied to it and that modifier option is configured so that it overrides its parent menu item's tax rates. See <a href=\"https://doc.toasttab.com/doc/devguide/apiUsingTaxInfoAndModifierOptionTaxInfoToCalculateTaxesForMenuItemsAndModOptions.html\">Using taxInfo and modifierOptionTaxInfo to calculate taxes for menu items and modifier options</a> in the Toast Developer Guide for more information.               To retrieve full configuration data for a tax rate, use the `/taxRates/{guid}` endpoint in the configuration API.  _Important:_ The `taxInfo` value is intended to help you display prices but the `/prices` endpoint of the orders API is the only supported way to determine the prices of orders that you submit to the orders API. See <a href=\"https://doc.toasttab.com/doc/devguide/apiOrderPrices.html\">Order prices</a> in the Toast Developer Guide for more information. ", alias="taxInfo")
    tax_inclusion: Optional[StrictStr] = Field(default=None, description="A string that represents the tax inclusion setting for this menu item. Possible values include:  * `TAX_INCLUDED`: The menu item's price includes taxes. You should not display additional tax on top of the menu item price in your ordering UI. * `TAX_NOT_INCLUDED`: The menu item's price does not include taxes. You should display tax values alongside the menu item price in your ordering UI. * `SMART_TAX`: The menu item is using smart tax, a feature that allows a restaurant to configure menu item prices to include or not include taxes, depending on the section of the restaurant that the item is ordered in (for example, the bar or the dining room). For example, a guest can order an item at either the bar or in the main dining room. To prevent bartenders from having to handle coins, which can slow down service, and to make tipping easier, the restaurant wants the price of the item to be a whole number that includes tax when it is ordered at the bar. In the main dining room, where speed of service is less of a concern, the restaurant doesn't want the item's price to include tax, so that it doesn't lose out on the extra revenue.  Typically, the smart tax setting is used for in-store workflows where the efficiency of money handling is a priority. As such, it doesn't apply to online ordering integrations. If a menu item's `taxInclusion` value is set to `SMART_TAX`, your ordering integration should treat the menu item as if tax is not included. For more information on the smart tax feature, see <a href=\"https://doc.toasttab.com/doc/platformguide/adminSmartTax.html\">Smart tax</a> in the Toast Platform Guide.  _Note:_ A menu item's tax inclusion setting is inherited by any modifiers that are applied to that menu item. For more information, see <a href=\"https://doc.toasttab.com/doc/platformguide/adminTaxesOnModifiers.html#adminModifierTaxInteraction\">Tax functionality interaction</a> in the Toast Platform Guide. ", alias="taxInclusion")
    item_tags: Optional[List[ItemTag]] = Field(default=None, description="An array of `ItemTag` objects that are assigned to this menu item. Item tags are used to assign identifying characteristics to a menu item, for example, vegetarian, gluten-free, or alcohol. ", alias="itemTags")
    plu: Optional[StrictStr] = Field(default=None, description="The price lookup (PLU) code for this menu item. The PLU code can include both numbers and letters. This value contains an empty string if a PLU code has not been defined. ")
    sku: Optional[StrictStr] = Field(default=None, description="The stock keeping unit (SKU) identifier for this menu item. The SKU identifier can include both numbers and letters. This value contains an empty string if a SKU has not been defined. ")
    calories: Optional[StrictInt] = Field(default=None, description="The number of calories in this menu item. The calories value can be any positive or negative integer, or zero. This value is null if a calories amount has not been configured for the menu item. ")
    content_advisories: Optional[ContentAdvisories] = Field(default=None, alias="contentAdvisories")
    unit_of_measure: Optional[StrictStr] = Field(default=None, description="The unit of measure used to determine the price of the item. For example, $10.00 per gram. ", alias="unitOfMeasure")
    portions: Optional[Annotated[List[Portion], Field(min_length=0)]] = Field(default=None, description="An array of `Portion` objects that define the portions that can be used with this menu item. For example, for a pizza menu item, you could define 1st Half and 2nd Half portions. See <a href=\"https://doc.toasttab.com/doc/platformguide/adminPortionsOverview.html\">Portions overview</a> in the Toast Platform Guide for more information on portions. ")
    prep_time: Optional[StrictInt] = Field(default=None, description="The amount of time, in seconds, that it takes to prepare this menu item. This value is null if a prep time has not been specified for the menu item.<br> <br> *Related topics*<br> <a href=\"https://doc.toasttab.com/doc/platformguide/adminFireByPrepTime.html\">Using prep times to automate item firing</a><br> ", alias="prepTime")
    prep_stations: Optional[List[StrictStr]] = Field(default=None, description="An array of GUIDs for the prep stations that have been assigned to this menu item. This array is empty if no prep stations have been assigned.<br> <br> *Related topics:*<br> <a href=\"https://doc.toasttab.com/doc/platformguide/platformKitchenRoutingOverview.html\">Routing to prep stations</a> ", alias="prepStations")
    modifier_group_references: Optional[Annotated[List[StrictInt], Field(min_length=0)]] = Field(default=None, description="An array of `referenceId`s for `ModifierGroup` objects. These objects define the modifier groups that apply to this menu item. ", alias="modifierGroupReferences")
    eligible_payment_assistance_programs: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that indicate which payment assistance programs may be used to pay for this menu item. Possible values include:  * `SNAP`: Supplemental Nutrition Assistance Program * `EBT_CASH`: Electronic Benefit Transfer Cash  The array is empty if no payment assistance programs have been assigned to the menu item. ", alias="eligiblePaymentAssistancePrograms")
    length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The length of the item or modifier. Use the `dimensionUnitOfMeasure` value to determine the unit of measurement.  The `length` value is `null` if no length is specified for the item or modifier.  You can use the `length`, `height`, and `width` values to determine the overall size of the item or modifier. This information is useful, for example, when determining shipping costs or choosing the size of delivery vehicle to use. ")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The height of the item or modifier. Use the `dimensionUnitOfMeasure` value to determine the unit of measurement.  The `height` value is `null` if no height is specified for the item or modifier.  You can use the `length`, `height`, and `width` values to determine the overall size of the item or modifier. This information is useful, for example, when determining shipping costs or choosing the size of delivery vehicle to use. ")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The width of the item or modifier. Use the `dimensionUnitOfMeasure` value to determine the unit of measurement.  The `width` value is `null` if no width is specified for the item or modifier.  You can use the `length`, `height`, and `width` values to determine the overall size of the item or modifier. This information is useful, for example, when determining shipping costs or choosing the size of delivery vehicle to use. ")
    dimension_unit_of_measure: Optional[DimensionUnitOfMeasure] = Field(default=None, alias="dimensionUnitOfMeasure")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The weight of the item or modifier. Use the `weightUnitOfMeasure` value to determine the unit of measurement.  The `weight` value is `null` if no weight is specified for the item or modifier.      You can use the `weight` value when determining shipping costs or choosing a delivery vehicle to use. ")
    weight_unit_of_measure: Optional[WeightUnitOfMeasure] = Field(default=None, alias="weightUnitOfMeasure")
    images: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that contain URLs for images that have been uploaded for this item or modifier. The array is empty if no images have been uploaded.      _Note:_ The `images` array contains multiple URLs for multiple images for the same item or modifier. The older `image` value contains a single URL for a single image. ")
    guest_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The number of guests the item or modifier is expected to serve. This value is `null` if no guest count is specified. ", alias="guestCount")
    __properties: ClassVar[List[str]] = ["name", "kitchenName", "guid", "multiLocationId", "masterId", "description", "posName", "posButtonColorLight", "posButtonColorDark", "image", "visibility", "price", "pricingStrategy", "pricingRules", "isDeferred", "isDiscountable", "salesCategory", "taxInfo", "taxInclusion", "itemTags", "plu", "sku", "calories", "contentAdvisories", "unitOfMeasure", "portions", "prepTime", "prepStations", "modifierGroupReferences", "eligiblePaymentAssistancePrograms", "length", "height", "width", "dimensionUnitOfMeasure", "weight", "weightUnitOfMeasure", "images", "guestCount"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS']):
                raise ValueError("each list item must be one of ('POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS')")
        return value

    @field_validator('pricing_strategy')
    def pricing_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BASE_PRICE', 'MENU_SPECIFIC_PRICE', 'TIME_SPECIFIC_PRICE', 'SIZE_PRICE', 'OPEN_PRICE']):
            raise ValueError("must be one of enum values ('BASE_PRICE', 'MENU_SPECIFIC_PRICE', 'TIME_SPECIFIC_PRICE', 'SIZE_PRICE', 'OPEN_PRICE')")
        return value

    @field_validator('tax_inclusion')
    def tax_inclusion_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TAX_INCLUDED', 'TAX_NOT_INCLUDED', 'SMART_TAX']):
            raise ValueError("must be one of enum values ('TAX_INCLUDED', 'TAX_NOT_INCLUDED', 'SMART_TAX')")
        return value

    @field_validator('unit_of_measure')
    def unit_of_measure_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NONE', 'LB', 'OZ', 'KG', 'G']):
            raise ValueError("must be one of enum values ('NONE', 'LB', 'OZ', 'KG', 'G')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MenuItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pricing_rules
        if self.pricing_rules:
            _dict['pricingRules'] = self.pricing_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sales_category
        if self.sales_category:
            _dict['salesCategory'] = self.sales_category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in item_tags (list)
        _items = []
        if self.item_tags:
            for _item_item_tags in self.item_tags:
                if _item_item_tags:
                    _items.append(_item_item_tags.to_dict())
            _dict['itemTags'] = _items
        # override the default output from pydantic by calling `to_dict()` of content_advisories
        if self.content_advisories:
            _dict['contentAdvisories'] = self.content_advisories.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in portions (list)
        _items = []
        if self.portions:
            for _item_portions in self.portions:
                if _item_portions:
                    _items.append(_item_portions.to_dict())
            _dict['portions'] = _items
        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if calories (nullable) is None
        # and model_fields_set contains the field
        if self.calories is None and "calories" in self.model_fields_set:
            _dict['calories'] = None

        # set to None if prep_time (nullable) is None
        # and model_fields_set contains the field
        if self.prep_time is None and "prep_time" in self.model_fields_set:
            _dict['prepTime'] = None

        # set to None if length (nullable) is None
        # and model_fields_set contains the field
        if self.length is None and "length" in self.model_fields_set:
            _dict['length'] = None

        # set to None if height (nullable) is None
        # and model_fields_set contains the field
        if self.height is None and "height" in self.model_fields_set:
            _dict['height'] = None

        # set to None if width (nullable) is None
        # and model_fields_set contains the field
        if self.width is None and "width" in self.model_fields_set:
            _dict['width'] = None

        # set to None if weight (nullable) is None
        # and model_fields_set contains the field
        if self.weight is None and "weight" in self.model_fields_set:
            _dict['weight'] = None

        # set to None if guest_count (nullable) is None
        # and model_fields_set contains the field
        if self.guest_count is None and "guest_count" in self.model_fields_set:
            _dict['guestCount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MenuItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "kitchenName": obj.get("kitchenName"),
            "guid": obj.get("guid"),
            "multiLocationId": obj.get("multiLocationId"),
            "masterId": obj.get("masterId"),
            "description": obj.get("description"),
            "posName": obj.get("posName"),
            "posButtonColorLight": obj.get("posButtonColorLight"),
            "posButtonColorDark": obj.get("posButtonColorDark"),
            "image": Image.from_dict(obj["image"]) if obj.get("image") is not None else None,
            "visibility": obj.get("visibility"),
            "price": obj.get("price"),
            "pricingStrategy": obj.get("pricingStrategy"),
            "pricingRules": PricingRules.from_dict(obj["pricingRules"]) if obj.get("pricingRules") is not None else None,
            "isDeferred": obj.get("isDeferred"),
            "isDiscountable": obj.get("isDiscountable"),
            "salesCategory": SalesCategory.from_dict(obj["salesCategory"]) if obj.get("salesCategory") is not None else None,
            "taxInfo": obj.get("taxInfo"),
            "taxInclusion": obj.get("taxInclusion"),
            "itemTags": [ItemTag.from_dict(_item) for _item in obj["itemTags"]] if obj.get("itemTags") is not None else None,
            "plu": obj.get("plu"),
            "sku": obj.get("sku"),
            "calories": obj.get("calories"),
            "contentAdvisories": ContentAdvisories.from_dict(obj["contentAdvisories"]) if obj.get("contentAdvisories") is not None else None,
            "unitOfMeasure": obj.get("unitOfMeasure"),
            "portions": [Portion.from_dict(_item) for _item in obj["portions"]] if obj.get("portions") is not None else None,
            "prepTime": obj.get("prepTime"),
            "prepStations": obj.get("prepStations"),
            "modifierGroupReferences": obj.get("modifierGroupReferences"),
            "eligiblePaymentAssistancePrograms": obj.get("eligiblePaymentAssistancePrograms"),
            "length": obj.get("length"),
            "height": obj.get("height"),
            "width": obj.get("width"),
            "dimensionUnitOfMeasure": obj.get("dimensionUnitOfMeasure"),
            "weight": obj.get("weight"),
            "weightUnitOfMeasure": obj.get("weightUnitOfMeasure"),
            "images": obj.get("images"),
            "guestCount": obj.get("guestCount")
        })
        return _obj


