# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ModifierGroup(BaseModel):
    """
    Information about a modifier group configured for this restaurant, including an array of modifier options contained in the group. 
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A descriptive name for this modifier group, for example, \"Pizza Toppings\" or \"Salad Dressings\". ")
    guid: Optional[StrictStr] = Field(default=None, description="A unique identifier for this modifier group, assigned by the Toast POS system. ")
    reference_id: Optional[StrictInt] = Field(default=None, description="An integer identifier that is used to refer to this modifier group by items and portions that use it. ", alias="referenceId")
    multi_location_id: Optional[StrictStr] = Field(default=None, description="An identifier that is used to identify and consolidate menu entities that are versions of each other.  `multiLocationId` replaces `masterId`. `multiLocationId` and `masterId` always have the same value.  Menu entities can be versioned. Those versions can be assigned to specific restaurant locations, or groups of locations, in a management group. For example, you could have two versions of a burger, one for a Boston location and another for a New York City location. Versioned menu entities share the majority of, but not all of, their data. For example, the Boston version is called the Minuteman Burger and has pickles, while the New York City version is called the Empire Burger and does not.  You use the `multiLocationId` to identify menu entities that are versions of each other. To continue the example above, the Minuteman Burger in the JSON returned for the Boston location has the same `multilocationId` as the Empire Burger in the JSON returned for the New York City location. These matching `multlocationId` values indicate that the two items are related versions of the same item. In Toast reports, this allows a restaurant to track sales of the burger across both locations. ", alias="multiLocationId")
    master_id: Optional[StrictInt] = Field(default=None, description="This value is deprecated. Instead of `masterId`, use `multiLocationId`.  An identifier that is used to identify and consolidate menu entities that are versions of each other. ", alias="masterId")
    pos_name: Optional[StrictStr] = Field(default=None, description="The button label name that appears for this menu entity in the Toast POS app. `posName` contains an empty string if a `posName` has not been defined for the menu entity and the `name` value is used for the button label instead. ", alias="posName")
    pos_button_color_light: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in light mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorLight` contains the HEX code for the light mode color. ", alias="posButtonColorLight")
    pos_button_color_dark: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in dark mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorDark` contains the HEX code for the dark mode color. ", alias="posButtonColorDark")
    visibility: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that indicate where this menu entity is visible:  * POS: The menu entity is visible in the Toast POS app.   * KIOSK: The menu entity is visible on a Toast kiosk.   * TOAST_ONLINE_ORDERING: The menu entity is visible in the Toast online   ordering site for this restaurant.   * ORDERING_PARTNERS: The restaurants wants this menu entity to be visible   on online ordering sites that integrate with the Toast POS system using the orders API.   * GRUBHUB: Deprecated. The menu entity is included during a menu sync to   Grubhub and will be visible on the Grubhub online ordering service after a   menu sync has completed. _Note:_ Conceptually, the _Grubhub_ configuration   option that was associated with the `GRUBHUB` string in this array has   been replaced by the more general _Online orders: Ordering partners_   configuration option and restaurants that used the _Grubhub_ option have   been automatically migrated to the new _Online orders: Ordering partners_   option. This means that any menu entity that had the _Grubhub_ option set   to _Yes_ will now have the _Online orders: Ordering partners_ option   enabled and the `ORDERING_PARTNERS` enum will be present in the   `visibility` array for it. To support backwards compatibility, the   `visibility` array for these entities will also continue to contain the   `GRUBHUB` enum for a short period of time. See <a   href=\"https://doc.toasttab.com/doc/devguide/apiDeprecatedApiFunctions.html#apiMenuEntityVisibilityEnhancements\">Menu   Visibility Enhancements (Rolled Out)</a> for more information.  The `visibility` array is empty if the menu entity is not configured to be visible for any of the use cases listed above. ")
    pricing_strategy: Optional[StrictStr] = Field(default=None, description="A string that represents the pricing strategy used for this modifier group.  If there is no additional charge for the modifier options in this group, or if the modifier options in the group are priced individually, then the `pricingStrategy` value is NONE.  If the modifier group is priced at the group level and is using the:   * Fixed Price pricing strategy, then the `pricingStrategy` value is NONE.   * Sequence Price pricing strategy, then the `pricingStrategy` value is SEQUENCE_PRICE.   * Size Price pricing strategy, then the `pricingStrategy` value is SIZE_PRICE.   * Size/Sequence Price pricing strategy, then the `pricingStrategy` value is SIZE_SEQUENCE_PRICE.     If the `pricingStrategy` value is NONE,  then the prices for the modifier options in this group are resolved down to the modifier option level and you can retrieve them from the `price` value of the individual `ModifierOption` objects.  If the `pricingStrategy` value is SIZE_PRICE, SEQUENCE_PRICE, or SIZE_SEQUENCE_PRICE, then you must use the rules provided in _this modifier group's_ `pricingRules` value to calculate the prices for the modifier options in the group. ", alias="pricingStrategy")
    pricing_rules: Optional[Dict[str, Any]] = Field(default=None, alias="pricingRules")
    default_options_charge_price: Optional[StrictStr] = Field(default=None, description="Indicates whether the prices associated with any default modifiers in this group are added to the cost of the menu items they modify.  Values are:   * NO: The default modifier price is ignored. No change is made to the cost of the menu item.   * YES: The default modifier price is added to the menu item price. YES is the default setting for `defaultOptionsChargePrice`. ", alias="defaultOptionsChargePrice")
    default_options_substitution_pricing: Optional[StrictStr] = Field(default=None, description="Indicates whether substitution pricing is enabled for the modifier group. ", alias="defaultOptionsSubstitutionPricing")
    min_selections: Optional[StrictInt] = Field(default=None, description="The minimum number of modifier options that a customer can choose from this modifier group.  If a server is not required to select a modifier option from this modifier group, `minSelections` is set to 0.  If a server must select a modifier option from this modifier group, `minSelections` must be set to 1 or higher. ", alias="minSelections")
    max_selections: Optional[StrictInt] = Field(default=None, description="The maximum number of modifier options that a customer can choose from this modifier group. `maxSelections` is null if a customer can choose an unlimited number of modifier options from this modifier group. ", alias="maxSelections")
    required_mode: Optional[StrictStr] = Field(default=None, description="Specifies how the modifier group appears and behaves in the Toast POS app. ", alias="requiredMode")
    is_multi_select: Optional[StrictBool] = Field(default=None, description="Indicates whether you can select more than one modifier option from this modifier group. ", alias="isMultiSelect")
    pre_modifier_group_reference: Optional[StrictInt] = Field(default=None, description="The `referenceId` of a `PreModifierGroup` object. This object defines the premodifiers that can be applied to the modifier options contained in this modifier group. ", alias="preModifierGroupReference")
    modifier_option_references: Optional[Annotated[List[StrictInt], Field(min_length=0)]] = Field(default=None, description="An array of `referenceId`s for `ModifierOption` objects. These objects define the modifier options contained in this modifier group. ", alias="modifierOptionReferences")
    __properties: ClassVar[List[str]] = ["name", "guid", "referenceId", "multiLocationId", "masterId", "posName", "posButtonColorLight", "posButtonColorDark", "visibility", "pricingStrategy", "pricingRules", "defaultOptionsChargePrice", "defaultOptionsSubstitutionPricing", "minSelections", "maxSelections", "requiredMode", "isMultiSelect", "preModifierGroupReference", "modifierOptionReferences"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS']):
                raise ValueError("each list item must be one of ('POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS')")
        return value

    @field_validator('default_options_charge_price')
    def default_options_charge_price_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NO', 'YES']):
            raise ValueError("must be one of enum values ('NO', 'YES')")
        return value

    @field_validator('default_options_substitution_pricing')
    def default_options_substitution_pricing_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NO', 'YES']):
            raise ValueError("must be one of enum values ('NO', 'YES')")
        return value

    @field_validator('required_mode')
    def required_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['REQUIRED', 'OPTIONAL_FORCE_SHOW', 'OPTIONAL']):
            raise ValueError("must be one of enum values ('REQUIRED', 'OPTIONAL_FORCE_SHOW', 'OPTIONAL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModifierGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pricing_rules
        if self.pricing_rules:
            _dict['pricingRules'] = self.pricing_rules.to_dict()
        # set to None if max_selections (nullable) is None
        # and model_fields_set contains the field
        if self.max_selections is None and "max_selections" in self.model_fields_set:
            _dict['maxSelections'] = None

        # set to None if pre_modifier_group_reference (nullable) is None
        # and model_fields_set contains the field
        if self.pre_modifier_group_reference is None and "pre_modifier_group_reference" in self.model_fields_set:
            _dict['preModifierGroupReference'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModifierGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "guid": obj.get("guid"),
            "referenceId": obj.get("referenceId"),
            "multiLocationId": obj.get("multiLocationId"),
            "masterId": obj.get("masterId"),
            "posName": obj.get("posName"),
            "posButtonColorLight": obj.get("posButtonColorLight"),
            "posButtonColorDark": obj.get("posButtonColorDark"),
            "visibility": obj.get("visibility"),
            "pricingStrategy": obj.get("pricingStrategy"),
            "pricingRules": PricingRules.from_dict(obj["pricingRules"]) if obj.get("pricingRules") is not None else None,
            "defaultOptionsChargePrice": obj.get("defaultOptionsChargePrice"),
            "defaultOptionsSubstitutionPricing": obj.get("defaultOptionsSubstitutionPricing"),
            "minSelections": obj.get("minSelections"),
            "maxSelections": obj.get("maxSelections"),
            "requiredMode": obj.get("requiredMode"),
            "isMultiSelect": obj.get("isMultiSelect"),
            "preModifierGroupReference": obj.get("preModifierGroupReference"),
            "modifierOptionReferences": obj.get("modifierOptionReferences")
        })
        return _obj


