"""
This module contains only a dictionary of Windows Language IDs.
"""
from __future__ import annotations

LCID = {
    0x0C00: 'Default Custom Locale Language',
    0x1400: 'Default Custom MUI Locale Language',
    0x007F: 'Invariant Locale Language',
    0x0000: 'Neutral Locale Language',
    0x0800: 'System Default Locale Language',
    0x1000: 'Unspecified Custom Locale Language',
    0x0400: 'User Default Locale Language',
    0x0436: 'Afrikaans-South Africa',
    0x041c: 'Albanian-Albania',
    0x045e: 'Amharic-Ethiopia',
    0x0401: 'Arabic (Saudi Arabia)',
    0x1401: 'Arabic (Algeria)',
    0x3c01: 'Arabic (Bahrain)',
    0x0c01: 'Arabic (Egypt)',
    0x0801: 'Arabic (Iraq)',
    0x2c01: 'Arabic (Jordan)',
    0x3401: 'Arabic (Kuwait)',
    0x3001: 'Arabic (Lebanon)',
    0x1001: 'Arabic (Libya)',
    0x1801: 'Arabic (Morocco)',
    0x2001: 'Arabic (Oman)',
    0x4001: 'Arabic (Qatar)',
    0x2801: 'Arabic (Syria)',
    0x1c01: 'Arabic (Tunisia)',
    0x3801: 'Arabic (U.A.E.)',
    0x2401: 'Arabic (Yemen)',
    0x042b: 'Armenian-Armenia',
    0x044d: 'Assamese',
    0x082c: 'Azeri (Cyrillic)',
    0x042c: 'Azeri (Latin)',
    0x042d: 'Basque',
    0x0423: 'Belarusian',
    0x0445: 'Bengali (India)',
    0x0845: 'Bengali (Bangladesh)',
    0x141A: 'Bosnian (Bosnia/Herzegovina)',
    0x0402: 'Bulgarian',
    0x0455: 'Burmese',
    0x0403: 'Catalan',
    0x045c: 'Cherokee-United States',
    0x0804: 'Chinese (People\'s Republic of China)',
    0x1004: 'Chinese (Singapore)',
    0x0404: 'Chinese (Taiwan)',
    0x0c04: 'Chinese (Hong Kong SAR)',
    0x1404: 'Chinese (Macao SAR)',
    0x041a: 'Croatian',
    0x101a: 'Croatian (Bosnia/Herzegovina)',
    0x0405: 'Czech',
    0x0406: 'Danish',
    0x0465: 'Divehi',
    0x0413: 'Dutch-Netherlands',
    0x0813: 'Dutch-Belgium',
    0x0466: 'Edo',
    0x0409: 'English (United States)',
    0x0809: 'English (United Kingdom)',
    0x0c09: 'English (Australia)',
    0x2809: 'English (Belize)',
    0x1009: 'English (Canada)',
    0x2409: 'English (Caribbean)',
    0x3c09: 'English (Hong Kong SAR)',
    0x4009: 'English (India)',
    0x3809: 'English (Indonesia)',
    0x1809: 'English (Ireland)',
    0x2009: 'English (Jamaica)',
    0x4409: 'English (Malaysia)',
    0x1409: 'English (New Zealand)',
    0x3409: 'English (Philippines)',
    0x4809: 'English (Singapore)',
    0x1c09: 'English (South Africa)',
    0x2c09: 'English (Trinidad)',
    0x3009: 'English (Zimbabwe)',
    0x0425: 'Estonian',
    0x0438: 'Faroese',
    0x0429: 'Farsi',
    0x0464: 'Filipino',
    0x040b: 'Finnish',
    0x040c: 'French (France)',
    0x080c: 'French (Belgium)',
    0x2c0c: 'French (Cameroon)',
    0x0c0c: 'French (Canada)',
    0x240c: 'French (Democratic Rep. of Congo)',
    0x300c: 'French (Cote d\'Ivoire)',
    0x3c0c: 'French (Haiti)',
    0x140c: 'French (Luxembourg)',
    0x340c: 'French (Mali)',
    0x180c: 'French (Monaco)',
    0x380c: 'French (Morocco)',
    0xe40c: 'French (North Africa)',
    0x200c: 'French (Reunion)',
    0x280c: 'French (Senegal)',
    0x100c: 'French (Switzerland)',
    0x1c0c: 'French (West Indies)',
    0x0462: 'Frisian-Netherlands',
    0x0467: 'Fulfulde-Nigeria',
    0x042f: 'FYRO Macedonian',
    0x083c: 'Gaelic (Ireland)',
    0x043c: 'Gaelic (Scotland)',
    0x0456: 'Galician',
    0x0437: 'Georgian',
    0x0407: 'German (Germany)',
    0x0c07: 'German (Austria)',
    0x1407: 'German (Liechtenstein)',
    0x1007: 'German (Luxembourg)',
    0x0807: 'German (Switzerland)',
    0x0408: 'Greek',
    0x0474: 'Guarani-Paraguay',
    0x0447: 'Gujarati',
    0x0468: 'Hausa-Nigeria',
    0x0475: 'Hawaiian (United States)',
    0x040d: 'Hebrew',
    0x0439: 'Hindi',
    0x040e: 'Hungarian',
    0x0469: 'Ibibio-Nigeria',
    0x040f: 'Icelandic',
    0x0470: 'Igbo-Nigeria',
    0x0421: 'Indonesian',
    0x045d: 'Inuktitut',
    0x0410: 'Italian (Italy)',
    0x0810: 'Italian (Switzerland)',
    0x0411: 'Japanese',
    0x044b: 'Kannada',
    0x0471: 'Kanuri-Nigeria',
    0x0860: 'Kashmiri',
    0x0460: 'Kashmiri (Arabic)',
    0x043f: 'Kazakh',
    0x0453: 'Khmer',
    0x0457: 'Konkani',
    0x0412: 'Korean',
    0x0440: 'Kyrgyz (Cyrillic)',
    0x0454: 'Lao',
    0x0476: 'Latin',
    0x0426: 'Latvian',
    0x0427: 'Lithuanian',
    0x043e: 'Malay-Malaysia',
    0x083e: 'Malay-Brunei Darussalam',
    0x044c: 'Malayalam',
    0x043a: 'Maltese',
    0x0458: 'Manipuri',
    0x0481: 'Maori-New Zealand',
    0x044e: 'Marathi',
    0x0450: 'Mongolian (Cyrillic)',
    0x0850: 'Mongolian (Mongolian)',
    0x0461: 'Nepali',
    0x0861: 'Nepali-India',
    0x0414: 'Norwegian (Bokmål)',
    0x0814: 'Norwegian (Nynorsk)',
    0x0448: 'Oriya',
    0x0472: 'Oromo',
    0x0479: 'Papiamentu',
    0x0463: 'Pashto',
    0x0415: 'Polish',
    0x0416: 'Portuguese-Brazil',
    0x0816: 'Portuguese-Portugal',
    0x0446: 'Punjabi',
    0x0846: 'Punjabi (Pakistan)',
    0x046B: 'Quecha (Bolivia)',
    0x086B: 'Quecha (Ecuador)',
    0x0C6B: 'Quecha (Peru)',
    0x0417: 'Rhaeto-Romanic',
    0x0418: 'Romanian',
    0x0818: 'Romanian (Moldava)',
    0x0419: 'Russian',
    0x0819: 'Russian (Moldava)',
    0x043b: 'Sami (Lappish)',
    0x044f: 'Sanskrit',
    0x046c: 'Sepedi',
    0x0c1a: 'Serbian (Cyrillic)',
    0x081a: 'Serbian (Latin)',
    0x0459: 'Sindhi (India)',
    0x0859: 'Sindhi (Pakistan)',
    0x045b: 'Sinhalese-Sri Lanka',
    0x041b: 'Slovak',
    0x0424: 'Slovenian',
    0x0477: 'Somali',
    0x042e: 'Sorbian',
    0x0c0a: 'Spanish (Modern Sort)',
    0x040a: 'Spanish (Traditional Sort)',
    0x2c0a: 'Spanish (Argentina)',
    0x400a: 'Spanish (Bolivia)',
    0x340a: 'Spanish (Chile)',
    0x240a: 'Spanish (Colombia)',
    0x140a: 'Spanish (Costa Rica)',
    0x1c0a: 'Spanish (Dominican Republic)',
    0x300a: 'Spanish (Ecuador)',
    0x440a: 'Spanish (El Salvador)',
    0x100a: 'Spanish (Guatemala)',
    0x480a: 'Spanish (Honduras)',
    0x580a: 'Spanish (Latin America)',
    0x080a: 'Spanish (Mexico)',
    0x4c0a: 'Spanish (Nicaragua)',
    0x180a: 'Spanish (Panama)',
    0x3c0a: 'Spanish (Paraguay)',
    0x280a: 'Spanish (Peru)',
    0x500a: 'Spanish (Puerto Rico)',
    0x540a: 'Spanish (United States)',
    0x380a: 'Spanish (Uruguay)',
    0x200a: 'Spanish (Venezuela)',
    0x0430: 'Sutu',
    0x0441: 'Swahili',
    0x041d: 'Swedish',
    0x081d: 'Swedish-Finland',
    0x045a: 'Syriac',
    0x0428: 'Tajik',
    0x045f: 'Tamazight (Arabic)',
    0x085f: 'Tamazight (Latin)',
    0x0449: 'Tamil',
    0x0444: 'Tatar',
    0x044a: 'Telugu',
    0x041e: 'Thai',
    0x0851: 'Tibetan (Bhutan)',
    0x0451: 'Tibetan (People\'s Republic of China)',
    0x0873: 'Tigrigna (Eritrea)',
    0x0473: 'Tigrigna (Ethiopia)',
    0x0431: 'Tsonga',
    0x0432: 'Tswana',
    0x041f: 'Turkish',
    0x0442: 'Turkmen',
    0x0480: 'Uighur-China',
    0x0422: 'Ukrainian',
    0x0420: 'Urdu',
    0x0820: 'Urdu-India',
    0x0843: 'Uzbek (Cyrillic)',
    0x0443: 'Uzbek (Latin)',
    0x0433: 'Venda',
    0x042a: 'Vietnamese',
    0x0452: 'Welsh',
    0x0434: 'Xhosa',
    0x0478: 'Yi',
    0x043d: 'Yiddish',
    0x046a: 'Yoruba',
    0x0435: 'Zulu',
    0x04ff: 'HID (Human Interface DeVITe)',
}


DEFAULT_CODEPAGE = {
    0x0401: 'cp1256',
    0x0402: 'cp1251',
    0x0404: 'big5',
    0x0405: 'cp1250',
    0x0408: 'cp1253',
    0x040d: 'cp1255',
    0x040e: 'cp1250',
    0x0411: 'shift_jis',
    0x0412: 'uhc',
    0x0415: 'cp1250',
    0x0418: 'cp1250',
    0x0419: 'cp1251',
    0x041a: 'cp1250',
    0x041b: 'cp1250',
    0x041c: 'cp1250',
    0x041e: 'cp874',
    0x041f: 'cp1254',
    0x0420: 'cp1256',
    0x0422: 'cp1251',
    0x0423: 'cp1251',
    0x0424: 'cp1250',
    0x0425: 'cp1257',
    0x0426: 'cp1257',
    0x0427: 'cp1257',
    0x0429: 'cp1256',
    0x042a: 'cp1258',
    0x042c: 'cp1254',
    0x042f: 'cp1251',
    0x043f: 'cp1251',
    0x0440: 'cp1251',
    0x0443: 'cp1254',
    0x0444: 'cp1251',
    0x0450: 'cp1251',
    0x0492: 'iso_8859_14',
    0x0801: 'cp1256',
    0x0804: 'gbk',
    0x081a: 'cp1250',
    0x082c: 'cp1251',
    0x0843: 'cp1251',
    0x0c01: 'cp1256',
    0x0c04: 'big5',
    0x0c1a: 'cp1251',
    0x1001: 'cp1256',
    0x1004: 'gbk',
    0x1401: 'cp1256',
    0x1404: 'big5',
    0x1801: 'cp1256',
    0x1c01: 'cp1256',
    0x2001: 'cp1256',
    0x2401: 'cp1256',
    0x2801: 'cp1256',
    0x2c01: 'cp1256',
    0x3001: 'cp1256',
    0x3401: 'cp1256',
    0x3801: 'cp1256',
    0x3c01: 'cp1256',
    0x4001: 'cp1256',
}
