# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'CustomResourceColumnDefinition',
    'CustomResourceColumnDefinitionPatch',
    'CustomResourceConversion',
    'CustomResourceConversionPatch',
    'CustomResourceDefinition',
    'CustomResourceDefinitionCondition',
    'CustomResourceDefinitionConditionPatch',
    'CustomResourceDefinitionNames',
    'CustomResourceDefinitionNamesPatch',
    'CustomResourceDefinitionSpec',
    'CustomResourceDefinitionSpecPatch',
    'CustomResourceDefinitionStatus',
    'CustomResourceDefinitionStatusPatch',
    'CustomResourceDefinitionVersion',
    'CustomResourceDefinitionVersionPatch',
    'CustomResourceSubresourceScale',
    'CustomResourceSubresourceScalePatch',
    'CustomResourceSubresources',
    'CustomResourceSubresourcesPatch',
    'CustomResourceValidation',
    'CustomResourceValidationPatch',
    'ExternalDocumentation',
    'ExternalDocumentationPatch',
    'JSONSchemaProps',
    'JSONSchemaPropsPatch',
    'ServiceReference',
    'ServiceReferencePatch',
    'WebhookClientConfig',
    'WebhookClientConfigPatch',
]

@pulumi.output_type
class CustomResourceColumnDefinition(dict):
    """
    CustomResourceColumnDefinition specifies a column for server side printing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "JSONPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceColumnDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceColumnDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceColumnDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None):
        """
        CustomResourceColumnDefinition specifies a column for server side printing.
        :param _builtins.str json_path: JSONPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        :param _builtins.str name: name is a human readable name for the column.
        :param _builtins.str type: type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param _builtins.str description: description is a human readable description of this column.
        :param _builtins.str format: format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param _builtins.int priority: priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        """
        pulumi.set(__self__, "json_path", json_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter(name="JSONPath")
    def json_path(self) -> _builtins.str:
        """
        JSONPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        """
        return pulumi.get(self, "json_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is a human readable name for the column.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        description is a human readable description of this column.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class CustomResourceColumnDefinitionPatch(dict):
    """
    CustomResourceColumnDefinition specifies a column for server side printing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "JSONPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceColumnDefinitionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceColumnDefinitionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceColumnDefinitionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 format: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        CustomResourceColumnDefinition specifies a column for server side printing.
        :param _builtins.str json_path: JSONPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        :param _builtins.str description: description is a human readable description of this column.
        :param _builtins.str format: format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param _builtins.str name: name is a human readable name for the column.
        :param _builtins.int priority: priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        :param _builtins.str type: type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="JSONPath")
    def json_path(self) -> Optional[_builtins.str]:
        """
        JSONPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        """
        return pulumi.get(self, "json_path")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        description is a human readable description of this column.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is a human readable name for the column.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomResourceConversion(dict):
    """
    CustomResourceConversion describes how to convert different versions of a CR.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conversionReviewVersions":
            suggest = "conversion_review_versions"
        elif key == "webhookClientConfig":
            suggest = "webhook_client_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceConversion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceConversion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceConversion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 strategy: _builtins.str,
                 conversion_review_versions: Optional[Sequence[_builtins.str]] = None,
                 webhook_client_config: Optional['outputs.WebhookClientConfig'] = None):
        """
        CustomResourceConversion describes how to convert different versions of a CR.
        :param _builtins.str strategy: strategy specifies how custom resources are converted between versions. Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information
                 is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhookClientConfig to be set.
        :param Sequence[_builtins.str] conversion_review_versions: conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Defaults to `["v1beta1"]`.
        :param 'WebhookClientConfigArgs' webhook_client_config: webhookClientConfig is the instructions for how to call the webhook if strategy is `Webhook`. Required when `strategy` is set to `Webhook`.
        """
        pulumi.set(__self__, "strategy", strategy)
        if conversion_review_versions is not None:
            pulumi.set(__self__, "conversion_review_versions", conversion_review_versions)
        if webhook_client_config is not None:
            pulumi.set(__self__, "webhook_client_config", webhook_client_config)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> _builtins.str:
        """
        strategy specifies how custom resources are converted between versions. Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information
          is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhookClientConfig to be set.
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter(name="conversionReviewVersions")
    def conversion_review_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Defaults to `["v1beta1"]`.
        """
        return pulumi.get(self, "conversion_review_versions")

    @_builtins.property
    @pulumi.getter(name="webhookClientConfig")
    def webhook_client_config(self) -> Optional['outputs.WebhookClientConfig']:
        """
        webhookClientConfig is the instructions for how to call the webhook if strategy is `Webhook`. Required when `strategy` is set to `Webhook`.
        """
        return pulumi.get(self, "webhook_client_config")


@pulumi.output_type
class CustomResourceConversionPatch(dict):
    """
    CustomResourceConversion describes how to convert different versions of a CR.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conversionReviewVersions":
            suggest = "conversion_review_versions"
        elif key == "webhookClientConfig":
            suggest = "webhook_client_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceConversionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceConversionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceConversionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conversion_review_versions: Optional[Sequence[_builtins.str]] = None,
                 strategy: Optional[_builtins.str] = None,
                 webhook_client_config: Optional['outputs.WebhookClientConfigPatch'] = None):
        """
        CustomResourceConversion describes how to convert different versions of a CR.
        :param Sequence[_builtins.str] conversion_review_versions: conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Defaults to `["v1beta1"]`.
        :param _builtins.str strategy: strategy specifies how custom resources are converted between versions. Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information
                 is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhookClientConfig to be set.
        :param 'WebhookClientConfigPatchArgs' webhook_client_config: webhookClientConfig is the instructions for how to call the webhook if strategy is `Webhook`. Required when `strategy` is set to `Webhook`.
        """
        if conversion_review_versions is not None:
            pulumi.set(__self__, "conversion_review_versions", conversion_review_versions)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if webhook_client_config is not None:
            pulumi.set(__self__, "webhook_client_config", webhook_client_config)

    @_builtins.property
    @pulumi.getter(name="conversionReviewVersions")
    def conversion_review_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail. Defaults to `["v1beta1"]`.
        """
        return pulumi.get(self, "conversion_review_versions")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[_builtins.str]:
        """
        strategy specifies how custom resources are converted between versions. Allowed values are: - `None`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `Webhook`: API Server will call to an external webhook to do the conversion. Additional information
          is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhookClientConfig to be set.
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter(name="webhookClientConfig")
    def webhook_client_config(self) -> Optional['outputs.WebhookClientConfigPatch']:
        """
        webhookClientConfig is the instructions for how to call the webhook if strategy is `Webhook`. Required when `strategy` is set to `Webhook`.
        """
        return pulumi.get(self, "webhook_client_config")


@pulumi.output_type
class CustomResourceDefinition(dict):
    """
    CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>. Deprecated in v1.16, planned for removal in v1.19. Use apiextensions.k8s.io/v1 CustomResourceDefinition instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.CustomResourceDefinitionSpec',
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.CustomResourceDefinitionStatus'] = None):
        """
        CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>. Deprecated in v1.16, planned for removal in v1.19. Use apiextensions.k8s.io/v1 CustomResourceDefinition instead.
        :param 'CustomResourceDefinitionSpecArgs' spec: spec describes how the user wants the resources to appear
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param 'CustomResourceDefinitionStatusArgs' status: status indicates the actual state of the CustomResourceDefinition
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apiextensions.k8s.io/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CustomResourceDefinition')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> 'outputs.CustomResourceDefinitionSpec':
        """
        spec describes how the user wants the resources to appear
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.CustomResourceDefinitionStatus']:
        """
        status indicates the actual state of the CustomResourceDefinition
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomResourceDefinitionCondition(dict):
    """
    CustomResourceDefinitionCondition contains details for the current condition of this pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        CustomResourceDefinitionCondition contains details for the current condition of this pod.
        :param _builtins.str status: status is the status of the condition. Can be True, False, Unknown.
        :param _builtins.str type: type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        :param _builtins.str last_transition_time: lastTransitionTime last time the condition transitioned from one status to another.
        :param _builtins.str message: message is a human-readable message indicating details about last transition.
        :param _builtins.str reason: reason is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        status is the status of the condition. Can be True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        lastTransitionTime last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class CustomResourceDefinitionConditionPatch(dict):
    """
    CustomResourceDefinitionCondition contains details for the current condition of this pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        CustomResourceDefinitionCondition contains details for the current condition of this pod.
        :param _builtins.str last_transition_time: lastTransitionTime last time the condition transitioned from one status to another.
        :param _builtins.str message: message is a human-readable message indicating details about last transition.
        :param _builtins.str reason: reason is a unique, one-word, CamelCase reason for the condition's last transition.
        :param _builtins.str status: status is the status of the condition. Can be True, False, Unknown.
        :param _builtins.str type: type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        lastTransitionTime last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        status is the status of the condition. Can be True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomResourceDefinitionNames(dict):
    """
    CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listKind":
            suggest = "list_kind"
        elif key == "shortNames":
            suggest = "short_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: _builtins.str,
                 plural: _builtins.str,
                 categories: Optional[Sequence[_builtins.str]] = None,
                 list_kind: Optional[_builtins.str] = None,
                 short_names: Optional[Sequence[_builtins.str]] = None,
                 singular: Optional[_builtins.str] = None):
        """
        CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
        :param _builtins.str kind: kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        :param _builtins.str plural: plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        :param Sequence[_builtins.str] categories: categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        :param _builtins.str list_kind: listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        :param Sequence[_builtins.str] short_names: shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        :param _builtins.str singular: singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "plural", plural)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if list_kind is not None:
            pulumi.set(__self__, "list_kind", list_kind)
        if short_names is not None:
            pulumi.set(__self__, "short_names", short_names)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def plural(self) -> _builtins.str:
        """
        plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        """
        return pulumi.get(self, "plural")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[_builtins.str]]:
        """
        categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="listKind")
    def list_kind(self) -> Optional[_builtins.str]:
        """
        listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        """
        return pulumi.get(self, "list_kind")

    @_builtins.property
    @pulumi.getter(name="shortNames")
    def short_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        """
        return pulumi.get(self, "short_names")

    @_builtins.property
    @pulumi.getter
    def singular(self) -> Optional[_builtins.str]:
        """
        singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        return pulumi.get(self, "singular")


@pulumi.output_type
class CustomResourceDefinitionNamesPatch(dict):
    """
    CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listKind":
            suggest = "list_kind"
        elif key == "shortNames":
            suggest = "short_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionNamesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionNamesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionNamesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Optional[Sequence[_builtins.str]] = None,
                 kind: Optional[_builtins.str] = None,
                 list_kind: Optional[_builtins.str] = None,
                 plural: Optional[_builtins.str] = None,
                 short_names: Optional[Sequence[_builtins.str]] = None,
                 singular: Optional[_builtins.str] = None):
        """
        CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
        :param Sequence[_builtins.str] categories: categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        :param _builtins.str kind: kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        :param _builtins.str list_kind: listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        :param _builtins.str plural: plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        :param Sequence[_builtins.str] short_names: shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        :param _builtins.str singular: singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if list_kind is not None:
            pulumi.set(__self__, "list_kind", list_kind)
        if plural is not None:
            pulumi.set(__self__, "plural", plural)
        if short_names is not None:
            pulumi.set(__self__, "short_names", short_names)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[_builtins.str]]:
        """
        categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="listKind")
    def list_kind(self) -> Optional[_builtins.str]:
        """
        listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        """
        return pulumi.get(self, "list_kind")

    @_builtins.property
    @pulumi.getter
    def plural(self) -> Optional[_builtins.str]:
        """
        plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        """
        return pulumi.get(self, "plural")

    @_builtins.property
    @pulumi.getter(name="shortNames")
    def short_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        """
        return pulumi.get(self, "short_names")

    @_builtins.property
    @pulumi.getter
    def singular(self) -> Optional[_builtins.str]:
        """
        singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        return pulumi.get(self, "singular")


@pulumi.output_type
class CustomResourceDefinitionSpec(dict):
    """
    CustomResourceDefinitionSpec describes how a user wants their resource to appear
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalPrinterColumns":
            suggest = "additional_printer_columns"
        elif key == "preserveUnknownFields":
            suggest = "preserve_unknown_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group: _builtins.str,
                 names: 'outputs.CustomResourceDefinitionNames',
                 scope: _builtins.str,
                 additional_printer_columns: Optional[Sequence['outputs.CustomResourceColumnDefinition']] = None,
                 conversion: Optional['outputs.CustomResourceConversion'] = None,
                 preserve_unknown_fields: Optional[_builtins.bool] = None,
                 subresources: Optional['outputs.CustomResourceSubresources'] = None,
                 validation: Optional['outputs.CustomResourceValidation'] = None,
                 version: Optional[_builtins.str] = None,
                 versions: Optional[Sequence['outputs.CustomResourceDefinitionVersion']] = None):
        """
        CustomResourceDefinitionSpec describes how a user wants their resource to appear
        :param _builtins.str group: group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        :param 'CustomResourceDefinitionNamesArgs' names: names specify the resource and kind names for the custom resource.
        :param _builtins.str scope: scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`. Default is `Namespaced`.
        :param Sequence['CustomResourceColumnDefinitionArgs'] additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If present, this field configures columns for all versions. Top-level and per-version columns are mutually exclusive. If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        :param 'CustomResourceConversionArgs' conversion: conversion defines conversion settings for the CRD.
        :param _builtins.bool preserve_unknown_fields: preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. If false, schemas must be defined for all versions. Defaults to true in v1beta for backwards compatibility. Deprecated: will be required to be false in v1. Preservation of unknown fields can be specified in the validation schema using the `x-kubernetes-preserve-unknown-fields: true` extension. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
        :param 'CustomResourceSubresourcesArgs' subresources: subresources specify what subresources the defined custom resource has. If present, this field configures subresources for all versions. Top-level and per-version subresources are mutually exclusive.
        :param 'CustomResourceValidationArgs' validation: validation describes the schema used for validation and pruning of the custom resource. If present, this validation schema is used to validate all versions. Top-level and per-version schemas are mutually exclusive.
        :param _builtins.str version: version is the API version of the defined custom resource. The custom resources are served under `/apis/<group>/<version>/...`. Must match the name of the first item in the `versions` list if `version` and `versions` are both specified. Optional if `versions` is specified. Deprecated: use `versions` instead.
        :param Sequence['CustomResourceDefinitionVersionArgs'] versions: versions is the list of all API versions of the defined custom resource. Optional if `version` is specified. The name of the first item in the `versions` list must match the `version` field if `version` and `versions` are both specified. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "scope", scope)
        if additional_printer_columns is not None:
            pulumi.set(__self__, "additional_printer_columns", additional_printer_columns)
        if conversion is not None:
            pulumi.set(__self__, "conversion", conversion)
        if preserve_unknown_fields is not None:
            pulumi.set(__self__, "preserve_unknown_fields", preserve_unknown_fields)
        if subresources is not None:
            pulumi.set(__self__, "subresources", subresources)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def names(self) -> 'outputs.CustomResourceDefinitionNames':
        """
        names specify the resource and kind names for the custom resource.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`. Default is `Namespaced`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="additionalPrinterColumns")
    def additional_printer_columns(self) -> Optional[Sequence['outputs.CustomResourceColumnDefinition']]:
        """
        additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If present, this field configures columns for all versions. Top-level and per-version columns are mutually exclusive. If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        """
        return pulumi.get(self, "additional_printer_columns")

    @_builtins.property
    @pulumi.getter
    def conversion(self) -> Optional['outputs.CustomResourceConversion']:
        """
        conversion defines conversion settings for the CRD.
        """
        return pulumi.get(self, "conversion")

    @_builtins.property
    @pulumi.getter(name="preserveUnknownFields")
    def preserve_unknown_fields(self) -> Optional[_builtins.bool]:
        """
        preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. If false, schemas must be defined for all versions. Defaults to true in v1beta for backwards compatibility. Deprecated: will be required to be false in v1. Preservation of unknown fields can be specified in the validation schema using the `x-kubernetes-preserve-unknown-fields: true` extension. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
        """
        return pulumi.get(self, "preserve_unknown_fields")

    @_builtins.property
    @pulumi.getter
    def subresources(self) -> Optional['outputs.CustomResourceSubresources']:
        """
        subresources specify what subresources the defined custom resource has. If present, this field configures subresources for all versions. Top-level and per-version subresources are mutually exclusive.
        """
        return pulumi.get(self, "subresources")

    @_builtins.property
    @pulumi.getter
    def validation(self) -> Optional['outputs.CustomResourceValidation']:
        """
        validation describes the schema used for validation and pruning of the custom resource. If present, this validation schema is used to validate all versions. Top-level and per-version schemas are mutually exclusive.
        """
        return pulumi.get(self, "validation")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        version is the API version of the defined custom resource. The custom resources are served under `/apis/<group>/<version>/...`. Must match the name of the first item in the `versions` list if `version` and `versions` are both specified. Optional if `versions` is specified. Deprecated: use `versions` instead.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionVersion']]:
        """
        versions is the list of all API versions of the defined custom resource. Optional if `version` is specified. The name of the first item in the `versions` list must match the `version` field if `version` and `versions` are both specified. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class CustomResourceDefinitionSpecPatch(dict):
    """
    CustomResourceDefinitionSpec describes how a user wants their resource to appear
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalPrinterColumns":
            suggest = "additional_printer_columns"
        elif key == "preserveUnknownFields":
            suggest = "preserve_unknown_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_printer_columns: Optional[Sequence['outputs.CustomResourceColumnDefinitionPatch']] = None,
                 conversion: Optional['outputs.CustomResourceConversionPatch'] = None,
                 group: Optional[_builtins.str] = None,
                 names: Optional['outputs.CustomResourceDefinitionNamesPatch'] = None,
                 preserve_unknown_fields: Optional[_builtins.bool] = None,
                 scope: Optional[_builtins.str] = None,
                 subresources: Optional['outputs.CustomResourceSubresourcesPatch'] = None,
                 validation: Optional['outputs.CustomResourceValidationPatch'] = None,
                 version: Optional[_builtins.str] = None,
                 versions: Optional[Sequence['outputs.CustomResourceDefinitionVersionPatch']] = None):
        """
        CustomResourceDefinitionSpec describes how a user wants their resource to appear
        :param Sequence['CustomResourceColumnDefinitionPatchArgs'] additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If present, this field configures columns for all versions. Top-level and per-version columns are mutually exclusive. If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        :param 'CustomResourceConversionPatchArgs' conversion: conversion defines conversion settings for the CRD.
        :param _builtins.str group: group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        :param 'CustomResourceDefinitionNamesPatchArgs' names: names specify the resource and kind names for the custom resource.
        :param _builtins.bool preserve_unknown_fields: preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. If false, schemas must be defined for all versions. Defaults to true in v1beta for backwards compatibility. Deprecated: will be required to be false in v1. Preservation of unknown fields can be specified in the validation schema using the `x-kubernetes-preserve-unknown-fields: true` extension. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
        :param _builtins.str scope: scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`. Default is `Namespaced`.
        :param 'CustomResourceSubresourcesPatchArgs' subresources: subresources specify what subresources the defined custom resource has. If present, this field configures subresources for all versions. Top-level and per-version subresources are mutually exclusive.
        :param 'CustomResourceValidationPatchArgs' validation: validation describes the schema used for validation and pruning of the custom resource. If present, this validation schema is used to validate all versions. Top-level and per-version schemas are mutually exclusive.
        :param _builtins.str version: version is the API version of the defined custom resource. The custom resources are served under `/apis/<group>/<version>/...`. Must match the name of the first item in the `versions` list if `version` and `versions` are both specified. Optional if `versions` is specified. Deprecated: use `versions` instead.
        :param Sequence['CustomResourceDefinitionVersionPatchArgs'] versions: versions is the list of all API versions of the defined custom resource. Optional if `version` is specified. The name of the first item in the `versions` list must match the `version` field if `version` and `versions` are both specified. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        if additional_printer_columns is not None:
            pulumi.set(__self__, "additional_printer_columns", additional_printer_columns)
        if conversion is not None:
            pulumi.set(__self__, "conversion", conversion)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if preserve_unknown_fields is not None:
            pulumi.set(__self__, "preserve_unknown_fields", preserve_unknown_fields)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if subresources is not None:
            pulumi.set(__self__, "subresources", subresources)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="additionalPrinterColumns")
    def additional_printer_columns(self) -> Optional[Sequence['outputs.CustomResourceColumnDefinitionPatch']]:
        """
        additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If present, this field configures columns for all versions. Top-level and per-version columns are mutually exclusive. If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        """
        return pulumi.get(self, "additional_printer_columns")

    @_builtins.property
    @pulumi.getter
    def conversion(self) -> Optional['outputs.CustomResourceConversionPatch']:
        """
        conversion defines conversion settings for the CRD.
        """
        return pulumi.get(self, "conversion")

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Optional['outputs.CustomResourceDefinitionNamesPatch']:
        """
        names specify the resource and kind names for the custom resource.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="preserveUnknownFields")
    def preserve_unknown_fields(self) -> Optional[_builtins.bool]:
        """
        preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. If false, schemas must be defined for all versions. Defaults to true in v1beta for backwards compatibility. Deprecated: will be required to be false in v1. Preservation of unknown fields can be specified in the validation schema using the `x-kubernetes-preserve-unknown-fields: true` extension. See https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/#pruning-versus-preserving-unknown-fields for details.
        """
        return pulumi.get(self, "preserve_unknown_fields")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`. Default is `Namespaced`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def subresources(self) -> Optional['outputs.CustomResourceSubresourcesPatch']:
        """
        subresources specify what subresources the defined custom resource has. If present, this field configures subresources for all versions. Top-level and per-version subresources are mutually exclusive.
        """
        return pulumi.get(self, "subresources")

    @_builtins.property
    @pulumi.getter
    def validation(self) -> Optional['outputs.CustomResourceValidationPatch']:
        """
        validation describes the schema used for validation and pruning of the custom resource. If present, this validation schema is used to validate all versions. Top-level and per-version schemas are mutually exclusive.
        """
        return pulumi.get(self, "validation")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        version is the API version of the defined custom resource. The custom resources are served under `/apis/<group>/<version>/...`. Must match the name of the first item in the `versions` list if `version` and `versions` are both specified. Optional if `versions` is specified. Deprecated: use `versions` instead.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionVersionPatch']]:
        """
        versions is the list of all API versions of the defined custom resource. Optional if `version` is specified. The name of the first item in the `versions` list must match the `version` field if `version` and `versions` are both specified. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class CustomResourceDefinitionStatus(dict):
    """
    CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptedNames":
            suggest = "accepted_names"
        elif key == "storedVersions":
            suggest = "stored_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accepted_names: 'outputs.CustomResourceDefinitionNames',
                 stored_versions: Sequence[_builtins.str],
                 conditions: Optional[Sequence['outputs.CustomResourceDefinitionCondition']] = None):
        """
        CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
        :param 'CustomResourceDefinitionNamesArgs' accepted_names: acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        :param Sequence[_builtins.str] stored_versions: storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        :param Sequence['CustomResourceDefinitionConditionArgs'] conditions: conditions indicate state for particular aspects of a CustomResourceDefinition
        """
        pulumi.set(__self__, "accepted_names", accepted_names)
        pulumi.set(__self__, "stored_versions", stored_versions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter(name="acceptedNames")
    def accepted_names(self) -> 'outputs.CustomResourceDefinitionNames':
        """
        acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        """
        return pulumi.get(self, "accepted_names")

    @_builtins.property
    @pulumi.getter(name="storedVersions")
    def stored_versions(self) -> Sequence[_builtins.str]:
        """
        storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        """
        return pulumi.get(self, "stored_versions")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionCondition']]:
        """
        conditions indicate state for particular aspects of a CustomResourceDefinition
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class CustomResourceDefinitionStatusPatch(dict):
    """
    CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptedNames":
            suggest = "accepted_names"
        elif key == "storedVersions":
            suggest = "stored_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accepted_names: Optional['outputs.CustomResourceDefinitionNamesPatch'] = None,
                 conditions: Optional[Sequence['outputs.CustomResourceDefinitionConditionPatch']] = None,
                 stored_versions: Optional[Sequence[_builtins.str]] = None):
        """
        CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
        :param 'CustomResourceDefinitionNamesPatchArgs' accepted_names: acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        :param Sequence['CustomResourceDefinitionConditionPatchArgs'] conditions: conditions indicate state for particular aspects of a CustomResourceDefinition
        :param Sequence[_builtins.str] stored_versions: storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        """
        if accepted_names is not None:
            pulumi.set(__self__, "accepted_names", accepted_names)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if stored_versions is not None:
            pulumi.set(__self__, "stored_versions", stored_versions)

    @_builtins.property
    @pulumi.getter(name="acceptedNames")
    def accepted_names(self) -> Optional['outputs.CustomResourceDefinitionNamesPatch']:
        """
        acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        """
        return pulumi.get(self, "accepted_names")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionConditionPatch']]:
        """
        conditions indicate state for particular aspects of a CustomResourceDefinition
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="storedVersions")
    def stored_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        """
        return pulumi.get(self, "stored_versions")


@pulumi.output_type
class CustomResourceDefinitionVersion(dict):
    """
    CustomResourceDefinitionVersion describes a version for CRD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalPrinterColumns":
            suggest = "additional_printer_columns"
        elif key == "deprecationWarning":
            suggest = "deprecation_warning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 served: _builtins.bool,
                 storage: _builtins.bool,
                 additional_printer_columns: Optional[Sequence['outputs.CustomResourceColumnDefinition']] = None,
                 deprecated: Optional[_builtins.bool] = None,
                 deprecation_warning: Optional[_builtins.str] = None,
                 schema: Optional['outputs.CustomResourceValidation'] = None,
                 subresources: Optional['outputs.CustomResourceSubresources'] = None):
        """
        CustomResourceDefinitionVersion describes a version for CRD.
        :param _builtins.str name: name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        :param _builtins.bool served: served is a flag enabling/disabling this version from being served via REST APIs
        :param _builtins.bool storage: storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        :param Sequence['CustomResourceColumnDefinitionArgs'] additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead). If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        :param _builtins.bool deprecated: deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        :param _builtins.str deprecation_warning: deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        :param 'CustomResourceValidationArgs' schema: schema describes the schema used for validation and pruning of this version of the custom resource. Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead).
        :param 'CustomResourceSubresourcesArgs' subresources: subresources specify what subresources this version of the defined custom resource have. Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "served", served)
        pulumi.set(__self__, "storage", storage)
        if additional_printer_columns is not None:
            pulumi.set(__self__, "additional_printer_columns", additional_printer_columns)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if deprecation_warning is not None:
            pulumi.set(__self__, "deprecation_warning", deprecation_warning)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if subresources is not None:
            pulumi.set(__self__, "subresources", subresources)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def served(self) -> _builtins.bool:
        """
        served is a flag enabling/disabling this version from being served via REST APIs
        """
        return pulumi.get(self, "served")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.bool:
        """
        storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter(name="additionalPrinterColumns")
    def additional_printer_columns(self) -> Optional[Sequence['outputs.CustomResourceColumnDefinition']]:
        """
        additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead). If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        """
        return pulumi.get(self, "additional_printer_columns")

    @_builtins.property
    @pulumi.getter
    def deprecated(self) -> Optional[_builtins.bool]:
        """
        deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        """
        return pulumi.get(self, "deprecated")

    @_builtins.property
    @pulumi.getter(name="deprecationWarning")
    def deprecation_warning(self) -> Optional[_builtins.str]:
        """
        deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        """
        return pulumi.get(self, "deprecation_warning")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional['outputs.CustomResourceValidation']:
        """
        schema describes the schema used for validation and pruning of this version of the custom resource. Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead).
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter
    def subresources(self) -> Optional['outputs.CustomResourceSubresources']:
        """
        subresources specify what subresources this version of the defined custom resource have. Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead).
        """
        return pulumi.get(self, "subresources")


@pulumi.output_type
class CustomResourceDefinitionVersionPatch(dict):
    """
    CustomResourceDefinitionVersion describes a version for CRD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalPrinterColumns":
            suggest = "additional_printer_columns"
        elif key == "deprecationWarning":
            suggest = "deprecation_warning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionVersionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionVersionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionVersionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_printer_columns: Optional[Sequence['outputs.CustomResourceColumnDefinitionPatch']] = None,
                 deprecated: Optional[_builtins.bool] = None,
                 deprecation_warning: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 schema: Optional['outputs.CustomResourceValidationPatch'] = None,
                 served: Optional[_builtins.bool] = None,
                 storage: Optional[_builtins.bool] = None,
                 subresources: Optional['outputs.CustomResourceSubresourcesPatch'] = None):
        """
        CustomResourceDefinitionVersion describes a version for CRD.
        :param Sequence['CustomResourceColumnDefinitionPatchArgs'] additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead). If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        :param _builtins.bool deprecated: deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        :param _builtins.str deprecation_warning: deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        :param _builtins.str name: name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        :param 'CustomResourceValidationPatchArgs' schema: schema describes the schema used for validation and pruning of this version of the custom resource. Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead).
        :param _builtins.bool served: served is a flag enabling/disabling this version from being served via REST APIs
        :param _builtins.bool storage: storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        :param 'CustomResourceSubresourcesPatchArgs' subresources: subresources specify what subresources this version of the defined custom resource have. Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead).
        """
        if additional_printer_columns is not None:
            pulumi.set(__self__, "additional_printer_columns", additional_printer_columns)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if deprecation_warning is not None:
            pulumi.set(__self__, "deprecation_warning", deprecation_warning)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if served is not None:
            pulumi.set(__self__, "served", served)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if subresources is not None:
            pulumi.set(__self__, "subresources", subresources)

    @_builtins.property
    @pulumi.getter(name="additionalPrinterColumns")
    def additional_printer_columns(self) -> Optional[Sequence['outputs.CustomResourceColumnDefinitionPatch']]:
        """
        additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead). If no top-level or per-version columns are specified, a single column displaying the age of the custom resource is used.
        """
        return pulumi.get(self, "additional_printer_columns")

    @_builtins.property
    @pulumi.getter
    def deprecated(self) -> Optional[_builtins.bool]:
        """
        deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        """
        return pulumi.get(self, "deprecated")

    @_builtins.property
    @pulumi.getter(name="deprecationWarning")
    def deprecation_warning(self) -> Optional[_builtins.str]:
        """
        deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        """
        return pulumi.get(self, "deprecation_warning")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional['outputs.CustomResourceValidationPatch']:
        """
        schema describes the schema used for validation and pruning of this version of the custom resource. Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead).
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter
    def served(self) -> Optional[_builtins.bool]:
        """
        served is a flag enabling/disabling this version from being served via REST APIs
        """
        return pulumi.get(self, "served")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[_builtins.bool]:
        """
        storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def subresources(self) -> Optional['outputs.CustomResourceSubresourcesPatch']:
        """
        subresources specify what subresources this version of the defined custom resource have. Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead).
        """
        return pulumi.get(self, "subresources")


@pulumi.output_type
class CustomResourceSubresourceScale(dict):
    """
    CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "specReplicasPath":
            suggest = "spec_replicas_path"
        elif key == "statusReplicasPath":
            suggest = "status_replicas_path"
        elif key == "labelSelectorPath":
            suggest = "label_selector_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceSubresourceScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceSubresourceScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceSubresourceScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec_replicas_path: _builtins.str,
                 status_replicas_path: _builtins.str,
                 label_selector_path: Optional[_builtins.str] = None):
        """
        CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
        :param _builtins.str spec_replicas_path: specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        :param _builtins.str status_replicas_path: statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        :param _builtins.str label_selector_path: labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        """
        pulumi.set(__self__, "spec_replicas_path", spec_replicas_path)
        pulumi.set(__self__, "status_replicas_path", status_replicas_path)
        if label_selector_path is not None:
            pulumi.set(__self__, "label_selector_path", label_selector_path)

    @_builtins.property
    @pulumi.getter(name="specReplicasPath")
    def spec_replicas_path(self) -> _builtins.str:
        """
        specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        """
        return pulumi.get(self, "spec_replicas_path")

    @_builtins.property
    @pulumi.getter(name="statusReplicasPath")
    def status_replicas_path(self) -> _builtins.str:
        """
        statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        """
        return pulumi.get(self, "status_replicas_path")

    @_builtins.property
    @pulumi.getter(name="labelSelectorPath")
    def label_selector_path(self) -> Optional[_builtins.str]:
        """
        labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        """
        return pulumi.get(self, "label_selector_path")


@pulumi.output_type
class CustomResourceSubresourceScalePatch(dict):
    """
    CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelectorPath":
            suggest = "label_selector_path"
        elif key == "specReplicasPath":
            suggest = "spec_replicas_path"
        elif key == "statusReplicasPath":
            suggest = "status_replicas_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceSubresourceScalePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceSubresourceScalePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceSubresourceScalePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_selector_path: Optional[_builtins.str] = None,
                 spec_replicas_path: Optional[_builtins.str] = None,
                 status_replicas_path: Optional[_builtins.str] = None):
        """
        CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
        :param _builtins.str label_selector_path: labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        :param _builtins.str spec_replicas_path: specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        :param _builtins.str status_replicas_path: statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        """
        if label_selector_path is not None:
            pulumi.set(__self__, "label_selector_path", label_selector_path)
        if spec_replicas_path is not None:
            pulumi.set(__self__, "spec_replicas_path", spec_replicas_path)
        if status_replicas_path is not None:
            pulumi.set(__self__, "status_replicas_path", status_replicas_path)

    @_builtins.property
    @pulumi.getter(name="labelSelectorPath")
    def label_selector_path(self) -> Optional[_builtins.str]:
        """
        labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        """
        return pulumi.get(self, "label_selector_path")

    @_builtins.property
    @pulumi.getter(name="specReplicasPath")
    def spec_replicas_path(self) -> Optional[_builtins.str]:
        """
        specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        """
        return pulumi.get(self, "spec_replicas_path")

    @_builtins.property
    @pulumi.getter(name="statusReplicasPath")
    def status_replicas_path(self) -> Optional[_builtins.str]:
        """
        statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        """
        return pulumi.get(self, "status_replicas_path")


@pulumi.output_type
class CustomResourceSubresources(dict):
    """
    CustomResourceSubresources defines the status and scale subresources for CustomResources.
    """
    def __init__(__self__, *,
                 scale: Optional['outputs.CustomResourceSubresourceScale'] = None,
                 status: Optional[Any] = None):
        """
        CustomResourceSubresources defines the status and scale subresources for CustomResources.
        :param 'CustomResourceSubresourceScaleArgs' scale: scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        :param Any status: status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def scale(self) -> Optional['outputs.CustomResourceSubresourceScale']:
        """
        scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        """
        return pulumi.get(self, "scale")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[Any]:
        """
        status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomResourceSubresourcesPatch(dict):
    """
    CustomResourceSubresources defines the status and scale subresources for CustomResources.
    """
    def __init__(__self__, *,
                 scale: Optional['outputs.CustomResourceSubresourceScalePatch'] = None,
                 status: Optional[Any] = None):
        """
        CustomResourceSubresources defines the status and scale subresources for CustomResources.
        :param 'CustomResourceSubresourceScalePatchArgs' scale: scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        :param Any status: status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def scale(self) -> Optional['outputs.CustomResourceSubresourceScalePatch']:
        """
        scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        """
        return pulumi.get(self, "scale")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[Any]:
        """
        status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomResourceValidation(dict):
    """
    CustomResourceValidation is a list of validation methods for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openAPIV3Schema":
            suggest = "open_apiv3_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceValidation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceValidation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceValidation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_apiv3_schema: Optional['outputs.JSONSchemaProps'] = None):
        """
        CustomResourceValidation is a list of validation methods for CustomResources.
        :param 'JSONSchemaPropsArgs' open_apiv3_schema: openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        if open_apiv3_schema is not None:
            pulumi.set(__self__, "open_apiv3_schema", open_apiv3_schema)

    @_builtins.property
    @pulumi.getter(name="openAPIV3Schema")
    def open_apiv3_schema(self) -> Optional['outputs.JSONSchemaProps']:
        """
        openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        return pulumi.get(self, "open_apiv3_schema")


@pulumi.output_type
class CustomResourceValidationPatch(dict):
    """
    CustomResourceValidation is a list of validation methods for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openAPIV3Schema":
            suggest = "open_apiv3_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceValidationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceValidationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceValidationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_apiv3_schema: Optional['outputs.JSONSchemaPropsPatch'] = None):
        """
        CustomResourceValidation is a list of validation methods for CustomResources.
        :param 'JSONSchemaPropsPatchArgs' open_apiv3_schema: openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        if open_apiv3_schema is not None:
            pulumi.set(__self__, "open_apiv3_schema", open_apiv3_schema)

    @_builtins.property
    @pulumi.getter(name="openAPIV3Schema")
    def open_apiv3_schema(self) -> Optional['outputs.JSONSchemaPropsPatch']:
        """
        openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        return pulumi.get(self, "open_apiv3_schema")


@pulumi.output_type
class ExternalDocumentation(dict):
    """
    ExternalDocumentation allows referencing an external resource for extended documentation.
    """
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        ExternalDocumentation allows referencing an external resource for extended documentation.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class ExternalDocumentationPatch(dict):
    """
    ExternalDocumentation allows referencing an external resource for extended documentation.
    """
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        ExternalDocumentation allows referencing an external resource for extended documentation.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class JSONSchemaProps(dict):
    """
    JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "$ref":
            suggest = "_ref"
        elif key == "$schema":
            suggest = "_schema"
        elif key == "additionalItems":
            suggest = "additional_items"
        elif key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "allOf":
            suggest = "all_of"
        elif key == "anyOf":
            suggest = "any_of"
        elif key == "exclusiveMaximum":
            suggest = "exclusive_maximum"
        elif key == "exclusiveMinimum":
            suggest = "exclusive_minimum"
        elif key == "externalDocs":
            suggest = "external_docs"
        elif key == "maxItems":
            suggest = "max_items"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "maxProperties":
            suggest = "max_properties"
        elif key == "minItems":
            suggest = "min_items"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "minProperties":
            suggest = "min_properties"
        elif key == "multipleOf":
            suggest = "multiple_of"
        elif key == "not":
            suggest = "not_"
        elif key == "oneOf":
            suggest = "one_of"
        elif key == "patternProperties":
            suggest = "pattern_properties"
        elif key == "uniqueItems":
            suggest = "unique_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JSONSchemaProps. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JSONSchemaProps.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JSONSchemaProps.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 _ref: Optional[_builtins.str] = None,
                 _schema: Optional[_builtins.str] = None,
                 additional_items: Optional[Any] = None,
                 additional_properties: Optional[Any] = None,
                 all_of: Optional[Sequence['outputs.JSONSchemaProps']] = None,
                 any_of: Optional[Sequence['outputs.JSONSchemaProps']] = None,
                 default: Optional[Any] = None,
                 definitions: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 dependencies: Optional[Mapping[str, Any]] = None,
                 description: Optional[_builtins.str] = None,
                 enum: Optional[Sequence[Any]] = None,
                 example: Optional[Any] = None,
                 exclusive_maximum: Optional[_builtins.bool] = None,
                 exclusive_minimum: Optional[_builtins.bool] = None,
                 external_docs: Optional['outputs.ExternalDocumentation'] = None,
                 format: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 items: Optional[Any] = None,
                 max_items: Optional[_builtins.int] = None,
                 max_length: Optional[_builtins.int] = None,
                 max_properties: Optional[_builtins.int] = None,
                 maximum: Optional[_builtins.float] = None,
                 min_items: Optional[_builtins.int] = None,
                 min_length: Optional[_builtins.int] = None,
                 min_properties: Optional[_builtins.int] = None,
                 minimum: Optional[_builtins.float] = None,
                 multiple_of: Optional[_builtins.float] = None,
                 not_: Optional['outputs.JSONSchemaProps'] = None,
                 nullable: Optional[_builtins.bool] = None,
                 one_of: Optional[Sequence['outputs.JSONSchemaProps']] = None,
                 pattern: Optional[_builtins.str] = None,
                 pattern_properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 required: Optional[Sequence[_builtins.str]] = None,
                 title: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 unique_items: Optional[_builtins.bool] = None,
                 x_kubernetes_embedded_resource: Optional[_builtins.bool] = None,
                 x_kubernetes_int_or_string: Optional[_builtins.bool] = None,
                 x_kubernetes_list_map_keys: Optional[Sequence[_builtins.str]] = None,
                 x_kubernetes_list_type: Optional[_builtins.str] = None,
                 x_kubernetes_map_type: Optional[_builtins.str] = None,
                 x_kubernetes_preserve_unknown_fields: Optional[_builtins.bool] = None):
        """
        JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
        :param Any default: default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. CustomResourceDefinitions with defaults must be created using the v1 (or newer) CustomResourceDefinition API.
        :param _builtins.str format: format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:
               
               - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        :param _builtins.bool x_kubernetes_embedded_resource: x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        :param _builtins.bool x_kubernetes_int_or_string: x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:
               
               1) anyOf:
                  - type: integer
                  - type: string
               2) allOf:
                  - anyOf:
                    - type: integer
                    - type: string
                  - ... zero or more
        :param Sequence[_builtins.str] x_kubernetes_list_map_keys: x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.
               
               This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).
        :param _builtins.str x_kubernetes_list_type: x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:
               
               1) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic lists will be entirely replaced when updated. This extension
                    may be used on any type of list (struct, scalar, ...).
               2) `set`:
                    Sets are lists that must not have multiple items with the same value. Each
                    value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
                    array with x-kubernetes-list-type `atomic`.
               3) `map`:
                    These lists are like maps in that their elements have a non-index key
                    used to identify them. Order is preserved upon merge. The map tag
                    must only be used on a list with elements of type object.
               Defaults to atomic for arrays.
        :param _builtins.str x_kubernetes_map_type: x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:
               
               1) `granular`:
                    These maps are actual maps (key-value pairs) and each fields are independent
                    from each other (they can each be manipulated by separate actors). This is
                    the default behaviour for all maps.
               2) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic maps will be entirely replaced when updated.
        :param _builtins.bool x_kubernetes_preserve_unknown_fields: x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        """
        if _ref is not None:
            pulumi.set(__self__, "_ref", _ref)
        if _schema is not None:
            pulumi.set(__self__, "_schema", _schema)
        if additional_items is not None:
            pulumi.set(__self__, "additional_items", additional_items)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum is not None:
            pulumi.set(__self__, "enum", enum)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if exclusive_maximum is not None:
            pulumi.set(__self__, "exclusive_maximum", exclusive_maximum)
        if exclusive_minimum is not None:
            pulumi.set(__self__, "exclusive_minimum", exclusive_minimum)
        if external_docs is not None:
            pulumi.set(__self__, "external_docs", external_docs)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if max_items is not None:
            pulumi.set(__self__, "max_items", max_items)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_properties is not None:
            pulumi.set(__self__, "max_properties", max_properties)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_items is not None:
            pulumi.set(__self__, "min_items", min_items)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_properties is not None:
            pulumi.set(__self__, "min_properties", min_properties)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if multiple_of is not None:
            pulumi.set(__self__, "multiple_of", multiple_of)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if one_of is not None:
            pulumi.set(__self__, "one_of", one_of)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_properties is not None:
            pulumi.set(__self__, "pattern_properties", pattern_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unique_items is not None:
            pulumi.set(__self__, "unique_items", unique_items)
        if x_kubernetes_embedded_resource is not None:
            pulumi.set(__self__, "x_kubernetes_embedded_resource", x_kubernetes_embedded_resource)
        if x_kubernetes_int_or_string is not None:
            pulumi.set(__self__, "x_kubernetes_int_or_string", x_kubernetes_int_or_string)
        if x_kubernetes_list_map_keys is not None:
            pulumi.set(__self__, "x_kubernetes_list_map_keys", x_kubernetes_list_map_keys)
        if x_kubernetes_list_type is not None:
            pulumi.set(__self__, "x_kubernetes_list_type", x_kubernetes_list_type)
        if x_kubernetes_map_type is not None:
            pulumi.set(__self__, "x_kubernetes_map_type", x_kubernetes_map_type)
        if x_kubernetes_preserve_unknown_fields is not None:
            pulumi.set(__self__, "x_kubernetes_preserve_unknown_fields", x_kubernetes_preserve_unknown_fields)

    @_builtins.property
    @pulumi.getter(name="$ref")
    def _ref(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "_ref")

    @_builtins.property
    @pulumi.getter(name="$schema")
    def _schema(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "_schema")

    @_builtins.property
    @pulumi.getter(name="additionalItems")
    def additional_items(self) -> Optional[Any]:
        return pulumi.get(self, "additional_items")

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[Any]:
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.JSONSchemaProps']]:
        return pulumi.get(self, "all_of")

    @_builtins.property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[Sequence['outputs.JSONSchemaProps']]:
        return pulumi.get(self, "any_of")

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[Any]:
        """
        default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. CustomResourceDefinitions with defaults must be created using the v1 (or newer) CustomResourceDefinition API.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def definitions(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "definitions")

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dependencies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enum(self) -> Optional[Sequence[Any]]:
        return pulumi.get(self, "enum")

    @_builtins.property
    @pulumi.getter
    def example(self) -> Optional[Any]:
        return pulumi.get(self, "example")

    @_builtins.property
    @pulumi.getter(name="exclusiveMaximum")
    def exclusive_maximum(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "exclusive_maximum")

    @_builtins.property
    @pulumi.getter(name="exclusiveMinimum")
    def exclusive_minimum(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "exclusive_minimum")

    @_builtins.property
    @pulumi.getter(name="externalDocs")
    def external_docs(self) -> Optional['outputs.ExternalDocumentation']:
        return pulumi.get(self, "external_docs")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:

        - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Any]:
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_length")

    @_builtins.property
    @pulumi.getter(name="maxProperties")
    def max_properties(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_properties")

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "maximum")

    @_builtins.property
    @pulumi.getter(name="minItems")
    def min_items(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "min_items")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="minProperties")
    def min_properties(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "min_properties")

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "minimum")

    @_builtins.property
    @pulumi.getter(name="multipleOf")
    def multiple_of(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "multiple_of")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.JSONSchemaProps']:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def nullable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "nullable")

    @_builtins.property
    @pulumi.getter(name="oneOf")
    def one_of(self) -> Optional[Sequence['outputs.JSONSchemaProps']]:
        return pulumi.get(self, "one_of")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="patternProperties")
    def pattern_properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "pattern_properties")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="uniqueItems")
    def unique_items(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "unique_items")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_embedded_resource(self) -> Optional[_builtins.bool]:
        """
        x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        """
        return pulumi.get(self, "x_kubernetes_embedded_resource")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_int_or_string(self) -> Optional[_builtins.bool]:
        """
        x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

        1) anyOf:
           - type: integer
           - type: string
        2) allOf:
           - anyOf:
             - type: integer
             - type: string
           - ... zero or more
        """
        return pulumi.get(self, "x_kubernetes_int_or_string")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_list_map_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.

        This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).
        """
        return pulumi.get(self, "x_kubernetes_list_map_keys")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_list_type(self) -> Optional[_builtins.str]:
        """
        x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:

        1) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic lists will be entirely replaced when updated. This extension
             may be used on any type of list (struct, scalar, ...).
        2) `set`:
             Sets are lists that must not have multiple items with the same value. Each
             value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
             array with x-kubernetes-list-type `atomic`.
        3) `map`:
             These lists are like maps in that their elements have a non-index key
             used to identify them. Order is preserved upon merge. The map tag
             must only be used on a list with elements of type object.
        Defaults to atomic for arrays.
        """
        return pulumi.get(self, "x_kubernetes_list_type")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_map_type(self) -> Optional[_builtins.str]:
        """
        x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:

        1) `granular`:
             These maps are actual maps (key-value pairs) and each fields are independent
             from each other (they can each be manipulated by separate actors). This is
             the default behaviour for all maps.
        2) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic maps will be entirely replaced when updated.
        """
        return pulumi.get(self, "x_kubernetes_map_type")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_preserve_unknown_fields(self) -> Optional[_builtins.bool]:
        """
        x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        """
        return pulumi.get(self, "x_kubernetes_preserve_unknown_fields")


@pulumi.output_type
class JSONSchemaPropsPatch(dict):
    """
    JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "$ref":
            suggest = "_ref"
        elif key == "$schema":
            suggest = "_schema"
        elif key == "additionalItems":
            suggest = "additional_items"
        elif key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "allOf":
            suggest = "all_of"
        elif key == "anyOf":
            suggest = "any_of"
        elif key == "exclusiveMaximum":
            suggest = "exclusive_maximum"
        elif key == "exclusiveMinimum":
            suggest = "exclusive_minimum"
        elif key == "externalDocs":
            suggest = "external_docs"
        elif key == "maxItems":
            suggest = "max_items"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "maxProperties":
            suggest = "max_properties"
        elif key == "minItems":
            suggest = "min_items"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "minProperties":
            suggest = "min_properties"
        elif key == "multipleOf":
            suggest = "multiple_of"
        elif key == "not":
            suggest = "not_"
        elif key == "oneOf":
            suggest = "one_of"
        elif key == "patternProperties":
            suggest = "pattern_properties"
        elif key == "uniqueItems":
            suggest = "unique_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JSONSchemaPropsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JSONSchemaPropsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JSONSchemaPropsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 _ref: Optional[_builtins.str] = None,
                 _schema: Optional[_builtins.str] = None,
                 additional_items: Optional[Any] = None,
                 additional_properties: Optional[Any] = None,
                 all_of: Optional[Sequence['outputs.JSONSchemaPropsPatch']] = None,
                 any_of: Optional[Sequence['outputs.JSONSchemaPropsPatch']] = None,
                 default: Optional[Any] = None,
                 definitions: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 dependencies: Optional[Mapping[str, Any]] = None,
                 description: Optional[_builtins.str] = None,
                 enum: Optional[Sequence[Any]] = None,
                 example: Optional[Any] = None,
                 exclusive_maximum: Optional[_builtins.bool] = None,
                 exclusive_minimum: Optional[_builtins.bool] = None,
                 external_docs: Optional['outputs.ExternalDocumentationPatch'] = None,
                 format: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 items: Optional[Any] = None,
                 max_items: Optional[_builtins.int] = None,
                 max_length: Optional[_builtins.int] = None,
                 max_properties: Optional[_builtins.int] = None,
                 maximum: Optional[_builtins.float] = None,
                 min_items: Optional[_builtins.int] = None,
                 min_length: Optional[_builtins.int] = None,
                 min_properties: Optional[_builtins.int] = None,
                 minimum: Optional[_builtins.float] = None,
                 multiple_of: Optional[_builtins.float] = None,
                 not_: Optional['outputs.JSONSchemaPropsPatch'] = None,
                 nullable: Optional[_builtins.bool] = None,
                 one_of: Optional[Sequence['outputs.JSONSchemaPropsPatch']] = None,
                 pattern: Optional[_builtins.str] = None,
                 pattern_properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 required: Optional[Sequence[_builtins.str]] = None,
                 title: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 unique_items: Optional[_builtins.bool] = None,
                 x_kubernetes_embedded_resource: Optional[_builtins.bool] = None,
                 x_kubernetes_int_or_string: Optional[_builtins.bool] = None,
                 x_kubernetes_list_map_keys: Optional[Sequence[_builtins.str]] = None,
                 x_kubernetes_list_type: Optional[_builtins.str] = None,
                 x_kubernetes_map_type: Optional[_builtins.str] = None,
                 x_kubernetes_preserve_unknown_fields: Optional[_builtins.bool] = None):
        """
        JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
        :param Any default: default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. CustomResourceDefinitions with defaults must be created using the v1 (or newer) CustomResourceDefinition API.
        :param _builtins.str format: format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:
               
               - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        :param _builtins.bool x_kubernetes_embedded_resource: x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        :param _builtins.bool x_kubernetes_int_or_string: x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:
               
               1) anyOf:
                  - type: integer
                  - type: string
               2) allOf:
                  - anyOf:
                    - type: integer
                    - type: string
                  - ... zero or more
        :param Sequence[_builtins.str] x_kubernetes_list_map_keys: x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.
               
               This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).
        :param _builtins.str x_kubernetes_list_type: x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:
               
               1) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic lists will be entirely replaced when updated. This extension
                    may be used on any type of list (struct, scalar, ...).
               2) `set`:
                    Sets are lists that must not have multiple items with the same value. Each
                    value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
                    array with x-kubernetes-list-type `atomic`.
               3) `map`:
                    These lists are like maps in that their elements have a non-index key
                    used to identify them. Order is preserved upon merge. The map tag
                    must only be used on a list with elements of type object.
               Defaults to atomic for arrays.
        :param _builtins.str x_kubernetes_map_type: x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:
               
               1) `granular`:
                    These maps are actual maps (key-value pairs) and each fields are independent
                    from each other (they can each be manipulated by separate actors). This is
                    the default behaviour for all maps.
               2) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic maps will be entirely replaced when updated.
        :param _builtins.bool x_kubernetes_preserve_unknown_fields: x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        """
        if _ref is not None:
            pulumi.set(__self__, "_ref", _ref)
        if _schema is not None:
            pulumi.set(__self__, "_schema", _schema)
        if additional_items is not None:
            pulumi.set(__self__, "additional_items", additional_items)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum is not None:
            pulumi.set(__self__, "enum", enum)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if exclusive_maximum is not None:
            pulumi.set(__self__, "exclusive_maximum", exclusive_maximum)
        if exclusive_minimum is not None:
            pulumi.set(__self__, "exclusive_minimum", exclusive_minimum)
        if external_docs is not None:
            pulumi.set(__self__, "external_docs", external_docs)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if max_items is not None:
            pulumi.set(__self__, "max_items", max_items)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_properties is not None:
            pulumi.set(__self__, "max_properties", max_properties)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_items is not None:
            pulumi.set(__self__, "min_items", min_items)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_properties is not None:
            pulumi.set(__self__, "min_properties", min_properties)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if multiple_of is not None:
            pulumi.set(__self__, "multiple_of", multiple_of)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if one_of is not None:
            pulumi.set(__self__, "one_of", one_of)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_properties is not None:
            pulumi.set(__self__, "pattern_properties", pattern_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unique_items is not None:
            pulumi.set(__self__, "unique_items", unique_items)
        if x_kubernetes_embedded_resource is not None:
            pulumi.set(__self__, "x_kubernetes_embedded_resource", x_kubernetes_embedded_resource)
        if x_kubernetes_int_or_string is not None:
            pulumi.set(__self__, "x_kubernetes_int_or_string", x_kubernetes_int_or_string)
        if x_kubernetes_list_map_keys is not None:
            pulumi.set(__self__, "x_kubernetes_list_map_keys", x_kubernetes_list_map_keys)
        if x_kubernetes_list_type is not None:
            pulumi.set(__self__, "x_kubernetes_list_type", x_kubernetes_list_type)
        if x_kubernetes_map_type is not None:
            pulumi.set(__self__, "x_kubernetes_map_type", x_kubernetes_map_type)
        if x_kubernetes_preserve_unknown_fields is not None:
            pulumi.set(__self__, "x_kubernetes_preserve_unknown_fields", x_kubernetes_preserve_unknown_fields)

    @_builtins.property
    @pulumi.getter(name="$ref")
    def _ref(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "_ref")

    @_builtins.property
    @pulumi.getter(name="$schema")
    def _schema(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "_schema")

    @_builtins.property
    @pulumi.getter(name="additionalItems")
    def additional_items(self) -> Optional[Any]:
        return pulumi.get(self, "additional_items")

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[Any]:
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.JSONSchemaPropsPatch']]:
        return pulumi.get(self, "all_of")

    @_builtins.property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[Sequence['outputs.JSONSchemaPropsPatch']]:
        return pulumi.get(self, "any_of")

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[Any]:
        """
        default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. CustomResourceDefinitions with defaults must be created using the v1 (or newer) CustomResourceDefinition API.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def definitions(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "definitions")

    @_builtins.property
    @pulumi.getter
    def dependencies(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dependencies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enum(self) -> Optional[Sequence[Any]]:
        return pulumi.get(self, "enum")

    @_builtins.property
    @pulumi.getter
    def example(self) -> Optional[Any]:
        return pulumi.get(self, "example")

    @_builtins.property
    @pulumi.getter(name="exclusiveMaximum")
    def exclusive_maximum(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "exclusive_maximum")

    @_builtins.property
    @pulumi.getter(name="exclusiveMinimum")
    def exclusive_minimum(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "exclusive_minimum")

    @_builtins.property
    @pulumi.getter(name="externalDocs")
    def external_docs(self) -> Optional['outputs.ExternalDocumentationPatch']:
        return pulumi.get(self, "external_docs")

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:

        - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Any]:
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_items")

    @_builtins.property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_length")

    @_builtins.property
    @pulumi.getter(name="maxProperties")
    def max_properties(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_properties")

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "maximum")

    @_builtins.property
    @pulumi.getter(name="minItems")
    def min_items(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "min_items")

    @_builtins.property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "min_length")

    @_builtins.property
    @pulumi.getter(name="minProperties")
    def min_properties(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "min_properties")

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "minimum")

    @_builtins.property
    @pulumi.getter(name="multipleOf")
    def multiple_of(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "multiple_of")

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.JSONSchemaPropsPatch']:
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter
    def nullable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "nullable")

    @_builtins.property
    @pulumi.getter(name="oneOf")
    def one_of(self) -> Optional[Sequence['outputs.JSONSchemaPropsPatch']]:
        return pulumi.get(self, "one_of")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter(name="patternProperties")
    def pattern_properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "pattern_properties")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="uniqueItems")
    def unique_items(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "unique_items")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_embedded_resource(self) -> Optional[_builtins.bool]:
        """
        x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        """
        return pulumi.get(self, "x_kubernetes_embedded_resource")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_int_or_string(self) -> Optional[_builtins.bool]:
        """
        x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

        1) anyOf:
           - type: integer
           - type: string
        2) allOf:
           - anyOf:
             - type: integer
             - type: string
           - ... zero or more
        """
        return pulumi.get(self, "x_kubernetes_int_or_string")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_list_map_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.

        This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).
        """
        return pulumi.get(self, "x_kubernetes_list_map_keys")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_list_type(self) -> Optional[_builtins.str]:
        """
        x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:

        1) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic lists will be entirely replaced when updated. This extension
             may be used on any type of list (struct, scalar, ...).
        2) `set`:
             Sets are lists that must not have multiple items with the same value. Each
             value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
             array with x-kubernetes-list-type `atomic`.
        3) `map`:
             These lists are like maps in that their elements have a non-index key
             used to identify them. Order is preserved upon merge. The map tag
             must only be used on a list with elements of type object.
        Defaults to atomic for arrays.
        """
        return pulumi.get(self, "x_kubernetes_list_type")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_map_type(self) -> Optional[_builtins.str]:
        """
        x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:

        1) `granular`:
             These maps are actual maps (key-value pairs) and each fields are independent
             from each other (they can each be manipulated by separate actors). This is
             the default behaviour for all maps.
        2) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic maps will be entirely replaced when updated.
        """
        return pulumi.get(self, "x_kubernetes_map_type")

    @_builtins.property
    @pulumi.getter
    def x_kubernetes_preserve_unknown_fields(self) -> Optional[_builtins.bool]:
        """
        x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        """
        return pulumi.get(self, "x_kubernetes_preserve_unknown_fields")


@pulumi.output_type
class ServiceReference(dict):
    """
    ServiceReference holds a reference to Service.legacy.k8s.io
    """
    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        ServiceReference holds a reference to Service.legacy.k8s.io
        :param _builtins.str name: name is the name of the service. Required
        :param _builtins.str namespace: namespace is the namespace of the service. Required
        :param _builtins.str path: path is an optional URL path at which the webhook will be contacted.
        :param _builtins.int port: port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the service. Required
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        namespace is the namespace of the service. Required
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is an optional URL path at which the webhook will be contacted.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceReferencePatch(dict):
    """
    ServiceReference holds a reference to Service.legacy.k8s.io
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        ServiceReference holds a reference to Service.legacy.k8s.io
        :param _builtins.str name: name is the name of the service. Required
        :param _builtins.str namespace: namespace is the namespace of the service. Required
        :param _builtins.str path: path is an optional URL path at which the webhook will be contacted.
        :param _builtins.int port: port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the service. Required
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        namespace is the namespace of the service. Required
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is an optional URL path at which the webhook will be contacted.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class WebhookClientConfig(dict):
    """
    WebhookClientConfig contains the information to make a TLS connection with the webhook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caBundle":
            suggest = "ca_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookClientConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookClientConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookClientConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_bundle: Optional[_builtins.str] = None,
                 service: Optional['outputs.ServiceReference'] = None,
                 url: Optional[_builtins.str] = None):
        """
        WebhookClientConfig contains the information to make a TLS connection with the webhook.
        :param _builtins.str ca_bundle: caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        :param 'ServiceReferenceArgs' service: service is a reference to the service for this webhook. Either service or url must be specified.
               
               If the webhook is running within the cluster, then you should use `service`.
        :param _builtins.str url: url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
               
               The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
               
               Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
               
               The scheme must be "https"; the URL must begin with "https://".
               
               A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
               
               Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        if ca_bundle is not None:
            pulumi.set(__self__, "ca_bundle", ca_bundle)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> Optional[_builtins.str]:
        """
        caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        """
        return pulumi.get(self, "ca_bundle")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional['outputs.ServiceReference']:
        """
        service is a reference to the service for this webhook. Either service or url must be specified.

        If the webhook is running within the cluster, then you should use `service`.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

        The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

        The scheme must be "https"; the URL must begin with "https://".

        A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

        Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class WebhookClientConfigPatch(dict):
    """
    WebhookClientConfig contains the information to make a TLS connection with the webhook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caBundle":
            suggest = "ca_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookClientConfigPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookClientConfigPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookClientConfigPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_bundle: Optional[_builtins.str] = None,
                 service: Optional['outputs.ServiceReferencePatch'] = None,
                 url: Optional[_builtins.str] = None):
        """
        WebhookClientConfig contains the information to make a TLS connection with the webhook.
        :param _builtins.str ca_bundle: caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        :param 'ServiceReferencePatchArgs' service: service is a reference to the service for this webhook. Either service or url must be specified.
               
               If the webhook is running within the cluster, then you should use `service`.
        :param _builtins.str url: url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
               
               The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
               
               Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
               
               The scheme must be "https"; the URL must begin with "https://".
               
               A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
               
               Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        if ca_bundle is not None:
            pulumi.set(__self__, "ca_bundle", ca_bundle)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> Optional[_builtins.str]:
        """
        caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        """
        return pulumi.get(self, "ca_bundle")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional['outputs.ServiceReferencePatch']:
        """
        service is a reference to the service for this webhook. Either service or url must be specified.

        If the webhook is running within the cluster, then you should use `service`.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

        The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

        The scheme must be "https"; the URL must begin with "https://".

        A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

        Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        return pulumi.get(self, "url")


