# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'ContainerResourceMetricSource',
    'ContainerResourceMetricSourcePatch',
    'ContainerResourceMetricStatus',
    'ContainerResourceMetricStatusPatch',
    'CrossVersionObjectReference',
    'CrossVersionObjectReferencePatch',
    'ExternalMetricSource',
    'ExternalMetricSourcePatch',
    'ExternalMetricStatus',
    'ExternalMetricStatusPatch',
    'HPAScalingPolicy',
    'HPAScalingPolicyPatch',
    'HPAScalingRules',
    'HPAScalingRulesPatch',
    'HorizontalPodAutoscaler',
    'HorizontalPodAutoscalerBehavior',
    'HorizontalPodAutoscalerBehaviorPatch',
    'HorizontalPodAutoscalerCondition',
    'HorizontalPodAutoscalerConditionPatch',
    'HorizontalPodAutoscalerSpec',
    'HorizontalPodAutoscalerSpecPatch',
    'HorizontalPodAutoscalerStatus',
    'HorizontalPodAutoscalerStatusPatch',
    'MetricIdentifier',
    'MetricIdentifierPatch',
    'MetricSpec',
    'MetricSpecPatch',
    'MetricStatus',
    'MetricStatusPatch',
    'MetricTarget',
    'MetricTargetPatch',
    'MetricValueStatus',
    'MetricValueStatusPatch',
    'ObjectMetricSource',
    'ObjectMetricSourcePatch',
    'ObjectMetricStatus',
    'ObjectMetricStatusPatch',
    'PodsMetricSource',
    'PodsMetricSourcePatch',
    'PodsMetricStatus',
    'PodsMetricStatusPatch',
    'ResourceMetricSource',
    'ResourceMetricSourcePatch',
    'ResourceMetricStatus',
    'ResourceMetricStatusPatch',
]

@pulumi.output_type
class ContainerResourceMetricSource(dict):
    """
    ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
    """
    def __init__(__self__, *,
                 container: _builtins.str,
                 name: _builtins.str,
                 target: 'outputs.MetricTarget'):
        """
        ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param _builtins.str container: container is the name of the container in the pods of the scaling target
        :param _builtins.str name: name is the name of the resource in question.
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def container(self) -> _builtins.str:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ContainerResourceMetricSourcePatch(dict):
    """
    ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
    """
    def __init__(__self__, *,
                 container: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 target: Optional['outputs.MetricTargetPatch'] = None):
        """
        ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param _builtins.str container: container is the name of the container in the pods of the scaling target
        :param _builtins.str name: name is the name of the resource in question.
        :param 'MetricTargetPatchArgs' target: target specifies the target value for the given metric
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional[_builtins.str]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional['outputs.MetricTargetPatch']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ContainerResourceMetricStatus(dict):
    """
    ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    def __init__(__self__, *,
                 container: _builtins.str,
                 current: 'outputs.MetricValueStatus',
                 name: _builtins.str):
        """
        ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param _builtins.str container: container is the name of the container in the pods of the scaling target
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param _builtins.str name: name is the name of the resource in question.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def container(self) -> _builtins.str:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerResourceMetricStatusPatch(dict):
    """
    ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    def __init__(__self__, *,
                 container: Optional[_builtins.str] = None,
                 current: Optional['outputs.MetricValueStatusPatch'] = None,
                 name: Optional[_builtins.str] = None):
        """
        ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param _builtins.str container: container is the name of the container in the pods of the scaling target
        :param 'MetricValueStatusPatchArgs' current: current contains the current value for the given metric
        :param _builtins.str name: name is the name of the resource in question.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if current is not None:
            pulumi.set(__self__, "current", current)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional[_builtins.str]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional['outputs.MetricValueStatusPatch']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CrossVersionObjectReference(dict):
    """
    CrossVersionObjectReference contains enough information to let you identify the referred resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossVersionObjectReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossVersionObjectReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossVersionObjectReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: _builtins.str,
                 name: _builtins.str,
                 api_version: Optional[_builtins.str] = None):
        """
        CrossVersionObjectReference contains enough information to let you identify the referred resource.
        :param _builtins.str kind: kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param _builtins.str name: name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.str api_version: apiVersion is the API version of the referent
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        apiVersion is the API version of the referent
        """
        return pulumi.get(self, "api_version")


@pulumi.output_type
class CrossVersionObjectReferencePatch(dict):
    """
    CrossVersionObjectReference contains enough information to let you identify the referred resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossVersionObjectReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossVersionObjectReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossVersionObjectReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        CrossVersionObjectReference contains enough information to let you identify the referred resource.
        :param _builtins.str api_version: apiVersion is the API version of the referent
        :param _builtins.str kind: kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param _builtins.str name: name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        apiVersion is the API version of the referent
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExternalMetricSource(dict):
    """
    ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
    """
    def __init__(__self__, *,
                 metric: 'outputs.MetricIdentifier',
                 target: 'outputs.MetricTarget'):
        """
        ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExternalMetricSourcePatch(dict):
    """
    ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
    """
    def __init__(__self__, *,
                 metric: Optional['outputs.MetricIdentifierPatch'] = None,
                 target: Optional['outputs.MetricTargetPatch'] = None):
        """
        ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'MetricIdentifierPatchArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetPatchArgs' target: target specifies the target value for the given metric
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricIdentifierPatch']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional['outputs.MetricTargetPatch']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExternalMetricStatus(dict):
    """
    ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
    """
    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 metric: 'outputs.MetricIdentifier'):
        """
        ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class ExternalMetricStatusPatch(dict):
    """
    ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
    """
    def __init__(__self__, *,
                 current: Optional['outputs.MetricValueStatusPatch'] = None,
                 metric: Optional['outputs.MetricIdentifierPatch'] = None):
        """
        ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
        :param 'MetricValueStatusPatchArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierPatchArgs' metric: metric identifies the target metric by name and selector
        """
        if current is not None:
            pulumi.set(__self__, "current", current)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional['outputs.MetricValueStatusPatch']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricIdentifierPatch']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class HPAScalingPolicy(dict):
    """
    HPAScalingPolicy is a single policy which must hold true for a specified past interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "periodSeconds":
            suggest = "period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HPAScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HPAScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HPAScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period_seconds: _builtins.int,
                 type: _builtins.str,
                 value: _builtins.int):
        """
        HPAScalingPolicy is a single policy which must hold true for a specified past interval.
        :param _builtins.int period_seconds: periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param _builtins.str type: type is used to specify the scaling policy.
        :param _builtins.int value: value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> _builtins.int:
        """
        periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to specify the scaling policy.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HPAScalingPolicyPatch(dict):
    """
    HPAScalingPolicy is a single policy which must hold true for a specified past interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "periodSeconds":
            suggest = "period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HPAScalingPolicyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HPAScalingPolicyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HPAScalingPolicyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period_seconds: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.int] = None):
        """
        HPAScalingPolicy is a single policy which must hold true for a specified past interval.
        :param _builtins.int period_seconds: periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param _builtins.str type: type is used to specify the scaling policy.
        :param _builtins.int value: value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type is used to specify the scaling policy.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.int]:
        """
        value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HPAScalingRules(dict):
    """
    HPAScalingRules configures the scaling behavior for one direction via scaling Policy Rules and a configurable metric tolerance.

    Scaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

    The tolerance is applied to the metric values and prevents scaling too eagerly for small metric variations. (Note that setting a tolerance requires enabling the alpha HPAConfigurableTolerance feature gate.)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectPolicy":
            suggest = "select_policy"
        elif key == "stabilizationWindowSeconds":
            suggest = "stabilization_window_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HPAScalingRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HPAScalingRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HPAScalingRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policies: Optional[Sequence['outputs.HPAScalingPolicy']] = None,
                 select_policy: Optional[_builtins.str] = None,
                 stabilization_window_seconds: Optional[_builtins.int] = None,
                 tolerance: Optional[_builtins.str] = None):
        """
        HPAScalingRules configures the scaling behavior for one direction via scaling Policy Rules and a configurable metric tolerance.

        Scaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

        The tolerance is applied to the metric values and prevents scaling too eagerly for small metric variations. (Note that setting a tolerance requires enabling the alpha HPAConfigurableTolerance feature gate.)
        :param Sequence['HPAScalingPolicyArgs'] policies: policies is a list of potential scaling polices which can be used during scaling. If not set, use the default values: - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window. - For scale down: allow all pods to be removed in a 15s window.
        :param _builtins.str select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        :param _builtins.int stabilization_window_seconds: stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        :param _builtins.str tolerance: tolerance is the tolerance on the ratio between the current and desired metric value under which no updates are made to the desired number of replicas (e.g. 0.01 for 1%). Must be greater than or equal to zero. If not set, the default cluster-wide tolerance is applied (by default 10%).
               
               For example, if autoscaling is configured with a memory consumption target of 100Mi, and scale-down and scale-up tolerances of 5% and 1% respectively, scaling will be triggered when the actual consumption falls below 95Mi or exceeds 101Mi.
               
               This is an alpha field and requires enabling the HPAConfigurableTolerance feature gate.
        """
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if select_policy is not None:
            pulumi.set(__self__, "select_policy", select_policy)
        if stabilization_window_seconds is not None:
            pulumi.set(__self__, "stabilization_window_seconds", stabilization_window_seconds)
        if tolerance is not None:
            pulumi.set(__self__, "tolerance", tolerance)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.HPAScalingPolicy']]:
        """
        policies is a list of potential scaling polices which can be used during scaling. If not set, use the default values: - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window. - For scale down: allow all pods to be removed in a 15s window.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="selectPolicy")
    def select_policy(self) -> Optional[_builtins.str]:
        """
        selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        """
        return pulumi.get(self, "select_policy")

    @_builtins.property
    @pulumi.getter(name="stabilizationWindowSeconds")
    def stabilization_window_seconds(self) -> Optional[_builtins.int]:
        """
        stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        return pulumi.get(self, "stabilization_window_seconds")

    @_builtins.property
    @pulumi.getter
    def tolerance(self) -> Optional[_builtins.str]:
        """
        tolerance is the tolerance on the ratio between the current and desired metric value under which no updates are made to the desired number of replicas (e.g. 0.01 for 1%). Must be greater than or equal to zero. If not set, the default cluster-wide tolerance is applied (by default 10%).

        For example, if autoscaling is configured with a memory consumption target of 100Mi, and scale-down and scale-up tolerances of 5% and 1% respectively, scaling will be triggered when the actual consumption falls below 95Mi or exceeds 101Mi.

        This is an alpha field and requires enabling the HPAConfigurableTolerance feature gate.
        """
        return pulumi.get(self, "tolerance")


@pulumi.output_type
class HPAScalingRulesPatch(dict):
    """
    HPAScalingRules configures the scaling behavior for one direction via scaling Policy Rules and a configurable metric tolerance.

    Scaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

    The tolerance is applied to the metric values and prevents scaling too eagerly for small metric variations. (Note that setting a tolerance requires enabling the alpha HPAConfigurableTolerance feature gate.)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "selectPolicy":
            suggest = "select_policy"
        elif key == "stabilizationWindowSeconds":
            suggest = "stabilization_window_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HPAScalingRulesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HPAScalingRulesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HPAScalingRulesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policies: Optional[Sequence['outputs.HPAScalingPolicyPatch']] = None,
                 select_policy: Optional[_builtins.str] = None,
                 stabilization_window_seconds: Optional[_builtins.int] = None,
                 tolerance: Optional[_builtins.str] = None):
        """
        HPAScalingRules configures the scaling behavior for one direction via scaling Policy Rules and a configurable metric tolerance.

        Scaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.

        The tolerance is applied to the metric values and prevents scaling too eagerly for small metric variations. (Note that setting a tolerance requires enabling the alpha HPAConfigurableTolerance feature gate.)
        :param Sequence['HPAScalingPolicyPatchArgs'] policies: policies is a list of potential scaling polices which can be used during scaling. If not set, use the default values: - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window. - For scale down: allow all pods to be removed in a 15s window.
        :param _builtins.str select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        :param _builtins.int stabilization_window_seconds: stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        :param _builtins.str tolerance: tolerance is the tolerance on the ratio between the current and desired metric value under which no updates are made to the desired number of replicas (e.g. 0.01 for 1%). Must be greater than or equal to zero. If not set, the default cluster-wide tolerance is applied (by default 10%).
               
               For example, if autoscaling is configured with a memory consumption target of 100Mi, and scale-down and scale-up tolerances of 5% and 1% respectively, scaling will be triggered when the actual consumption falls below 95Mi or exceeds 101Mi.
               
               This is an alpha field and requires enabling the HPAConfigurableTolerance feature gate.
        """
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if select_policy is not None:
            pulumi.set(__self__, "select_policy", select_policy)
        if stabilization_window_seconds is not None:
            pulumi.set(__self__, "stabilization_window_seconds", stabilization_window_seconds)
        if tolerance is not None:
            pulumi.set(__self__, "tolerance", tolerance)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[Sequence['outputs.HPAScalingPolicyPatch']]:
        """
        policies is a list of potential scaling polices which can be used during scaling. If not set, use the default values: - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window. - For scale down: allow all pods to be removed in a 15s window.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="selectPolicy")
    def select_policy(self) -> Optional[_builtins.str]:
        """
        selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        """
        return pulumi.get(self, "select_policy")

    @_builtins.property
    @pulumi.getter(name="stabilizationWindowSeconds")
    def stabilization_window_seconds(self) -> Optional[_builtins.int]:
        """
        stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        return pulumi.get(self, "stabilization_window_seconds")

    @_builtins.property
    @pulumi.getter
    def tolerance(self) -> Optional[_builtins.str]:
        """
        tolerance is the tolerance on the ratio between the current and desired metric value under which no updates are made to the desired number of replicas (e.g. 0.01 for 1%). Must be greater than or equal to zero. If not set, the default cluster-wide tolerance is applied (by default 10%).

        For example, if autoscaling is configured with a memory consumption target of 100Mi, and scale-down and scale-up tolerances of 5% and 1% respectively, scaling will be triggered when the actual consumption falls below 95Mi or exceeds 101Mi.

        This is an alpha field and requires enabling the HPAConfigurableTolerance feature gate.
        """
        return pulumi.get(self, "tolerance")


@pulumi.output_type
class HorizontalPodAutoscaler(dict):
    """
    HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.HorizontalPodAutoscalerSpec'] = None,
                 status: Optional['outputs.HorizontalPodAutoscalerStatus'] = None):
        """
        HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'HorizontalPodAutoscalerSpecArgs' spec: spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        :param 'HorizontalPodAutoscalerStatusArgs' status: status is the current information about the autoscaler.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'autoscaling/v2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'HorizontalPodAutoscaler')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.HorizontalPodAutoscalerSpec']:
        """
        spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.HorizontalPodAutoscalerStatus']:
        """
        status is the current information about the autoscaler.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class HorizontalPodAutoscalerBehavior(dict):
    """
    HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleDown":
            suggest = "scale_down"
        elif key == "scaleUp":
            suggest = "scale_up"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_down: Optional['outputs.HPAScalingRules'] = None,
                 scale_up: Optional['outputs.HPAScalingRules'] = None):
        """
        HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
        :param 'HPAScalingRulesArgs' scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param 'HPAScalingRulesArgs' scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
                 * increase no more than 4 pods per 60 seconds
                 * double the number of pods per 60 seconds
               No stabilization is used.
        """
        if scale_down is not None:
            pulumi.set(__self__, "scale_down", scale_down)
        if scale_up is not None:
            pulumi.set(__self__, "scale_up", scale_up)

    @_builtins.property
    @pulumi.getter(name="scaleDown")
    def scale_down(self) -> Optional['outputs.HPAScalingRules']:
        """
        scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        """
        return pulumi.get(self, "scale_down")

    @_builtins.property
    @pulumi.getter(name="scaleUp")
    def scale_up(self) -> Optional['outputs.HPAScalingRules']:
        """
        scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
          * increase no more than 4 pods per 60 seconds
          * double the number of pods per 60 seconds
        No stabilization is used.
        """
        return pulumi.get(self, "scale_up")


@pulumi.output_type
class HorizontalPodAutoscalerBehaviorPatch(dict):
    """
    HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleDown":
            suggest = "scale_down"
        elif key == "scaleUp":
            suggest = "scale_up"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerBehaviorPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerBehaviorPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerBehaviorPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_down: Optional['outputs.HPAScalingRulesPatch'] = None,
                 scale_up: Optional['outputs.HPAScalingRulesPatch'] = None):
        """
        HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
        :param 'HPAScalingRulesPatchArgs' scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param 'HPAScalingRulesPatchArgs' scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
                 * increase no more than 4 pods per 60 seconds
                 * double the number of pods per 60 seconds
               No stabilization is used.
        """
        if scale_down is not None:
            pulumi.set(__self__, "scale_down", scale_down)
        if scale_up is not None:
            pulumi.set(__self__, "scale_up", scale_up)

    @_builtins.property
    @pulumi.getter(name="scaleDown")
    def scale_down(self) -> Optional['outputs.HPAScalingRulesPatch']:
        """
        scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        """
        return pulumi.get(self, "scale_down")

    @_builtins.property
    @pulumi.getter(name="scaleUp")
    def scale_up(self) -> Optional['outputs.HPAScalingRulesPatch']:
        """
        scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
          * increase no more than 4 pods per 60 seconds
          * double the number of pods per 60 seconds
        No stabilization is used.
        """
        return pulumi.get(self, "scale_up")


@pulumi.output_type
class HorizontalPodAutoscalerCondition(dict):
    """
    HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
        :param _builtins.str status: status is the status of the condition (True, False, Unknown)
        :param _builtins.str type: type describes the current condition
        :param _builtins.str last_transition_time: lastTransitionTime is the last time the condition transitioned from one status to another
        :param _builtins.str message: message is a human-readable explanation containing details about the transition
        :param _builtins.str reason: reason is the reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        status is the status of the condition (True, False, Unknown)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type describes the current condition
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        lastTransitionTime is the last time the condition transitioned from one status to another
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is a human-readable explanation containing details about the transition
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is the reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class HorizontalPodAutoscalerConditionPatch(dict):
    """
    HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
        :param _builtins.str last_transition_time: lastTransitionTime is the last time the condition transitioned from one status to another
        :param _builtins.str message: message is a human-readable explanation containing details about the transition
        :param _builtins.str reason: reason is the reason for the condition's last transition.
        :param _builtins.str status: status is the status of the condition (True, False, Unknown)
        :param _builtins.str type: type describes the current condition
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        lastTransitionTime is the last time the condition transitioned from one status to another
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is a human-readable explanation containing details about the transition
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is the reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        status is the status of the condition (True, False, Unknown)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type describes the current condition
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HorizontalPodAutoscalerSpec(dict):
    """
    HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "scaleTargetRef":
            suggest = "scale_target_ref"
        elif key == "minReplicas":
            suggest = "min_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replicas: _builtins.int,
                 scale_target_ref: 'outputs.CrossVersionObjectReference',
                 behavior: Optional['outputs.HorizontalPodAutoscalerBehavior'] = None,
                 metrics: Optional[Sequence['outputs.MetricSpec']] = None,
                 min_replicas: Optional[_builtins.int] = None):
        """
        HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
        :param _builtins.int max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param 'CrossVersionObjectReferenceArgs' scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param 'HorizontalPodAutoscalerBehaviorArgs' behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param Sequence['MetricSpecArgs'] metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param _builtins.int min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        pulumi.set(__self__, "max_replicas", max_replicas)
        pulumi.set(__self__, "scale_target_ref", scale_target_ref)
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)

    @_builtins.property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> _builtins.int:
        """
        maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        """
        return pulumi.get(self, "max_replicas")

    @_builtins.property
    @pulumi.getter(name="scaleTargetRef")
    def scale_target_ref(self) -> 'outputs.CrossVersionObjectReference':
        """
        scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        return pulumi.get(self, "scale_target_ref")

    @_builtins.property
    @pulumi.getter
    def behavior(self) -> Optional['outputs.HorizontalPodAutoscalerBehavior']:
        """
        behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        """
        return pulumi.get(self, "behavior")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.MetricSpec']]:
        """
        metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[_builtins.int]:
        """
        minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        return pulumi.get(self, "min_replicas")


@pulumi.output_type
class HorizontalPodAutoscalerSpecPatch(dict):
    """
    HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"
        elif key == "scaleTargetRef":
            suggest = "scale_target_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 behavior: Optional['outputs.HorizontalPodAutoscalerBehaviorPatch'] = None,
                 max_replicas: Optional[_builtins.int] = None,
                 metrics: Optional[Sequence['outputs.MetricSpecPatch']] = None,
                 min_replicas: Optional[_builtins.int] = None,
                 scale_target_ref: Optional['outputs.CrossVersionObjectReferencePatch'] = None):
        """
        HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
        :param 'HorizontalPodAutoscalerBehaviorPatchArgs' behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param _builtins.int max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param Sequence['MetricSpecPatchArgs'] metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param _builtins.int min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        :param 'CrossVersionObjectReferencePatchArgs' scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if scale_target_ref is not None:
            pulumi.set(__self__, "scale_target_ref", scale_target_ref)

    @_builtins.property
    @pulumi.getter
    def behavior(self) -> Optional['outputs.HorizontalPodAutoscalerBehaviorPatch']:
        """
        behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        """
        return pulumi.get(self, "behavior")

    @_builtins.property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[_builtins.int]:
        """
        maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        """
        return pulumi.get(self, "max_replicas")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.MetricSpecPatch']]:
        """
        metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        """
        return pulumi.get(self, "metrics")

    @_builtins.property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[_builtins.int]:
        """
        minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        return pulumi.get(self, "min_replicas")

    @_builtins.property
    @pulumi.getter(name="scaleTargetRef")
    def scale_target_ref(self) -> Optional['outputs.CrossVersionObjectReferencePatch']:
        """
        scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        return pulumi.get(self, "scale_target_ref")


@pulumi.output_type
class HorizontalPodAutoscalerStatus(dict):
    """
    HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredReplicas":
            suggest = "desired_replicas"
        elif key == "currentMetrics":
            suggest = "current_metrics"
        elif key == "currentReplicas":
            suggest = "current_replicas"
        elif key == "lastScaleTime":
            suggest = "last_scale_time"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_replicas: _builtins.int,
                 conditions: Optional[Sequence['outputs.HorizontalPodAutoscalerCondition']] = None,
                 current_metrics: Optional[Sequence['outputs.MetricStatus']] = None,
                 current_replicas: Optional[_builtins.int] = None,
                 last_scale_time: Optional[_builtins.str] = None,
                 observed_generation: Optional[_builtins.int] = None):
        """
        HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
        :param _builtins.int desired_replicas: desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        :param Sequence['HorizontalPodAutoscalerConditionArgs'] conditions: conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        :param Sequence['MetricStatusArgs'] current_metrics: currentMetrics is the last read state of the metrics used by this autoscaler.
        :param _builtins.int current_replicas: currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        :param _builtins.str last_scale_time: lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        :param _builtins.int observed_generation: observedGeneration is the most recent generation observed by this autoscaler.
        """
        pulumi.set(__self__, "desired_replicas", desired_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_metrics is not None:
            pulumi.set(__self__, "current_metrics", current_metrics)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if last_scale_time is not None:
            pulumi.set(__self__, "last_scale_time", last_scale_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @_builtins.property
    @pulumi.getter(name="desiredReplicas")
    def desired_replicas(self) -> _builtins.int:
        """
        desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        """
        return pulumi.get(self, "desired_replicas")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.HorizontalPodAutoscalerCondition']]:
        """
        conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentMetrics")
    def current_metrics(self) -> Optional[Sequence['outputs.MetricStatus']]:
        """
        currentMetrics is the last read state of the metrics used by this autoscaler.
        """
        return pulumi.get(self, "current_metrics")

    @_builtins.property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[_builtins.int]:
        """
        currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        """
        return pulumi.get(self, "current_replicas")

    @_builtins.property
    @pulumi.getter(name="lastScaleTime")
    def last_scale_time(self) -> Optional[_builtins.str]:
        """
        lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        """
        return pulumi.get(self, "last_scale_time")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        observedGeneration is the most recent generation observed by this autoscaler.
        """
        return pulumi.get(self, "observed_generation")


@pulumi.output_type
class HorizontalPodAutoscalerStatusPatch(dict):
    """
    HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentMetrics":
            suggest = "current_metrics"
        elif key == "currentReplicas":
            suggest = "current_replicas"
        elif key == "desiredReplicas":
            suggest = "desired_replicas"
        elif key == "lastScaleTime":
            suggest = "last_scale_time"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HorizontalPodAutoscalerStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HorizontalPodAutoscalerStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HorizontalPodAutoscalerStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.HorizontalPodAutoscalerConditionPatch']] = None,
                 current_metrics: Optional[Sequence['outputs.MetricStatusPatch']] = None,
                 current_replicas: Optional[_builtins.int] = None,
                 desired_replicas: Optional[_builtins.int] = None,
                 last_scale_time: Optional[_builtins.str] = None,
                 observed_generation: Optional[_builtins.int] = None):
        """
        HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
        :param Sequence['HorizontalPodAutoscalerConditionPatchArgs'] conditions: conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        :param Sequence['MetricStatusPatchArgs'] current_metrics: currentMetrics is the last read state of the metrics used by this autoscaler.
        :param _builtins.int current_replicas: currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        :param _builtins.int desired_replicas: desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        :param _builtins.str last_scale_time: lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        :param _builtins.int observed_generation: observedGeneration is the most recent generation observed by this autoscaler.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_metrics is not None:
            pulumi.set(__self__, "current_metrics", current_metrics)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if desired_replicas is not None:
            pulumi.set(__self__, "desired_replicas", desired_replicas)
        if last_scale_time is not None:
            pulumi.set(__self__, "last_scale_time", last_scale_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.HorizontalPodAutoscalerConditionPatch']]:
        """
        conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentMetrics")
    def current_metrics(self) -> Optional[Sequence['outputs.MetricStatusPatch']]:
        """
        currentMetrics is the last read state of the metrics used by this autoscaler.
        """
        return pulumi.get(self, "current_metrics")

    @_builtins.property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[_builtins.int]:
        """
        currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        """
        return pulumi.get(self, "current_replicas")

    @_builtins.property
    @pulumi.getter(name="desiredReplicas")
    def desired_replicas(self) -> Optional[_builtins.int]:
        """
        desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        """
        return pulumi.get(self, "desired_replicas")

    @_builtins.property
    @pulumi.getter(name="lastScaleTime")
    def last_scale_time(self) -> Optional[_builtins.str]:
        """
        lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        """
        return pulumi.get(self, "last_scale_time")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        observedGeneration is the most recent generation observed by this autoscaler.
        """
        return pulumi.get(self, "observed_generation")


@pulumi.output_type
class MetricIdentifier(dict):
    """
    MetricIdentifier defines the name and optionally selector for a metric
    """
    def __init__(__self__, *,
                 name: _builtins.str,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None):
        """
        MetricIdentifier defines the name and optionally selector for a metric
        :param _builtins.str name: name is the name of the given metric
        :param '_meta.v1.LabelSelectorArgs' selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "name", name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the given metric
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class MetricIdentifierPatch(dict):
    """
    MetricIdentifier defines the name and optionally selector for a metric
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None):
        """
        MetricIdentifier defines the name and optionally selector for a metric
        :param _builtins.str name: name is the name of the given metric
        :param '_meta.v1.LabelSelectorPatchArgs' selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the given metric
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class MetricSpec(dict):
    """
    MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResource":
            suggest = "container_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 container_resource: Optional['outputs.ContainerResourceMetricSource'] = None,
                 external: Optional['outputs.ExternalMetricSource'] = None,
                 object: Optional['outputs.ObjectMetricSource'] = None,
                 pods: Optional['outputs.PodsMetricSource'] = None,
                 resource: Optional['outputs.ResourceMetricSource'] = None):
        """
        MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
        :param _builtins.str type: type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object.
        :param 'ContainerResourceMetricSourceArgs' container_resource: containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'ExternalMetricSourceArgs' external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'ObjectMetricSourceArgs' object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'PodsMetricSourceArgs' pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param 'ResourceMetricSourceArgs' resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional['outputs.ContainerResourceMetricSource']:
        """
        containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional['outputs.ExternalMetricSource']:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional['outputs.ObjectMetricSource']:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def pods(self) -> Optional['outputs.PodsMetricSource']:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.ResourceMetricSource']:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class MetricSpecPatch(dict):
    """
    MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResource":
            suggest = "container_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_resource: Optional['outputs.ContainerResourceMetricSourcePatch'] = None,
                 external: Optional['outputs.ExternalMetricSourcePatch'] = None,
                 object: Optional['outputs.ObjectMetricSourcePatch'] = None,
                 pods: Optional['outputs.PodsMetricSourcePatch'] = None,
                 resource: Optional['outputs.ResourceMetricSourcePatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
        :param 'ContainerResourceMetricSourcePatchArgs' container_resource: containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'ExternalMetricSourcePatchArgs' external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'ObjectMetricSourcePatchArgs' object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'PodsMetricSourcePatchArgs' pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param 'ResourceMetricSourcePatchArgs' resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param _builtins.str type: type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object.
        """
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional['outputs.ContainerResourceMetricSourcePatch']:
        """
        containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional['outputs.ExternalMetricSourcePatch']:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional['outputs.ObjectMetricSourcePatch']:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def pods(self) -> Optional['outputs.PodsMetricSourcePatch']:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.ResourceMetricSourcePatch']:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MetricStatus(dict):
    """
    MetricStatus describes the last-read state of a single metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResource":
            suggest = "container_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 container_resource: Optional['outputs.ContainerResourceMetricStatus'] = None,
                 external: Optional['outputs.ExternalMetricStatus'] = None,
                 object: Optional['outputs.ObjectMetricStatus'] = None,
                 pods: Optional['outputs.PodsMetricStatus'] = None,
                 resource: Optional['outputs.ResourceMetricStatus'] = None):
        """
        MetricStatus describes the last-read state of a single metric.
        :param _builtins.str type: type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object.
        :param 'ContainerResourceMetricStatusArgs' container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'ExternalMetricStatusArgs' external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'ObjectMetricStatusArgs' object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'PodsMetricStatusArgs' pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param 'ResourceMetricStatusArgs' resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional['outputs.ContainerResourceMetricStatus']:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional['outputs.ExternalMetricStatus']:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional['outputs.ObjectMetricStatus']:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def pods(self) -> Optional['outputs.PodsMetricStatus']:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.ResourceMetricStatus']:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class MetricStatusPatch(dict):
    """
    MetricStatus describes the last-read state of a single metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerResource":
            suggest = "container_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_resource: Optional['outputs.ContainerResourceMetricStatusPatch'] = None,
                 external: Optional['outputs.ExternalMetricStatusPatch'] = None,
                 object: Optional['outputs.ObjectMetricStatusPatch'] = None,
                 pods: Optional['outputs.PodsMetricStatusPatch'] = None,
                 resource: Optional['outputs.ResourceMetricStatusPatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        MetricStatus describes the last-read state of a single metric.
        :param 'ContainerResourceMetricStatusPatchArgs' container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'ExternalMetricStatusPatchArgs' external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param 'ObjectMetricStatusPatchArgs' object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'PodsMetricStatusPatchArgs' pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param 'ResourceMetricStatusPatchArgs' resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param _builtins.str type: type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object.
        """
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional['outputs.ContainerResourceMetricStatusPatch']:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional['outputs.ExternalMetricStatusPatch']:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional['outputs.ObjectMetricStatusPatch']:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def pods(self) -> Optional['outputs.PodsMetricStatusPatch']:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['outputs.ResourceMetricStatusPatch']:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MetricTarget(dict):
    """
    MetricTarget defines the target value, average value, or average utilization of a specific metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageUtilization":
            suggest = "average_utilization"
        elif key == "averageValue":
            suggest = "average_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 average_utilization: Optional[_builtins.int] = None,
                 average_value: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        MetricTarget defines the target value, average value, or average utilization of a specific metric
        :param _builtins.str type: type represents whether the metric type is Utilization, Value, or AverageValue
        :param _builtins.int average_utilization: averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        :param _builtins.str average_value: averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param _builtins.str value: value is the target value of the metric (as a quantity).
        """
        pulumi.set(__self__, "type", type)
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type represents whether the metric type is Utilization, Value, or AverageValue
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[_builtins.int]:
        """
        averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        """
        return pulumi.get(self, "average_utilization")

    @_builtins.property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[_builtins.str]:
        """
        averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        value is the target value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricTargetPatch(dict):
    """
    MetricTarget defines the target value, average value, or average utilization of a specific metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageUtilization":
            suggest = "average_utilization"
        elif key == "averageValue":
            suggest = "average_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricTargetPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricTargetPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricTargetPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_utilization: Optional[_builtins.int] = None,
                 average_value: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        MetricTarget defines the target value, average value, or average utilization of a specific metric
        :param _builtins.int average_utilization: averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        :param _builtins.str average_value: averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param _builtins.str type: type represents whether the metric type is Utilization, Value, or AverageValue
        :param _builtins.str value: value is the target value of the metric (as a quantity).
        """
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[_builtins.int]:
        """
        averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        """
        return pulumi.get(self, "average_utilization")

    @_builtins.property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[_builtins.str]:
        """
        averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type represents whether the metric type is Utilization, Value, or AverageValue
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        value is the target value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricValueStatus(dict):
    """
    MetricValueStatus holds the current value for a metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageUtilization":
            suggest = "average_utilization"
        elif key == "averageValue":
            suggest = "average_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricValueStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricValueStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricValueStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_utilization: Optional[_builtins.int] = None,
                 average_value: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        MetricValueStatus holds the current value for a metric
        :param _builtins.int average_utilization: currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param _builtins.str average_value: averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        :param _builtins.str value: value is the current value of the metric (as a quantity).
        """
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[_builtins.int]:
        """
        currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        """
        return pulumi.get(self, "average_utilization")

    @_builtins.property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[_builtins.str]:
        """
        averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        value is the current value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricValueStatusPatch(dict):
    """
    MetricValueStatus holds the current value for a metric
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "averageUtilization":
            suggest = "average_utilization"
        elif key == "averageValue":
            suggest = "average_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricValueStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricValueStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricValueStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 average_utilization: Optional[_builtins.int] = None,
                 average_value: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        MetricValueStatus holds the current value for a metric
        :param _builtins.int average_utilization: currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param _builtins.str average_value: averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        :param _builtins.str value: value is the current value of the metric (as a quantity).
        """
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[_builtins.int]:
        """
        currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        """
        return pulumi.get(self, "average_utilization")

    @_builtins.property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[_builtins.str]:
        """
        averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        value is the current value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ObjectMetricSource(dict):
    """
    ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "describedObject":
            suggest = "described_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetricSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetricSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetricSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 described_object: 'outputs.CrossVersionObjectReference',
                 metric: 'outputs.MetricIdentifier',
                 target: 'outputs.MetricTarget'):
        """
        ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'CrossVersionObjectReferenceArgs' described_object: describedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "described_object", described_object)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> 'outputs.CrossVersionObjectReference':
        """
        describedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectMetricSourcePatch(dict):
    """
    ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "describedObject":
            suggest = "described_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetricSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetricSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetricSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 described_object: Optional['outputs.CrossVersionObjectReferencePatch'] = None,
                 metric: Optional['outputs.MetricIdentifierPatch'] = None,
                 target: Optional['outputs.MetricTargetPatch'] = None):
        """
        ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'CrossVersionObjectReferencePatchArgs' described_object: describedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param 'MetricIdentifierPatchArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetPatchArgs' target: target specifies the target value for the given metric
        """
        if described_object is not None:
            pulumi.set(__self__, "described_object", described_object)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> Optional['outputs.CrossVersionObjectReferencePatch']:
        """
        describedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricIdentifierPatch']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional['outputs.MetricTargetPatch']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectMetricStatus(dict):
    """
    ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "describedObject":
            suggest = "described_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetricStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetricStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetricStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 described_object: 'outputs.CrossVersionObjectReference',
                 metric: 'outputs.MetricIdentifier'):
        """
        ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param 'CrossVersionObjectReferenceArgs' described_object: DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "described_object", described_object)
        pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> 'outputs.CrossVersionObjectReference':
        """
        DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class ObjectMetricStatusPatch(dict):
    """
    ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "describedObject":
            suggest = "described_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetricStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetricStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetricStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current: Optional['outputs.MetricValueStatusPatch'] = None,
                 described_object: Optional['outputs.CrossVersionObjectReferencePatch'] = None,
                 metric: Optional['outputs.MetricIdentifierPatch'] = None):
        """
        ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param 'MetricValueStatusPatchArgs' current: current contains the current value for the given metric
        :param 'CrossVersionObjectReferencePatchArgs' described_object: DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param 'MetricIdentifierPatchArgs' metric: metric identifies the target metric by name and selector
        """
        if current is not None:
            pulumi.set(__self__, "current", current)
        if described_object is not None:
            pulumi.set(__self__, "described_object", described_object)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional['outputs.MetricValueStatusPatch']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> Optional['outputs.CrossVersionObjectReferencePatch']:
        """
        DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricIdentifierPatch']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class PodsMetricSource(dict):
    """
    PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
    """
    def __init__(__self__, *,
                 metric: 'outputs.MetricIdentifier',
                 target: 'outputs.MetricTarget'):
        """
        PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class PodsMetricSourcePatch(dict):
    """
    PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
    """
    def __init__(__self__, *,
                 metric: Optional['outputs.MetricIdentifierPatch'] = None,
                 target: Optional['outputs.MetricTargetPatch'] = None):
        """
        PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
        :param 'MetricIdentifierPatchArgs' metric: metric identifies the target metric by name and selector
        :param 'MetricTargetPatchArgs' target: target specifies the target value for the given metric
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricIdentifierPatch']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional['outputs.MetricTargetPatch']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class PodsMetricStatus(dict):
    """
    PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
    """
    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 metric: 'outputs.MetricIdentifier'):
        """
        PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierArgs' metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> 'outputs.MetricIdentifier':
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class PodsMetricStatusPatch(dict):
    """
    PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
    """
    def __init__(__self__, *,
                 current: Optional['outputs.MetricValueStatusPatch'] = None,
                 metric: Optional['outputs.MetricIdentifierPatch'] = None):
        """
        PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
        :param 'MetricValueStatusPatchArgs' current: current contains the current value for the given metric
        :param 'MetricIdentifierPatchArgs' metric: metric identifies the target metric by name and selector
        """
        if current is not None:
            pulumi.set(__self__, "current", current)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional['outputs.MetricValueStatusPatch']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricIdentifierPatch']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class ResourceMetricSource(dict):
    """
    ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
    """
    def __init__(__self__, *,
                 name: _builtins.str,
                 target: 'outputs.MetricTarget'):
        """
        ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param _builtins.str name: name is the name of the resource in question.
        :param 'MetricTargetArgs' target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def target(self) -> 'outputs.MetricTarget':
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ResourceMetricSourcePatch(dict):
    """
    ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 target: Optional['outputs.MetricTargetPatch'] = None):
        """
        ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param _builtins.str name: name is the name of the resource in question.
        :param 'MetricTargetPatchArgs' target: target specifies the target value for the given metric
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional['outputs.MetricTargetPatch']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ResourceMetricStatus(dict):
    """
    ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    def __init__(__self__, *,
                 current: 'outputs.MetricValueStatus',
                 name: _builtins.str):
        """
        ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'MetricValueStatusArgs' current: current contains the current value for the given metric
        :param _builtins.str name: name is the name of the resource in question.
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def current(self) -> 'outputs.MetricValueStatus':
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ResourceMetricStatusPatch(dict):
    """
    ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
    """
    def __init__(__self__, *,
                 current: Optional['outputs.MetricValueStatusPatch'] = None,
                 name: Optional[_builtins.str] = None):
        """
        ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param 'MetricValueStatusPatchArgs' current: current contains the current value for the given metric
        :param _builtins.str name: name is the name of the resource in question.
        """
        if current is not None:
            pulumi.set(__self__, "current", current)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def current(self) -> Optional['outputs.MetricValueStatusPatch']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")


