# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllowedCSIDriver',
    'AllowedCSIDriverPatch',
    'AllowedFlexVolume',
    'AllowedFlexVolumePatch',
    'AllowedHostPath',
    'AllowedHostPathPatch',
    'DaemonSet',
    'DaemonSetCondition',
    'DaemonSetConditionPatch',
    'DaemonSetSpec',
    'DaemonSetSpecPatch',
    'DaemonSetStatus',
    'DaemonSetStatusPatch',
    'DaemonSetUpdateStrategy',
    'DaemonSetUpdateStrategyPatch',
    'Deployment',
    'DeploymentCondition',
    'DeploymentConditionPatch',
    'DeploymentSpec',
    'DeploymentSpecPatch',
    'DeploymentStatus',
    'DeploymentStatusPatch',
    'DeploymentStrategy',
    'DeploymentStrategyPatch',
    'FSGroupStrategyOptions',
    'FSGroupStrategyOptionsPatch',
    'HTTPIngressPath',
    'HTTPIngressPathPatch',
    'HTTPIngressRuleValue',
    'HTTPIngressRuleValuePatch',
    'HostPortRange',
    'HostPortRangePatch',
    'IDRange',
    'IDRangePatch',
    'IPBlock',
    'IPBlockPatch',
    'Ingress',
    'IngressBackend',
    'IngressBackendPatch',
    'IngressRule',
    'IngressRulePatch',
    'IngressSpec',
    'IngressSpecPatch',
    'IngressStatus',
    'IngressStatusPatch',
    'IngressTLS',
    'IngressTLSPatch',
    'NetworkPolicy',
    'NetworkPolicyEgressRule',
    'NetworkPolicyEgressRulePatch',
    'NetworkPolicyIngressRule',
    'NetworkPolicyIngressRulePatch',
    'NetworkPolicyPeer',
    'NetworkPolicyPeerPatch',
    'NetworkPolicyPort',
    'NetworkPolicyPortPatch',
    'NetworkPolicySpec',
    'NetworkPolicySpecPatch',
    'PodSecurityPolicy',
    'PodSecurityPolicySpec',
    'PodSecurityPolicySpecPatch',
    'ReplicaSet',
    'ReplicaSetCondition',
    'ReplicaSetConditionPatch',
    'ReplicaSetSpec',
    'ReplicaSetSpecPatch',
    'ReplicaSetStatus',
    'ReplicaSetStatusPatch',
    'RollbackConfig',
    'RollbackConfigPatch',
    'RollingUpdateDaemonSet',
    'RollingUpdateDaemonSetPatch',
    'RollingUpdateDeployment',
    'RollingUpdateDeploymentPatch',
    'RunAsGroupStrategyOptions',
    'RunAsGroupStrategyOptionsPatch',
    'RunAsUserStrategyOptions',
    'RunAsUserStrategyOptionsPatch',
    'RuntimeClassStrategyOptions',
    'RuntimeClassStrategyOptionsPatch',
    'SELinuxStrategyOptions',
    'SELinuxStrategyOptionsPatch',
    'SupplementalGroupsStrategyOptions',
    'SupplementalGroupsStrategyOptionsPatch',
]

@pulumi.output_type
class AllowedCSIDriver(dict):
    """
    AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.
    """
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.
        :param _builtins.str name: Name is the registered name of the CSI driver
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name is the registered name of the CSI driver
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AllowedCSIDriverPatch(dict):
    """
    AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used.
        :param _builtins.str name: Name is the registered name of the CSI driver
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name is the registered name of the CSI driver
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AllowedFlexVolume(dict):
    """
    AllowedFlexVolume represents a single Flexvolume that is allowed to be used. Deprecated: use AllowedFlexVolume from policy API Group instead.
    """
    def __init__(__self__, *,
                 driver: _builtins.str):
        """
        AllowedFlexVolume represents a single Flexvolume that is allowed to be used. Deprecated: use AllowedFlexVolume from policy API Group instead.
        :param _builtins.str driver: driver is the name of the Flexvolume driver.
        """
        pulumi.set(__self__, "driver", driver)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        driver is the name of the Flexvolume driver.
        """
        return pulumi.get(self, "driver")


@pulumi.output_type
class AllowedFlexVolumePatch(dict):
    """
    AllowedFlexVolume represents a single Flexvolume that is allowed to be used. Deprecated: use AllowedFlexVolume from policy API Group instead.
    """
    def __init__(__self__, *,
                 driver: Optional[_builtins.str] = None):
        """
        AllowedFlexVolume represents a single Flexvolume that is allowed to be used. Deprecated: use AllowedFlexVolume from policy API Group instead.
        :param _builtins.str driver: driver is the name of the Flexvolume driver.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[_builtins.str]:
        """
        driver is the name of the Flexvolume driver.
        """
        return pulumi.get(self, "driver")


@pulumi.output_type
class AllowedHostPath(dict):
    """
    AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined. Deprecated: use AllowedHostPath from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathPrefix":
            suggest = "path_prefix"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllowedHostPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllowedHostPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllowedHostPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_prefix: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined. Deprecated: use AllowedHostPath from policy API Group instead.
        :param _builtins.str path_prefix: pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.
               
               Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
        :param _builtins.bool read_only: when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
        """
        if path_prefix is not None:
            pulumi.set(__self__, "path_prefix", path_prefix)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> Optional[_builtins.str]:
        """
        pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.

        Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
        """
        return pulumi.get(self, "path_prefix")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class AllowedHostPathPatch(dict):
    """
    AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined. Deprecated: use AllowedHostPath from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathPrefix":
            suggest = "path_prefix"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllowedHostPathPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllowedHostPathPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllowedHostPathPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_prefix: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined. Deprecated: use AllowedHostPath from policy API Group instead.
        :param _builtins.str path_prefix: pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.
               
               Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
        :param _builtins.bool read_only: when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
        """
        if path_prefix is not None:
            pulumi.set(__self__, "path_prefix", path_prefix)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> Optional[_builtins.str]:
        """
        pathPrefix is the path prefix that the host volume must match. It does not support `*`. Trailing slashes are trimmed when validating the path prefix with a host path.

        Examples: `/foo` would allow `/foo`, `/foo/` and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
        """
        return pulumi.get(self, "path_prefix")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        when set to true, will allow host volumes matching the pathPrefix only if all volume mounts are readOnly.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class DaemonSet(dict):
    """
    DaemonSet represents the configuration of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.DaemonSetSpec'] = None,
                 status: Optional['outputs.DaemonSetStatus'] = None):
        """
        DaemonSet represents the configuration of a daemon set.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'DaemonSetSpecArgs' spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'DaemonSetStatusArgs' status: The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'extensions/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DaemonSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.DaemonSetSpec']:
        """
        The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.DaemonSetStatus']:
        """
        The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DaemonSetCondition(dict):
    """
    DaemonSetCondition describes the state of a DaemonSet at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of DaemonSet condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of DaemonSet condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class DaemonSetConditionPatch(dict):
    """
    DaemonSetCondition describes the state of a DaemonSet at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of DaemonSet condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of DaemonSet condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaemonSetSpec(dict):
    """
    DaemonSetSpec is the specification of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "templateGeneration":
            suggest = "template_generation"
        elif key == "updateStrategy":
            suggest = "update_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 template_generation: Optional[_builtins.int] = None,
                 update_strategy: Optional['outputs.DaemonSetUpdateStrategy'] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param '_core.v1.PodTemplateSpecArgs' template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param _builtins.int min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param _builtins.int revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param '_meta.v1.LabelSelectorArgs' selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param _builtins.int template_generation: DEPRECATED. A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.
        :param 'DaemonSetUpdateStrategyArgs' update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template_generation is not None:
            pulumi.set(__self__, "template_generation", template_generation)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="templateGeneration")
    def template_generation(self) -> Optional[_builtins.int]:
        """
        DEPRECATED. A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.
        """
        return pulumi.get(self, "template_generation")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.DaemonSetUpdateStrategy']:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")


@pulumi.output_type
class DaemonSetSpecPatch(dict):
    """
    DaemonSetSpec is the specification of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "templateGeneration":
            suggest = "template_generation"
        elif key == "updateStrategy":
            suggest = "update_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None,
                 template_generation: Optional[_builtins.int] = None,
                 update_strategy: Optional['outputs.DaemonSetUpdateStrategyPatch'] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param _builtins.int min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param _builtins.int revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param '_meta.v1.LabelSelectorPatchArgs' selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecPatchArgs' template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param _builtins.int template_generation: DEPRECATED. A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.
        :param 'DaemonSetUpdateStrategyPatchArgs' update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if template_generation is not None:
            pulumi.set(__self__, "template_generation", template_generation)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="templateGeneration")
    def template_generation(self) -> Optional[_builtins.int]:
        """
        DEPRECATED. A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.
        """
        return pulumi.get(self, "template_generation")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.DaemonSetUpdateStrategyPatch']:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")


@pulumi.output_type
class DaemonSetStatus(dict):
    """
    DaemonSetStatus represents the current status of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentNumberScheduled":
            suggest = "current_number_scheduled"
        elif key == "desiredNumberScheduled":
            suggest = "desired_number_scheduled"
        elif key == "numberMisscheduled":
            suggest = "number_misscheduled"
        elif key == "numberReady":
            suggest = "number_ready"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "numberAvailable":
            suggest = "number_available"
        elif key == "numberUnavailable":
            suggest = "number_unavailable"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "updatedNumberScheduled":
            suggest = "updated_number_scheduled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_number_scheduled: _builtins.int,
                 desired_number_scheduled: _builtins.int,
                 number_misscheduled: _builtins.int,
                 number_ready: _builtins.int,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DaemonSetCondition']] = None,
                 number_available: Optional[_builtins.int] = None,
                 number_unavailable: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 updated_number_scheduled: Optional[_builtins.int] = None):
        """
        DaemonSetStatus represents the current status of a daemon set.
        :param _builtins.int current_number_scheduled: The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int desired_number_scheduled: The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_misscheduled: The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_ready: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.
        :param _builtins.int collision_count: Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['DaemonSetConditionArgs'] conditions: Represents the latest available observations of a DaemonSet's current state.
        :param _builtins.int number_available: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int number_unavailable: The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int observed_generation: The most recent generation observed by the daemon set controller.
        :param _builtins.int updated_number_scheduled: The total number of nodes that are running updated daemon pod
        """
        pulumi.set(__self__, "current_number_scheduled", current_number_scheduled)
        pulumi.set(__self__, "desired_number_scheduled", desired_number_scheduled)
        pulumi.set(__self__, "number_misscheduled", number_misscheduled)
        pulumi.set(__self__, "number_ready", number_ready)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if number_available is not None:
            pulumi.set(__self__, "number_available", number_available)
        if number_unavailable is not None:
            pulumi.set(__self__, "number_unavailable", number_unavailable)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if updated_number_scheduled is not None:
            pulumi.set(__self__, "updated_number_scheduled", updated_number_scheduled)

    @_builtins.property
    @pulumi.getter(name="currentNumberScheduled")
    def current_number_scheduled(self) -> _builtins.int:
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "current_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="desiredNumberScheduled")
    def desired_number_scheduled(self) -> _builtins.int:
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "desired_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="numberMisscheduled")
    def number_misscheduled(self) -> _builtins.int:
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "number_misscheduled")

    @_builtins.property
    @pulumi.getter(name="numberReady")
    def number_ready(self) -> _builtins.int:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.
        """
        return pulumi.get(self, "number_ready")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DaemonSetCondition']]:
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="numberAvailable")
    def number_available(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_available")

    @_builtins.property
    @pulumi.getter(name="numberUnavailable")
    def number_unavailable(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_unavailable")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The most recent generation observed by the daemon set controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="updatedNumberScheduled")
    def updated_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The total number of nodes that are running updated daemon pod
        """
        return pulumi.get(self, "updated_number_scheduled")


@pulumi.output_type
class DaemonSetStatusPatch(dict):
    """
    DaemonSetStatus represents the current status of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collisionCount":
            suggest = "collision_count"
        elif key == "currentNumberScheduled":
            suggest = "current_number_scheduled"
        elif key == "desiredNumberScheduled":
            suggest = "desired_number_scheduled"
        elif key == "numberAvailable":
            suggest = "number_available"
        elif key == "numberMisscheduled":
            suggest = "number_misscheduled"
        elif key == "numberReady":
            suggest = "number_ready"
        elif key == "numberUnavailable":
            suggest = "number_unavailable"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "updatedNumberScheduled":
            suggest = "updated_number_scheduled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DaemonSetConditionPatch']] = None,
                 current_number_scheduled: Optional[_builtins.int] = None,
                 desired_number_scheduled: Optional[_builtins.int] = None,
                 number_available: Optional[_builtins.int] = None,
                 number_misscheduled: Optional[_builtins.int] = None,
                 number_ready: Optional[_builtins.int] = None,
                 number_unavailable: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 updated_number_scheduled: Optional[_builtins.int] = None):
        """
        DaemonSetStatus represents the current status of a daemon set.
        :param _builtins.int collision_count: Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['DaemonSetConditionPatchArgs'] conditions: Represents the latest available observations of a DaemonSet's current state.
        :param _builtins.int current_number_scheduled: The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int desired_number_scheduled: The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_available: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int number_misscheduled: The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_ready: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.
        :param _builtins.int number_unavailable: The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int observed_generation: The most recent generation observed by the daemon set controller.
        :param _builtins.int updated_number_scheduled: The total number of nodes that are running updated daemon pod
        """
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_number_scheduled is not None:
            pulumi.set(__self__, "current_number_scheduled", current_number_scheduled)
        if desired_number_scheduled is not None:
            pulumi.set(__self__, "desired_number_scheduled", desired_number_scheduled)
        if number_available is not None:
            pulumi.set(__self__, "number_available", number_available)
        if number_misscheduled is not None:
            pulumi.set(__self__, "number_misscheduled", number_misscheduled)
        if number_ready is not None:
            pulumi.set(__self__, "number_ready", number_ready)
        if number_unavailable is not None:
            pulumi.set(__self__, "number_unavailable", number_unavailable)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if updated_number_scheduled is not None:
            pulumi.set(__self__, "updated_number_scheduled", updated_number_scheduled)

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DaemonSetConditionPatch']]:
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentNumberScheduled")
    def current_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "current_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="desiredNumberScheduled")
    def desired_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "desired_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="numberAvailable")
    def number_available(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_available")

    @_builtins.property
    @pulumi.getter(name="numberMisscheduled")
    def number_misscheduled(self) -> Optional[_builtins.int]:
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "number_misscheduled")

    @_builtins.property
    @pulumi.getter(name="numberReady")
    def number_ready(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.
        """
        return pulumi.get(self, "number_ready")

    @_builtins.property
    @pulumi.getter(name="numberUnavailable")
    def number_unavailable(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_unavailable")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The most recent generation observed by the daemon set controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="updatedNumberScheduled")
    def updated_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The total number of nodes that are running updated daemon pod
        """
        return pulumi.get(self, "updated_number_scheduled")


@pulumi.output_type
class DaemonSetUpdateStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetUpdateStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetUpdateStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetUpdateStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDaemonSet'] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param 'RollingUpdateDaemonSetArgs' rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param _builtins.str type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is OnDelete.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDaemonSet']:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is OnDelete.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaemonSetUpdateStrategyPatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetUpdateStrategyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetUpdateStrategyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetUpdateStrategyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDaemonSetPatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param 'RollingUpdateDaemonSetPatchArgs' rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param _builtins.str type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is OnDelete.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDaemonSetPatch']:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is OnDelete.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class Deployment(dict):
    """
    Deployment enables declarative updates for Pods and ReplicaSets.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The Deployment has begun to be updated by the Deployment controller. If the current
       generation of the Deployment is > 1, then this means that the current generation must
       be different from the generation reported by the last outputs.
    2. There exists a ReplicaSet whose revision is equal to the current revision of the
       Deployment.
    3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
       member is set to 'True'.
    4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
       'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
       'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
       because it doesn't do a rollout (i.e., it simply creates the Deployment and
       corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

    If the Deployment has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Deployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Deployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Deployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.DeploymentSpec'] = None,
                 status: Optional['outputs.DeploymentStatus'] = None):
        """
        Deployment enables declarative updates for Pods and ReplicaSets.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Deployment has begun to be updated by the Deployment controller. If the current
           generation of the Deployment is > 1, then this means that the current generation must
           be different from the generation reported by the last outputs.
        2. There exists a ReplicaSet whose revision is equal to the current revision of the
           Deployment.
        3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
           member is set to 'True'.
        4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
           'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
           'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
           because it doesn't do a rollout (i.e., it simply creates the Deployment and
           corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

        If the Deployment has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata.
        :param 'DeploymentSpecArgs' spec: Specification of the desired behavior of the Deployment.
        :param 'DeploymentStatusArgs' status: Most recently observed status of the Deployment.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'extensions/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Deployment')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.DeploymentSpec']:
        """
        Specification of the desired behavior of the Deployment.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.DeploymentStatus']:
        """
        Most recently observed status of the Deployment.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DeploymentCondition(dict):
    """
    DeploymentCondition describes the state of a deployment at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 last_update_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of deployment condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str last_update_time: The last time this condition was updated.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of deployment condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class DeploymentConditionPatch(dict):
    """
    DeploymentCondition describes the state of a deployment at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 last_update_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str last_update_time: The last time this condition was updated.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of deployment condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of deployment condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentSpec(dict):
    """
    DeploymentSpec is the specification of the desired behavior of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "progressDeadlineSeconds":
            suggest = "progress_deadline_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "rollbackTo":
            suggest = "rollback_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[_builtins.int] = None,
                 paused: Optional[_builtins.bool] = None,
                 progress_deadline_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 rollback_to: Optional['outputs.RollbackConfig'] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 strategy: Optional['outputs.DeploymentStrategy'] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param '_core.v1.PodTemplateSpecArgs' template: Template describes the pods that will be created.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.bool paused: Indicates that the deployment is paused and will not be processed by the deployment controller.
        :param _builtins.int progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. This is set to the max value of int32 (i.e. 2147483647) by default, which means "no deadline".
        :param _builtins.int replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param _builtins.int revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. This is set to the max value of int32 (i.e. 2147483647) by default, which means "retaining all old RelicaSets".
        :param 'RollbackConfigArgs' rollback_to: DEPRECATED. The config this deployment is rolling back to. Will be cleared after rollback is done.
        :param '_meta.v1.LabelSelectorArgs' selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.
        :param 'DeploymentStrategyArgs' strategy: The deployment strategy to use to replace existing pods with new ones.
        """
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if rollback_to is not None:
            pulumi.set(__self__, "rollback_to", rollback_to)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        Template describes the pods that will be created.
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[_builtins.bool]:
        """
        Indicates that the deployment is paused and will not be processed by the deployment controller.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[_builtins.int]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. This is set to the max value of int32 (i.e. 2147483647) by default, which means "no deadline".
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. This is set to the max value of int32 (i.e. 2147483647) by default, which means "retaining all old RelicaSets".
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter(name="rollbackTo")
    def rollback_to(self) -> Optional['outputs.RollbackConfig']:
        """
        DEPRECATED. The config this deployment is rolling back to. Will be cleared after rollback is done.
        """
        return pulumi.get(self, "rollback_to")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.DeploymentStrategy']:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class DeploymentSpecPatch(dict):
    """
    DeploymentSpec is the specification of the desired behavior of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "progressDeadlineSeconds":
            suggest = "progress_deadline_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "rollbackTo":
            suggest = "rollback_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 paused: Optional[_builtins.bool] = None,
                 progress_deadline_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 rollback_to: Optional['outputs.RollbackConfigPatch'] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 strategy: Optional['outputs.DeploymentStrategyPatch'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.bool paused: Indicates that the deployment is paused and will not be processed by the deployment controller.
        :param _builtins.int progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. This is set to the max value of int32 (i.e. 2147483647) by default, which means "no deadline".
        :param _builtins.int replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param _builtins.int revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. This is set to the max value of int32 (i.e. 2147483647) by default, which means "retaining all old RelicaSets".
        :param 'RollbackConfigPatchArgs' rollback_to: DEPRECATED. The config this deployment is rolling back to. Will be cleared after rollback is done.
        :param '_meta.v1.LabelSelectorPatchArgs' selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.
        :param 'DeploymentStrategyPatchArgs' strategy: The deployment strategy to use to replace existing pods with new ones.
        :param '_core.v1.PodTemplateSpecPatchArgs' template: Template describes the pods that will be created.
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if rollback_to is not None:
            pulumi.set(__self__, "rollback_to", rollback_to)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[_builtins.bool]:
        """
        Indicates that the deployment is paused and will not be processed by the deployment controller.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[_builtins.int]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. This is set to the max value of int32 (i.e. 2147483647) by default, which means "no deadline".
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. This is set to the max value of int32 (i.e. 2147483647) by default, which means "retaining all old RelicaSets".
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter(name="rollbackTo")
    def rollback_to(self) -> Optional['outputs.RollbackConfigPatch']:
        """
        DEPRECATED. The config this deployment is rolling back to. Will be cleared after rollback is done.
        """
        return pulumi.get(self, "rollback_to")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.DeploymentStrategyPatch']:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        Template describes the pods that will be created.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class DeploymentStatus(dict):
    """
    DeploymentStatus is the most recently observed status of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "unavailableReplicas":
            suggest = "unavailable_replicas"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DeploymentCondition']] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 unavailable_replicas: Optional[_builtins.int] = None,
                 updated_replicas: Optional[_builtins.int] = None):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        :param _builtins.int available_replicas: Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
        :param _builtins.int collision_count: Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        :param Sequence['DeploymentConditionArgs'] conditions: Represents the latest available observations of a deployment's current state.
        :param _builtins.int observed_generation: The generation observed by the deployment controller.
        :param _builtins.int ready_replicas: Total number of ready pods targeted by this deployment.
        :param _builtins.int replicas: Total number of non-terminated pods targeted by this deployment (their labels match the selector).
        :param _builtins.int unavailable_replicas: Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        :param _builtins.int updated_replicas: Total number of non-terminated pods targeted by this deployment that have the desired template spec.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if unavailable_replicas is not None:
            pulumi.set(__self__, "unavailable_replicas", unavailable_replicas)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DeploymentCondition']]:
        """
        Represents the latest available observations of a deployment's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The generation observed by the deployment controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of ready pods targeted by this deployment.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminated pods targeted by this deployment (their labels match the selector).
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="unavailableReplicas")
    def unavailable_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        return pulumi.get(self, "unavailable_replicas")

    @_builtins.property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminated pods targeted by this deployment that have the desired template spec.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class DeploymentStatusPatch(dict):
    """
    DeploymentStatus is the most recently observed status of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "unavailableReplicas":
            suggest = "unavailable_replicas"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DeploymentConditionPatch']] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 unavailable_replicas: Optional[_builtins.int] = None,
                 updated_replicas: Optional[_builtins.int] = None):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        :param _builtins.int available_replicas: Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
        :param _builtins.int collision_count: Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        :param Sequence['DeploymentConditionPatchArgs'] conditions: Represents the latest available observations of a deployment's current state.
        :param _builtins.int observed_generation: The generation observed by the deployment controller.
        :param _builtins.int ready_replicas: Total number of ready pods targeted by this deployment.
        :param _builtins.int replicas: Total number of non-terminated pods targeted by this deployment (their labels match the selector).
        :param _builtins.int unavailable_replicas: Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        :param _builtins.int updated_replicas: Total number of non-terminated pods targeted by this deployment that have the desired template spec.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if unavailable_replicas is not None:
            pulumi.set(__self__, "unavailable_replicas", unavailable_replicas)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DeploymentConditionPatch']]:
        """
        Represents the latest available observations of a deployment's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The generation observed by the deployment controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of ready pods targeted by this deployment.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminated pods targeted by this deployment (their labels match the selector).
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="unavailableReplicas")
    def unavailable_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        return pulumi.get(self, "unavailable_replicas")

    @_builtins.property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminated pods targeted by this deployment that have the desired template spec.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class DeploymentStrategy(dict):
    """
    DeploymentStrategy describes how to replace existing pods with new ones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDeployment'] = None,
                 type: Optional[_builtins.str] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param 'RollingUpdateDeploymentArgs' rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param _builtins.str type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDeployment']:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentStrategyPatch(dict):
    """
    DeploymentStrategy describes how to replace existing pods with new ones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStrategyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStrategyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStrategyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDeploymentPatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param 'RollingUpdateDeploymentPatchArgs' rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param _builtins.str type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDeploymentPatch']:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FSGroupStrategyOptions(dict):
    """
    FSGroupStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use FSGroupStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 ranges: Optional[Sequence['outputs.IDRange']] = None,
                 rule: Optional[_builtins.str] = None):
        """
        FSGroupStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use FSGroupStrategyOptions from policy API Group instead.
        :param Sequence['IDRangeArgs'] ranges: ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
        :param _builtins.str rule: rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
        """
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRange']]:
        """
        ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class FSGroupStrategyOptionsPatch(dict):
    """
    FSGroupStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use FSGroupStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 ranges: Optional[Sequence['outputs.IDRangePatch']] = None,
                 rule: Optional[_builtins.str] = None):
        """
        FSGroupStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use FSGroupStrategyOptions from policy API Group instead.
        :param Sequence['IDRangePatchArgs'] ranges: ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
        :param _builtins.str rule: rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
        """
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRangePatch']]:
        """
        ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate what FSGroup is used in the SecurityContext.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class HTTPIngressPath(dict):
    """
    HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathType":
            suggest = "path_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPIngressPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPIngressPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPIngressPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: 'outputs.IngressBackend',
                 path: Optional[_builtins.str] = None,
                 path_type: Optional[_builtins.str] = None):
        """
        HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.
        :param 'IngressBackendArgs' backend: Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param _builtins.str path: Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.
        :param _builtins.str path_type: PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
                 done on a path element by element basis. A path element refers is the
                 list of labels in the path split by the '/' separator. A request is a
                 match for path p if every p is an element-wise prefix of p of the
                 request path. Note that if the last element of the path is a substring
                 of the last element in request path, it is not a match (e.g. /foo/bar
                 matches /foo/bar/baz, but does not match /foo/barbaz).
               * ImplementationSpecific: Interpretation of the Path matching is up to
                 the IngressClass. Implementations can treat this as a separate PathType
                 or treat it identically to Prefix or Exact path types.
               Implementations are required to support all path types. Defaults to ImplementationSpecific.
        """
        pulumi.set(__self__, "backend", backend)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_type is not None:
            pulumi.set(__self__, "path_type", path_type)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> 'outputs.IngressBackend':
        """
        Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathType")
    def path_type(self) -> Optional[_builtins.str]:
        """
        PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
          done on a path element by element basis. A path element refers is the
          list of labels in the path split by the '/' separator. A request is a
          match for path p if every p is an element-wise prefix of p of the
          request path. Note that if the last element of the path is a substring
          of the last element in request path, it is not a match (e.g. /foo/bar
          matches /foo/bar/baz, but does not match /foo/barbaz).
        * ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
        Implementations are required to support all path types. Defaults to ImplementationSpecific.
        """
        return pulumi.get(self, "path_type")


@pulumi.output_type
class HTTPIngressPathPatch(dict):
    """
    HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathType":
            suggest = "path_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPIngressPathPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPIngressPathPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPIngressPathPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: Optional['outputs.IngressBackendPatch'] = None,
                 path: Optional[_builtins.str] = None,
                 path_type: Optional[_builtins.str] = None):
        """
        HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.
        :param 'IngressBackendPatchArgs' backend: Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param _builtins.str path: Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.
        :param _builtins.str path_type: PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
                 done on a path element by element basis. A path element refers is the
                 list of labels in the path split by the '/' separator. A request is a
                 match for path p if every p is an element-wise prefix of p of the
                 request path. Note that if the last element of the path is a substring
                 of the last element in request path, it is not a match (e.g. /foo/bar
                 matches /foo/bar/baz, but does not match /foo/barbaz).
               * ImplementationSpecific: Interpretation of the Path matching is up to
                 the IngressClass. Implementations can treat this as a separate PathType
                 or treat it identically to Prefix or Exact path types.
               Implementations are required to support all path types. Defaults to ImplementationSpecific.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_type is not None:
            pulumi.set(__self__, "path_type", path_type)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional['outputs.IngressBackendPatch']:
        """
        Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. If unspecified, the path defaults to a catch all sending traffic to the backend.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathType")
    def path_type(self) -> Optional[_builtins.str]:
        """
        PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
          done on a path element by element basis. A path element refers is the
          list of labels in the path split by the '/' separator. A request is a
          match for path p if every p is an element-wise prefix of p of the
          request path. Note that if the last element of the path is a substring
          of the last element in request path, it is not a match (e.g. /foo/bar
          matches /foo/bar/baz, but does not match /foo/barbaz).
        * ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
        Implementations are required to support all path types. Defaults to ImplementationSpecific.
        """
        return pulumi.get(self, "path_type")


@pulumi.output_type
class HTTPIngressRuleValue(dict):
    """
    HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
    """
    def __init__(__self__, *,
                 paths: Sequence['outputs.HTTPIngressPath']):
        """
        HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
        :param Sequence['HTTPIngressPathArgs'] paths: A collection of paths that map requests to backends.
        """
        pulumi.set(__self__, "paths", paths)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence['outputs.HTTPIngressPath']:
        """
        A collection of paths that map requests to backends.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class HTTPIngressRuleValuePatch(dict):
    """
    HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
    """
    def __init__(__self__, *,
                 paths: Optional[Sequence['outputs.HTTPIngressPathPatch']] = None):
        """
        HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
        :param Sequence['HTTPIngressPathPatchArgs'] paths: A collection of paths that map requests to backends.
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[Sequence['outputs.HTTPIngressPathPatch']]:
        """
        A collection of paths that map requests to backends.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class HostPortRange(dict):
    """
    HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined. Deprecated: use HostPortRange from policy API Group instead.
    """
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int):
        """
        HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined. Deprecated: use HostPortRange from policy API Group instead.
        :param _builtins.int max: max is the end of the range, inclusive.
        :param _builtins.int min: min is the start of the range, inclusive.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        max is the end of the range, inclusive.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        min is the start of the range, inclusive.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class HostPortRangePatch(dict):
    """
    HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined. Deprecated: use HostPortRange from policy API Group instead.
    """
    def __init__(__self__, *,
                 max: Optional[_builtins.int] = None,
                 min: Optional[_builtins.int] = None):
        """
        HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined. Deprecated: use HostPortRange from policy API Group instead.
        :param _builtins.int max: max is the end of the range, inclusive.
        :param _builtins.int min: min is the start of the range, inclusive.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.int]:
        """
        max is the end of the range, inclusive.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.int]:
        """
        min is the start of the range, inclusive.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class IDRange(dict):
    """
    IDRange provides a min/max of an allowed range of IDs. Deprecated: use IDRange from policy API Group instead.
    """
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int):
        """
        IDRange provides a min/max of an allowed range of IDs. Deprecated: use IDRange from policy API Group instead.
        :param _builtins.int max: max is the end of the range, inclusive.
        :param _builtins.int min: min is the start of the range, inclusive.
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        max is the end of the range, inclusive.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        min is the start of the range, inclusive.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class IDRangePatch(dict):
    """
    IDRange provides a min/max of an allowed range of IDs. Deprecated: use IDRange from policy API Group instead.
    """
    def __init__(__self__, *,
                 max: Optional[_builtins.int] = None,
                 min: Optional[_builtins.int] = None):
        """
        IDRange provides a min/max of an allowed range of IDs. Deprecated: use IDRange from policy API Group instead.
        :param _builtins.int max: max is the end of the range, inclusive.
        :param _builtins.int min: min is the start of the range, inclusive.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.int]:
        """
        max is the end of the range, inclusive.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.int]:
        """
        min is the start of the range, inclusive.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class IPBlock(dict):
    """
    DEPRECATED 1.9 - This group version of IPBlock is deprecated by networking/v1/IPBlock. IPBlock describes a particular CIDR (Ex. "192.168.1.1/24") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "except":
            suggest = "except_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: _builtins.str,
                 except_: Optional[Sequence[_builtins.str]] = None):
        """
        DEPRECATED 1.9 - This group version of IPBlock is deprecated by networking/v1/IPBlock. IPBlock describes a particular CIDR (Ex. "192.168.1.1/24") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
        :param _builtins.str cidr: CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24"
        :param Sequence[_builtins.str] except_: Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range
        """
        pulumi.set(__self__, "cidr", cidr)
        if except_ is not None:
            pulumi.set(__self__, "except_", except_)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24"
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="except")
    def except_(self) -> Optional[Sequence[_builtins.str]]:
        """
        Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range
        """
        return pulumi.get(self, "except_")


@pulumi.output_type
class IPBlockPatch(dict):
    """
    DEPRECATED 1.9 - This group version of IPBlock is deprecated by networking/v1/IPBlock. IPBlock describes a particular CIDR (Ex. "192.168.1.1/24") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "except":
            suggest = "except_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPBlockPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPBlockPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPBlockPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: Optional[_builtins.str] = None,
                 except_: Optional[Sequence[_builtins.str]] = None):
        """
        DEPRECATED 1.9 - This group version of IPBlock is deprecated by networking/v1/IPBlock. IPBlock describes a particular CIDR (Ex. "192.168.1.1/24") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
        :param _builtins.str cidr: CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24"
        :param Sequence[_builtins.str] except_: Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if except_ is not None:
            pulumi.set(__self__, "except_", except_)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[_builtins.str]:
        """
        CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24"
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="except")
    def except_(self) -> Optional[Sequence[_builtins.str]]:
        """
        Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" Except values will be rejected if they are outside the CIDR range
        """
        return pulumi.get(self, "except_")


@pulumi.output_type
class Ingress(dict):
    """
    Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc. 

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1.  Ingress object exists.
    2.  Endpoint objects exist with matching names for each Ingress path (except when Service
        type is ExternalName).
    3.  Ingress entry exists for '.status.loadBalancer.ingress'.

    If the Ingress has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Ingress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Ingress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Ingress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.IngressSpec'] = None,
                 status: Optional['outputs.IngressStatus'] = None):
        """
        Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc. 

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1.  Ingress object exists.
        2.  Endpoint objects exist with matching names for each Ingress path (except when Service
            type is ExternalName).
        3.  Ingress entry exists for '.status.loadBalancer.ingress'.

        If the Ingress has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'IngressSpecArgs' spec: Spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'IngressStatusArgs' status: Status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'extensions/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Ingress')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.IngressSpec']:
        """
        Spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.IngressStatus']:
        """
        Status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class IngressBackend(dict):
    """
    IngressBackend describes all endpoints for a given service and port.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"
        elif key == "servicePort":
            suggest = "service_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: _builtins.str,
                 service_port: Any,
                 resource: Optional['_core.v1.outputs.TypedLocalObjectReference'] = None):
        """
        IngressBackend describes all endpoints for a given service and port.
        :param _builtins.str service_name: Specifies the name of the referenced service.
        :param Union[_builtins.int, _builtins.str] service_port: Specifies the port of the referenced service.
        :param '_core.v1.TypedLocalObjectReferenceArgs' resource: Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
        """
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_port", service_port)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        Specifies the name of the referenced service.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Any:
        """
        Specifies the port of the referenced service.
        """
        return pulumi.get(self, "service_port")

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['_core.v1.outputs.TypedLocalObjectReference']:
        """
        Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class IngressBackendPatch(dict):
    """
    IngressBackend describes all endpoints for a given service and port.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"
        elif key == "servicePort":
            suggest = "service_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressBackendPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressBackendPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressBackendPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource: Optional['_core.v1.outputs.TypedLocalObjectReferencePatch'] = None,
                 service_name: Optional[_builtins.str] = None,
                 service_port: Optional[Any] = None):
        """
        IngressBackend describes all endpoints for a given service and port.
        :param '_core.v1.TypedLocalObjectReferencePatchArgs' resource: Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
        :param _builtins.str service_name: Specifies the name of the referenced service.
        :param Union[_builtins.int, _builtins.str] service_port: Specifies the port of the referenced service.
        """
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> Optional['_core.v1.outputs.TypedLocalObjectReferencePatch']:
        """
        Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
        """
        return pulumi.get(self, "resource")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the referenced service.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[Any]:
        """
        Specifies the port of the referenced service.
        """
        return pulumi.get(self, "service_port")


@pulumi.output_type
class IngressRule(dict):
    """
    IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
    """
    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 http: Optional['outputs.HTTPIngressRuleValue'] = None):
        """
        IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
        :param _builtins.str host: Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the
               	  IP in the Spec of the parent Ingress.
               2. The `:` delimiter is not respected because ports are not allowed.
               	  Currently the port of an Ingress is implicitly :80 for http and
               	  :443 for https.
               Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the
        	  IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional['outputs.HTTPIngressRuleValue']:
        return pulumi.get(self, "http")


@pulumi.output_type
class IngressRulePatch(dict):
    """
    IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
    """
    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 http: Optional['outputs.HTTPIngressRuleValuePatch'] = None):
        """
        IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
        :param _builtins.str host: Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the
               	  IP in the Spec of the parent Ingress.
               2. The `:` delimiter is not respected because ports are not allowed.
               	  Currently the port of an Ingress is implicitly :80 for http and
               	  :443 for https.
               Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the
        	  IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional['outputs.HTTPIngressRuleValuePatch']:
        return pulumi.get(self, "http")


@pulumi.output_type
class IngressSpec(dict):
    """
    IngressSpec describes the Ingress the user wishes to exist.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressClassName":
            suggest = "ingress_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: Optional['outputs.IngressBackend'] = None,
                 ingress_class_name: Optional[_builtins.str] = None,
                 rules: Optional[Sequence['outputs.IngressRule']] = None,
                 tls: Optional[Sequence['outputs.IngressTLS']] = None):
        """
        IngressSpec describes the Ingress the user wishes to exist.
        :param 'IngressBackendArgs' backend: A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.
        :param _builtins.str ingress_class_name: IngressClassName is the name of the IngressClass cluster resource. The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
        :param Sequence['IngressRuleArgs'] rules: A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param Sequence['IngressTLSArgs'] tls: TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional['outputs.IngressBackend']:
        """
        A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[_builtins.str]:
        """
        IngressClassName is the name of the IngressClass cluster resource. The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
        """
        return pulumi.get(self, "ingress_class_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.IngressRule']]:
        """
        A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[Sequence['outputs.IngressTLS']]:
        """
        TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class IngressSpecPatch(dict):
    """
    IngressSpec describes the Ingress the user wishes to exist.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressClassName":
            suggest = "ingress_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend: Optional['outputs.IngressBackendPatch'] = None,
                 ingress_class_name: Optional[_builtins.str] = None,
                 rules: Optional[Sequence['outputs.IngressRulePatch']] = None,
                 tls: Optional[Sequence['outputs.IngressTLSPatch']] = None):
        """
        IngressSpec describes the Ingress the user wishes to exist.
        :param 'IngressBackendPatchArgs' backend: A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.
        :param _builtins.str ingress_class_name: IngressClassName is the name of the IngressClass cluster resource. The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
        :param Sequence['IngressRulePatchArgs'] rules: A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param Sequence['IngressTLSPatchArgs'] tls: TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def backend(self) -> Optional['outputs.IngressBackendPatch']:
        """
        A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.
        """
        return pulumi.get(self, "backend")

    @_builtins.property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[_builtins.str]:
        """
        IngressClassName is the name of the IngressClass cluster resource. The associated IngressClass defines which controller will implement the resource. This replaces the deprecated `kubernetes.io/ingress.class` annotation. For backwards compatibility, when that annotation is set, it must be given precedence over this field. The controller may emit a warning if the field and annotation have different values. Implementations of this API should ignore Ingresses without a class specified. An IngressClass resource may be marked as default, which can be used to set a default value for this field. For more information, refer to the IngressClass documentation.
        """
        return pulumi.get(self, "ingress_class_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.IngressRulePatch']]:
        """
        A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[Sequence['outputs.IngressTLSPatch']]:
        """
        TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class IngressStatus(dict):
    """
    IngressStatus describe the current state of the Ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancer":
            suggest = "load_balancer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer: Optional['_core.v1.outputs.LoadBalancerStatus'] = None):
        """
        IngressStatus describe the current state of the Ingress.
        :param '_core.v1.LoadBalancerStatusArgs' load_balancer: LoadBalancer contains the current status of the load-balancer.
        """
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['_core.v1.outputs.LoadBalancerStatus']:
        """
        LoadBalancer contains the current status of the load-balancer.
        """
        return pulumi.get(self, "load_balancer")


@pulumi.output_type
class IngressStatusPatch(dict):
    """
    IngressStatus describe the current state of the Ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancer":
            suggest = "load_balancer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancer: Optional['_core.v1.outputs.LoadBalancerStatusPatch'] = None):
        """
        IngressStatus describe the current state of the Ingress.
        :param '_core.v1.LoadBalancerStatusPatchArgs' load_balancer: LoadBalancer contains the current status of the load-balancer.
        """
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['_core.v1.outputs.LoadBalancerStatusPatch']:
        """
        LoadBalancer contains the current status of the load-balancer.
        """
        return pulumi.get(self, "load_balancer")


@pulumi.output_type
class IngressTLS(dict):
    """
    IngressTLS describes the transport layer security associated with an Ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressTLS. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressTLS.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressTLS.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Optional[Sequence[_builtins.str]] = None,
                 secret_name: Optional[_builtins.str] = None):
        """
        IngressTLS describes the transport layer security associated with an Ingress.
        :param Sequence[_builtins.str] hosts: Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param _builtins.str secret_name: SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class IngressTLSPatch(dict):
    """
    IngressTLS describes the transport layer security associated with an Ingress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressTLSPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressTLSPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressTLSPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Optional[Sequence[_builtins.str]] = None,
                 secret_name: Optional[_builtins.str] = None):
        """
        IngressTLS describes the transport layer security associated with an Ingress.
        :param Sequence[_builtins.str] hosts: Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param _builtins.str secret_name: SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class NetworkPolicy(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.NetworkPolicySpec'] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'NetworkPolicySpecArgs' spec: Specification of the desired behavior for this NetworkPolicy.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'extensions/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'NetworkPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.NetworkPolicySpec']:
        """
        Specification of the desired behavior for this NetworkPolicy.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class NetworkPolicyEgressRule(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyEgressRule is deprecated by networking/v1/NetworkPolicyEgressRule. NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
    """
    def __init__(__self__, *,
                 ports: Optional[Sequence['outputs.NetworkPolicyPort']] = None,
                 to: Optional[Sequence['outputs.NetworkPolicyPeer']] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyEgressRule is deprecated by networking/v1/NetworkPolicyEgressRule. NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
        :param Sequence['NetworkPolicyPortArgs'] ports: List of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        :param Sequence['NetworkPolicyPeerArgs'] to: List of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPort']]:
        """
        List of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[Sequence['outputs.NetworkPolicyPeer']]:
        """
        List of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class NetworkPolicyEgressRulePatch(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyEgressRule is deprecated by networking/v1/NetworkPolicyEgressRule. NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
    """
    def __init__(__self__, *,
                 ports: Optional[Sequence['outputs.NetworkPolicyPortPatch']] = None,
                 to: Optional[Sequence['outputs.NetworkPolicyPeerPatch']] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyEgressRule is deprecated by networking/v1/NetworkPolicyEgressRule. NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
        :param Sequence['NetworkPolicyPortPatchArgs'] ports: List of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        :param Sequence['NetworkPolicyPeerPatchArgs'] to: List of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPortPatch']]:
        """
        List of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def to(self) -> Optional[Sequence['outputs.NetworkPolicyPeerPatch']]:
        """
        List of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class NetworkPolicyIngressRule(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyIngressRule is deprecated by networking/v1/NetworkPolicyIngressRule. This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyIngressRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyIngressRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyIngressRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[Sequence['outputs.NetworkPolicyPeer']] = None,
                 ports: Optional[Sequence['outputs.NetworkPolicyPort']] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyIngressRule is deprecated by networking/v1/NetworkPolicyIngressRule. This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.
        :param Sequence['NetworkPolicyPeerArgs'] from_: List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        :param Sequence['NetworkPolicyPortArgs'] ports: List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[Sequence['outputs.NetworkPolicyPeer']]:
        """
        List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPort']]:
        """
        List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class NetworkPolicyIngressRulePatch(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyIngressRule is deprecated by networking/v1/NetworkPolicyIngressRule. This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyIngressRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyIngressRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyIngressRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: Optional[Sequence['outputs.NetworkPolicyPeerPatch']] = None,
                 ports: Optional[Sequence['outputs.NetworkPolicyPortPatch']] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyIngressRule is deprecated by networking/v1/NetworkPolicyIngressRule. This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.
        :param Sequence['NetworkPolicyPeerPatchArgs'] from_: List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        :param Sequence['NetworkPolicyPortPatchArgs'] ports: List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[Sequence['outputs.NetworkPolicyPeerPatch']]:
        """
        List of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.NetworkPolicyPortPatch']]:
        """
        List of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class NetworkPolicyPeer(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyPeer is deprecated by networking/v1/NetworkPolicyPeer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipBlock":
            suggest = "ip_block"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "podSelector":
            suggest = "pod_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyPeer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyPeer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyPeer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_block: Optional['outputs.IPBlock'] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 pod_selector: Optional['_meta.v1.outputs.LabelSelector'] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyPeer is deprecated by networking/v1/NetworkPolicyPeer.
        :param 'IPBlockArgs' ip_block: IPBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: Selects Namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.
               
               If PodSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
        :param '_meta.v1.LabelSelectorArgs' pod_selector: This is a label selector which selects Pods. This field follows standard label selector semantics; if present but empty, it selects all pods.
               
               If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
        """
        if ip_block is not None:
            pulumi.set(__self__, "ip_block", ip_block)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)

    @_builtins.property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> Optional['outputs.IPBlock']:
        """
        IPBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        """
        return pulumi.get(self, "ip_block")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        Selects Namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

        If PodSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        This is a label selector which selects Pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

        If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
        """
        return pulumi.get(self, "pod_selector")


@pulumi.output_type
class NetworkPolicyPeerPatch(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyPeer is deprecated by networking/v1/NetworkPolicyPeer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipBlock":
            suggest = "ip_block"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "podSelector":
            suggest = "pod_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyPeerPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyPeerPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyPeerPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_block: Optional['outputs.IPBlockPatch'] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 pod_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyPeer is deprecated by networking/v1/NetworkPolicyPeer.
        :param 'IPBlockPatchArgs' ip_block: IPBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: Selects Namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.
               
               If PodSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
        :param '_meta.v1.LabelSelectorPatchArgs' pod_selector: This is a label selector which selects Pods. This field follows standard label selector semantics; if present but empty, it selects all pods.
               
               If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
        """
        if ip_block is not None:
            pulumi.set(__self__, "ip_block", ip_block)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)

    @_builtins.property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> Optional['outputs.IPBlockPatch']:
        """
        IPBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        """
        return pulumi.get(self, "ip_block")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Selects Namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

        If PodSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        This is a label selector which selects Pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

        If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the Pods matching PodSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
        """
        return pulumi.get(self, "pod_selector")


@pulumi.output_type
class NetworkPolicyPort(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyPort is deprecated by networking/v1/NetworkPolicyPort.
    """
    def __init__(__self__, *,
                 port: Optional[Any] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyPort is deprecated by networking/v1/NetworkPolicyPort.
        :param Union[_builtins.int, _builtins.str] port: If specified, the port on the given protocol.  This can either be a numerical or named port on a pod.  If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        :param _builtins.str protocol: Optional.  The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        If specified, the port on the given protocol.  This can either be a numerical or named port on a pod.  If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Optional.  The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkPolicyPortPatch(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicyPort is deprecated by networking/v1/NetworkPolicyPort.
    """
    def __init__(__self__, *,
                 port: Optional[Any] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicyPort is deprecated by networking/v1/NetworkPolicyPort.
        :param Union[_builtins.int, _builtins.str] port: If specified, the port on the given protocol.  This can either be a numerical or named port on a pod.  If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        :param _builtins.str protocol: Optional.  The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        If specified, the port on the given protocol.  This can either be a numerical or named port on a pod.  If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Optional.  The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkPolicySpec(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicySpec is deprecated by networking/v1/NetworkPolicySpec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podSelector":
            suggest = "pod_selector"
        elif key == "policyTypes":
            suggest = "policy_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pod_selector: '_meta.v1.outputs.LabelSelector',
                 egress: Optional[Sequence['outputs.NetworkPolicyEgressRule']] = None,
                 ingress: Optional[Sequence['outputs.NetworkPolicyIngressRule']] = None,
                 policy_types: Optional[Sequence[_builtins.str]] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicySpec is deprecated by networking/v1/NetworkPolicySpec.
        :param '_meta.v1.LabelSelectorArgs' pod_selector: Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        :param Sequence['NetworkPolicyEgressRuleArgs'] egress: List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        :param Sequence['NetworkPolicyIngressRuleArgs'] ingress: List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default).
        :param Sequence[_builtins.str] policy_types: List of rule types that the NetworkPolicy relates to. Valid options are "Ingress", "Egress", or "Ingress,Egress". If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an Egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        pulumi.set(__self__, "pod_selector", pod_selector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if policy_types is not None:
            pulumi.set(__self__, "policy_types", policy_types)

    @_builtins.property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        """
        return pulumi.get(self, "pod_selector")

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[Sequence['outputs.NetworkPolicyEgressRule']]:
        """
        List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.NetworkPolicyIngressRule']]:
        """
        List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default).
        """
        return pulumi.get(self, "ingress")

    @_builtins.property
    @pulumi.getter(name="policyTypes")
    def policy_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of rule types that the NetworkPolicy relates to. Valid options are "Ingress", "Egress", or "Ingress,Egress". If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an Egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        return pulumi.get(self, "policy_types")


@pulumi.output_type
class NetworkPolicySpecPatch(dict):
    """
    DEPRECATED 1.9 - This group version of NetworkPolicySpec is deprecated by networking/v1/NetworkPolicySpec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podSelector":
            suggest = "pod_selector"
        elif key == "policyTypes":
            suggest = "policy_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicySpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicySpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicySpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress: Optional[Sequence['outputs.NetworkPolicyEgressRulePatch']] = None,
                 ingress: Optional[Sequence['outputs.NetworkPolicyIngressRulePatch']] = None,
                 pod_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 policy_types: Optional[Sequence[_builtins.str]] = None):
        """
        DEPRECATED 1.9 - This group version of NetworkPolicySpec is deprecated by networking/v1/NetworkPolicySpec.
        :param Sequence['NetworkPolicyEgressRulePatchArgs'] egress: List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        :param Sequence['NetworkPolicyIngressRulePatchArgs'] ingress: List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default).
        :param '_meta.v1.LabelSelectorPatchArgs' pod_selector: Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        :param Sequence[_builtins.str] policy_types: List of rule types that the NetworkPolicy relates to. Valid options are "Ingress", "Egress", or "Ingress,Egress". If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an Egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)
        if policy_types is not None:
            pulumi.set(__self__, "policy_types", policy_types)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[Sequence['outputs.NetworkPolicyEgressRulePatch']]:
        """
        List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.NetworkPolicyIngressRulePatch']]:
        """
        List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default).
        """
        return pulumi.get(self, "ingress")

    @_builtins.property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        """
        return pulumi.get(self, "pod_selector")

    @_builtins.property
    @pulumi.getter(name="policyTypes")
    def policy_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of rule types that the NetworkPolicy relates to. Valid options are "Ingress", "Egress", or "Ingress,Egress". If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an Egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        return pulumi.get(self, "policy_types")


@pulumi.output_type
class PodSecurityPolicy(dict):
    """
    PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container. Deprecated: use PodSecurityPolicy from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSecurityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSecurityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSecurityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.PodSecurityPolicySpec'] = None):
        """
        PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container. Deprecated: use PodSecurityPolicy from policy API Group instead.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PodSecurityPolicySpecArgs' spec: spec defines the policy enforced.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'extensions/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodSecurityPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PodSecurityPolicySpec']:
        """
        spec defines the policy enforced.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class PodSecurityPolicySpec(dict):
    """
    PodSecurityPolicySpec defines the policy enforced. Deprecated: use PodSecurityPolicySpec from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsGroup":
            suggest = "fs_group"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "seLinux":
            suggest = "se_linux"
        elif key == "supplementalGroups":
            suggest = "supplemental_groups"
        elif key == "allowPrivilegeEscalation":
            suggest = "allow_privilege_escalation"
        elif key == "allowedCSIDrivers":
            suggest = "allowed_csi_drivers"
        elif key == "allowedCapabilities":
            suggest = "allowed_capabilities"
        elif key == "allowedFlexVolumes":
            suggest = "allowed_flex_volumes"
        elif key == "allowedHostPaths":
            suggest = "allowed_host_paths"
        elif key == "allowedProcMountTypes":
            suggest = "allowed_proc_mount_types"
        elif key == "allowedUnsafeSysctls":
            suggest = "allowed_unsafe_sysctls"
        elif key == "defaultAddCapabilities":
            suggest = "default_add_capabilities"
        elif key == "defaultAllowPrivilegeEscalation":
            suggest = "default_allow_privilege_escalation"
        elif key == "forbiddenSysctls":
            suggest = "forbidden_sysctls"
        elif key == "hostIPC":
            suggest = "host_ipc"
        elif key == "hostNetwork":
            suggest = "host_network"
        elif key == "hostPID":
            suggest = "host_pid"
        elif key == "hostPorts":
            suggest = "host_ports"
        elif key == "readOnlyRootFilesystem":
            suggest = "read_only_root_filesystem"
        elif key == "requiredDropCapabilities":
            suggest = "required_drop_capabilities"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runtimeClass":
            suggest = "runtime_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSecurityPolicySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSecurityPolicySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSecurityPolicySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_group: 'outputs.FSGroupStrategyOptions',
                 run_as_user: 'outputs.RunAsUserStrategyOptions',
                 se_linux: 'outputs.SELinuxStrategyOptions',
                 supplemental_groups: 'outputs.SupplementalGroupsStrategyOptions',
                 allow_privilege_escalation: Optional[_builtins.bool] = None,
                 allowed_csi_drivers: Optional[Sequence['outputs.AllowedCSIDriver']] = None,
                 allowed_capabilities: Optional[Sequence[_builtins.str]] = None,
                 allowed_flex_volumes: Optional[Sequence['outputs.AllowedFlexVolume']] = None,
                 allowed_host_paths: Optional[Sequence['outputs.AllowedHostPath']] = None,
                 allowed_proc_mount_types: Optional[Sequence[_builtins.str]] = None,
                 allowed_unsafe_sysctls: Optional[Sequence[_builtins.str]] = None,
                 default_add_capabilities: Optional[Sequence[_builtins.str]] = None,
                 default_allow_privilege_escalation: Optional[_builtins.bool] = None,
                 forbidden_sysctls: Optional[Sequence[_builtins.str]] = None,
                 host_ipc: Optional[_builtins.bool] = None,
                 host_network: Optional[_builtins.bool] = None,
                 host_pid: Optional[_builtins.bool] = None,
                 host_ports: Optional[Sequence['outputs.HostPortRange']] = None,
                 privileged: Optional[_builtins.bool] = None,
                 read_only_root_filesystem: Optional[_builtins.bool] = None,
                 required_drop_capabilities: Optional[Sequence[_builtins.str]] = None,
                 run_as_group: Optional['outputs.RunAsGroupStrategyOptions'] = None,
                 runtime_class: Optional['outputs.RuntimeClassStrategyOptions'] = None,
                 volumes: Optional[Sequence[_builtins.str]] = None):
        """
        PodSecurityPolicySpec defines the policy enforced. Deprecated: use PodSecurityPolicySpec from policy API Group instead.
        :param 'FSGroupStrategyOptionsArgs' fs_group: fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.
        :param 'RunAsUserStrategyOptionsArgs' run_as_user: runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.
        :param 'SELinuxStrategyOptionsArgs' se_linux: seLinux is the strategy that will dictate the allowable labels that may be set.
        :param 'SupplementalGroupsStrategyOptionsArgs' supplemental_groups: supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.
        :param _builtins.bool allow_privilege_escalation: allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.
        :param Sequence['AllowedCSIDriverArgs'] allowed_csi_drivers: AllowedCSIDrivers is a whitelist of inline CSI drivers that must be explicitly set to be embedded within a pod spec. An empty value indicates that any CSI driver can be used for inline ephemeral volumes.
        :param Sequence[_builtins.str] allowed_capabilities: allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
        :param Sequence['AllowedFlexVolumeArgs'] allowed_flex_volumes: allowedFlexVolumes is a whitelist of allowed Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the "volumes" field.
        :param Sequence['AllowedHostPathArgs'] allowed_host_paths: allowedHostPaths is a white list of allowed host paths. Empty indicates that all host paths may be used.
        :param Sequence[_builtins.str] allowed_proc_mount_types: AllowedProcMountTypes is a whitelist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
        :param Sequence[_builtins.str] allowed_unsafe_sysctls: allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to whitelist all allowed unsafe sysctls explicitly to avoid rejection.
               
               Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
        :param Sequence[_builtins.str] default_add_capabilities: defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
        :param _builtins.bool default_allow_privilege_escalation: defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
        :param Sequence[_builtins.str] forbidden_sysctls: forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.
               
               Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
        :param _builtins.bool host_ipc: hostIPC determines if the policy allows the use of HostIPC in the pod spec.
        :param _builtins.bool host_network: hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
        :param _builtins.bool host_pid: hostPID determines if the policy allows the use of HostPID in the pod spec.
        :param Sequence['HostPortRangeArgs'] host_ports: hostPorts determines which host port ranges are allowed to be exposed.
        :param _builtins.bool privileged: privileged determines if a pod can request to be run as privileged.
        :param _builtins.bool read_only_root_filesystem: readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
        :param Sequence[_builtins.str] required_drop_capabilities: requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.
        :param 'RunAsGroupStrategyOptionsArgs' run_as_group: RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set. If this field is omitted, the pod's RunAsGroup can take any value. This field requires the RunAsGroup feature gate to be enabled.
        :param 'RuntimeClassStrategyOptionsArgs' runtime_class: runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod. If this field is omitted, the pod's runtimeClassName field is unrestricted. Enforcement of this field depends on the RuntimeClass feature gate being enabled.
        :param Sequence[_builtins.str] volumes: volumes is a white list of allowed volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
        """
        pulumi.set(__self__, "fs_group", fs_group)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "se_linux", se_linux)
        pulumi.set(__self__, "supplemental_groups", supplemental_groups)
        if allow_privilege_escalation is not None:
            pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        if allowed_csi_drivers is not None:
            pulumi.set(__self__, "allowed_csi_drivers", allowed_csi_drivers)
        if allowed_capabilities is not None:
            pulumi.set(__self__, "allowed_capabilities", allowed_capabilities)
        if allowed_flex_volumes is not None:
            pulumi.set(__self__, "allowed_flex_volumes", allowed_flex_volumes)
        if allowed_host_paths is not None:
            pulumi.set(__self__, "allowed_host_paths", allowed_host_paths)
        if allowed_proc_mount_types is not None:
            pulumi.set(__self__, "allowed_proc_mount_types", allowed_proc_mount_types)
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if default_add_capabilities is not None:
            pulumi.set(__self__, "default_add_capabilities", default_add_capabilities)
        if default_allow_privilege_escalation is not None:
            pulumi.set(__self__, "default_allow_privilege_escalation", default_allow_privilege_escalation)
        if forbidden_sysctls is not None:
            pulumi.set(__self__, "forbidden_sysctls", forbidden_sysctls)
        if host_ipc is not None:
            pulumi.set(__self__, "host_ipc", host_ipc)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if host_pid is not None:
            pulumi.set(__self__, "host_pid", host_pid)
        if host_ports is not None:
            pulumi.set(__self__, "host_ports", host_ports)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_filesystem is not None:
            pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        if required_drop_capabilities is not None:
            pulumi.set(__self__, "required_drop_capabilities", required_drop_capabilities)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if runtime_class is not None:
            pulumi.set(__self__, "runtime_class", runtime_class)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="fsGroup")
    def fs_group(self) -> 'outputs.FSGroupStrategyOptions':
        """
        fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.
        """
        return pulumi.get(self, "fs_group")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> 'outputs.RunAsUserStrategyOptions':
        """
        runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="seLinux")
    def se_linux(self) -> 'outputs.SELinuxStrategyOptions':
        """
        seLinux is the strategy that will dictate the allowable labels that may be set.
        """
        return pulumi.get(self, "se_linux")

    @_builtins.property
    @pulumi.getter(name="supplementalGroups")
    def supplemental_groups(self) -> 'outputs.SupplementalGroupsStrategyOptions':
        """
        supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.
        """
        return pulumi.get(self, "supplemental_groups")

    @_builtins.property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> Optional[_builtins.bool]:
        """
        allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @_builtins.property
    @pulumi.getter(name="allowedCSIDrivers")
    def allowed_csi_drivers(self) -> Optional[Sequence['outputs.AllowedCSIDriver']]:
        """
        AllowedCSIDrivers is a whitelist of inline CSI drivers that must be explicitly set to be embedded within a pod spec. An empty value indicates that any CSI driver can be used for inline ephemeral volumes.
        """
        return pulumi.get(self, "allowed_csi_drivers")

    @_builtins.property
    @pulumi.getter(name="allowedCapabilities")
    def allowed_capabilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
        """
        return pulumi.get(self, "allowed_capabilities")

    @_builtins.property
    @pulumi.getter(name="allowedFlexVolumes")
    def allowed_flex_volumes(self) -> Optional[Sequence['outputs.AllowedFlexVolume']]:
        """
        allowedFlexVolumes is a whitelist of allowed Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the "volumes" field.
        """
        return pulumi.get(self, "allowed_flex_volumes")

    @_builtins.property
    @pulumi.getter(name="allowedHostPaths")
    def allowed_host_paths(self) -> Optional[Sequence['outputs.AllowedHostPath']]:
        """
        allowedHostPaths is a white list of allowed host paths. Empty indicates that all host paths may be used.
        """
        return pulumi.get(self, "allowed_host_paths")

    @_builtins.property
    @pulumi.getter(name="allowedProcMountTypes")
    def allowed_proc_mount_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        AllowedProcMountTypes is a whitelist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
        """
        return pulumi.get(self, "allowed_proc_mount_types")

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[Sequence[_builtins.str]]:
        """
        allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to whitelist all allowed unsafe sysctls explicitly to avoid rejection.

        Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @_builtins.property
    @pulumi.getter(name="defaultAddCapabilities")
    def default_add_capabilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
        """
        return pulumi.get(self, "default_add_capabilities")

    @_builtins.property
    @pulumi.getter(name="defaultAllowPrivilegeEscalation")
    def default_allow_privilege_escalation(self) -> Optional[_builtins.bool]:
        """
        defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
        """
        return pulumi.get(self, "default_allow_privilege_escalation")

    @_builtins.property
    @pulumi.getter(name="forbiddenSysctls")
    def forbidden_sysctls(self) -> Optional[Sequence[_builtins.str]]:
        """
        forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.

        Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
        """
        return pulumi.get(self, "forbidden_sysctls")

    @_builtins.property
    @pulumi.getter(name="hostIPC")
    def host_ipc(self) -> Optional[_builtins.bool]:
        """
        hostIPC determines if the policy allows the use of HostIPC in the pod spec.
        """
        return pulumi.get(self, "host_ipc")

    @_builtins.property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[_builtins.bool]:
        """
        hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
        """
        return pulumi.get(self, "host_network")

    @_builtins.property
    @pulumi.getter(name="hostPID")
    def host_pid(self) -> Optional[_builtins.bool]:
        """
        hostPID determines if the policy allows the use of HostPID in the pod spec.
        """
        return pulumi.get(self, "host_pid")

    @_builtins.property
    @pulumi.getter(name="hostPorts")
    def host_ports(self) -> Optional[Sequence['outputs.HostPortRange']]:
        """
        hostPorts determines which host port ranges are allowed to be exposed.
        """
        return pulumi.get(self, "host_ports")

    @_builtins.property
    @pulumi.getter
    def privileged(self) -> Optional[_builtins.bool]:
        """
        privileged determines if a pod can request to be run as privileged.
        """
        return pulumi.get(self, "privileged")

    @_builtins.property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> Optional[_builtins.bool]:
        """
        readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @_builtins.property
    @pulumi.getter(name="requiredDropCapabilities")
    def required_drop_capabilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.
        """
        return pulumi.get(self, "required_drop_capabilities")

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional['outputs.RunAsGroupStrategyOptions']:
        """
        RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set. If this field is omitted, the pod's RunAsGroup can take any value. This field requires the RunAsGroup feature gate to be enabled.
        """
        return pulumi.get(self, "run_as_group")

    @_builtins.property
    @pulumi.getter(name="runtimeClass")
    def runtime_class(self) -> Optional['outputs.RuntimeClassStrategyOptions']:
        """
        runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod. If this field is omitted, the pod's runtimeClassName field is unrestricted. Enforcement of this field depends on the RuntimeClass feature gate being enabled.
        """
        return pulumi.get(self, "runtime_class")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence[_builtins.str]]:
        """
        volumes is a white list of allowed volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class PodSecurityPolicySpecPatch(dict):
    """
    PodSecurityPolicySpec defines the policy enforced. Deprecated: use PodSecurityPolicySpec from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPrivilegeEscalation":
            suggest = "allow_privilege_escalation"
        elif key == "allowedCSIDrivers":
            suggest = "allowed_csi_drivers"
        elif key == "allowedCapabilities":
            suggest = "allowed_capabilities"
        elif key == "allowedFlexVolumes":
            suggest = "allowed_flex_volumes"
        elif key == "allowedHostPaths":
            suggest = "allowed_host_paths"
        elif key == "allowedProcMountTypes":
            suggest = "allowed_proc_mount_types"
        elif key == "allowedUnsafeSysctls":
            suggest = "allowed_unsafe_sysctls"
        elif key == "defaultAddCapabilities":
            suggest = "default_add_capabilities"
        elif key == "defaultAllowPrivilegeEscalation":
            suggest = "default_allow_privilege_escalation"
        elif key == "forbiddenSysctls":
            suggest = "forbidden_sysctls"
        elif key == "fsGroup":
            suggest = "fs_group"
        elif key == "hostIPC":
            suggest = "host_ipc"
        elif key == "hostNetwork":
            suggest = "host_network"
        elif key == "hostPID":
            suggest = "host_pid"
        elif key == "hostPorts":
            suggest = "host_ports"
        elif key == "readOnlyRootFilesystem":
            suggest = "read_only_root_filesystem"
        elif key == "requiredDropCapabilities":
            suggest = "required_drop_capabilities"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "runtimeClass":
            suggest = "runtime_class"
        elif key == "seLinux":
            suggest = "se_linux"
        elif key == "supplementalGroups":
            suggest = "supplemental_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSecurityPolicySpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSecurityPolicySpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSecurityPolicySpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_privilege_escalation: Optional[_builtins.bool] = None,
                 allowed_csi_drivers: Optional[Sequence['outputs.AllowedCSIDriverPatch']] = None,
                 allowed_capabilities: Optional[Sequence[_builtins.str]] = None,
                 allowed_flex_volumes: Optional[Sequence['outputs.AllowedFlexVolumePatch']] = None,
                 allowed_host_paths: Optional[Sequence['outputs.AllowedHostPathPatch']] = None,
                 allowed_proc_mount_types: Optional[Sequence[_builtins.str]] = None,
                 allowed_unsafe_sysctls: Optional[Sequence[_builtins.str]] = None,
                 default_add_capabilities: Optional[Sequence[_builtins.str]] = None,
                 default_allow_privilege_escalation: Optional[_builtins.bool] = None,
                 forbidden_sysctls: Optional[Sequence[_builtins.str]] = None,
                 fs_group: Optional['outputs.FSGroupStrategyOptionsPatch'] = None,
                 host_ipc: Optional[_builtins.bool] = None,
                 host_network: Optional[_builtins.bool] = None,
                 host_pid: Optional[_builtins.bool] = None,
                 host_ports: Optional[Sequence['outputs.HostPortRangePatch']] = None,
                 privileged: Optional[_builtins.bool] = None,
                 read_only_root_filesystem: Optional[_builtins.bool] = None,
                 required_drop_capabilities: Optional[Sequence[_builtins.str]] = None,
                 run_as_group: Optional['outputs.RunAsGroupStrategyOptionsPatch'] = None,
                 run_as_user: Optional['outputs.RunAsUserStrategyOptionsPatch'] = None,
                 runtime_class: Optional['outputs.RuntimeClassStrategyOptionsPatch'] = None,
                 se_linux: Optional['outputs.SELinuxStrategyOptionsPatch'] = None,
                 supplemental_groups: Optional['outputs.SupplementalGroupsStrategyOptionsPatch'] = None,
                 volumes: Optional[Sequence[_builtins.str]] = None):
        """
        PodSecurityPolicySpec defines the policy enforced. Deprecated: use PodSecurityPolicySpec from policy API Group instead.
        :param _builtins.bool allow_privilege_escalation: allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.
        :param Sequence['AllowedCSIDriverPatchArgs'] allowed_csi_drivers: AllowedCSIDrivers is a whitelist of inline CSI drivers that must be explicitly set to be embedded within a pod spec. An empty value indicates that any CSI driver can be used for inline ephemeral volumes.
        :param Sequence[_builtins.str] allowed_capabilities: allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
        :param Sequence['AllowedFlexVolumePatchArgs'] allowed_flex_volumes: allowedFlexVolumes is a whitelist of allowed Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the "volumes" field.
        :param Sequence['AllowedHostPathPatchArgs'] allowed_host_paths: allowedHostPaths is a white list of allowed host paths. Empty indicates that all host paths may be used.
        :param Sequence[_builtins.str] allowed_proc_mount_types: AllowedProcMountTypes is a whitelist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
        :param Sequence[_builtins.str] allowed_unsafe_sysctls: allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to whitelist all allowed unsafe sysctls explicitly to avoid rejection.
               
               Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
        :param Sequence[_builtins.str] default_add_capabilities: defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
        :param _builtins.bool default_allow_privilege_escalation: defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
        :param Sequence[_builtins.str] forbidden_sysctls: forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.
               
               Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
        :param 'FSGroupStrategyOptionsPatchArgs' fs_group: fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.
        :param _builtins.bool host_ipc: hostIPC determines if the policy allows the use of HostIPC in the pod spec.
        :param _builtins.bool host_network: hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
        :param _builtins.bool host_pid: hostPID determines if the policy allows the use of HostPID in the pod spec.
        :param Sequence['HostPortRangePatchArgs'] host_ports: hostPorts determines which host port ranges are allowed to be exposed.
        :param _builtins.bool privileged: privileged determines if a pod can request to be run as privileged.
        :param _builtins.bool read_only_root_filesystem: readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
        :param Sequence[_builtins.str] required_drop_capabilities: requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.
        :param 'RunAsGroupStrategyOptionsPatchArgs' run_as_group: RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set. If this field is omitted, the pod's RunAsGroup can take any value. This field requires the RunAsGroup feature gate to be enabled.
        :param 'RunAsUserStrategyOptionsPatchArgs' run_as_user: runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.
        :param 'RuntimeClassStrategyOptionsPatchArgs' runtime_class: runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod. If this field is omitted, the pod's runtimeClassName field is unrestricted. Enforcement of this field depends on the RuntimeClass feature gate being enabled.
        :param 'SELinuxStrategyOptionsPatchArgs' se_linux: seLinux is the strategy that will dictate the allowable labels that may be set.
        :param 'SupplementalGroupsStrategyOptionsPatchArgs' supplemental_groups: supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.
        :param Sequence[_builtins.str] volumes: volumes is a white list of allowed volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
        """
        if allow_privilege_escalation is not None:
            pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        if allowed_csi_drivers is not None:
            pulumi.set(__self__, "allowed_csi_drivers", allowed_csi_drivers)
        if allowed_capabilities is not None:
            pulumi.set(__self__, "allowed_capabilities", allowed_capabilities)
        if allowed_flex_volumes is not None:
            pulumi.set(__self__, "allowed_flex_volumes", allowed_flex_volumes)
        if allowed_host_paths is not None:
            pulumi.set(__self__, "allowed_host_paths", allowed_host_paths)
        if allowed_proc_mount_types is not None:
            pulumi.set(__self__, "allowed_proc_mount_types", allowed_proc_mount_types)
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if default_add_capabilities is not None:
            pulumi.set(__self__, "default_add_capabilities", default_add_capabilities)
        if default_allow_privilege_escalation is not None:
            pulumi.set(__self__, "default_allow_privilege_escalation", default_allow_privilege_escalation)
        if forbidden_sysctls is not None:
            pulumi.set(__self__, "forbidden_sysctls", forbidden_sysctls)
        if fs_group is not None:
            pulumi.set(__self__, "fs_group", fs_group)
        if host_ipc is not None:
            pulumi.set(__self__, "host_ipc", host_ipc)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if host_pid is not None:
            pulumi.set(__self__, "host_pid", host_pid)
        if host_ports is not None:
            pulumi.set(__self__, "host_ports", host_ports)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_filesystem is not None:
            pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        if required_drop_capabilities is not None:
            pulumi.set(__self__, "required_drop_capabilities", required_drop_capabilities)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if runtime_class is not None:
            pulumi.set(__self__, "runtime_class", runtime_class)
        if se_linux is not None:
            pulumi.set(__self__, "se_linux", se_linux)
        if supplemental_groups is not None:
            pulumi.set(__self__, "supplemental_groups", supplemental_groups)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> Optional[_builtins.bool]:
        """
        allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true.
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @_builtins.property
    @pulumi.getter(name="allowedCSIDrivers")
    def allowed_csi_drivers(self) -> Optional[Sequence['outputs.AllowedCSIDriverPatch']]:
        """
        AllowedCSIDrivers is a whitelist of inline CSI drivers that must be explicitly set to be embedded within a pod spec. An empty value indicates that any CSI driver can be used for inline ephemeral volumes.
        """
        return pulumi.get(self, "allowed_csi_drivers")

    @_builtins.property
    @pulumi.getter(name="allowedCapabilities")
    def allowed_capabilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities.
        """
        return pulumi.get(self, "allowed_capabilities")

    @_builtins.property
    @pulumi.getter(name="allowedFlexVolumes")
    def allowed_flex_volumes(self) -> Optional[Sequence['outputs.AllowedFlexVolumePatch']]:
        """
        allowedFlexVolumes is a whitelist of allowed Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the "volumes" field.
        """
        return pulumi.get(self, "allowed_flex_volumes")

    @_builtins.property
    @pulumi.getter(name="allowedHostPaths")
    def allowed_host_paths(self) -> Optional[Sequence['outputs.AllowedHostPathPatch']]:
        """
        allowedHostPaths is a white list of allowed host paths. Empty indicates that all host paths may be used.
        """
        return pulumi.get(self, "allowed_host_paths")

    @_builtins.property
    @pulumi.getter(name="allowedProcMountTypes")
    def allowed_proc_mount_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        AllowedProcMountTypes is a whitelist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled.
        """
        return pulumi.get(self, "allowed_proc_mount_types")

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[Sequence[_builtins.str]]:
        """
        allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to whitelist all allowed unsafe sysctls explicitly to avoid rejection.

        Examples: e.g. "foo/*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc.
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @_builtins.property
    @pulumi.getter(name="defaultAddCapabilities")
    def default_add_capabilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list.
        """
        return pulumi.get(self, "default_add_capabilities")

    @_builtins.property
    @pulumi.getter(name="defaultAllowPrivilegeEscalation")
    def default_allow_privilege_escalation(self) -> Optional[_builtins.bool]:
        """
        defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process.
        """
        return pulumi.get(self, "default_allow_privilege_escalation")

    @_builtins.property
    @pulumi.getter(name="forbiddenSysctls")
    def forbidden_sysctls(self) -> Optional[Sequence[_builtins.str]]:
        """
        forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.

        Examples: e.g. "foo/*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc.
        """
        return pulumi.get(self, "forbidden_sysctls")

    @_builtins.property
    @pulumi.getter(name="fsGroup")
    def fs_group(self) -> Optional['outputs.FSGroupStrategyOptionsPatch']:
        """
        fsGroup is the strategy that will dictate what fs group is used by the SecurityContext.
        """
        return pulumi.get(self, "fs_group")

    @_builtins.property
    @pulumi.getter(name="hostIPC")
    def host_ipc(self) -> Optional[_builtins.bool]:
        """
        hostIPC determines if the policy allows the use of HostIPC in the pod spec.
        """
        return pulumi.get(self, "host_ipc")

    @_builtins.property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[_builtins.bool]:
        """
        hostNetwork determines if the policy allows the use of HostNetwork in the pod spec.
        """
        return pulumi.get(self, "host_network")

    @_builtins.property
    @pulumi.getter(name="hostPID")
    def host_pid(self) -> Optional[_builtins.bool]:
        """
        hostPID determines if the policy allows the use of HostPID in the pod spec.
        """
        return pulumi.get(self, "host_pid")

    @_builtins.property
    @pulumi.getter(name="hostPorts")
    def host_ports(self) -> Optional[Sequence['outputs.HostPortRangePatch']]:
        """
        hostPorts determines which host port ranges are allowed to be exposed.
        """
        return pulumi.get(self, "host_ports")

    @_builtins.property
    @pulumi.getter
    def privileged(self) -> Optional[_builtins.bool]:
        """
        privileged determines if a pod can request to be run as privileged.
        """
        return pulumi.get(self, "privileged")

    @_builtins.property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> Optional[_builtins.bool]:
        """
        readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to.
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @_builtins.property
    @pulumi.getter(name="requiredDropCapabilities")
    def required_drop_capabilities(self) -> Optional[Sequence[_builtins.str]]:
        """
        requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added.
        """
        return pulumi.get(self, "required_drop_capabilities")

    @_builtins.property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional['outputs.RunAsGroupStrategyOptionsPatch']:
        """
        RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set. If this field is omitted, the pod's RunAsGroup can take any value. This field requires the RunAsGroup feature gate to be enabled.
        """
        return pulumi.get(self, "run_as_group")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional['outputs.RunAsUserStrategyOptionsPatch']:
        """
        runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="runtimeClass")
    def runtime_class(self) -> Optional['outputs.RuntimeClassStrategyOptionsPatch']:
        """
        runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod. If this field is omitted, the pod's runtimeClassName field is unrestricted. Enforcement of this field depends on the RuntimeClass feature gate being enabled.
        """
        return pulumi.get(self, "runtime_class")

    @_builtins.property
    @pulumi.getter(name="seLinux")
    def se_linux(self) -> Optional['outputs.SELinuxStrategyOptionsPatch']:
        """
        seLinux is the strategy that will dictate the allowable labels that may be set.
        """
        return pulumi.get(self, "se_linux")

    @_builtins.property
    @pulumi.getter(name="supplementalGroups")
    def supplemental_groups(self) -> Optional['outputs.SupplementalGroupsStrategyOptionsPatch']:
        """
        supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext.
        """
        return pulumi.get(self, "supplemental_groups")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence[_builtins.str]]:
        """
        volumes is a white list of allowed volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class ReplicaSet(dict):
    """
    ReplicaSet ensures that a specified number of pod replicas are running at any given time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ReplicaSetSpec'] = None,
                 status: Optional['outputs.ReplicaSetStatus'] = None):
        """
        ReplicaSet ensures that a specified number of pod replicas are running at any given time.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'ReplicaSetSpecArgs' spec: Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'ReplicaSetStatusArgs' status: Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'extensions/v1beta1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ReplicaSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ReplicaSetSpec']:
        """
        Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.ReplicaSetStatus']:
        """
        Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ReplicaSetCondition(dict):
    """
    ReplicaSetCondition describes the state of a replica set at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of replica set condition.
        :param _builtins.str last_transition_time: The last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of replica set condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ReplicaSetConditionPatch(dict):
    """
    ReplicaSetCondition describes the state of a replica set at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        :param _builtins.str last_transition_time: The last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of replica set condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of replica set condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicaSetSpec(dict):
    """
    ReplicaSetSpec is the specification of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpec'] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.int replicas: Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        :param '_meta.v1.LabelSelectorArgs' selector: Selector is a label query over pods that should match the replica count. If the selector is empty, it is defaulted to the labels present on the pod template. Label keys and values that must match in order to be controlled by this replica set. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecArgs' template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        Selector is a label query over pods that should match the replica count. If the selector is empty, it is defaulted to the labels present on the pod template. Label keys and values that must match in order to be controlled by this replica set. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpec']:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ReplicaSetSpecPatch(dict):
    """
    ReplicaSetSpec is the specification of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.int replicas: Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        :param '_meta.v1.LabelSelectorPatchArgs' selector: Selector is a label query over pods that should match the replica count. If the selector is empty, it is defaulted to the labels present on the pod template. Label keys and values that must match in order to be controlled by this replica set. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecPatchArgs' template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Selector is a label query over pods that should match the replica count. If the selector is empty, it is defaulted to the labels present on the pod template. Label keys and values that must match in order to be controlled by this replica set. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ReplicaSetStatus(dict):
    """
    ReplicaSetStatus represents the current status of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "fullyLabeledReplicas":
            suggest = "fully_labeled_replicas"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replicas: _builtins.int,
                 available_replicas: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.ReplicaSetCondition']] = None,
                 fully_labeled_replicas: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        :param _builtins.int replicas: Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        :param _builtins.int available_replicas: The number of available replicas (ready for at least minReadySeconds) for this replica set.
        :param Sequence['ReplicaSetConditionArgs'] conditions: Represents the latest available observations of a replica set's current state.
        :param _builtins.int fully_labeled_replicas: The number of pods that have labels matching the labels of the pod template of the replicaset.
        :param _builtins.int observed_generation: ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        :param _builtins.int ready_replicas: The number of ready replicas for this replica set.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> _builtins.int:
        """
        Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        The number of available replicas (ready for at least minReadySeconds) for this replica set.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ReplicaSetCondition']]:
        """
        Represents the latest available observations of a replica set's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[_builtins.int]:
        """
        The number of pods that have labels matching the labels of the pod template of the replicaset.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        The number of ready replicas for this replica set.
        """
        return pulumi.get(self, "ready_replicas")


@pulumi.output_type
class ReplicaSetStatusPatch(dict):
    """
    ReplicaSetStatus represents the current status of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "fullyLabeledReplicas":
            suggest = "fully_labeled_replicas"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.ReplicaSetConditionPatch']] = None,
                 fully_labeled_replicas: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        :param _builtins.int available_replicas: The number of available replicas (ready for at least minReadySeconds) for this replica set.
        :param Sequence['ReplicaSetConditionPatchArgs'] conditions: Represents the latest available observations of a replica set's current state.
        :param _builtins.int fully_labeled_replicas: The number of pods that have labels matching the labels of the pod template of the replicaset.
        :param _builtins.int observed_generation: ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        :param _builtins.int ready_replicas: The number of ready replicas for this replica set.
        :param _builtins.int replicas: Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        The number of available replicas (ready for at least minReadySeconds) for this replica set.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ReplicaSetConditionPatch']]:
        """
        Represents the latest available observations of a replica set's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[_builtins.int]:
        """
        The number of pods that have labels matching the labels of the pod template of the replicaset.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        The number of ready replicas for this replica set.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class RollbackConfig(dict):
    """
    DEPRECATED.
    """
    def __init__(__self__, *,
                 revision: Optional[_builtins.int] = None):
        """
        DEPRECATED.
        :param _builtins.int revision: The revision to rollback to. If set to 0, rollback to the last revision.
        """
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.int]:
        """
        The revision to rollback to. If set to 0, rollback to the last revision.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class RollbackConfigPatch(dict):
    """
    DEPRECATED.
    """
    def __init__(__self__, *,
                 revision: Optional[_builtins.int] = None):
        """
        DEPRECATED.
        :param _builtins.int revision: The revision to rollback to. If set to 0, rollback to the last revision.
        """
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.int]:
        """
        The revision to rollback to. If set to 0, rollback to the last revision.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class RollingUpdateDaemonSet(dict):
    """
    Spec to control the desired behavior of daemon set rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDaemonSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDaemonSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDaemonSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateDaemonSetPatch(dict):
    """
    Spec to control the desired behavior of daemon set rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDaemonSetPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDaemonSetPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDaemonSetPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0. Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateDeployment(dict):
    """
    Spec to control the desired behavior of rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param Union[_builtins.int, _builtins.str] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. By default, a value of 1 is used. Example: when this is set to 30%, the new RC can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. By default, a fixed value of 1 is used. Example: when this is set to 30%, the old RC can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. By default, a value of 1 is used. Example: when this is set to 30%, the new RC can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. By default, a fixed value of 1 is used. Example: when this is set to 30%, the old RC can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateDeploymentPatch(dict):
    """
    Spec to control the desired behavior of rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDeploymentPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDeploymentPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDeploymentPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param Union[_builtins.int, _builtins.str] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. By default, a value of 1 is used. Example: when this is set to 30%, the new RC can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. By default, a fixed value of 1 is used. Example: when this is set to 30%, the old RC can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. By default, a value of 1 is used. Example: when this is set to 30%, the new RC can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new RC can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. By default, a fixed value of 1 is used. Example: when this is set to 30%, the old RC can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old RC can be scaled down further, followed by scaling up the new RC, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RunAsGroupStrategyOptions(dict):
    """
    RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsGroupStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 rule: _builtins.str,
                 ranges: Optional[Sequence['outputs.IDRange']] = None):
        """
        RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsGroupStrategyOptions from policy API Group instead.
        :param _builtins.str rule: rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
        :param Sequence['IDRangeArgs'] ranges: ranges are the allowed ranges of gids that may be used. If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs.
        """
        pulumi.set(__self__, "rule", rule)
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> _builtins.str:
        """
        rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRange']]:
        """
        ranges are the allowed ranges of gids that may be used. If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")


@pulumi.output_type
class RunAsGroupStrategyOptionsPatch(dict):
    """
    RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsGroupStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 ranges: Optional[Sequence['outputs.IDRangePatch']] = None,
                 rule: Optional[_builtins.str] = None):
        """
        RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsGroupStrategyOptions from policy API Group instead.
        :param Sequence['IDRangePatchArgs'] ranges: ranges are the allowed ranges of gids that may be used. If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs.
        :param _builtins.str rule: rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
        """
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRangePatch']]:
        """
        ranges are the allowed ranges of gids that may be used. If you would like to force a single gid then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate the allowable RunAsGroup values that may be set.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class RunAsUserStrategyOptions(dict):
    """
    RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsUserStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 rule: _builtins.str,
                 ranges: Optional[Sequence['outputs.IDRange']] = None):
        """
        RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsUserStrategyOptions from policy API Group instead.
        :param _builtins.str rule: rule is the strategy that will dictate the allowable RunAsUser values that may be set.
        :param Sequence['IDRangeArgs'] ranges: ranges are the allowed ranges of uids that may be used. If you would like to force a single uid then supply a single range with the same start and end. Required for MustRunAs.
        """
        pulumi.set(__self__, "rule", rule)
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> _builtins.str:
        """
        rule is the strategy that will dictate the allowable RunAsUser values that may be set.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRange']]:
        """
        ranges are the allowed ranges of uids that may be used. If you would like to force a single uid then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")


@pulumi.output_type
class RunAsUserStrategyOptionsPatch(dict):
    """
    RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsUserStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 ranges: Optional[Sequence['outputs.IDRangePatch']] = None,
                 rule: Optional[_builtins.str] = None):
        """
        RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsUserStrategyOptions from policy API Group instead.
        :param Sequence['IDRangePatchArgs'] ranges: ranges are the allowed ranges of uids that may be used. If you would like to force a single uid then supply a single range with the same start and end. Required for MustRunAs.
        :param _builtins.str rule: rule is the strategy that will dictate the allowable RunAsUser values that may be set.
        """
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRangePatch']]:
        """
        ranges are the allowed ranges of uids that may be used. If you would like to force a single uid then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate the allowable RunAsUser values that may be set.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class RuntimeClassStrategyOptions(dict):
    """
    RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRuntimeClassNames":
            suggest = "allowed_runtime_class_names"
        elif key == "defaultRuntimeClassName":
            suggest = "default_runtime_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeClassStrategyOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeClassStrategyOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeClassStrategyOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_runtime_class_names: Sequence[_builtins.str],
                 default_runtime_class_name: Optional[_builtins.str] = None):
        """
        RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.
        :param Sequence[_builtins.str] allowed_runtime_class_names: allowedRuntimeClassNames is a whitelist of RuntimeClass names that may be specified on a pod. A value of "*" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset.
        :param _builtins.str default_runtime_class_name: defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod.
        """
        pulumi.set(__self__, "allowed_runtime_class_names", allowed_runtime_class_names)
        if default_runtime_class_name is not None:
            pulumi.set(__self__, "default_runtime_class_name", default_runtime_class_name)

    @_builtins.property
    @pulumi.getter(name="allowedRuntimeClassNames")
    def allowed_runtime_class_names(self) -> Sequence[_builtins.str]:
        """
        allowedRuntimeClassNames is a whitelist of RuntimeClass names that may be specified on a pod. A value of "*" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset.
        """
        return pulumi.get(self, "allowed_runtime_class_names")

    @_builtins.property
    @pulumi.getter(name="defaultRuntimeClassName")
    def default_runtime_class_name(self) -> Optional[_builtins.str]:
        """
        defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod.
        """
        return pulumi.get(self, "default_runtime_class_name")


@pulumi.output_type
class RuntimeClassStrategyOptionsPatch(dict):
    """
    RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRuntimeClassNames":
            suggest = "allowed_runtime_class_names"
        elif key == "defaultRuntimeClassName":
            suggest = "default_runtime_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeClassStrategyOptionsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeClassStrategyOptionsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeClassStrategyOptionsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_runtime_class_names: Optional[Sequence[_builtins.str]] = None,
                 default_runtime_class_name: Optional[_builtins.str] = None):
        """
        RuntimeClassStrategyOptions define the strategy that will dictate the allowable RuntimeClasses for a pod.
        :param Sequence[_builtins.str] allowed_runtime_class_names: allowedRuntimeClassNames is a whitelist of RuntimeClass names that may be specified on a pod. A value of "*" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset.
        :param _builtins.str default_runtime_class_name: defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod.
        """
        if allowed_runtime_class_names is not None:
            pulumi.set(__self__, "allowed_runtime_class_names", allowed_runtime_class_names)
        if default_runtime_class_name is not None:
            pulumi.set(__self__, "default_runtime_class_name", default_runtime_class_name)

    @_builtins.property
    @pulumi.getter(name="allowedRuntimeClassNames")
    def allowed_runtime_class_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        allowedRuntimeClassNames is a whitelist of RuntimeClass names that may be specified on a pod. A value of "*" means that any RuntimeClass name is allowed, and must be the only item in the list. An empty list requires the RuntimeClassName field to be unset.
        """
        return pulumi.get(self, "allowed_runtime_class_names")

    @_builtins.property
    @pulumi.getter(name="defaultRuntimeClassName")
    def default_runtime_class_name(self) -> Optional[_builtins.str]:
        """
        defaultRuntimeClassName is the default RuntimeClassName to set on the pod. The default MUST be allowed by the allowedRuntimeClassNames list. A value of nil does not mutate the Pod.
        """
        return pulumi.get(self, "default_runtime_class_name")


@pulumi.output_type
class SELinuxStrategyOptions(dict):
    """
    SELinuxStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use SELinuxStrategyOptions from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "seLinuxOptions":
            suggest = "se_linux_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SELinuxStrategyOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SELinuxStrategyOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SELinuxStrategyOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule: _builtins.str,
                 se_linux_options: Optional['_core.v1.outputs.SELinuxOptions'] = None):
        """
        SELinuxStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use SELinuxStrategyOptions from policy API Group instead.
        :param _builtins.str rule: rule is the strategy that will dictate the allowable labels that may be set.
        :param '_core.v1.SELinuxOptionsArgs' se_linux_options: seLinuxOptions required to run as; required for MustRunAs More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        pulumi.set(__self__, "rule", rule)
        if se_linux_options is not None:
            pulumi.set(__self__, "se_linux_options", se_linux_options)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> _builtins.str:
        """
        rule is the strategy that will dictate the allowable labels that may be set.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> Optional['_core.v1.outputs.SELinuxOptions']:
        """
        seLinuxOptions required to run as; required for MustRunAs More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        return pulumi.get(self, "se_linux_options")


@pulumi.output_type
class SELinuxStrategyOptionsPatch(dict):
    """
    SELinuxStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use SELinuxStrategyOptions from policy API Group instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "seLinuxOptions":
            suggest = "se_linux_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SELinuxStrategyOptionsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SELinuxStrategyOptionsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SELinuxStrategyOptionsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule: Optional[_builtins.str] = None,
                 se_linux_options: Optional['_core.v1.outputs.SELinuxOptionsPatch'] = None):
        """
        SELinuxStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use SELinuxStrategyOptions from policy API Group instead.
        :param _builtins.str rule: rule is the strategy that will dictate the allowable labels that may be set.
        :param '_core.v1.SELinuxOptionsPatchArgs' se_linux_options: seLinuxOptions required to run as; required for MustRunAs More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if se_linux_options is not None:
            pulumi.set(__self__, "se_linux_options", se_linux_options)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate the allowable labels that may be set.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> Optional['_core.v1.outputs.SELinuxOptionsPatch']:
        """
        seLinuxOptions required to run as; required for MustRunAs More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        return pulumi.get(self, "se_linux_options")


@pulumi.output_type
class SupplementalGroupsStrategyOptions(dict):
    """
    SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use SupplementalGroupsStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 ranges: Optional[Sequence['outputs.IDRange']] = None,
                 rule: Optional[_builtins.str] = None):
        """
        SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use SupplementalGroupsStrategyOptions from policy API Group instead.
        :param Sequence['IDRangeArgs'] ranges: ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs.
        :param _builtins.str rule: rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
        """
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRange']]:
        """
        ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class SupplementalGroupsStrategyOptionsPatch(dict):
    """
    SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use SupplementalGroupsStrategyOptions from policy API Group instead.
    """
    def __init__(__self__, *,
                 ranges: Optional[Sequence['outputs.IDRangePatch']] = None,
                 rule: Optional[_builtins.str] = None):
        """
        SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use SupplementalGroupsStrategyOptions from policy API Group instead.
        :param Sequence['IDRangePatchArgs'] ranges: ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs.
        :param _builtins.str rule: rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
        """
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter
    def ranges(self) -> Optional[Sequence['outputs.IDRangePatch']]:
        """
        ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs.
        """
        return pulumi.get(self, "ranges")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.
        """
        return pulumi.get(self, "rule")


