# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities

__all__ = [
    'ReleaseStatus',
    'RepositoryOpts',
]

@pulumi.output_type
class ReleaseStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appVersion":
            suggest = "app_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReleaseStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReleaseStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReleaseStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 app_version: Optional[_builtins.str] = None,
                 chart: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 revision: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str status: Status of the release.
        :param _builtins.str app_version: The version number of the application being deployed.
        :param _builtins.str chart: The name of the chart.
        :param _builtins.str name: Name is the name of the release.
        :param _builtins.str namespace: Namespace is the kubernetes namespace of the release.
        :param _builtins.int revision: Version is an int32 which represents the version of the release.
        :param _builtins.str version: A SemVer 2 conformant version string of the chart.
        """
        pulumi.set(__self__, "status", status)
        if app_version is not None:
            pulumi.set(__self__, "app_version", app_version)
        if chart is not None:
            pulumi.set(__self__, "chart", chart)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the release.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> Optional[_builtins.str]:
        """
        The version number of the application being deployed.
        """
        return pulumi.get(self, "app_version")

    @_builtins.property
    @pulumi.getter
    def chart(self) -> Optional[_builtins.str]:
        """
        The name of the chart.
        """
        return pulumi.get(self, "chart")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name is the name of the release.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        Namespace is the kubernetes namespace of the release.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.int]:
        """
        Version is an int32 which represents the version of the release.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        A SemVer 2 conformant version string of the chart.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RepositoryOpts(dict):
    """
    Specification defining the Helm chart repository to use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caFile":
            suggest = "ca_file"
        elif key == "certFile":
            suggest = "cert_file"
        elif key == "keyFile":
            suggest = "key_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryOpts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryOpts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryOpts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_file: Optional[_builtins.str] = None,
                 cert_file: Optional[_builtins.str] = None,
                 key_file: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 repo: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        Specification defining the Helm chart repository to use.
        :param _builtins.str ca_file: The Repository's CA File
        :param _builtins.str cert_file: The repository's cert file
        :param _builtins.str key_file: The repository's cert key file
        :param _builtins.str password: Password for HTTP basic authentication
        :param _builtins.str repo: Repository where to locate the requested chart. If it's a URL the chart is installed without installing the repository.
        :param _builtins.str username: Username for HTTP basic authentication
        """
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[_builtins.str]:
        """
        The Repository's CA File
        """
        return pulumi.get(self, "ca_file")

    @_builtins.property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[_builtins.str]:
        """
        The repository's cert file
        """
        return pulumi.get(self, "cert_file")

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[_builtins.str]:
        """
        The repository's cert key file
        """
        return pulumi.get(self, "key_file")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for HTTP basic authentication
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def repo(self) -> Optional[_builtins.str]:
        """
        Repository where to locate the requested chart. If it's a URL the chart is installed without installing the repository.
        """
        return pulumi.get(self, "repo")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username for HTTP basic authentication
        """
        return pulumi.get(self, "username")


