from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class MagnetGrabRequest:
    """
    ROS message: drone_srv_msgs/MagnetGrabRequest
    Generated by hakoniwa-ros2pdu.
    """

    drone_name: str
    grab_on: bool
    timeout_sec: float

    def __init__(self):
        self.drone_name = ""
        self.grab_on = False
        self.timeout_sec = 0.0

    def __str__(self):
        return f"MagnetGrabRequest(" + ", ".join([
            f"drone_name={self.drone_name}"
            f"grab_on={self.grab_on}"
            f"timeout_sec={self.timeout_sec}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'drone_name'
        field_val = self.drone_name
        if isinstance(field_val, bytearray):
            d['drone_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['drone_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['drone_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['drone_name'] = field_val
        # handle field 'grab_on'
        field_val = self.grab_on
        if isinstance(field_val, bytearray):
            d['grab_on'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['grab_on'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['grab_on'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['grab_on'] = field_val
        # handle field 'timeout_sec'
        field_val = self.timeout_sec
        if isinstance(field_val, bytearray):
            d['timeout_sec'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['timeout_sec'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['timeout_sec'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['timeout_sec'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'drone_name'
        if 'drone_name' in d:
            field_type = cls.__annotations__.get('drone_name')
            value = d['drone_name']
            
            if field_type is bytearray:
                obj.drone_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.drone_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.drone_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.drone_name = field_type.from_dict(value)
            else:
                obj.drone_name = value
        # handle field 'grab_on'
        if 'grab_on' in d:
            field_type = cls.__annotations__.get('grab_on')
            value = d['grab_on']
            
            if field_type is bytearray:
                obj.grab_on = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.grab_on = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.grab_on = value
            elif hasattr(field_type, 'from_dict'):
                obj.grab_on = field_type.from_dict(value)
            else:
                obj.grab_on = value
        # handle field 'timeout_sec'
        if 'timeout_sec' in d:
            field_type = cls.__annotations__.get('timeout_sec')
            value = d['timeout_sec']
            
            if field_type is bytearray:
                obj.timeout_sec = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.timeout_sec = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.timeout_sec = value
            elif hasattr(field_type, 'from_dict'):
                obj.timeout_sec = field_type.from_dict(value)
            else:
                obj.timeout_sec = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
