from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion


# class definition for the ROS message
class Pose:
    """
    ROS message: geometry_msgs/Pose
    Generated by hakoniwa-ros2pdu.
    """

    position: Point
    orientation: Quaternion

    def __init__(self):
        self.position = Point()
        self.orientation = Quaternion()

    def __str__(self):
        return f"Pose(" + ", ".join([
            f"position={self.position}"
            f"orientation={self.orientation}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'position'
        field_val = self.position
        if isinstance(field_val, bytearray):
            d['position'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['position'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['position'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['position'] = field_val
        # handle field 'orientation'
        field_val = self.orientation
        if isinstance(field_val, bytearray):
            d['orientation'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['orientation'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['orientation'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['orientation'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'position'
        if 'position' in d:
            field_type = cls.__annotations__.get('position')
            value = d['position']
            
            if field_type is bytearray:
                obj.position = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.position = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.position = value
            elif hasattr(field_type, 'from_dict'):
                obj.position = field_type.from_dict(value)
            else:
                obj.position = value
        # handle field 'orientation'
        if 'orientation' in d:
            field_type = cls.__annotations__.get('orientation')
            value = d['orientation']
            
            if field_type is bytearray:
                obj.orientation = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.orientation = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.orientation = value
            elif hasattr(field_type, 'from_dict'):
                obj.orientation = field_type.from_dict(value)
            else:
                obj.orientation = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
