from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class Transform:
    """
    ROS message: geometry_msgs/Transform
    Generated by hakoniwa-ros2pdu.
    """

    translation: Vector3
    rotation: Quaternion

    def __init__(self):
        self.translation = Vector3()
        self.rotation = Quaternion()

    def __str__(self):
        return f"Transform(" + ", ".join([
            f"translation={self.translation}"
            f"rotation={self.rotation}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'translation'
        field_val = self.translation
        if isinstance(field_val, bytearray):
            d['translation'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['translation'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['translation'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['translation'] = field_val
        # handle field 'rotation'
        field_val = self.rotation
        if isinstance(field_val, bytearray):
            d['rotation'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['rotation'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['rotation'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['rotation'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'translation'
        if 'translation' in d:
            field_type = cls.__annotations__.get('translation')
            value = d['translation']
            
            if field_type is bytearray:
                obj.translation = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.translation = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.translation = value
            elif hasattr(field_type, 'from_dict'):
                obj.translation = field_type.from_dict(value)
            else:
                obj.translation = value
        # handle field 'rotation'
        if 'rotation' in d:
            field_type = cls.__annotations__.get('rotation')
            value = d['rotation']
            
            if field_type is bytearray:
                obj.rotation = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.rotation = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.rotation = value
            elif hasattr(field_type, 'from_dict'):
                obj.rotation = field_type.from_dict(value)
            else:
                obj.rotation = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
