from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class DisturbanceBoundary:
    """
    ROS message: hako_msgs/DisturbanceBoundary
    Generated by hakoniwa-ros2pdu.
    """

    boundary_point: Point
    boundary_normal: Vector3

    def __init__(self):
        self.boundary_point = Point()
        self.boundary_normal = Vector3()

    def __str__(self):
        return f"DisturbanceBoundary(" + ", ".join([
            f"boundary_point={self.boundary_point}"
            f"boundary_normal={self.boundary_normal}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'boundary_point'
        field_val = self.boundary_point
        if isinstance(field_val, bytearray):
            d['boundary_point'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['boundary_point'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['boundary_point'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['boundary_point'] = field_val
        # handle field 'boundary_normal'
        field_val = self.boundary_normal
        if isinstance(field_val, bytearray):
            d['boundary_normal'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['boundary_normal'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['boundary_normal'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['boundary_normal'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'boundary_point'
        if 'boundary_point' in d:
            field_type = cls.__annotations__.get('boundary_point')
            value = d['boundary_point']
            
            if field_type is bytearray:
                obj.boundary_point = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.boundary_point = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.boundary_point = value
            elif hasattr(field_type, 'from_dict'):
                obj.boundary_point = field_type.from_dict(value)
            else:
                obj.boundary_point = value
        # handle field 'boundary_normal'
        if 'boundary_normal' in d:
            field_type = cls.__annotations__.get('boundary_normal')
            value = d['boundary_normal']
            
            if field_type is bytearray:
                obj.boundary_normal = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.boundary_normal = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.boundary_normal = value
            elif hasattr(field_type, 'from_dict'):
                obj.boundary_normal = field_type.from_dict(value)
            else:
                obj.boundary_normal = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
